"use strict";
/*
Copyright 2019 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.IrcUser = void 0;
const matrix_appservice_bridge_1 = require("matrix-appservice-bridge");
class IrcUser extends matrix_appservice_bridge_1.RemoteUser {
    server;
    nick;
    isVirtual;
    password;
    /**
     * Construct a new IRC user.
     * @constructor
     * @param {IrcServer} server : The IRC server the user is on.
     * @param {string} nick : The nick for this user.
     * @param {boolean} isVirtual : True if the user is not a real IRC user.
     * @param {string} password : The password to give to NickServ.
     * @param {string} username : The username of the client (for ident)
     */
    constructor(server, nick, isVirtual, password = null, username = null) {
        super(server.domain + "__@__" + nick, {
            domain: server.domain,
            nick: nick,
            isVirtual: Boolean(isVirtual),
            password: password || null,
            username: username || null
        });
        this.server = server;
        this.nick = nick;
        this.isVirtual = isVirtual;
        this.password = password;
    }
    getUsername() {
        return this.get("username");
    }
    toString() {
        return `${this.nick} (${this.getUsername()}@${this.server ? this.server.domain : "-"})`;
    }
}
exports.IrcUser = IrcUser;
//# sourceMappingURL=IrcUser.js.map