/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.NoContentException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.ReaderInterceptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.jaxrs.ReaderInterceptorContextImpl;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class RequestDeserializeHandler
implements ServerRestHandler {
    private static final Logger log = Logger.getLogger(RequestDeserializeHandler.class);
    private final Class<?> type;
    private final Type genericType;
    private final List<MediaType> acceptableMediaTypes;
    private final ServerSerialisers serialisers;
    private final int parameterIndex;

    public RequestDeserializeHandler(Class<?> type, Type genericType, List<MediaType> acceptableMediaTypes, ServerSerialisers serialisers, int parameterIndex) {
        this.type = type;
        this.genericType = genericType;
        this.acceptableMediaTypes = acceptableMediaTypes;
        this.serialisers = serialisers;
        this.parameterIndex = parameterIndex;
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        List readers;
        requestContext.requireCDIRequestScope();
        MediaType effectiveRequestType = null;
        Object requestType = requestContext.getHeader("Content-Type", true);
        if (requestType != null) {
            try {
                effectiveRequestType = MediaTypeHelper.valueOf((String)((String)requestType));
            }
            catch (Exception e) {
                log.debugv("Incorrect media type", (Object)e);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            }
            if (MediaTypeHelper.getFirstMatch(this.acceptableMediaTypes, Collections.singletonList(effectiveRequestType)) == null) {
                throw new NotSupportedException("The content-type header value did not match the value in @Consumes");
            }
        } else {
            effectiveRequestType = !this.acceptableMediaTypes.isEmpty() ? this.acceptableMediaTypes.get(0) : MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        if ((readers = this.serialisers.findReaders(null, this.type, effectiveRequestType, RuntimeType.SERVER)).isEmpty()) {
            log.debugv("No matching MessageBodyReader found for type {0} and media type {1}", this.type, (Object)effectiveRequestType);
            throw new NotSupportedException();
        }
        for (MessageBodyReader reader : readers) {
            Object result;
            if (!this.isReadable(reader, requestContext, effectiveRequestType)) continue;
            ReaderInterceptor[] interceptors = requestContext.getReaderInterceptors();
            try {
                try {
                    result = interceptors == null ? this.readFrom(reader, requestContext, effectiveRequestType) : new ReaderInterceptorContextImpl(requestContext, this.getAnnotations(requestContext), this.type, this.genericType, effectiveRequestType, reader, requestContext.getInputStream(), interceptors, this.serialisers).proceed();
                }
                catch (NoContentException e) {
                    throw new BadRequestException((Throwable)e);
                }
            }
            catch (Exception e) {
                log.debug((Object)"Error occurred during deserialization of input", (Throwable)e);
                requestContext.handleException(e, true);
                requestContext.resume();
                return;
            }
            requestContext.setRequestEntity(result);
            requestContext.resume();
            return;
        }
        log.debugv("No matching MessageBodyReader found for type {0} and media type {1}", this.type, (Object)effectiveRequestType);
        throw new NotSupportedException("No supported MessageBodyReader found");
    }

    private boolean isReadable(MessageBodyReader<?> reader, ResteasyReactiveRequestContext requestContext, MediaType requestType) {
        if (reader instanceof ServerMessageBodyReader) {
            return ((ServerMessageBodyReader)reader).isReadable(this.type, this.genericType, requestContext.getTarget().getLazyMethod(), requestType);
        }
        return reader.isReadable(this.type, this.genericType, this.getAnnotations(requestContext), requestType);
    }

    public Object readFrom(MessageBodyReader<?> reader, ResteasyReactiveRequestContext requestContext, MediaType requestType) throws IOException {
        requestContext.requireCDIRequestScope();
        if (reader instanceof ServerMessageBodyReader) {
            return ((ServerMessageBodyReader)reader).readFrom(this.type, this.genericType, requestType, requestContext);
        }
        return reader.readFrom(this.type, this.genericType, this.getAnnotations(requestContext), requestType, requestContext.getHttpHeaders().getRequestHeaders(), requestContext.getInputStream());
    }

    private Annotation[] getAnnotations(ResteasyReactiveRequestContext requestContext) {
        return requestContext.getTarget().getLazyMethod().getParameterAnnotations(this.parameterIndex);
    }
}

