/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathList;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MutableJarApplicationModel
implements Serializable {
    private static final long serialVersionUID = 2046278141713688084L;
    private final String baseName;
    private final SerializedDep appArtifact;
    private List<SerializedDep> dependencies;
    private Set<ArtifactKey> localProjectArtifacts;
    private Map<ArtifactKey, Set<String>> excludedResources;
    private Collection<ExtensionCapabilities> capabilitiesContracts;
    private PlatformImports platformImports;
    private String userProvidersDirectory;

    public MutableJarApplicationModel(String baseName, Map<ArtifactKey, List<String>> paths, ApplicationModel appModel, String userProvidersDirectory, String appArchivePath) {
        this.baseName = baseName;
        this.userProvidersDirectory = userProvidersDirectory;
        this.appArtifact = new SerializedDep(appModel.getAppArtifact(), paths.getOrDefault(appModel.getAppArtifact().getKey(), List.of()), 0);
        this.appArtifact.paths = List.of(appArchivePath.replace('\\', '/'));
        this.localProjectArtifacts = new HashSet<ArtifactKey>(appModel.getReloadableWorkspaceDependencies());
        this.excludedResources = new HashMap<ArtifactKey, Set<String>>(appModel.getRemovedResources());
        this.dependencies = new ArrayList<SerializedDep>(appModel.getDependencies().size());
        for (ResolvedDependency i : appModel.getDependencies()) {
            List<String> pathList = paths.get(i.getKey());
            if (pathList != null && !pathList.isEmpty()) {
                this.dependencies.add(new SerializedDep(i, pathList, i.getFlags()));
                continue;
            }
            this.localProjectArtifacts.remove(i.getKey());
            this.excludedResources.remove(i.getKey());
        }
        this.capabilitiesContracts = new ArrayList<ExtensionCapabilities>(appModel.getExtensionCapabilities());
        this.platformImports = appModel.getPlatforms();
    }

    public String getUserProvidersDirectory() {
        return this.userProvidersDirectory;
    }

    public ApplicationModel getAppModel(Path root) {
        ApplicationModelBuilder model = new ApplicationModelBuilder();
        model.setAppArtifact(this.appArtifact.getDep(root));
        for (SerializedDep serializedDep : this.dependencies) {
            model.addDependency(serializedDep.getDep(root));
        }
        model.addReloadableWorkspaceModules(this.localProjectArtifacts);
        for (Map.Entry entry : this.excludedResources.entrySet()) {
            model.addRemovedResources((ArtifactKey)entry.getKey(), (Set)entry.getValue());
        }
        for (ExtensionCapabilities extensionCapabilities : this.capabilitiesContracts) {
            model.addExtensionCapabilities(extensionCapabilities);
        }
        model.setPlatformImports(this.platformImports);
        return model.build();
    }

    public String getBaseName() {
        return this.baseName;
    }

    private static class SerializedDep
    extends GACTV {
        private List<String> paths;
        private final int flags;

        public SerializedDep(ResolvedDependency dependency, List<String> paths, int flags) {
            super(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
            this.paths = paths.stream().map(s -> s.replace('\\', '/')).collect(Collectors.toList());
            this.flags = flags;
        }

        public ResolvedDependencyBuilder getDep(Path root) {
            PathList.Builder builder = PathList.builder();
            for (String i : this.paths) {
                builder.add(root.resolve(i));
            }
            return (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(this.getGroupId())).setArtifactId(this.getArtifactId())).setClassifier(this.getClassifier())).setType(this.getType())).setVersion(this.getVersion())).setResolvedPaths(builder.build()).setFlags(this.flags);
        }
    }
}

