/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;

public class TopicIds
implements Set<Uuid> {
    private final Set<String> topicNames;
    private final TopicResolver resolver;

    public TopicIds(Set<String> topicNames, TopicsImage image) {
        this.topicNames = Objects.requireNonNull(topicNames);
        this.resolver = new DefaultTopicResolver(image);
    }

    public TopicIds(Set<String> topicNames, TopicResolver resolver) {
        this.topicNames = Objects.requireNonNull(topicNames);
        this.resolver = Objects.requireNonNull(resolver);
    }

    @Override
    public int size() {
        return this.topicNames.size();
    }

    @Override
    public boolean isEmpty() {
        return this.topicNames.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Uuid) {
            Uuid topicId = (Uuid)o;
            String topicName = this.resolver.name(topicId);
            if (topicName == null) {
                return false;
            }
            return this.topicNames.contains(topicName);
        }
        return false;
    }

    @Override
    public Iterator<Uuid> iterator() {
        return new TopicIdIterator(this.topicNames.iterator(), this.resolver);
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Uuid o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Uuid> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicIds uuids = (TopicIds)o;
        if (!Objects.equals(this.topicNames, uuids.topicNames)) {
            return false;
        }
        return Objects.equals(this.resolver.image(), uuids.resolver.image());
    }

    @Override
    public int hashCode() {
        int result = this.topicNames.hashCode();
        result = 31 * result + this.resolver.image().hashCode();
        return result;
    }

    public String toString() {
        return "TopicIds(topicNames=" + String.valueOf(this.topicNames) + ", resolver=" + String.valueOf(this.resolver) + ")";
    }

    public static class DefaultTopicResolver
    implements TopicResolver {
        private final TopicsImage image;

        public DefaultTopicResolver(TopicsImage image) {
            this.image = Objects.requireNonNull(image);
        }

        @Override
        public final TopicsImage image() {
            return this.image;
        }

        @Override
        public String name(Uuid id) {
            TopicImage topic = this.image.getTopic(id);
            if (topic == null) {
                return null;
            }
            return topic.name();
        }

        @Override
        public Uuid id(String name) {
            TopicImage topic = this.image.getTopic(name);
            if (topic == null) {
                return null;
            }
            return topic.id();
        }

        @Override
        public void clear() {
        }

        public String toString() {
            return "DefaultTopicResolver(image=" + String.valueOf(this.image) + ")";
        }
    }

    public static interface TopicResolver {
        public TopicsImage image();

        public String name(Uuid var1);

        public Uuid id(String var1);

        public void clear();
    }

    private static class TopicIdIterator
    implements Iterator<Uuid> {
        final Iterator<String> iterator;
        final TopicResolver resolver;
        private Uuid next = null;

        private TopicIdIterator(Iterator<String> iterator, TopicResolver resolver) {
            this.iterator = Objects.requireNonNull(iterator);
            this.resolver = Objects.requireNonNull(resolver);
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            Uuid result = null;
            do {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                String next = this.iterator.next();
                Uuid topicId = this.resolver.id(next);
                if (topicId == null) continue;
                result = topicId;
            } while (result == null);
            this.next = result;
            return true;
        }

        @Override
        public Uuid next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Uuid result = this.next;
            this.next = null;
            return result;
        }
    }

    public static class CachedTopicResolver
    implements TopicResolver {
        private final TopicsImage image;
        private final Map<String, Uuid> topicIds = new HashMap<String, Uuid>();
        private final Map<Uuid, String> topicNames = new HashMap<Uuid, String>();

        public CachedTopicResolver(TopicsImage image) {
            this.image = Objects.requireNonNull(image);
        }

        @Override
        public final TopicsImage image() {
            return this.image;
        }

        @Override
        public String name(Uuid id) {
            return this.topicNames.computeIfAbsent(id, __ -> {
                TopicImage topic = this.image.getTopic(id);
                if (topic == null) {
                    return null;
                }
                return topic.name();
            });
        }

        @Override
        public Uuid id(String name) {
            return this.topicIds.computeIfAbsent(name, __ -> {
                TopicImage topic = this.image.getTopic(name);
                if (topic == null) {
                    return null;
                }
                return topic.id();
            });
        }

        @Override
        public void clear() {
            this.topicNames.clear();
            this.topicIds.clear();
        }

        public String toString() {
            return "CachedTopicResolver(image=" + String.valueOf(this.image) + ")";
        }
    }
}

