/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionWindowedDeserializer<T>
implements Deserializer<Windowed<T>> {
    public static final String WINDOWED_INNER_DESERIALIZER_CLASS = "windowed.inner.deserializer.class";
    private final Logger log = LoggerFactory.getLogger(SessionWindowedDeserializer.class);
    private Deserializer<T> inner;

    public SessionWindowedDeserializer() {
    }

    public SessionWindowedDeserializer(Deserializer<T> inner) {
        this.inner = inner;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        String windowedInnerClassSerdeConfig;
        String deserializerConfigKey = WINDOWED_INNER_DESERIALIZER_CLASS;
        String deserializerConfigValue = (String)configs.get(WINDOWED_INNER_DESERIALIZER_CLASS);
        if (deserializerConfigValue == null && (windowedInnerClassSerdeConfig = (String)configs.get("windowed.inner.class.serde")) != null) {
            deserializerConfigKey = "windowed.inner.class.serde";
            deserializerConfigValue = windowedInnerClassSerdeConfig;
            this.log.warn("Config {} is deprecated. Please use {} instead.", (Object)"windowed.inner.class.serde", (Object)WINDOWED_INNER_DESERIALIZER_CLASS);
        }
        Serde windowedInnerDeserializerClass = null;
        if (deserializerConfigValue != null) {
            try {
                windowedInnerDeserializerClass = (Serde)Utils.newInstance((String)deserializerConfigValue, Serde.class);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(deserializerConfigKey, (Object)deserializerConfigValue, "Serde class " + deserializerConfigValue + " could not be found.");
            }
        }
        if (this.inner != null && deserializerConfigValue != null) {
            if (!this.inner.getClass().getName().equals(windowedInnerDeserializerClass.deserializer().getClass().getName())) {
                throw new IllegalArgumentException("Inner class deserializer set using constructor (" + this.inner.getClass().getName() + ") is different from the one set in " + deserializerConfigKey + " config (" + windowedInnerDeserializerClass.deserializer().getClass().getName() + ").");
            }
        } else {
            if (this.inner == null && deserializerConfigValue == null) {
                throw new IllegalArgumentException("Inner class deserializer should be set either via constructor or via the windowed.inner.deserializer.class config");
            }
            if (this.inner == null) {
                this.inner = windowedInnerDeserializerClass.deserializer();
            }
        }
    }

    public Windowed<T> deserialize(String topic, byte[] data) {
        WindowedSerdes.verifyInnerDeserializerNotNull(this.inner, this);
        if (data == null || data.length == 0) {
            return null;
        }
        return SessionKeySchema.from(data, this.inner, topic);
    }

    public void close() {
        if (this.inner != null) {
            this.inner.close();
        }
    }

    Deserializer<T> innerDeserializer() {
        return this.inner;
    }
}

