/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import tim.prune.App;
import tim.prune.DataSubscriber;
import tim.prune.FunctionLibrary;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.cmd.EditPointCmd;
import tim.prune.cmd.InsertPointCmd;
import tim.prune.config.ColourScheme;
import tim.prune.config.Config;
import tim.prune.data.Checker;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.DoubleRange;
import tim.prune.data.Field;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.MidpointData;
import tim.prune.data.Selection;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.function.DeleteCurrentPoint;
import tim.prune.function.Describer;
import tim.prune.function.compress.MarkPointsInRectangleFunction;
import tim.prune.function.edit.FieldEdit;
import tim.prune.gui.IconManager;
import tim.prune.gui.MultiStateCheckBox;
import tim.prune.gui.colour.PointColourer;
import tim.prune.gui.colour.WaypointColours;
import tim.prune.gui.colour.WaypointSymbolPainter;
import tim.prune.gui.map.MapPosition;
import tim.prune.gui.map.MapTileManager;
import tim.prune.gui.map.MapUtils;
import tim.prune.gui.map.OverlayPanel;
import tim.prune.gui.map.ScaleBar;
import tim.prune.gui.map.TileConsumer;
import tim.prune.gui.map.WaypointIcons;
import tim.prune.gui.map.WpIconDefinition;

public class MapCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
DataSubscriber,
KeyListener,
MouseWheelListener,
TileConsumer {
    private final App _app;
    private final Track _track;
    private final TrackInfo _trackInfo;
    private final Selection _selection;
    private final MidpointData _midpoints;
    private int _clickedPoint = -1;
    private int _prevSelectedPoint = -1;
    private final MapTileManager _tileManager = new MapTileManager(this);
    private BufferedImage _mapImage = null;
    private BufferedImage _trackImage = null;
    private JSlider _transparencySlider = null;
    private final JCheckBox _scaleCheckBox;
    private final JCheckBox _mapCheckBox;
    private final JCheckBox _autopanCheckBox;
    private final MultiStateCheckBox _connectCheckBox;
    private final JCheckBox _editmodeCheckBox;
    private JPopupMenu _popup = null;
    private final JPanel _topPanel;
    private final JPanel _sidePanel;
    private ScaleBar _scaleBar = null;
    private DoubleRange _latRange = null;
    private DoubleRange _lonRange = null;
    private boolean _recalculate = false;
    private boolean _checkBounds = false;
    private final MapPosition _mapPosition;
    private int _dragFromX = -1;
    private int _dragFromY = -1;
    private int _dragToX = -1;
    private int _dragToY = -1;
    private int _popupMenuX = -1;
    private int _popupMenuY = -1;
    private DrawMode _drawMode = DrawMode.DEFAULT;
    private WpIconDefinition _waypointIconDefinition = null;
    private final WaypointColours _waypointColours = new WaypointColours();
    private boolean _emptyTrack = true;
    private double _lastScale = 1.0;
    private static final int CLICK_SENSITIVITY = 10;
    private static final int PAN_DISTANCE = 20;
    private static final int AUTOPAN_DISTANCE = 75;
    private static final int INDEX_UNKNOWN = -2;

    public MapCanvas(App app) {
        this._app = app;
        this._trackInfo = this._app.getTrackInfo();
        this._track = this._trackInfo.getTrack();
        this._selection = this._trackInfo.getSelection();
        this._midpoints = new MidpointData();
        this._mapPosition = new MapPosition();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        ItemListener itemListener = itemEvent -> {
            this._recalculate = true;
            this.repaint();
        };
        ItemListener itemListener2 = itemEvent -> {
            this._tileManager.clearMemoryCaches();
            this._recalculate = true;
            this._app.getConfig().setConfigBoolean("prune.showmap", itemEvent.getStateChange() == 1);
            UpdateMessageBroker.informSubscribers();
            if (itemEvent.getStateChange() == 2 && this._transparencySlider.getValue() < 0) {
                this._transparencySlider.setValue(0);
            }
        };
        this._topPanel = new OverlayPanel();
        this._topPanel.setLayout(new FlowLayout());
        this._transparencySlider = new JSlider(-6, 6, 0);
        this._transparencySlider.setPreferredSize(new Dimension(100, 20));
        this._transparencySlider.setMajorTickSpacing(1);
        this._transparencySlider.setSnapToTicks(true);
        this._transparencySlider.setOpaque(false);
        this._transparencySlider.setValue(0);
        this._transparencySlider.addChangeListener(changeEvent -> {
            int n = this._transparencySlider.getValue();
            if (n == 1 || n == -1) {
                this._transparencySlider.setValue(0);
            } else {
                this._recalculate = true;
                this.repaint();
            }
        });
        this._transparencySlider.setFocusable(false);
        this._topPanel.add(this._transparencySlider);
        IconManager iconManager = this._app.getIconManager();
        this._scaleCheckBox = new JCheckBox(iconManager.getImageIcon("canvas/scalebar-off"), true);
        this._scaleCheckBox.setSelectedIcon(iconManager.getImageIcon("canvas/scalebar-on"));
        this._scaleCheckBox.setOpaque(false);
        this._scaleCheckBox.setToolTipText(I18nManager.getText("menu.map.showscalebar"));
        this._scaleCheckBox.addItemListener(itemEvent -> this._scaleBar.setVisible(this._scaleCheckBox.isSelected()));
        this._scaleCheckBox.setFocusable(false);
        this._topPanel.add(this._scaleCheckBox);
        this._mapCheckBox = new JCheckBox(iconManager.getImageIcon("canvas/showmap-off"), false);
        this._mapCheckBox.setSelectedIcon(iconManager.getImageIcon("canvas/showmap-on"));
        this._mapCheckBox.setOpaque(false);
        this._mapCheckBox.setToolTipText(I18nManager.getText("menu.map.showmap"));
        this._mapCheckBox.addItemListener(itemListener2);
        this._mapCheckBox.setFocusable(false);
        this._topPanel.add(this._mapCheckBox);
        this._autopanCheckBox = new JCheckBox(iconManager.getImageIcon("canvas/autopan-off"), true);
        this._autopanCheckBox.setSelectedIcon(iconManager.getImageIcon("canvas/autopan-on"));
        this._autopanCheckBox.setOpaque(false);
        this._autopanCheckBox.setToolTipText(I18nManager.getText("menu.map.autopan"));
        this._autopanCheckBox.addItemListener(itemListener);
        this._autopanCheckBox.setFocusable(false);
        this._topPanel.add(this._autopanCheckBox);
        this._connectCheckBox = new MultiStateCheckBox(4);
        this._connectCheckBox.setIcon(0, iconManager.getImageIcon("canvas/points-arrows"));
        this._connectCheckBox.setIcon(1, iconManager.getImageIcon("canvas/points-hidden"));
        this._connectCheckBox.setIcon(2, iconManager.getImageIcon("canvas/points-connected"));
        this._connectCheckBox.setIcon(3, iconManager.getImageIcon("canvas/points-disconnected"));
        this._connectCheckBox.setCurrentState(0);
        this._connectCheckBox.setOpaque(false);
        this._connectCheckBox.setToolTipText(I18nManager.getText("menu.map.connect"));
        this._connectCheckBox.addItemListener(itemListener);
        this._connectCheckBox.setFocusable(false);
        this._topPanel.add(this._connectCheckBox);
        this._editmodeCheckBox = new JCheckBox(iconManager.getImageIcon("canvas/edit-mode-off"), false);
        this._editmodeCheckBox.setSelectedIcon(iconManager.getImageIcon("canvas/edit-mode-on"));
        this._editmodeCheckBox.setOpaque(false);
        this._editmodeCheckBox.setToolTipText(I18nManager.getText("menu.map.editmode"));
        this._editmodeCheckBox.addItemListener(itemListener);
        this._editmodeCheckBox.setFocusable(false);
        this._topPanel.add(this._editmodeCheckBox);
        this._sidePanel = new OverlayPanel();
        this._sidePanel.setLayout(new BoxLayout(this._sidePanel, 1));
        JButton jButton = new JButton(iconManager.getImageIcon("canvas/zoom-in"));
        jButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jButton.setContentAreaFilled(false);
        jButton.setToolTipText(I18nManager.getText("menu.map.zoomin"));
        jButton.addActionListener(actionEvent -> this.zoomIn());
        jButton.setFocusable(false);
        this._sidePanel.add(jButton);
        JButton jButton2 = new JButton(iconManager.getImageIcon("canvas/zoom-out"));
        jButton2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jButton2.setContentAreaFilled(false);
        jButton2.setToolTipText(I18nManager.getText("menu.map.zoomout"));
        jButton2.addActionListener(actionEvent -> this.zoomOut());
        jButton2.setFocusable(false);
        this._sidePanel.add(jButton2);
        this._scaleBar = new ScaleBar(this._app.getConfig());
        this.setLayout(new BorderLayout());
        this._topPanel.setVisible(false);
        this._sidePanel.setVisible(false);
        this.add((Component)this._topPanel, "North");
        this.add((Component)this._sidePanel, "West");
        this.add((Component)this._scaleBar, "South");
        this.makePopup();
        this._tileManager.setMapSource(this._app.getConfig().getConfigInt("prune.mapsource"));
        this.dataUpdated(128);
    }

    private void makePopup() {
        this._popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(I18nManager.getText("menu.map.zoomin"));
        jMenuItem.addActionListener(actionEvent -> {
            this.panMap((this._popupMenuX - this.getScaledWidth() / 2) / 2, (this._popupMenuY - this.getScaledHeight() / 2) / 2);
            this.zoomIn();
        });
        this._popup.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(I18nManager.getText("menu.map.zoomout"));
        jMenuItem2.addActionListener(actionEvent -> {
            this.panMap(-(this._popupMenuX - this.getScaledWidth() / 2), -(this._popupMenuY - this.getScaledHeight() / 2));
            this.zoomOut();
        });
        this._popup.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(I18nManager.getText("menu.map.zoomfull"));
        jMenuItem3.addActionListener(actionEvent -> {
            this.zoomToFit();
            this._recalculate = true;
            this.repaint();
        });
        this._popup.add(jMenuItem3);
        this._popup.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem(I18nManager.getText(FunctionLibrary.FUNCTION_SET_MAP_BG.getNameKey()));
        jMenuItem4.addActionListener(actionEvent -> FunctionLibrary.FUNCTION_SET_MAP_BG.begin());
        this._popup.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem(I18nManager.getText("menu.map.newpoint"));
        jMenuItem5.addActionListener(actionEvent -> this.insertPoint(this.createPointFromClick(this._popupMenuX, this._popupMenuY, true), -1));
        this._popup.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem(I18nManager.getText("menu.map.drawpoints"));
        jMenuItem6.addActionListener(actionEvent -> {
            DrawMode drawMode = this._drawMode = DrawMode.DRAW_POINTS_START;
        });
        this._popup.add(jMenuItem6);
    }

    private void zoomToFit() {
        if (this._track.getNumPoints() > 0) {
            this._latRange = this._track.getLatRange();
            this._lonRange = this._track.getLonRange();
        }
        if (this._latRange == null || this._lonRange == null || !this._latRange.hasData() || !this._lonRange.hasData()) {
            this.setDefaultLatLonRange();
        }
        DoubleRange doubleRange = new DoubleRange(MapUtils.getXFromLongitude(this._lonRange.getMinimum()), MapUtils.getXFromLongitude(this._lonRange.getMaximum()));
        DoubleRange doubleRange2 = new DoubleRange(MapUtils.getYFromLatitude(this._latRange.getMinimum()), MapUtils.getYFromLatitude(this._latRange.getMaximum()));
        this._mapPosition.zoomToXY(doubleRange.getMinimum(), doubleRange.getMaximum(), doubleRange2.getMinimum(), doubleRange2.getMaximum(), this.getScaledWidth(), this.getScaledHeight());
        this.showZoomLevel();
    }

    private void setDefaultLatLonRange() {
        String string = this._app.getConfig().getConfigString("prune.latlonrange");
        try {
            String[] stringArray = string.split(";");
            if (stringArray.length == 4) {
                double d = Double.parseDouble(stringArray[0]);
                double d2 = Double.parseDouble(stringArray[1]);
                if (d >= -90.0 && d <= 90.0 && d2 >= -90.0 && d2 <= 90.0 && d != d2) {
                    this._latRange = new DoubleRange(d, d2);
                    double d3 = Double.parseDouble(stringArray[2]);
                    double d4 = Double.parseDouble(stringArray[3]);
                    if (d3 >= -180.0 && d3 <= 180.0 && d4 >= -180.0 && d4 <= 180.0 && d3 != d4) {
                        this._lonRange = new DoubleRange(d3, d4);
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {}
        this._latRange = new DoubleRange(45.8, 47.9);
        this._lonRange = new DoubleRange(5.9, 10.6);
    }

    @Override
    public void paint(Graphics graphics) {
        boolean bl;
        block19: {
            block18: {
                int n;
                super.paint(graphics);
                if (this._mapImage != null && (this._mapImage.getWidth() != this.getScaledWidth() || this._mapImage.getHeight() != this.getScaledHeight())) {
                    this._mapImage = null;
                }
                boolean bl2 = this._app.getConfig().getConfigBoolean("prune.showmap");
                boolean bl3 = bl = this._track.getNumPoints() > 0 || bl2;
                if (!bl) break block18;
                if (this._autopanCheckBox.isSelected()) {
                    int n2 = this._selection.getCurrentPointIndex();
                    if (n2 >= 0 && this._dragFromX == -1 && n2 != this._prevSelectedPoint) {
                        this.autopanToPoint(n2);
                    }
                    this._prevSelectedPoint = n2;
                }
                if (this._emptyTrack && this._track.getNumPoints() > 1) {
                    this.zoomToFit();
                    this._recalculate = true;
                }
                boolean bl4 = this._emptyTrack = this._track.getNumPoints() == 0;
                if (this._mapImage == null || this._recalculate) {
                    this.paintMapContents();
                    this._scaleBar.updateScale(this._mapPosition.getZoom(), this._mapPosition.getYFromPixels(0, 0));
                }
                if (this._mapImage != null) {
                    double d;
                    Graphics2D graphics2D = (Graphics2D)graphics.create();
                    n = this._app.getConfig().getConfigBoolean("prune.osscaling");
                    double d2 = d = n != 0 ? 1.0 : graphics2D.getTransform().getScaleX();
                    if (d != this._lastScale) {
                        this._lastScale = d;
                        this._mapPosition.setDisplayScaling(this._lastScale);
                        this._scaleBar.setDisplayScaling(this._lastScale);
                    }
                    if (n == 0) {
                        AffineTransform affineTransform = graphics2D.getTransform();
                        double d3 = affineTransform.getTranslateX();
                        double d4 = affineTransform.getTranslateY();
                        affineTransform.setToScale(1.0, 1.0);
                        affineTransform.translate(d3, d4);
                        graphics2D.setTransform(affineTransform);
                    }
                    graphics2D.drawImage(this._mapImage, 0, 0, this.getScaledWidth(), this.getScaledHeight(), null);
                }
                switch (this._drawMode) {
                    case DRAG_POINT: {
                        DataPoint dataPoint = this._track.getPoint(this._selection.getCurrentPointIndex());
                        if (dataPoint != null) {
                            n = this._selection.getCurrentPointIndex();
                            if (dataPoint.isWaypoint()) {
                                this.drawDragLines(graphics, n, n);
                                break;
                            }
                            this.drawDragLines(graphics, n - 1, n + 1);
                            break;
                        }
                        break block19;
                    }
                    case CREATE_MIDPOINT: {
                        this.drawDragLines(graphics, this._clickedPoint - 1, this._clickedPoint);
                        break;
                    }
                    case ZOOM_RECT: 
                    case MARK_RECTANGLE_INSIDE: 
                    case MARK_RECTANGLE_OUTSIDE: {
                        if (this._dragFromX != -1 && this._dragFromY != -1) {
                            graphics.setColor(Color.RED);
                            graphics.drawLine(this._dragFromX, this._dragFromY, this._dragFromX, this._dragToY);
                            graphics.drawLine(this._dragFromX, this._dragFromY, this._dragToX, this._dragFromY);
                            graphics.drawLine(this._dragToX, this._dragFromY, this._dragToX, this._dragToY);
                            graphics.drawLine(this._dragFromX, this._dragToY, this._dragToX, this._dragToY);
                            break;
                        }
                        break block19;
                    }
                    case DRAW_POINTS_CONT: {
                        n = this._track.getNumPoints() - 1;
                        if (n >= 0) {
                            graphics.setColor(this._app.getConfig().getColourScheme().getColour(1));
                            int n3 = this.getWidth() / 2 + (int)((double)this._mapPosition.getXFromCentre(this._track.getX(n)) / this._lastScale);
                            int n4 = this.getHeight() / 2 + (int)((double)this._mapPosition.getYFromCentre(this._track.getY(n)) / this._lastScale);
                            graphics.drawLine(n3, n4, this._dragToX, this._dragToY);
                            break;
                        }
                        break block19;
                    }
                }
                break block19;
            }
            ColourScheme colourScheme = this._app.getConfig().getColourScheme();
            graphics.setColor(colourScheme.getColour(0));
            graphics.fillRect(0, 0, this.getScaledWidth(), this.getScaledHeight());
            graphics.setColor(colourScheme.getColour(3));
            graphics.drawString(I18nManager.getText("display.nodata"), 50, this.getScaledHeight() / 2);
            this._scaleBar.updateScale(-1, 0.0);
        }
        this._topPanel.setVisible(bl);
        this._sidePanel.setVisible(bl);
        this.paintChildren(graphics);
    }

    private boolean isCurrentPointVisible() {
        if (this._trackInfo.getCurrentPoint() == null) {
            return false;
        }
        int n = this._selection.getCurrentPointIndex();
        int n2 = Math.abs(this._mapPosition.getXFromCentre(this._track.getX(n)));
        if (n2 > this.getScaledWidth() / 2) {
            return false;
        }
        int n3 = Math.abs(this._mapPosition.getYFromCentre(this._track.getY(n)));
        return n3 < this.getScaledHeight() / 2;
    }

    private void autopanToPoint(int n) {
        int n2 = this.getWidth() / 2 + this._mapPosition.getXFromCentre(this._track.getX(n));
        int n3 = this.getHeight() / 2 + this._mapPosition.getYFromCentre(this._track.getY(n));
        int n4 = 0;
        int n5 = 0;
        if (n2 < 20) {
            n4 = n2 - 75;
        } else if (n2 > this.getWidth() - 20) {
            n4 = 75 + n2 - this.getWidth();
        }
        if (n3 < 40) {
            n5 = n3 - 75;
        }
        if (n3 > this.getHeight() - 20) {
            n5 = 75 + n3 - this.getHeight();
        }
        if (n4 != 0 || n5 != 0) {
            this._mapPosition.pan(n4, n5);
        }
    }

    private void paintMapContents() {
        boolean bl;
        if (this._mapImage == null || this._mapImage.getWidth() != this.getScaledWidth() || this._mapImage.getHeight() != this.getScaledHeight()) {
            this._mapImage = new BufferedImage(this.getScaledWidth(), this.getScaledHeight(), 1);
        }
        Graphics graphics = this._mapImage.getGraphics();
        Config config = this._app.getConfig();
        ColourScheme colourScheme = config.getColourScheme();
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, config.getConfigBoolean("prune.antialias") ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setColor(colourScheme.getColour(0));
        graphics.fillRect(0, 0, this.getScaledWidth(), this.getScaledHeight());
        boolean bl2 = config.getConfigBoolean("prune.showmap");
        this._mapCheckBox.setSelected(bl2);
        boolean bl3 = bl = config.getConfigString("prune.diskcache") != null;
        if (bl2 && !bl && config.getConfigBoolean("prune.onlinemode")) {
            SwingUtilities.invokeLater(() -> this._app.showTip(0));
        }
        this._recalculate = false;
        if (bl2) {
            this._tileManager.centreMap(this._mapPosition.getZoom(), this._mapPosition.getCentreTileX(), this._mapPosition.getCentreTileY());
            if (this._mapImage == null) {
                return;
            }
            if (this._tileManager.isOverzoomed()) {
                graphics.setColor(colourScheme.getColour(3));
                graphics.drawString(I18nManager.getText("map.overzoom"), 50, this.getScaledHeight() / 2);
            } else {
                int n6 = this._tileManager.getNumLayers();
                int[] nArray = this._mapPosition.getTileIndices(this.getScaledWidth(), this.getScaledHeight());
                int[] nArray2 = this._mapPosition.getDisplayOffsets(this.getScaledWidth(), this.getScaledHeight());
                int n7 = nArray[0];
                while (n7 <= nArray[1]) {
                    int n8 = (n7 - nArray[0]) * 256 - nArray2[0];
                    int n9 = nArray[2];
                    while (n9 <= nArray[3]) {
                        int n10 = (n9 - nArray[2]) * 256 - nArray2[1];
                        int n11 = 0;
                        while (n11 < n6) {
                            Image image2 = this._tileManager.getTile(n11, n7, n9, true, this._app.getConfig());
                            if (image2 != null) {
                                graphics.drawImage(image2, n8, n10, 256, 256, (image, n, n2, n3, n4, n5) -> this.checkPaintedTile(n));
                            }
                            ++n11;
                        }
                        ++n9;
                    }
                    ++n7;
                }
                n7 = Math.max(1, this._transparencySlider.getValue()) - 1;
                if (n7 > 0) {
                    int[] nArray3 = new int[6];
                    nArray3[1] = 40;
                    nArray3[2] = 80;
                    nArray3[3] = 120;
                    nArray3[4] = 160;
                    nArray3[5] = 210;
                    int[] nArray4 = nArray3;
                    Color color = colourScheme.getColour(0);
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), nArray4[n7]);
                    graphics.setColor(color);
                    graphics.fillRect(0, 0, this.getScaledWidth(), this.getScaledHeight());
                }
            }
        }
        float[] fArray = new float[]{1.0f, 0.75f, 0.5f, 0.3f, 0.15f, 0.0f};
        float f = 1.0f;
        if (this._transparencySlider.getValue() < 0) {
            f = fArray[-1 - this._transparencySlider.getValue()];
        }
        if (f > 0.0f) {
            boolean bl4 = true;
            try {
                if (f > 0.9f) {
                    bl4 = this.paintPoints(graphics);
                    this._trackImage = null;
                } else {
                    if (this._trackImage == null || this._trackImage.getWidth() != this.getScaledWidth() || this._trackImage.getHeight() != this.getScaledHeight()) {
                        this._trackImage = new BufferedImage(this.getScaledWidth(), this.getScaledHeight(), 2);
                    }
                    Graphics2D graphics2D = this._trackImage.createGraphics();
                    graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
                    graphics2D.fillRect(0, 0, this.getScaledWidth(), this.getScaledHeight());
                    graphics2D.setPaintMode();
                    bl4 = this.paintPoints(graphics2D);
                    ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, f));
                    graphics.drawImage(this._trackImage, 0, 0, null);
                }
            }
            catch (ArrayIndexOutOfBoundsException | NullPointerException runtimeException) {}
            if (!bl4 && this._checkBounds) {
                this.zoomToFit();
                this._recalculate = true;
                this.repaint();
            }
        }
        graphics.dispose();
        this._checkBounds = false;
        this._transparencySlider.setEnabled(bl2);
    }

    private boolean checkPaintedTile(int n) {
        if ((n & 0x20) == 0) {
            this.tilesUpdated(true);
            return true;
        }
        return false;
    }

    private boolean paintPoints(Graphics graphics) {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        ColourScheme colourScheme = this._app.getConfig().getColourScheme();
        Color color = colourScheme.getColour(1);
        Color color2 = colourScheme.getColour(2);
        Color color3 = colourScheme.getColour(4);
        Color color4 = colourScheme.getColour(5);
        Color color5 = colourScheme.getColour(3);
        PointColourer pointColourer = this._app.getPointColourer();
        int n8 = this.getScaledWidth();
        int n9 = this.getScaledHeight();
        int n10 = n8 / 2;
        int n11 = n9 / 2;
        int n12 = this._track.getNumPoints();
        int[] nArray = new int[n12];
        int[] nArray2 = new int[n12];
        int n13 = (int)(Math.sqrt(400.0) * 0.7);
        if (graphics instanceof Graphics2D) {
            n7 = this._app.getConfig().getConfigInt("prune.linewidth");
            if (n7 < 1 || n7 > 4) {
                n7 = 2;
            }
            ((Graphics2D)graphics).setStroke(new BasicStroke(n7));
        }
        n7 = 0;
        graphics.setColor(color);
        int n14 = -1;
        int n15 = -1;
        int n16 = this._connectCheckBox.getCurrentState();
        boolean bl = n16 != 3;
        boolean bl2 = n16 != 1;
        boolean bl3 = n16 == 0;
        int n17 = 0;
        boolean bl4 = false;
        int n18 = 0;
        int n19 = 0;
        while (n19 < n12) {
            n6 = n10 + this._mapPosition.getXFromCentre(this._track.getX(n19));
            n5 = n11 + this._mapPosition.getYFromCentre(this._track.getY(n19));
            nArray[n19] = n6 = MapCanvas.wrapLongitudeValue(n6, n8, this._mapPosition.getZoom());
            nArray2[n19] = n5;
            n4 = n6 >= 0 && n6 < n8 && n5 >= 0 && n5 < n9 ? 1 : 0;
            n3 = this._track.getPoint(n19).isWaypoint() ? 1 : 0;
            boolean bl5 = bl4 = bl4 || n3 != 0;
            if (n3 == 0) {
                if (n4 != 0 || bl && n17 != 0) {
                    if (this._trackInfo.isPointMarkedForDeletion(n19)) {
                        graphics.setColor(color3);
                    } else if (pointColourer != null) {
                        object = pointColourer.getColour(n19);
                        graphics.setColor((Color)object);
                    } else {
                        graphics.setColor(color);
                    }
                    if (n4 != 0) {
                        if (bl2) {
                            graphics.drawRect(n6 - 2, n5 - 2, 3, 3);
                        }
                        n7 = 1;
                    }
                }
                if (!(!bl || n4 == 0 && n17 == 0 || n14 == -1 && n15 == -1 || this._track.getPoint(n19).getSegmentStart())) {
                    graphics.drawLine(n14, n15, n6, n5);
                    n7 = 1;
                    if (bl3) {
                        double d = Math.max(Math.abs(n14 - n6), Math.abs(n15 - n5));
                        int n20 = n2 = n18 != 0 ? 120 : n13;
                        if (d > (double)n2) {
                            double d2 = (n14 - n6) * (n14 - n6) + (n15 - n5) * (n15 - n5);
                            if (d2 > 400.0) {
                                double d3 = (double)(n14 + n6) / 2.0;
                                double d4 = (double)(n15 + n5) / 2.0;
                                int n21 = n = d3 >= 0.0 && d3 < (double)n8 && d4 >= 0.0 && d4 < (double)n9 ? 1 : 0;
                                if (n != 0) {
                                    double d5 = Math.atan2(n5 - n15, n6 - n14);
                                    double d6 = 3.0 * Math.cos(d5);
                                    double d7 = 3.0 * Math.sin(d5);
                                    double d8 = d3 + d6;
                                    double d9 = d4 + d7;
                                    graphics.drawLine((int)(d3 - d6 - 2.0 * d7), (int)(d4 - d7 + 2.0 * d6), (int)d8, (int)d9);
                                    graphics.drawLine((int)(d3 - d6 + 2.0 * d7), (int)(d4 - d7 - 2.0 * d6), (int)d8, (int)d9);
                                }
                                n18 = n;
                            }
                        } else {
                            n18 = 0;
                        }
                    }
                }
                n14 = n6;
                n15 = n5;
            }
            n17 = n4;
            ++n19;
        }
        graphics.setColor(color5);
        if (bl4) {
            Object object2;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n6 = fontMetrics.getHeight();
            this._waypointColours.setSalt(this._app.getConfig().getConfigInt("prune.waypointsalt"));
            n5 = 0;
            n4 = 0;
            while (n4 < this._track.getNumPoints()) {
                if (this._track.getPoint(n4).isWaypoint()) {
                    n3 = nArray[n4];
                    int n22 = nArray2[n4];
                    if (n3 >= 0 && n3 < n8 && n22 >= 0 && n22 < n9) {
                        if (this._waypointIconDefinition == null) {
                            graphics.fillRect(n3 - 3, n22 - 3, 6, 6);
                        } else {
                            Color color6;
                            object2 = this._waypointIconDefinition.getImageIcon();
                            Image image = WaypointSymbolPainter.paintSymbol((ImageIcon)object2, color6 = this._waypointColours.getColourForType(this._track.getPoint(n4).getFieldValue(Field.WAYPT_TYPE)));
                            if (image != null) {
                                graphics.drawImage(image, n3 - this._waypointIconDefinition.getXOffset(), n22 - this._waypointIconDefinition.getYOffset(), null);
                            }
                        }
                        n7 = 1;
                        ++n5;
                    }
                }
                ++n4;
            }
            n4 = n5 > 100 ? 1 : 4;
            n3 = n5 > 1000 ? 2 : 1;
            object = new int[4];
            object2 = new int[4];
            n2 = 0;
            while (n2 < this._track.getNumPoints()) {
                if (this._track.getPoint(n2).isWaypoint()) {
                    int n23 = nArray[n2];
                    int n24 = nArray2[n2];
                    if (n23 >= 0 && n23 < n8 && n24 >= 0 && n24 < n9) {
                        String string = this._track.getPoint(n2).getWaypointName();
                        int n25 = fontMetrics.stringWidth(string);
                        boolean bl6 = false;
                        object[0] = n23 + 2;
                        object[1] = n23 - n25 - 2;
                        object[2] = object[3] = n23 - n25 / 2;
                        object2[0] = object2[1] = n24 + n6 / 2;
                        object2[2] = n24 - 2;
                        object2[3] = n24 + n6 + 2;
                        int n26 = 0;
                        while (n26 < n4 && !bl6) {
                            object[0] = object[0] + 3;
                            object[1] = object[1] - 3;
                            object2[2] = object2[2] - 3;
                            object2[3] = object2[3] + 3;
                            n = 0;
                            while (n < 4) {
                                if (object[n] > 0 && object[n] + n25 < n8 && object2[n] < n9 && object2[n] - n6 > 0 && !MapUtils.overlapsPoints(this._mapImage, object[n], object2[n], n25, n6, color5)) {
                                    graphics.drawString(string, object[n], object2[n]);
                                    bl6 = true;
                                    break;
                                }
                                ++n;
                            }
                            ++n26;
                        }
                    }
                }
                n2 += n3;
            }
        }
        graphics.setColor(color4);
        int n27 = 0;
        while (n27 < this._track.getNumPoints()) {
            if (this._track.getPoint(n27).hasMedia()) {
                n6 = nArray[n27];
                n5 = nArray2[n27];
                if (n6 >= 0 && n6 < n8 && n5 >= 0 && n5 < n9) {
                    graphics.drawRect(n6 - 1, n5 - 1, 2, 2);
                    graphics.drawRect(n6 - 2, n5 - 2, 4, 4);
                    n7 = 1;
                }
            }
            ++n27;
        }
        if (this._selection.hasRangeSelected()) {
            graphics.setColor(color2);
            n27 = this._selection.getStart();
            while (n27 <= this._selection.getEnd()) {
                n6 = nArray[n27];
                n5 = nArray2[n27];
                graphics.drawRect(n6 - 1, n5 - 1, 2, 2);
                ++n27;
            }
        }
        if ((n27 = this._selection.getCurrentPointIndex()) >= 0) {
            n6 = nArray[n27];
            n5 = nArray2[n27];
            graphics.setColor(color3);
            graphics.drawLine(n6, 0, n6, n9);
            graphics.drawLine(0, n5, n8, n5);
        }
        return n7 != 0;
    }

    private static int wrapLongitudeValue(int n, int n2, int n3) {
        if (n > n2) {
            int n4 = n;
            while (n4 > n2) {
                n4 -= 256 << n3;
            }
            if (n4 >= 0) {
                return n4;
            }
        } else if (n < 0) {
            int n5 = n;
            while (n5 < 0) {
                n5 += 256 << n3;
            }
            if (n5 < n2) {
                return n5;
            }
        }
        return n;
    }

    private void drawDragLines(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        graphics.setColor(this._app.getConfig().getColourScheme().getColour(1));
        if (n == n2 || n > -1 && !this._track.getPoint(n + 1).getSegmentStart()) {
            n4 = this.getWidth() / 2 + (int)((double)this._mapPosition.getXFromCentre(this._track.getX(n)) / this._lastScale);
            n3 = this.getHeight() / 2 + (int)((double)this._mapPosition.getYFromCentre(this._track.getY(n)) / this._lastScale);
            graphics.drawLine(n4, n3, this._dragToX, this._dragToY);
        }
        if (n2 < this._track.getNumPoints() && !this._track.getPoint(n2).getSegmentStart()) {
            n4 = this.getWidth() / 2 + (int)((double)this._mapPosition.getXFromCentre(this._track.getX(n2)) / this._lastScale);
            n3 = this.getHeight() / 2 + (int)((double)this._mapPosition.getYFromCentre(this._track.getY(n2)) / this._lastScale);
            graphics.drawLine(n4, n3, this._dragToX, this._dragToY);
        }
    }

    @Override
    public void tilesUpdated(boolean bl) {
        this._recalculate = true;
        this.repaint();
    }

    @Override
    public void reportCacheFailure() {
        this._app.getConfig().setConfigString("prune.diskcache", null);
    }

    public final void zoomOut() {
        this._mapPosition.zoomOut();
        this._recalculate = true;
        this.repaint();
        this.showZoomLevel();
    }

    public final void zoomIn() {
        boolean bl = this._autopanCheckBox.isSelected() && this.isCurrentPointVisible();
        this._mapPosition.zoomIn();
        if (bl && !this.isCurrentPointVisible()) {
            this.autopanToPoint(this._selection.getCurrentPointIndex());
        }
        this._recalculate = true;
        this.repaint();
        this.showZoomLevel();
    }

    private void showZoomLevel() {
        if (this._app.getConfig().getConfigBoolean("prune.showzoomlevel")) {
            UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("display.zoomlevel")) + ": " + this._mapPosition.getZoom());
        }
    }

    public void panMap(int n, int n2) {
        this._mapPosition.pan(n, n2);
        this._recalculate = true;
        this.repaint();
    }

    private DataPoint createPointFromClick(int n, int n2, boolean bl) {
        double d = MapUtils.getLatitudeFromY(this._mapPosition.getYFromPixels(n2, this.getHeight()));
        double d2 = MapUtils.getLongitudeFromX(this._mapPosition.getXFromPixels(n, this.getWidth()));
        Coordinate coordinate = Latitude.make(d);
        Coordinate coordinate2 = Longitude.make(d2);
        if (coordinate != null && coordinate2 != null) {
            DataPoint dataPoint = new DataPoint(Latitude.make(d), Longitude.make(d2));
            dataPoint.setSegmentStart(bl);
            return dataPoint;
        }
        return null;
    }

    private void movePointToMouse(int n, int n2, int n3, int n4) {
        double d = MapUtils.getLatitudeFromY(this._mapPosition.getYFromPixels(n2, this.getHeight()));
        double d2 = MapUtils.getLongitudeFromX(this._mapPosition.getXFromPixels(n, this.getWidth()));
        double d3 = MapUtils.getLatitudeFromY(this._mapPosition.getYFromPixels(n4, this.getHeight())) - d;
        double d4 = MapUtils.getLongitudeFromX(this._mapPosition.getXFromPixels(n3, this.getWidth())) - d2;
        DataPoint dataPoint = this._trackInfo.getCurrentPoint();
        if (dataPoint == null) {
            return;
        }
        String string = String.format("%.12f", dataPoint.getLatitude().getDouble() + d3);
        String string2 = String.format("%.12f", dataPoint.getLongitude().getDouble() + d4);
        List<FieldEdit> list = List.of(new FieldEdit(Field.LATITUDE, string), new FieldEdit(Field.LONGITUDE, string2));
        int n5 = this._app.getTrackInfo().getSelection().getCurrentPointIndex();
        EditPointCmd editPointCmd = new EditPointCmd(n5, list);
        Describer describer = new Describer("undo.editpoint", "undo.editpoint.withname");
        editPointCmd.setDescription(describer.getDescriptionWithNameOrNot(dataPoint.getWaypointName()));
        editPointCmd.setConfirmText(I18nManager.getText("confirm.point.edit"));
        this._app.execute(editPointCmd);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(512, 300);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = this._app.getConfig().getConfigBoolean("prune.showmap");
        boolean bl3 = bl = this._track != null && this._track.getNumPoints() > 0;
        if (bl2 || bl) {
            if (!mouseEvent.isMetaDown()) {
                if (mouseEvent.getClickCount() == 1) {
                    if (this._drawMode == DrawMode.DEFAULT && bl) {
                        int n = this._clickedPoint;
                        if (n == -2) {
                            n = this._track.getNearestPointIndex(this._mapPosition.getXFromPixels(mouseEvent.getX(), this.getWidth()), this._mapPosition.getYFromPixels(mouseEvent.getY(), this.getHeight()), this._mapPosition.getBoundsFromPixels(10), false);
                        }
                        if (mouseEvent.isShiftDown()) {
                            this._trackInfo.extendSelection(n);
                        } else {
                            this._trackInfo.selectPoint(n);
                        }
                    } else if (this._drawMode == DrawMode.DRAW_POINTS_START) {
                        DataPoint dataPoint = this.createPointFromClick(mouseEvent.getX(), mouseEvent.getY(), true);
                        this.insertPoint(dataPoint, -1);
                        this._dragToX = mouseEvent.getX();
                        this._dragToY = mouseEvent.getY();
                        this._drawMode = DrawMode.DRAW_POINTS_CONT;
                    } else if (this._drawMode == DrawMode.DRAW_POINTS_CONT) {
                        DataPoint dataPoint = this.createPointFromClick(mouseEvent.getX(), mouseEvent.getY(), false);
                        this.insertPoint(dataPoint, -1);
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    if (this._drawMode == DrawMode.DEFAULT) {
                        this.panMap(mouseEvent.getX() - this.getWidth() / 2, mouseEvent.getY() - this.getHeight() / 2);
                        this.zoomIn();
                    } else if (this._drawMode == DrawMode.DRAW_POINTS_START || this._drawMode == DrawMode.DRAW_POINTS_CONT) {
                        this._drawMode = DrawMode.DEFAULT;
                    }
                }
            } else {
                this._popupMenuX = mouseEvent.getX();
                this._popupMenuY = mouseEvent.getY();
                this._popup.show(this, this._popupMenuX, this._popupMenuY);
            }
        }
        this._app.setCurrentMode(App.AppMode.NORMAL);
        if (this._drawMode == DrawMode.MARK_RECTANGLE_INSIDE || this._drawMode == DrawMode.MARK_RECTANGLE_OUTSIDE) {
            this._drawMode = DrawMode.DEFAULT;
        }
    }

    private void insertPoint(DataPoint dataPoint, int n) {
        if (n < -1 || dataPoint == null) {
            return;
        }
        InsertPointCmd insertPointCmd = new InsertPointCmd(dataPoint, n);
        insertPointCmd.setDescription(I18nManager.getText("undo.createpoint"));
        insertPointCmd.setConfirmText(I18nManager.getText("confirm.createpoint"));
        this._app.execute(insertPointCmd);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this._clickedPoint = -2;
        if (this._track == null || this._track.getNumPoints() <= 0) {
            return;
        }
        if (mouseEvent.isMetaDown()) {
            return;
        }
        if (this._drawMode == DrawMode.DEFAULT && (this._editmodeCheckBox.isSelected() || mouseEvent.isAltDown() || mouseEvent.isAltGraphDown())) {
            double d = this._mapPosition.getXFromPixels(mouseEvent.getX(), this.getWidth());
            double d2 = this._mapPosition.getYFromPixels(mouseEvent.getY(), this.getHeight());
            double d3 = this._mapPosition.getBoundsFromPixels(10);
            this._clickedPoint = this._track.getNearestPointIndex(d, d2, d3, false);
            if (this._clickedPoint >= 0) {
                this._trackInfo.selectPoint(this._clickedPoint);
                if (this._trackInfo.getCurrentPoint() != null) {
                    this._drawMode = DrawMode.DRAG_POINT;
                    this._dragFromX = this._dragToX = mouseEvent.getX();
                    this._dragFromY = this._dragToY = mouseEvent.getY();
                }
            } else {
                int n = this._midpoints.getNearestPointIndex(d, d2, d3);
                if (n > 0) {
                    this._drawMode = DrawMode.CREATE_MIDPOINT;
                    this._clickedPoint = n;
                    this._dragFromX = this._dragToX = mouseEvent.getX();
                    this._dragFromY = this._dragToY = mouseEvent.getY();
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._recalculate = true;
        if (this._drawMode == DrawMode.DRAG_POINT) {
            if (mouseEvent.isMetaDown()) {
                return;
            }
            if (Math.abs(this._dragToX - this._dragFromX) > 2 || Math.abs(this._dragToY - this._dragFromY) > 2) {
                this.movePointToMouse(this._dragFromX, this._dragFromY, this._dragToX, this._dragToY);
            }
            this._drawMode = DrawMode.DEFAULT;
        } else if (this._drawMode == DrawMode.CREATE_MIDPOINT) {
            if (mouseEvent.isMetaDown()) {
                return;
            }
            this._drawMode = DrawMode.DEFAULT;
            this.insertPoint(this.createPointFromClick(this._dragToX, this._dragToY, false), this._clickedPoint);
        } else if (this._drawMode == DrawMode.ZOOM_RECT) {
            if (Math.abs(this._dragToX - this._dragFromX) > 20 && Math.abs(this._dragToY - this._dragFromY) > 20) {
                this._mapPosition.zoomToPixels(this._dragFromX, this._dragToX, this._dragFromY, this._dragToY, this.getWidth(), this.getHeight());
                this.showZoomLevel();
            }
            this._drawMode = DrawMode.DEFAULT;
        } else if (this._drawMode == DrawMode.MARK_RECTANGLE_INSIDE || this._drawMode == DrawMode.MARK_RECTANGLE_OUTSIDE) {
            if (mouseEvent.isMetaDown()) {
                return;
            }
            boolean bl = this._drawMode == DrawMode.MARK_RECTANGLE_INSIDE;
            this._app.setCurrentMode(App.AppMode.NORMAL);
            this._drawMode = DrawMode.DEFAULT;
            double d = MapUtils.getLongitudeFromX(this._mapPosition.getXFromPixels(this._dragFromX, this.getWidth()));
            double d2 = MapUtils.getLatitudeFromY(this._mapPosition.getYFromPixels(this._dragFromY, this.getHeight()));
            double d3 = MapUtils.getLongitudeFromX(this._mapPosition.getXFromPixels(this._dragToX, this.getWidth()));
            double d4 = MapUtils.getLatitudeFromY(this._mapPosition.getYFromPixels(this._dragToY, this.getHeight()));
            if (this._dragFromX < 0 || this._dragFromY < 0) {
                d = d3;
                d2 = d4;
            }
            MarkPointsInRectangleFunction markPointsInRectangleFunction = this.getMarkRectangleFunction(bl);
            markPointsInRectangleFunction.setRectCoords(d, d2, d3, d4);
            markPointsInRectangleFunction.begin();
        }
        this._dragFromY = -1;
        this._dragFromX = -1;
        this.repaint();
    }

    private MarkPointsInRectangleFunction getMarkRectangleFunction(boolean bl) {
        GenericFunction genericFunction = bl ? FunctionLibrary.FUNCTION_MARK_INSIDE_RECTANGLE : FunctionLibrary.FUNCTION_MARK_OUTSIDE_RECTANGLE;
        return (MarkPointsInRectangleFunction)genericFunction;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = (mouseEvent.getModifiersEx() & 0x1000) > 0;
        if (bl) {
            this._drawMode = DrawMode.ZOOM_RECT;
            if (this._dragFromX == -1) {
                this._dragFromX = mouseEvent.getX();
                this._dragFromY = mouseEvent.getY();
            }
            this._dragToX = mouseEvent.getX();
            this._dragToY = mouseEvent.getY();
            this.repaint();
        } else if (this._drawMode == DrawMode.DRAG_POINT || this._drawMode == DrawMode.CREATE_MIDPOINT) {
            this._dragToX = mouseEvent.getX();
            this._dragToY = mouseEvent.getY();
            this._recalculate = true;
            this.repaint();
        } else if (this._drawMode == DrawMode.MARK_RECTANGLE_INSIDE || this._drawMode == DrawMode.MARK_RECTANGLE_OUTSIDE) {
            if (this._dragFromX == -1) {
                this._dragFromX = mouseEvent.getX();
                this._dragFromY = mouseEvent.getY();
            }
            this._dragToX = mouseEvent.getX();
            this._dragToY = mouseEvent.getY();
            this.repaint();
        } else {
            if (this._dragFromX != -1) {
                this.panMap(this._dragFromX - mouseEvent.getX(), this._dragFromY - mouseEvent.getY());
            }
            this._dragFromX = this._dragToX = mouseEvent.getX();
            this._dragFromY = this._dragToY = mouseEvent.getY();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl = false;
        boolean bl2 = false;
        if (this._drawMode == DrawMode.DRAW_POINTS_CONT) {
            this._dragToX = mouseEvent.getX();
            this._dragToY = mouseEvent.getY();
            this.repaint();
        } else if (this._drawMode == DrawMode.MARK_RECTANGLE_INSIDE || this._drawMode == DrawMode.MARK_RECTANGLE_OUTSIDE) {
            bl2 = true;
        } else if ((this._editmodeCheckBox.isSelected() || mouseEvent.isAltDown() || mouseEvent.isAltGraphDown()) && this._track.getNumPoints() > 0) {
            double d;
            double d2;
            double d3 = this._mapPosition.getXFromPixels(mouseEvent.getX(), this.getWidth());
            boolean bl3 = bl = this._track.getNearestPointIndex(d3, d2 = this._mapPosition.getYFromPixels(mouseEvent.getY(), this.getHeight()), d = this._mapPosition.getBoundsFromPixels(10), false) >= 0 || this._midpoints.getNearestPointIndex(d3, d2, d) >= 0;
        }
        if (bl && !this.isCursorSet()) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        } else if (bl2 && !this.isCursorSet()) {
            this.setCursor(Cursor.getPredefinedCursor(5));
        } else if (!bl && !bl2 && this.isCursorSet()) {
            this.setCursor(null);
        }
    }

    @Override
    public void actionCompleted(String string) {
    }

    @Override
    public void dataUpdated(int n) {
        Object object;
        this._recalculate = true;
        if ((n & 1) > 0) {
            this._checkBounds = true;
        }
        if ((n & 0x80) > 0) {
            object = this._app.getConfig();
            this._tileManager.setMapSource(object.getConfigInt("prune.mapsource"));
            this._waypointIconDefinition = WaypointIcons.getDefinition(object, this._app.getIconManager());
        }
        if ((n & 3) > 0) {
            this._midpoints.updateData(this._track);
        }
        if ((object = this._app.getCurrentMode()) == App.AppMode.DRAWRECT_INSIDE || object == App.AppMode.DRAWRECT_OUTSIDE) {
            DrawMode drawMode = this._drawMode = object == App.AppMode.DRAWRECT_INSIDE ? DrawMode.MARK_RECTANGLE_INSIDE : DrawMode.MARK_RECTANGLE_OUTSIDE;
            if (!this.isCursorSet()) {
                this.setCursor(Cursor.getPredefinedCursor(5));
            }
        }
        this.repaint();
        this.requestFocus();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = this._selection.getCurrentPointIndex();
        if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
            int n3;
            int n4 = n3 = keyEvent.isShiftDown() ? 3 : 1;
            if (n == 38) {
                this.zoomIn();
            } else if (n == 40) {
                this.zoomOut();
            } else if (n == 37 && n2 > 0) {
                this._trackInfo.incrementPointIndex(-n3);
            } else if (n == 39) {
                this._trackInfo.incrementPointIndex(n3);
            } else if (n == 33) {
                this._trackInfo.selectPoint(Checker.getPreviousSegmentStart(this._trackInfo.getTrack(), this._trackInfo.getSelection().getCurrentPointIndex()));
            } else if (n == 34) {
                this._trackInfo.selectPoint(Checker.getNextSegmentStart(this._trackInfo.getTrack(), this._trackInfo.getSelection().getCurrentPointIndex()));
            } else if (n == 36) {
                this._trackInfo.selectPoint(0);
            } else if (n == 35) {
                this._trackInfo.selectPoint(this._trackInfo.getTrack().getNumPoints() - 1);
            }
        } else {
            int n5 = 0;
            if (n == 38) {
                n5 = -20;
            } else if (n == 40) {
                n5 = 20;
            }
            int n6 = 0;
            if (n == 39) {
                n6 = 20;
            } else if (n == 37) {
                n6 = -20;
            }
            this.panMap(n6, n5);
            if (n == 27) {
                this._drawMode = DrawMode.DEFAULT;
            } else if (n == 8 && n2 >= 0) {
                new DeleteCurrentPoint(this._app).begin();
            } else if (n == 36 && this._trackInfo.getSelection().hasRangeSelected()) {
                this._trackInfo.selectPoint(this._trackInfo.getSelection().getStart());
            } else if (n == 35 && this._trackInfo.getSelection().hasRangeSelected()) {
                this._trackInfo.selectPoint(this._trackInfo.getSelection().getEnd());
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        int n2 = (mouseWheelEvent.getX() - this.getWidth() / 2) / 2;
        int n3 = (mouseWheelEvent.getY() - this.getHeight() / 2) / 2;
        if (n < 0) {
            this.panMap(n2, n3);
            this.zoomIn();
        } else if (n > 0) {
            this.panMap(-n2, -n3);
            this.zoomOut();
        }
    }

    private int getScaledHeight() {
        int n = super.getHeight();
        return (int)((double)n * this._lastScale);
    }

    private int getScaledWidth() {
        int n = super.getWidth();
        return (int)((double)n * this._lastScale);
    }

    public double getMinYValue() {
        return this._mapPosition.getYFromPixels(this.getHeight(), this.getHeight());
    }

    public double getMaxYValue() {
        return this._mapPosition.getYFromPixels(0, this.getHeight());
    }

    public double getMinXValue() {
        return this._mapPosition.getXFromPixels(0, this.getWidth());
    }

    public double getMaxXValue() {
        return this._mapPosition.getXFromPixels(this.getWidth(), this.getWidth());
    }

    private static enum DrawMode {
        DEFAULT,
        ZOOM_RECT,
        DRAW_POINTS_START,
        DRAW_POINTS_CONT,
        DRAG_POINT,
        CREATE_MIDPOINT,
        MARK_RECTANGLE_INSIDE,
        MARK_RECTANGLE_OUTSIDE;

    }
}

