# frozen_string_literal: true

class AddExternalTypeIndexOnVulnerabilityIdentifiers < Gitlab::Database::Migration[2.3]
  milestone '18.5'
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_identifiers_on_id_where_external_type_cve'

  def up
    add_concurrent_index(
      :vulnerability_identifiers,
      :id,
      where: "LOWER(external_type) = 'cve'",
      name: INDEX_NAME
    )
  end

  def down
    remove_concurrent_index_by_name :vulnerability_identifiers, INDEX_NAME
  end
end
