# frozen_string_literal: true

class AddVulnerabilityFindingLinksProjectIdTrigger < Gitlab::Database::Migration[2.2]
  milestone '17.3'

  def up
    install_sharding_key_assignment_trigger(
      table: :vulnerability_finding_links,
      sharding_key: :project_id,
      parent_table: :vulnerability_occurrences,
      parent_sharding_key: :project_id,
      foreign_key: :vulnerability_occurrence_id
    )
  end

  def down
    remove_sharding_key_assignment_trigger(
      table: :vulnerability_finding_links,
      sharding_key: :project_id,
      parent_table: :vulnerability_occurrences,
      parent_sharding_key: :project_id,
      foreign_key: :vulnerability_occurrence_id
    )
  end
end
