# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class CreateBySubscription(AAZCommand):
    """Create an attestation at subscription scope.
    """

    _aaz_info = {
        "version": "2022-09-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.policyinsights/attestations/{}", "2022-09-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.attestation_name = AAZStrArg(
            options=["-n", "--name", "--attestation-name"],
            help="The name of the attestation.",
            required=True,
            id_part="name",
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.assessment_date = AAZDateTimeArg(
            options=["--assessment-date"],
            arg_group="Properties",
            help="The time the evidence was assessed",
        )
        _args_schema.comments = AAZStrArg(
            options=["--comments"],
            arg_group="Properties",
            help="Comments describing why this attestation was created.",
        )
        _args_schema.compliance_state = AAZStrArg(
            options=["--compliance-state"],
            arg_group="Properties",
            help="The compliance state that should be set on the resource.",
            enum={"Compliant": "Compliant", "NonCompliant": "NonCompliant", "Unknown": "Unknown"},
        )
        _args_schema.evidence = AAZListArg(
            options=["--evidence"],
            arg_group="Properties",
            help="The evidence supporting the compliance state set in this attestation.",
        )
        _args_schema.expires_on = AAZDateTimeArg(
            options=["--expires-on"],
            arg_group="Properties",
            help="The time the compliance state should expire.",
        )
        _args_schema.metadata = AAZDictArg(
            options=["--metadata"],
            arg_group="Properties",
            help="Additional metadata for this attestation",
        )
        _args_schema.owner = AAZStrArg(
            options=["--owner"],
            arg_group="Properties",
            help="The person responsible for setting the state of the resource. This value is typically an Azure Active Directory object ID.",
        )
        _args_schema.policy_assignment_id = AAZStrArg(
            options=["--policy-assignment-id"],
            arg_group="Properties",
            help="The resource ID of the policy assignment that the attestation is setting the state for.",
            required=True,
        )
        _args_schema.policy_definition_reference_id = AAZStrArg(
            options=["--policy-definition-reference-id"],
            arg_group="Properties",
            help="The policy definition reference ID from a policy set definition that the attestation is setting the state for. If the policy assignment assigns a policy set definition the attestation can choose a definition within the set definition with this property or omit this and set the state for the entire set definition.",
        )

        evidence = cls._args_schema.evidence
        evidence.Element = AAZObjectArg()

        _element = cls._args_schema.evidence.Element
        _element.description = AAZStrArg(
            options=["description"],
            help="The description for this piece of evidence.",
        )
        _element.source_uri = AAZStrArg(
            options=["source-uri"],
            help="The URI location of the evidence.",
        )

        metadata = cls._args_schema.metadata
        metadata.Element = AAZStrArg()
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.AttestationsCreateOrUpdateAtSubscription(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class AttestationsCreateOrUpdateAtSubscription(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/attestations/{attestationName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "attestationName", self.ctx.args.attestation_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-09-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("properties", AAZObjectType, ".", typ_kwargs={"flags": {"required": True, "client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("assessmentDate", AAZStrType, ".assessment_date")
                properties.set_prop("comments", AAZStrType, ".comments")
                properties.set_prop("complianceState", AAZStrType, ".compliance_state")
                properties.set_prop("evidence", AAZListType, ".evidence")
                properties.set_prop("expiresOn", AAZStrType, ".expires_on")
                properties.set_prop("metadata", AAZDictType, ".metadata")
                properties.set_prop("owner", AAZStrType, ".owner")
                properties.set_prop("policyAssignmentId", AAZStrType, ".policy_assignment_id", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("policyDefinitionReferenceId", AAZStrType, ".policy_definition_reference_id")

            evidence = _builder.get(".properties.evidence")
            if evidence is not None:
                evidence.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.evidence[]")
            if _elements is not None:
                _elements.set_prop("description", AAZStrType, ".description")
                _elements.set_prop("sourceUri", AAZStrType, ".source_uri")

            metadata = _builder.get(".properties.metadata")
            if metadata is not None:
                metadata.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType(
                flags={"required": True, "client_flatten": True},
            )
            _schema_on_200_201.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties
            properties.assessment_date = AAZStrType(
                serialized_name="assessmentDate",
            )
            properties.comments = AAZStrType()
            properties.compliance_state = AAZStrType(
                serialized_name="complianceState",
            )
            properties.evidence = AAZListType()
            properties.expires_on = AAZStrType(
                serialized_name="expiresOn",
            )
            properties.last_compliance_state_change_at = AAZStrType(
                serialized_name="lastComplianceStateChangeAt",
                flags={"read_only": True},
            )
            properties.metadata = AAZDictType()
            properties.owner = AAZStrType()
            properties.policy_assignment_id = AAZStrType(
                serialized_name="policyAssignmentId",
                flags={"required": True},
            )
            properties.policy_definition_reference_id = AAZStrType(
                serialized_name="policyDefinitionReferenceId",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )

            evidence = cls._schema_on_200_201.properties.evidence
            evidence.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.evidence.Element
            _element.description = AAZStrType()
            _element.source_uri = AAZStrType(
                serialized_name="sourceUri",
            )

            metadata = cls._schema_on_200_201.properties.metadata
            metadata.Element = AAZStrType()

            system_data = cls._schema_on_200_201.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            return cls._schema_on_200_201


class _CreateBySubscriptionHelper:
    """Helper class for CreateBySubscription"""


__all__ = ["CreateBySubscription"]
