/* Indicator.c generated by valac 0.56.17, the Vala compiler
 * generated from Indicator.vala, do not modify */

/*
 * Copyright (c) 2011-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#include "session.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <wingpanel.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <granite.h>
#include <gmodule.h>

#define SESSION_INDICATOR_ICON_NAME "system-shutdown-symbolic"
#define SESSION_INDICATOR_KEYBINDING_SCHEMA "org.gnome.settings-daemon.plugins.media-keys"
#define SESSION_GETTEXT_PACKAGE "session-indicator"
#define SESSION_LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_LOCK_INTERFACE (lock_interface_get_type ())
#define LOCK_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCK_INTERFACE, LockInterface))
#define IS_LOCK_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCK_INTERFACE))
#define LOCK_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_LOCK_INTERFACE, LockInterfaceIface))

typedef struct _LockInterface LockInterface;
typedef struct _LockInterfaceIface LockInterfaceIface;

#define TYPE_LOCK_INTERFACE_PROXY (lock_interface_proxy_get_type ())

#define TYPE_SESSION_INTERFACE (session_interface_get_type ())
#define SESSION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SESSION_INTERFACE, SessionInterface))
#define IS_SESSION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SESSION_INTERFACE))
#define SESSION_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SESSION_INTERFACE, SessionInterfaceIface))

typedef struct _SessionInterface SessionInterface;
typedef struct _SessionInterfaceIface SessionInterfaceIface;

#define TYPE_SESSION_INTERFACE_PROXY (session_interface_proxy_get_type ())

#define TYPE_SYSTEM_INTERFACE (system_interface_get_type ())
#define SYSTEM_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_INTERFACE, SystemInterface))
#define IS_SYSTEM_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_INTERFACE))
#define SYSTEM_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SYSTEM_INTERFACE, SystemInterfaceIface))

typedef struct _SystemInterface SystemInterface;
typedef struct _SystemInterfaceIface SystemInterfaceIface;

#define TYPE_SYSTEM_INTERFACE_PROXY (system_interface_proxy_get_type ())

#define TYPE_USER_INFO (user_info_get_type ())
typedef struct _UserInfo UserInfo;
enum  {
	SESSION_INDICATOR_0_PROPERTY,
	SESSION_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* session_indicator_properties[SESSION_INDICATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SessionIndicatorInitInterfacesData SessionIndicatorInitInterfacesData;
typedef struct _Block2Data Block2Data;
typedef struct _SessionIndicatorUpdateTooltipData SessionIndicatorUpdateTooltipData;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _LockInterfaceIface {
	GTypeInterface parent_iface;
	void (*lock) (LockInterface* self, GError** error);
};

struct _SessionInterfaceIface {
	GTypeInterface parent_iface;
	void (*logout) (SessionInterface* self, guint type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*logout_finish) (SessionInterface* self, GAsyncResult* _res_, GError** error);
	void (*reboot) (SessionInterface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*reboot_finish) (SessionInterface* self, GAsyncResult* _res_, GError** error);
	void (*shutdown) (SessionInterface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*shutdown_finish) (SessionInterface* self, GAsyncResult* _res_, GError** error);
};

struct _UserInfo {
	guint32 uid;
	gchar* user_name;
	char* user_object;
};

struct _SystemInterfaceIface {
	GTypeInterface parent_iface;
	void (*suspend) (SystemInterface* self, gboolean interactive, GError** error);
	void (*reboot) (SystemInterface* self, gboolean interactive, GError** error);
	void (*power_off) (SystemInterface* self, gboolean interactive, GError** error);
	UserInfo* (*list_users) (SystemInterface* self, gint* result_length1, GError** error);
};

struct _SessionIndicatorPrivate {
	LockInterface* lock_interface;
	SessionInterface* session_interface;
	SystemInterface* system_interface;
	WingpanelIndicatorManagerServerType server_type;
	GtkImage* indicator_icon;
	GtkModelButton* lock_screen;
	GtkModelButton* suspend;
	GtkModelButton* shutdown;
	GtkModelButton* log_out;
	SessionServicesUserManager* manager;
	SessionWidgetsEndSessionDialog* current_dialog;
	GtkBox* main_box;
	gchar* active_user_real_name;
};

struct _Block1Data {
	int _ref_count_;
	SessionIndicator* self;
	GraniteAccelLabel* log_out_grid;
	GraniteAccelLabel* lock_screen_grid;
};

struct _SessionIndicatorInitInterfacesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SessionIndicator* self;
	SystemInterface* _tmp0_;
	SystemInterface* _tmp1_;
	SystemInterface* _tmp2_;
	GtkModelButton* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GtkModelButton* _tmp6_;
	LockInterface* _tmp7_;
	LockInterface* _tmp8_;
	LockInterface* _tmp9_;
	GtkModelButton* _tmp10_;
	GError* _vala1_e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	SessionInterface* _tmp13_;
	SessionInterface* _tmp14_;
	SessionInterface* _tmp15_;
	GtkModelButton* _tmp16_;
	GtkModelButton* _tmp17_;
	GError* _vala2_e;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	SessionIndicator* self;
	SessionEndSessionDialogServer* server;
};

struct _SessionIndicatorUpdateTooltipData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SessionIndicator* self;
	gchar* description;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint n_online_users;
	SessionServicesUserManager* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* accel_label;
	gchar* _tmp11_;
	GtkImage* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
};

static gint SessionIndicator_private_offset;
static gpointer session_indicator_parent_class = NULL;
static GSettings* session_indicator_keybinding_settings;
static GSettings* session_indicator_keybinding_settings = NULL;

VALA_EXTERN GType lock_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint lock_interface_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
VALA_EXTERN GType lock_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType session_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint session_interface_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN GType session_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType system_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint system_interface_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType user_info_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UserInfo* user_info_dup (const UserInfo* self);
VALA_EXTERN void user_info_free (UserInfo* self);
VALA_EXTERN void user_info_copy (const UserInfo* self,
                     UserInfo* dest);
VALA_EXTERN void user_info_destroy (UserInfo* self);
VALA_EXTERN GType system_interface_get_type (void) G_GNUC_CONST ;
static void __lambda17_ (SessionIndicator* self,
                  guint type);
static void session_indicator_show_dialog (SessionIndicator* self,
                                    SessionWidgetsEndSessionDialogType type);
static void ___lambda17__session_end_session_dialog_server_show_dialog (SessionEndSessionDialogServer* _sender,
                                                                 guint type,
                                                                 gpointer self);
static GtkWidget* session_indicator_real_get_display_widget (WingpanelIndicator* base);
static void ___lambda23_ (SessionIndicator* self);
static void session_indicator_update_tooltip (SessionIndicator* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static void session_indicator_update_tooltip_finish (SessionIndicator* self,
                                              GAsyncResult* _res_);
static void ____lambda23__session_services_user_manager_changed (SessionServicesUserManager* _sender,
                                                          gpointer self);
static gboolean ___lambda24_ (SessionIndicator* self,
                       GdkEventButton* e);
static void session_indicator_init_interfaces (SessionIndicator* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void session_indicator_init_interfaces_finish (SessionIndicator* self,
                                               GAsyncResult* _res_);
static void ____lambda25_ (SessionIndicator* self,
                    GObject* obj,
                    GAsyncResult* res);
static void session_indicator_show_shutdown_dialog (SessionIndicator* self);
static void _____lambda25__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static gboolean ____lambda24__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static GtkWidget* session_indicator_real_get_widget (WingpanelIndicator* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _____lambda27_ (Block1Data* _data1_);
static void ______lambda27__g_settings_changed (GSettings* _sender,
                                         const gchar* key,
                                         gpointer self);
static void _____lambda28_ (Block1Data* _data1_);
static void ______lambda28__g_settings_changed (GSettings* _sender,
                                         const gchar* key,
                                         gpointer self);
static void ______lambda29_ (Block1Data* _data1_);
static void _______lambda29__g_settings_changed (GSettings* _sender,
                                          const gchar* key,
                                          gpointer self);
static void ______lambda30_ (Block1Data* _data1_);
static void _______lambda30__g_settings_changed (GSettings* _sender,
                                          const gchar* key,
                                          gpointer self);
static void ___lambda31_ (SessionIndicator* self);
static void ____lambda31__session_services_user_manager_close (SessionServicesUserManager* _sender,
                                                        gpointer self);
static void ___lambda32_ (SessionIndicator* self);
static void ____lambda32__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void ___lambda33_ (SessionIndicator* self);
static void ____lambda33__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void ___lambda34_ (SessionIndicator* self);
VALA_EXTERN void system_interface_suspend (SystemInterface* self,
                               gboolean interactive,
                               GError** error);
static void ____lambda34__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void ___lambda35_ (SessionIndicator* self);
VALA_EXTERN void session_interface_logout (SessionInterface* self,
                               guint type,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN void session_interface_logout_finish (SessionInterface* self,
                                      GAsyncResult* _res_,
                                      GError** error);
static void __lambda36_ (SessionIndicator* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda36__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ____lambda35__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void ___lambda37_ (SessionIndicator* self);
VALA_EXTERN void lock_interface_lock (LockInterface* self,
                          GError** error);
static void ____lambda37__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
VALA_EXTERN void session_interface_reboot (SessionInterface* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN void session_interface_reboot_finish (SessionInterface* self,
                                      GAsyncResult* _res_,
                                      GError** error);
static void ___lambda26_ (SessionIndicator* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda26__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void session_indicator_init_interfaces_data_free (gpointer _data);
static gboolean session_indicator_init_interfaces_co (SessionIndicatorInitInterfacesData* _data_);
static void session_indicator_init_interfaces_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void session_indicator_real_opened (WingpanelIndicator* base);
static void session_indicator_real_closed (WingpanelIndicator* base);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda18_ (Block2Data* _data2_);
static void ___lambda18__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
static void __lambda19_ (Block2Data* _data2_);
static void ___lambda19__session_widgets_end_session_dialog_cancelled (SessionWidgetsEndSessionDialog* _sender,
                                                                gpointer self);
static void __lambda20_ (Block2Data* _data2_);
static void ___lambda20__session_widgets_end_session_dialog_logout (SessionWidgetsEndSessionDialog* _sender,
                                                             gpointer self);
static void __lambda21_ (Block2Data* _data2_);
VALA_EXTERN void system_interface_power_off (SystemInterface* self,
                                 gboolean interactive,
                                 GError** error);
static void ___lambda21__session_widgets_end_session_dialog_shutdown (SessionWidgetsEndSessionDialog* _sender,
                                                               gpointer self);
static void __lambda22_ (Block2Data* _data2_);
VALA_EXTERN void system_interface_reboot (SystemInterface* self,
                              gboolean interactive,
                              GError** error);
static void ___lambda22__session_widgets_end_session_dialog_reboot (SessionWidgetsEndSessionDialog* _sender,
                                                             gpointer self);
static void session_indicator_update_tooltip_data_free (gpointer _data);
static gboolean session_indicator_update_tooltip_co (SessionIndicatorUpdateTooltipData* _data_);
static void session_indicator_update_tooltip_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void session_indicator_finalize (GObject * obj);
static GType session_indicator_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
session_indicator_get_instance_private (SessionIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, SessionIndicator_private_offset);
}

static void
__lambda17_ (SessionIndicator* self,
             guint type)
{
	session_indicator_show_dialog (self, (SessionWidgetsEndSessionDialogType) type);
}

static void
___lambda17__session_end_session_dialog_server_show_dialog (SessionEndSessionDialogServer* _sender,
                                                            guint type,
                                                            gpointer self)
{
	__lambda17_ ((SessionIndicator*) self, type);
}

SessionIndicator*
session_indicator_construct (GType object_type,
                             WingpanelIndicatorManagerServerType server_type)
{
	SessionIndicator * self = NULL;
	SessionEndSessionDialogServer* _tmp0_;
	SessionServicesUserManager* _tmp1_;
	bindtextdomain (SESSION_GETTEXT_PACKAGE, SESSION_LOCALEDIR);
	bind_textdomain_codeset (SESSION_GETTEXT_PACKAGE, "UTF-8");
	self = (SessionIndicator*) g_object_new (object_type, "code-name", WINGPANEL_INDICATOR_SESSION, NULL);
	self->priv->server_type = server_type;
	wingpanel_indicator_set_visible ((WingpanelIndicator*) self, TRUE);
	session_end_session_dialog_server_init ();
	_tmp0_ = session_end_session_dialog_server_get_default ();
	g_signal_connect_object (_tmp0_, "show-dialog", (GCallback) ___lambda17__session_end_session_dialog_server_show_dialog, self, 0);
	_tmp1_ = session_services_user_manager_new ();
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp1_;
	return self;
}

SessionIndicator*
session_indicator_new (WingpanelIndicatorManagerServerType server_type)
{
	return session_indicator_construct (SESSION_TYPE_INDICATOR, server_type);
}

static void
___lambda23_ (SessionIndicator* self)
{
	session_indicator_update_tooltip (self, NULL, NULL);
}

static void
____lambda23__session_services_user_manager_changed (SessionServicesUserManager* _sender,
                                                     gpointer self)
{
	___lambda23_ ((SessionIndicator*) self);
}

static void
____lambda25_ (SessionIndicator* self,
               GObject* obj,
               GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	session_indicator_init_interfaces_finish (self, res);
	session_indicator_show_shutdown_dialog (self);
}

static void
_____lambda25__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda25_ ((SessionIndicator*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
___lambda24_ (SessionIndicator* self,
              GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button == ((guint) GDK_BUTTON_MIDDLE)) {
		SessionInterface* _tmp0_;
		_tmp0_ = self->priv->session_interface;
		if (_tmp0_ == NULL) {
			session_indicator_init_interfaces (self, _____lambda25__gasync_ready_callback, g_object_ref (self));
		} else {
			session_indicator_show_shutdown_dialog (self);
		}
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
____lambda24__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = ___lambda24_ ((SessionIndicator*) self, event);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
session_indicator_real_get_display_widget (WingpanelIndicator* base)
{
	SessionIndicator * self;
	GtkImage* _tmp0_;
	GtkImage* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* result;
	self = (SessionIndicator*) base;
	_tmp0_ = self->priv->indicator_icon;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		GtkImage* _tmp2_ = NULL;
		SessionServicesUserManager* _tmp3_;
		GtkImage* _tmp4_;
		_tmp1_ = g_strdup (SESSION_INDICATOR_ICON_NAME);
		_tmp2_ = (GtkImage*) gtk_image_new ();
		g_object_set (_tmp2_, "icon-name", _tmp1_, NULL);
		_g_free0 (_tmp1_);
		gtk_image_set_pixel_size (_tmp2_, 24);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->indicator_icon);
		self->priv->indicator_icon = _tmp2_;
		_tmp3_ = self->priv->manager;
		g_signal_connect_object (_tmp3_, "changed", (GCallback) ____lambda23__session_services_user_manager_changed, self, 0);
		_tmp4_ = self->priv->indicator_icon;
		g_signal_connect_object ((GtkWidget*) _tmp4_, "button-press-event", (GCallback) ____lambda24__gtk_widget_button_press_event, self, 0);
	}
	_tmp5_ = self->priv->indicator_icon;
	_tmp6_ = _g_object_ref0 ((GtkWidget*) _tmp5_);
	result = _tmp6_;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SessionIndicator* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->lock_screen_grid);
		_g_object_unref0 (_data1_->log_out_grid);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_____lambda27_ (Block1Data* _data1_)
{
	SessionIndicator* self;
	GraniteAccelLabel* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = _data1_->self;
	_tmp0_ = _data1_->log_out_grid;
	_tmp1_ = session_indicator_keybinding_settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "logout");
	_tmp3_ = _tmp2_;
	granite_accel_label_set_accel_string (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
}

static void
______lambda27__g_settings_changed (GSettings* _sender,
                                    const gchar* key,
                                    gpointer self)
{
	_____lambda27_ (self);
}

static void
_____lambda28_ (Block1Data* _data1_)
{
	SessionIndicator* self;
	GraniteAccelLabel* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = _data1_->self;
	_tmp0_ = _data1_->lock_screen_grid;
	_tmp1_ = session_indicator_keybinding_settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "screensaver");
	_tmp3_ = _tmp2_;
	granite_accel_label_set_accel_string (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
}

static void
______lambda28__g_settings_changed (GSettings* _sender,
                                    const gchar* key,
                                    gpointer self)
{
	_____lambda28_ (self);
}

static void
______lambda29_ (Block1Data* _data1_)
{
	SessionIndicator* self;
	GraniteAccelLabel* _tmp0_;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	self = _data1_->self;
	_tmp0_ = _data1_->log_out_grid;
	_tmp1_ = session_indicator_keybinding_settings;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "logout");
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_tmp5_ = _tmp4_[0];
	granite_accel_label_set_accel_string (_tmp0_, _tmp5_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
}

static void
_______lambda29__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self)
{
	______lambda29_ (self);
}

static void
______lambda30_ (Block1Data* _data1_)
{
	SessionIndicator* self;
	GraniteAccelLabel* _tmp0_;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	self = _data1_->self;
	_tmp0_ = _data1_->lock_screen_grid;
	_tmp1_ = session_indicator_keybinding_settings;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "screensaver");
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_tmp5_ = _tmp4_[0];
	granite_accel_label_set_accel_string (_tmp0_, _tmp5_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
}

static void
_______lambda30__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self)
{
	______lambda30_ (self);
}

static void
___lambda31_ (SessionIndicator* self)
{
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
}

static void
____lambda31__session_services_user_manager_close (SessionServicesUserManager* _sender,
                                                   gpointer self)
{
	___lambda31_ ((SessionIndicator*) self);
}

static void
___lambda32_ (SessionIndicator* self)
{
	GError* _inner_error0_ = NULL;
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
	{
		g_app_info_launch_default_for_uri ("settings://accounts", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("Indicator.vala:200: Failed to open user accounts settings: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda32__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda32_ ((SessionIndicator*) self);
}

static void
___lambda33_ (SessionIndicator* self)
{
	session_indicator_show_shutdown_dialog (self);
}

static void
____lambda33__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda33_ ((SessionIndicator*) self);
}

static void
___lambda34_ (SessionIndicator* self)
{
	GError* _inner_error0_ = NULL;
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
	{
		SystemInterface* _tmp0_;
		_tmp0_ = self->priv->system_interface;
		system_interface_suspend (_tmp0_, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("Indicator.vala:214: Unable to suspend: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda34__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda34_ ((SessionIndicator*) self);
}

static void
__lambda36_ (SessionIndicator* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		SessionInterface* _tmp0_;
		_tmp0_ = self->priv->session_interface;
		session_interface_logout_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		if (!g_error_matches (_tmp1_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			GError* _tmp2_;
			const gchar* _tmp3_;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			g_warning ("Indicator.vala:224: Unable to open logout dialog: %s", _tmp3_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda36__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda36_ ((SessionIndicator*) self, source_object, res);
	g_object_unref (self);
}

static void
___lambda35_ (SessionIndicator* self)
{
	SessionInterface* _tmp0_;
	_tmp0_ = self->priv->session_interface;
	session_interface_logout (_tmp0_, (guint) 0, ___lambda36__gasync_ready_callback, g_object_ref (self));
}

static void
____lambda35__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda35_ ((SessionIndicator*) self);
}

static void
___lambda37_ (SessionIndicator* self)
{
	GError* _inner_error0_ = NULL;
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
	{
		LockInterface* _tmp0_;
		_tmp0_ = self->priv->lock_interface;
		lock_interface_lock (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("Indicator.vala:236: Unable to lock: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda37__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda37_ ((SessionIndicator*) self);
}

static GtkWidget*
session_indicator_real_get_widget (WingpanelIndicator* base)
{
	SessionIndicator * self;
	GtkBox* _tmp0_;
	GtkBox* _tmp83_;
	GtkWidget* _tmp84_;
	GtkWidget* result;
	self = (SessionIndicator*) base;
	_tmp0_ = self->priv->main_box;
	if (_tmp0_ == NULL) {
		Block1Data* _data1_;
		GtkBox* _tmp1_;
		GtkModelButton* user_settings = NULL;
		gchar* _tmp2_;
		GtkModelButton* _tmp3_ = NULL;
		GraniteAccelLabel* _tmp4_;
		GtkModelButton* _tmp5_ = NULL;
		GtkModelButton* _tmp6_;
		GtkWidget* _tmp7_;
		GtkModelButton* _tmp8_;
		GraniteAccelLabel* _tmp9_;
		GraniteAccelLabel* _tmp10_;
		GtkModelButton* _tmp11_ = NULL;
		GtkModelButton* _tmp12_;
		GtkWidget* _tmp13_;
		GtkModelButton* _tmp14_;
		GraniteAccelLabel* _tmp15_;
		gchar* _tmp16_;
		GtkModelButton* _tmp17_ = NULL;
		gchar* _tmp18_;
		GtkModelButton* _tmp19_ = NULL;
		GtkBox* _tmp39_;
		GtkModelButton* _tmp40_;
		GtkBox* _tmp41_;
		GtkModelButton* _tmp42_;
		GSettings* _tmp43_;
		SessionServicesUserManager* _tmp77_;
		GtkModelButton* _tmp78_;
		GtkModelButton* _tmp79_;
		GtkModelButton* _tmp80_;
		GtkModelButton* _tmp81_;
		GtkModelButton* _tmp82_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = g_object_ref (self);
		session_indicator_init_interfaces (self, NULL, NULL);
		_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->main_box);
		self->priv->main_box = _tmp1_;
		_tmp2_ = g_strdup (_ ("User Accounts Settings…"));
		_tmp3_ = (GtkModelButton*) gtk_model_button_new ();
		g_object_set (_tmp3_, "text", _tmp2_, NULL);
		_g_free0 (_tmp2_);
		g_object_ref_sink (_tmp3_);
		user_settings = _tmp3_;
		_tmp4_ = granite_accel_label_new (_ ("Log Out…"), NULL);
		g_object_ref_sink (_tmp4_);
		_data1_->log_out_grid = _tmp4_;
		_tmp5_ = (GtkModelButton*) gtk_model_button_new ();
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->log_out);
		self->priv->log_out = _tmp5_;
		_tmp6_ = self->priv->log_out;
		_tmp7_ = gtk_bin_get_child ((GtkBin*) _tmp6_);
		gtk_widget_destroy (_tmp7_);
		_tmp8_ = self->priv->log_out;
		_tmp9_ = _data1_->log_out_grid;
		gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
		_tmp10_ = granite_accel_label_new (_ ("Lock"), NULL);
		g_object_ref_sink (_tmp10_);
		_data1_->lock_screen_grid = _tmp10_;
		_tmp11_ = (GtkModelButton*) gtk_model_button_new ();
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
		g_object_ref_sink (_tmp11_);
		_g_object_unref0 (self->priv->lock_screen);
		self->priv->lock_screen = _tmp11_;
		_tmp12_ = self->priv->lock_screen;
		_tmp13_ = gtk_bin_get_child ((GtkBin*) _tmp12_);
		gtk_widget_destroy (_tmp13_);
		_tmp14_ = self->priv->lock_screen;
		_tmp15_ = _data1_->lock_screen_grid;
		gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
		_tmp16_ = g_strdup (_ ("Shut Down…"));
		_tmp17_ = (GtkModelButton*) gtk_model_button_new ();
		gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, TRUE);
		g_object_set (_tmp17_, "text", _tmp16_, NULL);
		_g_free0 (_tmp16_);
		g_object_ref_sink (_tmp17_);
		_g_object_unref0 (self->priv->shutdown);
		self->priv->shutdown = _tmp17_;
		_tmp18_ = g_strdup (_ ("Suspend"));
		_tmp19_ = (GtkModelButton*) gtk_model_button_new ();
		gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, FALSE);
		g_object_set (_tmp19_, "text", _tmp18_, NULL);
		_g_free0 (_tmp18_);
		g_object_ref_sink (_tmp19_);
		_g_object_unref0 (self->priv->suspend);
		self->priv->suspend = _tmp19_;
		if (self->priv->server_type == WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION) {
			GtkSeparator* users_separator = NULL;
			GtkSeparator* _tmp20_ = NULL;
			GtkSeparator* logout_separator = NULL;
			GtkSeparator* _tmp21_ = NULL;
			GtkScrolledWindow* scrolled_box = NULL;
			GtkScrolledWindow* _tmp22_ = NULL;
			GtkScrolledWindow* _tmp23_;
			SessionServicesUserManager* _tmp24_;
			SessionWidgetsUserListBox* _tmp25_;
			SessionWidgetsUserListBox* _tmp26_;
			GtkBox* _tmp27_;
			GtkScrolledWindow* _tmp28_;
			GtkBox* _tmp29_;
			GtkModelButton* _tmp30_;
			GtkBox* _tmp31_;
			GtkSeparator* _tmp32_;
			GtkBox* _tmp33_;
			GtkModelButton* _tmp34_;
			GtkBox* _tmp35_;
			GtkModelButton* _tmp36_;
			GtkBox* _tmp37_;
			GtkSeparator* _tmp38_;
			_tmp20_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
			gtk_widget_set_margin_top ((GtkWidget*) _tmp20_, 3);
			gtk_widget_set_margin_bottom ((GtkWidget*) _tmp20_, 3);
			g_object_ref_sink (_tmp20_);
			users_separator = _tmp20_;
			_tmp21_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
			gtk_widget_set_margin_top ((GtkWidget*) _tmp21_, 3);
			gtk_widget_set_margin_bottom ((GtkWidget*) _tmp21_, 3);
			g_object_ref_sink (_tmp21_);
			logout_separator = _tmp21_;
			_tmp22_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
			gtk_widget_set_hexpand ((GtkWidget*) _tmp22_, TRUE);
			g_object_set (_tmp22_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
			gtk_scrolled_window_set_max_content_height (_tmp22_, 300);
			gtk_scrolled_window_set_propagate_natural_height (_tmp22_, TRUE);
			g_object_ref_sink (_tmp22_);
			scrolled_box = _tmp22_;
			_tmp23_ = scrolled_box;
			_tmp24_ = self->priv->manager;
			_tmp25_ = session_services_user_manager_get_user_grid (_tmp24_);
			_tmp26_ = _tmp25_;
			gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp26_);
			_tmp27_ = self->priv->main_box;
			_tmp28_ = scrolled_box;
			gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
			_tmp29_ = self->priv->main_box;
			_tmp30_ = user_settings;
			gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
			_tmp31_ = self->priv->main_box;
			_tmp32_ = users_separator;
			gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
			_tmp33_ = self->priv->main_box;
			_tmp34_ = self->priv->lock_screen;
			gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
			_tmp35_ = self->priv->main_box;
			_tmp36_ = self->priv->log_out;
			gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
			_tmp37_ = self->priv->main_box;
			_tmp38_ = logout_separator;
			gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
			_g_object_unref0 (scrolled_box);
			_g_object_unref0 (logout_separator);
			_g_object_unref0 (users_separator);
		}
		_tmp39_ = self->priv->main_box;
		_tmp40_ = self->priv->suspend;
		gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
		_tmp41_ = self->priv->main_box;
		_tmp42_ = self->priv->shutdown;
		gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
		_tmp43_ = session_indicator_keybinding_settings;
		if (_tmp43_ != NULL) {
			const GVariantType* key_type = NULL;
			GSettings* _tmp44_;
			GVariant* _tmp45_;
			GVariant* _tmp46_;
			const GVariantType* _tmp47_;
			const GVariantType* _tmp48_;
			const GVariantType* _tmp49_;
			const GVariantType* _tmp50_;
			_tmp44_ = session_indicator_keybinding_settings;
			_tmp45_ = g_settings_get_value (_tmp44_, "logout");
			_tmp46_ = _tmp45_;
			_tmp47_ = g_variant_get_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_g_variant_unref0 (_tmp46_);
			key_type = _tmp48_;
			_tmp49_ = key_type;
			_tmp50_ = G_VARIANT_TYPE_STRING;
			if (g_variant_type_equal (_tmp49_, _tmp50_)) {
				GraniteAccelLabel* _tmp51_;
				GSettings* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				GraniteAccelLabel* _tmp55_;
				GSettings* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				GSettings* _tmp59_;
				GSettings* _tmp60_;
				_tmp51_ = _data1_->log_out_grid;
				_tmp52_ = session_indicator_keybinding_settings;
				_tmp53_ = g_settings_get_string (_tmp52_, "logout");
				_tmp54_ = _tmp53_;
				granite_accel_label_set_accel_string (_tmp51_, _tmp54_);
				_g_free0 (_tmp54_);
				_tmp55_ = _data1_->lock_screen_grid;
				_tmp56_ = session_indicator_keybinding_settings;
				_tmp57_ = g_settings_get_string (_tmp56_, "screensaver");
				_tmp58_ = _tmp57_;
				granite_accel_label_set_accel_string (_tmp55_, _tmp58_);
				_g_free0 (_tmp58_);
				_tmp59_ = session_indicator_keybinding_settings;
				g_signal_connect_data (_tmp59_, "changed::logout", (GCallback) ______lambda27__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
				_tmp60_ = session_indicator_keybinding_settings;
				g_signal_connect_data (_tmp60_, "changed::screensaver", (GCallback) ______lambda28__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
			} else {
				const GVariantType* _tmp61_;
				const GVariantType* _tmp62_;
				_tmp61_ = key_type;
				_tmp62_ = G_VARIANT_TYPE_STRING_ARRAY;
				if (g_variant_type_equal (_tmp61_, _tmp62_)) {
					GraniteAccelLabel* _tmp63_;
					GSettings* _tmp64_;
					gchar** _tmp65_;
					gchar** _tmp66_;
					gchar** _tmp67_;
					gint _tmp67__length1;
					const gchar* _tmp68_;
					GraniteAccelLabel* _tmp69_;
					GSettings* _tmp70_;
					gchar** _tmp71_;
					gchar** _tmp72_;
					gchar** _tmp73_;
					gint _tmp73__length1;
					const gchar* _tmp74_;
					GSettings* _tmp75_;
					GSettings* _tmp76_;
					_tmp63_ = _data1_->log_out_grid;
					_tmp64_ = session_indicator_keybinding_settings;
					_tmp66_ = _tmp65_ = g_settings_get_strv (_tmp64_, "logout");
					_tmp67_ = _tmp66_;
					_tmp67__length1 = _vala_array_length (_tmp65_);
					_tmp68_ = _tmp67_[0];
					granite_accel_label_set_accel_string (_tmp63_, _tmp68_);
					_tmp67_ = (_vala_array_free (_tmp67_, _tmp67__length1, (GDestroyNotify) g_free), NULL);
					_tmp69_ = _data1_->lock_screen_grid;
					_tmp70_ = session_indicator_keybinding_settings;
					_tmp72_ = _tmp71_ = g_settings_get_strv (_tmp70_, "screensaver");
					_tmp73_ = _tmp72_;
					_tmp73__length1 = _vala_array_length (_tmp71_);
					_tmp74_ = _tmp73_[0];
					granite_accel_label_set_accel_string (_tmp69_, _tmp74_);
					_tmp73_ = (_vala_array_free (_tmp73_, _tmp73__length1, (GDestroyNotify) g_free), NULL);
					_tmp75_ = session_indicator_keybinding_settings;
					g_signal_connect_data (_tmp75_, "changed::logout", (GCallback) _______lambda29__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
					_tmp76_ = session_indicator_keybinding_settings;
					g_signal_connect_data (_tmp76_, "changed::screensaver", (GCallback) _______lambda30__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
				}
			}
		}
		_tmp77_ = self->priv->manager;
		g_signal_connect_object (_tmp77_, "close", (GCallback) ____lambda31__session_services_user_manager_close, self, 0);
		_tmp78_ = user_settings;
		g_signal_connect_object ((GtkButton*) _tmp78_, "clicked", (GCallback) ____lambda32__gtk_button_clicked, self, 0);
		_tmp79_ = self->priv->shutdown;
		g_signal_connect_object ((GtkButton*) _tmp79_, "clicked", (GCallback) ____lambda33__gtk_button_clicked, self, 0);
		_tmp80_ = self->priv->suspend;
		g_signal_connect_object ((GtkButton*) _tmp80_, "clicked", (GCallback) ____lambda34__gtk_button_clicked, self, 0);
		_tmp81_ = self->priv->log_out;
		g_signal_connect_object ((GtkButton*) _tmp81_, "clicked", (GCallback) ____lambda35__gtk_button_clicked, self, 0);
		_tmp82_ = self->priv->lock_screen;
		g_signal_connect_object ((GtkButton*) _tmp82_, "clicked", (GCallback) ____lambda37__gtk_button_clicked, self, 0);
		_g_object_unref0 (user_settings);
		block1_data_unref (_data1_);
		_data1_ = NULL;
	}
	_tmp83_ = self->priv->main_box;
	_tmp84_ = _g_object_ref0 ((GtkWidget*) _tmp83_);
	result = _tmp84_;
	return result;
}

static void
___lambda26_ (SessionIndicator* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		SessionInterface* _tmp0_;
		_tmp0_ = self->priv->session_interface;
		session_interface_reboot_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		if (!g_error_matches (_tmp1_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			GError* _tmp2_;
			const gchar* _tmp3_;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			g_critical ("Indicator.vala:255: Unable to open shutdown dialog: %s", _tmp3_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda26__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda26_ ((SessionIndicator*) self, source_object, res);
	g_object_unref (self);
}

static void
session_indicator_show_shutdown_dialog (SessionIndicator* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
	if (self->priv->server_type == WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION) {
		SessionInterface* _tmp0_;
		_tmp0_ = self->priv->session_interface;
		session_interface_reboot (_tmp0_, ____lambda26__gasync_ready_callback, g_object_ref (self));
	} else {
		session_indicator_show_dialog (self, SESSION_WIDGETS_END_SESSION_DIALOG_TYPE_RESTART);
	}
}

static void
session_indicator_init_interfaces_data_free (gpointer _data)
{
	SessionIndicatorInitInterfacesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SessionIndicatorInitInterfacesData, _data_);
}

static void
session_indicator_init_interfaces (SessionIndicator* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	SessionIndicatorInitInterfacesData* _data_;
	SessionIndicator* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SessionIndicatorInitInterfacesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, session_indicator_init_interfaces_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	session_indicator_init_interfaces_co (_data_);
}

static void
session_indicator_init_interfaces_finish (SessionIndicator* self,
                                          GAsyncResult* _res_)
{
	SessionIndicatorInitInterfacesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
session_indicator_init_interfaces_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	SessionIndicatorInitInterfacesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	session_indicator_init_interfaces_co (_data_);
}

static gboolean
session_indicator_init_interfaces_co (SessionIndicatorInitInterfacesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (TYPE_SYSTEM_INTERFACE_PROXY, 0, NULL, session_indicator_init_interfaces_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.login1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/login1", "g-interface-name", "org.freedesktop.login1.Manager", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (SystemInterface*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (SystemInterface*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->system_interface);
		_data_->self->priv->system_interface = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->self->priv->suspend;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp3_, TRUE);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_critical ("Indicator.vala:269: Unable to connect to the login interface: %s", _data_->_tmp5_);
		_data_->_tmp6_ = _data_->self->priv->suspend;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp6_, FALSE);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->self->priv->server_type == WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION) {
		{
			_data_->_state_ = 2;
			g_async_initable_new_async (TYPE_LOCK_INTERFACE_PROXY, 0, NULL, session_indicator_init_interfaces_ready, _data_, "g-flags", 0, "g-name", "org.gnome.ScreenSaver", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/ScreenSaver", "g-interface-name", "org.gnome.ScreenSaver", NULL);
			return FALSE;
			_state_2:
			_data_->_tmp8_ = (LockInterface*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp7_ = (LockInterface*) _data_->_tmp8_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp9_ = _data_->_tmp7_;
			_data_->_tmp7_ = NULL;
			_g_object_unref0 (_data_->self->priv->lock_interface);
			_data_->self->priv->lock_interface = _data_->_tmp9_;
			_data_->_tmp10_ = _data_->self->priv->lock_screen;
			gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp10_, TRUE);
			_g_object_unref0 (_data_->_tmp7_);
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			_data_->_vala1_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp11_ = _data_->_vala1_e;
			_data_->_tmp12_ = _data_->_tmp11_->message;
			g_warning ("Indicator.vala:278: Unable to connect to lock interface: %s", _data_->_tmp12_);
			_g_error_free0 (_data_->_vala1_e);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_state_ = 3;
			g_async_initable_new_async (TYPE_SESSION_INTERFACE_PROXY, 0, NULL, session_indicator_init_interfaces_ready, _data_, "g-flags", 0, "g-name", "org.gnome.SessionManager", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SessionManager", "g-interface-name", "org.gnome.SessionManager", NULL);
			return FALSE;
			_state_3:
			_data_->_tmp14_ = (SessionInterface*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp13_ = (SessionInterface*) _data_->_tmp14_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch2_g_io_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp15_ = _data_->_tmp13_;
			_data_->_tmp13_ = NULL;
			_g_object_unref0 (_data_->self->priv->session_interface);
			_data_->self->priv->session_interface = _data_->_tmp15_;
			_data_->_tmp16_ = _data_->self->priv->shutdown;
			gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp16_, TRUE);
			_data_->_tmp17_ = _data_->self->priv->log_out;
			gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp17_, TRUE);
			_g_object_unref0 (_data_->_tmp13_);
		}
		goto __finally2;
		__catch2_g_io_error:
		{
			_data_->_vala2_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp18_ = _data_->_vala2_e;
			_data_->_tmp19_ = _data_->_tmp18_->message;
			g_critical ("Indicator.vala:286: Unable to connect to GNOME session interface: %s", _data_->_tmp19_);
			_g_error_free0 (_data_->_vala2_e);
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
session_indicator_real_opened (WingpanelIndicator* base)
{
	SessionIndicator * self;
	GtkBox* _tmp1_;
	self = (SessionIndicator*) base;
	if (self->priv->server_type == WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION) {
		SessionServicesUserManager* _tmp0_;
		_tmp0_ = self->priv->manager;
		session_services_user_manager_update_all (_tmp0_);
	}
	_tmp1_ = self->priv->main_box;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
}

static void
session_indicator_real_closed (WingpanelIndicator* base)
{
	SessionIndicator * self;
	self = (SessionIndicator*) base;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SessionIndicator* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda18_ (Block2Data* _data2_)
{
	SessionIndicator* self;
	SessionEndSessionDialogServer* _tmp0_;
	self = _data2_->self;
	_tmp0_ = _data2_->server;
	g_signal_emit_by_name (_tmp0_, "closed");
	_g_object_unref0 (self->priv->current_dialog);
	self->priv->current_dialog = NULL;
}

static void
___lambda18__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda18_ (self);
}

static void
__lambda19_ (Block2Data* _data2_)
{
	SessionIndicator* self;
	SessionEndSessionDialogServer* _tmp0_;
	self = _data2_->self;
	_tmp0_ = _data2_->server;
	g_signal_emit_by_name (_tmp0_, "canceled");
}

static void
___lambda19__session_widgets_end_session_dialog_cancelled (SessionWidgetsEndSessionDialog* _sender,
                                                           gpointer self)
{
	__lambda19_ (self);
}

static void
__lambda20_ (Block2Data* _data2_)
{
	SessionIndicator* self;
	SessionEndSessionDialogServer* _tmp0_;
	self = _data2_->self;
	_tmp0_ = _data2_->server;
	g_signal_emit_by_name (_tmp0_, "confirmed-logout");
}

static void
___lambda20__session_widgets_end_session_dialog_logout (SessionWidgetsEndSessionDialog* _sender,
                                                        gpointer self)
{
	__lambda20_ (self);
}

static void
__lambda21_ (Block2Data* _data2_)
{
	SessionIndicator* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	if (self->priv->server_type == WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION) {
		SessionEndSessionDialogServer* _tmp0_;
		_tmp0_ = _data2_->server;
		g_signal_emit_by_name (_tmp0_, "confirmed-shutdown");
	} else {
		{
			SystemInterface* _tmp1_;
			_tmp1_ = self->priv->system_interface;
			system_interface_power_off (_tmp1_, FALSE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			g_warning ("Indicator.vala:337: Unable to shutdown: %s", _tmp3_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
___lambda21__session_widgets_end_session_dialog_shutdown (SessionWidgetsEndSessionDialog* _sender,
                                                          gpointer self)
{
	__lambda21_ (self);
}

static void
__lambda22_ (Block2Data* _data2_)
{
	SessionIndicator* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	if (self->priv->server_type == WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION) {
		SessionEndSessionDialogServer* _tmp0_;
		_tmp0_ = _data2_->server;
		g_signal_emit_by_name (_tmp0_, "confirmed-reboot");
	} else {
		{
			SystemInterface* _tmp1_;
			_tmp1_ = self->priv->system_interface;
			system_interface_reboot (_tmp1_, FALSE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			g_warning ("Indicator.vala:349: Unable to reboot: %s", _tmp3_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
___lambda22__session_widgets_end_session_dialog_reboot (SessionWidgetsEndSessionDialog* _sender,
                                                        gpointer self)
{
	__lambda22_ (self);
}

static void
session_indicator_show_dialog (SessionIndicator* self,
                               SessionWidgetsEndSessionDialogType type)
{
	Block2Data* _data2_;
	SessionWidgetsEndSessionDialog* _tmp0_;
	SessionEndSessionDialogServer* _tmp5_;
	GtkImage* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWindow* _tmp8_;
	SessionWidgetsEndSessionDialog* _tmp9_ = NULL;
	SessionWidgetsEndSessionDialog* _tmp10_;
	SessionWidgetsEndSessionDialog* _tmp11_;
	SessionWidgetsEndSessionDialog* _tmp12_;
	SessionWidgetsEndSessionDialog* _tmp13_;
	SessionWidgetsEndSessionDialog* _tmp14_;
	SessionWidgetsEndSessionDialog* _tmp15_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
	_tmp0_ = self->priv->current_dialog;
	if (_tmp0_ != NULL) {
		SessionWidgetsEndSessionDialog* _tmp1_;
		SessionWidgetsEndSessionDialogType _tmp2_;
		SessionWidgetsEndSessionDialogType _tmp3_;
		_tmp1_ = self->priv->current_dialog;
		_tmp2_ = session_widgets_end_session_dialog_get_dialog_type (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != type) {
			SessionWidgetsEndSessionDialog* _tmp4_;
			_tmp4_ = self->priv->current_dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp4_);
		} else {
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return;
		}
	}
	_tmp5_ = session_end_session_dialog_server_get_default ();
	_data2_->server = _tmp5_;
	_tmp6_ = self->priv->indicator_icon;
	_tmp7_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp6_);
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_window_get_type (), GtkWindow));
	_tmp9_ = session_widgets_end_session_dialog_new (type);
	gtk_window_set_transient_for ((GtkWindow*) _tmp9_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->current_dialog);
	self->priv->current_dialog = _tmp9_;
	_tmp10_ = self->priv->current_dialog;
	g_signal_connect_data ((GtkWidget*) _tmp10_, "destroy", (GCallback) ___lambda18__gtk_widget_destroy, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp11_ = self->priv->current_dialog;
	g_signal_connect_data (_tmp11_, "cancelled", (GCallback) ___lambda19__session_widgets_end_session_dialog_cancelled, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp12_ = self->priv->current_dialog;
	g_signal_connect_data (_tmp12_, "logout", (GCallback) ___lambda20__session_widgets_end_session_dialog_logout, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp13_ = self->priv->current_dialog;
	g_signal_connect_data (_tmp13_, "shutdown", (GCallback) ___lambda21__session_widgets_end_session_dialog_shutdown, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp14_ = self->priv->current_dialog;
	g_signal_connect_data (_tmp14_, "reboot", (GCallback) ___lambda22__session_widgets_end_session_dialog_reboot, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp15_ = self->priv->current_dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp15_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
session_indicator_update_tooltip_data_free (gpointer _data)
{
	SessionIndicatorUpdateTooltipData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SessionIndicatorUpdateTooltipData, _data_);
}

static void
session_indicator_update_tooltip (SessionIndicator* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	SessionIndicatorUpdateTooltipData* _data_;
	SessionIndicator* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SessionIndicatorUpdateTooltipData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, session_indicator_update_tooltip_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	session_indicator_update_tooltip_co (_data_);
}

static void
session_indicator_update_tooltip_finish (SessionIndicator* self,
                                         GAsyncResult* _res_)
{
	SessionIndicatorUpdateTooltipData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
session_indicator_update_tooltip_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	SessionIndicatorUpdateTooltipData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	session_indicator_update_tooltip_co (_data_);
}

static gboolean
session_indicator_update_tooltip_co (SessionIndicatorUpdateTooltipData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->server_type == WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION) {
		_data_->_tmp0_ = _data_->self->priv->active_user_real_name;
		if (_data_->_tmp0_ == NULL) {
			_data_->_tmp1_ = g_get_real_name ();
			_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
			_g_free0 (_data_->self->priv->active_user_real_name);
			_data_->self->priv->active_user_real_name = _data_->_tmp2_;
		}
		_data_->_tmp3_ = _data_->self->priv->manager;
		_data_->_state_ = 1;
		session_services_user_manager_get_n_active_and_online_users (_data_->_tmp3_, session_indicator_update_tooltip_ready, _data_);
		return FALSE;
		_state_1:
		_data_->n_online_users = session_services_user_manager_get_n_active_and_online_users_finish (_data_->_tmp3_, _data_->_res_) - 1;
		if (_data_->n_online_users > 0) {
			_data_->_tmp4_ = g_strdup (g_dngettext (SESSION_GETTEXT_PACKAGE, "Logged in as “%s”, %i other user logged in", "Logged in as “%s”, %i other users logged in", (gulong) _data_->n_online_users));
			_g_free0 (_data_->description);
			_data_->description = _data_->_tmp4_;
			_data_->_tmp5_ = _data_->description;
			_data_->_tmp6_ = _data_->self->priv->active_user_real_name;
			_data_->_tmp7_ = g_strdup_printf (_data_->_tmp5_, _data_->_tmp6_, _data_->n_online_users);
			_g_free0 (_data_->description);
			_data_->description = _data_->_tmp7_;
		} else {
			_data_->_tmp8_ = _data_->self->priv->active_user_real_name;
			_data_->_tmp9_ = g_strdup_printf (_ ("Logged in as “%s”"), _data_->_tmp8_);
			_g_free0 (_data_->description);
			_data_->description = _data_->_tmp9_;
		}
	} else {
		_data_->_tmp10_ = g_strdup (_ ("Not logged in"));
		_g_free0 (_data_->description);
		_data_->description = _data_->_tmp10_;
	}
	_data_->_tmp11_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _ ("Middle-click to prompt to shut down"));
	_data_->accel_label = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->self->priv->indicator_icon;
	_data_->_tmp13_ = _data_->description;
	_data_->_tmp14_ = g_strdup_printf ("%s\n%s", _data_->_tmp13_, _data_->accel_label);
	_data_->_tmp15_ = _data_->_tmp14_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _data_->_tmp12_, _data_->_tmp15_);
	_g_free0 (_data_->_tmp15_);
	_g_free0 (_data_->accel_label);
	_g_free0 (_data_->description);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
session_indicator_class_init (SessionIndicatorClass * klass,
                              gpointer klass_data)
{
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	gboolean _tmp3_;
	session_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SessionIndicator_private_offset);
	((WingpanelIndicatorClass *) klass)->get_display_widget = (GtkWidget* (*) (WingpanelIndicator*)) session_indicator_real_get_display_widget;
	((WingpanelIndicatorClass *) klass)->get_widget = (GtkWidget* (*) (WingpanelIndicator*)) session_indicator_real_get_widget;
	((WingpanelIndicatorClass *) klass)->opened = (void (*) (WingpanelIndicator*)) session_indicator_real_opened;
	((WingpanelIndicatorClass *) klass)->closed = (void (*) (WingpanelIndicator*)) session_indicator_real_closed;
	G_OBJECT_CLASS (klass)->finalize = session_indicator_finalize;
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, SESSION_INDICATOR_KEYBINDING_SCHEMA, TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_settings_schema_unref0 (_tmp2_);
	if (_tmp3_) {
		GSettings* _tmp4_;
		_tmp4_ = g_settings_new (SESSION_INDICATOR_KEYBINDING_SCHEMA);
		_g_object_unref0 (session_indicator_keybinding_settings);
		session_indicator_keybinding_settings = _tmp4_;
	}
}

static void
session_indicator_instance_init (SessionIndicator * self,
                                 gpointer klass)
{
	self->priv = session_indicator_get_instance_private (self);
	self->priv->current_dialog = NULL;
}

static void
session_indicator_finalize (GObject * obj)
{
	SessionIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SESSION_TYPE_INDICATOR, SessionIndicator);
	_g_object_unref0 (self->priv->lock_interface);
	_g_object_unref0 (self->priv->session_interface);
	_g_object_unref0 (self->priv->system_interface);
	_g_object_unref0 (self->priv->indicator_icon);
	_g_object_unref0 (self->priv->lock_screen);
	_g_object_unref0 (self->priv->suspend);
	_g_object_unref0 (self->priv->shutdown);
	_g_object_unref0 (self->priv->log_out);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->current_dialog);
	_g_object_unref0 (self->priv->main_box);
	_g_free0 (self->priv->active_user_real_name);
	G_OBJECT_CLASS (session_indicator_parent_class)->finalize (obj);
}

static GType
session_indicator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SessionIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) session_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SessionIndicator), 0, (GInstanceInitFunc) session_indicator_instance_init, NULL };
	GType session_indicator_type_id;
	session_indicator_type_id = g_type_register_static (WINGPANEL_TYPE_INDICATOR, "SessionIndicator", &g_define_type_info, 0);
	SessionIndicator_private_offset = g_type_add_instance_private (session_indicator_type_id, sizeof (SessionIndicatorPrivate));
	return session_indicator_type_id;
}

GType
session_indicator_get_type (void)
{
	static volatile gsize session_indicator_type_id__once = 0;
	if (g_once_init_enter (&session_indicator_type_id__once)) {
		GType session_indicator_type_id;
		session_indicator_type_id = session_indicator_get_type_once ();
		g_once_init_leave (&session_indicator_type_id__once, session_indicator_type_id);
	}
	return session_indicator_type_id__once;
}

WingpanelIndicator*
get_indicator (GModule* module,
               WingpanelIndicatorManagerServerType server_type)
{
	SessionIndicator* indicator = NULL;
	SessionIndicator* _tmp0_;
	WingpanelIndicator* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Indicator.vala:392: Activating Session Indicator");
	_tmp0_ = session_indicator_new (server_type);
	indicator = _tmp0_;
	result = (WingpanelIndicator*) indicator;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

