/*
 * NTDLL error mapping
 *
 * Copyright 2020 Alexandre Julliard
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

/* conversion table, generated by ./make_errors */

static const DWORD error_map[3129] =
{
    ERROR_WAIT_1,                                      /* 00000001 (STATUS_WAIT_1) */
    ERROR_WAIT_2,                                      /* 00000002 (STATUS_WAIT_2) */
    ERROR_WAIT_3,                                      /* 00000003 (STATUS_WAIT_3) */
    ERROR_WAIT_63,                                     /* 0000003f (STATUS_WAIT_63) */
    ERROR_WAIT_NO_CHILDREN,                            /* 00000080 (STATUS_ABANDONED_WAIT_0) */
    ERROR_ABANDONED_WAIT_63,                           /* 000000bf (STATUS_ABANDONED_WAIT_63) */
    ERROR_USER_APC,                                    /* 000000c0 (STATUS_USER_APC) */
    ERROR_KERNEL_APC,                                  /* 00000100 (STATUS_KERNEL_APC) */
    ERROR_ALERTED,                                     /* 00000101 (STATUS_ALERTED) */
    ERROR_TIMEOUT,                                     /* 00000102 (STATUS_TIMEOUT) */
    ERROR_IO_PENDING,                                  /* 00000103 (STATUS_PENDING) */
    ERROR_REPARSE,                                     /* 00000104 (STATUS_REPARSE) */
    ERROR_MORE_DATA,                                   /* 00000105 (STATUS_MORE_ENTRIES) */
    ERROR_NOT_ALL_ASSIGNED,                            /* 00000106 (STATUS_NOT_ALL_ASSIGNED) */
    ERROR_SOME_NOT_MAPPED,                             /* 00000107 (STATUS_SOME_NOT_MAPPED) */
    ERROR_OPLOCK_BREAK_IN_PROGRESS,                    /* 00000108 (STATUS_OPLOCK_BREAK_IN_PROGRESS) */
    ERROR_VOLUME_MOUNTED,                              /* 00000109 (STATUS_VOLUME_MOUNTED) */
    ERROR_RXACT_COMMITTED,                             /* 0000010a (STATUS_RXACT_COMMITTED) */
    ERROR_NOTIFY_CLEANUP,                              /* 0000010b (STATUS_NOTIFY_CLEANUP) */
    ERROR_NOTIFY_ENUM_DIR,                             /* 0000010c (STATUS_NOTIFY_ENUM_DIR) */
    ERROR_NO_QUOTAS_FOR_ACCOUNT,                       /* 0000010d (STATUS_NO_QUOTAS_FOR_ACCOUNT) */
    ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED,            /* 0000010e (STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED) */
    ERROR_MR_MID_NOT_FOUND,                            /* 0000010f */
    ERROR_PAGE_FAULT_TRANSITION,                       /* 00000110 (STATUS_PAGE_FAULT_TRANSITION) */
    ERROR_PAGE_FAULT_DEMAND_ZERO,                      /* 00000111 (STATUS_PAGE_FAULT_DEMAND_ZERO) */
    ERROR_PAGE_FAULT_COPY_ON_WRITE,                    /* 00000112 (STATUS_PAGE_FAULT_COPY_ON_WRITE) */
    ERROR_PAGE_FAULT_GUARD_PAGE,                       /* 00000113 (STATUS_PAGE_FAULT_GUARD_PAGE) */
    ERROR_PAGE_FAULT_PAGING_FILE,                      /* 00000114 (STATUS_PAGE_FAULT_PAGING_FILE) */
    ERROR_CACHE_PAGE_LOCKED,                           /* 00000115 (STATUS_CACHE_PAGE_LOCKED) */
    ERROR_CRASH_DUMP,                                  /* 00000116 (STATUS_CRASH_DUMP) */
    ERROR_BUFFER_ALL_ZEROS,                            /* 00000117 (STATUS_BUFFER_ALL_ZEROS) */
    ERROR_REPARSE_OBJECT,                              /* 00000118 (STATUS_REPARSE_OBJECT) */
    ERROR_RESOURCE_REQUIREMENTS_CHANGED,               /* 00000119 (STATUS_RESOURCE_REQUIREMENTS_CHANGED) */
    ERROR_MR_MID_NOT_FOUND,                            /* 0000011a */
    ERROR_MR_MID_NOT_FOUND,                            /* 0000011b */
    ERROR_MR_MID_NOT_FOUND,                            /* 0000011c */
    ERROR_MR_MID_NOT_FOUND,                            /* 0000011d */
    ERROR_MR_MID_NOT_FOUND,                            /* 0000011e */
    ERROR_MR_MID_NOT_FOUND,                            /* 0000011f */
    ERROR_TRANSLATION_COMPLETE,                        /* 00000120 (STATUS_TRANSLATION_COMPLETE) */
    ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY,             /* 00000121 (STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY) */
    ERROR_NOTHING_TO_TERMINATE,                        /* 00000122 (STATUS_NOTHING_TO_TERMINATE) */
    ERROR_PROCESS_NOT_IN_JOB,                          /* 00000123 (STATUS_PROCESS_NOT_IN_JOB) */
    ERROR_PROCESS_IN_JOB,                              /* 00000124 (STATUS_PROCESS_IN_JOB) */
    ERROR_VOLSNAP_HIBERNATE_READY,                     /* 00000125 (STATUS_VOLSNAP_HIBERNATE_READY) */
    ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY,          /* 00000126 (STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY) */
    ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED,          /* 00000127 (STATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED) */
    ERROR_INTERRUPT_STILL_CONNECTED,                   /* 00000128 (STATUS_INTERRUPT_STILL_CONNECTED) */
    ERROR_RESOURCEMANAGER_READ_ONLY,                   /* 00000202 (STATUS_RESOURCEMANAGER_READ_ONLY) */
    ERROR_OPLOCK_SWITCHED_TO_NEW_HANDLE,               /* 00000215 (STATUS_OPLOCK_SWITCHED_TO_NEW_HANDLE) */
    ERROR_OPLOCK_HANDLE_CLOSED,                        /* 00000216 (STATUS_OPLOCK_HANDLE_CLOSED) */
    ERROR_WAIT_FOR_OPLOCK,                             /* 00000367 (STATUS_WAIT_FOR_OPLOCK) */
    ERROR_REPARSE,                                     /* 00000368 (STATUS_REPARSE_GLOBAL) */
    ERROR_DBG_EXCEPTION_HANDLED,                       /* 00010001 (DBG_EXCEPTION_HANDLED) */
    ERROR_DBG_CONTINUE,                                /* 00010002 (DBG_CONTINUE) */
    ERROR_FLT_IO_COMPLETE,                             /* 001c0001 (STATUS_FLT_IO_COMPLETE) */
    ERROR_HV_PENDING_PAGE_REQUESTS,                    /* 00350059 (STATUS_HV_PENDING_PAGE_REQUESTS) */
    ERROR_SPACES_INTERNAL_ERROR,                       /* 00e70003 (STATUS_SPACES_REDIRECT) */
    ERROR_OBJECT_NAME_EXISTS,                          /* 40000000 (STATUS_OBJECT_NAME_EXISTS) */
    ERROR_THREAD_WAS_SUSPENDED,                        /* 40000001 (STATUS_THREAD_WAS_SUSPENDED) */
    ERROR_INVALID_PARAMETER,                           /* 40000002 (STATUS_WORKING_SET_LIMIT_RANGE) */
    ERROR_IMAGE_NOT_AT_BASE,                           /* 40000003 (STATUS_IMAGE_NOT_AT_BASE) */
    ERROR_RXACT_STATE_CREATED,                         /* 40000004 (STATUS_RXACT_STATE_CREATED) */
    ERROR_SEGMENT_NOTIFICATION,                        /* 40000005 (STATUS_SEGMENT_NOTIFICATION) */
    ERROR_LOCAL_USER_SESSION_KEY,                      /* 40000006 (STATUS_LOCAL_USER_SESSION_KEY) */
    ERROR_BAD_CURRENT_DIRECTORY,                       /* 40000007 (STATUS_BAD_CURRENT_DIRECTORY) */
    ERROR_MORE_WRITES,                                 /* 40000008 (STATUS_SERIAL_MORE_WRITES) */
    ERROR_REGISTRY_RECOVERED,                          /* 40000009 (STATUS_REGISTRY_RECOVERED) */
    ERROR_FT_READ_RECOVERY_FROM_BACKUP,                /* 4000000a (STATUS_FT_READ_RECOVERY_FROM_BACKUP) */
    ERROR_FT_WRITE_RECOVERY,                           /* 4000000b (STATUS_FT_WRITE_RECOVERY) */
    ERROR_COUNTER_TIMEOUT,                             /* 4000000c (STATUS_SERIAL_COUNTER_TIMEOUT) */
    ERROR_NULL_LM_PASSWORD,                            /* 4000000d (STATUS_NULL_LM_PASSWORD) */
    ERROR_IMAGE_MACHINE_TYPE_MISMATCH,                 /* 4000000e (STATUS_IMAGE_MACHINE_TYPE_MISMATCH) */
    ERROR_RECEIVE_PARTIAL,                             /* 4000000f (STATUS_RECEIVE_PARTIAL) */
    ERROR_RECEIVE_EXPEDITED,                           /* 40000010 (STATUS_RECEIVE_EXPEDITED) */
    ERROR_RECEIVE_PARTIAL_EXPEDITED,                   /* 40000011 (STATUS_RECEIVE_PARTIAL_EXPEDITED) */
    ERROR_EVENT_DONE,                                  /* 40000012 (STATUS_EVENT_DONE) */
    ERROR_EVENT_PENDING,                               /* 40000013 (STATUS_EVENT_PENDING) */
    ERROR_CHECKING_FILE_SYSTEM,                        /* 40000014 (STATUS_CHECKING_FILE_SYSTEM) */
    ERROR_FATAL_APP_EXIT,                              /* 40000015 (STATUS_FATAL_APP_EXIT) */
    ERROR_PREDEFINED_HANDLE,                           /* 40000016 (STATUS_PREDEFINED_HANDLE) */
    ERROR_WAS_UNLOCKED,                                /* 40000017 (STATUS_WAS_UNLOCKED) */
    ERROR_SERVICE_NOTIFICATION,                        /* 40000018 (STATUS_SERVICE_NOTIFICATION) */
    ERROR_WAS_LOCKED,                                  /* 40000019 (STATUS_WAS_LOCKED) */
    ERROR_LOG_HARD_ERROR,                              /* 4000001a (STATUS_LOG_HARD_ERROR) */
    ERROR_ALREADY_WIN32,                               /* 4000001b (STATUS_ALREADY_WIN32) */
    ERROR_WX86_WARNING,                                /* 4000001c (STATUS_WX86_UNSIMULATE) */
    ERROR_WX86_WARNING,                                /* 4000001d (STATUS_WX86_CONTINUE) */
    ERROR_WX86_WARNING,                                /* 4000001e (STATUS_WX86_SINGLE_STEP) */
    ERROR_WX86_WARNING,                                /* 4000001f (STATUS_WX86_BREAKPOINT) */
    ERROR_WX86_WARNING,                                /* 40000020 (STATUS_WX86_EXCEPTION_CONTINUE) */
    ERROR_WX86_WARNING,                                /* 40000021 (STATUS_WX86_EXCEPTION_LASTCHANCE) */
    ERROR_WX86_WARNING,                                /* 40000022 (STATUS_WX86_EXCEPTION_CHAIN) */
    ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE,             /* 40000023 (STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE) */
    ERROR_NO_YIELD_PERFORMED,                          /* 40000024 (STATUS_NO_YIELD_PERFORMED) */
    ERROR_TIMER_RESUME_IGNORED,                        /* 40000025 (STATUS_TIMER_RESUME_IGNORED) */
    ERROR_ARBITRATION_UNHANDLED,                       /* 40000026 (STATUS_ARBITRATION_UNHANDLED) */
    ERROR_CARDBUS_NOT_SUPPORTED,                       /* 40000027 (STATUS_CARDBUS_NOT_SUPPORTED) */
    ERROR_WX86_WARNING,                                /* 40000028 (STATUS_WX86_CREATEWX86TIB) */
    ERROR_MP_PROCESSOR_MISMATCH,                       /* 40000029 (STATUS_MP_PROCESSOR_MISMATCH) */
    ERROR_HIBERNATED,                                  /* 4000002a (STATUS_HIBERNATED) */
    ERROR_RESUME_HIBERNATION,                          /* 4000002b (STATUS_RESUME_HIBERNATION) */
    ERROR_FIRMWARE_UPDATED,                            /* 4000002c (STATUS_FIRMWARE_UPDATED) */
    ERROR_DRIVERS_LEAKING_LOCKED_PAGES,                /* 4000002d (STATUS_DRIVERS_LEAKING_LOCKED_PAGES) */
    ERROR_INTERNAL_ERROR,                              /* 4000002e (STATUS_MESSAGE_RETRIEVED) */
    ERROR_SYSTEM_POWERSTATE_TRANSITION,                /* 4000002f (STATUS_SYSTEM_POWERSTATE_TRANSITION) */
    ERROR_INTERNAL_ERROR,                              /* 40000030 (STATUS_ALPC_CHECK_COMPLETION_LIST) */
    ERROR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION,        /* 40000031 (STATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION) */
    ERROR_ACCESS_AUDIT_BY_POLICY,                      /* 40000032 (STATUS_ACCESS_AUDIT_BY_POLICY) */
    ERROR_ABANDON_HIBERFILE,                           /* 40000033 (STATUS_ABANDON_HIBERFILE) */
    ERROR_BIZRULES_NOT_ENABLED,                        /* 40000034 (STATUS_BIZRULES_NOT_ENABLED) */
    ERROR_MR_MID_NOT_FOUND,                            /* 40000035 (STATUS_FT_READ_FROM_COPY) */
    ERROR_IMAGE_AT_DIFFERENT_BASE,                     /* 40000036 (STATUS_IMAGE_AT_DIFFERENT_BASE) */
    ERROR_MR_MID_NOT_FOUND,                            /* 40000037 (STATUS_PATCH_DEFERRED) */
    STATUS_BREAKPOINT,                                 /* 40000038 (STATUS_EMULATION_BREAKPOINT) */
    ERROR_INVALID_FUNCTION,                            /* 40000039 (STATUS_EMULATION_SYSCALL) */
    ERROR_WAKE_SYSTEM,                                 /* 40000294 (STATUS_WAKE_SYSTEM) */
    ERROR_DS_SHUTTING_DOWN,                            /* 40000370 (STATUS_DS_SHUTTING_DOWN) */
    ERROR_DISK_REPAIR_REDIRECTED,                      /* 40000807 (STATUS_DISK_REPAIR_REDIRECTED) */
    ERROR_SERVICES_FAILED_AUTOSTART,                   /* 4000a144 (STATUS_SERVICES_FAILED_AUTOSTART) */
    ERROR_DBG_REPLY_LATER,                             /* 40010001 (DBG_REPLY_LATER) */
    ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE,                /* 40010002 (DBG_UNABLE_TO_PROVIDE_HANDLE) */
    ERROR_DBG_TERMINATE_THREAD,                        /* 40010003 (DBG_TERMINATE_THREAD) */
    ERROR_DBG_TERMINATE_PROCESS,                       /* 40010004 (DBG_TERMINATE_PROCESS) */
    ERROR_DBG_CONTROL_C,                               /* 40010005 (DBG_CONTROL_C) */
    ERROR_DBG_PRINTEXCEPTION_C,                        /* 40010006 (DBG_PRINTEXCEPTION_C) */
    ERROR_DBG_RIPEXCEPTION,                            /* 40010007 (DBG_RIPEXCEPTION) */
    ERROR_DBG_CONTROL_BREAK,                           /* 40010008 (DBG_CONTROL_BREAK) */
    ERROR_DBG_COMMAND_EXCEPTION,                       /* 40010009 (DBG_COMMAND_EXCEPTION) */
    ERROR_DBG_PRINTEXCEPTION_C,                        /* 4001000a (DBG_PRINTEXCEPTION_WIDE_C) */
    RPC_S_UUID_LOCAL_ONLY,                             /* 40020056 (RPC_NT_UUID_LOCAL_ONLY) */
    RPC_S_SEND_INCOMPLETE,                             /* 400200af (RPC_NT_SEND_INCOMPLETE) */
    ERROR_CTX_CDM_CONNECT,                             /* 400a0004 (STATUS_CTX_CDM_CONNECT) */
    ERROR_CTX_CDM_DISCONNECT,                          /* 400a0005 (STATUS_CTX_CDM_DISCONNECT) */
    ERROR_SXS_RELEASE_ACTIVATION_CONTEXT,              /* 4015000d (STATUS_SXS_RELEASE_ACTIVATION_CONTEXT) */
    ERROR_HEURISTIC_DAMAGE_POSSIBLE,                   /* 40190001 (STATUS_HEURISTIC_DAMAGE_POSSIBLE) */
    ERROR_RECOVERY_NOT_NEEDED,                         /* 40190034 (STATUS_RECOVERY_NOT_NEEDED) */
    ERROR_RM_ALREADY_STARTED,                          /* 40190035 (STATUS_RM_ALREADY_STARTED) */
    ERROR_LOG_NO_RESTART,                              /* 401a000c (STATUS_LOG_NO_RESTART) */
    ERROR_HUNG_DISPLAY_DRIVER_THREAD,                  /* 401b00ec (STATUS_VIDEO_DRIVER_DEBUG_REPORT_REQUEST) */
    ERROR_GRAPHICS_PARTIAL_DATA_POPULATED,             /* 401e000a (STATUS_GRAPHICS_PARTIAL_DATA_POPULATED) */
    ERROR_GRAPHICS_SKIP_ALLOCATION_PREPARATION,        /* 401e0201 (STATUS_GRAPHICS_SKIP_ALLOCATION_PREPARATION) */
    ERROR_GRAPHICS_MODE_NOT_PINNED,                    /* 401e0307 (STATUS_GRAPHICS_MODE_NOT_PINNED) */
    ERROR_GRAPHICS_NO_PREFERRED_MODE,                  /* 401e031e (STATUS_GRAPHICS_NO_PREFERRED_MODE) */
    ERROR_GRAPHICS_DATASET_IS_EMPTY,                   /* 401e034b (STATUS_GRAPHICS_DATASET_IS_EMPTY) */
    ERROR_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET,        /* 401e034c (STATUS_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET) */
    ERROR_MR_MID_NOT_FOUND,                            /* 401e034d */
    ERROR_MR_MID_NOT_FOUND,                            /* 401e034e */
    ERROR_MR_MID_NOT_FOUND,                            /* 401e034f */
    ERROR_MR_MID_NOT_FOUND,                            /* 401e0350 */
    ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED, /* 401e0351 (STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED) */
    ERROR_GRAPHICS_UNKNOWN_CHILD_STATUS,               /* 401e042f (STATUS_GRAPHICS_UNKNOWN_CHILD_STATUS) */
    ERROR_MR_MID_NOT_FOUND,                            /* 401e0430 */
    ERROR_MR_MID_NOT_FOUND,                            /* 401e0431 */
    ERROR_MR_MID_NOT_FOUND,                            /* 401e0432 */
    ERROR_MR_MID_NOT_FOUND,                            /* 401e0433 */
    ERROR_MR_MID_NOT_FOUND,                            /* 401e0434 */
    ERROR_MR_MID_NOT_FOUND,                            /* 401e0435 */
    ERROR_MR_MID_NOT_FOUND,                            /* 401e0436 */
    ERROR_GRAPHICS_LEADLINK_START_DEFERRED,            /* 401e0437 (STATUS_GRAPHICS_LEADLINK_START_DEFERRED) */
    ERROR_MR_MID_NOT_FOUND,                            /* 401e0438 */
    ERROR_GRAPHICS_POLLING_TOO_FREQUENTLY,             /* 401e0439 (STATUS_GRAPHICS_POLLING_TOO_FREQUENTLY) */
    ERROR_GRAPHICS_START_DEFERRED,                     /* 401e043a (STATUS_GRAPHICS_START_DEFERRED) */
    ERROR_MR_MID_NOT_FOUND,                            /* 401e043b */
    ERROR_GRAPHICS_DEPENDABLE_CHILD_STATUS,            /* 401e043c (STATUS_GRAPHICS_DEPENDABLE_CHILD_STATUS) */
    ERROR_NDIS_INDICATION_REQUIRED,                    /* 40230001 (STATUS_NDIS_INDICATION_REQUIRED) */
    TPM_E_PCP_UNSUPPORTED_PSS_SALT,                    /* 40292023 (STATUS_PCP_UNSUPPORTED_PSS_SALT) */
    STATUS_GUARD_PAGE_VIOLATION,                       /* 80000001 (STATUS_GUARD_PAGE_VIOLATION) */
    ERROR_NOACCESS,                                    /* 80000002 (STATUS_DATATYPE_MISALIGNMENT) */
    STATUS_BREAKPOINT,                                 /* 80000003 (STATUS_BREAKPOINT) */
    STATUS_SINGLE_STEP,                                /* 80000004 (STATUS_SINGLE_STEP) */
    ERROR_MORE_DATA,                                   /* 80000005 (STATUS_BUFFER_OVERFLOW) */
    ERROR_NO_MORE_FILES,                               /* 80000006 (STATUS_NO_MORE_FILES) */
    ERROR_WAKE_SYSTEM_DEBUGGER,                        /* 80000007 (STATUS_WAKE_SYSTEM_DEBUGGER) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80000008 */
    ERROR_MR_MID_NOT_FOUND,                            /* 80000009 */
    ERROR_HANDLES_CLOSED,                              /* 8000000a (STATUS_HANDLES_CLOSED) */
    ERROR_NO_INHERITANCE,                              /* 8000000b (STATUS_NO_INHERITANCE) */
    ERROR_GUID_SUBSTITUTION_MADE,                      /* 8000000c (STATUS_GUID_SUBSTITUTION_MADE) */
    ERROR_PARTIAL_COPY,                                /* 8000000d (STATUS_PARTIAL_COPY) */
    ERROR_OUT_OF_PAPER,                                /* 8000000e (STATUS_DEVICE_PAPER_EMPTY) */
    ERROR_NOT_READY,                                   /* 8000000f (STATUS_DEVICE_POWERED_OFF) */
    ERROR_NOT_READY,                                   /* 80000010 (STATUS_DEVICE_OFF_LINE) */
    ERROR_BUSY,                                        /* 80000011 (STATUS_DEVICE_BUSY) */
    ERROR_NO_MORE_ITEMS,                               /* 80000012 (STATUS_NO_MORE_EAS) */
    ERROR_INVALID_EA_NAME,                             /* 80000013 (STATUS_INVALID_EA_NAME) */
    ERROR_EA_LIST_INCONSISTENT,                        /* 80000014 (STATUS_EA_LIST_INCONSISTENT) */
    ERROR_EA_LIST_INCONSISTENT,                        /* 80000015 (STATUS_INVALID_EA_FLAG) */
    ERROR_MEDIA_CHANGED,                               /* 80000016 (STATUS_VERIFY_REQUIRED) */
    ERROR_EXTRANEOUS_INFORMATION,                      /* 80000017 (STATUS_EXTRANEOUS_INFORMATION) */
    ERROR_RXACT_COMMIT_NECESSARY,                      /* 80000018 (STATUS_RXACT_COMMIT_NECESSARY) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80000019 (E_ASYNC_OPERATION_NOT_STARTED) */
    ERROR_NO_MORE_ITEMS,                               /* 8000001a (STATUS_NO_MORE_ENTRIES) */
    ERROR_FILEMARK_DETECTED,                           /* 8000001b (STATUS_FILEMARK_DETECTED) */
    ERROR_MEDIA_CHANGED,                               /* 8000001c (STATUS_MEDIA_CHANGED) */
    ERROR_BUS_RESET,                                   /* 8000001d (STATUS_BUS_RESET) */
    ERROR_END_OF_MEDIA,                                /* 8000001e (STATUS_END_OF_MEDIA) */
    ERROR_BEGINNING_OF_MEDIA,                          /* 8000001f (STATUS_BEGINNING_OF_MEDIA) */
    ERROR_MEDIA_CHECK,                                 /* 80000020 (STATUS_MEDIA_CHECK) */
    ERROR_SETMARK_DETECTED,                            /* 80000021 (STATUS_SETMARK_DETECTED) */
    ERROR_NO_DATA_DETECTED,                            /* 80000022 (STATUS_NO_DATA_DETECTED) */
    ERROR_REDIRECTOR_HAS_OPEN_HANDLES,                 /* 80000023 (STATUS_REDIRECTOR_HAS_OPEN_HANDLES) */
    ERROR_SERVER_HAS_OPEN_HANDLES,                     /* 80000024 (STATUS_SERVER_HAS_OPEN_HANDLES) */
    ERROR_ACTIVE_CONNECTIONS,                          /* 80000025 (STATUS_ALREADY_DISCONNECTED) */
    ERROR_LONGJUMP,                                    /* 80000026 (STATUS_LONGJUMP) */
    ERROR_CLEANER_CARTRIDGE_INSTALLED,                 /* 80000027 (STATUS_CLEANER_CARTRIDGE_INSTALLED) */
    ERROR_PLUGPLAY_QUERY_VETOED,                       /* 80000028 (STATUS_PLUGPLAY_QUERY_VETOED) */
    ERROR_UNWIND_CONSOLIDATE,                          /* 80000029 (STATUS_UNWIND_CONSOLIDATE) */
    ERROR_REGISTRY_HIVE_RECOVERED,                     /* 8000002a (STATUS_REGISTRY_HIVE_RECOVERED) */
    ERROR_DLL_MIGHT_BE_INSECURE,                       /* 8000002b (STATUS_DLL_MIGHT_BE_INSECURE) */
    ERROR_DLL_MIGHT_BE_INCOMPATIBLE,                   /* 8000002c (STATUS_DLL_MIGHT_BE_INCOMPATIBLE) */
    ERROR_STOPPED_ON_SYMLINK,                          /* 8000002d (STATUS_STOPPED_ON_SYMLINK) */
    ERROR_CANNOT_GRANT_REQUESTED_OPLOCK,               /* 8000002e (STATUS_CANNOT_GRANT_REQUESTED_OPLOCK) */
    ERROR_NO_ACE_CONDITION,                            /* 8000002f (STATUS_NO_ACE_CONDITION) */
    ERROR_DEVICE_SUPPORT_IN_PROGRESS,                  /* 80000030 (STATUS_DEVICE_SUPPORT_IN_PROGRESS) */
    STG_S_POWER_CYCLE_REQUIRED,                        /* 80000031 (STATUS_DEVICE_POWER_CYCLE_REQUIRED) */
    ERROR_NO_WORK_DONE,                                /* 80000032 (STATUS_NO_WORK_DONE) */
    ERROR_RETURN_ADDRESS_HIJACK_ATTEMPT,               /* 80000033 (STATUS_RETURN_ADDRESS_HIJACK_ATTEMPT) */
    ERROR_GEN_FAILURE,                                 /* 80000034 (STATUS_RECOVERABLE_BUGCHECK) */
    ERROR_DEVICE_RESET_REQUIRED,                       /* 800001b6 (STATUS_DEVICE_RESET_REQUIRED) */
    ERROR_DEVICE_REQUIRES_CLEANING,                    /* 80000288 (STATUS_DEVICE_REQUIRES_CLEANING) */
    ERROR_DEVICE_DOOR_OPEN,                            /* 80000289 (STATUS_DEVICE_DOOR_OPEN) */
    ERROR_DATA_LOST_REPAIR,                            /* 80000803 (STATUS_DATA_LOST_REPAIR) */
    ERROR_GPIO_INTERRUPT_ALREADY_UNMASKED,             /* 8000a127 (STATUS_GPIO_INTERRUPT_ALREADY_UNMASKED) */
    ERROR_CLOUD_FILE_PROPERTY_BLOB_CHECKSUM_MISMATCH,  /* 8000cf00 (STATUS_CLOUD_FILE_PROPERTY_BLOB_CHECKSUM_MISMATCH) */
    ERROR_MR_MID_NOT_FOUND,                            /* 8000cf01 */
    ERROR_MR_MID_NOT_FOUND,                            /* 8000cf02 */
    ERROR_MR_MID_NOT_FOUND,                            /* 8000cf03 */
    ERROR_CLOUD_FILE_PROPERTY_BLOB_TOO_LARGE,          /* 8000cf04 (STATUS_CLOUD_FILE_PROPERTY_BLOB_TOO_LARGE) */
    ERROR_CLOUD_FILE_TOO_MANY_PROPERTY_BLOBS,          /* 8000cf05 (STATUS_CLOUD_FILE_TOO_MANY_PROPERTY_BLOBS) */
    ERROR_DBG_EXCEPTION_NOT_HANDLED,                   /* 80010001 (DBG_EXCEPTION_NOT_HANDLED) */
    ERROR_NO_SYSTEM_RESOURCES,                         /* 80090300 (SEC_E_INSUFFICIENT_MEMORY) */
    ERROR_INVALID_HANDLE,                              /* 80090301 (SEC_E_INVALID_HANDLE) */
    ERROR_INVALID_FUNCTION,                            /* 80090302 (SEC_E_UNSUPPORTED_FUNCTION) */
    ERROR_BAD_NETPATH,                                 /* 80090303 (SEC_E_TARGET_UNKNOWN) */
    ERROR_INTERNAL_ERROR,                              /* 80090304 (SEC_E_INTERNAL_ERROR) */
    ERROR_NO_SUCH_PACKAGE,                             /* 80090305 (SEC_E_SECPKG_NOT_FOUND) */
    ERROR_NOT_OWNER,                                   /* 80090306 (SEC_E_NOT_OWNER) */
    ERROR_NO_SUCH_PACKAGE,                             /* 80090307 (SEC_E_CANNOT_INSTALL) */
    ERROR_INVALID_PARAMETER,                           /* 80090308 (SEC_E_INVALID_TOKEN) */
    ERROR_INVALID_PARAMETER,                           /* 80090309 (SEC_E_CANNOT_PACK) */
    ERROR_NOT_SUPPORTED,                               /* 8009030a (SEC_E_QOP_NOT_SUPPORTED) */
    ERROR_CANNOT_IMPERSONATE,                          /* 8009030b (SEC_E_NO_IMPERSONATION) */
    ERROR_LOGON_FAILURE,                               /* 8009030c (SEC_E_LOGON_DENIED) */
    ERROR_INVALID_PARAMETER,                           /* 8009030d (SEC_E_UNKNOWN_CREDENTIALS) */
    ERROR_NO_SUCH_LOGON_SESSION,                       /* 8009030e (SEC_E_NO_CREDENTIALS) */
    ERROR_ACCESS_DENIED,                               /* 8009030f (SEC_E_MESSAGE_ALTERED) */
    ERROR_ACCESS_DENIED,                               /* 80090310 (SEC_E_OUT_OF_SEQUENCE) */
    ERROR_NO_LOGON_SERVERS,                            /* 80090311 (SEC_E_NO_AUTHENTICATING_AUTHORITY) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090312 */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090313 */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090314 */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090315 */
    ERROR_NO_SUCH_PACKAGE,                             /* 80090316 (SEC_E_BAD_PKGID) */
    ERROR_CONTEXT_EXPIRED,                             /* 80090317 (SEC_E_CONTEXT_EXPIRED) */
    ERROR_INVALID_USER_BUFFER,                         /* 80090318 (SEC_E_INCOMPLETE_MESSAGE) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090319 */
    ERROR_MR_MID_NOT_FOUND,                            /* 8009031a */
    ERROR_MR_MID_NOT_FOUND,                            /* 8009031b */
    ERROR_MR_MID_NOT_FOUND,                            /* 8009031c */
    ERROR_MR_MID_NOT_FOUND,                            /* 8009031d */
    ERROR_MR_MID_NOT_FOUND,                            /* 8009031e */
    ERROR_MR_MID_NOT_FOUND,                            /* 8009031f */
    ERROR_INVALID_PARAMETER,                           /* 80090320 (SEC_E_INCOMPLETE_CREDENTIALS) */
    ERROR_INSUFFICIENT_BUFFER,                         /* 80090321 (SEC_E_BUFFER_TOO_SMALL) */
    ERROR_WRONG_TARGET_NAME,                           /* 80090322 (SEC_E_WRONG_PRINCIPAL) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090323 */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090324 (SEC_E_TIME_SKEW) */
    ERROR_TRUST_FAILURE,                               /* 80090325 (SEC_E_UNTRUSTED_ROOT) */
    ERROR_INVALID_PARAMETER,                           /* 80090326 (SEC_E_ILLEGAL_MESSAGE) */
    ERROR_INVALID_PARAMETER,                           /* 80090327 (SEC_E_CERT_UNKNOWN) */
    ERROR_PASSWORD_EXPIRED,                            /* 80090328 (SEC_E_CERT_EXPIRED) */
    ERROR_ENCRYPTION_FAILED,                           /* 80090329 (SEC_E_ENCRYPT_FAILURE) */
    ERROR_MR_MID_NOT_FOUND,                            /* 8009032a */
    ERROR_MR_MID_NOT_FOUND,                            /* 8009032b */
    ERROR_MR_MID_NOT_FOUND,                            /* 8009032c */
    ERROR_MR_MID_NOT_FOUND,                            /* 8009032d */
    ERROR_MR_MID_NOT_FOUND,                            /* 8009032e */
    ERROR_MR_MID_NOT_FOUND,                            /* 8009032f */
    ERROR_DECRYPTION_FAILED,                           /* 80090330 (SEC_E_DECRYPT_FAILURE) */
    ERROR_INVALID_FUNCTION,                            /* 80090331 (SEC_E_ALGORITHM_MISMATCH) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090332 (SEC_E_SECURITY_QOS_FAILED) */
    ERROR_CONTEXT_EXPIRED,                             /* 80090333 (SEC_E_UNFINISHED_CONTEXT_DELETED) */
    ERROR_SHUTDOWN_IN_PROGRESS,                        /* 8009033f (SEC_E_SHUTDOWN_IN_PROGRESS) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090340 (SEC_E_KDC_INVALID_REQUEST) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090341 (SEC_E_KDC_UNABLE_TO_REFER) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090342 (SEC_E_KDC_UNKNOWN_ETYPE) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090343 (SEC_E_UNSUPPORTED_PREAUTH) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090344 */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090345 (SEC_E_DELEGATION_REQUIRED) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090346 (SEC_E_BAD_BINDINGS) */
    ERROR_CANNOT_IMPERSONATE,                          /* 80090347 (SEC_E_MULTIPLE_ACCOUNTS) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090348 (SEC_E_NO_KERB_KEY) */
    ERROR_BAD_TOKEN_TYPE,                              /* 80090349 (SEC_E_CERT_WRONG_USAGE) */
    ERROR_INVALID_PARAMETER,                           /* 8009035d (SEC_E_INVALID_PARAMETER) */
    ERROR_ACCESS_DENIED,                               /* 8009035e (SEC_E_DELEGATION_POLICY) */
    ERROR_ACCESS_DENIED,                               /* 8009035f (SEC_E_POLICY_NLTM_ONLY) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090360 */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090361 (SEC_E_NO_CONTEXT) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090362 (SEC_E_PKU2U_CERT_FAILURE) */
    ERROR_MUTUAL_AUTH_FAILED,                          /* 80090363 (SEC_E_MUTUAL_AUTH_FAILED) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090364 */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090365 (SEC_E_ONLY_HTTPS_ALLOWED) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80090366 */
    ERROR_NOT_SUPPORTED,                               /* 80090367 (SEC_E_APPLICATION_PROTOCOL_MISMATCH) */
    ERROR_MUTUAL_AUTH_FAILED,                          /* 80092010 (CRYPT_E_REVOKED) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80092011 (CRYPT_E_NO_REVOCATION_DLL) */
    ERROR_MUTUAL_AUTH_FAILED,                          /* 80092012 (CRYPT_E_NO_REVOCATION_CHECK) */
    ERROR_MUTUAL_AUTH_FAILED,                          /* 80092013 (CRYPT_E_REVOCATION_OFFLINE) */
    ERROR_MUTUAL_AUTH_FAILED,                          /* 80096004 (TRUST_E_CERT_SIGNATURE) */
    ERROR_BAD_TOKEN_TYPE,                              /* 800b0110 (CERT_E_WRONG_USAGE) */
    ERROR_CLUSTER_NODE_ALREADY_UP,                     /* 80130001 (STATUS_CLUSTER_NODE_ALREADY_UP) */
    ERROR_CLUSTER_NODE_ALREADY_DOWN,                   /* 80130002 (STATUS_CLUSTER_NODE_ALREADY_DOWN) */
    ERROR_CLUSTER_NETWORK_ALREADY_ONLINE,              /* 80130003 (STATUS_CLUSTER_NETWORK_ALREADY_ONLINE) */
    ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE,             /* 80130004 (STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE) */
    ERROR_CLUSTER_NODE_ALREADY_MEMBER,                 /* 80130005 (STATUS_CLUSTER_NODE_ALREADY_MEMBER) */
    ERROR_COULD_NOT_RESIZE_LOG,                        /* 80190009 (STATUS_COULD_NOT_RESIZE_LOG) */
    ERROR_NO_TXF_METADATA,                             /* 80190029 (STATUS_NO_TXF_METADATA) */
    ERROR_MR_MID_NOT_FOUND,                            /* 8019002a */
    ERROR_MR_MID_NOT_FOUND,                            /* 8019002b */
    ERROR_MR_MID_NOT_FOUND,                            /* 8019002c */
    ERROR_MR_MID_NOT_FOUND,                            /* 8019002d */
    ERROR_MR_MID_NOT_FOUND,                            /* 8019002e */
    ERROR_MR_MID_NOT_FOUND,                            /* 8019002f */
    ERROR_MR_MID_NOT_FOUND,                            /* 80190030 */
    ERROR_CANT_RECOVER_WITH_HANDLE_OPEN,               /* 80190031 (STATUS_CANT_RECOVER_WITH_HANDLE_OPEN) */
    ERROR_TXF_METADATA_ALREADY_PRESENT,                /* 80190041 (STATUS_TXF_METADATA_ALREADY_PRESENT) */
    ERROR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET,         /* 80190042 (STATUS_TRANSACTION_SCOPE_CALLBACKS_NOT_SET) */
    ERROR_HUNG_DISPLAY_DRIVER_THREAD,                  /* 801b00eb (STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED) */
    ERROR_INSUFFICIENT_BUFFER,                         /* 801c0001 (STATUS_FLT_BUFFER_TOO_SMALL) */
    FVE_E_BAD_INFORMATION,                             /* 80210001 (STATUS_FVE_PARTIAL_METADATA) */
    FVE_E_TRANSIENT_STATE,                             /* 80210002 (STATUS_FVE_TRANSIENT_STATE) */
    ERROR_VID_REMOTE_NODE_PARENT_GPA_PAGES_USED,       /* 80370001 (STATUS_VID_REMOTE_NODE_PARENT_GPA_PAGES_USED) */
    ERROR_VOLMGR_INCOMPLETE_REGENERATION,              /* 80380001 (STATUS_VOLMGR_INCOMPLETE_REGENERATION) */
    ERROR_VOLMGR_INCOMPLETE_DISK_MIGRATION,            /* 80380002 (STATUS_VOLMGR_INCOMPLETE_DISK_MIGRATION) */
    ERROR_BCD_NOT_ALL_ENTRIES_IMPORTED,                /* 80390001 (STATUS_BCD_NOT_ALL_ENTRIES_IMPORTED) */
    ERROR_MR_MID_NOT_FOUND,                            /* 80390002 */
    ERROR_BCD_NOT_ALL_ENTRIES_SYNCHRONIZED,            /* 80390003 (STATUS_BCD_NOT_ALL_ENTRIES_SYNCHRONIZED) */
    ERROR_QUERY_STORAGE_ERROR,                         /* 803a0001 (STATUS_QUERY_STORAGE_ERROR) */
    ERROR_GDI_HANDLE_LEAK,                             /* 803f0001 (STATUS_GDI_HANDLE_LEAK) */
    ERROR_SECUREBOOT_NOT_ENABLED,                      /* 80430006 (STATUS_SECUREBOOT_NOT_ENABLED) */
    ERROR_GEN_FAILURE,                                 /* c0000001 (STATUS_UNSUCCESSFUL) */
    ERROR_INVALID_FUNCTION,                            /* c0000002 (STATUS_NOT_IMPLEMENTED) */
    ERROR_INVALID_PARAMETER,                           /* c0000003 (STATUS_INVALID_INFO_CLASS) */
    ERROR_BAD_LENGTH,                                  /* c0000004 (STATUS_INFO_LENGTH_MISMATCH) */
    ERROR_NOACCESS,                                    /* c0000005 (STATUS_ACCESS_VIOLATION) */
    ERROR_SWAPERROR,                                   /* c0000006 (STATUS_IN_PAGE_ERROR) */
    ERROR_PAGEFILE_QUOTA,                              /* c0000007 (STATUS_PAGEFILE_QUOTA) */
    ERROR_INVALID_HANDLE,                              /* c0000008 (STATUS_INVALID_HANDLE) */
    ERROR_STACK_OVERFLOW,                              /* c0000009 (STATUS_BAD_INITIAL_STACK) */
    ERROR_BAD_EXE_FORMAT,                              /* c000000a (STATUS_BAD_INITIAL_PC) */
    ERROR_INVALID_PARAMETER,                           /* c000000b (STATUS_INVALID_CID) */
    ERROR_TIMER_NOT_CANCELED,                          /* c000000c (STATUS_TIMER_NOT_CANCELED) */
    ERROR_INVALID_PARAMETER,                           /* c000000d (STATUS_INVALID_PARAMETER) */
    ERROR_NO_SUCH_DEVICE,                              /* c000000e (STATUS_NO_SUCH_DEVICE) */
    ERROR_FILE_NOT_FOUND,                              /* c000000f (STATUS_NO_SUCH_FILE) */
    ERROR_INVALID_FUNCTION,                            /* c0000010 (STATUS_INVALID_DEVICE_REQUEST) */
    ERROR_HANDLE_EOF,                                  /* c0000011 (STATUS_END_OF_FILE) */
    ERROR_WRONG_DISK,                                  /* c0000012 (STATUS_WRONG_VOLUME) */
    ERROR_NOT_READY,                                   /* c0000013 (STATUS_NO_MEDIA_IN_DEVICE) */
    ERROR_UNRECOGNIZED_MEDIA,                          /* c0000014 (STATUS_UNRECOGNIZED_MEDIA) */
    ERROR_SECTOR_NOT_FOUND,                            /* c0000015 (STATUS_NONEXISTENT_SECTOR) */
    ERROR_MORE_DATA,                                   /* c0000016 (STATUS_MORE_PROCESSING_REQUIRED) */
    ERROR_NOT_ENOUGH_MEMORY,                           /* c0000017 (STATUS_NO_MEMORY) */
    ERROR_INVALID_ADDRESS,                             /* c0000018 (STATUS_CONFLICTING_ADDRESSES) */
    ERROR_INVALID_ADDRESS,                             /* c0000019 (STATUS_NOT_MAPPED_VIEW) */
    ERROR_INVALID_PARAMETER,                           /* c000001a (STATUS_UNABLE_TO_FREE_VM) */
    ERROR_INVALID_PARAMETER,                           /* c000001b (STATUS_UNABLE_TO_DELETE_SECTION) */
    ERROR_INVALID_FUNCTION,                            /* c000001c (STATUS_INVALID_SYSTEM_SERVICE) */
    STATUS_ILLEGAL_INSTRUCTION,                        /* c000001d (STATUS_ILLEGAL_INSTRUCTION) */
    ERROR_ACCESS_DENIED,                               /* c000001e (STATUS_INVALID_LOCK_SEQUENCE) */
    ERROR_ACCESS_DENIED,                               /* c000001f (STATUS_INVALID_VIEW_SIZE) */
    ERROR_BAD_EXE_FORMAT,                              /* c0000020 (STATUS_INVALID_FILE_FOR_SECTION) */
    ERROR_ACCESS_DENIED,                               /* c0000021 (STATUS_ALREADY_COMMITTED) */
    ERROR_ACCESS_DENIED,                               /* c0000022 (STATUS_ACCESS_DENIED) */
    ERROR_INSUFFICIENT_BUFFER,                         /* c0000023 (STATUS_BUFFER_TOO_SMALL) */
    ERROR_INVALID_HANDLE,                              /* c0000024 (STATUS_OBJECT_TYPE_MISMATCH) */
    STATUS_NONCONTINUABLE_EXCEPTION,                   /* c0000025 (STATUS_NONCONTINUABLE_EXCEPTION) */
    STATUS_INVALID_DISPOSITION,                        /* c0000026 (STATUS_INVALID_DISPOSITION) */
    ERROR_UNWIND,                                      /* c0000027 (STATUS_UNWIND) */
    ERROR_BAD_STACK,                                   /* c0000028 (STATUS_BAD_STACK) */
    ERROR_INVALID_UNWIND_TARGET,                       /* c0000029 (STATUS_INVALID_UNWIND_TARGET) */
    ERROR_NOT_LOCKED,                                  /* c000002a (STATUS_NOT_LOCKED) */
    STATUS_PARITY_ERROR,                               /* c000002b (STATUS_PARITY_ERROR) */
    ERROR_INVALID_ADDRESS,                             /* c000002c (STATUS_UNABLE_TO_DECOMMIT_VM) */
    ERROR_INVALID_ADDRESS,                             /* c000002d (STATUS_NOT_COMMITTED) */
    ERROR_INVALID_PORT_ATTRIBUTES,                     /* c000002e (STATUS_INVALID_PORT_ATTRIBUTES) */
    ERROR_PORT_MESSAGE_TOO_LONG,                       /* c000002f (STATUS_PORT_MESSAGE_TOO_LONG) */
    ERROR_INVALID_PARAMETER,                           /* c0000030 (STATUS_INVALID_PARAMETER_MIX) */
    ERROR_INVALID_QUOTA_LOWER,                         /* c0000031 (STATUS_INVALID_QUOTA_LOWER) */
    ERROR_DISK_CORRUPT,                                /* c0000032 (STATUS_DISK_CORRUPT_ERROR) */
    ERROR_INVALID_NAME,                                /* c0000033 (STATUS_OBJECT_NAME_INVALID) */
    ERROR_FILE_NOT_FOUND,                              /* c0000034 (STATUS_OBJECT_NAME_NOT_FOUND) */
    ERROR_ALREADY_EXISTS,                              /* c0000035 (STATUS_OBJECT_NAME_COLLISION) */
    RPC_S_DO_NOT_DISTURB,                              /* c0000036 (STATUS_PORT_DO_NOT_DISTURB) */
    ERROR_INVALID_HANDLE,                              /* c0000037 (STATUS_PORT_DISCONNECTED) */
    ERROR_DEVICE_ALREADY_ATTACHED,                     /* c0000038 (STATUS_DEVICE_ALREADY_ATTACHED) */
    ERROR_BAD_PATHNAME,                                /* c0000039 (STATUS_OBJECT_PATH_INVALID) */
    ERROR_PATH_NOT_FOUND,                              /* c000003a (STATUS_OBJECT_PATH_NOT_FOUND) */
    ERROR_BAD_PATHNAME,                                /* c000003b (STATUS_OBJECT_PATH_SYNTAX_BAD) */
    ERROR_IO_DEVICE,                                   /* c000003c (STATUS_DATA_OVERRUN) */
    ERROR_IO_DEVICE,                                   /* c000003d (STATUS_DATA_LATE_ERROR) */
    ERROR_CRC,                                         /* c000003e (STATUS_DATA_ERROR) */
    ERROR_CRC,                                         /* c000003f (STATUS_CRC_ERROR) */
    ERROR_NOT_ENOUGH_MEMORY,                           /* c0000040 (STATUS_SECTION_TOO_BIG) */
    ERROR_ACCESS_DENIED,                               /* c0000041 (STATUS_PORT_CONNECTION_REFUSED) */
    ERROR_INVALID_HANDLE,                              /* c0000042 (STATUS_INVALID_PORT_HANDLE) */
    ERROR_SHARING_VIOLATION,                           /* c0000043 (STATUS_SHARING_VIOLATION) */
    ERROR_NOT_ENOUGH_QUOTA,                            /* c0000044 (STATUS_QUOTA_EXCEEDED) */
    ERROR_INVALID_PARAMETER,                           /* c0000045 (STATUS_INVALID_PAGE_PROTECTION) */
    ERROR_NOT_OWNER,                                   /* c0000046 (STATUS_MUTANT_NOT_OWNED) */
    ERROR_TOO_MANY_POSTS,                              /* c0000047 (STATUS_SEMAPHORE_LIMIT_EXCEEDED) */
    ERROR_INVALID_PARAMETER,                           /* c0000048 (STATUS_PORT_ALREADY_SET) */
    ERROR_INVALID_PARAMETER,                           /* c0000049 (STATUS_SECTION_NOT_IMAGE) */
    ERROR_SIGNAL_REFUSED,                              /* c000004a (STATUS_SUSPEND_COUNT_EXCEEDED) */
    ERROR_ACCESS_DENIED,                               /* c000004b (STATUS_THREAD_IS_TERMINATING) */
    ERROR_INVALID_PARAMETER,                           /* c000004c (STATUS_BAD_WORKING_SET_LIMIT) */
    ERROR_INVALID_PARAMETER,                           /* c000004d (STATUS_INCOMPATIBLE_FILE_MAP) */
    ERROR_INVALID_PARAMETER,                           /* c000004e (STATUS_SECTION_PROTECTION) */
    ERROR_EAS_NOT_SUPPORTED,                           /* c000004f (STATUS_EAS_NOT_SUPPORTED) */
    ERROR_EA_LIST_INCONSISTENT,                        /* c0000050 (STATUS_EA_TOO_LARGE) */
    ERROR_FILE_CORRUPT,                                /* c0000051 (STATUS_NONEXISTENT_EA_ENTRY) */
    ERROR_FILE_CORRUPT,                                /* c0000052 (STATUS_NO_EAS_ON_FILE) */
    ERROR_FILE_CORRUPT,                                /* c0000053 (STATUS_EA_CORRUPT_ERROR) */
    ERROR_LOCK_VIOLATION,                              /* c0000054 (STATUS_FILE_LOCK_CONFLICT) */
    ERROR_LOCK_VIOLATION,                              /* c0000055 (STATUS_LOCK_NOT_GRANTED) */
    ERROR_ACCESS_DENIED,                               /* c0000056 (STATUS_DELETE_PENDING) */
    ERROR_NOT_SUPPORTED,                               /* c0000057 (STATUS_CTL_FILE_NOT_SUPPORTED) */
    ERROR_UNKNOWN_REVISION,                            /* c0000058 (STATUS_UNKNOWN_REVISION) */
    ERROR_REVISION_MISMATCH,                           /* c0000059 (STATUS_REVISION_MISMATCH) */
    ERROR_INVALID_OWNER,                               /* c000005a (STATUS_INVALID_OWNER) */
    ERROR_INVALID_PRIMARY_GROUP,                       /* c000005b (STATUS_INVALID_PRIMARY_GROUP) */
    ERROR_NO_IMPERSONATION_TOKEN,                      /* c000005c (STATUS_NO_IMPERSONATION_TOKEN) */
    ERROR_CANT_DISABLE_MANDATORY,                      /* c000005d (STATUS_CANT_DISABLE_MANDATORY) */
    ERROR_NO_LOGON_SERVERS,                            /* c000005e (STATUS_NO_LOGON_SERVERS) */
    ERROR_NO_SUCH_LOGON_SESSION,                       /* c000005f (STATUS_NO_SUCH_LOGON_SESSION) */
    ERROR_NO_SUCH_PRIVILEGE,                           /* c0000060 (STATUS_NO_SUCH_PRIVILEGE) */
    ERROR_PRIVILEGE_NOT_HELD,                          /* c0000061 (STATUS_PRIVILEGE_NOT_HELD) */
    ERROR_INVALID_ACCOUNT_NAME,                        /* c0000062 (STATUS_INVALID_ACCOUNT_NAME) */
    ERROR_USER_EXISTS,                                 /* c0000063 (STATUS_USER_EXISTS) */
    ERROR_NO_SUCH_USER,                                /* c0000064 (STATUS_NO_SUCH_USER) */
    ERROR_GROUP_EXISTS,                                /* c0000065 (STATUS_GROUP_EXISTS) */
    ERROR_NO_SUCH_GROUP,                               /* c0000066 (STATUS_NO_SUCH_GROUP) */
    ERROR_MEMBER_IN_GROUP,                             /* c0000067 (STATUS_MEMBER_IN_GROUP) */
    ERROR_MEMBER_NOT_IN_GROUP,                         /* c0000068 (STATUS_MEMBER_NOT_IN_GROUP) */
    ERROR_LAST_ADMIN,                                  /* c0000069 (STATUS_LAST_ADMIN) */
    ERROR_INVALID_PASSWORD,                            /* c000006a (STATUS_WRONG_PASSWORD) */
    ERROR_ILL_FORMED_PASSWORD,                         /* c000006b (STATUS_ILL_FORMED_PASSWORD) */
    ERROR_PASSWORD_RESTRICTION,                        /* c000006c (STATUS_PASSWORD_RESTRICTION) */
    ERROR_LOGON_FAILURE,                               /* c000006d (STATUS_LOGON_FAILURE) */
    ERROR_ACCOUNT_RESTRICTION,                         /* c000006e (STATUS_ACCOUNT_RESTRICTION) */
    ERROR_INVALID_LOGON_HOURS,                         /* c000006f (STATUS_INVALID_LOGON_HOURS) */
    ERROR_INVALID_WORKSTATION,                         /* c0000070 (STATUS_INVALID_WORKSTATION) */
    ERROR_PASSWORD_EXPIRED,                            /* c0000071 (STATUS_PASSWORD_EXPIRED) */
    ERROR_ACCOUNT_DISABLED,                            /* c0000072 (STATUS_ACCOUNT_DISABLED) */
    ERROR_NONE_MAPPED,                                 /* c0000073 (STATUS_NONE_MAPPED) */
    ERROR_TOO_MANY_LUIDS_REQUESTED,                    /* c0000074 (STATUS_TOO_MANY_LUIDS_REQUESTED) */
    ERROR_LUIDS_EXHAUSTED,                             /* c0000075 (STATUS_LUIDS_EXHAUSTED) */
    ERROR_INVALID_SUB_AUTHORITY,                       /* c0000076 (STATUS_INVALID_SUB_AUTHORITY) */
    ERROR_INVALID_ACL,                                 /* c0000077 (STATUS_INVALID_ACL) */
    ERROR_INVALID_SID,                                 /* c0000078 (STATUS_INVALID_SID) */
    ERROR_INVALID_SECURITY_DESCR,                      /* c0000079 (STATUS_INVALID_SECURITY_DESCR) */
    ERROR_PROC_NOT_FOUND,                              /* c000007a (STATUS_PROCEDURE_NOT_FOUND) */
    ERROR_BAD_EXE_FORMAT,                              /* c000007b (STATUS_INVALID_IMAGE_FORMAT) */
    ERROR_NO_TOKEN,                                    /* c000007c (STATUS_NO_TOKEN) */
    ERROR_BAD_INHERITANCE_ACL,                         /* c000007d (STATUS_BAD_INHERITANCE_ACL) */
    ERROR_NOT_LOCKED,                                  /* c000007e (STATUS_RANGE_NOT_LOCKED) */
    ERROR_DISK_FULL,                                   /* c000007f (STATUS_DISK_FULL) */
    ERROR_SERVER_DISABLED,                             /* c0000080 (STATUS_SERVER_DISABLED) */
    ERROR_SERVER_NOT_DISABLED,                         /* c0000081 (STATUS_SERVER_NOT_DISABLED) */
    ERROR_TOO_MANY_NAMES,                              /* c0000082 (STATUS_TOO_MANY_GUIDS_REQUESTED) */
    ERROR_NO_MORE_ITEMS,                               /* c0000083 (STATUS_GUIDS_EXHAUSTED) */
    ERROR_INVALID_ID_AUTHORITY,                        /* c0000084 (STATUS_INVALID_ID_AUTHORITY) */
    ERROR_NO_MORE_ITEMS,                               /* c0000085 (STATUS_AGENTS_EXHAUSTED) */
    ERROR_LABEL_TOO_LONG,                              /* c0000086 (STATUS_INVALID_VOLUME_LABEL) */
    ERROR_OUTOFMEMORY,                                 /* c0000087 (STATUS_SECTION_NOT_EXTENDED) */
    ERROR_INVALID_ADDRESS,                             /* c0000088 (STATUS_NOT_MAPPED_DATA) */
    ERROR_RESOURCE_DATA_NOT_FOUND,                     /* c0000089 (STATUS_RESOURCE_DATA_NOT_FOUND) */
    ERROR_RESOURCE_TYPE_NOT_FOUND,                     /* c000008a (STATUS_RESOURCE_TYPE_NOT_FOUND) */
    ERROR_RESOURCE_NAME_NOT_FOUND,                     /* c000008b (STATUS_RESOURCE_NAME_NOT_FOUND) */
    STATUS_ARRAY_BOUNDS_EXCEEDED,                      /* c000008c (STATUS_ARRAY_BOUNDS_EXCEEDED) */
    STATUS_FLOAT_DENORMAL_OPERAND,                     /* c000008d (STATUS_FLOAT_DENORMAL_OPERAND) */
    STATUS_FLOAT_DIVIDE_BY_ZERO,                       /* c000008e (STATUS_FLOAT_DIVIDE_BY_ZERO) */
    STATUS_FLOAT_INEXACT_RESULT,                       /* c000008f (STATUS_FLOAT_INEXACT_RESULT) */
    STATUS_FLOAT_INVALID_OPERATION,                    /* c0000090 (STATUS_FLOAT_INVALID_OPERATION) */
    STATUS_FLOAT_OVERFLOW,                             /* c0000091 (STATUS_FLOAT_OVERFLOW) */
    STATUS_FLOAT_STACK_CHECK,                          /* c0000092 (STATUS_FLOAT_STACK_CHECK) */
    STATUS_FLOAT_UNDERFLOW,                            /* c0000093 (STATUS_FLOAT_UNDERFLOW) */
    STATUS_INTEGER_DIVIDE_BY_ZERO,                     /* c0000094 (STATUS_INTEGER_DIVIDE_BY_ZERO) */
    ERROR_ARITHMETIC_OVERFLOW,                         /* c0000095 (STATUS_INTEGER_OVERFLOW) */
    STATUS_PRIVILEGED_INSTRUCTION,                     /* c0000096 (STATUS_PRIVILEGED_INSTRUCTION) */
    ERROR_NOT_ENOUGH_MEMORY,                           /* c0000097 (STATUS_TOO_MANY_PAGING_FILES) */
    ERROR_FILE_INVALID,                                /* c0000098 (STATUS_FILE_INVALID) */
    ERROR_ALLOTTED_SPACE_EXCEEDED,                     /* c0000099 (STATUS_ALLOTTED_SPACE_EXCEEDED) */
    ERROR_NO_SYSTEM_RESOURCES,                         /* c000009a (STATUS_INSUFFICIENT_RESOURCES) */
    ERROR_PATH_NOT_FOUND,                              /* c000009b (STATUS_DFS_EXIT_PATH_FOUND) */
    ERROR_CRC,                                         /* c000009c (STATUS_DEVICE_DATA_ERROR) */
    ERROR_DEVICE_NOT_CONNECTED,                        /* c000009d (STATUS_DEVICE_NOT_CONNECTED) */
    ERROR_NOT_READY,                                   /* c000009e (STATUS_DEVICE_POWER_FAILURE) */
    ERROR_INVALID_ADDRESS,                             /* c000009f (STATUS_FREE_VM_NOT_AT_BASE) */
    ERROR_INVALID_ADDRESS,                             /* c00000a0 (STATUS_MEMORY_NOT_ALLOCATED) */
    ERROR_WORKING_SET_QUOTA,                           /* c00000a1 (STATUS_WORKING_SET_QUOTA) */
    ERROR_WRITE_PROTECT,                               /* c00000a2 (STATUS_MEDIA_WRITE_PROTECTED) */
    ERROR_NOT_READY,                                   /* c00000a3 (STATUS_DEVICE_NOT_READY) */
    ERROR_INVALID_GROUP_ATTRIBUTES,                    /* c00000a4 (STATUS_INVALID_GROUP_ATTRIBUTES) */
    ERROR_BAD_IMPERSONATION_LEVEL,                     /* c00000a5 (STATUS_BAD_IMPERSONATION_LEVEL) */
    ERROR_CANT_OPEN_ANONYMOUS,                         /* c00000a6 (STATUS_CANT_OPEN_ANONYMOUS) */
    ERROR_BAD_VALIDATION_CLASS,                        /* c00000a7 (STATUS_BAD_VALIDATION_CLASS) */
    ERROR_BAD_TOKEN_TYPE,                              /* c00000a8 (STATUS_BAD_TOKEN_TYPE) */
    ERROR_INVALID_PARAMETER,                           /* c00000a9 (STATUS_BAD_MASTER_BOOT_RECORD) */
    ERROR_INSTRUCTION_MISALIGNMENT,                    /* c00000aa (STATUS_INSTRUCTION_MISALIGNMENT) */
    ERROR_PIPE_BUSY,                                   /* c00000ab (STATUS_INSTANCE_NOT_AVAILABLE) */
    ERROR_PIPE_BUSY,                                   /* c00000ac (STATUS_PIPE_NOT_AVAILABLE) */
    ERROR_BAD_PIPE,                                    /* c00000ad (STATUS_INVALID_PIPE_STATE) */
    ERROR_PIPE_BUSY,                                   /* c00000ae (STATUS_PIPE_BUSY) */
    ERROR_INVALID_FUNCTION,                            /* c00000af (STATUS_ILLEGAL_FUNCTION) */
    ERROR_PIPE_NOT_CONNECTED,                          /* c00000b0 (STATUS_PIPE_DISCONNECTED) */
    ERROR_NO_DATA,                                     /* c00000b1 (STATUS_PIPE_CLOSING) */
    ERROR_PIPE_CONNECTED,                              /* c00000b2 (STATUS_PIPE_CONNECTED) */
    ERROR_PIPE_LISTENING,                              /* c00000b3 (STATUS_PIPE_LISTENING) */
    ERROR_BAD_PIPE,                                    /* c00000b4 (STATUS_INVALID_READ_MODE) */
    ERROR_SEM_TIMEOUT,                                 /* c00000b5 (STATUS_IO_TIMEOUT) */
    ERROR_HANDLE_EOF,                                  /* c00000b6 (STATUS_FILE_FORCED_CLOSED) */
    ERROR_PROFILING_NOT_STARTED,                       /* c00000b7 (STATUS_PROFILING_NOT_STARTED) */
    ERROR_PROFILING_NOT_STOPPED,                       /* c00000b8 (STATUS_PROFILING_NOT_STOPPED) */
    ERROR_COULD_NOT_INTERPRET,                         /* c00000b9 (STATUS_COULD_NOT_INTERPRET) */
    ERROR_ACCESS_DENIED,                               /* c00000ba (STATUS_FILE_IS_A_DIRECTORY) */
    ERROR_NOT_SUPPORTED,                               /* c00000bb (STATUS_NOT_SUPPORTED) */
    ERROR_REM_NOT_LIST,                                /* c00000bc (STATUS_REMOTE_NOT_LISTENING) */
    ERROR_DUP_NAME,                                    /* c00000bd (STATUS_DUPLICATE_NAME) */
    ERROR_BAD_NETPATH,                                 /* c00000be (STATUS_BAD_NETWORK_PATH) */
    ERROR_NETWORK_BUSY,                                /* c00000bf (STATUS_NETWORK_BUSY) */
    ERROR_DEV_NOT_EXIST,                               /* c00000c0 (STATUS_DEVICE_DOES_NOT_EXIST) */
    ERROR_TOO_MANY_CMDS,                               /* c00000c1 (STATUS_TOO_MANY_COMMANDS) */
    ERROR_ADAP_HDW_ERR,                                /* c00000c2 (STATUS_ADAPTER_HARDWARE_ERROR) */
    ERROR_BAD_NET_RESP,                                /* c00000c3 (STATUS_INVALID_NETWORK_RESPONSE) */
    ERROR_UNEXP_NET_ERR,                               /* c00000c4 (STATUS_UNEXPECTED_NETWORK_ERROR) */
    ERROR_BAD_REM_ADAP,                                /* c00000c5 (STATUS_BAD_REMOTE_ADAPTER) */
    ERROR_PRINTQ_FULL,                                 /* c00000c6 (STATUS_PRINT_QUEUE_FULL) */
    ERROR_NO_SPOOL_SPACE,                              /* c00000c7 (STATUS_NO_SPOOL_SPACE) */
    ERROR_PRINT_CANCELLED,                             /* c00000c8 (STATUS_PRINT_CANCELLED) */
    ERROR_NETNAME_DELETED,                             /* c00000c9 (STATUS_NETWORK_NAME_DELETED) */
    ERROR_NETWORK_ACCESS_DENIED,                       /* c00000ca (STATUS_NETWORK_ACCESS_DENIED) */
    ERROR_BAD_DEV_TYPE,                                /* c00000cb (STATUS_BAD_DEVICE_TYPE) */
    ERROR_BAD_NET_NAME,                                /* c00000cc (STATUS_BAD_NETWORK_NAME) */
    ERROR_TOO_MANY_NAMES,                              /* c00000cd (STATUS_TOO_MANY_NAMES) */
    ERROR_TOO_MANY_SESS,                               /* c00000ce (STATUS_TOO_MANY_SESSIONS) */
    ERROR_SHARING_PAUSED,                              /* c00000cf (STATUS_SHARING_PAUSED) */
    ERROR_REQ_NOT_ACCEP,                               /* c00000d0 (STATUS_REQUEST_NOT_ACCEPTED) */
    ERROR_REDIR_PAUSED,                                /* c00000d1 (STATUS_REDIRECTOR_PAUSED) */
    ERROR_NET_WRITE_FAULT,                             /* c00000d2 (STATUS_NET_WRITE_FAULT) */
    ERROR_PROFILING_AT_LIMIT,                          /* c00000d3 (STATUS_PROFILING_AT_LIMIT) */
    ERROR_NOT_SAME_DEVICE,                             /* c00000d4 (STATUS_NOT_SAME_DEVICE) */
    ERROR_ACCESS_DENIED,                               /* c00000d5 (STATUS_FILE_RENAMED) */
    ERROR_VC_DISCONNECTED,                             /* c00000d6 (STATUS_VIRTUAL_CIRCUIT_CLOSED) */
    ERROR_NO_SECURITY_ON_OBJECT,                       /* c00000d7 (STATUS_NO_SECURITY_ON_OBJECT) */
    ERROR_CANT_WAIT,                                   /* c00000d8 (STATUS_CANT_WAIT) */
    ERROR_NO_DATA,                                     /* c00000d9 (STATUS_PIPE_EMPTY) */
    ERROR_CANT_ACCESS_DOMAIN_INFO,                     /* c00000da (STATUS_CANT_ACCESS_DOMAIN_INFO) */
    ERROR_CANT_TERMINATE_SELF,                         /* c00000db (STATUS_CANT_TERMINATE_SELF) */
    ERROR_INVALID_SERVER_STATE,                        /* c00000dc (STATUS_INVALID_SERVER_STATE) */
    ERROR_INVALID_DOMAIN_STATE,                        /* c00000dd (STATUS_INVALID_DOMAIN_STATE) */
    ERROR_INVALID_DOMAIN_ROLE,                         /* c00000de (STATUS_INVALID_DOMAIN_ROLE) */
    ERROR_NO_SUCH_DOMAIN,                              /* c00000df (STATUS_NO_SUCH_DOMAIN) */
    ERROR_DOMAIN_EXISTS,                               /* c00000e0 (STATUS_DOMAIN_EXISTS) */
    ERROR_DOMAIN_LIMIT_EXCEEDED,                       /* c00000e1 (STATUS_DOMAIN_LIMIT_EXCEEDED) */
    ERROR_OPLOCK_NOT_GRANTED,                          /* c00000e2 (STATUS_OPLOCK_NOT_GRANTED) */
    ERROR_INVALID_OPLOCK_PROTOCOL,                     /* c00000e3 (STATUS_INVALID_OPLOCK_PROTOCOL) */
    ERROR_INTERNAL_DB_CORRUPTION,                      /* c00000e4 (STATUS_INTERNAL_DB_CORRUPTION) */
    ERROR_INTERNAL_ERROR,                              /* c00000e5 (STATUS_INTERNAL_ERROR) */
    ERROR_GENERIC_NOT_MAPPED,                          /* c00000e6 (STATUS_GENERIC_NOT_MAPPED) */
    ERROR_BAD_DESCRIPTOR_FORMAT,                       /* c00000e7 (STATUS_BAD_DESCRIPTOR_FORMAT) */
    ERROR_INVALID_USER_BUFFER,                         /* c00000e8 (STATUS_INVALID_USER_BUFFER) */
    ERROR_IO_DEVICE,                                   /* c00000e9 (STATUS_UNEXPECTED_IO_ERROR) */
    ERROR_UNEXPECTED_MM_CREATE_ERR,                    /* c00000ea (STATUS_UNEXPECTED_MM_CREATE_ERR) */
    ERROR_UNEXPECTED_MM_MAP_ERROR,                     /* c00000eb (STATUS_UNEXPECTED_MM_MAP_ERROR) */
    ERROR_UNEXPECTED_MM_EXTEND_ERR,                    /* c00000ec (STATUS_UNEXPECTED_MM_EXTEND_ERR) */
    ERROR_NOT_LOGON_PROCESS,                           /* c00000ed (STATUS_NOT_LOGON_PROCESS) */
    ERROR_LOGON_SESSION_EXISTS,                        /* c00000ee (STATUS_LOGON_SESSION_EXISTS) */
    ERROR_INVALID_PARAMETER,                           /* c00000ef (STATUS_INVALID_PARAMETER_1) */
    ERROR_INVALID_PARAMETER,                           /* c00000f0 (STATUS_INVALID_PARAMETER_2) */
    ERROR_INVALID_PARAMETER,                           /* c00000f1 (STATUS_INVALID_PARAMETER_3) */
    ERROR_INVALID_PARAMETER,                           /* c00000f2 (STATUS_INVALID_PARAMETER_4) */
    ERROR_INVALID_PARAMETER,                           /* c00000f3 (STATUS_INVALID_PARAMETER_5) */
    ERROR_INVALID_PARAMETER,                           /* c00000f4 (STATUS_INVALID_PARAMETER_6) */
    ERROR_INVALID_PARAMETER,                           /* c00000f5 (STATUS_INVALID_PARAMETER_7) */
    ERROR_INVALID_PARAMETER,                           /* c00000f6 (STATUS_INVALID_PARAMETER_8) */
    ERROR_INVALID_PARAMETER,                           /* c00000f7 (STATUS_INVALID_PARAMETER_9) */
    ERROR_INVALID_PARAMETER,                           /* c00000f8 (STATUS_INVALID_PARAMETER_10) */
    ERROR_INVALID_PARAMETER,                           /* c00000f9 (STATUS_INVALID_PARAMETER_11) */
    ERROR_INVALID_PARAMETER,                           /* c00000fa (STATUS_INVALID_PARAMETER_12) */
    ERROR_PATH_NOT_FOUND,                              /* c00000fb (STATUS_REDIRECTOR_NOT_STARTED) */
    ERROR_SERVICE_ALREADY_RUNNING,                     /* c00000fc (STATUS_REDIRECTOR_STARTED) */
    ERROR_STACK_OVERFLOW,                              /* c00000fd (STATUS_STACK_OVERFLOW) */
    ERROR_NO_SUCH_PACKAGE,                             /* c00000fe (STATUS_NO_SUCH_PACKAGE) */
    ERROR_BAD_FUNCTION_TABLE,                          /* c00000ff (STATUS_BAD_FUNCTION_TABLE) */
    ERROR_ENVVAR_NOT_FOUND,                            /* c0000100 (STATUS_VARIABLE_NOT_FOUND) */
    ERROR_DIR_NOT_EMPTY,                               /* c0000101 (STATUS_DIRECTORY_NOT_EMPTY) */
    ERROR_FILE_CORRUPT,                                /* c0000102 (STATUS_FILE_CORRUPT_ERROR) */
    ERROR_DIRECTORY,                                   /* c0000103 (STATUS_NOT_A_DIRECTORY) */
    ERROR_BAD_LOGON_SESSION_STATE,                     /* c0000104 (STATUS_BAD_LOGON_SESSION_STATE) */
    ERROR_LOGON_SESSION_COLLISION,                     /* c0000105 (STATUS_LOGON_SESSION_COLLISION) */
    ERROR_FILENAME_EXCED_RANGE,                        /* c0000106 (STATUS_NAME_TOO_LONG) */
    ERROR_OPEN_FILES,                                  /* c0000107 (STATUS_FILES_OPEN) */
    ERROR_DEVICE_IN_USE,                               /* c0000108 (STATUS_CONNECTION_IN_USE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000109 (STATUS_MESSAGE_NOT_FOUND) */
    ERROR_ACCESS_DENIED,                               /* c000010a (STATUS_PROCESS_IS_TERMINATING) */
    ERROR_INVALID_LOGON_TYPE,                          /* c000010b (STATUS_INVALID_LOGON_TYPE) */
    ERROR_NO_GUID_TRANSLATION,                         /* c000010c (STATUS_NO_GUID_TRANSLATION) */
    ERROR_CANNOT_IMPERSONATE,                          /* c000010d (STATUS_CANNOT_IMPERSONATE) */
    ERROR_SERVICE_ALREADY_RUNNING,                     /* c000010e (STATUS_IMAGE_ALREADY_LOADED) */
    ERROR_ABIOS_ERROR,                                 /* c000010f (STATUS_ABIOS_NOT_PRESENT) */
    ERROR_ABIOS_ERROR,                                 /* c0000110 (STATUS_ABIOS_LID_NOT_EXIST) */
    ERROR_ABIOS_ERROR,                                 /* c0000111 (STATUS_ABIOS_LID_ALREADY_OWNED) */
    ERROR_ABIOS_ERROR,                                 /* c0000112 (STATUS_ABIOS_NOT_LID_OWNER) */
    ERROR_ABIOS_ERROR,                                 /* c0000113 (STATUS_ABIOS_INVALID_COMMAND) */
    ERROR_ABIOS_ERROR,                                 /* c0000114 (STATUS_ABIOS_INVALID_LID) */
    ERROR_ABIOS_ERROR,                                 /* c0000115 (STATUS_ABIOS_SELECTOR_NOT_AVAILABLE) */
    ERROR_ABIOS_ERROR,                                 /* c0000116 (STATUS_ABIOS_INVALID_SELECTOR) */
    ERROR_INVALID_THREAD_ID,                           /* c0000117 (STATUS_NO_LDT) */
    ERROR_INVALID_LDT_SIZE,                            /* c0000118 (STATUS_INVALID_LDT_SIZE) */
    ERROR_INVALID_LDT_OFFSET,                          /* c0000119 (STATUS_INVALID_LDT_OFFSET) */
    ERROR_INVALID_LDT_DESCRIPTOR,                      /* c000011a (STATUS_INVALID_LDT_DESCRIPTOR) */
    ERROR_BAD_EXE_FORMAT,                              /* c000011b (STATUS_INVALID_IMAGE_NE_FORMAT) */
    ERROR_RXACT_INVALID_STATE,                         /* c000011c (STATUS_RXACT_INVALID_STATE) */
    ERROR_RXACT_COMMIT_FAILURE,                        /* c000011d (STATUS_RXACT_COMMIT_FAILURE) */
    ERROR_FILE_INVALID,                                /* c000011e (STATUS_MAPPED_FILE_SIZE_ZERO) */
    ERROR_TOO_MANY_OPEN_FILES,                         /* c000011f (STATUS_TOO_MANY_OPENED_FILES) */
    ERROR_OPERATION_ABORTED,                           /* c0000120 (STATUS_CANCELLED) */
    ERROR_ACCESS_DENIED,                               /* c0000121 (STATUS_CANNOT_DELETE) */
    ERROR_INVALID_COMPUTERNAME,                        /* c0000122 (STATUS_INVALID_COMPUTER_NAME) */
    ERROR_ACCESS_DENIED,                               /* c0000123 (STATUS_FILE_DELETED) */
    ERROR_SPECIAL_ACCOUNT,                             /* c0000124 (STATUS_SPECIAL_ACCOUNT) */
    ERROR_SPECIAL_GROUP,                               /* c0000125 (STATUS_SPECIAL_GROUP) */
    ERROR_SPECIAL_USER,                                /* c0000126 (STATUS_SPECIAL_USER) */
    ERROR_MEMBERS_PRIMARY_GROUP,                       /* c0000127 (STATUS_MEMBERS_PRIMARY_GROUP) */
    ERROR_INVALID_HANDLE,                              /* c0000128 (STATUS_FILE_CLOSED) */
    ERROR_TOO_MANY_THREADS,                            /* c0000129 (STATUS_TOO_MANY_THREADS) */
    ERROR_THREAD_NOT_IN_PROCESS,                       /* c000012a (STATUS_THREAD_NOT_IN_PROCESS) */
    ERROR_TOKEN_ALREADY_IN_USE,                        /* c000012b (STATUS_TOKEN_ALREADY_IN_USE) */
    ERROR_PAGEFILE_QUOTA_EXCEEDED,                     /* c000012c (STATUS_PAGEFILE_QUOTA_EXCEEDED) */
    ERROR_COMMITMENT_LIMIT,                            /* c000012d (STATUS_COMMITMENT_LIMIT) */
    ERROR_BAD_EXE_FORMAT,                              /* c000012e (STATUS_INVALID_IMAGE_LE_FORMAT) */
    ERROR_BAD_EXE_FORMAT,                              /* c000012f (STATUS_INVALID_IMAGE_NOT_MZ) */
    ERROR_BAD_EXE_FORMAT,                              /* c0000130 (STATUS_INVALID_IMAGE_PROTECT) */
    ERROR_BAD_EXE_FORMAT,                              /* c0000131 (STATUS_INVALID_IMAGE_WIN_16) */
    ERROR_LOGON_SERVER_CONFLICT,                       /* c0000132 (STATUS_LOGON_SERVER_CONFLICT) */
    ERROR_TIME_SKEW,                                   /* c0000133 (STATUS_TIME_DIFFERENCE_AT_DC) */
    ERROR_SYNCHRONIZATION_REQUIRED,                    /* c0000134 (STATUS_SYNCHRONIZATION_REQUIRED) */
    ERROR_MOD_NOT_FOUND,                               /* c0000135 (STATUS_DLL_NOT_FOUND) */
    ERROR_NET_OPEN_FAILED,                             /* c0000136 (STATUS_OPEN_FAILED) */
    ERROR_IO_PRIVILEGE_FAILED,                         /* c0000137 (STATUS_IO_PRIVILEGE_FAILED) */
    ERROR_INVALID_ORDINAL,                             /* c0000138 (STATUS_ORDINAL_NOT_FOUND) */
    ERROR_PROC_NOT_FOUND,                              /* c0000139 (STATUS_ENTRYPOINT_NOT_FOUND) */
    ERROR_CONTROL_C_EXIT,                              /* c000013a (STATUS_CONTROL_C_EXIT) */
    ERROR_NETNAME_DELETED,                             /* c000013b (STATUS_LOCAL_DISCONNECT) */
    ERROR_NETNAME_DELETED,                             /* c000013c (STATUS_REMOTE_DISCONNECT) */
    ERROR_REM_NOT_LIST,                                /* c000013d (STATUS_REMOTE_RESOURCES) */
    ERROR_UNEXP_NET_ERR,                               /* c000013e (STATUS_LINK_FAILED) */
    ERROR_UNEXP_NET_ERR,                               /* c000013f (STATUS_LINK_TIMEOUT) */
    ERROR_UNEXP_NET_ERR,                               /* c0000140 (STATUS_INVALID_CONNECTION) */
    ERROR_UNEXP_NET_ERR,                               /* c0000141 (STATUS_INVALID_ADDRESS) */
    ERROR_DLL_INIT_FAILED,                             /* c0000142 (STATUS_DLL_INIT_FAILED) */
    ERROR_MISSING_SYSTEMFILE,                          /* c0000143 (STATUS_MISSING_SYSTEMFILE) */
    ERROR_UNHANDLED_EXCEPTION,                         /* c0000144 (STATUS_UNHANDLED_EXCEPTION) */
    ERROR_APP_INIT_FAILURE,                            /* c0000145 (STATUS_APP_INIT_FAILURE) */
    ERROR_PAGEFILE_CREATE_FAILED,                      /* c0000146 (STATUS_PAGEFILE_CREATE_FAILED) */
    ERROR_NO_PAGEFILE,                                 /* c0000147 (STATUS_NO_PAGEFILE) */
    ERROR_INVALID_LEVEL,                               /* c0000148 (STATUS_INVALID_LEVEL) */
    ERROR_INVALID_PASSWORD,                            /* c0000149 (STATUS_WRONG_PASSWORD_CORE) */
    ERROR_ILLEGAL_FLOAT_CONTEXT,                       /* c000014a (STATUS_ILLEGAL_FLOAT_CONTEXT) */
    ERROR_BROKEN_PIPE,                                 /* c000014b (STATUS_PIPE_BROKEN) */
    ERROR_BADDB,                                       /* c000014c (STATUS_REGISTRY_CORRUPT) */
    ERROR_REGISTRY_IO_FAILED,                          /* c000014d (STATUS_REGISTRY_IO_FAILED) */
    ERROR_NO_EVENT_PAIR,                               /* c000014e (STATUS_NO_EVENT_PAIR) */
    ERROR_UNRECOGNIZED_VOLUME,                         /* c000014f (STATUS_UNRECOGNIZED_VOLUME) */
    ERROR_SERIAL_NO_DEVICE,                            /* c0000150 (STATUS_SERIAL_NO_DEVICE_INITED) */
    ERROR_NO_SUCH_ALIAS,                               /* c0000151 (STATUS_NO_SUCH_ALIAS) */
    ERROR_MEMBER_NOT_IN_ALIAS,                         /* c0000152 (STATUS_MEMBER_NOT_IN_ALIAS) */
    ERROR_MEMBER_IN_ALIAS,                             /* c0000153 (STATUS_MEMBER_IN_ALIAS) */
    ERROR_ALIAS_EXISTS,                                /* c0000154 (STATUS_ALIAS_EXISTS) */
    ERROR_LOGON_NOT_GRANTED,                           /* c0000155 (STATUS_LOGON_NOT_GRANTED) */
    ERROR_TOO_MANY_SECRETS,                            /* c0000156 (STATUS_TOO_MANY_SECRETS) */
    ERROR_SECRET_TOO_LONG,                             /* c0000157 (STATUS_SECRET_TOO_LONG) */
    ERROR_INTERNAL_DB_ERROR,                           /* c0000158 (STATUS_INTERNAL_DB_ERROR) */
    ERROR_FULLSCREEN_MODE,                             /* c0000159 (STATUS_FULLSCREEN_MODE) */
    ERROR_TOO_MANY_CONTEXT_IDS,                        /* c000015a (STATUS_TOO_MANY_CONTEXT_IDS) */
    ERROR_LOGON_TYPE_NOT_GRANTED,                      /* c000015b (STATUS_LOGON_TYPE_NOT_GRANTED) */
    ERROR_NOT_REGISTRY_FILE,                           /* c000015c (STATUS_NOT_REGISTRY_FILE) */
    ERROR_NT_CROSS_ENCRYPTION_REQUIRED,                /* c000015d (STATUS_NT_CROSS_ENCRYPTION_REQUIRED) */
    ERROR_DOMAIN_CTRLR_CONFIG_ERROR,                   /* c000015e (STATUS_DOMAIN_CTRLR_CONFIG_ERROR) */
    ERROR_IO_DEVICE,                                   /* c000015f (STATUS_FT_MISSING_MEMBER) */
    ERROR_SERVICE_NOT_FOUND,                           /* c0000160 (STATUS_ILL_FORMED_SERVICE_ENTRY) */
    ERROR_ILLEGAL_CHARACTER,                           /* c0000161 (STATUS_ILLEGAL_CHARACTER) */
    ERROR_NO_UNICODE_TRANSLATION,                      /* c0000162 (STATUS_UNMAPPABLE_CHARACTER) */
    ERROR_UNDEFINED_CHARACTER,                         /* c0000163 (STATUS_UNDEFINED_CHARACTER) */
    ERROR_FLOPPY_VOLUME,                               /* c0000164 (STATUS_FLOPPY_VOLUME) */
    ERROR_FLOPPY_ID_MARK_NOT_FOUND,                    /* c0000165 (STATUS_FLOPPY_ID_MARK_NOT_FOUND) */
    ERROR_FLOPPY_WRONG_CYLINDER,                       /* c0000166 (STATUS_FLOPPY_WRONG_CYLINDER) */
    ERROR_FLOPPY_UNKNOWN_ERROR,                        /* c0000167 (STATUS_FLOPPY_UNKNOWN_ERROR) */
    ERROR_FLOPPY_BAD_REGISTERS,                        /* c0000168 (STATUS_FLOPPY_BAD_REGISTERS) */
    ERROR_DISK_RECALIBRATE_FAILED,                     /* c0000169 (STATUS_DISK_RECALIBRATE_FAILED) */
    ERROR_DISK_OPERATION_FAILED,                       /* c000016a (STATUS_DISK_OPERATION_FAILED) */
    ERROR_DISK_RESET_FAILED,                           /* c000016b (STATUS_DISK_RESET_FAILED) */
    ERROR_IRQ_BUSY,                                    /* c000016c (STATUS_SHARED_IRQ_BUSY) */
    ERROR_IO_DEVICE,                                   /* c000016d (STATUS_FT_ORPHANING) */
    ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT,            /* c000016e (STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT) */
    ERROR_MR_MID_NOT_FOUND,                            /* c000016f */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000170 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000171 */
    ERROR_PARTITION_FAILURE,                           /* c0000172 (STATUS_PARTITION_FAILURE) */
    ERROR_INVALID_BLOCK_LENGTH,                        /* c0000173 (STATUS_INVALID_BLOCK_LENGTH) */
    ERROR_DEVICE_NOT_PARTITIONED,                      /* c0000174 (STATUS_DEVICE_NOT_PARTITIONED) */
    ERROR_UNABLE_TO_LOCK_MEDIA,                        /* c0000175 (STATUS_UNABLE_TO_LOCK_MEDIA) */
    ERROR_UNABLE_TO_UNLOAD_MEDIA,                      /* c0000176 (STATUS_UNABLE_TO_UNLOAD_MEDIA) */
    ERROR_EOM_OVERFLOW,                                /* c0000177 (STATUS_EOM_OVERFLOW) */
    ERROR_NO_MEDIA_IN_DRIVE,                           /* c0000178 (STATUS_NO_MEDIA) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000179 */
    ERROR_NO_SUCH_MEMBER,                              /* c000017a (STATUS_NO_SUCH_MEMBER) */
    ERROR_INVALID_MEMBER,                              /* c000017b (STATUS_INVALID_MEMBER) */
    ERROR_KEY_DELETED,                                 /* c000017c (STATUS_KEY_DELETED) */
    ERROR_NO_LOG_SPACE,                                /* c000017d (STATUS_NO_LOG_SPACE) */
    ERROR_TOO_MANY_SIDS,                               /* c000017e (STATUS_TOO_MANY_SIDS) */
    ERROR_LM_CROSS_ENCRYPTION_REQUIRED,                /* c000017f (STATUS_LM_CROSS_ENCRYPTION_REQUIRED) */
    ERROR_KEY_HAS_CHILDREN,                            /* c0000180 (STATUS_KEY_HAS_CHILDREN) */
    ERROR_CHILD_MUST_BE_VOLATILE,                      /* c0000181 (STATUS_CHILD_MUST_BE_VOLATILE) */
    ERROR_INVALID_PARAMETER,                           /* c0000182 (STATUS_DEVICE_CONFIGURATION_ERROR) */
    ERROR_IO_DEVICE,                                   /* c0000183 (STATUS_DRIVER_INTERNAL_ERROR) */
    ERROR_BAD_COMMAND,                                 /* c0000184 (STATUS_INVALID_DEVICE_STATE) */
    ERROR_IO_DEVICE,                                   /* c0000185 (STATUS_IO_DEVICE_ERROR) */
    ERROR_IO_DEVICE,                                   /* c0000186 (STATUS_DEVICE_PROTOCOL_ERROR) */
    ERROR_BACKUP_CONTROLLER,                           /* c0000187 (STATUS_BACKUP_CONTROLLER) */
    ERROR_LOG_FILE_FULL,                               /* c0000188 (STATUS_LOG_FILE_FULL) */
    ERROR_WRITE_PROTECT,                               /* c0000189 (STATUS_TOO_LATE) */
    ERROR_NO_TRUST_LSA_SECRET,                         /* c000018a (STATUS_NO_TRUST_LSA_SECRET) */
    ERROR_NO_TRUST_SAM_ACCOUNT,                        /* c000018b (STATUS_NO_TRUST_SAM_ACCOUNT) */
    ERROR_TRUSTED_DOMAIN_FAILURE,                      /* c000018c (STATUS_TRUSTED_DOMAIN_FAILURE) */
    ERROR_TRUSTED_RELATIONSHIP_FAILURE,                /* c000018d (STATUS_TRUSTED_RELATIONSHIP_FAILURE) */
    ERROR_EVENTLOG_FILE_CORRUPT,                       /* c000018e (STATUS_EVENTLOG_FILE_CORRUPT) */
    ERROR_EVENTLOG_CANT_START,                         /* c000018f (STATUS_EVENTLOG_CANT_START) */
    ERROR_TRUST_FAILURE,                               /* c0000190 (STATUS_TRUST_FAILURE) */
    ERROR_MUTANT_LIMIT_EXCEEDED,                       /* c0000191 (STATUS_MUTANT_LIMIT_EXCEEDED) */
    ERROR_NETLOGON_NOT_STARTED,                        /* c0000192 (STATUS_NETLOGON_NOT_STARTED) */
    ERROR_ACCOUNT_EXPIRED,                             /* c0000193 (STATUS_ACCOUNT_EXPIRED) */
    ERROR_POSSIBLE_DEADLOCK,                           /* c0000194 (STATUS_POSSIBLE_DEADLOCK) */
    ERROR_SESSION_CREDENTIAL_CONFLICT,                 /* c0000195 (STATUS_NETWORK_CREDENTIAL_CONFLICT) */
    ERROR_REMOTE_SESSION_LIMIT_EXCEEDED,               /* c0000196 (STATUS_REMOTE_SESSION_LIMIT) */
    ERROR_EVENTLOG_FILE_CHANGED,                       /* c0000197 (STATUS_EVENTLOG_FILE_CHANGED) */
    ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT,           /* c0000198 (STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT) */
    ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT,           /* c0000199 (STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT) */
    ERROR_NOLOGON_SERVER_TRUST_ACCOUNT,                /* c000019a (STATUS_NOLOGON_SERVER_TRUST_ACCOUNT) */
    ERROR_DOMAIN_TRUST_INCONSISTENT,                   /* c000019b (STATUS_DOMAIN_TRUST_INCONSISTENT) */
    ERROR_FS_DRIVER_REQUIRED,                          /* c000019c (STATUS_FS_DRIVER_REQUIRED) */
    ERROR_SERVICE_ALREADY_RUNNING,                     /* c000019d (STATUS_IMAGE_ALREADY_LOADED_AS_DLL) */
    ERROR_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING, /* c000019e (STATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING) */
    ERROR_SHORT_NAMES_NOT_ENABLED_ON_VOLUME,           /* c000019f (STATUS_SHORT_NAMES_NOT_ENABLED_ON_VOLUME) */
    ERROR_SECURITY_STREAM_IS_INCONSISTENT,             /* c00001a0 (STATUS_SECURITY_STREAM_IS_INCONSISTENT) */
    ERROR_INVALID_LOCK_RANGE,                          /* c00001a1 (STATUS_INVALID_LOCK_RANGE) */
    ERROR_INVALID_ACE_CONDITION,                       /* c00001a2 (STATUS_INVALID_ACE_CONDITION) */
    ERROR_IMAGE_SUBSYSTEM_NOT_PRESENT,                 /* c00001a3 (STATUS_IMAGE_SUBSYSTEM_NOT_PRESENT) */
    ERROR_NOTIFICATION_GUID_ALREADY_DEFINED,           /* c00001a4 (STATUS_NOTIFICATION_GUID_ALREADY_DEFINED) */
    ERROR_INVALID_EXCEPTION_HANDLER,                   /* c00001a5 (STATUS_INVALID_EXCEPTION_HANDLER) */
    ERROR_DUPLICATE_PRIVILEGES,                        /* c00001a6 (STATUS_DUPLICATE_PRIVILEGES) */
    ERROR_NOT_ALLOWED_ON_SYSTEM_FILE,                  /* c00001a7 (STATUS_NOT_ALLOWED_ON_SYSTEM_FILE) */
    ERROR_DATA_LOST_REPAIR,                            /* c00001a8 (STATUS_REPAIR_NEEDED) */
    ERROR_NOT_SUPPORTED,                               /* c00001a9 (STATUS_QUOTA_NOT_ENABLED) */
    APPMODEL_ERROR_NO_PACKAGE,                         /* c00001aa (STATUS_NO_APPLICATION_PACKAGE) */
    ERROR_FILE_METADATA_OPTIMIZATION_IN_PROGRESS,      /* c00001ab (STATUS_FILE_METADATA_OPTIMIZATION_IN_PROGRESS) */
    ERROR_NOT_SAME_OBJECT,                             /* c00001ac (STATUS_NOT_SAME_OBJECT) */
    ERROR_NOT_ENOUGH_MEMORY,                           /* c00001ad (STATUS_FATAL_MEMORY_EXHAUSTION) */
    ERROR_PROCESS_NOT_IN_JOB,                          /* c00001ae (STATUS_ERROR_PROCESS_NOT_IN_JOB) */
    ERROR_CPU_SET_INVALID,                             /* c00001af (STATUS_CPU_SET_INVALID) */
    ERROR_INVALID_DATA,                                /* c00001b0 (STATUS_IO_DEVICE_INVALID_DATA) */
    ERROR_INVALID_DATA,                                /* c00001b1 (STATUS_IO_UNALIGNED_WRITE) */
    ERROR_NOACCESS,                                    /* c00001b2 (STATUS_CONTROL_STACK_VIOLATION) */
    ERROR_WEAK_WHFBKEY_BLOCKED,                        /* c00001b3 (STATUS_WEAK_WHFBKEY_BLOCKED) */
    ERROR_SERVER_TRANSPORT_CONFLICT,                   /* c00001b4 (STATUS_SERVER_TRANSPORT_CONFLICT) */
    ERROR_CERTIFICATE_VALIDATION_PREFERENCE_CONFLICT,  /* c00001b5 (STATUS_CERTIFICATE_VALIDATION_PREFERENCE_CONFLICT) */
    ERROR_NETWORK_ACCESS_DENIED,                       /* c0000201 (STATUS_NETWORK_OPEN_RESTRICTION) */
    ERROR_NO_USER_SESSION_KEY,                         /* c0000202 (STATUS_NO_USER_SESSION_KEY) */
    ERROR_UNEXP_NET_ERR,                               /* c0000203 (STATUS_USER_SESSION_DELETED) */
    ERROR_RESOURCE_LANG_NOT_FOUND,                     /* c0000204 (STATUS_RESOURCE_LANG_NOT_FOUND) */
    ERROR_NOT_ENOUGH_SERVER_MEMORY,                    /* c0000205 (STATUS_INSUFF_SERVER_RESOURCES) */
    ERROR_INVALID_USER_BUFFER,                         /* c0000206 (STATUS_INVALID_BUFFER_SIZE) */
    ERROR_INVALID_NETNAME,                             /* c0000207 (STATUS_INVALID_ADDRESS_COMPONENT) */
    ERROR_INVALID_NETNAME,                             /* c0000208 (STATUS_INVALID_ADDRESS_WILDCARD) */
    ERROR_TOO_MANY_NAMES,                              /* c0000209 (STATUS_TOO_MANY_ADDRESSES) */
    ERROR_DUP_NAME,                                    /* c000020a (STATUS_ADDRESS_ALREADY_EXISTS) */
    ERROR_NETNAME_DELETED,                             /* c000020b (STATUS_ADDRESS_CLOSED) */
    ERROR_NETNAME_DELETED,                             /* c000020c (STATUS_CONNECTION_DISCONNECTED) */
    ERROR_NETNAME_DELETED,                             /* c000020d (STATUS_CONNECTION_RESET) */
    ERROR_TOO_MANY_NAMES,                              /* c000020e (STATUS_TOO_MANY_NODES) */
    ERROR_UNEXP_NET_ERR,                               /* c000020f (STATUS_TRANSACTION_ABORTED) */
    ERROR_UNEXP_NET_ERR,                               /* c0000210 (STATUS_TRANSACTION_TIMED_OUT) */
    ERROR_UNEXP_NET_ERR,                               /* c0000211 (STATUS_TRANSACTION_NO_RELEASE) */
    ERROR_UNEXP_NET_ERR,                               /* c0000212 (STATUS_TRANSACTION_NO_MATCH) */
    ERROR_UNEXP_NET_ERR,                               /* c0000213 (STATUS_TRANSACTION_RESPONDED) */
    ERROR_UNEXP_NET_ERR,                               /* c0000214 (STATUS_TRANSACTION_INVALID_ID) */
    ERROR_UNEXP_NET_ERR,                               /* c0000215 (STATUS_TRANSACTION_INVALID_TYPE) */
    ERROR_NOT_SUPPORTED,                               /* c0000216 (STATUS_NOT_SERVER_SESSION) */
    ERROR_NOT_SUPPORTED,                               /* c0000217 (STATUS_NOT_CLIENT_SESSION) */
    ERROR_CANNOT_LOAD_REGISTRY_FILE,                   /* c0000218 (STATUS_CANNOT_LOAD_REGISTRY_FILE) */
    ERROR_DEBUG_ATTACH_FAILED,                         /* c0000219 (STATUS_DEBUG_ATTACH_FAILED) */
    ERROR_SYSTEM_PROCESS_TERMINATED,                   /* c000021a (STATUS_SYSTEM_PROCESS_TERMINATED) */
    ERROR_DATA_NOT_ACCEPTED,                           /* c000021b (STATUS_DATA_NOT_ACCEPTED) */
    ERROR_NO_BROWSER_SERVERS_FOUND,                    /* c000021c (STATUS_NO_BROWSER_SERVERS_FOUND) */
    ERROR_VDM_HARD_ERROR,                              /* c000021d (STATUS_VDM_HARD_ERROR) */
    ERROR_DRIVER_CANCEL_TIMEOUT,                       /* c000021e (STATUS_DRIVER_CANCEL_TIMEOUT) */
    ERROR_REPLY_MESSAGE_MISMATCH,                      /* c000021f (STATUS_REPLY_MESSAGE_MISMATCH) */
    ERROR_MAPPED_ALIGNMENT,                            /* c0000220 (STATUS_MAPPED_ALIGNMENT) */
    ERROR_BAD_EXE_FORMAT,                              /* c0000221 (STATUS_IMAGE_CHECKSUM_MISMATCH) */
    ERROR_LOST_WRITEBEHIND_DATA,                       /* c0000222 (STATUS_LOST_WRITEBEHIND_DATA) */
    ERROR_CLIENT_SERVER_PARAMETERS_INVALID,            /* c0000223 (STATUS_CLIENT_SERVER_PARAMETERS_INVALID) */
    ERROR_PASSWORD_MUST_CHANGE,                        /* c0000224 (STATUS_PASSWORD_MUST_CHANGE) */
    ERROR_NOT_FOUND,                                   /* c0000225 (STATUS_NOT_FOUND) */
    ERROR_NOT_TINY_STREAM,                             /* c0000226 (STATUS_NOT_TINY_STREAM) */
    ERROR_RECOVERY_FAILURE,                            /* c0000227 (STATUS_RECOVERY_FAILURE) */
    ERROR_STACK_OVERFLOW_READ,                         /* c0000228 (STATUS_STACK_OVERFLOW_READ) */
    ERROR_INVALID_PARAMETER,                           /* c0000229 (STATUS_FAIL_CHECK) */
    ERROR_OBJECT_ALREADY_EXISTS,                       /* c000022a (STATUS_DUPLICATE_OBJECTID) */
    ERROR_OBJECT_ALREADY_EXISTS,                       /* c000022b (STATUS_OBJECTID_EXISTS) */
    ERROR_CONVERT_TO_LARGE,                            /* c000022c (STATUS_CONVERT_TO_LARGE) */
    ERROR_RETRY,                                       /* c000022d (STATUS_RETRY) */
    ERROR_FOUND_OUT_OF_SCOPE,                          /* c000022e (STATUS_FOUND_OUT_OF_SCOPE) */
    ERROR_ALLOCATE_BUCKET,                             /* c000022f (STATUS_ALLOCATE_BUCKET) */
    ERROR_SET_NOT_FOUND,                               /* c0000230 (STATUS_PROPSET_NOT_FOUND) */
    ERROR_MARSHALL_OVERFLOW,                           /* c0000231 (STATUS_MARSHALL_OVERFLOW) */
    ERROR_INVALID_VARIANT,                             /* c0000232 (STATUS_INVALID_VARIANT) */
    ERROR_DOMAIN_CONTROLLER_NOT_FOUND,                 /* c0000233 (STATUS_DOMAIN_CONTROLLER_NOT_FOUND) */
    ERROR_ACCOUNT_LOCKED_OUT,                          /* c0000234 (STATUS_ACCOUNT_LOCKED_OUT) */
    ERROR_INVALID_HANDLE,                              /* c0000235 (STATUS_HANDLE_NOT_CLOSABLE) */
    ERROR_CONNECTION_REFUSED,                          /* c0000236 (STATUS_CONNECTION_REFUSED) */
    ERROR_GRACEFUL_DISCONNECT,                         /* c0000237 (STATUS_GRACEFUL_DISCONNECT) */
    ERROR_ADDRESS_ALREADY_ASSOCIATED,                  /* c0000238 (STATUS_ADDRESS_ALREADY_ASSOCIATED) */
    ERROR_ADDRESS_NOT_ASSOCIATED,                      /* c0000239 (STATUS_ADDRESS_NOT_ASSOCIATED) */
    ERROR_CONNECTION_INVALID,                          /* c000023a (STATUS_CONNECTION_INVALID) */
    ERROR_CONNECTION_ACTIVE,                           /* c000023b (STATUS_CONNECTION_ACTIVE) */
    ERROR_NETWORK_UNREACHABLE,                         /* c000023c (STATUS_NETWORK_UNREACHABLE) */
    ERROR_HOST_UNREACHABLE,                            /* c000023d (STATUS_HOST_UNREACHABLE) */
    ERROR_PROTOCOL_UNREACHABLE,                        /* c000023e (STATUS_PROTOCOL_UNREACHABLE) */
    ERROR_PORT_UNREACHABLE,                            /* c000023f (STATUS_PORT_UNREACHABLE) */
    ERROR_REQUEST_ABORTED,                             /* c0000240 (STATUS_REQUEST_ABORTED) */
    ERROR_CONNECTION_ABORTED,                          /* c0000241 (STATUS_CONNECTION_ABORTED) */
    ERROR_BAD_COMPRESSION_BUFFER,                      /* c0000242 (STATUS_BAD_COMPRESSION_BUFFER) */
    ERROR_USER_MAPPED_FILE,                            /* c0000243 (STATUS_USER_MAPPED_FILE) */
    ERROR_AUDIT_FAILED,                                /* c0000244 (STATUS_AUDIT_FAILED) */
    ERROR_TIMER_RESOLUTION_NOT_SET,                    /* c0000245 (STATUS_TIMER_RESOLUTION_NOT_SET) */
    ERROR_CONNECTION_COUNT_LIMIT,                      /* c0000246 (STATUS_CONNECTION_COUNT_LIMIT) */
    ERROR_LOGIN_TIME_RESTRICTION,                      /* c0000247 (STATUS_LOGIN_TIME_RESTRICTION) */
    ERROR_LOGIN_WKSTA_RESTRICTION,                     /* c0000248 (STATUS_LOGIN_WKSTA_RESTRICTION) */
    ERROR_BAD_EXE_FORMAT,                              /* c0000249 (STATUS_IMAGE_MP_UP_MISMATCH) */
    ERROR_MR_MID_NOT_FOUND,                            /* c000024a */
    ERROR_MR_MID_NOT_FOUND,                            /* c000024b */
    ERROR_MR_MID_NOT_FOUND,                            /* c000024c */
    ERROR_MR_MID_NOT_FOUND,                            /* c000024d */
    ERROR_MR_MID_NOT_FOUND,                            /* c000024e */
    ERROR_MR_MID_NOT_FOUND,                            /* c000024f */
    ERROR_INSUFFICIENT_LOGON_INFO,                     /* c0000250 (STATUS_INSUFFICIENT_LOGON_INFO) */
    ERROR_BAD_DLL_ENTRYPOINT,                          /* c0000251 (STATUS_BAD_DLL_ENTRYPOINT) */
    ERROR_BAD_SERVICE_ENTRYPOINT,                      /* c0000252 (STATUS_BAD_SERVICE_ENTRYPOINT) */
    ERROR_CONNECTION_ABORTED,                          /* c0000253 (STATUS_LPC_REPLY_LOST) */
    ERROR_IP_ADDRESS_CONFLICT1,                        /* c0000254 (STATUS_IP_ADDRESS_CONFLICT1) */
    ERROR_IP_ADDRESS_CONFLICT2,                        /* c0000255 (STATUS_IP_ADDRESS_CONFLICT2) */
    ERROR_REGISTRY_QUOTA_LIMIT,                        /* c0000256 (STATUS_REGISTRY_QUOTA_LIMIT) */
    ERROR_HOST_UNREACHABLE,                            /* c0000257 (STATUS_PATH_NOT_COVERED) */
    ERROR_NO_CALLBACK_ACTIVE,                          /* c0000258 (STATUS_NO_CALLBACK_ACTIVE) */
    ERROR_LICENSE_QUOTA_EXCEEDED,                      /* c0000259 (STATUS_LICENSE_QUOTA_EXCEEDED) */
    ERROR_PWD_TOO_SHORT,                               /* c000025a (STATUS_PWD_TOO_SHORT) */
    ERROR_PWD_TOO_RECENT,                              /* c000025b (STATUS_PWD_TOO_RECENT) */
    ERROR_PWD_HISTORY_CONFLICT,                        /* c000025c (STATUS_PWD_HISTORY_CONFLICT) */
    ERROR_MR_MID_NOT_FOUND,                            /* c000025d */
    ERROR_SERVICE_DISABLED,                            /* c000025e (STATUS_PLUGPLAY_NO_DEVICE) */
    ERROR_UNSUPPORTED_COMPRESSION,                     /* c000025f (STATUS_UNSUPPORTED_COMPRESSION) */
    ERROR_INVALID_HW_PROFILE,                          /* c0000260 (STATUS_INVALID_HW_PROFILE) */
    ERROR_INVALID_PLUGPLAY_DEVICE_PATH,                /* c0000261 (STATUS_INVALID_PLUGPLAY_DEVICE_PATH) */
    ERROR_INVALID_ORDINAL,                             /* c0000262 (STATUS_DRIVER_ORDINAL_NOT_FOUND) */
    ERROR_PROC_NOT_FOUND,                              /* c0000263 (STATUS_DRIVER_ENTRYPOINT_NOT_FOUND) */
    ERROR_NOT_OWNER,                                   /* c0000264 (STATUS_RESOURCE_NOT_OWNED) */
    ERROR_TOO_MANY_LINKS,                              /* c0000265 (STATUS_TOO_MANY_LINKS) */
    ERROR_QUOTA_LIST_INCONSISTENT,                     /* c0000266 (STATUS_QUOTA_LIST_INCONSISTENT) */
    ERROR_FILE_OFFLINE,                                /* c0000267 (STATUS_FILE_IS_OFFLINE) */
    ERROR_EVALUATION_EXPIRATION,                       /* c0000268 (STATUS_EVALUATION_EXPIRATION) */
    ERROR_ILLEGAL_DLL_RELOCATION,                      /* c0000269 (STATUS_ILLEGAL_DLL_RELOCATION) */
    ERROR_CTX_LICENSE_NOT_AVAILABLE,                   /* c000026a (STATUS_LICENSE_VIOLATION) */
    ERROR_DLL_INIT_FAILED_LOGOFF,                      /* c000026b (STATUS_DLL_INIT_FAILED_LOGOFF) */
    ERROR_BAD_DRIVER,                                  /* c000026c (STATUS_DRIVER_UNABLE_TO_LOAD) */
    ERROR_CONNECTION_UNAVAIL,                          /* c000026d (STATUS_DFS_UNAVAILABLE) */
    ERROR_NOT_READY,                                   /* c000026e (STATUS_VOLUME_DISMOUNTED) */
    ERROR_WX86_ERROR,                                  /* c000026f (STATUS_WX86_INTERNAL_ERROR) */
    ERROR_WX86_ERROR,                                  /* c0000270 (STATUS_WX86_FLOAT_STACK_CHECK) */
    ERROR_VALIDATE_CONTINUE,                           /* c0000271 (STATUS_VALIDATE_CONTINUE) */
    ERROR_NO_MATCH,                                    /* c0000272 (STATUS_NO_MATCH) */
    ERROR_NO_MORE_MATCHES,                             /* c0000273 (STATUS_NO_MORE_MATCHES) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000274 */
    ERROR_NOT_A_REPARSE_POINT,                         /* c0000275 (STATUS_NOT_A_REPARSE_POINT) */
    ERROR_REPARSE_TAG_INVALID,                         /* c0000276 (STATUS_IO_REPARSE_TAG_INVALID) */
    ERROR_REPARSE_TAG_MISMATCH,                        /* c0000277 (STATUS_IO_REPARSE_TAG_MISMATCH) */
    ERROR_INVALID_REPARSE_DATA,                        /* c0000278 (STATUS_IO_REPARSE_DATA_INVALID) */
    ERROR_CANT_ACCESS_FILE,                            /* c0000279 (STATUS_IO_REPARSE_TAG_NOT_HANDLED) */
    ERROR_PWD_TOO_LONG,                                /* c000027a (STATUS_PWD_TOO_LONG) */
    ERROR_INTERNAL_ERROR,                              /* c000027b (STATUS_STOWED_EXCEPTION) */
    ERROR_INTERNAL_ERROR,                              /* c000027c (STATUS_CONTEXT_STOWED_EXCEPTION) */
    ERROR_MR_MID_NOT_FOUND,                            /* c000027d */
    ERROR_MR_MID_NOT_FOUND,                            /* c000027e */
    ERROR_MR_MID_NOT_FOUND,                            /* c000027f */
    ERROR_CANT_RESOLVE_FILENAME,                       /* c0000280 (STATUS_REPARSE_POINT_NOT_RESOLVED) */
    ERROR_BAD_PATHNAME,                                /* c0000281 (STATUS_DIRECTORY_IS_A_REPARSE_POINT) */
    ERROR_RANGE_LIST_CONFLICT,                         /* c0000282 (STATUS_RANGE_LIST_CONFLICT) */
    ERROR_SOURCE_ELEMENT_EMPTY,                        /* c0000283 (STATUS_SOURCE_ELEMENT_EMPTY) */
    ERROR_DESTINATION_ELEMENT_FULL,                    /* c0000284 (STATUS_DESTINATION_ELEMENT_FULL) */
    ERROR_ILLEGAL_ELEMENT_ADDRESS,                     /* c0000285 (STATUS_ILLEGAL_ELEMENT_ADDRESS) */
    ERROR_MAGAZINE_NOT_PRESENT,                        /* c0000286 (STATUS_MAGAZINE_NOT_PRESENT) */
    ERROR_DEVICE_REINITIALIZATION_NEEDED,              /* c0000287 (STATUS_REINITIALIZATION_NEEDED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000288 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000289 */
    ERROR_ACCESS_DENIED,                               /* c000028a (STATUS_ENCRYPTION_FAILED) */
    ERROR_ACCESS_DENIED,                               /* c000028b (STATUS_DECRYPTION_FAILED) */
    ERROR_RANGE_NOT_FOUND,                             /* c000028c (STATUS_RANGE_NOT_FOUND) */
    ERROR_ACCESS_DENIED,                               /* c000028d (STATUS_NO_RECOVERY_POLICY) */
    ERROR_ACCESS_DENIED,                               /* c000028e (STATUS_NO_EFS) */
    ERROR_ACCESS_DENIED,                               /* c000028f (STATUS_WRONG_EFS) */
    ERROR_ACCESS_DENIED,                               /* c0000290 (STATUS_NO_USER_KEYS) */
    ERROR_FILE_NOT_ENCRYPTED,                          /* c0000291 (STATUS_FILE_NOT_ENCRYPTED) */
    ERROR_NOT_EXPORT_FORMAT,                           /* c0000292 (STATUS_NOT_EXPORT_FORMAT) */
    ERROR_FILE_ENCRYPTED,                              /* c0000293 (STATUS_FILE_ENCRYPTED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000294 */
    ERROR_WMI_GUID_NOT_FOUND,                          /* c0000295 (STATUS_WMI_GUID_NOT_FOUND) */
    ERROR_WMI_INSTANCE_NOT_FOUND,                      /* c0000296 (STATUS_WMI_INSTANCE_NOT_FOUND) */
    ERROR_WMI_ITEMID_NOT_FOUND,                        /* c0000297 (STATUS_WMI_ITEMID_NOT_FOUND) */
    ERROR_WMI_TRY_AGAIN,                               /* c0000298 (STATUS_WMI_TRY_AGAIN) */
    ERROR_SHARED_POLICY,                               /* c0000299 (STATUS_SHARED_POLICY) */
    ERROR_POLICY_OBJECT_NOT_FOUND,                     /* c000029a (STATUS_POLICY_OBJECT_NOT_FOUND) */
    ERROR_POLICY_ONLY_IN_DS,                           /* c000029b (STATUS_POLICY_ONLY_IN_DS) */
    ERROR_INVALID_FUNCTION,                            /* c000029c (STATUS_VOLUME_NOT_UPGRADED) */
    ERROR_REMOTE_STORAGE_NOT_ACTIVE,                   /* c000029d (STATUS_REMOTE_STORAGE_NOT_ACTIVE) */
    ERROR_REMOTE_STORAGE_MEDIA_ERROR,                  /* c000029e (STATUS_REMOTE_STORAGE_MEDIA_ERROR) */
    ERROR_NO_TRACKING_SERVICE,                         /* c000029f (STATUS_NO_TRACKING_SERVICE) */
    ERROR_SERVER_SID_MISMATCH,                         /* c00002a0 (STATUS_SERVER_SID_MISMATCH) */
    ERROR_DS_NO_ATTRIBUTE_OR_VALUE,                    /* c00002a1 (STATUS_DS_NO_ATTRIBUTE_OR_VALUE) */
    ERROR_DS_INVALID_ATTRIBUTE_SYNTAX,                 /* c00002a2 (STATUS_DS_INVALID_ATTRIBUTE_SYNTAX) */
    ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED,                 /* c00002a3 (STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED) */
    ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS,                /* c00002a4 (STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS) */
    ERROR_DS_BUSY,                                     /* c00002a5 (STATUS_DS_BUSY) */
    ERROR_DS_UNAVAILABLE,                              /* c00002a6 (STATUS_DS_UNAVAILABLE) */
    ERROR_DS_NO_RIDS_ALLOCATED,                        /* c00002a7 (STATUS_DS_NO_RIDS_ALLOCATED) */
    ERROR_DS_NO_MORE_RIDS,                             /* c00002a8 (STATUS_DS_NO_MORE_RIDS) */
    ERROR_DS_INCORRECT_ROLE_OWNER,                     /* c00002a9 (STATUS_DS_INCORRECT_ROLE_OWNER) */
    ERROR_DS_RIDMGR_INIT_ERROR,                        /* c00002aa (STATUS_DS_RIDMGR_INIT_ERROR) */
    ERROR_DS_OBJ_CLASS_VIOLATION,                      /* c00002ab (STATUS_DS_OBJ_CLASS_VIOLATION) */
    ERROR_DS_CANT_ON_NON_LEAF,                         /* c00002ac (STATUS_DS_CANT_ON_NON_LEAF) */
    ERROR_DS_CANT_ON_RDN,                              /* c00002ad (STATUS_DS_CANT_ON_RDN) */
    ERROR_DS_CANT_MOD_OBJ_CLASS,                       /* c00002ae (STATUS_DS_CANT_MOD_OBJ_CLASS) */
    ERROR_DS_CROSS_DOM_MOVE_ERROR,                     /* c00002af (STATUS_DS_CROSS_DOM_MOVE_FAILED) */
    ERROR_DS_GC_NOT_AVAILABLE,                         /* c00002b0 (STATUS_DS_GC_NOT_AVAILABLE) */
    ERROR_DS_DS_REQUIRED,                              /* c00002b1 (STATUS_DIRECTORY_SERVICE_REQUIRED) */
    ERROR_REPARSE_ATTRIBUTE_CONFLICT,                  /* c00002b2 (STATUS_REPARSE_ATTRIBUTE_CONFLICT) */
    ERROR_CANT_ENABLE_DENY_ONLY,                       /* c00002b3 (STATUS_CANT_ENABLE_DENY_ONLY) */
    ERROR_FLOAT_MULTIPLE_FAULTS,                       /* c00002b4 (STATUS_FLOAT_MULTIPLE_FAULTS) */
    ERROR_FLOAT_MULTIPLE_TRAPS,                        /* c00002b5 (STATUS_FLOAT_MULTIPLE_TRAPS) */
    ERROR_DEVICE_REMOVED,                              /* c00002b6 (STATUS_DEVICE_REMOVED) */
    ERROR_JOURNAL_DELETE_IN_PROGRESS,                  /* c00002b7 (STATUS_JOURNAL_DELETE_IN_PROGRESS) */
    ERROR_JOURNAL_NOT_ACTIVE,                          /* c00002b8 (STATUS_JOURNAL_NOT_ACTIVE) */
    ERROR_NOINTERFACE,                                 /* c00002b9 (STATUS_NOINTERFACE) */
    ERROR_DS_RIDMGR_DISABLED,                          /* c00002ba (STATUS_DS_RIDMGR_DISABLED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c00002bb */
    ERROR_MR_MID_NOT_FOUND,                            /* c00002bc */
    ERROR_MR_MID_NOT_FOUND,                            /* c00002bd */
    ERROR_MR_MID_NOT_FOUND,                            /* c00002be */
    ERROR_MR_MID_NOT_FOUND,                            /* c00002bf */
    ERROR_MR_MID_NOT_FOUND,                            /* c00002c0 */
    ERROR_DS_ADMIN_LIMIT_EXCEEDED,                     /* c00002c1 (STATUS_DS_ADMIN_LIMIT_EXCEEDED) */
    ERROR_DRIVER_FAILED_SLEEP,                         /* c00002c2 (STATUS_DRIVER_FAILED_SLEEP) */
    ERROR_MUTUAL_AUTH_FAILED,                          /* c00002c3 (STATUS_MUTUAL_AUTHENTICATION_FAILED) */
    ERROR_CORRUPT_SYSTEM_FILE,                         /* c00002c4 (STATUS_CORRUPT_SYSTEM_FILE) */
    ERROR_NOACCESS,                                    /* c00002c5 (STATUS_DATATYPE_MISALIGNMENT_ERROR) */
    ERROR_WMI_READ_ONLY,                               /* c00002c6 (STATUS_WMI_READ_ONLY) */
    ERROR_WMI_SET_FAILURE,                             /* c00002c7 (STATUS_WMI_SET_FAILURE) */
    ERROR_COMMITMENT_MINIMUM,                          /* c00002c8 (STATUS_COMMITMENT_MINIMUM) */
    ERROR_REG_NAT_CONSUMPTION,                         /* c00002c9 (STATUS_REG_NAT_CONSUMPTION) */
    ERROR_TRANSPORT_FULL,                              /* c00002ca (STATUS_TRANSPORT_FULL) */
    ERROR_DS_SAM_INIT_FAILURE,                         /* c00002cb (STATUS_DS_SAM_INIT_FAILURE) */
    ERROR_ONLY_IF_CONNECTED,                           /* c00002cc (STATUS_ONLY_IF_CONNECTED) */
    ERROR_DS_SENSITIVE_GROUP_VIOLATION,                /* c00002cd (STATUS_DS_SENSITIVE_GROUP_VIOLATION) */
    ERROR_PNP_RESTART_ENUMERATION,                     /* c00002ce (STATUS_PNP_RESTART_ENUMERATION) */
    ERROR_JOURNAL_ENTRY_DELETED,                       /* c00002cf (STATUS_JOURNAL_ENTRY_DELETED) */
    ERROR_DS_CANT_MOD_PRIMARYGROUPID,                  /* c00002d0 (STATUS_DS_CANT_MOD_PRIMARYGROUPID) */
    ERROR_SYSTEM_IMAGE_BAD_SIGNATURE,                  /* c00002d1 (STATUS_SYSTEM_IMAGE_BAD_SIGNATURE) */
    ERROR_PNP_REBOOT_REQUIRED,                         /* c00002d2 (STATUS_PNP_REBOOT_REQUIRED) */
    ERROR_NOT_READY,                                   /* c00002d3 (STATUS_POWER_STATE_INVALID) */
    ERROR_DS_INVALID_GROUP_TYPE,                       /* c00002d4 (STATUS_DS_INVALID_GROUP_TYPE) */
    ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN,       /* c00002d5 (STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN) */
    ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN,        /* c00002d6 (STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN) */
    ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER,            /* c00002d7 (STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER) */
    ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER,        /* c00002d8 (STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER) */
    ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER,         /* c00002d9 (STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER) */
    ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER,      /* c00002da (STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER) */
    ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER, /* c00002db (STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER) */
    ERROR_DS_HAVE_PRIMARY_MEMBERS,                     /* c00002dc (STATUS_DS_HAVE_PRIMARY_MEMBERS) */
    ERROR_NOT_SUPPORTED,                               /* c00002dd (STATUS_WMI_NOT_SUPPORTED) */
    ERROR_INSUFFICIENT_POWER,                          /* c00002de (STATUS_INSUFFICIENT_POWER) */
    ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD,                /* c00002df (STATUS_SAM_NEED_BOOTKEY_PASSWORD) */
    ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY,                  /* c00002e0 (STATUS_SAM_NEED_BOOTKEY_FLOPPY) */
    ERROR_DS_CANT_START,                               /* c00002e1 (STATUS_DS_CANT_START) */
    ERROR_DS_INIT_FAILURE,                             /* c00002e2 (STATUS_DS_INIT_FAILURE) */
    ERROR_SAM_INIT_FAILURE,                            /* c00002e3 (STATUS_SAM_INIT_FAILURE) */
    ERROR_DS_GC_REQUIRED,                              /* c00002e4 (STATUS_DS_GC_REQUIRED) */
    ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY,               /* c00002e5 (STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY) */
    ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS,               /* c00002e6 (STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS) */
    ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED,           /* c00002e7 (STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED) */
    ERROR_MULTIPLE_FAULT_VIOLATION,                    /* c00002e8 (STATUS_MULTIPLE_FAULT_VIOLATION) */
    ERROR_CURRENT_DOMAIN_NOT_ALLOWED,                  /* c00002e9 (STATUS_CURRENT_DOMAIN_NOT_ALLOWED) */
    ERROR_CANNOT_MAKE,                                 /* c00002ea (STATUS_CANNOT_MAKE) */
    ERROR_SYSTEM_SHUTDOWN,                             /* c00002eb (STATUS_SYSTEM_SHUTDOWN) */
    ERROR_DS_INIT_FAILURE_CONSOLE,                     /* c00002ec (STATUS_DS_INIT_FAILURE_CONSOLE) */
    ERROR_DS_SAM_INIT_FAILURE_CONSOLE,                 /* c00002ed (STATUS_DS_SAM_INIT_FAILURE_CONSOLE) */
    SEC_E_UNFINISHED_CONTEXT_DELETED,                  /* c00002ee (STATUS_UNFINISHED_CONTEXT_DELETED) */
    SEC_E_NO_TGT_REPLY,                                /* c00002ef (STATUS_NO_TGT_REPLY) */
    ERROR_FILE_NOT_FOUND,                              /* c00002f0 (STATUS_OBJECTID_NOT_FOUND) */
    SEC_E_NO_IP_ADDRESSES,                             /* c00002f1 (STATUS_NO_IP_ADDRESSES) */
    SEC_E_WRONG_CREDENTIAL_HANDLE,                     /* c00002f2 (STATUS_WRONG_CREDENTIAL_HANDLE) */
    SEC_E_CRYPTO_SYSTEM_INVALID,                       /* c00002f3 (STATUS_CRYPTO_SYSTEM_INVALID) */
    SEC_E_MAX_REFERRALS_EXCEEDED,                      /* c00002f4 (STATUS_MAX_REFERRALS_EXCEEDED) */
    SEC_E_MUST_BE_KDC,                                 /* c00002f5 (STATUS_MUST_BE_KDC) */
    SEC_E_STRONG_CRYPTO_NOT_SUPPORTED,                 /* c00002f6 (STATUS_STRONG_CRYPTO_NOT_SUPPORTED) */
    SEC_E_TOO_MANY_PRINCIPALS,                         /* c00002f7 (STATUS_TOO_MANY_PRINCIPALS) */
    SEC_E_NO_PA_DATA,                                  /* c00002f8 (STATUS_NO_PA_DATA) */
    SEC_E_PKINIT_NAME_MISMATCH,                        /* c00002f9 (STATUS_PKINIT_NAME_MISMATCH) */
    SEC_E_SMARTCARD_LOGON_REQUIRED,                    /* c00002fa (STATUS_SMARTCARD_LOGON_REQUIRED) */
    SEC_E_KDC_INVALID_REQUEST,                         /* c00002fb (STATUS_KDC_INVALID_REQUEST) */
    SEC_E_KDC_UNABLE_TO_REFER,                         /* c00002fc (STATUS_KDC_UNABLE_TO_REFER) */
    SEC_E_KDC_UNKNOWN_ETYPE,                           /* c00002fd (STATUS_KDC_UNKNOWN_ETYPE) */
    ERROR_SHUTDOWN_IN_PROGRESS,                        /* c00002fe (STATUS_SHUTDOWN_IN_PROGRESS) */
    ERROR_SERVER_SHUTDOWN_IN_PROGRESS,                 /* c00002ff (STATUS_SERVER_SHUTDOWN_IN_PROGRESS) */
    ERROR_NOT_SUPPORTED_ON_SBS,                        /* c0000300 (STATUS_NOT_SUPPORTED_ON_SBS) */
    ERROR_WMI_GUID_DISCONNECTED,                       /* c0000301 (STATUS_WMI_GUID_DISCONNECTED) */
    ERROR_WMI_ALREADY_DISABLED,                        /* c0000302 (STATUS_WMI_ALREADY_DISABLED) */
    ERROR_WMI_ALREADY_ENABLED,                         /* c0000303 (STATUS_WMI_ALREADY_ENABLED) */
    ERROR_DISK_TOO_FRAGMENTED,                         /* c0000304 (STATUS_MFT_TOO_FRAGMENTED) */
    STG_E_STATUS_COPY_PROTECTION_FAILURE,              /* c0000305 (STATUS_COPY_PROTECTION_FAILURE) */
    STG_E_CSS_AUTHENTICATION_FAILURE,                  /* c0000306 (STATUS_CSS_AUTHENTICATION_FAILURE) */
    STG_E_CSS_KEY_NOT_PRESENT,                         /* c0000307 (STATUS_CSS_KEY_NOT_PRESENT) */
    STG_E_CSS_KEY_NOT_ESTABLISHED,                     /* c0000308 (STATUS_CSS_KEY_NOT_ESTABLISHED) */
    STG_E_CSS_SCRAMBLED_SECTOR,                        /* c0000309 (STATUS_CSS_SCRAMBLED_SECTOR) */
    STG_E_CSS_REGION_MISMATCH,                         /* c000030a (STATUS_CSS_REGION_MISMATCH) */
    STG_E_RESETS_EXHAUSTED,                            /* c000030b (STATUS_CSS_RESETS_EXHAUSTED) */
    ERROR_PASSWORD_CHANGE_REQUIRED,                    /* c000030c (STATUS_PASSWORD_CHANGE_REQUIRED) */
    ERROR_LOST_MODE_LOGON_RESTRICTION,                 /* c000030d (STATUS_LOST_MODE_LOGON_RESTRICTION) */
    ERROR_PKINIT_FAILURE,                              /* c0000320 (STATUS_PKINIT_FAILURE) */
    ERROR_SMARTCARD_SUBSYSTEM_FAILURE,                 /* c0000321 (STATUS_SMARTCARD_SUBSYSTEM_FAILURE) */
    SEC_E_NO_KERB_KEY,                                 /* c0000322 (STATUS_NO_KERB_KEY) */
    ERROR_HOST_DOWN,                                   /* c0000350 (STATUS_HOST_DOWN) */
    SEC_E_UNSUPPORTED_PREAUTH,                         /* c0000351 (STATUS_UNSUPPORTED_PREAUTH) */
    ERROR_EFS_ALG_BLOB_TOO_BIG,                        /* c0000352 (STATUS_EFS_ALG_BLOB_TOO_BIG) */
    ERROR_PORT_NOT_SET,                                /* c0000353 (STATUS_PORT_NOT_SET) */
    ERROR_DEBUGGER_INACTIVE,                           /* c0000354 (STATUS_DEBUGGER_INACTIVE) */
    ERROR_DS_VERSION_CHECK_FAILURE,                    /* c0000355 (STATUS_DS_VERSION_CHECK_FAILURE) */
    ERROR_AUDITING_DISABLED,                           /* c0000356 (STATUS_AUDITING_DISABLED) */
    ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4,           /* c0000357 (STATUS_PRENT4_MACHINE_ACCOUNT) */
    ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER,            /* c0000358 (STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER) */
    ERROR_BAD_EXE_FORMAT,                              /* c0000359 (STATUS_INVALID_IMAGE_WIN_32) */
    ERROR_BAD_EXE_FORMAT,                              /* c000035a (STATUS_INVALID_IMAGE_WIN_64) */
    SEC_E_BAD_BINDINGS,                                /* c000035b (STATUS_BAD_BINDINGS) */
    ERROR_NO_USER_SESSION_KEY,                         /* c000035c (STATUS_NETWORK_SESSION_EXPIRED) */
    ERROR_APPHELP_BLOCK,                               /* c000035d (STATUS_APPHELP_BLOCK) */
    ERROR_ALL_SIDS_FILTERED,                           /* c000035e (STATUS_ALL_SIDS_FILTERED) */
    ERROR_NOT_SAFE_MODE_DRIVER,                        /* c000035f (STATUS_NOT_SAFE_MODE_DRIVER) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000360 */
    ERROR_ACCESS_DISABLED_BY_POLICY,                   /* c0000361 (STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT) */
    ERROR_ACCESS_DISABLED_BY_POLICY,                   /* c0000362 (STATUS_ACCESS_DISABLED_BY_POLICY_PATH) */
    ERROR_ACCESS_DISABLED_BY_POLICY,                   /* c0000363 (STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER) */
    ERROR_ACCESS_DISABLED_BY_POLICY,                   /* c0000364 (STATUS_ACCESS_DISABLED_BY_POLICY_OTHER) */
    ERROR_FAILED_DRIVER_ENTRY,                         /* c0000365 (STATUS_FAILED_DRIVER_ENTRY) */
    ERROR_DEVICE_ENUMERATION_ERROR,                    /* c0000366 (STATUS_DEVICE_ENUMERATION_ERROR) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000367 */
    ERROR_MOUNT_POINT_NOT_RESOLVED,                    /* c0000368 (STATUS_MOUNT_POINT_NOT_RESOLVED) */
    ERROR_INVALID_DEVICE_OBJECT_PARAMETER,             /* c0000369 (STATUS_INVALID_DEVICE_OBJECT_PARAMETER) */
    ERROR_MCA_OCCURED,                                 /* c000036a (STATUS_MCA_OCCURED) */
    ERROR_DRIVER_BLOCKED,                              /* c000036b (STATUS_DRIVER_BLOCKED_CRITICAL) */
    ERROR_DRIVER_BLOCKED,                              /* c000036c (STATUS_DRIVER_BLOCKED) */
    ERROR_DRIVER_DATABASE_ERROR,                       /* c000036d (STATUS_DRIVER_DATABASE_ERROR) */
    ERROR_SYSTEM_HIVE_TOO_LARGE,                       /* c000036e (STATUS_SYSTEM_HIVE_TOO_LARGE) */
    ERROR_INVALID_IMPORT_OF_NON_DLL,                   /* c000036f (STATUS_INVALID_IMPORT_OF_NON_DLL) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000370 */
    ERROR_NO_SECRETS,                                  /* c0000371 (STATUS_NO_SECRETS) */
    ERROR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY,       /* c0000372 (STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY) */
    ERROR_NOT_ENOUGH_MEMORY,                           /* c0000373 (STATUS_FAILED_STACK_SWITCH) */
    ERROR_INTERNAL_ERROR,                              /* c0000374 (STATUS_HEAP_CORRUPTION) */
    SCARD_W_WRONG_CHV,                                 /* c0000380 (STATUS_SMARTCARD_WRONG_PIN) */
    SCARD_W_CHV_BLOCKED,                               /* c0000381 (STATUS_SMARTCARD_CARD_BLOCKED) */
    SCARD_W_CARD_NOT_AUTHENTICATED,                    /* c0000382 (STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED) */
    SCARD_E_NO_SMARTCARD,                              /* c0000383 (STATUS_SMARTCARD_NO_CARD) */
    NTE_NO_KEY,                                        /* c0000384 (STATUS_SMARTCARD_NO_KEY_CONTAINER) */
    SCARD_E_NO_SUCH_CERTIFICATE,                       /* c0000385 (STATUS_SMARTCARD_NO_CERTIFICATE) */
    NTE_BAD_KEYSET,                                    /* c0000386 (STATUS_SMARTCARD_NO_KEYSET) */
    SCARD_E_COMM_DATA_LOST,                            /* c0000387 (STATUS_SMARTCARD_IO_ERROR) */
    ERROR_DOWNGRADE_DETECTED,                          /* c0000388 (STATUS_DOWNGRADE_DETECTED) */
    SEC_E_SMARTCARD_CERT_REVOKED,                      /* c0000389 (STATUS_SMARTCARD_CERT_REVOKED) */
    SEC_E_ISSUING_CA_UNTRUSTED,                        /* c000038a (STATUS_ISSUING_CA_UNTRUSTED) */
    SEC_E_REVOCATION_OFFLINE_C,                        /* c000038b (STATUS_REVOCATION_OFFLINE_C) */
    SEC_E_PKINIT_CLIENT_FAILURE,                       /* c000038c (STATUS_PKINIT_CLIENT_FAILURE) */
    SEC_E_SMARTCARD_CERT_EXPIRED,                      /* c000038d (STATUS_SMARTCARD_CERT_EXPIRED) */
    ERROR_DRIVER_FAILED_PRIOR_UNLOAD,                  /* c000038e (STATUS_DRIVER_FAILED_PRIOR_UNLOAD) */
    NTE_SILENT_CONTEXT,                                /* c000038f (STATUS_SMARTCARD_SILENT_CONTEXT) */
    ERROR_PER_USER_TRUST_QUOTA_EXCEEDED,               /* c0000401 (STATUS_PER_USER_TRUST_QUOTA_EXCEEDED) */
    ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED,               /* c0000402 (STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED) */
    ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED,            /* c0000403 (STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED) */
    ERROR_DS_NAME_NOT_UNIQUE,                          /* c0000404 (STATUS_DS_NAME_NOT_UNIQUE) */
    ERROR_DS_DUPLICATE_ID_FOUND,                       /* c0000405 (STATUS_DS_DUPLICATE_ID_FOUND) */
    ERROR_DS_GROUP_CONVERSION_ERROR,                   /* c0000406 (STATUS_DS_GROUP_CONVERSION_ERROR) */
    ERROR_VOLSNAP_PREPARE_HIBERNATE,                   /* c0000407 (STATUS_VOLSNAP_PREPARE_HIBERNATE) */
    ERROR_LOGON_FAILURE,                               /* c0000408 (STATUS_USER2USER_REQUIRED) */
    ERROR_STACK_BUFFER_OVERRUN,                        /* c0000409 (STATUS_STACK_BUFFER_OVERRUN) */
    SEC_E_NO_S4U_PROT_SUPPORT,                         /* c000040a (STATUS_NO_S4U_PROT_SUPPORT) */
    SEC_E_CROSSREALM_DELEGATION_FAILURE,               /* c000040b (STATUS_CROSSREALM_DELEGATION_FAILURE) */
    SEC_E_REVOCATION_OFFLINE_KDC,                      /* c000040c (STATUS_REVOCATION_OFFLINE_KDC) */
    SEC_E_ISSUING_CA_UNTRUSTED_KDC,                    /* c000040d (STATUS_ISSUING_CA_UNTRUSTED_KDC) */
    SEC_E_KDC_CERT_EXPIRED,                            /* c000040e (STATUS_KDC_CERT_EXPIRED) */
    SEC_E_KDC_CERT_REVOKED,                            /* c000040f (STATUS_KDC_CERT_REVOKED) */
    ERROR_PARAMETER_QUOTA_EXCEEDED,                    /* c0000410 (STATUS_PARAMETER_QUOTA_EXCEEDED) */
    ERROR_HIBERNATION_FAILURE,                         /* c0000411 (STATUS_HIBERNATION_FAILURE) */
    ERROR_DELAY_LOAD_FAILED,                           /* c0000412 (STATUS_DELAY_LOAD_FAILED) */
    ERROR_AUTHENTICATION_FIREWALL_FAILED,              /* c0000413 (STATUS_AUTHENTICATION_FIREWALL_FAILED) */
    ERROR_VDM_DISALLOWED,                              /* c0000414 (STATUS_VDM_DISALLOWED) */
    ERROR_HUNG_DISPLAY_DRIVER_THREAD,                  /* c0000415 (STATUS_HUNG_DISPLAY_DRIVER_THREAD) */
    ERROR_NOT_ENOUGH_MEMORY,                           /* c0000416 (STATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE) */
    ERROR_INVALID_CRUNTIME_PARAMETER,                  /* c0000417 (STATUS_INVALID_CRUNTIME_PARAMETER) */
    ERROR_NTLM_BLOCKED,                                /* c0000418 (STATUS_NTLM_BLOCKED) */
    ERROR_DS_SRC_SID_EXISTS_IN_FOREST,                 /* c0000419 (STATUS_DS_SRC_SID_EXISTS_IN_FOREST) */
    ERROR_DS_DOMAIN_NAME_EXISTS_IN_FOREST,             /* c000041a (STATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST) */
    ERROR_DS_FLAT_NAME_EXISTS_IN_FOREST,               /* c000041b (STATUS_DS_FLAT_NAME_EXISTS_IN_FOREST) */
    ERROR_INVALID_USER_PRINCIPAL_NAME,                 /* c000041c (STATUS_INVALID_USER_PRINCIPAL_NAME) */
    ERROR_FATAL_APP_EXIT,                              /* c000041d (STATUS_FATAL_USER_CALLBACK_EXCEPTION) */
    ERROR_MR_MID_NOT_FOUND,                            /* c000041e */
    ERROR_MR_MID_NOT_FOUND,                            /* c000041f */
    ERROR_ASSERTION_FAILURE,                           /* c0000420 (STATUS_ASSERTION_FAILURE) */
    ERROR_VERIFIER_STOP,                               /* c0000421 (STATUS_VERIFIER_STOP) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000422 */
    ERROR_CALLBACK_POP_STACK,                          /* c0000423 (STATUS_CALLBACK_POP_STACK) */
    ERROR_DRIVER_BLOCKED,                              /* c0000424 (STATUS_INCOMPATIBLE_DRIVER_BLOCKED) */
    ERROR_KEY_DELETED,                                 /* c0000425 (STATUS_HIVE_UNLOADED) */
    ERROR_COMPRESSION_DISABLED,                        /* c0000426 (STATUS_COMPRESSION_DISABLED) */
    ERROR_FILE_SYSTEM_LIMITATION,                      /* c0000427 (STATUS_FILE_SYSTEM_LIMITATION) */
    ERROR_INVALID_IMAGE_HASH,                          /* c0000428 (STATUS_INVALID_IMAGE_HASH) */
    ERROR_NOT_CAPABLE,                                 /* c0000429 (STATUS_NOT_CAPABLE) */
    ERROR_REQUEST_OUT_OF_SEQUENCE,                     /* c000042a (STATUS_REQUEST_OUT_OF_SEQUENCE) */
    ERROR_IMPLEMENTATION_LIMIT,                        /* c000042b (STATUS_IMPLEMENTATION_LIMIT) */
    ERROR_ELEVATION_REQUIRED,                          /* c000042c (STATUS_ELEVATION_REQUIRED) */
    SEC_E_NO_CONTEXT,                                  /* c000042d (STATUS_NO_SECURITY_CONTEXT) */
    ERROR_MR_MID_NOT_FOUND,                            /* c000042e */
    SEC_E_PKU2U_CERT_FAILURE,                          /* c000042f (STATUS_PKU2U_CERT_FAILURE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000430 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000431 */
    ERROR_BEYOND_VDL,                                  /* c0000432 (STATUS_BEYOND_VDL) */
    ERROR_BUSY,                                        /* c0000433 (STATUS_ENCOUNTERED_WRITE_IN_PROGRESS) */
    ERROR_BUSY,                                        /* c0000434 (STATUS_PTE_CHANGED) */
    ERROR_USER_MAPPED_FILE,                            /* c0000435 (STATUS_PURGE_FAILED) */
    ERROR_CRED_REQUIRES_CONFIRMATION,                  /* c0000440 (STATUS_CRED_REQUIRES_CONFIRMATION) */
    ERROR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE,       /* c0000441 (STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE) */
    ERROR_CS_ENCRYPTION_UNSUPPORTED_SERVER,            /* c0000442 (STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER) */
    ERROR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE,       /* c0000443 (STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE) */
    ERROR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE,            /* c0000444 (STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE) */
    ERROR_CS_ENCRYPTION_FILE_NOT_CSE,                  /* c0000445 (STATUS_CS_ENCRYPTION_FILE_NOT_CSE) */
    ERROR_INVALID_LABEL,                               /* c0000446 (STATUS_INVALID_LABEL) */
    ERROR_DRIVER_PROCESS_TERMINATED,                   /* c0000450 (STATUS_DRIVER_PROCESS_TERMINATED) */
    ERROR_AMBIGUOUS_SYSTEM_DEVICE,                     /* c0000451 (STATUS_AMBIGUOUS_SYSTEM_DEVICE) */
    ERROR_SYSTEM_DEVICE_NOT_FOUND,                     /* c0000452 (STATUS_SYSTEM_DEVICE_NOT_FOUND) */
    ERROR_RESTART_APPLICATION,                         /* c0000453 (STATUS_RESTART_BOOT_APPLICATION) */
    ERROR_NO_NVRAM_RESOURCES,                          /* c0000454 (STATUS_INSUFFICIENT_NVRAM_RESOURCES) */
    ERROR_INVALID_HANDLE,                              /* c0000455 (STATUS_INVALID_SESSION) */
    ERROR_INVALID_PARAMETER,                           /* c0000456 (STATUS_THREAD_ALREADY_IN_SESSION) */
    ERROR_INVALID_PARAMETER,                           /* c0000457 (STATUS_THREAD_NOT_IN_SESSION) */
    ERROR_INVALID_PARAMETER,                           /* c0000458 (STATUS_INVALID_WEIGHT) */
    ERROR_REQUEST_PAUSED,                              /* c0000459 (STATUS_REQUEST_PAUSED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c000045a */
    ERROR_MR_MID_NOT_FOUND,                            /* c000045b */
    ERROR_MR_MID_NOT_FOUND,                            /* c000045c */
    ERROR_MR_MID_NOT_FOUND,                            /* c000045d */
    ERROR_MR_MID_NOT_FOUND,                            /* c000045e */
    ERROR_MR_MID_NOT_FOUND,                            /* c000045f */
    ERROR_NO_RANGES_PROCESSED,                         /* c0000460 (STATUS_NO_RANGES_PROCESSED) */
    ERROR_DISK_RESOURCES_EXHAUSTED,                    /* c0000461 (STATUS_DISK_RESOURCES_EXHAUSTED) */
    ERROR_NEEDS_REMEDIATION,                           /* c0000462 (STATUS_NEEDS_REMEDIATION) */
    ERROR_DEVICE_FEATURE_NOT_SUPPORTED,                /* c0000463 (STATUS_DEVICE_FEATURE_NOT_SUPPORTED) */
    ERROR_DEVICE_UNREACHABLE,                          /* c0000464 (STATUS_DEVICE_UNREACHABLE) */
    ERROR_INVALID_TOKEN,                               /* c0000465 (STATUS_INVALID_TOKEN) */
    ERROR_NETNAME_DELETED,                             /* c0000466 (STATUS_SERVER_UNAVAILABLE) */
    ERROR_SHARING_VIOLATION,                           /* c0000467 (STATUS_FILE_NOT_AVAILABLE) */
    ERROR_DEVICE_NO_RESOURCES,                         /* c0000468 (STATUS_DEVICE_INSUFFICIENT_RESOURCES) */
    ERROR_PACKAGE_UPDATING,                            /* c0000469 (STATUS_PACKAGE_UPDATING) */
    ERROR_NOT_READ_FROM_COPY,                          /* c000046a (STATUS_NOT_READ_FROM_COPY) */
    ERROR_FT_WRITE_FAILURE,                            /* c000046b (STATUS_FT_WRITE_FAILURE) */
    ERROR_FT_DI_SCAN_REQUIRED,                         /* c000046c (STATUS_FT_DI_SCAN_REQUIRED) */
    ERROR_OBJECT_NOT_EXTERNALLY_BACKED,                /* c000046d (STATUS_OBJECT_NOT_EXTERNALLY_BACKED) */
    ERROR_EXTERNAL_BACKING_PROVIDER_UNKNOWN,           /* c000046e (STATUS_EXTERNAL_BACKING_PROVIDER_UNKNOWN) */
    ERROR_COMPRESSION_NOT_BENEFICIAL,                  /* c000046f (STATUS_COMPRESSION_NOT_BENEFICIAL) */
    ERROR_DATA_CHECKSUM_ERROR,                         /* c0000470 (STATUS_DATA_CHECKSUM_ERROR) */
    ERROR_INTERMIXED_KERNEL_EA_OPERATION,              /* c0000471 (STATUS_INTERMIXED_KERNEL_EA_OPERATION) */
    ERROR_FILE_LEVEL_TRIM_NOT_SUPPORTED,               /* c0000472 (STATUS_TRIM_READ_ZERO_NOT_SUPPORTED) */
    ERROR_TOO_MANY_DESCRIPTORS,                        /* c0000473 (STATUS_TOO_MANY_SEGMENT_DESCRIPTORS) */
    ERROR_OFFSET_ALIGNMENT_VIOLATION,                  /* c0000474 (STATUS_INVALID_OFFSET_ALIGNMENT) */
    ERROR_INVALID_FIELD_IN_PARAMETER_LIST,             /* c0000475 (STATUS_INVALID_FIELD_IN_PARAMETER_LIST) */
    ERROR_OPERATION_IN_PROGRESS,                       /* c0000476 (STATUS_OPERATION_IN_PROGRESS) */
    ERROR_BAD_DEVICE_PATH,                             /* c0000477 (STATUS_INVALID_INITIATOR_TARGET_PATH) */
    ERROR_SCRUB_DATA_DISABLED,                         /* c0000478 (STATUS_SCRUB_DATA_DISABLED) */
    ERROR_NOT_REDUNDANT_STORAGE,                       /* c0000479 (STATUS_NOT_REDUNDANT_STORAGE) */
    ERROR_RESIDENT_FILE_NOT_SUPPORTED,                 /* c000047a (STATUS_RESIDENT_FILE_NOT_SUPPORTED) */
    ERROR_COMPRESSED_FILE_NOT_SUPPORTED,               /* c000047b (STATUS_COMPRESSED_FILE_NOT_SUPPORTED) */
    ERROR_DIRECTORY_NOT_SUPPORTED,                     /* c000047c (STATUS_DIRECTORY_NOT_SUPPORTED) */
    ERROR_TIMEOUT,                                     /* c000047d (STATUS_IO_OPERATION_TIMEOUT) */
    ERROR_SYSTEM_NEEDS_REMEDIATION,                    /* c000047e (STATUS_SYSTEM_NEEDS_REMEDIATION) */
    ERROR_APPX_INTEGRITY_FAILURE_CLR_NGEN,             /* c000047f (STATUS_APPX_INTEGRITY_FAILURE_CLR_NGEN) */
    ERROR_NETNAME_DELETED,                             /* c0000480 (STATUS_SHARE_UNAVAILABLE) */
    ERROR_MOD_NOT_FOUND,                               /* c0000481 (STATUS_APISET_NOT_HOSTED) */
    ERROR_MOD_NOT_FOUND,                               /* c0000482 (STATUS_APISET_NOT_PRESENT) */
    ERROR_DEVICE_HARDWARE_ERROR,                       /* c0000483 (STATUS_DEVICE_HARDWARE_ERROR) */
    STG_E_FIRMWARE_SLOT_INVALID,                       /* c0000484 (STATUS_FIRMWARE_SLOT_INVALID) */
    STG_E_FIRMWARE_IMAGE_INVALID,                      /* c0000485 (STATUS_FIRMWARE_IMAGE_INVALID) */
    ERROR_STORAGE_TOPOLOGY_ID_MISMATCH,                /* c0000486 (STATUS_STORAGE_TOPOLOGY_ID_MISMATCH) */
    ERROR_GEN_FAILURE,                                 /* c0000487 (STATUS_WIM_NOT_BOOTABLE) */
    ERROR_BLOCKED_BY_PARENTAL_CONTROLS,                /* c0000488 (STATUS_BLOCKED_BY_PARENTAL_CONTROLS) */
    ERROR_NEEDS_REGISTRATION,                          /* c0000489 (STATUS_NEEDS_REGISTRATION) */
    ERROR_QUOTA_ACTIVITY,                              /* c000048a (STATUS_QUOTA_ACTIVITY) */
    ERROR_CALLBACK_INVOKE_INLINE,                      /* c000048b (STATUS_CALLBACK_INVOKE_INLINE) */
    ERROR_BLOCK_TOO_MANY_REFERENCES,                   /* c000048c (STATUS_BLOCK_TOO_MANY_REFERENCES) */
    ERROR_MARKED_TO_DISALLOW_WRITES,                   /* c000048d (STATUS_MARKED_TO_DISALLOW_WRITES) */
    ERROR_NETWORK_ACCESS_DENIED_EDP,                   /* c000048e (STATUS_NETWORK_ACCESS_DENIED_EDP) */
    ERROR_ENCLAVE_FAILURE,                             /* c000048f (STATUS_ENCLAVE_FAILURE) */
    ERROR_NO_MATCH,                                    /* c0000490 (STATUS_PNP_NO_COMPAT_DRIVERS) */
    ERROR_FILE_NOT_FOUND,                              /* c0000491 (STATUS_PNP_DRIVER_PACKAGE_NOT_FOUND) */
    ERROR_NOT_FOUND,                                   /* c0000492 (STATUS_PNP_DRIVER_CONFIGURATION_NOT_FOUND) */
    ERROR_SET_NOT_FOUND,                               /* c0000493 (STATUS_PNP_DRIVER_CONFIGURATION_INCOMPLETE) */
    ERROR_NOT_CAPABLE,                                 /* c0000494 (STATUS_PNP_FUNCTION_DRIVER_REQUIRED) */
    ERROR_NOT_READY,                                   /* c0000495 (STATUS_PNP_DEVICE_CONFIGURATION_PENDING) */
    ERROR_DEVICE_HINT_NAME_BUFFER_TOO_SMALL,           /* c0000496 (STATUS_DEVICE_HINT_NAME_BUFFER_TOO_SMALL) */
    APPMODEL_ERROR_PACKAGE_NOT_AVAILABLE,              /* c0000497 (STATUS_PACKAGE_NOT_AVAILABLE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000498 */
    ERROR_DEVICE_IN_MAINTENANCE,                       /* c0000499 (STATUS_DEVICE_IN_MAINTENANCE) */
    ERROR_NOT_SUPPORTED_ON_DAX,                        /* c000049a (STATUS_NOT_SUPPORTED_ON_DAX) */
    ERROR_DISK_TOO_FRAGMENTED,                         /* c000049b (STATUS_FREE_SPACE_TOO_FRAGMENTED) */
    ERROR_DAX_MAPPING_EXISTS,                          /* c000049c (STATUS_DAX_MAPPING_EXISTS) */
    ERROR_CHILD_PROCESS_BLOCKED,                       /* c000049d (STATUS_CHILD_PROCESS_BLOCKED) */
    ERROR_STORAGE_LOST_DATA_PERSISTENCE,               /* c000049e (STATUS_STORAGE_LOST_DATA_PERSISTENCE) */
    ERROR_VRF_CFG_ENABLED,                             /* c000049f (STATUS_VRF_CFG_ENABLED) */
    ERROR_PARTITION_TERMINATING,                       /* c00004a0 (STATUS_PARTITION_TERMINATING) */
    ERROR_EXTERNAL_SYSKEY_NOT_SUPPORTED,               /* c00004a1 (STATUS_EXTERNAL_SYSKEY_NOT_SUPPORTED) */
    ERROR_ENCLAVE_VIOLATION,                           /* c00004a2 (STATUS_ENCLAVE_VIOLATION) */
    ERROR_FILE_PROTECTED_UNDER_DPL,                    /* c00004a3 (STATUS_FILE_PROTECTED_UNDER_DPL) */
    ERROR_VOLUME_NOT_CLUSTER_ALIGNED,                  /* c00004a4 (STATUS_VOLUME_NOT_CLUSTER_ALIGNED) */
    ERROR_NO_PHYSICALLY_ALIGNED_FREE_SPACE_FOUND,      /* c00004a5 (STATUS_NO_PHYSICALLY_ALIGNED_FREE_SPACE_FOUND) */
    ERROR_APPX_FILE_NOT_ENCRYPTED,                     /* c00004a6 (STATUS_APPX_FILE_NOT_ENCRYPTED) */
    ERROR_RWRAW_ENCRYPTED_FILE_NOT_ENCRYPTED,          /* c00004a7 (STATUS_RWRAW_ENCRYPTED_FILE_NOT_ENCRYPTED) */
    ERROR_RWRAW_ENCRYPTED_INVALID_EDATAINFO_FILEOFFSET, /* c00004a8 (STATUS_RWRAW_ENCRYPTED_INVALID_EDATAINFO_FILEOFFSET) */
    ERROR_RWRAW_ENCRYPTED_INVALID_EDATAINFO_FILERANGE, /* c00004a9 (STATUS_RWRAW_ENCRYPTED_INVALID_EDATAINFO_FILERANGE) */
    ERROR_RWRAW_ENCRYPTED_INVALID_EDATAINFO_PARAMETER, /* c00004aa (STATUS_RWRAW_ENCRYPTED_INVALID_EDATAINFO_PARAMETER) */
    ERROR_FT_READ_FAILURE,                             /* c00004ab (STATUS_FT_READ_FAILURE) */
    ERROR_LOCK_VIOLATION,                              /* c00004ac (STATUS_PATCH_CONFLICT) */
    ERROR_STORAGE_RESERVE_ID_INVALID,                  /* c00004ad (STATUS_STORAGE_RESERVE_ID_INVALID) */
    ERROR_STORAGE_RESERVE_DOES_NOT_EXIST,              /* c00004ae (STATUS_STORAGE_RESERVE_DOES_NOT_EXIST) */
    ERROR_STORAGE_RESERVE_ALREADY_EXISTS,              /* c00004af (STATUS_STORAGE_RESERVE_ALREADY_EXISTS) */
    ERROR_STORAGE_RESERVE_NOT_EMPTY,                   /* c00004b0 (STATUS_STORAGE_RESERVE_NOT_EMPTY) */
    ERROR_NOT_A_DAX_VOLUME,                            /* c00004b1 (STATUS_NOT_A_DAX_VOLUME) */
    ERROR_NOT_DAX_MAPPABLE,                            /* c00004b2 (STATUS_NOT_DAX_MAPPABLE) */
    ERROR_CASE_DIFFERING_NAMES_IN_DIR,                 /* c00004b3 (STATUS_CASE_DIFFERING_NAMES_IN_DIR) */
    ERROR_FILE_NOT_SUPPORTED,                          /* c00004b4 (STATUS_FILE_NOT_SUPPORTED) */
    ERROR_NOT_SUPPORTED_WITH_BTT,                      /* c00004b5 (STATUS_NOT_SUPPORTED_WITH_BTT) */
    ERROR_ENCRYPTION_DISABLED,                         /* c00004b6 (STATUS_ENCRYPTION_DISABLED) */
    ERROR_ENCRYPTING_METADATA_DISALLOWED,              /* c00004b7 (STATUS_ENCRYPTING_METADATA_DISALLOWED) */
    ERROR_CANT_CLEAR_ENCRYPTION_FLAG,                  /* c00004b8 (STATUS_CANT_CLEAR_ENCRYPTION_FLAG) */
    ERROR_UNSATISFIED_DEPENDENCIES,                    /* c00004b9 (STATUS_UNSATISFIED_DEPENDENCIES) */
    ERROR_CASE_SENSITIVE_PATH,                         /* c00004ba (STATUS_CASE_SENSITIVE_PATH) */
    ERROR_PAGEFILE_CREATE_FAILED,                      /* c00004bb (STATUS_UNSUPPORTED_PAGING_MODE) */
    ERROR_UNTRUSTED_MOUNT_POINT,                       /* c00004bc (STATUS_UNTRUSTED_MOUNT_POINT) */
    ERROR_HAS_SYSTEM_CRITICAL_FILES,                   /* c00004bd (STATUS_HAS_SYSTEM_CRITICAL_FILES) */
    ERROR_OBJECT_IS_IMMUTABLE,                         /* c00004be (STATUS_OBJECT_IS_IMMUTABLE) */
    ERROR_FT_READ_FROM_COPY_FAILURE,                   /* c00004bf (STATUS_FT_READ_FROM_COPY_FAILURE) */
    ERROR_DLL_INIT_FAILED,                             /* c00004c0 (STATUS_IMAGE_LOADED_AS_PATCH_IMAGE) */
    ERROR_STORAGE_STACK_ACCESS_DENIED,                 /* c00004c1 (STATUS_STORAGE_STACK_ACCESS_DENIED) */
    ERROR_INSUFFICIENT_VIRTUAL_ADDR_RESOURCES,         /* c00004c2 (STATUS_INSUFFICIENT_VIRTUAL_ADDR_RESOURCES) */
    ERROR_ENCRYPTED_FILE_NOT_SUPPORTED,                /* c00004c3 (STATUS_ENCRYPTED_FILE_NOT_SUPPORTED) */
    ERROR_SPARSE_FILE_NOT_SUPPORTED,                   /* c00004c4 (STATUS_SPARSE_FILE_NOT_SUPPORTED) */
    ERROR_PAGEFILE_NOT_SUPPORTED,                      /* c00004c5 (STATUS_PAGEFILE_NOT_SUPPORTED) */
    ERROR_VOLUME_NOT_SUPPORTED,                        /* c00004c6 (STATUS_VOLUME_NOT_SUPPORTED) */
    ERROR_NOT_SUPPORTED_WITH_BYPASSIO,                 /* c00004c7 (STATUS_NOT_SUPPORTED_WITH_BYPASSIO) */
    ERROR_NO_BYPASSIO_DRIVER_SUPPORT,                  /* c00004c8 (STATUS_NO_BYPASSIO_DRIVER_SUPPORT) */
    ERROR_NOT_SUPPORTED_WITH_ENCRYPTION,               /* c00004c9 (STATUS_NOT_SUPPORTED_WITH_ENCRYPTION) */
    ERROR_NOT_SUPPORTED_WITH_COMPRESSION,              /* c00004ca (STATUS_NOT_SUPPORTED_WITH_COMPRESSION) */
    ERROR_NOT_SUPPORTED_WITH_REPLICATION,              /* c00004cb (STATUS_NOT_SUPPORTED_WITH_REPLICATION) */
    ERROR_NOT_SUPPORTED_WITH_DEDUPLICATION,            /* c00004cc (STATUS_NOT_SUPPORTED_WITH_DEDUPLICATION) */
    ERROR_NOT_SUPPORTED_WITH_AUDITING,                 /* c00004cd (STATUS_NOT_SUPPORTED_WITH_AUDITING) */
    ERROR_NOT_SUPPORTED_WITH_MONITORING,               /* c00004ce (STATUS_NOT_SUPPORTED_WITH_MONITORING) */
    ERROR_NOT_SUPPORTED_WITH_SNAPSHOT,                 /* c00004cf (STATUS_NOT_SUPPORTED_WITH_SNAPSHOT) */
    ERROR_NOT_SUPPORTED_WITH_VIRTUALIZATION,           /* c00004d0 (STATUS_NOT_SUPPORTED_WITH_VIRTUALIZATION) */
    ERROR_INDEX_OUT_OF_BOUNDS,                         /* c00004d1 (STATUS_INDEX_OUT_OF_BOUNDS) */
    ERROR_BYPASSIO_FLT_NOT_SUPPORTED,                  /* c00004d2 (STATUS_BYPASSIO_FLT_NOT_SUPPORTED) */
    ERROR_VOLUME_WRITE_ACCESS_DENIED,                  /* c00004d3 (STATUS_VOLUME_WRITE_ACCESS_DENIED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c00004d4 (STATUS_PATCH_NOT_REGISTERED) */
    ERROR_NOT_SUPPORTED_WITH_CACHED_HANDLE,            /* c00004d5 (STATUS_NOT_SUPPORTED_WITH_CACHED_HANDLE) */
    ERROR_INVALID_TASK_NAME,                           /* c0000500 (STATUS_INVALID_TASK_NAME) */
    ERROR_INVALID_TASK_INDEX,                          /* c0000501 (STATUS_INVALID_TASK_INDEX) */
    ERROR_THREAD_ALREADY_IN_TASK,                      /* c0000502 (STATUS_THREAD_ALREADY_IN_TASK) */
    ERROR_NOT_READY,                                   /* c0000503 (STATUS_CALLBACK_BYPASS) */
    ERROR_UNDEFINED_SCOPE,                             /* c0000504 (STATUS_UNDEFINED_SCOPE) */
    ERROR_INVALID_CAP,                                 /* c0000505 (STATUS_INVALID_CAP) */
    ERROR_NOT_GUI_PROCESS,                             /* c0000506 (STATUS_NOT_GUI_PROCESS) */
    ERROR_BUSY,                                        /* c0000507 (STATUS_DEVICE_HUNG) */
    ERROR_CONTAINER_ASSIGNED,                          /* c0000508 (STATUS_CONTAINER_ASSIGNED) */
    ERROR_JOB_NO_CONTAINER,                            /* c0000509 (STATUS_JOB_NO_CONTAINER) */
    STG_E_DEVICE_UNRESPONSIVE,                         /* c000050a (STATUS_DEVICE_UNRESPONSIVE) */
    ERROR_REPARSE_POINT_ENCOUNTERED,                   /* c000050b (STATUS_REPARSE_POINT_ENCOUNTERED) */
    ERROR_ATTRIBUTE_NOT_PRESENT,                       /* c000050c (STATUS_ATTRIBUTE_NOT_PRESENT) */
    ERROR_NOT_A_TIERED_VOLUME,                         /* c000050d (STATUS_NOT_A_TIERED_VOLUME) */
    ERROR_ALREADY_HAS_STREAM_ID,                       /* c000050e (STATUS_ALREADY_HAS_STREAM_ID) */
    ERROR_NOT_EMPTY,                                   /* c000050f (STATUS_JOB_NOT_EMPTY) */
    ERROR_ALREADY_INITIALIZED,                         /* c0000510 (STATUS_ALREADY_INITIALIZED) */
    ERROR_ENCLAVE_NOT_TERMINATED,                      /* c0000511 (STATUS_ENCLAVE_NOT_TERMINATED) */
    ERROR_ACCESS_DENIED,                               /* c0000512 (STATUS_ENCLAVE_IS_TERMINATING) */
    ERROR_SMB1_NOT_AVAILABLE,                          /* c0000513 (STATUS_SMB1_NOT_AVAILABLE) */
    ERROR_SMR_GARBAGE_COLLECTION_REQUIRED,             /* c0000514 (STATUS_SMR_GARBAGE_COLLECTION_REQUIRED) */
    STATUS_INTERRUPTED,                                /* c0000515 (STATUS_INTERRUPTED) */
    ERROR_INVALID_PARAMETER,                           /* c0000516 (STATUS_THREAD_NOT_RUNNING) */
    ERROR_SESSION_KEY_TOO_SHORT,                       /* c0000517 (STATUS_SESSION_KEY_TOO_SHORT) */
    ERROR_FAIL_FAST_EXCEPTION,                         /* c0000602 (STATUS_FAIL_FAST_EXCEPTION) */
    CERT_E_REVOKED,                                    /* c0000603 (STATUS_IMAGE_CERT_REVOKED) */
    ERROR_DYNAMIC_CODE_BLOCKED,                        /* c0000604 (STATUS_DYNAMIC_CODE_BLOCKED) */
    CERT_E_EXPIRED,                                    /* c0000605 (STATUS_IMAGE_CERT_EXPIRED) */
    ERROR_STRICT_CFG_VIOLATION,                        /* c0000606 (STATUS_STRICT_CFG_VIOLATION) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000607 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000608 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000609 */
    ERROR_SET_CONTEXT_DENIED,                          /* c000060a (STATUS_SET_CONTEXT_DENIED) */
    ERROR_CROSS_PARTITION_VIOLATION,                   /* c000060b (STATUS_CROSS_PARTITION_VIOLATION) */
    ERROR_INTERNAL_ERROR,                              /* c0000700 (STATUS_PORT_CLOSED) */
    ERROR_INTERNAL_ERROR,                              /* c0000701 (STATUS_MESSAGE_LOST) */
    ERROR_INVALID_PARAMETER,                           /* c0000702 (STATUS_INVALID_MESSAGE) */
    ERROR_INTERNAL_ERROR,                              /* c0000703 (STATUS_REQUEST_CANCELED) */
    ERROR_NOT_SUPPORTED,                               /* c0000704 (STATUS_RECURSIVE_DISPATCH) */
    ERROR_INVALID_PARAMETER,                           /* c0000705 (STATUS_LPC_RECEIVE_BUFFER_EXPECTED) */
    ERROR_INVALID_PARAMETER,                           /* c0000706 (STATUS_LPC_INVALID_CONNECTION_USAGE) */
    ERROR_NOT_SUPPORTED,                               /* c0000707 (STATUS_LPC_REQUESTS_NOT_ALLOWED) */
    ERROR_INTERNAL_ERROR,                              /* c0000708 (STATUS_RESOURCE_IN_USE) */
    ERROR_MEMORY_HARDWARE,                             /* c0000709 (STATUS_HARDWARE_MEMORY_ERROR) */
    ERROR_INVALID_HANDLE,                              /* c000070a (STATUS_THREADPOOL_HANDLE_EXCEPTION) */
    ERROR_INVALID_HANDLE,                              /* c000070b (STATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED) */
    ERROR_INVALID_HANDLE,                              /* c000070c (STATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED) */
    ERROR_INVALID_HANDLE,                              /* c000070d (STATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED) */
    ERROR_INVALID_HANDLE,                              /* c000070e (STATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED) */
    ERROR_INVALID_HANDLE,                              /* c000070f (STATUS_THREADPOOL_RELEASED_DURING_OPERATION) */
    ERROR_INVALID_FUNCTION,                            /* c0000710 (STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING) */
    ERROR_INVALID_FUNCTION,                            /* c0000711 (STATUS_APC_RETURNED_WHILE_IMPERSONATING) */
    ERROR_PROCESS_IS_PROTECTED,                        /* c0000712 (STATUS_PROCESS_IS_PROTECTED) */
    ERROR_MCA_EXCEPTION,                               /* c0000713 (STATUS_MCA_EXCEPTION) */
    ERROR_LOGON_FAILURE,                               /* c0000714 (STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE) */
    ERROR_SYMLINK_CLASS_DISABLED,                      /* c0000715 (STATUS_SYMLINK_CLASS_DISABLED) */
    ERROR_INVALID_NAME,                                /* c0000716 (STATUS_INVALID_IDN_NORMALIZATION) */
    ERROR_NO_UNICODE_TRANSLATION,                      /* c0000717 (STATUS_NO_UNICODE_TRANSLATION) */
    ERROR_INTERNAL_ERROR,                              /* c0000718 (STATUS_ALREADY_REGISTERED) */
    ERROR_INTERNAL_ERROR,                              /* c0000719 (STATUS_CONTEXT_MISMATCH) */
    ERROR_INTERNAL_ERROR,                              /* c000071a (STATUS_PORT_ALREADY_HAS_COMPLETION_LIST) */
    ERROR_INVALID_FUNCTION,                            /* c000071b (STATUS_CALLBACK_RETURNED_THREAD_PRIORITY) */
    ERROR_INVALID_PARAMETER,                           /* c000071c (STATUS_INVALID_THREAD) */
    ERROR_INVALID_FUNCTION,                            /* c000071d (STATUS_CALLBACK_RETURNED_TRANSACTION) */
    ERROR_INVALID_FUNCTION,                            /* c000071e (STATUS_CALLBACK_RETURNED_LDR_LOCK) */
    ERROR_INVALID_FUNCTION,                            /* c000071f (STATUS_CALLBACK_RETURNED_LANG) */
    ERROR_INVALID_FUNCTION,                            /* c0000720 (STATUS_CALLBACK_RETURNED_PRI_BACK) */
    ERROR_INVALID_FUNCTION,                            /* c0000721 (STATUS_CALLBACK_RETURNED_THREAD_AFFINITY) */
    RPC_S_SYSTEM_HANDLE_COUNT_EXCEEDED,                /* c0000722 (STATUS_LPC_HANDLE_COUNT_EXCEEDED) */
    ERROR_GEN_FAILURE,                                 /* c0000723 (STATUS_EXECUTABLE_MEMORY_WRITE) */
    ERROR_GEN_FAILURE,                                 /* c0000724 (STATUS_KERNEL_EXECUTABLE_MEMORY_WRITE) */
    ERROR_GEN_FAILURE,                                 /* c0000725 (STATUS_ATTACHED_EXECUTABLE_MEMORY_WRITE) */
    ERROR_GEN_FAILURE,                                 /* c0000726 (STATUS_TRIGGERED_EXECUTABLE_MEMORY_WRITE) */
    ERROR_DISK_REPAIR_DISABLED,                        /* c0000800 (STATUS_DISK_REPAIR_DISABLED) */
    ERROR_DS_DOMAIN_RENAME_IN_PROGRESS,                /* c0000801 (STATUS_DS_DOMAIN_RENAME_IN_PROGRESS) */
    ERROR_DISK_QUOTA_EXCEEDED,                         /* c0000802 (STATUS_DISK_QUOTA_EXCEEDED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000803 */
    ERROR_CONTENT_BLOCKED,                             /* c0000804 (STATUS_CONTENT_BLOCKED) */
    ERROR_BAD_CLUSTERS,                                /* c0000805 (STATUS_BAD_CLUSTERS) */
    ERROR_VOLUME_DIRTY,                                /* c0000806 (STATUS_VOLUME_DIRTY) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0000807 */
    ERROR_DISK_REPAIR_UNSUCCESSFUL,                    /* c0000808 (STATUS_DISK_REPAIR_UNSUCCESSFUL) */
    ERROR_CORRUPT_LOG_OVERFULL,                        /* c0000809 (STATUS_CORRUPT_LOG_OVERFULL) */
    ERROR_CORRUPT_LOG_CORRUPTED,                       /* c000080a (STATUS_CORRUPT_LOG_CORRUPTED) */
    ERROR_CORRUPT_LOG_UNAVAILABLE,                     /* c000080b (STATUS_CORRUPT_LOG_UNAVAILABLE) */
    ERROR_CORRUPT_LOG_DELETED_FULL,                    /* c000080c (STATUS_CORRUPT_LOG_DELETED_FULL) */
    ERROR_CORRUPT_LOG_CLEARED,                         /* c000080d (STATUS_CORRUPT_LOG_CLEARED) */
    ERROR_ORPHAN_NAME_EXHAUSTED,                       /* c000080e (STATUS_ORPHAN_NAME_EXHAUSTED) */
    ERROR_RETRY,                                       /* c000080f (STATUS_PROACTIVE_SCAN_IN_PROGRESS) */
    ERROR_ENCRYPTED_IO_NOT_POSSIBLE,                   /* c0000810 (STATUS_ENCRYPTED_IO_NOT_POSSIBLE) */
    ERROR_INTERNAL_ERROR,                              /* c0000811 (STATUS_CORRUPT_LOG_UPLEVEL_RECORDS) */
    ERROR_FILE_CHECKED_OUT,                            /* c0000901 (STATUS_FILE_CHECKED_OUT) */
    ERROR_CHECKOUT_REQUIRED,                           /* c0000902 (STATUS_CHECKOUT_REQUIRED) */
    ERROR_BAD_FILE_TYPE,                               /* c0000903 (STATUS_BAD_FILE_TYPE) */
    ERROR_FILE_TOO_LARGE,                              /* c0000904 (STATUS_FILE_TOO_LARGE) */
    ERROR_FORMS_AUTH_REQUIRED,                         /* c0000905 (STATUS_FORMS_AUTH_REQUIRED) */
    ERROR_VIRUS_INFECTED,                              /* c0000906 (STATUS_VIRUS_INFECTED) */
    ERROR_VIRUS_DELETED,                               /* c0000907 (STATUS_VIRUS_DELETED) */
    ERROR_BAD_MCFG_TABLE,                              /* c0000908 (STATUS_BAD_MCFG_TABLE) */
    ERROR_CANNOT_BREAK_OPLOCK,                         /* c0000909 (STATUS_CANNOT_BREAK_OPLOCK) */
    NTE_BAD_KEY,                                       /* c000090a (STATUS_BAD_KEY) */
    NTE_BAD_DATA,                                      /* c000090b (STATUS_BAD_DATA) */
    NTE_NO_KEY,                                        /* c000090c (STATUS_NO_KEY) */
    ERROR_MR_MID_NOT_FOUND,                            /* c000090d */
    ERROR_MR_MID_NOT_FOUND,                            /* c000090e */
    ERROR_MR_MID_NOT_FOUND,                            /* c000090f */
    ERROR_FILE_HANDLE_REVOKED,                         /* c0000910 (STATUS_FILE_HANDLE_REVOKED) */
    ERROR_SECTION_DIRECT_MAP_ONLY,                     /* c0000911 (STATUS_SECTION_DIRECT_MAP_ONLY) */
    ERROR_VRF_VOLATILE_CFG_AND_IO_ENABLED,             /* c0000c08 (STATUS_VRF_VOLATILE_CFG_AND_IO_ENABLED) */
    ERROR_VRF_VOLATILE_NOT_STOPPABLE,                  /* c0000c09 (STATUS_VRF_VOLATILE_NOT_STOPPABLE) */
    ERROR_VRF_VOLATILE_SAFE_MODE,                      /* c0000c0a (STATUS_VRF_VOLATILE_SAFE_MODE) */
    ERROR_VRF_VOLATILE_NOT_RUNNABLE_SYSTEM,            /* c0000c0b (STATUS_VRF_VOLATILE_NOT_RUNNABLE_SYSTEM) */
    ERROR_VRF_VOLATILE_NOT_SUPPORTED_RULECLASS,        /* c0000c0c (STATUS_VRF_VOLATILE_NOT_SUPPORTED_RULECLASS) */
    ERROR_VRF_VOLATILE_PROTECTED_DRIVER,               /* c0000c0d (STATUS_VRF_VOLATILE_PROTECTED_DRIVER) */
    ERROR_VRF_VOLATILE_NMI_REGISTERED,                 /* c0000c0e (STATUS_VRF_VOLATILE_NMI_REGISTERED) */
    ERROR_VRF_VOLATILE_SETTINGS_CONFLICT,              /* c0000c0f (STATUS_VRF_VOLATILE_SETTINGS_CONFLICT) */
    ERROR_DIF_IOCALLBACK_NOT_REPLACED,                 /* c0000c76 (STATUS_DIF_IOCALLBACK_NOT_REPLACED) */
    ERROR_DIF_LIVEDUMP_LIMIT_EXCEEDED,                 /* c0000c77 (STATUS_DIF_LIVEDUMP_LIMIT_EXCEEDED) */
    ERROR_DIF_VOLATILE_SECTION_NOT_LOCKED,             /* c0000c78 (STATUS_DIF_VOLATILE_SECTION_NOT_LOCKED) */
    ERROR_DIF_VOLATILE_DRIVER_HOTPATCHED,              /* c0000c79 (STATUS_DIF_VOLATILE_DRIVER_HOTPATCHED) */
    ERROR_DIF_VOLATILE_INVALID_INFO,                   /* c0000c7a (STATUS_DIF_VOLATILE_INVALID_INFO) */
    ERROR_DIF_VOLATILE_DRIVER_IS_NOT_RUNNING,          /* c0000c7b (STATUS_DIF_VOLATILE_DRIVER_IS_NOT_RUNNING) */
    ERROR_DIF_VOLATILE_PLUGIN_IS_NOT_RUNNING,          /* c0000c7c (STATUS_DIF_VOLATILE_PLUGIN_IS_NOT_RUNNING) */
    ERROR_DIF_VOLATILE_PLUGIN_CHANGE_NOT_ALLOWED,      /* c0000c7d (STATUS_DIF_VOLATILE_PLUGIN_CHANGE_NOT_ALLOWED) */
    ERROR_DIF_VOLATILE_NOT_ALLOWED,                    /* c0000c7e (STATUS_DIF_VOLATILE_NOT_ALLOWED) */
    ERROR_DIF_BINDING_API_NOT_FOUND,                   /* c0000c7f (STATUS_DIF_BINDING_API_NOT_FOUND) */
    ERROR_WOW_ASSERTION,                               /* c0009898 (STATUS_WOW_ASSERTION) */
    NTE_BAD_SIGNATURE,                                 /* c000a000 (STATUS_INVALID_SIGNATURE) */
    NTE_HMAC_NOT_SUPPORTED,                            /* c000a001 (STATUS_HMAC_NOT_SUPPORTED) */
    ERROR_CRC,                                         /* c000a002 (STATUS_AUTH_TAG_MISMATCH) */
    ERROR_INVALID_STATE,                               /* c000a003 (STATUS_INVALID_STATE_TRANSITION) */
    ERROR_INVALID_KERNEL_INFO_VERSION,                 /* c000a004 (STATUS_INVALID_KERNEL_INFO_VERSION) */
    ERROR_INVALID_PEP_INFO_VERSION,                    /* c000a005 (STATUS_INVALID_PEP_INFO_VERSION) */
    ERROR_HANDLE_REVOKED,                              /* c000a006 (STATUS_HANDLE_REVOKED) */
    ERROR_NOT_SUPPORTED,                               /* c000a007 (STATUS_EOF_ON_GHOSTED_RANGE) */
    ERROR_UNEXPECTED_NTCACHEMANAGER_ERROR,             /* c000a008 (STATUS_CC_NEEDS_CALLBACK_SECTION_DRAIN) */
    ERROR_MR_MID_NOT_FOUND,                            /* c000a009 */
    ERROR_MR_MID_NOT_FOUND,                            /* c000a00a */
    ERROR_MR_MID_NOT_FOUND,                            /* c000a00b */
    ERROR_MR_MID_NOT_FOUND,                            /* c000a00c */
    ERROR_MR_MID_NOT_FOUND,                            /* c000a00d */
    ERROR_MR_MID_NOT_FOUND,                            /* c000a00e */
    ERROR_MR_MID_NOT_FOUND,                            /* c000a00f */
    ERROR_MORE_DATA,                                   /* c000a010 (STATUS_IPSEC_QUEUE_OVERFLOW) */
    ERROR_MORE_DATA,                                   /* c000a011 (STATUS_ND_QUEUE_OVERFLOW) */
    ERROR_HOST_UNREACHABLE,                            /* c000a012 (STATUS_HOPLIMIT_EXCEEDED) */
    ERROR_NOT_SUPPORTED,                               /* c000a013 (STATUS_PROTOCOL_NOT_SUPPORTED) */
    ERROR_PROTOCOL_UNREACHABLE,                        /* c000a014 (STATUS_FASTPATH_REJECTED) */
    ERROR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED,  /* c000a080 (STATUS_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED) */
    ERROR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR,  /* c000a081 (STATUS_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR) */
    ERROR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR,      /* c000a082 (STATUS_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR) */
    ERROR_XML_PARSE_ERROR,                             /* c000a083 (STATUS_XML_PARSE_ERROR) */
    ERROR_XMLDSIG_ERROR,                               /* c000a084 (STATUS_XMLDSIG_ERROR) */
    ERROR_WRONG_COMPARTMENT,                           /* c000a085 (STATUS_WRONG_COMPARTMENT) */
    ERROR_AUTHIP_FAILURE,                              /* c000a086 (STATUS_AUTHIP_FAILURE) */
    ERROR_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS,       /* c000a087 (STATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS) */
    ERROR_DS_OID_NOT_FOUND,                            /* c000a088 (STATUS_DS_OID_NOT_FOUND) */
    ERROR_INCORRECT_ACCOUNT_TYPE,                      /* c000a089 (STATUS_INCORRECT_ACCOUNT_TYPE) */
    ERROR_HASH_NOT_SUPPORTED,                          /* c000a100 (STATUS_HASH_NOT_SUPPORTED) */
    ERROR_HASH_NOT_PRESENT,                            /* c000a101 (STATUS_HASH_NOT_PRESENT) */
    ERROR_SECONDARY_IC_PROVIDER_NOT_REGISTERED,        /* c000a121 (STATUS_SECONDARY_IC_PROVIDER_NOT_REGISTERED) */
    ERROR_GPIO_CLIENT_INFORMATION_INVALID,             /* c000a122 (STATUS_GPIO_CLIENT_INFORMATION_INVALID) */
    ERROR_GPIO_VERSION_NOT_SUPPORTED,                  /* c000a123 (STATUS_GPIO_VERSION_NOT_SUPPORTED) */
    ERROR_GPIO_INVALID_REGISTRATION_PACKET,            /* c000a124 (STATUS_GPIO_INVALID_REGISTRATION_PACKET) */
    ERROR_GPIO_OPERATION_DENIED,                       /* c000a125 (STATUS_GPIO_OPERATION_DENIED) */
    ERROR_GPIO_INCOMPATIBLE_CONNECT_MODE,              /* c000a126 (STATUS_GPIO_INCOMPATIBLE_CONNECT_MODE) */
    ERROR_CANNOT_SWITCH_RUNLEVEL,                      /* c000a141 (STATUS_CANNOT_SWITCH_RUNLEVEL) */
    ERROR_INVALID_RUNLEVEL_SETTING,                    /* c000a142 (STATUS_INVALID_RUNLEVEL_SETTING) */
    ERROR_RUNLEVEL_SWITCH_TIMEOUT,                     /* c000a143 (STATUS_RUNLEVEL_SWITCH_TIMEOUT) */
    ERROR_MR_MID_NOT_FOUND,                            /* c000a144 */
    ERROR_RUNLEVEL_SWITCH_AGENT_TIMEOUT,               /* c000a145 (STATUS_RUNLEVEL_SWITCH_AGENT_TIMEOUT) */
    ERROR_RUNLEVEL_SWITCH_IN_PROGRESS,                 /* c000a146 (STATUS_RUNLEVEL_SWITCH_IN_PROGRESS) */
    ERROR_NOT_APPCONTAINER,                            /* c000a200 (STATUS_NOT_APPCONTAINER) */
    ERROR_NOT_SUPPORTED_IN_APPCONTAINER,               /* c000a201 (STATUS_NOT_SUPPORTED_IN_APPCONTAINER) */
    ERROR_INVALID_PACKAGE_SID_LENGTH,                  /* c000a202 (STATUS_INVALID_PACKAGE_SID_LENGTH) */
    ERROR_ACCESS_DENIED,                               /* c000a203 (STATUS_LPAC_ACCESS_DENIED) */
    ERROR_ACCESS_DENIED,                               /* c000a204 (STATUS_ADMINLESS_ACCESS_DENIED) */
    ERROR_APP_DATA_NOT_FOUND,                          /* c000a281 (STATUS_APP_DATA_NOT_FOUND) */
    ERROR_APP_DATA_EXPIRED,                            /* c000a282 (STATUS_APP_DATA_EXPIRED) */
    ERROR_APP_DATA_CORRUPT,                            /* c000a283 (STATUS_APP_DATA_CORRUPT) */
    ERROR_APP_DATA_LIMIT_EXCEEDED,                     /* c000a284 (STATUS_APP_DATA_LIMIT_EXCEEDED) */
    ERROR_APP_DATA_REBOOT_REQUIRED,                    /* c000a285 (STATUS_APP_DATA_REBOOT_REQUIRED) */
    ERROR_OFFLOAD_READ_FLT_NOT_SUPPORTED,              /* c000a2a1 (STATUS_OFFLOAD_READ_FLT_NOT_SUPPORTED) */
    ERROR_OFFLOAD_WRITE_FLT_NOT_SUPPORTED,             /* c000a2a2 (STATUS_OFFLOAD_WRITE_FLT_NOT_SUPPORTED) */
    ERROR_OFFLOAD_READ_FILE_NOT_SUPPORTED,             /* c000a2a3 (STATUS_OFFLOAD_READ_FILE_NOT_SUPPORTED) */
    ERROR_OFFLOAD_WRITE_FILE_NOT_SUPPORTED,            /* c000a2a4 (STATUS_OFFLOAD_WRITE_FILE_NOT_SUPPORTED) */
    ERROR_WOF_WIM_HEADER_CORRUPT,                      /* c000a2a5 (STATUS_WOF_WIM_HEADER_CORRUPT) */
    ERROR_WOF_WIM_RESOURCE_TABLE_CORRUPT,              /* c000a2a6 (STATUS_WOF_WIM_RESOURCE_TABLE_CORRUPT) */
    ERROR_WOF_FILE_RESOURCE_TABLE_CORRUPT,             /* c000a2a7 (STATUS_WOF_FILE_RESOURCE_TABLE_CORRUPT) */
    ERROR_CIMFS_IMAGE_CORRUPT,                         /* c000c001 (STATUS_CIMFS_IMAGE_CORRUPT) */
    ERROR_CIMFS_IMAGE_VERSION_NOT_SUPPORTED,           /* c000c002 (STATUS_CIMFS_IMAGE_VERSION_NOT_SUPPORTED) */
    ERROR_FILE_SYSTEM_VIRTUALIZATION_UNAVAILABLE,      /* c000ce01 (STATUS_FILE_SYSTEM_VIRTUALIZATION_UNAVAILABLE) */
    ERROR_FILE_SYSTEM_VIRTUALIZATION_METADATA_CORRUPT, /* c000ce02 (STATUS_FILE_SYSTEM_VIRTUALIZATION_METADATA_CORRUPT) */
    ERROR_FILE_SYSTEM_VIRTUALIZATION_BUSY,             /* c000ce03 (STATUS_FILE_SYSTEM_VIRTUALIZATION_BUSY) */
    ERROR_FILE_SYSTEM_VIRTUALIZATION_PROVIDER_UNKNOWN, /* c000ce04 (STATUS_FILE_SYSTEM_VIRTUALIZATION_PROVIDER_UNKNOWN) */
    ERROR_FILE_SYSTEM_VIRTUALIZATION_INVALID_OPERATION, /* c000ce05 (STATUS_FILE_SYSTEM_VIRTUALIZATION_INVALID_OPERATION) */
    ERROR_CLOUD_FILE_SYNC_ROOT_METADATA_CORRUPT,       /* c000cf00 (STATUS_CLOUD_FILE_SYNC_ROOT_METADATA_CORRUPT) */
    ERROR_CLOUD_FILE_PROVIDER_NOT_RUNNING,             /* c000cf01 (STATUS_CLOUD_FILE_PROVIDER_NOT_RUNNING) */
    ERROR_CLOUD_FILE_METADATA_CORRUPT,                 /* c000cf02 (STATUS_CLOUD_FILE_METADATA_CORRUPT) */
    ERROR_CLOUD_FILE_METADATA_TOO_LARGE,               /* c000cf03 (STATUS_CLOUD_FILE_METADATA_TOO_LARGE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c000cf04 */
    ERROR_MR_MID_NOT_FOUND,                            /* c000cf05 */
    ERROR_CLOUD_FILE_PROPERTY_VERSION_NOT_SUPPORTED,   /* c000cf06 (STATUS_CLOUD_FILE_PROPERTY_VERSION_NOT_SUPPORTED) */
    ERROR_NOT_A_CLOUD_FILE,                            /* c000cf07 (STATUS_NOT_A_CLOUD_FILE) */
    ERROR_CLOUD_FILE_NOT_IN_SYNC,                      /* c000cf08 (STATUS_CLOUD_FILE_NOT_IN_SYNC) */
    ERROR_CLOUD_FILE_ALREADY_CONNECTED,                /* c000cf09 (STATUS_CLOUD_FILE_ALREADY_CONNECTED) */
    ERROR_CLOUD_FILE_NOT_SUPPORTED,                    /* c000cf0a (STATUS_CLOUD_FILE_NOT_SUPPORTED) */
    ERROR_CLOUD_FILE_INVALID_REQUEST,                  /* c000cf0b (STATUS_CLOUD_FILE_INVALID_REQUEST) */
    ERROR_CLOUD_FILE_READ_ONLY_VOLUME,                 /* c000cf0c (STATUS_CLOUD_FILE_READ_ONLY_VOLUME) */
    ERROR_CLOUD_FILE_CONNECTED_PROVIDER_ONLY,          /* c000cf0d (STATUS_CLOUD_FILE_CONNECTED_PROVIDER_ONLY) */
    ERROR_CLOUD_FILE_VALIDATION_FAILED,                /* c000cf0e (STATUS_CLOUD_FILE_VALIDATION_FAILED) */
    ERROR_CLOUD_FILE_AUTHENTICATION_FAILED,            /* c000cf0f (STATUS_CLOUD_FILE_AUTHENTICATION_FAILED) */
    ERROR_CLOUD_FILE_INSUFFICIENT_RESOURCES,           /* c000cf10 (STATUS_CLOUD_FILE_INSUFFICIENT_RESOURCES) */
    ERROR_CLOUD_FILE_NETWORK_UNAVAILABLE,              /* c000cf11 (STATUS_CLOUD_FILE_NETWORK_UNAVAILABLE) */
    ERROR_CLOUD_FILE_UNSUCCESSFUL,                     /* c000cf12 (STATUS_CLOUD_FILE_UNSUCCESSFUL) */
    ERROR_CLOUD_FILE_NOT_UNDER_SYNC_ROOT,              /* c000cf13 (STATUS_CLOUD_FILE_NOT_UNDER_SYNC_ROOT) */
    ERROR_CLOUD_FILE_IN_USE,                           /* c000cf14 (STATUS_CLOUD_FILE_IN_USE) */
    ERROR_CLOUD_FILE_PINNED,                           /* c000cf15 (STATUS_CLOUD_FILE_PINNED) */
    ERROR_CLOUD_FILE_REQUEST_ABORTED,                  /* c000cf16 (STATUS_CLOUD_FILE_REQUEST_ABORTED) */
    ERROR_CLOUD_FILE_PROPERTY_CORRUPT,                 /* c000cf17 (STATUS_CLOUD_FILE_PROPERTY_CORRUPT) */
    ERROR_CLOUD_FILE_ACCESS_DENIED,                    /* c000cf18 (STATUS_CLOUD_FILE_ACCESS_DENIED) */
    ERROR_CLOUD_FILE_INCOMPATIBLE_HARDLINKS,           /* c000cf19 (STATUS_CLOUD_FILE_INCOMPATIBLE_HARDLINKS) */
    ERROR_CLOUD_FILE_PROPERTY_LOCK_CONFLICT,           /* c000cf1a (STATUS_CLOUD_FILE_PROPERTY_LOCK_CONFLICT) */
    ERROR_CLOUD_FILE_REQUEST_CANCELED,                 /* c000cf1b (STATUS_CLOUD_FILE_REQUEST_CANCELED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c000cf1c */
    ERROR_CLOUD_FILE_PROVIDER_TERMINATED,              /* c000cf1d (STATUS_CLOUD_FILE_PROVIDER_TERMINATED) */
    ERROR_NOT_A_CLOUD_SYNC_ROOT,                       /* c000cf1e (STATUS_NOT_A_CLOUD_SYNC_ROOT) */
    ERROR_CLOUD_FILE_REQUEST_TIMEOUT,                  /* c000cf1f (STATUS_CLOUD_FILE_REQUEST_TIMEOUT) */
    ERROR_CLOUD_FILE_DEHYDRATION_DISALLOWED,           /* c000cf20 (STATUS_CLOUD_FILE_DEHYDRATION_DISALLOWED) */
    ERROR_FILE_SNAP_IN_PROGRESS,                       /* c000f500 (STATUS_FILE_SNAP_IN_PROGRESS) */
    ERROR_FILE_SNAP_USER_SECTION_NOT_SUPPORTED,        /* c000f501 (STATUS_FILE_SNAP_USER_SECTION_NOT_SUPPORTED) */
    ERROR_FILE_SNAP_MODIFY_NOT_SUPPORTED,              /* c000f502 (STATUS_FILE_SNAP_MODIFY_NOT_SUPPORTED) */
    ERROR_FILE_SNAP_IO_NOT_COORDINATED,                /* c000f503 (STATUS_FILE_SNAP_IO_NOT_COORDINATED) */
    ERROR_FILE_SNAP_UNEXPECTED_ERROR,                  /* c000f504 (STATUS_FILE_SNAP_UNEXPECTED_ERROR) */
    ERROR_FILE_SNAP_INVALID_PARAMETER,                 /* c000f505 (STATUS_FILE_SNAP_INVALID_PARAMETER) */
    RPC_S_INVALID_STRING_BINDING,                      /* c0020001 (RPC_NT_INVALID_STRING_BINDING) */
    RPC_S_WRONG_KIND_OF_BINDING,                       /* c0020002 (RPC_NT_WRONG_KIND_OF_BINDING) */
    ERROR_INVALID_HANDLE,                              /* c0020003 (RPC_NT_INVALID_BINDING) */
    RPC_S_PROTSEQ_NOT_SUPPORTED,                       /* c0020004 (RPC_NT_PROTSEQ_NOT_SUPPORTED) */
    RPC_S_INVALID_RPC_PROTSEQ,                         /* c0020005 (RPC_NT_INVALID_RPC_PROTSEQ) */
    RPC_S_INVALID_STRING_UUID,                         /* c0020006 (RPC_NT_INVALID_STRING_UUID) */
    RPC_S_INVALID_ENDPOINT_FORMAT,                     /* c0020007 (RPC_NT_INVALID_ENDPOINT_FORMAT) */
    RPC_S_INVALID_NET_ADDR,                            /* c0020008 (RPC_NT_INVALID_NET_ADDR) */
    RPC_S_NO_ENDPOINT_FOUND,                           /* c0020009 (RPC_NT_NO_ENDPOINT_FOUND) */
    RPC_S_INVALID_TIMEOUT,                             /* c002000a (RPC_NT_INVALID_TIMEOUT) */
    RPC_S_OBJECT_NOT_FOUND,                            /* c002000b (RPC_NT_OBJECT_NOT_FOUND) */
    RPC_S_ALREADY_REGISTERED,                          /* c002000c (RPC_NT_ALREADY_REGISTERED) */
    RPC_S_TYPE_ALREADY_REGISTERED,                     /* c002000d (RPC_NT_TYPE_ALREADY_REGISTERED) */
    RPC_S_ALREADY_LISTENING,                           /* c002000e (RPC_NT_ALREADY_LISTENING) */
    RPC_S_NO_PROTSEQS_REGISTERED,                      /* c002000f (RPC_NT_NO_PROTSEQS_REGISTERED) */
    RPC_S_NOT_LISTENING,                               /* c0020010 (RPC_NT_NOT_LISTENING) */
    RPC_S_UNKNOWN_MGR_TYPE,                            /* c0020011 (RPC_NT_UNKNOWN_MGR_TYPE) */
    RPC_S_UNKNOWN_IF,                                  /* c0020012 (RPC_NT_UNKNOWN_IF) */
    RPC_S_NO_BINDINGS,                                 /* c0020013 (RPC_NT_NO_BINDINGS) */
    RPC_S_NO_PROTSEQS,                                 /* c0020014 (RPC_NT_NO_PROTSEQS) */
    RPC_S_CANT_CREATE_ENDPOINT,                        /* c0020015 (RPC_NT_CANT_CREATE_ENDPOINT) */
    RPC_S_OUT_OF_RESOURCES,                            /* c0020016 (RPC_NT_OUT_OF_RESOURCES) */
    RPC_S_SERVER_UNAVAILABLE,                          /* c0020017 (RPC_NT_SERVER_UNAVAILABLE) */
    RPC_S_SERVER_TOO_BUSY,                             /* c0020018 (RPC_NT_SERVER_TOO_BUSY) */
    RPC_S_INVALID_NETWORK_OPTIONS,                     /* c0020019 (RPC_NT_INVALID_NETWORK_OPTIONS) */
    RPC_S_NO_CALL_ACTIVE,                              /* c002001a (RPC_NT_NO_CALL_ACTIVE) */
    RPC_S_CALL_FAILED,                                 /* c002001b (RPC_NT_CALL_FAILED) */
    RPC_S_CALL_FAILED_DNE,                             /* c002001c (RPC_NT_CALL_FAILED_DNE) */
    RPC_S_PROTOCOL_ERROR,                              /* c002001d (RPC_NT_PROTOCOL_ERROR) */
    ERROR_MR_MID_NOT_FOUND,                            /* c002001e */
    RPC_S_UNSUPPORTED_TRANS_SYN,                       /* c002001f (RPC_NT_UNSUPPORTED_TRANS_SYN) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0020020 */
    RPC_S_UNSUPPORTED_TYPE,                            /* c0020021 (RPC_NT_UNSUPPORTED_TYPE) */
    RPC_S_INVALID_TAG,                                 /* c0020022 (RPC_NT_INVALID_TAG) */
    RPC_S_INVALID_BOUND,                               /* c0020023 (RPC_NT_INVALID_BOUND) */
    RPC_S_NO_ENTRY_NAME,                               /* c0020024 (RPC_NT_NO_ENTRY_NAME) */
    RPC_S_INVALID_NAME_SYNTAX,                         /* c0020025 (RPC_NT_INVALID_NAME_SYNTAX) */
    RPC_S_UNSUPPORTED_NAME_SYNTAX,                     /* c0020026 (RPC_NT_UNSUPPORTED_NAME_SYNTAX) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0020027 */
    RPC_S_UUID_NO_ADDRESS,                             /* c0020028 (RPC_NT_UUID_NO_ADDRESS) */
    RPC_S_DUPLICATE_ENDPOINT,                          /* c0020029 (RPC_NT_DUPLICATE_ENDPOINT) */
    RPC_S_UNKNOWN_AUTHN_TYPE,                          /* c002002a (RPC_NT_UNKNOWN_AUTHN_TYPE) */
    RPC_S_MAX_CALLS_TOO_SMALL,                         /* c002002b (RPC_NT_MAX_CALLS_TOO_SMALL) */
    RPC_S_STRING_TOO_LONG,                             /* c002002c (RPC_NT_STRING_TOO_LONG) */
    RPC_S_PROTSEQ_NOT_FOUND,                           /* c002002d (RPC_NT_PROTSEQ_NOT_FOUND) */
    RPC_S_PROCNUM_OUT_OF_RANGE,                        /* c002002e (RPC_NT_PROCNUM_OUT_OF_RANGE) */
    RPC_S_BINDING_HAS_NO_AUTH,                         /* c002002f (RPC_NT_BINDING_HAS_NO_AUTH) */
    RPC_S_UNKNOWN_AUTHN_SERVICE,                       /* c0020030 (RPC_NT_UNKNOWN_AUTHN_SERVICE) */
    RPC_S_UNKNOWN_AUTHN_LEVEL,                         /* c0020031 (RPC_NT_UNKNOWN_AUTHN_LEVEL) */
    RPC_S_INVALID_AUTH_IDENTITY,                       /* c0020032 (RPC_NT_INVALID_AUTH_IDENTITY) */
    RPC_S_UNKNOWN_AUTHZ_SERVICE,                       /* c0020033 (RPC_NT_UNKNOWN_AUTHZ_SERVICE) */
    EPT_S_INVALID_ENTRY,                               /* c0020034 (EPT_NT_INVALID_ENTRY) */
    EPT_S_CANT_PERFORM_OP,                             /* c0020035 (EPT_NT_CANT_PERFORM_OP) */
    EPT_S_NOT_REGISTERED,                              /* c0020036 (EPT_NT_NOT_REGISTERED) */
    RPC_S_NOTHING_TO_EXPORT,                           /* c0020037 (RPC_NT_NOTHING_TO_EXPORT) */
    RPC_S_INCOMPLETE_NAME,                             /* c0020038 (RPC_NT_INCOMPLETE_NAME) */
    RPC_S_INVALID_VERS_OPTION,                         /* c0020039 (RPC_NT_INVALID_VERS_OPTION) */
    RPC_S_NO_MORE_MEMBERS,                             /* c002003a (RPC_NT_NO_MORE_MEMBERS) */
    RPC_S_NOT_ALL_OBJS_UNEXPORTED,                     /* c002003b (RPC_NT_NOT_ALL_OBJS_UNEXPORTED) */
    RPC_S_INTERFACE_NOT_FOUND,                         /* c002003c (RPC_NT_INTERFACE_NOT_FOUND) */
    RPC_S_ENTRY_ALREADY_EXISTS,                        /* c002003d (RPC_NT_ENTRY_ALREADY_EXISTS) */
    RPC_S_ENTRY_NOT_FOUND,                             /* c002003e (RPC_NT_ENTRY_NOT_FOUND) */
    RPC_S_NAME_SERVICE_UNAVAILABLE,                    /* c002003f (RPC_NT_NAME_SERVICE_UNAVAILABLE) */
    RPC_S_INVALID_NAF_ID,                              /* c0020040 (RPC_NT_INVALID_NAF_ID) */
    RPC_S_CANNOT_SUPPORT,                              /* c0020041 (RPC_NT_CANNOT_SUPPORT) */
    RPC_S_NO_CONTEXT_AVAILABLE,                        /* c0020042 (RPC_NT_NO_CONTEXT_AVAILABLE) */
    RPC_S_INTERNAL_ERROR,                              /* c0020043 (RPC_NT_INTERNAL_ERROR) */
    RPC_S_ZERO_DIVIDE,                                 /* c0020044 (RPC_NT_ZERO_DIVIDE) */
    RPC_S_ADDRESS_ERROR,                               /* c0020045 (RPC_NT_ADDRESS_ERROR) */
    RPC_S_FP_DIV_ZERO,                                 /* c0020046 (RPC_NT_FP_DIV_ZERO) */
    RPC_S_FP_UNDERFLOW,                                /* c0020047 (RPC_NT_FP_UNDERFLOW) */
    RPC_S_FP_OVERFLOW,                                 /* c0020048 (RPC_NT_FP_OVERFLOW) */
    RPC_S_CALL_IN_PROGRESS,                            /* c0020049 (RPC_NT_CALL_IN_PROGRESS) */
    RPC_S_NO_MORE_BINDINGS,                            /* c002004a (RPC_NT_NO_MORE_BINDINGS) */
    RPC_S_GROUP_MEMBER_NOT_FOUND,                      /* c002004b (RPC_NT_GROUP_MEMBER_NOT_FOUND) */
    EPT_S_CANT_CREATE,                                 /* c002004c (EPT_NT_CANT_CREATE) */
    RPC_S_INVALID_OBJECT,                              /* c002004d (RPC_NT_INVALID_OBJECT) */
    ERROR_MR_MID_NOT_FOUND,                            /* c002004e */
    RPC_S_NO_INTERFACES,                               /* c002004f (RPC_NT_NO_INTERFACES) */
    RPC_S_CALL_CANCELLED,                              /* c0020050 (RPC_NT_CALL_CANCELLED) */
    RPC_S_BINDING_INCOMPLETE,                          /* c0020051 (RPC_NT_BINDING_INCOMPLETE) */
    RPC_S_COMM_FAILURE,                                /* c0020052 (RPC_NT_COMM_FAILURE) */
    RPC_S_UNSUPPORTED_AUTHN_LEVEL,                     /* c0020053 (RPC_NT_UNSUPPORTED_AUTHN_LEVEL) */
    RPC_S_NO_PRINC_NAME,                               /* c0020054 (RPC_NT_NO_PRINC_NAME) */
    RPC_S_NOT_RPC_ERROR,                               /* c0020055 (RPC_NT_NOT_RPC_ERROR) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0020056 */
    RPC_S_SEC_PKG_ERROR,                               /* c0020057 (RPC_NT_SEC_PKG_ERROR) */
    RPC_S_NOT_CANCELLED,                               /* c0020058 (RPC_NT_NOT_CANCELLED) */
    RPC_S_INVALID_ASYNC_HANDLE,                        /* c0020062 (RPC_NT_INVALID_ASYNC_HANDLE) */
    RPC_S_INVALID_ASYNC_CALL,                          /* c0020063 (RPC_NT_INVALID_ASYNC_CALL) */
    RPC_S_PROXY_ACCESS_DENIED,                         /* c0020064 (RPC_NT_PROXY_ACCESS_DENIED) */
    RPC_S_COOKIE_AUTH_FAILED,                          /* c0020065 (RPC_NT_COOKIE_AUTH_FAILED) */
    RPC_X_NO_MORE_ENTRIES,                             /* c0030001 (RPC_NT_NO_MORE_ENTRIES) */
    RPC_X_SS_CHAR_TRANS_OPEN_FAIL,                     /* c0030002 (RPC_NT_SS_CHAR_TRANS_OPEN_FAIL) */
    RPC_X_SS_CHAR_TRANS_SHORT_FILE,                    /* c0030003 (RPC_NT_SS_CHAR_TRANS_SHORT_FILE) */
    ERROR_INVALID_HANDLE,                              /* c0030004 (RPC_NT_SS_IN_NULL_CONTEXT) */
    ERROR_INVALID_HANDLE,                              /* c0030005 (RPC_NT_SS_CONTEXT_MISMATCH) */
    RPC_X_SS_CONTEXT_DAMAGED,                          /* c0030006 (RPC_NT_SS_CONTEXT_DAMAGED) */
    RPC_X_SS_HANDLES_MISMATCH,                         /* c0030007 (RPC_NT_SS_HANDLES_MISMATCH) */
    RPC_X_SS_CANNOT_GET_CALL_HANDLE,                   /* c0030008 (RPC_NT_SS_CANNOT_GET_CALL_HANDLE) */
    RPC_X_NULL_REF_POINTER,                            /* c0030009 (RPC_NT_NULL_REF_POINTER) */
    RPC_X_ENUM_VALUE_OUT_OF_RANGE,                     /* c003000a (RPC_NT_ENUM_VALUE_OUT_OF_RANGE) */
    RPC_X_BYTE_COUNT_TOO_SMALL,                        /* c003000b (RPC_NT_BYTE_COUNT_TOO_SMALL) */
    RPC_X_BAD_STUB_DATA,                               /* c003000c (RPC_NT_BAD_STUB_DATA) */
    RPC_X_INVALID_ES_ACTION,                           /* c0030059 (RPC_NT_INVALID_ES_ACTION) */
    RPC_X_WRONG_ES_VERSION,                            /* c003005a (RPC_NT_WRONG_ES_VERSION) */
    RPC_X_WRONG_STUB_VERSION,                          /* c003005b (RPC_NT_WRONG_STUB_VERSION) */
    RPC_X_INVALID_PIPE_OBJECT,                         /* c003005c (RPC_NT_INVALID_PIPE_OBJECT) */
    RPC_X_WRONG_PIPE_ORDER,                            /* c003005d (RPC_NT_INVALID_PIPE_OPERATION) */
    RPC_X_WRONG_PIPE_VERSION,                          /* c003005e (RPC_NT_WRONG_PIPE_VERSION) */
    RPC_X_PIPE_CLOSED,                                 /* c003005f (RPC_NT_PIPE_CLOSED) */
    RPC_X_PIPE_DISCIPLINE_ERROR,                       /* c0030060 (RPC_NT_PIPE_DISCIPLINE_ERROR) */
    RPC_X_PIPE_EMPTY,                                  /* c0030061 (RPC_NT_PIPE_EMPTY) */
    ERROR_PNP_BAD_MPS_TABLE,                           /* c0040035 (STATUS_PNP_BAD_MPS_TABLE) */
    ERROR_PNP_TRANSLATION_FAILED,                      /* c0040036 (STATUS_PNP_TRANSLATION_FAILED) */
    ERROR_PNP_IRQ_TRANSLATION_FAILED,                  /* c0040037 (STATUS_PNP_IRQ_TRANSLATION_FAILED) */
    ERROR_PNP_INVALID_ID,                              /* c0040038 (STATUS_PNP_INVALID_ID) */
    ERROR_IO_REISSUE_AS_CACHED,                        /* c0040039 (STATUS_IO_REISSUE_AS_CACHED) */
    ERROR_CTX_WINSTATION_NAME_INVALID,                 /* c00a0001 (STATUS_CTX_WINSTATION_NAME_INVALID) */
    ERROR_CTX_INVALID_PD,                              /* c00a0002 (STATUS_CTX_INVALID_PD) */
    ERROR_CTX_PD_NOT_FOUND,                            /* c00a0003 (STATUS_CTX_PD_NOT_FOUND) */
    ERROR_MR_MID_NOT_FOUND,                            /* c00a0004 */
    ERROR_MR_MID_NOT_FOUND,                            /* c00a0005 */
    ERROR_CTX_CLOSE_PENDING,                           /* c00a0006 (STATUS_CTX_CLOSE_PENDING) */
    ERROR_CTX_NO_OUTBUF,                               /* c00a0007 (STATUS_CTX_NO_OUTBUF) */
    ERROR_CTX_MODEM_INF_NOT_FOUND,                     /* c00a0008 (STATUS_CTX_MODEM_INF_NOT_FOUND) */
    ERROR_CTX_INVALID_MODEMNAME,                       /* c00a0009 (STATUS_CTX_INVALID_MODEMNAME) */
    ERROR_CTX_MODEM_RESPONSE_ERROR,                    /* c00a000a (STATUS_CTX_RESPONSE_ERROR) */
    ERROR_CTX_MODEM_RESPONSE_TIMEOUT,                  /* c00a000b (STATUS_CTX_MODEM_RESPONSE_TIMEOUT) */
    ERROR_CTX_MODEM_RESPONSE_NO_CARRIER,               /* c00a000c (STATUS_CTX_MODEM_RESPONSE_NO_CARRIER) */
    ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE,              /* c00a000d (STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE) */
    ERROR_CTX_MODEM_RESPONSE_BUSY,                     /* c00a000e (STATUS_CTX_MODEM_RESPONSE_BUSY) */
    ERROR_CTX_MODEM_RESPONSE_VOICE,                    /* c00a000f (STATUS_CTX_MODEM_RESPONSE_VOICE) */
    ERROR_CTX_TD_ERROR,                                /* c00a0010 (STATUS_CTX_TD_ERROR) */
    ERROR_MR_MID_NOT_FOUND,                            /* c00a0011 */
    ERROR_CTX_LICENSE_CLIENT_INVALID,                  /* c00a0012 (STATUS_CTX_LICENSE_CLIENT_INVALID) */
    ERROR_CTX_LICENSE_NOT_AVAILABLE,                   /* c00a0013 (STATUS_CTX_LICENSE_NOT_AVAILABLE) */
    ERROR_CTX_LICENSE_EXPIRED,                         /* c00a0014 (STATUS_CTX_LICENSE_EXPIRED) */
    ERROR_CTX_WINSTATION_NOT_FOUND,                    /* c00a0015 (STATUS_CTX_WINSTATION_NOT_FOUND) */
    ERROR_CTX_WINSTATION_ALREADY_EXISTS,               /* c00a0016 (STATUS_CTX_WINSTATION_NAME_COLLISION) */
    ERROR_CTX_WINSTATION_BUSY,                         /* c00a0017 (STATUS_CTX_WINSTATION_BUSY) */
    ERROR_CTX_BAD_VIDEO_MODE,                          /* c00a0018 (STATUS_CTX_BAD_VIDEO_MODE) */
    ERROR_CTX_GRAPHICS_INVALID,                        /* c00a0022 (STATUS_CTX_GRAPHICS_INVALID) */
    ERROR_MR_MID_NOT_FOUND,                            /* c00a0023 */
    ERROR_CTX_NOT_CONSOLE,                             /* c00a0024 (STATUS_CTX_NOT_CONSOLE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c00a0025 */
    ERROR_CTX_CLIENT_QUERY_TIMEOUT,                    /* c00a0026 (STATUS_CTX_CLIENT_QUERY_TIMEOUT) */
    ERROR_CTX_CONSOLE_DISCONNECT,                      /* c00a0027 (STATUS_CTX_CONSOLE_DISCONNECT) */
    ERROR_CTX_CONSOLE_CONNECT,                         /* c00a0028 (STATUS_CTX_CONSOLE_CONNECT) */
    ERROR_MR_MID_NOT_FOUND,                            /* c00a0029 */
    ERROR_CTX_SHADOW_DENIED,                           /* c00a002a (STATUS_CTX_SHADOW_DENIED) */
    ERROR_CTX_WINSTATION_ACCESS_DENIED,                /* c00a002b (STATUS_CTX_WINSTATION_ACCESS_DENIED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c00a002c */
    ERROR_MR_MID_NOT_FOUND,                            /* c00a002d */
    ERROR_CTX_INVALID_WD,                              /* c00a002e (STATUS_CTX_INVALID_WD) */
    ERROR_CTX_WD_NOT_FOUND,                            /* c00a002f (STATUS_CTX_WD_NOT_FOUND) */
    ERROR_CTX_SHADOW_INVALID,                          /* c00a0030 (STATUS_CTX_SHADOW_INVALID) */
    ERROR_CTX_SHADOW_DISABLED,                         /* c00a0031 (STATUS_CTX_SHADOW_DISABLED) */
    ERROR_RDP_PROTOCOL_ERROR,                          /* c00a0032 (STATUS_RDP_PROTOCOL_ERROR) */
    ERROR_CTX_CLIENT_LICENSE_NOT_SET,                  /* c00a0033 (STATUS_CTX_CLIENT_LICENSE_NOT_SET) */
    ERROR_CTX_CLIENT_LICENSE_IN_USE,                   /* c00a0034 (STATUS_CTX_CLIENT_LICENSE_IN_USE) */
    ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE,             /* c00a0035 (STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE) */
    ERROR_CTX_SHADOW_NOT_RUNNING,                      /* c00a0036 (STATUS_CTX_SHADOW_NOT_RUNNING) */
    ERROR_CTX_LOGON_DISABLED,                          /* c00a0037 (STATUS_CTX_LOGON_DISABLED) */
    ERROR_CTX_SECURITY_LAYER_ERROR,                    /* c00a0038 (STATUS_CTX_SECURITY_LAYER_ERROR) */
    ERROR_TS_INCOMPATIBLE_SESSIONS,                    /* c00a0039 (STATUS_TS_INCOMPATIBLE_SESSIONS) */
    ERROR_TS_VIDEO_SUBSYSTEM_ERROR,                    /* c00a003a (STATUS_TS_VIDEO_SUBSYSTEM_ERROR) */
    ERROR_MUI_FILE_NOT_FOUND,                          /* c00b0001 (STATUS_MUI_FILE_NOT_FOUND) */
    ERROR_MUI_INVALID_FILE,                            /* c00b0002 (STATUS_MUI_INVALID_FILE) */
    ERROR_MUI_INVALID_RC_CONFIG,                       /* c00b0003 (STATUS_MUI_INVALID_RC_CONFIG) */
    ERROR_MUI_INVALID_LOCALE_NAME,                     /* c00b0004 (STATUS_MUI_INVALID_LOCALE_NAME) */
    ERROR_MUI_INVALID_ULTIMATEFALLBACK_NAME,           /* c00b0005 (STATUS_MUI_INVALID_ULTIMATEFALLBACK_NAME) */
    ERROR_MUI_FILE_NOT_LOADED,                         /* c00b0006 (STATUS_MUI_FILE_NOT_LOADED) */
    ERROR_RESOURCE_ENUM_USER_STOP,                     /* c00b0007 (STATUS_RESOURCE_ENUM_USER_STOP) */
    ERROR_CLUSTER_INVALID_NODE,                        /* c0130001 (STATUS_CLUSTER_INVALID_NODE) */
    ERROR_CLUSTER_NODE_EXISTS,                         /* c0130002 (STATUS_CLUSTER_NODE_EXISTS) */
    ERROR_CLUSTER_JOIN_IN_PROGRESS,                    /* c0130003 (STATUS_CLUSTER_JOIN_IN_PROGRESS) */
    ERROR_CLUSTER_NODE_NOT_FOUND,                      /* c0130004 (STATUS_CLUSTER_NODE_NOT_FOUND) */
    ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND,                /* c0130005 (STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND) */
    ERROR_CLUSTER_NETWORK_EXISTS,                      /* c0130006 (STATUS_CLUSTER_NETWORK_EXISTS) */
    ERROR_CLUSTER_NETWORK_NOT_FOUND,                   /* c0130007 (STATUS_CLUSTER_NETWORK_NOT_FOUND) */
    ERROR_CLUSTER_NETINTERFACE_EXISTS,                 /* c0130008 (STATUS_CLUSTER_NETINTERFACE_EXISTS) */
    ERROR_CLUSTER_NETINTERFACE_NOT_FOUND,              /* c0130009 (STATUS_CLUSTER_NETINTERFACE_NOT_FOUND) */
    ERROR_CLUSTER_INVALID_REQUEST,                     /* c013000a (STATUS_CLUSTER_INVALID_REQUEST) */
    ERROR_CLUSTER_INVALID_NETWORK_PROVIDER,            /* c013000b (STATUS_CLUSTER_INVALID_NETWORK_PROVIDER) */
    ERROR_CLUSTER_NODE_DOWN,                           /* c013000c (STATUS_CLUSTER_NODE_DOWN) */
    ERROR_CLUSTER_NODE_UNREACHABLE,                    /* c013000d (STATUS_CLUSTER_NODE_UNREACHABLE) */
    ERROR_CLUSTER_NODE_NOT_MEMBER,                     /* c013000e (STATUS_CLUSTER_NODE_NOT_MEMBER) */
    ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS,                /* c013000f (STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS) */
    ERROR_CLUSTER_INVALID_NETWORK,                     /* c0130010 (STATUS_CLUSTER_INVALID_NETWORK) */
    ERROR_CLUSTER_NO_NET_ADAPTERS,                     /* c0130011 (STATUS_CLUSTER_NO_NET_ADAPTERS) */
    ERROR_CLUSTER_NODE_UP,                             /* c0130012 (STATUS_CLUSTER_NODE_UP) */
    ERROR_CLUSTER_NODE_PAUSED,                         /* c0130013 (STATUS_CLUSTER_NODE_PAUSED) */
    ERROR_CLUSTER_NODE_NOT_PAUSED,                     /* c0130014 (STATUS_CLUSTER_NODE_NOT_PAUSED) */
    ERROR_CLUSTER_NO_SECURITY_CONTEXT,                 /* c0130015 (STATUS_CLUSTER_NO_SECURITY_CONTEXT) */
    ERROR_CLUSTER_NETWORK_NOT_INTERNAL,                /* c0130016 (STATUS_CLUSTER_NETWORK_NOT_INTERNAL) */
    ERROR_CLUSTER_POISONED,                            /* c0130017 (STATUS_CLUSTER_POISONED) */
    ERROR_NON_CSV_PATH,                                /* c0130018 (STATUS_CLUSTER_NON_CSV_PATH) */
    ERROR_CSV_VOLUME_NOT_LOCAL,                        /* c0130019 (STATUS_CLUSTER_CSV_VOLUME_NOT_LOCAL) */
    ERROR_MR_MID_NOT_FOUND,                            /* c013001a */
    ERROR_MR_MID_NOT_FOUND,                            /* c013001b */
    ERROR_MR_MID_NOT_FOUND,                            /* c013001c */
    ERROR_MR_MID_NOT_FOUND,                            /* c013001d */
    ERROR_MR_MID_NOT_FOUND,                            /* c013001e */
    ERROR_MR_MID_NOT_FOUND,                            /* c013001f */
    ERROR_RETRY,                                       /* c0130020 (STATUS_CLUSTER_CSV_READ_OPLOCK_BREAK_IN_PROGRESS) */
    ERROR_RETRY,                                       /* c0130021 (STATUS_CLUSTER_CSV_AUTO_PAUSE_ERROR) */
    ERROR_NOT_SUPPORTED,                               /* c0130022 (STATUS_CLUSTER_CSV_REDIRECTED) */
    ERROR_NOT_SUPPORTED,                               /* c0130023 (STATUS_CLUSTER_CSV_NOT_REDIRECTED) */
    ERROR_NOT_SUPPORTED,                               /* c0130024 (STATUS_CLUSTER_CSV_VOLUME_DRAINING) */
    ERROR_RETRY,                                       /* c0130025 (STATUS_CLUSTER_CSV_SNAPSHOT_CREATION_IN_PROGRESS) */
    ERROR_NOT_SUPPORTED,                               /* c0130026 (STATUS_CLUSTER_CSV_VOLUME_DRAINING_SUCCEEDED_DOWNLEVEL) */
    ERROR_RETRY,                                       /* c0130027 (STATUS_CLUSTER_CSV_NO_SNAPSHOTS) */
    ERROR_CLUSTER_CSV_IO_PAUSE_TIMEOUT,                /* c0130028 (STATUS_CSV_IO_PAUSE_TIMEOUT) */
    ERROR_CLUSTER_CSV_INVALID_HANDLE,                  /* c0130029 (STATUS_CLUSTER_CSV_INVALID_HANDLE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c013002a */
    ERROR_MR_MID_NOT_FOUND,                            /* c013002b */
    ERROR_MR_MID_NOT_FOUND,                            /* c013002c */
    ERROR_MR_MID_NOT_FOUND,                            /* c013002d */
    ERROR_MR_MID_NOT_FOUND,                            /* c013002e */
    ERROR_MR_MID_NOT_FOUND,                            /* c013002f */
    ERROR_CLUSTER_CSV_SUPPORTED_ONLY_ON_COORDINATOR,   /* c0130030 (STATUS_CLUSTER_CSV_SUPPORTED_ONLY_ON_COORDINATOR) */
    ERROR_ACCESS_DENIED,                               /* c0130031 (STATUS_CLUSTER_CAM_TICKET_REPLAY_DETECTED) */
    ERROR_ACPI_ERROR,                                  /* c0140001 (STATUS_ACPI_INVALID_OPCODE) */
    ERROR_ACPI_ERROR,                                  /* c0140002 (STATUS_ACPI_STACK_OVERFLOW) */
    ERROR_ACPI_ERROR,                                  /* c0140003 (STATUS_ACPI_ASSERT_FAILED) */
    ERROR_ACPI_ERROR,                                  /* c0140004 (STATUS_ACPI_INVALID_INDEX) */
    ERROR_ACPI_ERROR,                                  /* c0140005 (STATUS_ACPI_INVALID_ARGUMENT) */
    ERROR_ACPI_ERROR,                                  /* c0140006 (STATUS_ACPI_FATAL) */
    ERROR_ACPI_ERROR,                                  /* c0140007 (STATUS_ACPI_INVALID_SUPERNAME) */
    ERROR_ACPI_ERROR,                                  /* c0140008 (STATUS_ACPI_INVALID_ARGTYPE) */
    ERROR_ACPI_ERROR,                                  /* c0140009 (STATUS_ACPI_INVALID_OBJTYPE) */
    ERROR_ACPI_ERROR,                                  /* c014000a (STATUS_ACPI_INVALID_TARGETTYPE) */
    ERROR_ACPI_ERROR,                                  /* c014000b (STATUS_ACPI_INCORRECT_ARGUMENT_COUNT) */
    ERROR_ACPI_ERROR,                                  /* c014000c (STATUS_ACPI_ADDRESS_NOT_MAPPED) */
    ERROR_ACPI_ERROR,                                  /* c014000d (STATUS_ACPI_INVALID_EVENTTYPE) */
    ERROR_ACPI_ERROR,                                  /* c014000e (STATUS_ACPI_HANDLER_COLLISION) */
    ERROR_ACPI_ERROR,                                  /* c014000f (STATUS_ACPI_INVALID_DATA) */
    ERROR_ACPI_ERROR,                                  /* c0140010 (STATUS_ACPI_INVALID_REGION) */
    ERROR_ACPI_ERROR,                                  /* c0140011 (STATUS_ACPI_INVALID_ACCESS_SIZE) */
    ERROR_ACPI_ERROR,                                  /* c0140012 (STATUS_ACPI_ACQUIRE_GLOBAL_LOCK) */
    ERROR_ACPI_ERROR,                                  /* c0140013 (STATUS_ACPI_ALREADY_INITIALIZED) */
    ERROR_ACPI_ERROR,                                  /* c0140014 (STATUS_ACPI_NOT_INITIALIZED) */
    ERROR_ACPI_ERROR,                                  /* c0140015 (STATUS_ACPI_INVALID_MUTEX_LEVEL) */
    ERROR_ACPI_ERROR,                                  /* c0140016 (STATUS_ACPI_MUTEX_NOT_OWNED) */
    ERROR_ACPI_ERROR,                                  /* c0140017 (STATUS_ACPI_MUTEX_NOT_OWNER) */
    ERROR_ACPI_ERROR,                                  /* c0140018 (STATUS_ACPI_RS_ACCESS) */
    ERROR_ACPI_ERROR,                                  /* c0140019 (STATUS_ACPI_INVALID_TABLE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c014001a */
    ERROR_MR_MID_NOT_FOUND,                            /* c014001b */
    ERROR_MR_MID_NOT_FOUND,                            /* c014001c */
    ERROR_MR_MID_NOT_FOUND,                            /* c014001d */
    ERROR_MR_MID_NOT_FOUND,                            /* c014001e */
    ERROR_MR_MID_NOT_FOUND,                            /* c014001f */
    ERROR_ACPI_ERROR,                                  /* c0140020 (STATUS_ACPI_REG_HANDLER_FAILED) */
    ERROR_ACPI_ERROR,                                  /* c0140021 (STATUS_ACPI_POWER_REQUEST_FAILED) */
    ERROR_SXS_SECTION_NOT_FOUND,                       /* c0150001 (STATUS_SXS_SECTION_NOT_FOUND) */
    ERROR_SXS_CANT_GEN_ACTCTX,                         /* c0150002 (STATUS_SXS_CANT_GEN_ACTCTX) */
    ERROR_SXS_INVALID_ACTCTXDATA_FORMAT,               /* c0150003 (STATUS_SXS_INVALID_ACTCTXDATA_FORMAT) */
    ERROR_SXS_ASSEMBLY_NOT_FOUND,                      /* c0150004 (STATUS_SXS_ASSEMBLY_NOT_FOUND) */
    ERROR_SXS_MANIFEST_FORMAT_ERROR,                   /* c0150005 (STATUS_SXS_MANIFEST_FORMAT_ERROR) */
    ERROR_SXS_MANIFEST_PARSE_ERROR,                    /* c0150006 (STATUS_SXS_MANIFEST_PARSE_ERROR) */
    ERROR_SXS_ACTIVATION_CONTEXT_DISABLED,             /* c0150007 (STATUS_SXS_ACTIVATION_CONTEXT_DISABLED) */
    ERROR_SXS_KEY_NOT_FOUND,                           /* c0150008 (STATUS_SXS_KEY_NOT_FOUND) */
    ERROR_SXS_VERSION_CONFLICT,                        /* c0150009 (STATUS_SXS_VERSION_CONFLICT) */
    ERROR_SXS_WRONG_SECTION_TYPE,                      /* c015000a (STATUS_SXS_WRONG_SECTION_TYPE) */
    ERROR_SXS_THREAD_QUERIES_DISABLED,                 /* c015000b (STATUS_SXS_THREAD_QUERIES_DISABLED) */
    ERROR_SXS_ASSEMBLY_MISSING,                        /* c015000c (STATUS_SXS_ASSEMBLY_MISSING) */
    ERROR_MR_MID_NOT_FOUND,                            /* c015000d */
    ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET,             /* c015000e (STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET) */
    ERROR_SXS_EARLY_DEACTIVATION,                      /* c015000f (STATUS_SXS_EARLY_DEACTIVATION) */
    ERROR_SXS_INVALID_DEACTIVATION,                    /* c0150010 (STATUS_SXS_INVALID_DEACTIVATION) */
    ERROR_SXS_MULTIPLE_DEACTIVATION,                   /* c0150011 (STATUS_SXS_MULTIPLE_DEACTIVATION) */
    ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY, /* c0150012 (STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY) */
    ERROR_SXS_PROCESS_TERMINATION_REQUESTED,           /* c0150013 (STATUS_SXS_PROCESS_TERMINATION_REQUESTED) */
    ERROR_SXS_CORRUPT_ACTIVATION_STACK,                /* c0150014 (STATUS_SXS_CORRUPT_ACTIVATION_STACK) */
    ERROR_SXS_CORRUPTION,                              /* c0150015 (STATUS_SXS_CORRUPTION) */
    ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE,        /* c0150016 (STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE) */
    ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME,         /* c0150017 (STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME) */
    ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE,            /* c0150018 (STATUS_SXS_IDENTITY_DUPLICATE_ATTRIBUTE) */
    ERROR_SXS_IDENTITY_PARSE_ERROR,                    /* c0150019 (STATUS_SXS_IDENTITY_PARSE_ERROR) */
    ERROR_SXS_COMPONENT_STORE_CORRUPT,                 /* c015001a (STATUS_SXS_COMPONENT_STORE_CORRUPT) */
    ERROR_SXS_FILE_HASH_MISMATCH,                      /* c015001b (STATUS_SXS_FILE_HASH_MISMATCH) */
    ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT, /* c015001c (STATUS_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT) */
    ERROR_SXS_IDENTITIES_DIFFERENT,                    /* c015001d (STATUS_SXS_IDENTITIES_DIFFERENT) */
    ERROR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT,            /* c015001e (STATUS_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT) */
    ERROR_SXS_FILE_NOT_PART_OF_ASSEMBLY,               /* c015001f (STATUS_SXS_FILE_NOT_PART_OF_ASSEMBLY) */
    ERROR_ADVANCED_INSTALLER_FAILED,                   /* c0150020 (STATUS_ADVANCED_INSTALLER_FAILED) */
    ERROR_XML_ENCODING_MISMATCH,                       /* c0150021 (STATUS_XML_ENCODING_MISMATCH) */
    ERROR_SXS_MANIFEST_TOO_BIG,                        /* c0150022 (STATUS_SXS_MANIFEST_TOO_BIG) */
    ERROR_SXS_SETTING_NOT_REGISTERED,                  /* c0150023 (STATUS_SXS_SETTING_NOT_REGISTERED) */
    ERROR_SXS_TRANSACTION_CLOSURE_INCOMPLETE,          /* c0150024 (STATUS_SXS_TRANSACTION_CLOSURE_INCOMPLETE) */
    ERROR_SMI_PRIMITIVE_INSTALLER_FAILED,              /* c0150025 (STATUS_SMI_PRIMITIVE_INSTALLER_FAILED) */
    ERROR_GENERIC_COMMAND_FAILED,                      /* c0150026 (STATUS_GENERIC_COMMAND_FAILED) */
    ERROR_SXS_FILE_HASH_MISSING,                       /* c0150027 (STATUS_SXS_FILE_HASH_MISSING) */
    ERROR_TRANSACTIONAL_CONFLICT,                      /* c0190001 (STATUS_TRANSACTIONAL_CONFLICT) */
    ERROR_INVALID_TRANSACTION,                         /* c0190002 (STATUS_INVALID_TRANSACTION) */
    ERROR_TRANSACTION_NOT_ACTIVE,                      /* c0190003 (STATUS_TRANSACTION_NOT_ACTIVE) */
    ERROR_TM_INITIALIZATION_FAILED,                    /* c0190004 (STATUS_TM_INITIALIZATION_FAILED) */
    ERROR_RM_NOT_ACTIVE,                               /* c0190005 (STATUS_RM_NOT_ACTIVE) */
    ERROR_RM_METADATA_CORRUPT,                         /* c0190006 (STATUS_RM_METADATA_CORRUPT) */
    ERROR_TRANSACTION_NOT_JOINED,                      /* c0190007 (STATUS_TRANSACTION_NOT_JOINED) */
    ERROR_DIRECTORY_NOT_RM,                            /* c0190008 (STATUS_DIRECTORY_NOT_RM) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0190009 */
    ERROR_TRANSACTIONS_UNSUPPORTED_REMOTE,             /* c019000a (STATUS_TRANSACTIONS_UNSUPPORTED_REMOTE) */
    ERROR_LOG_RESIZE_INVALID_SIZE,                     /* c019000b (STATUS_LOG_RESIZE_INVALID_SIZE) */
    ERROR_REMOTE_FILE_VERSION_MISMATCH,                /* c019000c (STATUS_REMOTE_FILE_VERSION_MISMATCH) */
    ERROR_MR_MID_NOT_FOUND,                            /* c019000d */
    ERROR_MR_MID_NOT_FOUND,                            /* c019000e */
    ERROR_CRM_PROTOCOL_ALREADY_EXISTS,                 /* c019000f (STATUS_CRM_PROTOCOL_ALREADY_EXISTS) */
    ERROR_TRANSACTION_PROPAGATION_FAILED,              /* c0190010 (STATUS_TRANSACTION_PROPAGATION_FAILED) */
    ERROR_CRM_PROTOCOL_NOT_FOUND,                      /* c0190011 (STATUS_CRM_PROTOCOL_NOT_FOUND) */
    ERROR_TRANSACTION_SUPERIOR_EXISTS,                 /* c0190012 (STATUS_TRANSACTION_SUPERIOR_EXISTS) */
    ERROR_TRANSACTION_REQUEST_NOT_VALID,               /* c0190013 (STATUS_TRANSACTION_REQUEST_NOT_VALID) */
    ERROR_TRANSACTION_NOT_REQUESTED,                   /* c0190014 (STATUS_TRANSACTION_NOT_REQUESTED) */
    ERROR_TRANSACTION_ALREADY_ABORTED,                 /* c0190015 (STATUS_TRANSACTION_ALREADY_ABORTED) */
    ERROR_TRANSACTION_ALREADY_COMMITTED,               /* c0190016 (STATUS_TRANSACTION_ALREADY_COMMITTED) */
    ERROR_TRANSACTION_INVALID_MARSHALL_BUFFER,         /* c0190017 (STATUS_TRANSACTION_INVALID_MARSHALL_BUFFER) */
    ERROR_CURRENT_TRANSACTION_NOT_VALID,               /* c0190018 (STATUS_CURRENT_TRANSACTION_NOT_VALID) */
    ERROR_LOG_GROWTH_FAILED,                           /* c0190019 (STATUS_LOG_GROWTH_FAILED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c019001a */
    ERROR_MR_MID_NOT_FOUND,                            /* c019001b */
    ERROR_MR_MID_NOT_FOUND,                            /* c019001c */
    ERROR_MR_MID_NOT_FOUND,                            /* c019001d */
    ERROR_MR_MID_NOT_FOUND,                            /* c019001e */
    ERROR_MR_MID_NOT_FOUND,                            /* c019001f */
    ERROR_MR_MID_NOT_FOUND,                            /* c0190020 */
    ERROR_OBJECT_NO_LONGER_EXISTS,                     /* c0190021 (STATUS_OBJECT_NO_LONGER_EXISTS) */
    ERROR_STREAM_MINIVERSION_NOT_FOUND,                /* c0190022 (STATUS_STREAM_MINIVERSION_NOT_FOUND) */
    ERROR_STREAM_MINIVERSION_NOT_VALID,                /* c0190023 (STATUS_STREAM_MINIVERSION_NOT_VALID) */
    ERROR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION, /* c0190024 (STATUS_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION) */
    ERROR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT,    /* c0190025 (STATUS_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT) */
    ERROR_CANT_CREATE_MORE_STREAM_MINIVERSIONS,        /* c0190026 (STATUS_CANT_CREATE_MORE_STREAM_MINIVERSIONS) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0190027 */
    ERROR_HANDLE_NO_LONGER_VALID,                      /* c0190028 (STATUS_HANDLE_NO_LONGER_VALID) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0190029 */
    ERROR_MR_MID_NOT_FOUND,                            /* c019002a */
    ERROR_MR_MID_NOT_FOUND,                            /* c019002b */
    ERROR_MR_MID_NOT_FOUND,                            /* c019002c */
    ERROR_MR_MID_NOT_FOUND,                            /* c019002d */
    ERROR_MR_MID_NOT_FOUND,                            /* c019002e */
    ERROR_MR_MID_NOT_FOUND,                            /* c019002f */
    ERROR_LOG_CORRUPTION_DETECTED,                     /* c0190030 (STATUS_LOG_CORRUPTION_DETECTED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0190031 */
    ERROR_RM_DISCONNECTED,                             /* c0190032 (STATUS_RM_DISCONNECTED) */
    ERROR_ENLISTMENT_NOT_SUPERIOR,                     /* c0190033 (STATUS_ENLISTMENT_NOT_SUPERIOR) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0190034 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0190035 */
    ERROR_FILE_IDENTITY_NOT_PERSISTENT,                /* c0190036 (STATUS_FILE_IDENTITY_NOT_PERSISTENT) */
    ERROR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY,         /* c0190037 (STATUS_CANT_BREAK_TRANSACTIONAL_DEPENDENCY) */
    ERROR_CANT_CROSS_RM_BOUNDARY,                      /* c0190038 (STATUS_CANT_CROSS_RM_BOUNDARY) */
    ERROR_TXF_DIR_NOT_EMPTY,                           /* c0190039 (STATUS_TXF_DIR_NOT_EMPTY) */
    ERROR_INDOUBT_TRANSACTIONS_EXIST,                  /* c019003a (STATUS_INDOUBT_TRANSACTIONS_EXIST) */
    ERROR_TM_VOLATILE,                                 /* c019003b (STATUS_TM_VOLATILE) */
    ERROR_ROLLBACK_TIMER_EXPIRED,                      /* c019003c (STATUS_ROLLBACK_TIMER_EXPIRED) */
    ERROR_TXF_ATTRIBUTE_CORRUPT,                       /* c019003d (STATUS_TXF_ATTRIBUTE_CORRUPT) */
    ERROR_EFS_NOT_ALLOWED_IN_TRANSACTION,              /* c019003e (STATUS_EFS_NOT_ALLOWED_IN_TRANSACTION) */
    ERROR_TRANSACTIONAL_OPEN_NOT_ALLOWED,              /* c019003f (STATUS_TRANSACTIONAL_OPEN_NOT_ALLOWED) */
    ERROR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE,       /* c0190040 (STATUS_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0190041 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0190042 */
    ERROR_TRANSACTION_REQUIRED_PROMOTION,              /* c0190043 (STATUS_TRANSACTION_REQUIRED_PROMOTION) */
    ERROR_CANNOT_EXECUTE_FILE_IN_TRANSACTION,          /* c0190044 (STATUS_CANNOT_EXECUTE_FILE_IN_TRANSACTION) */
    ERROR_TRANSACTIONS_NOT_FROZEN,                     /* c0190045 (STATUS_TRANSACTIONS_NOT_FROZEN) */
    ERROR_TRANSACTION_FREEZE_IN_PROGRESS,              /* c0190046 (STATUS_TRANSACTION_FREEZE_IN_PROGRESS) */
    ERROR_NOT_SNAPSHOT_VOLUME,                         /* c0190047 (STATUS_NOT_SNAPSHOT_VOLUME) */
    ERROR_NO_SAVEPOINT_WITH_OPEN_FILES,                /* c0190048 (STATUS_NO_SAVEPOINT_WITH_OPEN_FILES) */
    ERROR_SPARSE_NOT_ALLOWED_IN_TRANSACTION,           /* c0190049 (STATUS_SPARSE_NOT_ALLOWED_IN_TRANSACTION) */
    ERROR_TM_IDENTITY_MISMATCH,                        /* c019004a (STATUS_TM_IDENTITY_MISMATCH) */
    ERROR_FLOATED_SECTION,                             /* c019004b (STATUS_FLOATED_SECTION) */
    ERROR_CANNOT_ACCEPT_TRANSACTED_WORK,               /* c019004c (STATUS_CANNOT_ACCEPT_TRANSACTED_WORK) */
    ERROR_CANNOT_ABORT_TRANSACTIONS,                   /* c019004d (STATUS_CANNOT_ABORT_TRANSACTIONS) */
    ERROR_TRANSACTION_NOT_FOUND,                       /* c019004e (STATUS_TRANSACTION_NOT_FOUND) */
    ERROR_RESOURCEMANAGER_NOT_FOUND,                   /* c019004f (STATUS_RESOURCEMANAGER_NOT_FOUND) */
    ERROR_ENLISTMENT_NOT_FOUND,                        /* c0190050 (STATUS_ENLISTMENT_NOT_FOUND) */
    ERROR_TRANSACTIONMANAGER_NOT_FOUND,                /* c0190051 (STATUS_TRANSACTIONMANAGER_NOT_FOUND) */
    ERROR_TRANSACTIONMANAGER_NOT_ONLINE,               /* c0190052 (STATUS_TRANSACTIONMANAGER_NOT_ONLINE) */
    ERROR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION,  /* c0190053 (STATUS_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION) */
    ERROR_TRANSACTION_NOT_ROOT,                        /* c0190054 (STATUS_TRANSACTION_NOT_ROOT) */
    ERROR_TRANSACTION_OBJECT_EXPIRED,                  /* c0190055 (STATUS_TRANSACTION_OBJECT_EXPIRED) */
    ERROR_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION,      /* c0190056 (STATUS_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION) */
    ERROR_TRANSACTION_RESPONSE_NOT_ENLISTED,           /* c0190057 (STATUS_TRANSACTION_RESPONSE_NOT_ENLISTED) */
    ERROR_TRANSACTION_RECORD_TOO_LONG,                 /* c0190058 (STATUS_TRANSACTION_RECORD_TOO_LONG) */
    ERROR_NO_LINK_TRACKING_IN_TRANSACTION,             /* c0190059 (STATUS_NO_LINK_TRACKING_IN_TRANSACTION) */
    ERROR_OPERATION_NOT_SUPPORTED_IN_TRANSACTION,      /* c019005a (STATUS_OPERATION_NOT_SUPPORTED_IN_TRANSACTION) */
    ERROR_TRANSACTION_INTEGRITY_VIOLATED,              /* c019005b (STATUS_TRANSACTION_INTEGRITY_VIOLATED) */
    ERROR_TRANSACTIONMANAGER_IDENTITY_MISMATCH,        /* c019005c (STATUS_TRANSACTIONMANAGER_IDENTITY_MISMATCH) */
    ERROR_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT,            /* c019005d (STATUS_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT) */
    ERROR_TRANSACTION_MUST_WRITETHROUGH,               /* c019005e (STATUS_TRANSACTION_MUST_WRITETHROUGH) */
    ERROR_TRANSACTION_NO_SUPERIOR,                     /* c019005f (STATUS_TRANSACTION_NO_SUPERIOR) */
    ERROR_EXPIRED_HANDLE,                              /* c0190060 (STATUS_EXPIRED_HANDLE) */
    ERROR_TRANSACTION_NOT_ENLISTED,                    /* c0190061 (STATUS_TRANSACTION_NOT_ENLISTED) */
    ERROR_LOG_SECTOR_INVALID,                          /* c01a0001 (STATUS_LOG_SECTOR_INVALID) */
    ERROR_LOG_SECTOR_PARITY_INVALID,                   /* c01a0002 (STATUS_LOG_SECTOR_PARITY_INVALID) */
    ERROR_LOG_SECTOR_REMAPPED,                         /* c01a0003 (STATUS_LOG_SECTOR_REMAPPED) */
    ERROR_LOG_BLOCK_INCOMPLETE,                        /* c01a0004 (STATUS_LOG_BLOCK_INCOMPLETE) */
    ERROR_LOG_INVALID_RANGE,                           /* c01a0005 (STATUS_LOG_INVALID_RANGE) */
    ERROR_LOG_BLOCKS_EXHAUSTED,                        /* c01a0006 (STATUS_LOG_BLOCKS_EXHAUSTED) */
    ERROR_LOG_READ_CONTEXT_INVALID,                    /* c01a0007 (STATUS_LOG_READ_CONTEXT_INVALID) */
    ERROR_LOG_RESTART_INVALID,                         /* c01a0008 (STATUS_LOG_RESTART_INVALID) */
    ERROR_LOG_BLOCK_VERSION,                           /* c01a0009 (STATUS_LOG_BLOCK_VERSION) */
    ERROR_LOG_BLOCK_INVALID,                           /* c01a000a (STATUS_LOG_BLOCK_INVALID) */
    ERROR_LOG_READ_MODE_INVALID,                       /* c01a000b (STATUS_LOG_READ_MODE_INVALID) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01a000c */
    ERROR_LOG_METADATA_CORRUPT,                        /* c01a000d (STATUS_LOG_METADATA_CORRUPT) */
    ERROR_LOG_METADATA_INVALID,                        /* c01a000e (STATUS_LOG_METADATA_INVALID) */
    ERROR_LOG_METADATA_INCONSISTENT,                   /* c01a000f (STATUS_LOG_METADATA_INCONSISTENT) */
    ERROR_LOG_RESERVATION_INVALID,                     /* c01a0010 (STATUS_LOG_RESERVATION_INVALID) */
    ERROR_LOG_CANT_DELETE,                             /* c01a0011 (STATUS_LOG_CANT_DELETE) */
    ERROR_LOG_CONTAINER_LIMIT_EXCEEDED,                /* c01a0012 (STATUS_LOG_CONTAINER_LIMIT_EXCEEDED) */
    ERROR_LOG_START_OF_LOG,                            /* c01a0013 (STATUS_LOG_START_OF_LOG) */
    ERROR_LOG_POLICY_ALREADY_INSTALLED,                /* c01a0014 (STATUS_LOG_POLICY_ALREADY_INSTALLED) */
    ERROR_LOG_POLICY_NOT_INSTALLED,                    /* c01a0015 (STATUS_LOG_POLICY_NOT_INSTALLED) */
    ERROR_LOG_POLICY_INVALID,                          /* c01a0016 (STATUS_LOG_POLICY_INVALID) */
    ERROR_LOG_POLICY_CONFLICT,                         /* c01a0017 (STATUS_LOG_POLICY_CONFLICT) */
    ERROR_LOG_PINNED_ARCHIVE_TAIL,                     /* c01a0018 (STATUS_LOG_PINNED_ARCHIVE_TAIL) */
    ERROR_LOG_RECORD_NONEXISTENT,                      /* c01a0019 (STATUS_LOG_RECORD_NONEXISTENT) */
    ERROR_LOG_RECORDS_RESERVED_INVALID,                /* c01a001a (STATUS_LOG_RECORDS_RESERVED_INVALID) */
    ERROR_LOG_SPACE_RESERVED_INVALID,                  /* c01a001b (STATUS_LOG_SPACE_RESERVED_INVALID) */
    ERROR_LOG_TAIL_INVALID,                            /* c01a001c (STATUS_LOG_TAIL_INVALID) */
    ERROR_LOG_FULL,                                    /* c01a001d (STATUS_LOG_FULL) */
    ERROR_LOG_MULTIPLEXED,                             /* c01a001e (STATUS_LOG_MULTIPLEXED) */
    ERROR_LOG_DEDICATED,                               /* c01a001f (STATUS_LOG_DEDICATED) */
    ERROR_LOG_ARCHIVE_NOT_IN_PROGRESS,                 /* c01a0020 (STATUS_LOG_ARCHIVE_NOT_IN_PROGRESS) */
    ERROR_LOG_ARCHIVE_IN_PROGRESS,                     /* c01a0021 (STATUS_LOG_ARCHIVE_IN_PROGRESS) */
    ERROR_LOG_EPHEMERAL,                               /* c01a0022 (STATUS_LOG_EPHEMERAL) */
    ERROR_LOG_NOT_ENOUGH_CONTAINERS,                   /* c01a0023 (STATUS_LOG_NOT_ENOUGH_CONTAINERS) */
    ERROR_LOG_CLIENT_ALREADY_REGISTERED,               /* c01a0024 (STATUS_LOG_CLIENT_ALREADY_REGISTERED) */
    ERROR_LOG_CLIENT_NOT_REGISTERED,                   /* c01a0025 (STATUS_LOG_CLIENT_NOT_REGISTERED) */
    ERROR_LOG_FULL_HANDLER_IN_PROGRESS,                /* c01a0026 (STATUS_LOG_FULL_HANDLER_IN_PROGRESS) */
    ERROR_LOG_CONTAINER_READ_FAILED,                   /* c01a0027 (STATUS_LOG_CONTAINER_READ_FAILED) */
    ERROR_LOG_CONTAINER_WRITE_FAILED,                  /* c01a0028 (STATUS_LOG_CONTAINER_WRITE_FAILED) */
    ERROR_LOG_CONTAINER_OPEN_FAILED,                   /* c01a0029 (STATUS_LOG_CONTAINER_OPEN_FAILED) */
    ERROR_LOG_CONTAINER_STATE_INVALID,                 /* c01a002a (STATUS_LOG_CONTAINER_STATE_INVALID) */
    ERROR_LOG_STATE_INVALID,                           /* c01a002b (STATUS_LOG_STATE_INVALID) */
    ERROR_LOG_PINNED,                                  /* c01a002c (STATUS_LOG_PINNED) */
    ERROR_LOG_METADATA_FLUSH_FAILED,                   /* c01a002d (STATUS_LOG_METADATA_FLUSH_FAILED) */
    ERROR_LOG_INCONSISTENT_SECURITY,                   /* c01a002e (STATUS_LOG_INCONSISTENT_SECURITY) */
    ERROR_LOG_APPENDED_FLUSH_FAILED,                   /* c01a002f (STATUS_LOG_APPENDED_FLUSH_FAILED) */
    ERROR_LOG_PINNED_RESERVATION,                      /* c01a0030 (STATUS_LOG_PINNED_RESERVATION) */
    ERROR_HUNG_DISPLAY_DRIVER_THREAD,                  /* c01b00ea (STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD) */
    ERROR_FLT_NO_HANDLER_DEFINED,                      /* c01c0001 (STATUS_FLT_NO_HANDLER_DEFINED) */
    ERROR_FLT_CONTEXT_ALREADY_DEFINED,                 /* c01c0002 (STATUS_FLT_CONTEXT_ALREADY_DEFINED) */
    ERROR_FLT_INVALID_ASYNCHRONOUS_REQUEST,            /* c01c0003 (STATUS_FLT_INVALID_ASYNCHRONOUS_REQUEST) */
    ERROR_FLT_DISALLOW_FAST_IO,                        /* c01c0004 (STATUS_FLT_DISALLOW_FAST_IO) */
    ERROR_FLT_INVALID_NAME_REQUEST,                    /* c01c0005 (STATUS_FLT_INVALID_NAME_REQUEST) */
    ERROR_FLT_NOT_SAFE_TO_POST_OPERATION,              /* c01c0006 (STATUS_FLT_NOT_SAFE_TO_POST_OPERATION) */
    ERROR_FLT_NOT_INITIALIZED,                         /* c01c0007 (STATUS_FLT_NOT_INITIALIZED) */
    ERROR_FLT_FILTER_NOT_READY,                        /* c01c0008 (STATUS_FLT_FILTER_NOT_READY) */
    ERROR_FLT_POST_OPERATION_CLEANUP,                  /* c01c0009 (STATUS_FLT_POST_OPERATION_CLEANUP) */
    ERROR_FLT_INTERNAL_ERROR,                          /* c01c000a (STATUS_FLT_INTERNAL_ERROR) */
    ERROR_FLT_DELETING_OBJECT,                         /* c01c000b (STATUS_FLT_DELETING_OBJECT) */
    ERROR_FLT_MUST_BE_NONPAGED_POOL,                   /* c01c000c (STATUS_FLT_MUST_BE_NONPAGED_POOL) */
    ERROR_FLT_DUPLICATE_ENTRY,                         /* c01c000d (STATUS_FLT_DUPLICATE_ENTRY) */
    ERROR_FLT_CBDQ_DISABLED,                           /* c01c000e (STATUS_FLT_CBDQ_DISABLED) */
    ERROR_FLT_DO_NOT_ATTACH,                           /* c01c000f (STATUS_FLT_DO_NOT_ATTACH) */
    ERROR_FLT_DO_NOT_DETACH,                           /* c01c0010 (STATUS_FLT_DO_NOT_DETACH) */
    ERROR_FLT_INSTANCE_ALTITUDE_COLLISION,             /* c01c0011 (STATUS_FLT_INSTANCE_ALTITUDE_COLLISION) */
    ERROR_FLT_INSTANCE_NAME_COLLISION,                 /* c01c0012 (STATUS_FLT_INSTANCE_NAME_COLLISION) */
    ERROR_FLT_FILTER_NOT_FOUND,                        /* c01c0013 (STATUS_FLT_FILTER_NOT_FOUND) */
    ERROR_FLT_VOLUME_NOT_FOUND,                        /* c01c0014 (STATUS_FLT_VOLUME_NOT_FOUND) */
    ERROR_FLT_INSTANCE_NOT_FOUND,                      /* c01c0015 (STATUS_FLT_INSTANCE_NOT_FOUND) */
    ERROR_FLT_CONTEXT_ALLOCATION_NOT_FOUND,            /* c01c0016 (STATUS_FLT_CONTEXT_ALLOCATION_NOT_FOUND) */
    ERROR_FLT_INVALID_CONTEXT_REGISTRATION,            /* c01c0017 (STATUS_FLT_INVALID_CONTEXT_REGISTRATION) */
    ERROR_FLT_NAME_CACHE_MISS,                         /* c01c0018 (STATUS_FLT_NAME_CACHE_MISS) */
    ERROR_FLT_NO_DEVICE_OBJECT,                        /* c01c0019 (STATUS_FLT_NO_DEVICE_OBJECT) */
    ERROR_FLT_VOLUME_ALREADY_MOUNTED,                  /* c01c001a (STATUS_FLT_VOLUME_ALREADY_MOUNTED) */
    ERROR_FLT_ALREADY_ENLISTED,                        /* c01c001b (STATUS_FLT_ALREADY_ENLISTED) */
    ERROR_FLT_CONTEXT_ALREADY_LINKED,                  /* c01c001c (STATUS_FLT_CONTEXT_ALREADY_LINKED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01c001d */
    ERROR_MR_MID_NOT_FOUND,                            /* c01c001e */
    ERROR_MR_MID_NOT_FOUND,                            /* c01c001f */
    ERROR_FLT_NO_WAITER_FOR_REPLY,                     /* c01c0020 (STATUS_FLT_NO_WAITER_FOR_REPLY) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01c0021 */
    ERROR_MR_MID_NOT_FOUND,                            /* c01c0022 */
    ERROR_FLT_REGISTRATION_BUSY,                       /* c01c0023 (STATUS_FLT_REGISTRATION_BUSY) */
    ERROR_FLT_WCOS_NOT_SUPPORTED,                      /* c01c0024 (STATUS_FLT_WCOS_NOT_SUPPORTED) */
    ERROR_MONITOR_NO_DESCRIPTOR,                       /* c01d0001 (STATUS_MONITOR_NO_DESCRIPTOR) */
    ERROR_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT,           /* c01d0002 (STATUS_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT) */
    ERROR_MONITOR_INVALID_DESCRIPTOR_CHECKSUM,         /* c01d0003 (STATUS_MONITOR_INVALID_DESCRIPTOR_CHECKSUM) */
    ERROR_MONITOR_INVALID_STANDARD_TIMING_BLOCK,       /* c01d0004 (STATUS_MONITOR_INVALID_STANDARD_TIMING_BLOCK) */
    ERROR_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED,   /* c01d0005 (STATUS_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED) */
    ERROR_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK,  /* c01d0006 (STATUS_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK) */
    ERROR_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK,  /* c01d0007 (STATUS_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK) */
    ERROR_MONITOR_NO_MORE_DESCRIPTOR_DATA,             /* c01d0008 (STATUS_MONITOR_NO_MORE_DESCRIPTOR_DATA) */
    ERROR_MONITOR_INVALID_DETAILED_TIMING_BLOCK,       /* c01d0009 (STATUS_MONITOR_INVALID_DETAILED_TIMING_BLOCK) */
    ERROR_MONITOR_INVALID_MANUFACTURE_DATE,            /* c01d000a (STATUS_MONITOR_INVALID_MANUFACTURE_DATE) */
    ERROR_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER,           /* c01e0000 (STATUS_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER) */
    ERROR_GRAPHICS_INSUFFICIENT_DMA_BUFFER,            /* c01e0001 (STATUS_GRAPHICS_INSUFFICIENT_DMA_BUFFER) */
    ERROR_GRAPHICS_INVALID_DISPLAY_ADAPTER,            /* c01e0002 (STATUS_GRAPHICS_INVALID_DISPLAY_ADAPTER) */
    ERROR_GRAPHICS_ADAPTER_WAS_RESET,                  /* c01e0003 (STATUS_GRAPHICS_ADAPTER_WAS_RESET) */
    ERROR_GRAPHICS_INVALID_DRIVER_MODEL,               /* c01e0004 (STATUS_GRAPHICS_INVALID_DRIVER_MODEL) */
    ERROR_GRAPHICS_PRESENT_MODE_CHANGED,               /* c01e0005 (STATUS_GRAPHICS_PRESENT_MODE_CHANGED) */
    ERROR_GRAPHICS_PRESENT_OCCLUDED,                   /* c01e0006 (STATUS_GRAPHICS_PRESENT_OCCLUDED) */
    ERROR_GRAPHICS_PRESENT_DENIED,                     /* c01e0007 (STATUS_GRAPHICS_PRESENT_DENIED) */
    ERROR_GRAPHICS_CANNOTCOLORCONVERT,                 /* c01e0008 (STATUS_GRAPHICS_CANNOTCOLORCONVERT) */
    ERROR_GRAPHICS_DRIVER_MISMATCH,                    /* c01e0009 (STATUS_GRAPHICS_DRIVER_MISMATCH) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e000a */
    ERROR_GRAPHICS_PRESENT_REDIRECTION_DISABLED,       /* c01e000b (STATUS_GRAPHICS_PRESENT_REDIRECTION_DISABLED) */
    ERROR_GRAPHICS_PRESENT_UNOCCLUDED,                 /* c01e000c (STATUS_GRAPHICS_PRESENT_UNOCCLUDED) */
    ERROR_GRAPHICS_WINDOWDC_NOT_AVAILABLE,             /* c01e000d (STATUS_GRAPHICS_WINDOWDC_NOT_AVAILABLE) */
    ERROR_GRAPHICS_WINDOWLESS_PRESENT_DISABLED,        /* c01e000e (STATUS_GRAPHICS_WINDOWLESS_PRESENT_DISABLED) */
    ERROR_GRAPHICS_PRESENT_INVALID_WINDOW,             /* c01e000f (STATUS_GRAPHICS_PRESENT_INVALID_WINDOW) */
    ERROR_GRAPHICS_PRESENT_BUFFER_NOT_BOUND,           /* c01e0010 (STATUS_GRAPHICS_PRESENT_BUFFER_NOT_BOUND) */
    ERROR_GRAPHICS_VAIL_STATE_CHANGED,                 /* c01e0011 (STATUS_GRAPHICS_VAIL_STATE_CHANGED) */
    ERROR_GRAPHICS_INDIRECT_DISPLAY_ABANDON_SWAPCHAIN, /* c01e0012 (STATUS_GRAPHICS_INDIRECT_DISPLAY_ABANDON_SWAPCHAIN) */
    ERROR_GRAPHICS_INDIRECT_DISPLAY_DEVICE_STOPPED,    /* c01e0013 (STATUS_GRAPHICS_INDIRECT_DISPLAY_DEVICE_STOPPED) */
    ERROR_GRAPHICS_NO_VIDEO_MEMORY,                    /* c01e0100 (STATUS_GRAPHICS_NO_VIDEO_MEMORY) */
    ERROR_GRAPHICS_CANT_LOCK_MEMORY,                   /* c01e0101 (STATUS_GRAPHICS_CANT_LOCK_MEMORY) */
    ERROR_GRAPHICS_ALLOCATION_BUSY,                    /* c01e0102 (STATUS_GRAPHICS_ALLOCATION_BUSY) */
    ERROR_GRAPHICS_TOO_MANY_REFERENCES,                /* c01e0103 (STATUS_GRAPHICS_TOO_MANY_REFERENCES) */
    ERROR_GRAPHICS_TRY_AGAIN_LATER,                    /* c01e0104 (STATUS_GRAPHICS_TRY_AGAIN_LATER) */
    ERROR_GRAPHICS_TRY_AGAIN_NOW,                      /* c01e0105 (STATUS_GRAPHICS_TRY_AGAIN_NOW) */
    ERROR_GRAPHICS_ALLOCATION_INVALID,                 /* c01e0106 (STATUS_GRAPHICS_ALLOCATION_INVALID) */
    ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE,   /* c01e0107 (STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE) */
    ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED,   /* c01e0108 (STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED) */
    ERROR_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION,       /* c01e0109 (STATUS_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e010a */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e010b */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e010c */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e010d */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e010e */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e010f */
    ERROR_GRAPHICS_INVALID_ALLOCATION_USAGE,           /* c01e0110 (STATUS_GRAPHICS_INVALID_ALLOCATION_USAGE) */
    ERROR_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION,      /* c01e0111 (STATUS_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION) */
    ERROR_GRAPHICS_ALLOCATION_CLOSED,                  /* c01e0112 (STATUS_GRAPHICS_ALLOCATION_CLOSED) */
    ERROR_GRAPHICS_INVALID_ALLOCATION_INSTANCE,        /* c01e0113 (STATUS_GRAPHICS_INVALID_ALLOCATION_INSTANCE) */
    ERROR_GRAPHICS_INVALID_ALLOCATION_HANDLE,          /* c01e0114 (STATUS_GRAPHICS_INVALID_ALLOCATION_HANDLE) */
    ERROR_GRAPHICS_WRONG_ALLOCATION_DEVICE,            /* c01e0115 (STATUS_GRAPHICS_WRONG_ALLOCATION_DEVICE) */
    ERROR_GRAPHICS_ALLOCATION_CONTENT_LOST,            /* c01e0116 (STATUS_GRAPHICS_ALLOCATION_CONTENT_LOST) */
    ERROR_GRAPHICS_GPU_EXCEPTION_ON_DEVICE,            /* c01e0200 (STATUS_GRAPHICS_GPU_EXCEPTION_ON_DEVICE) */
    ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY,             /* c01e0300 (STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY) */
    ERROR_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED,       /* c01e0301 (STATUS_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED) */
    ERROR_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED, /* c01e0302 (STATUS_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED) */
    ERROR_GRAPHICS_INVALID_VIDPN,                      /* c01e0303 (STATUS_GRAPHICS_INVALID_VIDPN) */
    ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE,       /* c01e0304 (STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE) */
    ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET,       /* c01e0305 (STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET) */
    ERROR_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED,       /* c01e0306 (STATUS_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e0307 */
    ERROR_GRAPHICS_INVALID_VIDPN_SOURCEMODESET,        /* c01e0308 (STATUS_GRAPHICS_INVALID_VIDPN_SOURCEMODESET) */
    ERROR_GRAPHICS_INVALID_VIDPN_TARGETMODESET,        /* c01e0309 (STATUS_GRAPHICS_INVALID_VIDPN_TARGETMODESET) */
    ERROR_GRAPHICS_INVALID_FREQUENCY,                  /* c01e030a (STATUS_GRAPHICS_INVALID_FREQUENCY) */
    ERROR_GRAPHICS_INVALID_ACTIVE_REGION,              /* c01e030b (STATUS_GRAPHICS_INVALID_ACTIVE_REGION) */
    ERROR_GRAPHICS_INVALID_TOTAL_REGION,               /* c01e030c (STATUS_GRAPHICS_INVALID_TOTAL_REGION) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e030d */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e030e */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e030f */
    ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE,  /* c01e0310 (STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE) */
    ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE,  /* c01e0311 (STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE) */
    ERROR_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET,     /* c01e0312 (STATUS_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET) */
    ERROR_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY,           /* c01e0313 (STATUS_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY) */
    ERROR_GRAPHICS_MODE_ALREADY_IN_MODESET,            /* c01e0314 (STATUS_GRAPHICS_MODE_ALREADY_IN_MODESET) */
    ERROR_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET,      /* c01e0315 (STATUS_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET) */
    ERROR_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET,      /* c01e0316 (STATUS_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET) */
    ERROR_GRAPHICS_SOURCE_ALREADY_IN_SET,              /* c01e0317 (STATUS_GRAPHICS_SOURCE_ALREADY_IN_SET) */
    ERROR_GRAPHICS_TARGET_ALREADY_IN_SET,              /* c01e0318 (STATUS_GRAPHICS_TARGET_ALREADY_IN_SET) */
    ERROR_GRAPHICS_INVALID_VIDPN_PRESENT_PATH,         /* c01e0319 (STATUS_GRAPHICS_INVALID_VIDPN_PRESENT_PATH) */
    ERROR_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY,      /* c01e031a (STATUS_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY) */
    ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET,  /* c01e031b (STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET) */
    ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE,     /* c01e031c (STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE) */
    ERROR_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET,          /* c01e031d (STATUS_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e031e */
    ERROR_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET,      /* c01e031f (STATUS_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET) */
    ERROR_GRAPHICS_STALE_MODESET,                      /* c01e0320 (STATUS_GRAPHICS_STALE_MODESET) */
    ERROR_GRAPHICS_INVALID_MONITOR_SOURCEMODESET,      /* c01e0321 (STATUS_GRAPHICS_INVALID_MONITOR_SOURCEMODESET) */
    ERROR_GRAPHICS_INVALID_MONITOR_SOURCE_MODE,        /* c01e0322 (STATUS_GRAPHICS_INVALID_MONITOR_SOURCE_MODE) */
    ERROR_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN,    /* c01e0323 (STATUS_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN) */
    ERROR_GRAPHICS_MODE_ID_MUST_BE_UNIQUE,             /* c01e0324 (STATUS_GRAPHICS_MODE_ID_MUST_BE_UNIQUE) */
    ERROR_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION, /* c01e0325 (STATUS_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION) */
    ERROR_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES, /* c01e0326 (STATUS_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES) */
    ERROR_GRAPHICS_PATH_NOT_IN_TOPOLOGY,               /* c01e0327 (STATUS_GRAPHICS_PATH_NOT_IN_TOPOLOGY) */
    ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE, /* c01e0328 (STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE) */
    ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET, /* c01e0329 (STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET) */
    ERROR_GRAPHICS_INVALID_MONITORDESCRIPTORSET,       /* c01e032a (STATUS_GRAPHICS_INVALID_MONITORDESCRIPTORSET) */
    ERROR_GRAPHICS_INVALID_MONITORDESCRIPTOR,          /* c01e032b (STATUS_GRAPHICS_INVALID_MONITORDESCRIPTOR) */
    ERROR_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET,       /* c01e032c (STATUS_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET) */
    ERROR_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET,   /* c01e032d (STATUS_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET) */
    ERROR_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE, /* c01e032e (STATUS_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE) */
    ERROR_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE,   /* c01e032f (STATUS_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE) */
    ERROR_GRAPHICS_RESOURCES_NOT_RELATED,              /* c01e0330 (STATUS_GRAPHICS_RESOURCES_NOT_RELATED) */
    ERROR_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE,           /* c01e0331 (STATUS_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE) */
    ERROR_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE,           /* c01e0332 (STATUS_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE) */
    ERROR_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET,          /* c01e0333 (STATUS_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET) */
    ERROR_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER, /* c01e0334 (STATUS_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER) */
    ERROR_GRAPHICS_NO_VIDPNMGR,                        /* c01e0335 (STATUS_GRAPHICS_NO_VIDPNMGR) */
    ERROR_GRAPHICS_NO_ACTIVE_VIDPN,                    /* c01e0336 (STATUS_GRAPHICS_NO_ACTIVE_VIDPN) */
    ERROR_GRAPHICS_STALE_VIDPN_TOPOLOGY,               /* c01e0337 (STATUS_GRAPHICS_STALE_VIDPN_TOPOLOGY) */
    ERROR_GRAPHICS_MONITOR_NOT_CONNECTED,              /* c01e0338 (STATUS_GRAPHICS_MONITOR_NOT_CONNECTED) */
    ERROR_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY,             /* c01e0339 (STATUS_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY) */
    ERROR_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE,        /* c01e033a (STATUS_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE) */
    ERROR_GRAPHICS_INVALID_VISIBLEREGION_SIZE,         /* c01e033b (STATUS_GRAPHICS_INVALID_VISIBLEREGION_SIZE) */
    ERROR_GRAPHICS_INVALID_STRIDE,                     /* c01e033c (STATUS_GRAPHICS_INVALID_STRIDE) */
    ERROR_GRAPHICS_INVALID_PIXELFORMAT,                /* c01e033d (STATUS_GRAPHICS_INVALID_PIXELFORMAT) */
    ERROR_GRAPHICS_INVALID_COLORBASIS,                 /* c01e033e (STATUS_GRAPHICS_INVALID_COLORBASIS) */
    ERROR_GRAPHICS_INVALID_PIXELVALUEACCESSMODE,       /* c01e033f (STATUS_GRAPHICS_INVALID_PIXELVALUEACCESSMODE) */
    ERROR_GRAPHICS_TARGET_NOT_IN_TOPOLOGY,             /* c01e0340 (STATUS_GRAPHICS_TARGET_NOT_IN_TOPOLOGY) */
    ERROR_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT, /* c01e0341 (STATUS_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT) */
    ERROR_GRAPHICS_VIDPN_SOURCE_IN_USE,                /* c01e0342 (STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE) */
    ERROR_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN,           /* c01e0343 (STATUS_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN) */
    ERROR_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL,    /* c01e0344 (STATUS_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL) */
    ERROR_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION, /* c01e0345 (STATUS_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION) */
    ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED, /* c01e0346 (STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED) */
    ERROR_GRAPHICS_INVALID_GAMMA_RAMP,                 /* c01e0347 (STATUS_GRAPHICS_INVALID_GAMMA_RAMP) */
    ERROR_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED,           /* c01e0348 (STATUS_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED) */
    ERROR_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED,        /* c01e0349 (STATUS_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED) */
    ERROR_GRAPHICS_MODE_NOT_IN_MODESET,                /* c01e034a (STATUS_GRAPHICS_MODE_NOT_IN_MODESET) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e034b */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e034c */
    ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON, /* c01e034d (STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON) */
    ERROR_GRAPHICS_INVALID_PATH_CONTENT_TYPE,          /* c01e034e (STATUS_GRAPHICS_INVALID_PATH_CONTENT_TYPE) */
    ERROR_GRAPHICS_INVALID_COPYPROTECTION_TYPE,        /* c01e034f (STATUS_GRAPHICS_INVALID_COPYPROTECTION_TYPE) */
    ERROR_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS,  /* c01e0350 (STATUS_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e0351 */
    ERROR_GRAPHICS_INVALID_SCANLINE_ORDERING,          /* c01e0352 (STATUS_GRAPHICS_INVALID_SCANLINE_ORDERING) */
    ERROR_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED,       /* c01e0353 (STATUS_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED) */
    ERROR_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS,   /* c01e0354 (STATUS_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS) */
    ERROR_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT,        /* c01e0355 (STATUS_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT) */
    ERROR_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM,     /* c01e0356 (STATUS_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM) */
    ERROR_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN,  /* c01e0357 (STATUS_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN) */
    ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT, /* c01e0358 (STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT) */
    ERROR_GRAPHICS_MAX_NUM_PATHS_REACHED,              /* c01e0359 (STATUS_GRAPHICS_MAX_NUM_PATHS_REACHED) */
    ERROR_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION, /* c01e035a (STATUS_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION) */
    ERROR_GRAPHICS_INVALID_CLIENT_TYPE,                /* c01e035b (STATUS_GRAPHICS_INVALID_CLIENT_TYPE) */
    ERROR_GRAPHICS_CLIENTVIDPN_NOT_SET,                /* c01e035c (STATUS_GRAPHICS_CLIENTVIDPN_NOT_SET) */
    ERROR_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED,  /* c01e0400 (STATUS_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED) */
    ERROR_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED,     /* c01e0401 (STATUS_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED) */
    ERROR_GRAPHICS_NOT_A_LINKED_ADAPTER,               /* c01e0430 (STATUS_GRAPHICS_NOT_A_LINKED_ADAPTER) */
    ERROR_GRAPHICS_LEADLINK_NOT_ENUMERATED,            /* c01e0431 (STATUS_GRAPHICS_LEADLINK_NOT_ENUMERATED) */
    ERROR_GRAPHICS_CHAINLINKS_NOT_ENUMERATED,          /* c01e0432 (STATUS_GRAPHICS_CHAINLINKS_NOT_ENUMERATED) */
    ERROR_GRAPHICS_ADAPTER_CHAIN_NOT_READY,            /* c01e0433 (STATUS_GRAPHICS_ADAPTER_CHAIN_NOT_READY) */
    ERROR_GRAPHICS_CHAINLINKS_NOT_STARTED,             /* c01e0434 (STATUS_GRAPHICS_CHAINLINKS_NOT_STARTED) */
    ERROR_GRAPHICS_CHAINLINKS_NOT_POWERED_ON,          /* c01e0435 (STATUS_GRAPHICS_CHAINLINKS_NOT_POWERED_ON) */
    ERROR_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE,     /* c01e0436 (STATUS_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e0437 */
    ERROR_GRAPHICS_NOT_POST_DEVICE_DRIVER,             /* c01e0438 (STATUS_GRAPHICS_NOT_POST_DEVICE_DRIVER) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e0439 */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e043a */
    ERROR_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED,        /* c01e043b (STATUS_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED) */
    ERROR_GRAPHICS_OPM_NOT_SUPPORTED,                  /* c01e0500 (STATUS_GRAPHICS_OPM_NOT_SUPPORTED) */
    ERROR_GRAPHICS_COPP_NOT_SUPPORTED,                 /* c01e0501 (STATUS_GRAPHICS_COPP_NOT_SUPPORTED) */
    ERROR_GRAPHICS_UAB_NOT_SUPPORTED,                  /* c01e0502 (STATUS_GRAPHICS_UAB_NOT_SUPPORTED) */
    ERROR_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS,   /* c01e0503 (STATUS_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e0504 */
    ERROR_GRAPHICS_OPM_NO_VIDEO_OUTPUTS_EXIST,         /* c01e0505 (STATUS_GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e0506 */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e0507 */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e0508 */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e0509 */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e050a */
    ERROR_GRAPHICS_OPM_INTERNAL_ERROR,                 /* c01e050b (STATUS_GRAPHICS_OPM_INTERNAL_ERROR) */
    ERROR_GRAPHICS_OPM_INVALID_HANDLE,                 /* c01e050c (STATUS_GRAPHICS_OPM_INVALID_HANDLE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e050d */
    ERROR_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH,     /* c01e050e (STATUS_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH) */
    ERROR_GRAPHICS_OPM_SPANNING_MODE_ENABLED,          /* c01e050f (STATUS_GRAPHICS_OPM_SPANNING_MODE_ENABLED) */
    ERROR_GRAPHICS_OPM_THEATER_MODE_ENABLED,           /* c01e0510 (STATUS_GRAPHICS_OPM_THEATER_MODE_ENABLED) */
    ERROR_GRAPHICS_PVP_HFS_FAILED,                     /* c01e0511 (STATUS_GRAPHICS_PVP_HFS_FAILED) */
    ERROR_GRAPHICS_OPM_INVALID_SRM,                    /* c01e0512 (STATUS_GRAPHICS_OPM_INVALID_SRM) */
    ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP,   /* c01e0513 (STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP) */
    ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP,    /* c01e0514 (STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP) */
    ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA,  /* c01e0515 (STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA) */
    ERROR_GRAPHICS_OPM_HDCP_SRM_NEVER_SET,             /* c01e0516 (STATUS_GRAPHICS_OPM_HDCP_SRM_NEVER_SET) */
    ERROR_GRAPHICS_OPM_RESOLUTION_TOO_HIGH,            /* c01e0517 (STATUS_GRAPHICS_OPM_RESOLUTION_TOO_HIGH) */
    ERROR_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE, /* c01e0518 (STATUS_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e0519 */
    ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_NO_LONGER_EXISTS,  /* c01e051a (STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS) */
    ERROR_MR_MID_NOT_FOUND,                            /* c01e051b */
    ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS, /* c01e051c (STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS) */
    ERROR_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST,    /* c01e051d (STATUS_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST) */
    ERROR_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR,          /* c01e051e (STATUS_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR) */
    ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS, /* c01e051f (STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS) */
    ERROR_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED,        /* c01e0520 (STATUS_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED) */
    ERROR_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST,  /* c01e0521 (STATUS_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST) */
    ERROR_GRAPHICS_I2C_NOT_SUPPORTED,                  /* c01e0580 (STATUS_GRAPHICS_I2C_NOT_SUPPORTED) */
    ERROR_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST,          /* c01e0581 (STATUS_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST) */
    ERROR_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA,        /* c01e0582 (STATUS_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA) */
    ERROR_GRAPHICS_I2C_ERROR_RECEIVING_DATA,           /* c01e0583 (STATUS_GRAPHICS_I2C_ERROR_RECEIVING_DATA) */
    ERROR_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED,            /* c01e0584 (STATUS_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED) */
    ERROR_GRAPHICS_DDCCI_INVALID_DATA,                 /* c01e0585 (STATUS_GRAPHICS_DDCCI_INVALID_DATA) */
    ERROR_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE, /* c01e0586 (STATUS_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE) */
    ERROR_GRAPHICS_MCA_INVALID_CAPABILITIES_STRING,    /* c01e0587 (STATUS_GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING) */
    ERROR_GRAPHICS_MCA_INTERNAL_ERROR,                 /* c01e0588 (STATUS_GRAPHICS_MCA_INTERNAL_ERROR) */
    ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND,      /* c01e0589 (STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND) */
    ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH,       /* c01e058a (STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH) */
    ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM,     /* c01e058b (STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM) */
    ERROR_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE,    /* c01e058c (STATUS_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE) */
    ERROR_GRAPHICS_MONITOR_NO_LONGER_EXISTS,           /* c01e058d (STATUS_GRAPHICS_MONITOR_NO_LONGER_EXISTS) */
    ERROR_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED,     /* c01e05e0 (STATUS_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED) */
    ERROR_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME, /* c01e05e1 (STATUS_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME) */
    ERROR_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP, /* c01e05e2 (STATUS_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP) */
    ERROR_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED,    /* c01e05e3 (STATUS_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED) */
    ERROR_GRAPHICS_INVALID_POINTER,                    /* c01e05e4 (STATUS_GRAPHICS_INVALID_POINTER) */
    ERROR_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE, /* c01e05e5 (STATUS_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE) */
    ERROR_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL,          /* c01e05e6 (STATUS_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL) */
    ERROR_GRAPHICS_INTERNAL_ERROR,                     /* c01e05e7 (STATUS_GRAPHICS_INTERNAL_ERROR) */
    ERROR_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS,    /* c01e05e8 (STATUS_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS) */
    FVE_E_LOCKED_VOLUME,                               /* c0210000 (STATUS_FVE_LOCKED_VOLUME) */
    FVE_E_NOT_ENCRYPTED,                               /* c0210001 (STATUS_FVE_NOT_ENCRYPTED) */
    FVE_E_BAD_INFORMATION,                             /* c0210002 (STATUS_FVE_BAD_INFORMATION) */
    FVE_E_TOO_SMALL,                                   /* c0210003 (STATUS_FVE_TOO_SMALL) */
    FVE_E_FAILED_WRONG_FS,                             /* c0210004 (STATUS_FVE_FAILED_WRONG_FS) */
    FVE_E_BAD_PARTITION_SIZE,                          /* c0210005 (STATUS_FVE_BAD_PARTITION_SIZE) */
    FVE_E_FS_NOT_EXTENDED,                             /* c0210006 (STATUS_FVE_FS_NOT_EXTENDED) */
    FVE_E_FS_MOUNTED,                                  /* c0210007 (STATUS_FVE_FS_MOUNTED) */
    FVE_E_NO_LICENSE,                                  /* c0210008 (STATUS_FVE_NO_LICENSE) */
    FVE_E_ACTION_NOT_ALLOWED,                          /* c0210009 (STATUS_FVE_ACTION_NOT_ALLOWED) */
    FVE_E_BAD_DATA,                                    /* c021000a (STATUS_FVE_BAD_DATA) */
    FVE_E_VOLUME_NOT_BOUND,                            /* c021000b (STATUS_FVE_VOLUME_NOT_BOUND) */
    FVE_E_NOT_DATA_VOLUME,                             /* c021000c (STATUS_FVE_NOT_DATA_VOLUME) */
    FVE_E_CONV_READ,                                   /* c021000d (STATUS_FVE_CONV_READ_ERROR) */
    FVE_E_CONV_WRITE,                                  /* c021000e (STATUS_FVE_CONV_WRITE_ERROR) */
    FVE_E_OVERLAPPED_UPDATE,                           /* c021000f (STATUS_FVE_OVERLAPPED_UPDATE) */
    FVE_E_FAILED_SECTOR_SIZE,                          /* c0210010 (STATUS_FVE_FAILED_SECTOR_SIZE) */
    FVE_E_FAILED_AUTHENTICATION,                       /* c0210011 (STATUS_FVE_FAILED_AUTHENTICATION) */
    FVE_E_NOT_OS_VOLUME,                               /* c0210012 (STATUS_FVE_NOT_OS_VOLUME) */
    FVE_E_KEYFILE_NOT_FOUND,                           /* c0210013 (STATUS_FVE_KEYFILE_NOT_FOUND) */
    FVE_E_KEYFILE_INVALID,                             /* c0210014 (STATUS_FVE_KEYFILE_INVALID) */
    FVE_E_KEYFILE_NO_VMK,                              /* c0210015 (STATUS_FVE_KEYFILE_NO_VMK) */
    FVE_E_TPM_DISABLED,                                /* c0210016 (STATUS_FVE_TPM_DISABLED) */
    FVE_E_TPM_SRK_AUTH_NOT_ZERO,                       /* c0210017 (STATUS_FVE_TPM_SRK_AUTH_NOT_ZERO) */
    FVE_E_TPM_INVALID_PCR,                             /* c0210018 (STATUS_FVE_TPM_INVALID_PCR) */
    FVE_E_TPM_NO_VMK,                                  /* c0210019 (STATUS_FVE_TPM_NO_VMK) */
    FVE_E_PIN_INVALID,                                 /* c021001a (STATUS_FVE_PIN_INVALID) */
    FVE_E_AUTH_INVALID_APPLICATION,                    /* c021001b (STATUS_FVE_AUTH_INVALID_APPLICATION) */
    FVE_E_AUTH_INVALID_CONFIG,                         /* c021001c (STATUS_FVE_AUTH_INVALID_CONFIG) */
    FVE_E_DEBUGGER_ENABLED,                            /* c021001d (STATUS_FVE_DEBUGGER_ENABLED) */
    FVE_E_DRY_RUN_FAILED,                              /* c021001e (STATUS_FVE_DRY_RUN_FAILED) */
    FVE_E_BAD_INFORMATION,                             /* c021001f (STATUS_FVE_BAD_METADATA_POINTER) */
    FVE_E_BAD_INFORMATION,                             /* c0210020 (STATUS_FVE_OLD_METADATA_COPY) */
    FVE_E_REBOOT_REQUIRED,                             /* c0210021 (STATUS_FVE_REBOOT_REQUIRED) */
    FVE_E_RAW_ACCESS,                                  /* c0210022 (STATUS_FVE_RAW_ACCESS) */
    FVE_E_RAW_BLOCKED,                                 /* c0210023 (STATUS_FVE_RAW_BLOCKED) */
    FVE_E_NO_AUTOUNLOCK_MASTER_KEY,                    /* c0210024 (STATUS_FVE_NO_AUTOUNLOCK_MASTER_KEY) */
    FVE_E_MOR_FAILED,                                  /* c0210025 (STATUS_FVE_MOR_FAILED) */
    FVE_E_NO_FEATURE_LICENSE,                          /* c0210026 (STATUS_FVE_NO_FEATURE_LICENSE) */
    FVE_E_POLICY_USER_DISABLE_RDV_NOT_ALLOWED,         /* c0210027 (STATUS_FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED) */
    FVE_E_CONV_RECOVERY_FAILED,                        /* c0210028 (STATUS_FVE_CONV_RECOVERY_FAILED) */
    FVE_E_VIRTUALIZED_SPACE_TOO_BIG,                   /* c0210029 (STATUS_FVE_VIRTUALIZED_SPACE_TOO_BIG) */
    FVE_E_INVALID_DATUM_TYPE,                          /* c021002a (STATUS_FVE_INVALID_DATUM_TYPE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c021002b */
    ERROR_MR_MID_NOT_FOUND,                            /* c021002c */
    ERROR_MR_MID_NOT_FOUND,                            /* c021002d */
    ERROR_MR_MID_NOT_FOUND,                            /* c021002e */
    ERROR_MR_MID_NOT_FOUND,                            /* c021002f */
    FVE_E_VOLUME_TOO_SMALL,                            /* c0210030 (STATUS_FVE_VOLUME_TOO_SMALL) */
    FVE_E_ENH_PIN_INVALID,                             /* c0210031 (STATUS_FVE_ENH_PIN_INVALID) */
    FVE_E_FULL_ENCRYPTION_NOT_ALLOWED_ON_TP_STORAGE,   /* c0210032 (STATUS_FVE_FULL_ENCRYPTION_NOT_ALLOWED_ON_TP_STORAGE) */
    FVE_E_WIPE_NOT_ALLOWED_ON_TP_STORAGE,              /* c0210033 (STATUS_FVE_WIPE_NOT_ALLOWED_ON_TP_STORAGE) */
    FVE_E_NOT_ALLOWED_ON_CSV_STACK,                    /* c0210034 (STATUS_FVE_NOT_ALLOWED_ON_CSV_STACK) */
    FVE_E_NOT_ALLOWED_ON_CLUSTER,                      /* c0210035 (STATUS_FVE_NOT_ALLOWED_ON_CLUSTER) */
    FVE_E_NOT_ALLOWED_TO_UPGRADE_WHILE_CONVERTING,     /* c0210036 (STATUS_FVE_NOT_ALLOWED_TO_UPGRADE_WHILE_CONVERTING) */
    FVE_E_WIPE_CANCEL_NOT_APPLICABLE,                  /* c0210037 (STATUS_FVE_WIPE_CANCEL_NOT_APPLICABLE) */
    FVE_E_EDRIVE_DRY_RUN_FAILED,                       /* c0210038 (STATUS_FVE_EDRIVE_DRY_RUN_FAILED) */
    FVE_E_SECUREBOOT_DISABLED,                         /* c0210039 (STATUS_FVE_SECUREBOOT_DISABLED) */
    FVE_E_SECUREBOOT_CONFIGURATION_INVALID,            /* c021003a (STATUS_FVE_SECUREBOOT_CONFIG_CHANGE) */
    FVE_E_DE_DEVICE_LOCKEDOUT,                         /* c021003b (STATUS_FVE_DEVICE_LOCKEDOUT) */
    FVE_E_VOLUME_EXTEND_PREVENTS_EOW_DECRYPT,          /* c021003c (STATUS_FVE_VOLUME_EXTEND_PREVENTS_EOW_DECRYPT) */
    FVE_E_NOT_DE_VOLUME,                               /* c021003d (STATUS_FVE_NOT_DE_VOLUME) */
    FVE_E_PROTECTION_DISABLED,                         /* c021003e (STATUS_FVE_PROTECTION_DISABLED) */
    FVE_E_PROTECTION_CANNOT_BE_DISABLED,               /* c021003f (STATUS_FVE_PROTECTION_CANNOT_BE_DISABLED) */
    FVE_E_OSV_KSR_NOT_ALLOWED,                         /* c0210040 (STATUS_FVE_OSV_KSR_NOT_ALLOWED) */
    FVE_E_EDRIVE_BAND_ENUMERATION_FAILED,              /* c0210041 (STATUS_FVE_EDRIVE_BAND_ENUMERATION_FAILED) */
    FWP_E_CALLOUT_NOT_FOUND,                           /* c0220001 (STATUS_FWP_CALLOUT_NOT_FOUND) */
    FWP_E_CONDITION_NOT_FOUND,                         /* c0220002 (STATUS_FWP_CONDITION_NOT_FOUND) */
    FWP_E_FILTER_NOT_FOUND,                            /* c0220003 (STATUS_FWP_FILTER_NOT_FOUND) */
    FWP_E_LAYER_NOT_FOUND,                             /* c0220004 (STATUS_FWP_LAYER_NOT_FOUND) */
    FWP_E_PROVIDER_NOT_FOUND,                          /* c0220005 (STATUS_FWP_PROVIDER_NOT_FOUND) */
    FWP_E_PROVIDER_CONTEXT_NOT_FOUND,                  /* c0220006 (STATUS_FWP_PROVIDER_CONTEXT_NOT_FOUND) */
    FWP_E_SUBLAYER_NOT_FOUND,                          /* c0220007 (STATUS_FWP_SUBLAYER_NOT_FOUND) */
    FWP_E_NOT_FOUND,                                   /* c0220008 (STATUS_FWP_NOT_FOUND) */
    FWP_E_ALREADY_EXISTS,                              /* c0220009 (STATUS_FWP_ALREADY_EXISTS) */
    FWP_E_IN_USE,                                      /* c022000a (STATUS_FWP_IN_USE) */
    FWP_E_DYNAMIC_SESSION_IN_PROGRESS,                 /* c022000b (STATUS_FWP_DYNAMIC_SESSION_IN_PROGRESS) */
    FWP_E_WRONG_SESSION,                               /* c022000c (STATUS_FWP_WRONG_SESSION) */
    FWP_E_NO_TXN_IN_PROGRESS,                          /* c022000d (STATUS_FWP_NO_TXN_IN_PROGRESS) */
    FWP_E_TXN_IN_PROGRESS,                             /* c022000e (STATUS_FWP_TXN_IN_PROGRESS) */
    FWP_E_TXN_ABORTED,                                 /* c022000f (STATUS_FWP_TXN_ABORTED) */
    FWP_E_SESSION_ABORTED,                             /* c0220010 (STATUS_FWP_SESSION_ABORTED) */
    FWP_E_INCOMPATIBLE_TXN,                            /* c0220011 (STATUS_FWP_INCOMPATIBLE_TXN) */
    FWP_E_TIMEOUT,                                     /* c0220012 (STATUS_FWP_TIMEOUT) */
    FWP_E_NET_EVENTS_DISABLED,                         /* c0220013 (STATUS_FWP_NET_EVENTS_DISABLED) */
    FWP_E_INCOMPATIBLE_LAYER,                          /* c0220014 (STATUS_FWP_INCOMPATIBLE_LAYER) */
    FWP_E_KM_CLIENTS_ONLY,                             /* c0220015 (STATUS_FWP_KM_CLIENTS_ONLY) */
    FWP_E_LIFETIME_MISMATCH,                           /* c0220016 (STATUS_FWP_LIFETIME_MISMATCH) */
    FWP_E_BUILTIN_OBJECT,                              /* c0220017 (STATUS_FWP_BUILTIN_OBJECT) */
    FWP_E_TOO_MANY_CALLOUTS,                           /* c0220018 (STATUS_FWP_TOO_MANY_CALLOUTS) */
    FWP_E_NOTIFICATION_DROPPED,                        /* c0220019 (STATUS_FWP_NOTIFICATION_DROPPED) */
    FWP_E_TRAFFIC_MISMATCH,                            /* c022001a (STATUS_FWP_TRAFFIC_MISMATCH) */
    FWP_E_INCOMPATIBLE_SA_STATE,                       /* c022001b (STATUS_FWP_INCOMPATIBLE_SA_STATE) */
    FWP_E_NULL_POINTER,                                /* c022001c (STATUS_FWP_NULL_POINTER) */
    FWP_E_INVALID_ENUMERATOR,                          /* c022001d (STATUS_FWP_INVALID_ENUMERATOR) */
    FWP_E_INVALID_FLAGS,                               /* c022001e (STATUS_FWP_INVALID_FLAGS) */
    FWP_E_INVALID_NET_MASK,                            /* c022001f (STATUS_FWP_INVALID_NET_MASK) */
    FWP_E_INVALID_RANGE,                               /* c0220020 (STATUS_FWP_INVALID_RANGE) */
    FWP_E_INVALID_INTERVAL,                            /* c0220021 (STATUS_FWP_INVALID_INTERVAL) */
    FWP_E_ZERO_LENGTH_ARRAY,                           /* c0220022 (STATUS_FWP_ZERO_LENGTH_ARRAY) */
    FWP_E_NULL_DISPLAY_NAME,                           /* c0220023 (STATUS_FWP_NULL_DISPLAY_NAME) */
    FWP_E_INVALID_ACTION_TYPE,                         /* c0220024 (STATUS_FWP_INVALID_ACTION_TYPE) */
    FWP_E_INVALID_WEIGHT,                              /* c0220025 (STATUS_FWP_INVALID_WEIGHT) */
    FWP_E_MATCH_TYPE_MISMATCH,                         /* c0220026 (STATUS_FWP_MATCH_TYPE_MISMATCH) */
    FWP_E_TYPE_MISMATCH,                               /* c0220027 (STATUS_FWP_TYPE_MISMATCH) */
    FWP_E_OUT_OF_BOUNDS,                               /* c0220028 (STATUS_FWP_OUT_OF_BOUNDS) */
    FWP_E_RESERVED,                                    /* c0220029 (STATUS_FWP_RESERVED) */
    FWP_E_DUPLICATE_CONDITION,                         /* c022002a (STATUS_FWP_DUPLICATE_CONDITION) */
    FWP_E_DUPLICATE_KEYMOD,                            /* c022002b (STATUS_FWP_DUPLICATE_KEYMOD) */
    FWP_E_ACTION_INCOMPATIBLE_WITH_LAYER,              /* c022002c (STATUS_FWP_ACTION_INCOMPATIBLE_WITH_LAYER) */
    FWP_E_ACTION_INCOMPATIBLE_WITH_SUBLAYER,           /* c022002d (STATUS_FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER) */
    FWP_E_CONTEXT_INCOMPATIBLE_WITH_LAYER,             /* c022002e (STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER) */
    FWP_E_CONTEXT_INCOMPATIBLE_WITH_CALLOUT,           /* c022002f (STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT) */
    FWP_E_INCOMPATIBLE_AUTH_METHOD,                    /* c0220030 (STATUS_FWP_INCOMPATIBLE_AUTH_METHOD) */
    FWP_E_INCOMPATIBLE_DH_GROUP,                       /* c0220031 (STATUS_FWP_INCOMPATIBLE_DH_GROUP) */
    FWP_E_EM_NOT_SUPPORTED,                            /* c0220032 (STATUS_FWP_EM_NOT_SUPPORTED) */
    FWP_E_NEVER_MATCH,                                 /* c0220033 (STATUS_FWP_NEVER_MATCH) */
    FWP_E_PROVIDER_CONTEXT_MISMATCH,                   /* c0220034 (STATUS_FWP_PROVIDER_CONTEXT_MISMATCH) */
    FWP_E_INVALID_PARAMETER,                           /* c0220035 (STATUS_FWP_INVALID_PARAMETER) */
    FWP_E_TOO_MANY_SUBLAYERS,                          /* c0220036 (STATUS_FWP_TOO_MANY_SUBLAYERS) */
    FWP_E_CALLOUT_NOTIFICATION_FAILED,                 /* c0220037 (STATUS_FWP_CALLOUT_NOTIFICATION_FAILED) */
    FWP_E_INVALID_AUTH_TRANSFORM,                      /* c0220038 (STATUS_FWP_INVALID_AUTH_TRANSFORM) */
    FWP_E_INVALID_CIPHER_TRANSFORM,                    /* c0220039 (STATUS_FWP_INVALID_CIPHER_TRANSFORM) */
    FWP_E_INCOMPATIBLE_CIPHER_TRANSFORM,               /* c022003a (STATUS_FWP_INCOMPATIBLE_CIPHER_TRANSFORM) */
    FWP_E_INVALID_TRANSFORM_COMBINATION,               /* c022003b (STATUS_FWP_INVALID_TRANSFORM_COMBINATION) */
    FWP_E_DUPLICATE_AUTH_METHOD,                       /* c022003c (STATUS_FWP_DUPLICATE_AUTH_METHOD) */
    FWP_E_INVALID_TUNNEL_ENDPOINT,                     /* c022003d (STATUS_FWP_INVALID_TUNNEL_ENDPOINT) */
    FWP_E_L2_DRIVER_NOT_READY,                         /* c022003e (STATUS_FWP_L2_DRIVER_NOT_READY) */
    FWP_E_KEY_DICTATOR_ALREADY_REGISTERED,             /* c022003f (STATUS_FWP_KEY_DICTATOR_ALREADY_REGISTERED) */
    FWP_E_KEY_DICTATION_INVALID_KEYING_MATERIAL,       /* c0220040 (STATUS_FWP_KEY_DICTATION_INVALID_KEYING_MATERIAL) */
    FWP_E_CONNECTIONS_DISABLED,                        /* c0220041 (STATUS_FWP_CONNECTIONS_DISABLED) */
    FWP_E_INVALID_DNS_NAME,                            /* c0220042 (STATUS_FWP_INVALID_DNS_NAME) */
    FWP_E_STILL_ON,                                    /* c0220043 (STATUS_FWP_STILL_ON) */
    FWP_E_IKEEXT_NOT_RUNNING,                          /* c0220044 (STATUS_FWP_IKEEXT_NOT_RUNNING) */
    ERROR_NOT_READY,                                   /* c0220100 (STATUS_FWP_TCPIP_NOT_READY) */
    ERROR_OPERATION_ABORTED,                           /* c0220101 (STATUS_FWP_INJECT_HANDLE_CLOSING) */
    ERROR_RETRY,                                       /* c0220102 (STATUS_FWP_INJECT_HANDLE_STALE) */
    ERROR_INVALID_OPERATION,                           /* c0220103 (STATUS_FWP_CANNOT_PEND) */
    FWP_E_DROP_NOICMP,                                 /* c0220104 (STATUS_FWP_DROP_NOICMP) */
    ERROR_NDIS_INTERFACE_CLOSING,                      /* c0230002 (STATUS_NDIS_CLOSING) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0230003 */
    ERROR_NDIS_BAD_VERSION,                            /* c0230004 (STATUS_NDIS_BAD_VERSION) */
    ERROR_NDIS_BAD_CHARACTERISTICS,                    /* c0230005 (STATUS_NDIS_BAD_CHARACTERISTICS) */
    ERROR_NDIS_ADAPTER_NOT_FOUND,                      /* c0230006 (STATUS_NDIS_ADAPTER_NOT_FOUND) */
    ERROR_NDIS_OPEN_FAILED,                            /* c0230007 (STATUS_NDIS_OPEN_FAILED) */
    ERROR_NDIS_DEVICE_FAILED,                          /* c0230008 (STATUS_NDIS_DEVICE_FAILED) */
    ERROR_NDIS_MULTICAST_FULL,                         /* c0230009 (STATUS_NDIS_MULTICAST_FULL) */
    ERROR_NDIS_MULTICAST_EXISTS,                       /* c023000a (STATUS_NDIS_MULTICAST_EXISTS) */
    ERROR_NDIS_MULTICAST_NOT_FOUND,                    /* c023000b (STATUS_NDIS_MULTICAST_NOT_FOUND) */
    ERROR_NDIS_REQUEST_ABORTED,                        /* c023000c (STATUS_NDIS_REQUEST_ABORTED) */
    ERROR_NDIS_RESET_IN_PROGRESS,                      /* c023000d (STATUS_NDIS_RESET_IN_PROGRESS) */
    ERROR_MR_MID_NOT_FOUND,                            /* c023000e */
    ERROR_NDIS_INVALID_PACKET,                         /* c023000f (STATUS_NDIS_INVALID_PACKET) */
    ERROR_NDIS_INVALID_DEVICE_REQUEST,                 /* c0230010 (STATUS_NDIS_INVALID_DEVICE_REQUEST) */
    ERROR_NDIS_ADAPTER_NOT_READY,                      /* c0230011 (STATUS_NDIS_ADAPTER_NOT_READY) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0230012 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0230013 */
    ERROR_NDIS_INVALID_LENGTH,                         /* c0230014 (STATUS_NDIS_INVALID_LENGTH) */
    ERROR_NDIS_INVALID_DATA,                           /* c0230015 (STATUS_NDIS_INVALID_DATA) */
    ERROR_NDIS_BUFFER_TOO_SHORT,                       /* c0230016 (STATUS_NDIS_BUFFER_TOO_SHORT) */
    ERROR_NDIS_INVALID_OID,                            /* c0230017 (STATUS_NDIS_INVALID_OID) */
    ERROR_NDIS_ADAPTER_REMOVED,                        /* c0230018 (STATUS_NDIS_ADAPTER_REMOVED) */
    ERROR_NDIS_UNSUPPORTED_MEDIA,                      /* c0230019 (STATUS_NDIS_UNSUPPORTED_MEDIA) */
    ERROR_NDIS_GROUP_ADDRESS_IN_USE,                   /* c023001a (STATUS_NDIS_GROUP_ADDRESS_IN_USE) */
    ERROR_NDIS_FILE_NOT_FOUND,                         /* c023001b (STATUS_NDIS_FILE_NOT_FOUND) */
    ERROR_NDIS_ERROR_READING_FILE,                     /* c023001c (STATUS_NDIS_ERROR_READING_FILE) */
    ERROR_NDIS_ALREADY_MAPPED,                         /* c023001d (STATUS_NDIS_ALREADY_MAPPED) */
    ERROR_NDIS_RESOURCE_CONFLICT,                      /* c023001e (STATUS_NDIS_RESOURCE_CONFLICT) */
    ERROR_NDIS_MEDIA_DISCONNECTED,                     /* c023001f (STATUS_NDIS_MEDIA_DISCONNECTED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0230020 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0230021 */
    ERROR_NDIS_INVALID_ADDRESS,                        /* c0230022 (STATUS_NDIS_INVALID_ADDRESS) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0230023 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0230024 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0230025 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0230026 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0230027 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0230028 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0230029 */
    ERROR_NDIS_PAUSED,                                 /* c023002a (STATUS_NDIS_PAUSED) */
    ERROR_NDIS_INTERFACE_NOT_FOUND,                    /* c023002b (STATUS_NDIS_INTERFACE_NOT_FOUND) */
    ERROR_NDIS_UNSUPPORTED_REVISION,                   /* c023002c (STATUS_NDIS_UNSUPPORTED_REVISION) */
    ERROR_NDIS_INVALID_PORT,                           /* c023002d (STATUS_NDIS_INVALID_PORT) */
    ERROR_NDIS_INVALID_PORT_STATE,                     /* c023002e (STATUS_NDIS_INVALID_PORT_STATE) */
    ERROR_NDIS_LOW_POWER_STATE,                        /* c023002f (STATUS_NDIS_LOW_POWER_STATE) */
    ERROR_NDIS_REINIT_REQUIRED,                        /* c0230030 (STATUS_NDIS_REINIT_REQUIRED) */
    ERROR_NDIS_NO_QUEUES,                              /* c0230031 (STATUS_NDIS_NO_QUEUES) */
    ERROR_NDIS_NOT_SUPPORTED,                          /* c02300bb (STATUS_NDIS_NOT_SUPPORTED) */
    ERROR_NDIS_OFFLOAD_POLICY,                         /* c023100f (STATUS_NDIS_OFFLOAD_POLICY) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0231010 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0231011 */
    ERROR_NDIS_OFFLOAD_CONNECTION_REJECTED,            /* c0231012 (STATUS_NDIS_OFFLOAD_CONNECTION_REJECTED) */
    ERROR_NDIS_OFFLOAD_PATH_REJECTED,                  /* c0231013 (STATUS_NDIS_OFFLOAD_PATH_REJECTED) */
    ERROR_NDIS_DOT11_AUTO_CONFIG_ENABLED,              /* c0232000 (STATUS_NDIS_DOT11_AUTO_CONFIG_ENABLED) */
    ERROR_NDIS_DOT11_MEDIA_IN_USE,                     /* c0232001 (STATUS_NDIS_DOT11_MEDIA_IN_USE) */
    ERROR_NDIS_DOT11_POWER_STATE_INVALID,              /* c0232002 (STATUS_NDIS_DOT11_POWER_STATE_INVALID) */
    ERROR_NDIS_PM_WOL_PATTERN_LIST_FULL,               /* c0232003 (STATUS_NDIS_PM_WOL_PATTERN_LIST_FULL) */
    ERROR_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL,          /* c0232004 (STATUS_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL) */
    ERROR_NDIS_DOT11_AP_CHANNEL_CURRENTLY_NOT_AVAILABLE, /* c0232005 (STATUS_NDIS_DOT11_AP_CHANNEL_CURRENTLY_NOT_AVAILABLE) */
    ERROR_NDIS_DOT11_AP_BAND_CURRENTLY_NOT_AVAILABLE,  /* c0232006 (STATUS_NDIS_DOT11_AP_BAND_CURRENTLY_NOT_AVAILABLE) */
    ERROR_NDIS_DOT11_AP_CHANNEL_NOT_ALLOWED,           /* c0232007 (STATUS_NDIS_DOT11_AP_CHANNEL_NOT_ALLOWED) */
    ERROR_NDIS_DOT11_AP_BAND_NOT_ALLOWED,              /* c0232008 (STATUS_NDIS_DOT11_AP_BAND_NOT_ALLOWED) */
    ERROR_QUIC_HANDSHAKE_FAILURE,                      /* c0240000 (STATUS_QUIC_HANDSHAKE_FAILURE) */
    ERROR_QUIC_VER_NEG_FAILURE,                        /* c0240001 (STATUS_QUIC_VER_NEG_FAILURE) */
    ERROR_QUIC_USER_CANCELED,                          /* c0240002 (STATUS_QUIC_USER_CANCELED) */
    ERROR_QUIC_INTERNAL_ERROR,                         /* c0240003 (STATUS_QUIC_INTERNAL_ERROR) */
    ERROR_QUIC_PROTOCOL_VIOLATION,                     /* c0240004 (STATUS_QUIC_PROTOCOL_VIOLATION) */
    ERROR_QUIC_CONNECTION_IDLE,                        /* c0240005 (STATUS_QUIC_CONNECTION_IDLE) */
    ERROR_QUIC_CONNECTION_TIMEOUT,                     /* c0240006 (STATUS_QUIC_CONNECTION_TIMEOUT) */
    ERROR_QUIC_ALPN_NEG_FAILURE,                       /* c0240007 (STATUS_QUIC_ALPN_NEG_FAILURE) */
    TPM_E_ERROR_MASK,                                  /* c0290000 (STATUS_TPM_ERROR_MASK) */
    TPM_E_AUTHFAIL,                                    /* c0290001 (STATUS_TPM_AUTHFAIL) */
    TPM_E_BADINDEX,                                    /* c0290002 (STATUS_TPM_BADINDEX) */
    TPM_E_BAD_PARAMETER,                               /* c0290003 (STATUS_TPM_BAD_PARAMETER) */
    TPM_E_AUDITFAILURE,                                /* c0290004 (STATUS_TPM_AUDITFAILURE) */
    TPM_E_CLEAR_DISABLED,                              /* c0290005 (STATUS_TPM_CLEAR_DISABLED) */
    TPM_E_DEACTIVATED,                                 /* c0290006 (STATUS_TPM_DEACTIVATED) */
    TPM_E_DISABLED,                                    /* c0290007 (STATUS_TPM_DISABLED) */
    TPM_E_DISABLED_CMD,                                /* c0290008 (STATUS_TPM_DISABLED_CMD) */
    TPM_E_FAIL,                                        /* c0290009 (STATUS_TPM_FAIL) */
    TPM_E_BAD_ORDINAL,                                 /* c029000a (STATUS_TPM_BAD_ORDINAL) */
    TPM_E_INSTALL_DISABLED,                            /* c029000b (STATUS_TPM_INSTALL_DISABLED) */
    TPM_E_INVALID_KEYHANDLE,                           /* c029000c (STATUS_TPM_INVALID_KEYHANDLE) */
    TPM_E_KEYNOTFOUND,                                 /* c029000d (STATUS_TPM_KEYNOTFOUND) */
    TPM_E_INAPPROPRIATE_ENC,                           /* c029000e (STATUS_TPM_INAPPROPRIATE_ENC) */
    TPM_E_MIGRATEFAIL,                                 /* c029000f (STATUS_TPM_MIGRATEFAIL) */
    TPM_E_INVALID_PCR_INFO,                            /* c0290010 (STATUS_TPM_INVALID_PCR_INFO) */
    TPM_E_NOSPACE,                                     /* c0290011 (STATUS_TPM_NOSPACE) */
    TPM_E_NOSRK,                                       /* c0290012 (STATUS_TPM_NOSRK) */
    TPM_E_NOTSEALED_BLOB,                              /* c0290013 (STATUS_TPM_NOTSEALED_BLOB) */
    TPM_E_OWNER_SET,                                   /* c0290014 (STATUS_TPM_OWNER_SET) */
    TPM_E_RESOURCES,                                   /* c0290015 (STATUS_TPM_RESOURCES) */
    TPM_E_SHORTRANDOM,                                 /* c0290016 (STATUS_TPM_SHORTRANDOM) */
    TPM_E_SIZE,                                        /* c0290017 (STATUS_TPM_SIZE) */
    TPM_E_WRONGPCRVAL,                                 /* c0290018 (STATUS_TPM_WRONGPCRVAL) */
    TPM_E_BAD_PARAM_SIZE,                              /* c0290019 (STATUS_TPM_BAD_PARAM_SIZE) */
    TPM_E_SHA_THREAD,                                  /* c029001a (STATUS_TPM_SHA_THREAD) */
    TPM_E_SHA_ERROR,                                   /* c029001b (STATUS_TPM_SHA_ERROR) */
    TPM_E_FAILEDSELFTEST,                              /* c029001c (STATUS_TPM_FAILEDSELFTEST) */
    TPM_E_AUTH2FAIL,                                   /* c029001d (STATUS_TPM_AUTH2FAIL) */
    TPM_E_BADTAG,                                      /* c029001e (STATUS_TPM_BADTAG) */
    TPM_E_IOERROR,                                     /* c029001f (STATUS_TPM_IOERROR) */
    TPM_E_ENCRYPT_ERROR,                               /* c0290020 (STATUS_TPM_ENCRYPT_ERROR) */
    TPM_E_DECRYPT_ERROR,                               /* c0290021 (STATUS_TPM_DECRYPT_ERROR) */
    TPM_E_INVALID_AUTHHANDLE,                          /* c0290022 (STATUS_TPM_INVALID_AUTHHANDLE) */
    TPM_E_NO_ENDORSEMENT,                              /* c0290023 (STATUS_TPM_NO_ENDORSEMENT) */
    TPM_E_INVALID_KEYUSAGE,                            /* c0290024 (STATUS_TPM_INVALID_KEYUSAGE) */
    TPM_E_WRONG_ENTITYTYPE,                            /* c0290025 (STATUS_TPM_WRONG_ENTITYTYPE) */
    TPM_E_INVALID_POSTINIT,                            /* c0290026 (STATUS_TPM_INVALID_POSTINIT) */
    TPM_E_INAPPROPRIATE_SIG,                           /* c0290027 (STATUS_TPM_INAPPROPRIATE_SIG) */
    TPM_E_BAD_KEY_PROPERTY,                            /* c0290028 (STATUS_TPM_BAD_KEY_PROPERTY) */
    TPM_E_BAD_MIGRATION,                               /* c0290029 (STATUS_TPM_BAD_MIGRATION) */
    TPM_E_BAD_SCHEME,                                  /* c029002a (STATUS_TPM_BAD_SCHEME) */
    TPM_E_BAD_DATASIZE,                                /* c029002b (STATUS_TPM_BAD_DATASIZE) */
    TPM_E_BAD_MODE,                                    /* c029002c (STATUS_TPM_BAD_MODE) */
    TPM_E_BAD_PRESENCE,                                /* c029002d (STATUS_TPM_BAD_PRESENCE) */
    TPM_E_BAD_VERSION,                                 /* c029002e (STATUS_TPM_BAD_VERSION) */
    TPM_E_NO_WRAP_TRANSPORT,                           /* c029002f (STATUS_TPM_NO_WRAP_TRANSPORT) */
    TPM_E_AUDITFAIL_UNSUCCESSFUL,                      /* c0290030 (STATUS_TPM_AUDITFAIL_UNSUCCESSFUL) */
    TPM_E_AUDITFAIL_SUCCESSFUL,                        /* c0290031 (STATUS_TPM_AUDITFAIL_SUCCESSFUL) */
    TPM_E_NOTRESETABLE,                                /* c0290032 (STATUS_TPM_NOTRESETABLE) */
    TPM_E_NOTLOCAL,                                    /* c0290033 (STATUS_TPM_NOTLOCAL) */
    TPM_E_BAD_TYPE,                                    /* c0290034 (STATUS_TPM_BAD_TYPE) */
    TPM_E_INVALID_RESOURCE,                            /* c0290035 (STATUS_TPM_INVALID_RESOURCE) */
    TPM_E_NOTFIPS,                                     /* c0290036 (STATUS_TPM_NOTFIPS) */
    TPM_E_INVALID_FAMILY,                              /* c0290037 (STATUS_TPM_INVALID_FAMILY) */
    TPM_E_NO_NV_PERMISSION,                            /* c0290038 (STATUS_TPM_NO_NV_PERMISSION) */
    TPM_E_REQUIRES_SIGN,                               /* c0290039 (STATUS_TPM_REQUIRES_SIGN) */
    TPM_E_KEY_NOTSUPPORTED,                            /* c029003a (STATUS_TPM_KEY_NOTSUPPORTED) */
    TPM_E_AUTH_CONFLICT,                               /* c029003b (STATUS_TPM_AUTH_CONFLICT) */
    TPM_E_AREA_LOCKED,                                 /* c029003c (STATUS_TPM_AREA_LOCKED) */
    TPM_E_BAD_LOCALITY,                                /* c029003d (STATUS_TPM_BAD_LOCALITY) */
    TPM_E_READ_ONLY,                                   /* c029003e (STATUS_TPM_READ_ONLY) */
    TPM_E_PER_NOWRITE,                                 /* c029003f (STATUS_TPM_PER_NOWRITE) */
    TPM_E_FAMILYCOUNT,                                 /* c0290040 (STATUS_TPM_FAMILYCOUNT) */
    TPM_E_WRITE_LOCKED,                                /* c0290041 (STATUS_TPM_WRITE_LOCKED) */
    TPM_E_BAD_ATTRIBUTES,                              /* c0290042 (STATUS_TPM_BAD_ATTRIBUTES) */
    TPM_E_INVALID_STRUCTURE,                           /* c0290043 (STATUS_TPM_INVALID_STRUCTURE) */
    TPM_E_KEY_OWNER_CONTROL,                           /* c0290044 (STATUS_TPM_KEY_OWNER_CONTROL) */
    TPM_E_BAD_COUNTER,                                 /* c0290045 (STATUS_TPM_BAD_COUNTER) */
    TPM_E_NOT_FULLWRITE,                               /* c0290046 (STATUS_TPM_NOT_FULLWRITE) */
    TPM_E_CONTEXT_GAP,                                 /* c0290047 (STATUS_TPM_CONTEXT_GAP) */
    TPM_E_MAXNVWRITES,                                 /* c0290048 (STATUS_TPM_MAXNVWRITES) */
    TPM_E_NOOPERATOR,                                  /* c0290049 (STATUS_TPM_NOOPERATOR) */
    TPM_E_RESOURCEMISSING,                             /* c029004a (STATUS_TPM_RESOURCEMISSING) */
    TPM_E_DELEGATE_LOCK,                               /* c029004b (STATUS_TPM_DELEGATE_LOCK) */
    TPM_E_DELEGATE_FAMILY,                             /* c029004c (STATUS_TPM_DELEGATE_FAMILY) */
    TPM_E_DELEGATE_ADMIN,                              /* c029004d (STATUS_TPM_DELEGATE_ADMIN) */
    TPM_E_TRANSPORT_NOTEXCLUSIVE,                      /* c029004e (STATUS_TPM_TRANSPORT_NOTEXCLUSIVE) */
    TPM_E_OWNER_CONTROL,                               /* c029004f (STATUS_TPM_OWNER_CONTROL) */
    TPM_E_DAA_RESOURCES,                               /* c0290050 (STATUS_TPM_DAA_RESOURCES) */
    TPM_E_DAA_INPUT_DATA0,                             /* c0290051 (STATUS_TPM_DAA_INPUT_DATA0) */
    TPM_E_DAA_INPUT_DATA1,                             /* c0290052 (STATUS_TPM_DAA_INPUT_DATA1) */
    TPM_E_DAA_ISSUER_SETTINGS,                         /* c0290053 (STATUS_TPM_DAA_ISSUER_SETTINGS) */
    TPM_E_DAA_TPM_SETTINGS,                            /* c0290054 (STATUS_TPM_DAA_TPM_SETTINGS) */
    TPM_E_DAA_STAGE,                                   /* c0290055 (STATUS_TPM_DAA_STAGE) */
    TPM_E_DAA_ISSUER_VALIDITY,                         /* c0290056 (STATUS_TPM_DAA_ISSUER_VALIDITY) */
    TPM_E_DAA_WRONG_W,                                 /* c0290057 (STATUS_TPM_DAA_WRONG_W) */
    TPM_E_BAD_HANDLE,                                  /* c0290058 (STATUS_TPM_BAD_HANDLE) */
    TPM_E_BAD_DELEGATE,                                /* c0290059 (STATUS_TPM_BAD_DELEGATE) */
    TPM_E_BADCONTEXT,                                  /* c029005a (STATUS_TPM_BADCONTEXT) */
    TPM_E_TOOMANYCONTEXTS,                             /* c029005b (STATUS_TPM_TOOMANYCONTEXTS) */
    TPM_E_MA_TICKET_SIGNATURE,                         /* c029005c (STATUS_TPM_MA_TICKET_SIGNATURE) */
    TPM_E_MA_DESTINATION,                              /* c029005d (STATUS_TPM_MA_DESTINATION) */
    TPM_E_MA_SOURCE,                                   /* c029005e (STATUS_TPM_MA_SOURCE) */
    TPM_E_MA_AUTHORITY,                                /* c029005f (STATUS_TPM_MA_AUTHORITY) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290060 */
    TPM_E_PERMANENTEK,                                 /* c0290061 (STATUS_TPM_PERMANENTEK) */
    TPM_E_BAD_SIGNATURE,                               /* c0290062 (STATUS_TPM_BAD_SIGNATURE) */
    TPM_E_NOCONTEXTSPACE,                              /* c0290063 (STATUS_TPM_NOCONTEXTSPACE) */
    TPM_20_E_ASYMMETRIC,                               /* c0290081 (STATUS_TPM_20_E_ASYMMETRIC) */
    TPM_20_E_ATTRIBUTES,                               /* c0290082 (STATUS_TPM_20_E_ATTRIBUTES) */
    TPM_20_E_HASH,                                     /* c0290083 (STATUS_TPM_20_E_HASH) */
    TPM_20_E_VALUE,                                    /* c0290084 (STATUS_TPM_20_E_VALUE) */
    TPM_20_E_HIERARCHY,                                /* c0290085 (STATUS_TPM_20_E_HIERARCHY) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290086 */
    TPM_20_E_KEY_SIZE,                                 /* c0290087 (STATUS_TPM_20_E_KEY_SIZE) */
    TPM_20_E_MGF,                                      /* c0290088 (STATUS_TPM_20_E_MGF) */
    TPM_20_E_MODE,                                     /* c0290089 (STATUS_TPM_20_E_MODE) */
    TPM_20_E_TYPE,                                     /* c029008a (STATUS_TPM_20_E_TYPE) */
    TPM_20_E_HANDLE,                                   /* c029008b (STATUS_TPM_20_E_HANDLE) */
    TPM_20_E_KDF,                                      /* c029008c (STATUS_TPM_20_E_KDF) */
    TPM_20_E_RANGE,                                    /* c029008d (STATUS_TPM_20_E_RANGE) */
    TPM_20_E_AUTH_FAIL,                                /* c029008e (STATUS_TPM_20_E_AUTH_FAIL) */
    TPM_20_E_NONCE,                                    /* c029008f (STATUS_TPM_20_E_NONCE) */
    TPM_20_E_PP,                                       /* c0290090 (STATUS_TPM_20_E_PP) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290091 */
    TPM_20_E_SCHEME,                                   /* c0290092 (STATUS_TPM_20_E_SCHEME) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290093 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290094 */
    TPM_20_E_SIZE,                                     /* c0290095 (STATUS_TPM_20_E_SIZE) */
    TPM_20_E_SYMMETRIC,                                /* c0290096 (STATUS_TPM_20_E_SYMMETRIC) */
    TPM_20_E_TAG,                                      /* c0290097 (STATUS_TPM_20_E_TAG) */
    TPM_20_E_SELECTOR,                                 /* c0290098 (STATUS_TPM_20_E_SELECTOR) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290099 */
    TPM_20_E_INSUFFICIENT,                             /* c029009a (STATUS_TPM_20_E_INSUFFICIENT) */
    TPM_20_E_SIGNATURE,                                /* c029009b (STATUS_TPM_20_E_SIGNATURE) */
    TPM_20_E_KEY,                                      /* c029009c (STATUS_TPM_20_E_KEY) */
    TPM_20_E_POLICY_FAIL,                              /* c029009d (STATUS_TPM_20_E_POLICY_FAIL) */
    ERROR_MR_MID_NOT_FOUND,                            /* c029009e */
    TPM_20_E_INTEGRITY,                                /* c029009f (STATUS_TPM_20_E_INTEGRITY) */
    TPM_20_E_TICKET,                                   /* c02900a0 (STATUS_TPM_20_E_TICKET) */
    TPM_20_E_RESERVED_BITS,                            /* c02900a1 (STATUS_TPM_20_E_RESERVED_BITS) */
    TPM_20_E_BAD_AUTH,                                 /* c02900a2 (STATUS_TPM_20_E_BAD_AUTH) */
    TPM_20_E_EXPIRED,                                  /* c02900a3 (STATUS_TPM_20_E_EXPIRED) */
    TPM_20_E_POLICY_CC,                                /* c02900a4 (STATUS_TPM_20_E_POLICY_CC) */
    TPM_20_E_BINDING,                                  /* c02900a5 (STATUS_TPM_20_E_BINDING) */
    TPM_20_E_CURVE,                                    /* c02900a6 (STATUS_TPM_20_E_CURVE) */
    TPM_20_E_ECC_POINT,                                /* c02900a7 (STATUS_TPM_20_E_ECC_POINT) */
    TPM_20_E_INITIALIZE,                               /* c0290100 (STATUS_TPM_20_E_INITIALIZE) */
    TPM_20_E_FAILURE,                                  /* c0290101 (STATUS_TPM_20_E_FAILURE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290102 */
    TPM_20_E_SEQUENCE,                                 /* c0290103 (STATUS_TPM_20_E_SEQUENCE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290104 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290105 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290106 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290107 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290108 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290109 */
    ERROR_MR_MID_NOT_FOUND,                            /* c029010a */
    TPM_20_E_PRIVATE,                                  /* c029010b (STATUS_TPM_20_E_PRIVATE) */
    TPM_20_E_HMAC,                                     /* c0290119 (STATUS_TPM_20_E_HMAC) */
    ERROR_MR_MID_NOT_FOUND,                            /* c029011a */
    ERROR_MR_MID_NOT_FOUND,                            /* c029011b */
    ERROR_MR_MID_NOT_FOUND,                            /* c029011c */
    ERROR_MR_MID_NOT_FOUND,                            /* c029011d */
    ERROR_MR_MID_NOT_FOUND,                            /* c029011e */
    ERROR_MR_MID_NOT_FOUND,                            /* c029011f */
    TPM_20_E_DISABLED,                                 /* c0290120 (STATUS_TPM_20_E_DISABLED) */
    TPM_20_E_EXCLUSIVE,                                /* c0290121 (STATUS_TPM_20_E_EXCLUSIVE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290122 */
    TPM_20_E_ECC_CURVE,                                /* c0290123 (STATUS_TPM_20_E_ECC_CURVE) */
    TPM_20_E_AUTH_TYPE,                                /* c0290124 (STATUS_TPM_20_E_AUTH_TYPE) */
    TPM_20_E_AUTH_MISSING,                             /* c0290125 (STATUS_TPM_20_E_AUTH_MISSING) */
    TPM_20_E_POLICY,                                   /* c0290126 (STATUS_TPM_20_E_POLICY) */
    TPM_20_E_PCR,                                      /* c0290127 (STATUS_TPM_20_E_PCR) */
    TPM_20_E_PCR_CHANGED,                              /* c0290128 (STATUS_TPM_20_E_PCR_CHANGED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0290129 */
    ERROR_MR_MID_NOT_FOUND,                            /* c029012a */
    ERROR_MR_MID_NOT_FOUND,                            /* c029012b */
    ERROR_MR_MID_NOT_FOUND,                            /* c029012c */
    TPM_20_E_UPGRADE,                                  /* c029012d (STATUS_TPM_20_E_UPGRADE) */
    TPM_20_E_TOO_MANY_CONTEXTS,                        /* c029012e (STATUS_TPM_20_E_TOO_MANY_CONTEXTS) */
    TPM_20_E_AUTH_UNAVAILABLE,                         /* c029012f (STATUS_TPM_20_E_AUTH_UNAVAILABLE) */
    TPM_20_E_REBOOT,                                   /* c0290130 (STATUS_TPM_20_E_REBOOT) */
    TPM_20_E_UNBALANCED,                               /* c0290131 (STATUS_TPM_20_E_UNBALANCED) */
    TPM_20_E_COMMAND_SIZE,                             /* c0290142 (STATUS_TPM_20_E_COMMAND_SIZE) */
    TPM_20_E_COMMAND_CODE,                             /* c0290143 (STATUS_TPM_20_E_COMMAND_CODE) */
    TPM_20_E_AUTHSIZE,                                 /* c0290144 (STATUS_TPM_20_E_AUTHSIZE) */
    TPM_20_E_AUTH_CONTEXT,                             /* c0290145 (STATUS_TPM_20_E_AUTH_CONTEXT) */
    TPM_20_E_NV_RANGE,                                 /* c0290146 (STATUS_TPM_20_E_NV_RANGE) */
    TPM_20_E_NV_SIZE,                                  /* c0290147 (STATUS_TPM_20_E_NV_SIZE) */
    TPM_20_E_NV_LOCKED,                                /* c0290148 (STATUS_TPM_20_E_NV_LOCKED) */
    TPM_20_E_NV_AUTHORIZATION,                         /* c0290149 (STATUS_TPM_20_E_NV_AUTHORIZATION) */
    TPM_20_E_NV_UNINITIALIZED,                         /* c029014a (STATUS_TPM_20_E_NV_UNINITIALIZED) */
    TPM_20_E_NV_SPACE,                                 /* c029014b (STATUS_TPM_20_E_NV_SPACE) */
    TPM_20_E_NV_DEFINED,                               /* c029014c (STATUS_TPM_20_E_NV_DEFINED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c029014d */
    ERROR_MR_MID_NOT_FOUND,                            /* c029014e */
    ERROR_MR_MID_NOT_FOUND,                            /* c029014f */
    TPM_20_E_BAD_CONTEXT,                              /* c0290150 (STATUS_TPM_20_E_BAD_CONTEXT) */
    TPM_20_E_CPHASH,                                   /* c0290151 (STATUS_TPM_20_E_CPHASH) */
    TPM_20_E_PARENT,                                   /* c0290152 (STATUS_TPM_20_E_PARENT) */
    TPM_20_E_NEEDS_TEST,                               /* c0290153 (STATUS_TPM_20_E_NEEDS_TEST) */
    TPM_20_E_NO_RESULT,                                /* c0290154 (STATUS_TPM_20_E_NO_RESULT) */
    TPM_20_E_SENSITIVE,                                /* c0290155 (STATUS_TPM_20_E_SENSITIVE) */
    TPM_E_COMMAND_BLOCKED,                             /* c0290400 (STATUS_TPM_COMMAND_BLOCKED) */
    TPM_E_INVALID_HANDLE,                              /* c0290401 (STATUS_TPM_INVALID_HANDLE) */
    TPM_E_DUPLICATE_VHANDLE,                           /* c0290402 (STATUS_TPM_DUPLICATE_VHANDLE) */
    TPM_E_EMBEDDED_COMMAND_BLOCKED,                    /* c0290403 (STATUS_TPM_EMBEDDED_COMMAND_BLOCKED) */
    TPM_E_EMBEDDED_COMMAND_UNSUPPORTED,                /* c0290404 (STATUS_TPM_EMBEDDED_COMMAND_UNSUPPORTED) */
    TPM_E_RETRY,                                       /* c0290800 (STATUS_TPM_RETRY) */
    TPM_E_NEEDS_SELFTEST,                              /* c0290801 (STATUS_TPM_NEEDS_SELFTEST) */
    TPM_E_DOING_SELFTEST,                              /* c0290802 (STATUS_TPM_DOING_SELFTEST) */
    TPM_E_DEFEND_LOCK_RUNNING,                         /* c0290803 (STATUS_TPM_DEFEND_LOCK_RUNNING) */
    TBS_E_COMMAND_CANCELED,                            /* c0291001 (STATUS_TPM_COMMAND_CANCELED) */
    TBS_E_TOO_MANY_TBS_CONTEXTS,                       /* c0291002 (STATUS_TPM_TOO_MANY_CONTEXTS) */
    TBS_E_TPM_NOT_FOUND,                               /* c0291003 (STATUS_TPM_NOT_FOUND) */
    TBS_E_ACCESS_DENIED,                               /* c0291004 (STATUS_TPM_ACCESS_DENIED) */
    TBS_E_INSUFFICIENT_BUFFER,                         /* c0291005 (STATUS_TPM_INSUFFICIENT_BUFFER) */
    TBS_E_PPI_FUNCTION_UNSUPPORTED,                    /* c0291006 (STATUS_TPM_PPI_FUNCTION_UNSUPPORTED) */
    TPM_E_PCP_ERROR_MASK,                              /* c0292000 (STATUS_PCP_ERROR_MASK) */
    TPM_E_PCP_DEVICE_NOT_READY,                        /* c0292001 (STATUS_PCP_DEVICE_NOT_READY) */
    TPM_E_PCP_INVALID_HANDLE,                          /* c0292002 (STATUS_PCP_INVALID_HANDLE) */
    TPM_E_PCP_INVALID_PARAMETER,                       /* c0292003 (STATUS_PCP_INVALID_PARAMETER) */
    TPM_E_PCP_FLAG_NOT_SUPPORTED,                      /* c0292004 (STATUS_PCP_FLAG_NOT_SUPPORTED) */
    TPM_E_PCP_NOT_SUPPORTED,                           /* c0292005 (STATUS_PCP_NOT_SUPPORTED) */
    TPM_E_PCP_BUFFER_TOO_SMALL,                        /* c0292006 (STATUS_PCP_BUFFER_TOO_SMALL) */
    TPM_E_PCP_INTERNAL_ERROR,                          /* c0292007 (STATUS_PCP_INTERNAL_ERROR) */
    TPM_E_PCP_AUTHENTICATION_FAILED,                   /* c0292008 (STATUS_PCP_AUTHENTICATION_FAILED) */
    TPM_E_PCP_AUTHENTICATION_IGNORED,                  /* c0292009 (STATUS_PCP_AUTHENTICATION_IGNORED) */
    TPM_E_PCP_POLICY_NOT_FOUND,                        /* c029200a (STATUS_PCP_POLICY_NOT_FOUND) */
    TPM_E_PCP_PROFILE_NOT_FOUND,                       /* c029200b (STATUS_PCP_PROFILE_NOT_FOUND) */
    TPM_E_PCP_VALIDATION_FAILED,                       /* c029200c (STATUS_PCP_VALIDATION_FAILED) */
    NTE_DEVICE_NOT_FOUND,                              /* c029200d (STATUS_PCP_DEVICE_NOT_FOUND) */
    TPM_E_PCP_WRONG_PARENT,                            /* c029200e (STATUS_PCP_WRONG_PARENT) */
    TPM_E_KEY_NOT_LOADED,                              /* c029200f (STATUS_PCP_KEY_NOT_LOADED) */
    TPM_E_NO_KEY_CERTIFICATION,                        /* c0292010 (STATUS_PCP_NO_KEY_CERTIFICATION) */
    TPM_E_KEY_NOT_FINALIZED,                           /* c0292011 (STATUS_PCP_KEY_NOT_FINALIZED) */
    TPM_E_ATTESTATION_CHALLENGE_NOT_SET,               /* c0292012 (STATUS_PCP_ATTESTATION_CHALLENGE_NOT_SET) */
    TPM_E_NOT_PCR_BOUND,                               /* c0292013 (STATUS_PCP_NOT_PCR_BOUND) */
    TPM_E_KEY_ALREADY_FINALIZED,                       /* c0292014 (STATUS_PCP_KEY_ALREADY_FINALIZED) */
    TPM_E_KEY_USAGE_POLICY_NOT_SUPPORTED,              /* c0292015 (STATUS_PCP_KEY_USAGE_POLICY_NOT_SUPPORTED) */
    TPM_E_KEY_USAGE_POLICY_INVALID,                    /* c0292016 (STATUS_PCP_KEY_USAGE_POLICY_INVALID) */
    TPM_E_SOFT_KEY_ERROR,                              /* c0292017 (STATUS_PCP_SOFT_KEY_ERROR) */
    TPM_E_KEY_NOT_AUTHENTICATED,                       /* c0292018 (STATUS_PCP_KEY_NOT_AUTHENTICATED) */
    TPM_E_PCP_KEY_NOT_AIK,                             /* c0292019 (STATUS_PCP_KEY_NOT_AIK) */
    TPM_E_KEY_NOT_SIGNING_KEY,                         /* c029201a (STATUS_PCP_KEY_NOT_SIGNING_KEY) */
    TPM_E_LOCKED_OUT,                                  /* c029201b (STATUS_PCP_LOCKED_OUT) */
    TPM_E_CLAIM_TYPE_NOT_SUPPORTED,                    /* c029201c (STATUS_PCP_CLAIM_TYPE_NOT_SUPPORTED) */
    TPM_E_VERSION_NOT_SUPPORTED,                       /* c029201d (STATUS_PCP_TPM_VERSION_NOT_SUPPORTED) */
    TPM_E_BUFFER_LENGTH_MISMATCH,                      /* c029201e (STATUS_PCP_BUFFER_LENGTH_MISMATCH) */
    TPM_E_PCP_IFX_RSA_KEY_CREATION_BLOCKED,            /* c029201f (STATUS_PCP_IFX_RSA_KEY_CREATION_BLOCKED) */
    TPM_E_PCP_TICKET_MISSING,                          /* c0292020 (STATUS_PCP_TICKET_MISSING) */
    TPM_E_PCP_RAW_POLICY_NOT_SUPPORTED,                /* c0292021 (STATUS_PCP_RAW_POLICY_NOT_SUPPORTED) */
    TPM_E_PCP_KEY_HANDLE_INVALIDATED,                  /* c0292022 (STATUS_PCP_KEY_HANDLE_INVALIDATED) */
    ERROR_INVALID_PARAMETER,                           /* c0293002 (STATUS_RTPM_NO_RESULT) */
    ERROR_INTERNAL_ERROR,                              /* c0293003 (STATUS_RTPM_PCR_READ_INCOMPLETE) */
    ERROR_INVALID_PARAMETER,                           /* c0293004 (STATUS_RTPM_INVALID_CONTEXT) */
    ERROR_INTERNAL_ERROR,                              /* c0293005 (STATUS_RTPM_UNSUPPORTED_CMD) */
    TPM_E_ZERO_EXHAUST_ENABLED,                        /* c0294000 (STATUS_TPM_ZERO_EXHAUST_ENABLED) */
    ERROR_HV_INVALID_HYPERCALL_CODE,                   /* c0350002 (STATUS_HV_INVALID_HYPERCALL_CODE) */
    ERROR_HV_INVALID_HYPERCALL_INPUT,                  /* c0350003 (STATUS_HV_INVALID_HYPERCALL_INPUT) */
    ERROR_HV_INVALID_ALIGNMENT,                        /* c0350004 (STATUS_HV_INVALID_ALIGNMENT) */
    ERROR_HV_INVALID_PARAMETER,                        /* c0350005 (STATUS_HV_INVALID_PARAMETER) */
    ERROR_HV_ACCESS_DENIED,                            /* c0350006 (STATUS_HV_ACCESS_DENIED) */
    ERROR_HV_INVALID_PARTITION_STATE,                  /* c0350007 (STATUS_HV_INVALID_PARTITION_STATE) */
    ERROR_HV_OPERATION_DENIED,                         /* c0350008 (STATUS_HV_OPERATION_DENIED) */
    ERROR_HV_UNKNOWN_PROPERTY,                         /* c0350009 (STATUS_HV_UNKNOWN_PROPERTY) */
    ERROR_HV_PROPERTY_VALUE_OUT_OF_RANGE,              /* c035000a (STATUS_HV_PROPERTY_VALUE_OUT_OF_RANGE) */
    ERROR_HV_INSUFFICIENT_MEMORY,                      /* c035000b (STATUS_HV_INSUFFICIENT_MEMORY) */
    ERROR_HV_PARTITION_TOO_DEEP,                       /* c035000c (STATUS_HV_PARTITION_TOO_DEEP) */
    ERROR_HV_INVALID_PARTITION_ID,                     /* c035000d (STATUS_HV_INVALID_PARTITION_ID) */
    ERROR_HV_INVALID_VP_INDEX,                         /* c035000e (STATUS_HV_INVALID_VP_INDEX) */
    ERROR_MR_MID_NOT_FOUND,                            /* c035000f */
    ERROR_MR_MID_NOT_FOUND,                            /* c0350010 */
    ERROR_HV_INVALID_PORT_ID,                          /* c0350011 (STATUS_HV_INVALID_PORT_ID) */
    ERROR_HV_INVALID_CONNECTION_ID,                    /* c0350012 (STATUS_HV_INVALID_CONNECTION_ID) */
    ERROR_HV_INSUFFICIENT_BUFFERS,                     /* c0350013 (STATUS_HV_INSUFFICIENT_BUFFERS) */
    ERROR_HV_NOT_ACKNOWLEDGED,                         /* c0350014 (STATUS_HV_NOT_ACKNOWLEDGED) */
    ERROR_HV_INVALID_VP_STATE,                         /* c0350015 (STATUS_HV_INVALID_VP_STATE) */
    ERROR_HV_ACKNOWLEDGED,                             /* c0350016 (STATUS_HV_ACKNOWLEDGED) */
    ERROR_HV_INVALID_SAVE_RESTORE_STATE,               /* c0350017 (STATUS_HV_INVALID_SAVE_RESTORE_STATE) */
    ERROR_HV_INVALID_SYNIC_STATE,                      /* c0350018 (STATUS_HV_INVALID_SYNIC_STATE) */
    ERROR_HV_OBJECT_IN_USE,                            /* c0350019 (STATUS_HV_OBJECT_IN_USE) */
    ERROR_HV_INVALID_PROXIMITY_DOMAIN_INFO,            /* c035001a (STATUS_HV_INVALID_PROXIMITY_DOMAIN_INFO) */
    ERROR_HV_NO_DATA,                                  /* c035001b (STATUS_HV_NO_DATA) */
    ERROR_HV_INACTIVE,                                 /* c035001c (STATUS_HV_INACTIVE) */
    ERROR_HV_NO_RESOURCES,                             /* c035001d (STATUS_HV_NO_RESOURCES) */
    ERROR_HV_FEATURE_UNAVAILABLE,                      /* c035001e (STATUS_HV_FEATURE_UNAVAILABLE) */
    ERROR_HV_INSUFFICIENT_BUFFER,                      /* c0350033 (STATUS_HV_INSUFFICIENT_BUFFER) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0350034 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0350035 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0350036 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0350037 */
    ERROR_HV_INSUFFICIENT_DEVICE_DOMAINS,              /* c0350038 (STATUS_HV_INSUFFICIENT_DEVICE_DOMAINS) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0350039 */
    ERROR_MR_MID_NOT_FOUND,                            /* c035003a */
    ERROR_MR_MID_NOT_FOUND,                            /* c035003b */
    ERROR_HV_CPUID_FEATURE_VALIDATION,                 /* c035003c (STATUS_HV_CPUID_FEATURE_VALIDATION_ERROR) */
    ERROR_HV_CPUID_XSAVE_FEATURE_VALIDATION,           /* c035003d (STATUS_HV_CPUID_XSAVE_FEATURE_VALIDATION_ERROR) */
    ERROR_HV_PROCESSOR_STARTUP_TIMEOUT,                /* c035003e (STATUS_HV_PROCESSOR_STARTUP_TIMEOUT) */
    ERROR_HV_SMX_ENABLED,                              /* c035003f (STATUS_HV_SMX_ENABLED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0350040 */
    ERROR_HV_INVALID_LP_INDEX,                         /* c0350041 (STATUS_HV_INVALID_LP_INDEX) */
    ERROR_HV_INVALID_REGISTER_VALUE,                   /* c0350050 (STATUS_HV_INVALID_REGISTER_VALUE) */
    ERROR_HV_INVALID_VTL_STATE,                        /* c0350051 (STATUS_HV_INVALID_VTL_STATE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0350052 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0350053 */
    ERROR_MR_MID_NOT_FOUND,                            /* c0350054 */
    ERROR_HV_NX_NOT_DETECTED,                          /* c0350055 (STATUS_HV_NX_NOT_DETECTED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0350056 */
    ERROR_HV_INVALID_DEVICE_ID,                        /* c0350057 (STATUS_HV_INVALID_DEVICE_ID) */
    ERROR_HV_INVALID_DEVICE_STATE,                     /* c0350058 (STATUS_HV_INVALID_DEVICE_STATE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0350059 */
    ERROR_MR_MID_NOT_FOUND,                            /* c035005a */
    ERROR_MR_MID_NOT_FOUND,                            /* c035005b */
    ERROR_MR_MID_NOT_FOUND,                            /* c035005c */
    ERROR_MR_MID_NOT_FOUND,                            /* c035005d */
    ERROR_MR_MID_NOT_FOUND,                            /* c035005e */
    ERROR_MR_MID_NOT_FOUND,                            /* c035005f */
    ERROR_HV_PAGE_REQUEST_INVALID,                     /* c0350060 (STATUS_HV_PAGE_REQUEST_INVALID) */
    ERROR_HV_INVALID_CPU_GROUP_ID,                     /* c035006f (STATUS_HV_INVALID_CPU_GROUP_ID) */
    ERROR_HV_INVALID_CPU_GROUP_STATE,                  /* c0350070 (STATUS_HV_INVALID_CPU_GROUP_STATE) */
    ERROR_HV_OPERATION_FAILED,                         /* c0350071 (STATUS_HV_OPERATION_FAILED) */
    ERROR_HV_NOT_ALLOWED_WITH_NESTED_VIRT_ACTIVE,      /* c0350072 (STATUS_HV_NOT_ALLOWED_WITH_NESTED_VIRT_ACTIVE) */
    ERROR_HV_INSUFFICIENT_ROOT_MEMORY,                 /* c0350073 (STATUS_HV_INSUFFICIENT_ROOT_MEMORY) */
    ERROR_HV_EVENT_BUFFER_ALREADY_FREED,               /* c0350074 (STATUS_HV_EVENT_BUFFER_ALREADY_FREED) */
    ERROR_HV_INSUFFICIENT_CONTIGUOUS_MEMORY,           /* c0350075 (STATUS_HV_INSUFFICIENT_CONTIGUOUS_MEMORY) */
    ERROR_HV_DEVICE_NOT_IN_DOMAIN,                     /* c0350076 (STATUS_HV_DEVICE_NOT_IN_DOMAIN) */
    ERROR_HV_NESTED_VM_EXIT,                           /* c0350077 (STATUS_HV_NESTED_VM_EXIT) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0350078 */
    ERROR_IO_PENDING,                                  /* c0350079 (STATUS_HV_CALL_PENDING) */
    ERROR_MR_MID_NOT_FOUND,                            /* c035007a */
    ERROR_MR_MID_NOT_FOUND,                            /* c035007b */
    ERROR_MR_MID_NOT_FOUND,                            /* c035007c */
    ERROR_MR_MID_NOT_FOUND,                            /* c035007d */
    ERROR_MR_MID_NOT_FOUND,                            /* c035007e */
    ERROR_MR_MID_NOT_FOUND,                            /* c035007f */
    ERROR_HV_MSR_ACCESS_FAILED,                        /* c0350080 (STATUS_HV_MSR_ACCESS_FAILED) */
    ERROR_HV_NOT_PRESENT,                              /* c0351000 (STATUS_HV_NOT_PRESENT) */
    ERROR_IPSEC_BAD_SPI,                               /* c0360001 (STATUS_IPSEC_BAD_SPI) */
    ERROR_IPSEC_SA_LIFETIME_EXPIRED,                   /* c0360002 (STATUS_IPSEC_SA_LIFETIME_EXPIRED) */
    ERROR_IPSEC_WRONG_SA,                              /* c0360003 (STATUS_IPSEC_WRONG_SA) */
    ERROR_IPSEC_REPLAY_CHECK_FAILED,                   /* c0360004 (STATUS_IPSEC_REPLAY_CHECK_FAILED) */
    ERROR_IPSEC_INVALID_PACKET,                        /* c0360005 (STATUS_IPSEC_INVALID_PACKET) */
    ERROR_IPSEC_INTEGRITY_CHECK_FAILED,                /* c0360006 (STATUS_IPSEC_INTEGRITY_CHECK_FAILED) */
    ERROR_IPSEC_CLEAR_TEXT_DROP,                       /* c0360007 (STATUS_IPSEC_CLEAR_TEXT_DROP) */
    ERROR_IPSEC_AUTH_FIREWALL_DROP,                    /* c0360008 (STATUS_IPSEC_AUTH_FIREWALL_DROP) */
    ERROR_IPSEC_THROTTLE_DROP,                         /* c0360009 (STATUS_IPSEC_THROTTLE_DROP) */
    ERROR_IPSEC_DOSP_BLOCK,                            /* c0368000 (STATUS_IPSEC_DOSP_BLOCK) */
    ERROR_IPSEC_DOSP_RECEIVED_MULTICAST,               /* c0368001 (STATUS_IPSEC_DOSP_RECEIVED_MULTICAST) */
    ERROR_IPSEC_DOSP_INVALID_PACKET,                   /* c0368002 (STATUS_IPSEC_DOSP_INVALID_PACKET) */
    ERROR_IPSEC_DOSP_STATE_LOOKUP_FAILED,              /* c0368003 (STATUS_IPSEC_DOSP_STATE_LOOKUP_FAILED) */
    ERROR_IPSEC_DOSP_MAX_ENTRIES,                      /* c0368004 (STATUS_IPSEC_DOSP_MAX_ENTRIES) */
    ERROR_IPSEC_DOSP_KEYMOD_NOT_ALLOWED,               /* c0368005 (STATUS_IPSEC_DOSP_KEYMOD_NOT_ALLOWED) */
    ERROR_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES,      /* c0368006 (STATUS_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES) */
    ERROR_VID_DUPLICATE_HANDLER,                       /* c0370001 (STATUS_VID_DUPLICATE_HANDLER) */
    ERROR_VID_TOO_MANY_HANDLERS,                       /* c0370002 (STATUS_VID_TOO_MANY_HANDLERS) */
    ERROR_VID_QUEUE_FULL,                              /* c0370003 (STATUS_VID_QUEUE_FULL) */
    ERROR_VID_HANDLER_NOT_PRESENT,                     /* c0370004 (STATUS_VID_HANDLER_NOT_PRESENT) */
    ERROR_VID_INVALID_OBJECT_NAME,                     /* c0370005 (STATUS_VID_INVALID_OBJECT_NAME) */
    ERROR_VID_PARTITION_NAME_TOO_LONG,                 /* c0370006 (STATUS_VID_PARTITION_NAME_TOO_LONG) */
    ERROR_VID_MESSAGE_QUEUE_NAME_TOO_LONG,             /* c0370007 (STATUS_VID_MESSAGE_QUEUE_NAME_TOO_LONG) */
    ERROR_VID_PARTITION_ALREADY_EXISTS,                /* c0370008 (STATUS_VID_PARTITION_ALREADY_EXISTS) */
    ERROR_VID_PARTITION_DOES_NOT_EXIST,                /* c0370009 (STATUS_VID_PARTITION_DOES_NOT_EXIST) */
    ERROR_VID_PARTITION_NAME_NOT_FOUND,                /* c037000a (STATUS_VID_PARTITION_NAME_NOT_FOUND) */
    ERROR_VID_MESSAGE_QUEUE_ALREADY_EXISTS,            /* c037000b (STATUS_VID_MESSAGE_QUEUE_ALREADY_EXISTS) */
    ERROR_VID_EXCEEDED_MBP_ENTRY_MAP_LIMIT,            /* c037000c (STATUS_VID_EXCEEDED_MBP_ENTRY_MAP_LIMIT) */
    ERROR_VID_MB_STILL_REFERENCED,                     /* c037000d (STATUS_VID_MB_STILL_REFERENCED) */
    ERROR_VID_CHILD_GPA_PAGE_SET_CORRUPTED,            /* c037000e (STATUS_VID_CHILD_GPA_PAGE_SET_CORRUPTED) */
    ERROR_VID_INVALID_NUMA_SETTINGS,                   /* c037000f (STATUS_VID_INVALID_NUMA_SETTINGS) */
    ERROR_VID_INVALID_NUMA_NODE_INDEX,                 /* c0370010 (STATUS_VID_INVALID_NUMA_NODE_INDEX) */
    ERROR_VID_NOTIFICATION_QUEUE_ALREADY_ASSOCIATED,   /* c0370011 (STATUS_VID_NOTIFICATION_QUEUE_ALREADY_ASSOCIATED) */
    ERROR_VID_INVALID_MEMORY_BLOCK_HANDLE,             /* c0370012 (STATUS_VID_INVALID_MEMORY_BLOCK_HANDLE) */
    ERROR_VID_PAGE_RANGE_OVERFLOW,                     /* c0370013 (STATUS_VID_PAGE_RANGE_OVERFLOW) */
    ERROR_VID_INVALID_MESSAGE_QUEUE_HANDLE,            /* c0370014 (STATUS_VID_INVALID_MESSAGE_QUEUE_HANDLE) */
    ERROR_VID_INVALID_GPA_RANGE_HANDLE,                /* c0370015 (STATUS_VID_INVALID_GPA_RANGE_HANDLE) */
    ERROR_VID_NO_MEMORY_BLOCK_NOTIFICATION_QUEUE,      /* c0370016 (STATUS_VID_NO_MEMORY_BLOCK_NOTIFICATION_QUEUE) */
    ERROR_VID_MEMORY_BLOCK_LOCK_COUNT_EXCEEDED,        /* c0370017 (STATUS_VID_MEMORY_BLOCK_LOCK_COUNT_EXCEEDED) */
    ERROR_VID_INVALID_PPM_HANDLE,                      /* c0370018 (STATUS_VID_INVALID_PPM_HANDLE) */
    ERROR_VID_MBPS_ARE_LOCKED,                         /* c0370019 (STATUS_VID_MBPS_ARE_LOCKED) */
    ERROR_VID_MESSAGE_QUEUE_CLOSED,                    /* c037001a (STATUS_VID_MESSAGE_QUEUE_CLOSED) */
    ERROR_VID_VIRTUAL_PROCESSOR_LIMIT_EXCEEDED,        /* c037001b (STATUS_VID_VIRTUAL_PROCESSOR_LIMIT_EXCEEDED) */
    ERROR_VID_STOP_PENDING,                            /* c037001c (STATUS_VID_STOP_PENDING) */
    ERROR_VID_INVALID_PROCESSOR_STATE,                 /* c037001d (STATUS_VID_INVALID_PROCESSOR_STATE) */
    ERROR_VID_EXCEEDED_KM_CONTEXT_COUNT_LIMIT,         /* c037001e (STATUS_VID_EXCEEDED_KM_CONTEXT_COUNT_LIMIT) */
    ERROR_VID_KM_INTERFACE_ALREADY_INITIALIZED,        /* c037001f (STATUS_VID_KM_INTERFACE_ALREADY_INITIALIZED) */
    ERROR_VID_MB_PROPERTY_ALREADY_SET_RESET,           /* c0370020 (STATUS_VID_MB_PROPERTY_ALREADY_SET_RESET) */
    ERROR_VID_MMIO_RANGE_DESTROYED,                    /* c0370021 (STATUS_VID_MMIO_RANGE_DESTROYED) */
    ERROR_VID_INVALID_CHILD_GPA_PAGE_SET,              /* c0370022 (STATUS_VID_INVALID_CHILD_GPA_PAGE_SET) */
    ERROR_VID_RESERVE_PAGE_SET_IS_BEING_USED,          /* c0370023 (STATUS_VID_RESERVE_PAGE_SET_IS_BEING_USED) */
    ERROR_VID_RESERVE_PAGE_SET_TOO_SMALL,              /* c0370024 (STATUS_VID_RESERVE_PAGE_SET_TOO_SMALL) */
    ERROR_VID_MBP_ALREADY_LOCKED_USING_RESERVED_PAGE,  /* c0370025 (STATUS_VID_MBP_ALREADY_LOCKED_USING_RESERVED_PAGE) */
    ERROR_VID_MBP_COUNT_EXCEEDED_LIMIT,                /* c0370026 (STATUS_VID_MBP_COUNT_EXCEEDED_LIMIT) */
    ERROR_VID_SAVED_STATE_CORRUPT,                     /* c0370027 (STATUS_VID_SAVED_STATE_CORRUPT) */
    ERROR_VID_SAVED_STATE_UNRECOGNIZED_ITEM,           /* c0370028 (STATUS_VID_SAVED_STATE_UNRECOGNIZED_ITEM) */
    ERROR_VID_SAVED_STATE_INCOMPATIBLE,                /* c0370029 (STATUS_VID_SAVED_STATE_INCOMPATIBLE) */
    ERROR_VID_VTL_ACCESS_DENIED,                       /* c037002a (STATUS_VID_VTL_ACCESS_DENIED) */
    ERROR_VOLMGR_DATABASE_FULL,                        /* c0380001 (STATUS_VOLMGR_DATABASE_FULL) */
    ERROR_VOLMGR_DISK_CONFIGURATION_CORRUPTED,         /* c0380002 (STATUS_VOLMGR_DISK_CONFIGURATION_CORRUPTED) */
    ERROR_VOLMGR_DISK_CONFIGURATION_NOT_IN_SYNC,       /* c0380003 (STATUS_VOLMGR_DISK_CONFIGURATION_NOT_IN_SYNC) */
    ERROR_VOLMGR_PACK_CONFIG_UPDATE_FAILED,            /* c0380004 (STATUS_VOLMGR_PACK_CONFIG_UPDATE_FAILED) */
    ERROR_VOLMGR_DISK_CONTAINS_NON_SIMPLE_VOLUME,      /* c0380005 (STATUS_VOLMGR_DISK_CONTAINS_NON_SIMPLE_VOLUME) */
    ERROR_VOLMGR_DISK_DUPLICATE,                       /* c0380006 (STATUS_VOLMGR_DISK_DUPLICATE) */
    ERROR_VOLMGR_DISK_DYNAMIC,                         /* c0380007 (STATUS_VOLMGR_DISK_DYNAMIC) */
    ERROR_VOLMGR_DISK_ID_INVALID,                      /* c0380008 (STATUS_VOLMGR_DISK_ID_INVALID) */
    ERROR_VOLMGR_DISK_INVALID,                         /* c0380009 (STATUS_VOLMGR_DISK_INVALID) */
    ERROR_VOLMGR_DISK_LAST_VOTER,                      /* c038000a (STATUS_VOLMGR_DISK_LAST_VOTER) */
    ERROR_VOLMGR_DISK_LAYOUT_INVALID,                  /* c038000b (STATUS_VOLMGR_DISK_LAYOUT_INVALID) */
    ERROR_VOLMGR_DISK_LAYOUT_NON_BASIC_BETWEEN_BASIC_PARTITIONS, /* c038000c (STATUS_VOLMGR_DISK_LAYOUT_NON_BASIC_BETWEEN_BASIC_PARTITIONS) */
    ERROR_VOLMGR_DISK_LAYOUT_NOT_CYLINDER_ALIGNED,     /* c038000d (STATUS_VOLMGR_DISK_LAYOUT_NOT_CYLINDER_ALIGNED) */
    ERROR_VOLMGR_DISK_LAYOUT_PARTITIONS_TOO_SMALL,     /* c038000e (STATUS_VOLMGR_DISK_LAYOUT_PARTITIONS_TOO_SMALL) */
    ERROR_VOLMGR_DISK_LAYOUT_PRIMARY_BETWEEN_LOGICAL_PARTITIONS, /* c038000f (STATUS_VOLMGR_DISK_LAYOUT_PRIMARY_BETWEEN_LOGICAL_PARTITIONS) */
    ERROR_VOLMGR_DISK_LAYOUT_TOO_MANY_PARTITIONS,      /* c0380010 (STATUS_VOLMGR_DISK_LAYOUT_TOO_MANY_PARTITIONS) */
    ERROR_VOLMGR_DISK_MISSING,                         /* c0380011 (STATUS_VOLMGR_DISK_MISSING) */
    ERROR_VOLMGR_DISK_NOT_EMPTY,                       /* c0380012 (STATUS_VOLMGR_DISK_NOT_EMPTY) */
    ERROR_VOLMGR_DISK_NOT_ENOUGH_SPACE,                /* c0380013 (STATUS_VOLMGR_DISK_NOT_ENOUGH_SPACE) */
    ERROR_VOLMGR_DISK_REVECTORING_FAILED,              /* c0380014 (STATUS_VOLMGR_DISK_REVECTORING_FAILED) */
    ERROR_VOLMGR_DISK_SECTOR_SIZE_INVALID,             /* c0380015 (STATUS_VOLMGR_DISK_SECTOR_SIZE_INVALID) */
    ERROR_VOLMGR_DISK_SET_NOT_CONTAINED,               /* c0380016 (STATUS_VOLMGR_DISK_SET_NOT_CONTAINED) */
    ERROR_VOLMGR_DISK_USED_BY_MULTIPLE_MEMBERS,        /* c0380017 (STATUS_VOLMGR_DISK_USED_BY_MULTIPLE_MEMBERS) */
    ERROR_VOLMGR_DISK_USED_BY_MULTIPLE_PLEXES,         /* c0380018 (STATUS_VOLMGR_DISK_USED_BY_MULTIPLE_PLEXES) */
    ERROR_VOLMGR_DYNAMIC_DISK_NOT_SUPPORTED,           /* c0380019 (STATUS_VOLMGR_DYNAMIC_DISK_NOT_SUPPORTED) */
    ERROR_VOLMGR_EXTENT_ALREADY_USED,                  /* c038001a (STATUS_VOLMGR_EXTENT_ALREADY_USED) */
    ERROR_VOLMGR_EXTENT_NOT_CONTIGUOUS,                /* c038001b (STATUS_VOLMGR_EXTENT_NOT_CONTIGUOUS) */
    ERROR_VOLMGR_EXTENT_NOT_IN_PUBLIC_REGION,          /* c038001c (STATUS_VOLMGR_EXTENT_NOT_IN_PUBLIC_REGION) */
    ERROR_VOLMGR_EXTENT_NOT_SECTOR_ALIGNED,            /* c038001d (STATUS_VOLMGR_EXTENT_NOT_SECTOR_ALIGNED) */
    ERROR_VOLMGR_EXTENT_OVERLAPS_EBR_PARTITION,        /* c038001e (STATUS_VOLMGR_EXTENT_OVERLAPS_EBR_PARTITION) */
    ERROR_VOLMGR_EXTENT_VOLUME_LENGTHS_DO_NOT_MATCH,   /* c038001f (STATUS_VOLMGR_EXTENT_VOLUME_LENGTHS_DO_NOT_MATCH) */
    ERROR_VOLMGR_FAULT_TOLERANT_NOT_SUPPORTED,         /* c0380020 (STATUS_VOLMGR_FAULT_TOLERANT_NOT_SUPPORTED) */
    ERROR_VOLMGR_INTERLEAVE_LENGTH_INVALID,            /* c0380021 (STATUS_VOLMGR_INTERLEAVE_LENGTH_INVALID) */
    ERROR_VOLMGR_MAXIMUM_REGISTERED_USERS,             /* c0380022 (STATUS_VOLMGR_MAXIMUM_REGISTERED_USERS) */
    ERROR_VOLMGR_MEMBER_IN_SYNC,                       /* c0380023 (STATUS_VOLMGR_MEMBER_IN_SYNC) */
    ERROR_VOLMGR_MEMBER_INDEX_DUPLICATE,               /* c0380024 (STATUS_VOLMGR_MEMBER_INDEX_DUPLICATE) */
    ERROR_VOLMGR_MEMBER_INDEX_INVALID,                 /* c0380025 (STATUS_VOLMGR_MEMBER_INDEX_INVALID) */
    ERROR_VOLMGR_MEMBER_MISSING,                       /* c0380026 (STATUS_VOLMGR_MEMBER_MISSING) */
    ERROR_VOLMGR_MEMBER_NOT_DETACHED,                  /* c0380027 (STATUS_VOLMGR_MEMBER_NOT_DETACHED) */
    ERROR_VOLMGR_MEMBER_REGENERATING,                  /* c0380028 (STATUS_VOLMGR_MEMBER_REGENERATING) */
    ERROR_VOLMGR_ALL_DISKS_FAILED,                     /* c0380029 (STATUS_VOLMGR_ALL_DISKS_FAILED) */
    ERROR_VOLMGR_NO_REGISTERED_USERS,                  /* c038002a (STATUS_VOLMGR_NO_REGISTERED_USERS) */
    ERROR_VOLMGR_NO_SUCH_USER,                         /* c038002b (STATUS_VOLMGR_NO_SUCH_USER) */
    ERROR_VOLMGR_NOTIFICATION_RESET,                   /* c038002c (STATUS_VOLMGR_NOTIFICATION_RESET) */
    ERROR_VOLMGR_NUMBER_OF_MEMBERS_INVALID,            /* c038002d (STATUS_VOLMGR_NUMBER_OF_MEMBERS_INVALID) */
    ERROR_VOLMGR_NUMBER_OF_PLEXES_INVALID,             /* c038002e (STATUS_VOLMGR_NUMBER_OF_PLEXES_INVALID) */
    ERROR_VOLMGR_PACK_DUPLICATE,                       /* c038002f (STATUS_VOLMGR_PACK_DUPLICATE) */
    ERROR_VOLMGR_PACK_ID_INVALID,                      /* c0380030 (STATUS_VOLMGR_PACK_ID_INVALID) */
    ERROR_VOLMGR_PACK_INVALID,                         /* c0380031 (STATUS_VOLMGR_PACK_INVALID) */
    ERROR_VOLMGR_PACK_NAME_INVALID,                    /* c0380032 (STATUS_VOLMGR_PACK_NAME_INVALID) */
    ERROR_VOLMGR_PACK_OFFLINE,                         /* c0380033 (STATUS_VOLMGR_PACK_OFFLINE) */
    ERROR_VOLMGR_PACK_HAS_QUORUM,                      /* c0380034 (STATUS_VOLMGR_PACK_HAS_QUORUM) */
    ERROR_VOLMGR_PACK_WITHOUT_QUORUM,                  /* c0380035 (STATUS_VOLMGR_PACK_WITHOUT_QUORUM) */
    ERROR_VOLMGR_PARTITION_STYLE_INVALID,              /* c0380036 (STATUS_VOLMGR_PARTITION_STYLE_INVALID) */
    ERROR_VOLMGR_PARTITION_UPDATE_FAILED,              /* c0380037 (STATUS_VOLMGR_PARTITION_UPDATE_FAILED) */
    ERROR_VOLMGR_PLEX_IN_SYNC,                         /* c0380038 (STATUS_VOLMGR_PLEX_IN_SYNC) */
    ERROR_VOLMGR_PLEX_INDEX_DUPLICATE,                 /* c0380039 (STATUS_VOLMGR_PLEX_INDEX_DUPLICATE) */
    ERROR_VOLMGR_PLEX_INDEX_INVALID,                   /* c038003a (STATUS_VOLMGR_PLEX_INDEX_INVALID) */
    ERROR_VOLMGR_PLEX_LAST_ACTIVE,                     /* c038003b (STATUS_VOLMGR_PLEX_LAST_ACTIVE) */
    ERROR_VOLMGR_PLEX_MISSING,                         /* c038003c (STATUS_VOLMGR_PLEX_MISSING) */
    ERROR_VOLMGR_PLEX_REGENERATING,                    /* c038003d (STATUS_VOLMGR_PLEX_REGENERATING) */
    ERROR_VOLMGR_PLEX_TYPE_INVALID,                    /* c038003e (STATUS_VOLMGR_PLEX_TYPE_INVALID) */
    ERROR_VOLMGR_PLEX_NOT_RAID5,                       /* c038003f (STATUS_VOLMGR_PLEX_NOT_RAID5) */
    ERROR_VOLMGR_PLEX_NOT_SIMPLE,                      /* c0380040 (STATUS_VOLMGR_PLEX_NOT_SIMPLE) */
    ERROR_VOLMGR_STRUCTURE_SIZE_INVALID,               /* c0380041 (STATUS_VOLMGR_STRUCTURE_SIZE_INVALID) */
    ERROR_VOLMGR_TOO_MANY_NOTIFICATION_REQUESTS,       /* c0380042 (STATUS_VOLMGR_TOO_MANY_NOTIFICATION_REQUESTS) */
    ERROR_VOLMGR_TRANSACTION_IN_PROGRESS,              /* c0380043 (STATUS_VOLMGR_TRANSACTION_IN_PROGRESS) */
    ERROR_VOLMGR_UNEXPECTED_DISK_LAYOUT_CHANGE,        /* c0380044 (STATUS_VOLMGR_UNEXPECTED_DISK_LAYOUT_CHANGE) */
    ERROR_VOLMGR_VOLUME_CONTAINS_MISSING_DISK,         /* c0380045 (STATUS_VOLMGR_VOLUME_CONTAINS_MISSING_DISK) */
    ERROR_VOLMGR_VOLUME_ID_INVALID,                    /* c0380046 (STATUS_VOLMGR_VOLUME_ID_INVALID) */
    ERROR_VOLMGR_VOLUME_LENGTH_INVALID,                /* c0380047 (STATUS_VOLMGR_VOLUME_LENGTH_INVALID) */
    ERROR_VOLMGR_VOLUME_LENGTH_NOT_SECTOR_SIZE_MULTIPLE, /* c0380048 (STATUS_VOLMGR_VOLUME_LENGTH_NOT_SECTOR_SIZE_MULTIPLE) */
    ERROR_VOLMGR_VOLUME_NOT_MIRRORED,                  /* c0380049 (STATUS_VOLMGR_VOLUME_NOT_MIRRORED) */
    ERROR_VOLMGR_VOLUME_NOT_RETAINED,                  /* c038004a (STATUS_VOLMGR_VOLUME_NOT_RETAINED) */
    ERROR_VOLMGR_VOLUME_OFFLINE,                       /* c038004b (STATUS_VOLMGR_VOLUME_OFFLINE) */
    ERROR_VOLMGR_VOLUME_RETAINED,                      /* c038004c (STATUS_VOLMGR_VOLUME_RETAINED) */
    ERROR_VOLMGR_NUMBER_OF_EXTENTS_INVALID,            /* c038004d (STATUS_VOLMGR_NUMBER_OF_EXTENTS_INVALID) */
    ERROR_VOLMGR_DIFFERENT_SECTOR_SIZE,                /* c038004e (STATUS_VOLMGR_DIFFERENT_SECTOR_SIZE) */
    ERROR_VOLMGR_BAD_BOOT_DISK,                        /* c038004f (STATUS_VOLMGR_BAD_BOOT_DISK) */
    ERROR_VOLMGR_PACK_CONFIG_OFFLINE,                  /* c0380050 (STATUS_VOLMGR_PACK_CONFIG_OFFLINE) */
    ERROR_VOLMGR_PACK_CONFIG_ONLINE,                   /* c0380051 (STATUS_VOLMGR_PACK_CONFIG_ONLINE) */
    ERROR_VOLMGR_NOT_PRIMARY_PACK,                     /* c0380052 (STATUS_VOLMGR_NOT_PRIMARY_PACK) */
    ERROR_VOLMGR_PACK_LOG_UPDATE_FAILED,               /* c0380053 (STATUS_VOLMGR_PACK_LOG_UPDATE_FAILED) */
    ERROR_VOLMGR_NUMBER_OF_DISKS_IN_PLEX_INVALID,      /* c0380054 (STATUS_VOLMGR_NUMBER_OF_DISKS_IN_PLEX_INVALID) */
    ERROR_VOLMGR_NUMBER_OF_DISKS_IN_MEMBER_INVALID,    /* c0380055 (STATUS_VOLMGR_NUMBER_OF_DISKS_IN_MEMBER_INVALID) */
    ERROR_VOLMGR_VOLUME_MIRRORED,                      /* c0380056 (STATUS_VOLMGR_VOLUME_MIRRORED) */
    ERROR_VOLMGR_PLEX_NOT_SIMPLE_SPANNED,              /* c0380057 (STATUS_VOLMGR_PLEX_NOT_SIMPLE_SPANNED) */
    ERROR_VOLMGR_NO_VALID_LOG_COPIES,                  /* c0380058 (STATUS_VOLMGR_NO_VALID_LOG_COPIES) */
    ERROR_VOLMGR_PRIMARY_PACK_PRESENT,                 /* c0380059 (STATUS_VOLMGR_PRIMARY_PACK_PRESENT) */
    ERROR_VOLMGR_NUMBER_OF_DISKS_INVALID,              /* c038005a (STATUS_VOLMGR_NUMBER_OF_DISKS_INVALID) */
    ERROR_VOLMGR_MIRROR_NOT_SUPPORTED,                 /* c038005b (STATUS_VOLMGR_MIRROR_NOT_SUPPORTED) */
    ERROR_VOLMGR_RAID5_NOT_SUPPORTED,                  /* c038005c (STATUS_VOLMGR_RAID5_NOT_SUPPORTED) */
    ERROR_BCD_TOO_MANY_ELEMENTS,                       /* c0390002 (STATUS_BCD_TOO_MANY_ELEMENTS) */
    ERROR_VHD_DRIVE_FOOTER_MISSING,                    /* c03a0001 (STATUS_VHD_DRIVE_FOOTER_MISSING) */
    ERROR_VHD_DRIVE_FOOTER_CHECKSUM_MISMATCH,          /* c03a0002 (STATUS_VHD_DRIVE_FOOTER_CHECKSUM_MISMATCH) */
    ERROR_VHD_DRIVE_FOOTER_CORRUPT,                    /* c03a0003 (STATUS_VHD_DRIVE_FOOTER_CORRUPT) */
    ERROR_VHD_FORMAT_UNKNOWN,                          /* c03a0004 (STATUS_VHD_FORMAT_UNKNOWN) */
    ERROR_VHD_FORMAT_UNSUPPORTED_VERSION,              /* c03a0005 (STATUS_VHD_FORMAT_UNSUPPORTED_VERSION) */
    ERROR_VHD_SPARSE_HEADER_CHECKSUM_MISMATCH,         /* c03a0006 (STATUS_VHD_SPARSE_HEADER_CHECKSUM_MISMATCH) */
    ERROR_VHD_SPARSE_HEADER_UNSUPPORTED_VERSION,       /* c03a0007 (STATUS_VHD_SPARSE_HEADER_UNSUPPORTED_VERSION) */
    ERROR_VHD_SPARSE_HEADER_CORRUPT,                   /* c03a0008 (STATUS_VHD_SPARSE_HEADER_CORRUPT) */
    ERROR_VHD_BLOCK_ALLOCATION_FAILURE,                /* c03a0009 (STATUS_VHD_BLOCK_ALLOCATION_FAILURE) */
    ERROR_VHD_BLOCK_ALLOCATION_TABLE_CORRUPT,          /* c03a000a (STATUS_VHD_BLOCK_ALLOCATION_TABLE_CORRUPT) */
    ERROR_VHD_INVALID_BLOCK_SIZE,                      /* c03a000b (STATUS_VHD_INVALID_BLOCK_SIZE) */
    ERROR_VHD_BITMAP_MISMATCH,                         /* c03a000c (STATUS_VHD_BITMAP_MISMATCH) */
    ERROR_VHD_PARENT_VHD_NOT_FOUND,                    /* c03a000d (STATUS_VHD_PARENT_VHD_NOT_FOUND) */
    ERROR_VHD_CHILD_PARENT_ID_MISMATCH,                /* c03a000e (STATUS_VHD_CHILD_PARENT_ID_MISMATCH) */
    ERROR_VHD_CHILD_PARENT_TIMESTAMP_MISMATCH,         /* c03a000f (STATUS_VHD_CHILD_PARENT_TIMESTAMP_MISMATCH) */
    ERROR_VHD_METADATA_READ_FAILURE,                   /* c03a0010 (STATUS_VHD_METADATA_READ_FAILURE) */
    ERROR_VHD_METADATA_WRITE_FAILURE,                  /* c03a0011 (STATUS_VHD_METADATA_WRITE_FAILURE) */
    ERROR_VHD_INVALID_SIZE,                            /* c03a0012 (STATUS_VHD_INVALID_SIZE) */
    ERROR_VHD_INVALID_FILE_SIZE,                       /* c03a0013 (STATUS_VHD_INVALID_FILE_SIZE) */
    ERROR_VIRTDISK_PROVIDER_NOT_FOUND,                 /* c03a0014 (STATUS_VIRTDISK_PROVIDER_NOT_FOUND) */
    ERROR_VIRTDISK_NOT_VIRTUAL_DISK,                   /* c03a0015 (STATUS_VIRTDISK_NOT_VIRTUAL_DISK) */
    ERROR_VHD_PARENT_VHD_ACCESS_DENIED,                /* c03a0016 (STATUS_VHD_PARENT_VHD_ACCESS_DENIED) */
    ERROR_VHD_CHILD_PARENT_SIZE_MISMATCH,              /* c03a0017 (STATUS_VHD_CHILD_PARENT_SIZE_MISMATCH) */
    ERROR_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED,       /* c03a0018 (STATUS_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED) */
    ERROR_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT,      /* c03a0019 (STATUS_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT) */
    ERROR_VIRTUAL_DISK_LIMITATION,                     /* c03a001a (STATUS_VIRTUAL_DISK_LIMITATION) */
    ERROR_VHD_INVALID_TYPE,                            /* c03a001b (STATUS_VHD_INVALID_TYPE) */
    ERROR_VHD_INVALID_STATE,                           /* c03a001c (STATUS_VHD_INVALID_STATE) */
    ERROR_VIRTDISK_UNSUPPORTED_DISK_SECTOR_SIZE,       /* c03a001d (STATUS_VIRTDISK_UNSUPPORTED_DISK_SECTOR_SIZE) */
    ERROR_VIRTDISK_DISK_ALREADY_OWNED,                 /* c03a001e (STATUS_VIRTDISK_DISK_ALREADY_OWNED) */
    ERROR_VIRTDISK_DISK_ONLINE_AND_WRITABLE,           /* c03a001f (STATUS_VIRTDISK_DISK_ONLINE_AND_WRITABLE) */
    ERROR_CTLOG_TRACKING_NOT_INITIALIZED,              /* c03a0020 (STATUS_CTLOG_TRACKING_NOT_INITIALIZED) */
    ERROR_CTLOG_LOGFILE_SIZE_EXCEEDED_MAXSIZE,         /* c03a0021 (STATUS_CTLOG_LOGFILE_SIZE_EXCEEDED_MAXSIZE) */
    ERROR_CTLOG_VHD_CHANGED_OFFLINE,                   /* c03a0022 (STATUS_CTLOG_VHD_CHANGED_OFFLINE) */
    ERROR_CTLOG_INVALID_TRACKING_STATE,                /* c03a0023 (STATUS_CTLOG_INVALID_TRACKING_STATE) */
    ERROR_CTLOG_INCONSISTENT_TRACKING_FILE,            /* c03a0024 (STATUS_CTLOG_INCONSISTENT_TRACKING_FILE) */
    ERROR_MR_MID_NOT_FOUND,                            /* c03a0025 */
    ERROR_MR_MID_NOT_FOUND,                            /* c03a0026 */
    ERROR_MR_MID_NOT_FOUND,                            /* c03a0027 */
    ERROR_VHD_METADATA_FULL,                           /* c03a0028 (STATUS_VHD_METADATA_FULL) */
    ERROR_VHD_INVALID_CHANGE_TRACKING_ID,              /* c03a0029 (STATUS_VHD_INVALID_CHANGE_TRACKING_ID) */
    ERROR_VHD_CHANGE_TRACKING_DISABLED,                /* c03a002a (STATUS_VHD_CHANGE_TRACKING_DISABLED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c03a002b */
    ERROR_MR_MID_NOT_FOUND,                            /* c03a002c */
    ERROR_MR_MID_NOT_FOUND,                            /* c03a002d */
    ERROR_MR_MID_NOT_FOUND,                            /* c03a002e */
    ERROR_MR_MID_NOT_FOUND,                            /* c03a002f */
    ERROR_VHD_MISSING_CHANGE_TRACKING_INFORMATION,     /* c03a0030 (STATUS_VHD_MISSING_CHANGE_TRACKING_INFORMATION) */
    ERROR_VHD_RESIZE_WOULD_TRUNCATE_DATA,              /* c03a0031 (STATUS_VHD_RESIZE_WOULD_TRUNCATE_DATA) */
    ERROR_VHD_COULD_NOT_COMPUTE_MINIMUM_VIRTUAL_SIZE,  /* c03a0032 (STATUS_VHD_COULD_NOT_COMPUTE_MINIMUM_VIRTUAL_SIZE) */
    ERROR_VHD_ALREADY_AT_OR_BELOW_MINIMUM_VIRTUAL_SIZE, /* c03a0033 (STATUS_VHD_ALREADY_AT_OR_BELOW_MINIMUM_VIRTUAL_SIZE) */
    ERROR_INVALID_PARAMETER,                           /* c0400001 (STATUS_RKF_KEY_NOT_FOUND) */
    ERROR_INVALID_PARAMETER,                           /* c0400002 (STATUS_RKF_DUPLICATE_KEY) */
    ERROR_LOG_FULL,                                    /* c0400003 (STATUS_RKF_BLOB_FULL) */
    ERROR_LOG_FULL,                                    /* c0400004 (STATUS_RKF_STORE_FULL) */
    ERROR_SHARING_VIOLATION,                           /* c0400005 (STATUS_RKF_FILE_BLOCKED) */
    ERROR_INVALID_PARAMETER,                           /* c0400006 (STATUS_RKF_ACTIVE_KEY) */
    ERROR_INTERNAL_ERROR,                              /* c0410001 (STATUS_RDBSS_RESTART_OPERATION) */
    ERROR_INTERNAL_ERROR,                              /* c0410002 (STATUS_RDBSS_CONTINUE_OPERATION) */
    ERROR_INTERNAL_ERROR,                              /* c0410003 (STATUS_RDBSS_POST_OPERATION) */
    ERROR_INTERNAL_ERROR,                              /* c0410004 (STATUS_RDBSS_RETRY_LOOKUP) */
    E_BLUETOOTH_ATT_INVALID_HANDLE,                    /* c0420001 (STATUS_BTH_ATT_INVALID_HANDLE) */
    E_BLUETOOTH_ATT_READ_NOT_PERMITTED,                /* c0420002 (STATUS_BTH_ATT_READ_NOT_PERMITTED) */
    E_BLUETOOTH_ATT_WRITE_NOT_PERMITTED,               /* c0420003 (STATUS_BTH_ATT_WRITE_NOT_PERMITTED) */
    E_BLUETOOTH_ATT_INVALID_PDU,                       /* c0420004 (STATUS_BTH_ATT_INVALID_PDU) */
    E_BLUETOOTH_ATT_INSUFFICIENT_AUTHENTICATION,       /* c0420005 (STATUS_BTH_ATT_INSUFFICIENT_AUTHENTICATION) */
    E_BLUETOOTH_ATT_REQUEST_NOT_SUPPORTED,             /* c0420006 (STATUS_BTH_ATT_REQUEST_NOT_SUPPORTED) */
    E_BLUETOOTH_ATT_INVALID_OFFSET,                    /* c0420007 (STATUS_BTH_ATT_INVALID_OFFSET) */
    E_BLUETOOTH_ATT_INSUFFICIENT_AUTHORIZATION,        /* c0420008 (STATUS_BTH_ATT_INSUFFICIENT_AUTHORIZATION) */
    E_BLUETOOTH_ATT_PREPARE_QUEUE_FULL,                /* c0420009 (STATUS_BTH_ATT_PREPARE_QUEUE_FULL) */
    E_BLUETOOTH_ATT_ATTRIBUTE_NOT_FOUND,               /* c042000a (STATUS_BTH_ATT_ATTRIBUTE_NOT_FOUND) */
    E_BLUETOOTH_ATT_ATTRIBUTE_NOT_LONG,                /* c042000b (STATUS_BTH_ATT_ATTRIBUTE_NOT_LONG) */
    E_BLUETOOTH_ATT_INSUFFICIENT_ENCRYPTION_KEY_SIZE,  /* c042000c (STATUS_BTH_ATT_INSUFFICIENT_ENCRYPTION_KEY_SIZE) */
    E_BLUETOOTH_ATT_INVALID_ATTRIBUTE_VALUE_LENGTH,    /* c042000d (STATUS_BTH_ATT_INVALID_ATTRIBUTE_VALUE_LENGTH) */
    E_BLUETOOTH_ATT_UNLIKELY,                          /* c042000e (STATUS_BTH_ATT_UNLIKELY) */
    E_BLUETOOTH_ATT_INSUFFICIENT_ENCRYPTION,           /* c042000f (STATUS_BTH_ATT_INSUFFICIENT_ENCRYPTION) */
    E_BLUETOOTH_ATT_UNSUPPORTED_GROUP_TYPE,            /* c0420010 (STATUS_BTH_ATT_UNSUPPORTED_GROUP_TYPE) */
    E_BLUETOOTH_ATT_INSUFFICIENT_RESOURCES,            /* c0420011 (STATUS_BTH_ATT_INSUFFICIENT_RESOURCES) */
    E_BLUETOOTH_ATT_UNKNOWN_ERROR,                     /* c0421000 (STATUS_BTH_ATT_UNKNOWN_ERROR) */
    ERROR_SECUREBOOT_ROLLBACK_DETECTED,                /* c0430001 (STATUS_SECUREBOOT_ROLLBACK_DETECTED) */
    ERROR_SECUREBOOT_POLICY_VIOLATION,                 /* c0430002 (STATUS_SECUREBOOT_POLICY_VIOLATION) */
    ERROR_SECUREBOOT_INVALID_POLICY,                   /* c0430003 (STATUS_SECUREBOOT_INVALID_POLICY) */
    ERROR_SECUREBOOT_POLICY_PUBLISHER_NOT_FOUND,       /* c0430004 (STATUS_SECUREBOOT_POLICY_PUBLISHER_NOT_FOUND) */
    ERROR_SECUREBOOT_POLICY_NOT_SIGNED,                /* c0430005 (STATUS_SECUREBOOT_POLICY_NOT_SIGNED) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0430006 */
    ERROR_SECUREBOOT_FILE_REPLACED,                    /* c0430007 (STATUS_SECUREBOOT_FILE_REPLACED) */
    ERROR_SECUREBOOT_POLICY_NOT_AUTHORIZED,            /* c0430008 (STATUS_SECUREBOOT_POLICY_NOT_AUTHORIZED) */
    ERROR_SECUREBOOT_POLICY_UNKNOWN,                   /* c0430009 (STATUS_SECUREBOOT_POLICY_UNKNOWN) */
    ERROR_SECUREBOOT_POLICY_MISSING_ANTIROLLBACKVERSION, /* c043000a (STATUS_SECUREBOOT_POLICY_MISSING_ANTIROLLBACKVERSION) */
    ERROR_SECUREBOOT_PLATFORM_ID_MISMATCH,             /* c043000b (STATUS_SECUREBOOT_PLATFORM_ID_MISMATCH) */
    ERROR_SECUREBOOT_POLICY_ROLLBACK_DETECTED,         /* c043000c (STATUS_SECUREBOOT_POLICY_ROLLBACK_DETECTED) */
    ERROR_SECUREBOOT_POLICY_UPGRADE_MISMATCH,          /* c043000d (STATUS_SECUREBOOT_POLICY_UPGRADE_MISMATCH) */
    ERROR_SECUREBOOT_REQUIRED_POLICY_FILE_MISSING,     /* c043000e (STATUS_SECUREBOOT_REQUIRED_POLICY_FILE_MISSING) */
    ERROR_SECUREBOOT_NOT_BASE_POLICY,                  /* c043000f (STATUS_SECUREBOOT_NOT_BASE_POLICY) */
    ERROR_SECUREBOOT_NOT_SUPPLEMENTAL_POLICY,          /* c0430010 (STATUS_SECUREBOOT_NOT_SUPPLEMENTAL_POLICY) */
    E_AUDIO_ENGINE_NODE_NOT_FOUND,                     /* c0440001 (STATUS_AUDIO_ENGINE_NODE_NOT_FOUND) */
    E_HDAUDIO_EMPTY_CONNECTION_LIST,                   /* c0440002 (STATUS_HDAUDIO_EMPTY_CONNECTION_LIST) */
    E_HDAUDIO_CONNECTION_LIST_NOT_SUPPORTED,           /* c0440003 (STATUS_HDAUDIO_CONNECTION_LIST_NOT_SUPPORTED) */
    E_HDAUDIO_NO_LOGICAL_DEVICES_CREATED,              /* c0440004 (STATUS_HDAUDIO_NO_LOGICAL_DEVICES_CREATED) */
    E_HDAUDIO_NULL_LINKED_LIST_ENTRY,                  /* c0440005 (STATUS_HDAUDIO_NULL_LINKED_LIST_ENTRY) */
    ERROR_VSM_NOT_INITIALIZED,                         /* c0450000 (STATUS_VSM_NOT_INITIALIZED) */
    ERROR_VSM_DMA_PROTECTION_NOT_IN_USE,               /* c0450001 (STATUS_VSM_DMA_PROTECTION_NOT_IN_USE) */
    IORING_E_REQUIRED_FLAG_NOT_SUPPORTED,              /* c0460001 (STATUS_IORING_REQUIRED_FLAG_NOT_SUPPORTED) */
    IORING_E_SUBMISSION_QUEUE_FULL,                    /* c0460002 (STATUS_IORING_SUBMISSION_QUEUE_FULL) */
    IORING_E_VERSION_NOT_SUPPORTED,                    /* c0460003 (STATUS_IORING_VERSION_NOT_SUPPORTED) */
    IORING_E_SUBMISSION_QUEUE_TOO_BIG,                 /* c0460004 (STATUS_IORING_SUBMISSION_QUEUE_TOO_BIG) */
    IORING_E_COMPLETION_QUEUE_TOO_BIG,                 /* c0460005 (STATUS_IORING_COMPLETION_QUEUE_TOO_BIG) */
    IORING_E_SUBMIT_IN_PROGRESS,                       /* c0460006 (STATUS_IORING_SUBMIT_IN_PROGRESS) */
    IORING_E_CORRUPT,                                  /* c0460007 (STATUS_IORING_CORRUPT) */
    ERROR_VOLSNAP_BOOTFILE_NOT_VALID,                  /* c0500003 (STATUS_VOLSNAP_BOOTFILE_NOT_VALID) */
    ERROR_VOLSNAP_ACTIVATION_TIMEOUT,                  /* c0500004 (STATUS_VOLSNAP_ACTIVATION_TIMEOUT) */
    ERROR_VOLSNAP_NO_BYPASSIO_WITH_SNAPSHOT,           /* c0500005 (STATUS_VOLSNAP_NO_BYPASSIO_WITH_SNAPSHOT) */
    ERROR_IO_PREEMPTED,                                /* c0510001 (STATUS_IO_PREEMPTED) */
    ERROR_SVHDX_ERROR_STORED,                          /* c05c0000 (STATUS_SVHDX_ERROR_STORED) */
    ERROR_SVHDX_ERROR_NOT_AVAILABLE,                   /* c05cff00 (STATUS_SVHDX_ERROR_NOT_AVAILABLE) */
    ERROR_SVHDX_UNIT_ATTENTION_AVAILABLE,              /* c05cff01 (STATUS_SVHDX_UNIT_ATTENTION_AVAILABLE) */
    ERROR_SVHDX_UNIT_ATTENTION_CAPACITY_DATA_CHANGED,  /* c05cff02 (STATUS_SVHDX_UNIT_ATTENTION_CAPACITY_DATA_CHANGED) */
    ERROR_SVHDX_UNIT_ATTENTION_RESERVATIONS_PREEMPTED, /* c05cff03 (STATUS_SVHDX_UNIT_ATTENTION_RESERVATIONS_PREEMPTED) */
    ERROR_SVHDX_UNIT_ATTENTION_RESERVATIONS_RELEASED,  /* c05cff04 (STATUS_SVHDX_UNIT_ATTENTION_RESERVATIONS_RELEASED) */
    ERROR_SVHDX_UNIT_ATTENTION_REGISTRATIONS_PREEMPTED, /* c05cff05 (STATUS_SVHDX_UNIT_ATTENTION_REGISTRATIONS_PREEMPTED) */
    ERROR_SVHDX_UNIT_ATTENTION_OPERATING_DEFINITION_CHANGED, /* c05cff06 (STATUS_SVHDX_UNIT_ATTENTION_OPERATING_DEFINITION_CHANGED) */
    ERROR_SVHDX_RESERVATION_CONFLICT,                  /* c05cff07 (STATUS_SVHDX_RESERVATION_CONFLICT) */
    ERROR_SVHDX_WRONG_FILE_TYPE,                       /* c05cff08 (STATUS_SVHDX_WRONG_FILE_TYPE) */
    ERROR_SVHDX_VERSION_MISMATCH,                      /* c05cff09 (STATUS_SVHDX_VERSION_MISMATCH) */
    ERROR_VHD_SHARED,                                  /* c05cff0a (STATUS_VHD_SHARED) */
    ERROR_SVHDX_NO_INITIATOR,                          /* c05cff0b (STATUS_SVHDX_NO_INITIATOR) */
    ERROR_VHDSET_BACKING_STORAGE_NOT_FOUND,            /* c05cff0c (STATUS_VHDSET_BACKING_STORAGE_NOT_FOUND) */
    ERROR_SMB_NO_PREAUTH_INTEGRITY_HASH_OVERLAP,       /* c05d0000 (STATUS_SMB_NO_PREAUTH_INTEGRITY_HASH_OVERLAP) */
    ERROR_SMB_BAD_CLUSTER_DIALECT,                     /* c05d0001 (STATUS_SMB_BAD_CLUSTER_DIALECT) */
    ERROR_SMB_GUEST_LOGON_BLOCKED,                     /* c05d0002 (STATUS_SMB_GUEST_LOGON_BLOCKED) */
    ERROR_SMB_NO_SIGNING_ALGORITHM_OVERLAP,            /* c05d0003 (STATUS_SMB_NO_SIGNING_ALGORITHM_OVERLAP) */
    ERROR_SPACES_FAULT_DOMAIN_TYPE_INVALID,            /* c0e70001 (STATUS_SPACES_FAULT_DOMAIN_TYPE_INVALID) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0e70002 */
    ERROR_SPACES_RESILIENCY_TYPE_INVALID,              /* c0e70003 (STATUS_SPACES_RESILIENCY_TYPE_INVALID) */
    ERROR_SPACES_DRIVE_SECTOR_SIZE_INVALID,            /* c0e70004 (STATUS_SPACES_DRIVE_SECTOR_SIZE_INVALID) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0e70005 */
    ERROR_SPACES_DRIVE_REDUNDANCY_INVALID,             /* c0e70006 (STATUS_SPACES_DRIVE_REDUNDANCY_INVALID) */
    ERROR_SPACES_NUMBER_OF_DATA_COPIES_INVALID,        /* c0e70007 (STATUS_SPACES_NUMBER_OF_DATA_COPIES_INVALID) */
    ERROR_MR_MID_NOT_FOUND,                            /* c0e70008 */
    ERROR_SPACES_INTERLEAVE_LENGTH_INVALID,            /* c0e70009 (STATUS_SPACES_INTERLEAVE_LENGTH_INVALID) */
    ERROR_SPACES_NUMBER_OF_COLUMNS_INVALID,            /* c0e7000a (STATUS_SPACES_NUMBER_OF_COLUMNS_INVALID) */
    ERROR_SPACES_NOT_ENOUGH_DRIVES,                    /* c0e7000b (STATUS_SPACES_NOT_ENOUGH_DRIVES) */
    ERROR_SPACES_EXTENDED_ERROR,                       /* c0e7000c (STATUS_SPACES_EXTENDED_ERROR) */
    ERROR_SPACES_PROVISIONING_TYPE_INVALID,            /* c0e7000d (STATUS_SPACES_PROVISIONING_TYPE_INVALID) */
    ERROR_SPACES_ALLOCATION_SIZE_INVALID,              /* c0e7000e (STATUS_SPACES_ALLOCATION_SIZE_INVALID) */
    ERROR_SPACES_ENCLOSURE_AWARE_INVALID,              /* c0e7000f (STATUS_SPACES_ENCLOSURE_AWARE_INVALID) */
    ERROR_SPACES_WRITE_CACHE_SIZE_INVALID,             /* c0e70010 (STATUS_SPACES_WRITE_CACHE_SIZE_INVALID) */
    ERROR_SPACES_NUMBER_OF_GROUPS_INVALID,             /* c0e70011 (STATUS_SPACES_NUMBER_OF_GROUPS_INVALID) */
    ERROR_SPACES_DRIVE_OPERATIONAL_STATE_INVALID,      /* c0e70012 (STATUS_SPACES_DRIVE_OPERATIONAL_STATE_INVALID) */
    ERROR_SPACES_UPDATE_COLUMN_STATE,                  /* c0e70013 (STATUS_SPACES_UPDATE_COLUMN_STATE) */
    ERROR_SPACES_MAP_REQUIRED,                         /* c0e70014 (STATUS_SPACES_MAP_REQUIRED) */
    ERROR_SPACES_UNSUPPORTED_VERSION,                  /* c0e70015 (STATUS_SPACES_UNSUPPORTED_VERSION) */
    ERROR_SPACES_CORRUPT_METADATA,                     /* c0e70016 (STATUS_SPACES_CORRUPT_METADATA) */
    ERROR_SPACES_DRT_FULL,                             /* c0e70017 (STATUS_SPACES_DRT_FULL) */
    ERROR_SPACES_INCONSISTENCY,                        /* c0e70018 (STATUS_SPACES_INCONSISTENCY) */
    ERROR_SPACES_LOG_NOT_READY,                        /* c0e70019 (STATUS_SPACES_LOG_NOT_READY) */
    ERROR_SPACES_NO_REDUNDANCY,                        /* c0e7001a (STATUS_SPACES_NO_REDUNDANCY) */
    ERROR_SPACES_DRIVE_NOT_READY,                      /* c0e7001b (STATUS_SPACES_DRIVE_NOT_READY) */
    ERROR_SPACES_DRIVE_SPLIT,                          /* c0e7001c (STATUS_SPACES_DRIVE_SPLIT) */
    ERROR_SPACES_DRIVE_LOST_DATA,                      /* c0e7001d (STATUS_SPACES_DRIVE_LOST_DATA) */
    ERROR_SPACES_ENTRY_INCOMPLETE,                     /* c0e7001e (STATUS_SPACES_ENTRY_INCOMPLETE) */
    ERROR_SPACES_ENTRY_INVALID,                        /* c0e7001f (STATUS_SPACES_ENTRY_INVALID) */
    ERROR_SPACES_MARK_DIRTY,                           /* c0e70020 (STATUS_SPACES_MARK_DIRTY) */
    ERROR_SPACES_INTERNAL_ERROR,                       /* c0e70021 (STATUS_SPACES_PD_NOT_FOUND) */
    ERROR_SPACES_INTERNAL_ERROR,                       /* c0e70022 (STATUS_SPACES_PD_LENGTH_MISMATCH) */
    ERROR_SPACES_INTERNAL_ERROR,                       /* c0e70023 (STATUS_SPACES_PD_UNSUPPORTED_VERSION) */
    ERROR_SPACES_INTERNAL_ERROR,                       /* c0e70024 (STATUS_SPACES_PD_INVALID_DATA) */
    ERROR_SPACES_FLUSH_METADATA,                       /* c0e70025 (STATUS_SPACES_FLUSH_METADATA) */
    ERROR_SPACES_CACHE_FULL,                           /* c0e70026 (STATUS_SPACES_CACHE_FULL) */
    ERROR_SECCORE_INVALID_COMMAND,                     /* c0e80000 (STATUS_SECCORE_INVALID_COMMAND) */
    ERROR_SYSTEM_INTEGRITY_ROLLBACK_DETECTED,          /* c0e90001 (STATUS_SYSTEM_INTEGRITY_ROLLBACK_DETECTED) */
    ERROR_SYSTEM_INTEGRITY_POLICY_VIOLATION,           /* c0e90002 (STATUS_SYSTEM_INTEGRITY_POLICY_VIOLATION) */
    ERROR_SYSTEM_INTEGRITY_INVALID_POLICY,             /* c0e90003 (STATUS_SYSTEM_INTEGRITY_INVALID_POLICY) */
    ERROR_SYSTEM_INTEGRITY_POLICY_NOT_SIGNED,          /* c0e90004 (STATUS_SYSTEM_INTEGRITY_POLICY_NOT_SIGNED) */
    ERROR_SYSTEM_INTEGRITY_TOO_MANY_POLICIES,          /* c0e90005 (STATUS_SYSTEM_INTEGRITY_TOO_MANY_POLICIES) */
    ERROR_SYSTEM_INTEGRITY_SUPPLEMENTAL_POLICY_NOT_AUTHORIZED, /* c0e90006 (STATUS_SYSTEM_INTEGRITY_SUPPLEMENTAL_POLICY_NOT_AUTHORIZED) */
    ERROR_SYSTEM_INTEGRITY_REPUTATION_MALICIOUS,       /* c0e90007 (STATUS_SYSTEM_INTEGRITY_REPUTATION_MALICIOUS) */
    ERROR_SYSTEM_INTEGRITY_REPUTATION_PUA,             /* c0e90008 (STATUS_SYSTEM_INTEGRITY_REPUTATION_PUA) */
    ERROR_SYSTEM_INTEGRITY_REPUTATION_DANGEROUS_EXT,   /* c0e90009 (STATUS_SYSTEM_INTEGRITY_REPUTATION_DANGEROUS_EXT) */
    ERROR_SYSTEM_INTEGRITY_REPUTATION_OFFLINE,         /* c0e9000a (STATUS_SYSTEM_INTEGRITY_REPUTATION_OFFLINE) */
    ERROR_NO_APPLICABLE_APP_LICENSES_FOUND,            /* c0ea0001 (STATUS_NO_APPLICABLE_APP_LICENSES_FOUND) */
    ERROR_CLIP_LICENSE_NOT_FOUND,                      /* c0ea0002 (STATUS_CLIP_LICENSE_NOT_FOUND) */
    ERROR_CLIP_DEVICE_LICENSE_MISSING,                 /* c0ea0003 (STATUS_CLIP_DEVICE_LICENSE_MISSING) */
    ERROR_CLIP_LICENSE_INVALID_SIGNATURE,              /* c0ea0004 (STATUS_CLIP_LICENSE_INVALID_SIGNATURE) */
    ERROR_CLIP_KEYHOLDER_LICENSE_MISSING_OR_INVALID,   /* c0ea0005 (STATUS_CLIP_KEYHOLDER_LICENSE_MISSING_OR_INVALID) */
    ERROR_CLIP_LICENSE_EXPIRED,                        /* c0ea0006 (STATUS_CLIP_LICENSE_EXPIRED) */
    ERROR_CLIP_LICENSE_SIGNED_BY_UNKNOWN_SOURCE,       /* c0ea0007 (STATUS_CLIP_LICENSE_SIGNED_BY_UNKNOWN_SOURCE) */
    ERROR_CLIP_LICENSE_NOT_SIGNED,                     /* c0ea0008 (STATUS_CLIP_LICENSE_NOT_SIGNED) */
    ERROR_CLIP_LICENSE_HARDWARE_ID_OUT_OF_TOLERANCE,   /* c0ea0009 (STATUS_CLIP_LICENSE_HARDWARE_ID_OUT_OF_TOLERANCE) */
    ERROR_CLIP_LICENSE_DEVICE_ID_MISMATCH,             /* c0ea000a (STATUS_CLIP_LICENSE_DEVICE_ID_MISMATCH) */
    ERROR_PLATFORM_MANIFEST_NOT_AUTHORIZED,            /* c0eb0001 (STATUS_PLATFORM_MANIFEST_NOT_AUTHORIZED) */
    ERROR_PLATFORM_MANIFEST_INVALID,                   /* c0eb0002 (STATUS_PLATFORM_MANIFEST_INVALID) */
    ERROR_PLATFORM_MANIFEST_FILE_NOT_AUTHORIZED,       /* c0eb0003 (STATUS_PLATFORM_MANIFEST_FILE_NOT_AUTHORIZED) */
    ERROR_PLATFORM_MANIFEST_CATALOG_NOT_AUTHORIZED,    /* c0eb0004 (STATUS_PLATFORM_MANIFEST_CATALOG_NOT_AUTHORIZED) */
    ERROR_PLATFORM_MANIFEST_BINARY_ID_NOT_FOUND,       /* c0eb0005 (STATUS_PLATFORM_MANIFEST_BINARY_ID_NOT_FOUND) */
    ERROR_PLATFORM_MANIFEST_NOT_ACTIVE,                /* c0eb0006 (STATUS_PLATFORM_MANIFEST_NOT_ACTIVE) */
    ERROR_PLATFORM_MANIFEST_NOT_SIGNED,                /* c0eb0007 (STATUS_PLATFORM_MANIFEST_NOT_SIGNED) */
    ERROR_APPEXEC_CONDITION_NOT_SATISFIED,             /* c0ec0000 (STATUS_APPEXEC_CONDITION_NOT_SATISFIED) */
    ERROR_APPEXEC_HANDLE_INVALIDATED,                  /* c0ec0001 (STATUS_APPEXEC_HANDLE_INVALIDATED) */
    ERROR_APPEXEC_INVALID_HOST_GENERATION,             /* c0ec0002 (STATUS_APPEXEC_INVALID_HOST_GENERATION) */
    ERROR_APPEXEC_UNEXPECTED_PROCESS_REGISTRATION,     /* c0ec0003 (STATUS_APPEXEC_UNEXPECTED_PROCESS_REGISTRATION) */
    ERROR_APPEXEC_INVALID_HOST_STATE,                  /* c0ec0004 (STATUS_APPEXEC_INVALID_HOST_STATE) */
    ERROR_APPEXEC_NO_DONOR,                            /* c0ec0005 (STATUS_APPEXEC_NO_DONOR) */
    ERROR_APPEXEC_HOST_ID_MISMATCH,                    /* c0ec0006 (STATUS_APPEXEC_HOST_ID_MISMATCH) */
    ERROR_APPEXEC_UNKNOWN_USER,                        /* c0ec0007 (STATUS_APPEXEC_UNKNOWN_USER) */
    ERROR_APPEXEC_APP_COMPAT_BLOCK,                    /* c0ec0008 (STATUS_APPEXEC_APP_COMPAT_BLOCK) */
    ERROR_APPEXEC_CALLER_WAIT_TIMEOUT,                 /* c0ec0009 (STATUS_APPEXEC_CALLER_WAIT_TIMEOUT) */
    ERROR_APPEXEC_CALLER_WAIT_TIMEOUT_TERMINATION,     /* c0ec000a (STATUS_APPEXEC_CALLER_WAIT_TIMEOUT_TERMINATION) */
    ERROR_APPEXEC_CALLER_WAIT_TIMEOUT_LICENSING,       /* c0ec000b (STATUS_APPEXEC_CALLER_WAIT_TIMEOUT_LICENSING) */
    ERROR_APPEXEC_CALLER_WAIT_TIMEOUT_RESOURCES,       /* c0ec000c (STATUS_APPEXEC_CALLER_WAIT_TIMEOUT_RESOURCES) */
};

static const struct { ULONG start, end, offset; } table[162] =
{
    { 0x00000001, 0x00000003, 0 },
    { 0x0000003f, 0x0000003f, 3 },
    { 0x00000080, 0x00000080, 4 },
    { 0x000000bf, 0x000000c0, 5 },
    { 0x00000100, 0x00000128, 7 },
    { 0x00000202, 0x00000202, 48 },
    { 0x00000215, 0x00000216, 49 },
    { 0x00000367, 0x00000368, 51 },
    { 0x00010001, 0x00010002, 53 },
    { 0x001c0001, 0x001c0001, 55 },
    { 0x00350059, 0x00350059, 56 },
    { 0x00e70003, 0x00e70003, 57 },
    { 0x40000000, 0x40000039, 58 },
    { 0x40000294, 0x40000294, 116 },
    { 0x40000370, 0x40000370, 117 },
    { 0x40000807, 0x40000807, 118 },
    { 0x4000a144, 0x4000a144, 119 },
    { 0x40010001, 0x4001000a, 120 },
    { 0x40020056, 0x40020056, 130 },
    { 0x400200af, 0x400200af, 131 },
    { 0x400a0004, 0x400a0005, 132 },
    { 0x4015000d, 0x4015000d, 134 },
    { 0x40190001, 0x40190001, 135 },
    { 0x40190034, 0x40190035, 136 },
    { 0x401a000c, 0x401a000c, 138 },
    { 0x401b00ec, 0x401b00ec, 139 },
    { 0x401e000a, 0x401e000a, 140 },
    { 0x401e0201, 0x401e0201, 141 },
    { 0x401e0307, 0x401e0307, 142 },
    { 0x401e031e, 0x401e031e, 143 },
    { 0x401e034b, 0x401e0351, 144 },
    { 0x401e042f, 0x401e043c, 151 },
    { 0x40230001, 0x40230001, 165 },
    { 0x40292023, 0x40292023, 166 },
    { 0x80000001, 0x80000034, 167 },
    { 0x800001b6, 0x800001b6, 219 },
    { 0x80000288, 0x80000289, 220 },
    { 0x80000803, 0x80000803, 222 },
    { 0x8000a127, 0x8000a127, 223 },
    { 0x8000cf00, 0x8000cf05, 224 },
    { 0x80010001, 0x80010001, 230 },
    { 0x80090300, 0x80090333, 231 },
    { 0x8009033f, 0x80090349, 283 },
    { 0x8009035d, 0x80090367, 294 },
    { 0x80092010, 0x80092013, 305 },
    { 0x80096004, 0x80096004, 309 },
    { 0x800b0110, 0x800b0110, 310 },
    { 0x80130001, 0x80130005, 311 },
    { 0x80190009, 0x80190009, 316 },
    { 0x80190029, 0x80190031, 317 },
    { 0x80190041, 0x80190042, 326 },
    { 0x801b00eb, 0x801b00eb, 328 },
    { 0x801c0001, 0x801c0001, 329 },
    { 0x80210001, 0x80210002, 330 },
    { 0x80370001, 0x80370001, 332 },
    { 0x80380001, 0x80380002, 333 },
    { 0x80390001, 0x80390003, 335 },
    { 0x803a0001, 0x803a0001, 338 },
    { 0x803f0001, 0x803f0001, 339 },
    { 0x80430006, 0x80430006, 340 },
    { 0xc0000001, 0xc00001b5, 341 },
    { 0xc0000201, 0xc000030d, 778 },
    { 0xc0000320, 0xc0000322, 1047 },
    { 0xc0000350, 0xc0000374, 1050 },
    { 0xc0000380, 0xc000038f, 1087 },
    { 0xc0000401, 0xc0000435, 1103 },
    { 0xc0000440, 0xc0000446, 1156 },
    { 0xc0000450, 0xc00004d5, 1163 },
    { 0xc0000500, 0xc0000517, 1297 },
    { 0xc0000602, 0xc000060b, 1321 },
    { 0xc0000700, 0xc0000726, 1331 },
    { 0xc0000800, 0xc0000811, 1370 },
    { 0xc0000901, 0xc0000911, 1388 },
    { 0xc0000c08, 0xc0000c0f, 1405 },
    { 0xc0000c76, 0xc0000c7f, 1413 },
    { 0xc0009898, 0xc0009898, 1423 },
    { 0xc000a000, 0xc000a014, 1424 },
    { 0xc000a080, 0xc000a089, 1445 },
    { 0xc000a100, 0xc000a101, 1455 },
    { 0xc000a121, 0xc000a126, 1457 },
    { 0xc000a141, 0xc000a146, 1463 },
    { 0xc000a200, 0xc000a204, 1469 },
    { 0xc000a281, 0xc000a285, 1474 },
    { 0xc000a2a1, 0xc000a2a7, 1479 },
    { 0xc000c001, 0xc000c002, 1486 },
    { 0xc000ce01, 0xc000ce05, 1488 },
    { 0xc000cf00, 0xc000cf20, 1493 },
    { 0xc000f500, 0xc000f505, 1526 },
    { 0xc0020001, 0xc0020058, 1532 },
    { 0xc0020062, 0xc0020065, 1620 },
    { 0xc0030001, 0xc003000c, 1624 },
    { 0xc0030059, 0xc0030061, 1636 },
    { 0xc0040035, 0xc0040039, 1645 },
    { 0xc00a0001, 0xc00a0018, 1650 },
    { 0xc00a0022, 0xc00a003a, 1674 },
    { 0xc00b0001, 0xc00b0007, 1699 },
    { 0xc0130001, 0xc0130031, 1706 },
    { 0xc0140001, 0xc0140021, 1755 },
    { 0xc0150001, 0xc0150027, 1788 },
    { 0xc0190001, 0xc0190061, 1827 },
    { 0xc01a0001, 0xc01a0030, 1924 },
    { 0xc01b00ea, 0xc01b00ea, 1972 },
    { 0xc01c0001, 0xc01c0024, 1973 },
    { 0xc01d0001, 0xc01d000a, 2009 },
    { 0xc01e0000, 0xc01e0013, 2019 },
    { 0xc01e0100, 0xc01e0116, 2039 },
    { 0xc01e0200, 0xc01e0200, 2062 },
    { 0xc01e0300, 0xc01e035c, 2063 },
    { 0xc01e0400, 0xc01e0401, 2156 },
    { 0xc01e0430, 0xc01e043b, 2158 },
    { 0xc01e0500, 0xc01e0521, 2170 },
    { 0xc01e0580, 0xc01e058d, 2204 },
    { 0xc01e05e0, 0xc01e05e8, 2218 },
    { 0xc0210000, 0xc0210041, 2227 },
    { 0xc0220001, 0xc0220044, 2293 },
    { 0xc0220100, 0xc0220104, 2361 },
    { 0xc0230002, 0xc0230031, 2366 },
    { 0xc02300bb, 0xc02300bb, 2414 },
    { 0xc023100f, 0xc0231013, 2415 },
    { 0xc0232000, 0xc0232008, 2420 },
    { 0xc0240000, 0xc0240007, 2429 },
    { 0xc0290000, 0xc0290063, 2437 },
    { 0xc0290081, 0xc02900a7, 2537 },
    { 0xc0290100, 0xc029010b, 2576 },
    { 0xc0290119, 0xc0290131, 2588 },
    { 0xc0290142, 0xc0290155, 2613 },
    { 0xc0290400, 0xc0290404, 2633 },
    { 0xc0290800, 0xc0290803, 2638 },
    { 0xc0291001, 0xc0291006, 2642 },
    { 0xc0292000, 0xc0292022, 2648 },
    { 0xc0293002, 0xc0293005, 2683 },
    { 0xc0294000, 0xc0294000, 2687 },
    { 0xc0350002, 0xc035001e, 2688 },
    { 0xc0350033, 0xc0350041, 2717 },
    { 0xc0350050, 0xc0350060, 2732 },
    { 0xc035006f, 0xc0350080, 2749 },
    { 0xc0351000, 0xc0351000, 2767 },
    { 0xc0360001, 0xc0360009, 2768 },
    { 0xc0368000, 0xc0368006, 2777 },
    { 0xc0370001, 0xc037002a, 2784 },
    { 0xc0380001, 0xc038005c, 2826 },
    { 0xc0390002, 0xc0390002, 2918 },
    { 0xc03a0001, 0xc03a0033, 2919 },
    { 0xc0400001, 0xc0400006, 2970 },
    { 0xc0410001, 0xc0410004, 2976 },
    { 0xc0420001, 0xc0420011, 2980 },
    { 0xc0421000, 0xc0421000, 2997 },
    { 0xc0430001, 0xc0430010, 2998 },
    { 0xc0440001, 0xc0440005, 3014 },
    { 0xc0450000, 0xc0450001, 3019 },
    { 0xc0460001, 0xc0460007, 3021 },
    { 0xc0500003, 0xc0500005, 3028 },
    { 0xc0510001, 0xc0510001, 3031 },
    { 0xc05c0000, 0xc05c0000, 3032 },
    { 0xc05cff00, 0xc05cff0c, 3033 },
    { 0xc05d0000, 0xc05d0003, 3046 },
    { 0xc0e70001, 0xc0e70026, 3050 },
    { 0xc0e80000, 0xc0e80000, 3088 },
    { 0xc0e90001, 0xc0e9000a, 3089 },
    { 0xc0ea0001, 0xc0ea000a, 3099 },
    { 0xc0eb0001, 0xc0eb0007, 3109 },
    { 0xc0ec0000, 0xc0ec000c, 3116 },
};

static ULONG map_status( NTSTATUS status )
{
    int low = 0, high = ARRAY_SIZE(table) - 1;

    while (low <= high)
    {
        int pos = (low + high) / 2;
        if (status < table[pos].start) high = pos - 1;
        else if (status > table[pos].end) low = pos + 1;
        else return error_map[table[pos].offset + (status - table[pos].start)];
    }
    return ERROR_MR_MID_NOT_FOUND;
}
