/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSViewTransitionUpdateCallback.h"

#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "ScriptExecutionContext.h"


namespace WebCore {
using namespace JSC;

JSViewTransitionUpdateCallback::JSViewTransitionUpdateCallback(JSObject* callback, JSDOMGlobalObject* globalObject)
    : ViewTransitionUpdateCallback(globalObject->scriptExecutionContext())
    , m_data(new JSCallbackData(callback, globalObject, globalObject->scriptExecutionContext()))
{
}

JSViewTransitionUpdateCallback::~JSViewTransitionUpdateCallback()
{
    SUPPRESS_UNCOUNTED_LOCAL ScriptExecutionContext* context = scriptExecutionContext();
    // When the context is destroyed, all tasks with a reference to a callback
    // should be deleted. So if the context is 0, we are on the context thread.
    // We can't use RefPtr here since ScriptExecutionContext is not thread safe ref counted.
    if (!context || context->isContextThread())
        delete m_data;
    else
        context->postTask(DeleteCallbackDataTask(m_data));
#ifndef NDEBUG
    m_data = nullptr;
#endif
}

CallbackResult<typename IDLPromise<IDLAny>::CallbackReturnType> JSViewTransitionUpdateCallback::invoke()
{
    if (!canInvokeCallback())
        return CallbackResultType::UnableToExecute;

    Ref<JSViewTransitionUpdateCallback> protectedThis(*this);

    auto& globalObject = *m_data->globalObject();
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = globalObject.vm();

    JSLockHolder lock(vm);
    auto& lexicalGlobalObject = globalObject;
    JSValue thisValue = jsUndefined();
    MarkedArgumentBuffer args;
    ASSERT(!args.hasOverflowed());

    NakedPtr<JSC::Exception> returnedException;
    auto jsResult = m_data->invokeCallback(thisValue, args, JSCallbackData::CallbackType::Function, Identifier(), returnedException);
    if (returnedException) {
        auto* jsPromise = JSC::JSPromise::create(vm, globalObject.promiseStructure());
        jsPromise->rejectAsHandled(&globalObject, returnedException->value());
        return { DOMPromise::create(globalObject, *jsPromise) };
     }

    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto returnValue = convert<IDLPromise<IDLAny>>(lexicalGlobalObject, jsResult);
    if (returnValue.hasException(throwScope)) [[unlikely]]
        return CallbackResultType::ExceptionThrown;
    return { returnValue.releaseReturnValue() };
}

JSC::JSValue toJS(ViewTransitionUpdateCallback& impl)
{
    if (!static_cast<JSViewTransitionUpdateCallback&>(impl).callbackData())
        return jsNull();

    return static_cast<JSViewTransitionUpdateCallback&>(impl).callbackData()->callback();
}

ScriptExecutionContext* JSViewTransitionUpdateCallback::scriptExecutionContext() const
{
    return ContextDestructionObserver::scriptExecutionContext();
}
} // namespace WebCore
