/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDocumentType.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "CustomElementReactionQueue.h"
#include "DocumentInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDocumentTypePrototypeFunction_before);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentTypePrototypeFunction_after);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentTypePrototypeFunction_replaceWith);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentTypePrototypeFunction_remove);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDocumentTypeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDocumentType_name);
static JSC_DECLARE_CUSTOM_GETTER(jsDocumentType_publicId);
static JSC_DECLARE_CUSTOM_GETTER(jsDocumentType_systemId);

class JSDocumentTypePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDocumentTypePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDocumentTypePrototype* ptr = new (NotNull, JSC::allocateCell<JSDocumentTypePrototype>(vm)) JSDocumentTypePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDocumentTypePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDocumentTypePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDocumentTypePrototype, JSDocumentTypePrototype::Base);

using JSDocumentTypeDOMConstructor = JSDOMConstructorNotConstructable<JSDocumentType>;

template<> const ClassInfo JSDocumentTypeDOMConstructor::s_info = { "DocumentType"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDocumentTypeDOMConstructor) };

template<> JSValue JSDocumentTypeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSNode::getConstructor(vm, &globalObject);
}

template<> void JSDocumentTypeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DocumentType"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDocumentType::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 8> JSDocumentTypePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDocumentTypeConstructor, 0 } },
    HashTableValue { "name"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocumentType_name, 0 } },
    HashTableValue { "publicId"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocumentType_publicId, 0 } },
    HashTableValue { "systemId"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocumentType_systemId, 0 } },
    HashTableValue { "before"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentTypePrototypeFunction_before, 0 } },
    HashTableValue { "after"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentTypePrototypeFunction_after, 0 } },
    HashTableValue { "replaceWith"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentTypePrototypeFunction_replaceWith, 0 } },
    HashTableValue { "remove"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentTypePrototypeFunction_remove, 0 } },
};

const ClassInfo JSDocumentTypePrototype::s_info = { "DocumentType"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDocumentTypePrototype) };

void JSDocumentTypePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDocumentType::info(), JSDocumentTypePrototypeTableValues, *this);
    JSObject& unscopables = *constructEmptyObject(globalObject()->vm(), globalObject()->nullPrototypeObjectStructure());
    unscopables.putDirect(vm, Identifier::fromString(vm, "before"_s), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "after"_s), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "replaceWith"_s), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "remove"_s), jsBoolean(true));
    putDirectWithoutTransition(vm, vm.propertyNames->unscopablesSymbol, &unscopables, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::ReadOnly);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDocumentType::s_info = { "DocumentType"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDocumentType) };

JSDocumentType::JSDocumentType(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DocumentType>&& impl)
    : JSNode(structure, globalObject, WTFMove(impl))
{
}

Ref<DocumentType> JSDocumentType::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSDocumentType::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDocumentTypePrototype::createStructure(vm, &globalObject, JSNode::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSDocumentTypePrototype::create(vm, &globalObject, structure);
}

JSObject* JSDocumentType::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDocumentType>(vm, globalObject);
}

JSValue JSDocumentType::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDocumentTypeDOMConstructor, DOMConstructorID::DocumentType>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocumentTypeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDocumentTypePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDocumentType::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsDocumentType_nameGetter(JSGlobalObject& lexicalGlobalObject, JSDocumentType& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocumentType_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocumentType>::get<jsDocumentType_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocumentType_publicIdGetter(JSGlobalObject& lexicalGlobalObject, JSDocumentType& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.publicId())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocumentType_publicId, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocumentType>::get<jsDocumentType_publicIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocumentType_systemIdGetter(JSGlobalObject& lexicalGlobalObject, JSDocumentType& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.systemId())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocumentType_systemId, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocumentType>::get<jsDocumentType_systemIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsDocumentTypePrototypeFunction_beforeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocumentType>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.before(WTFMove(nodes)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentTypePrototypeFunction_before, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocumentType>::call<jsDocumentTypePrototypeFunction_beforeBody>(*lexicalGlobalObject, *callFrame, "before");
}

static inline JSC::EncodedJSValue jsDocumentTypePrototypeFunction_afterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocumentType>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.after(WTFMove(nodes)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentTypePrototypeFunction_after, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocumentType>::call<jsDocumentTypePrototypeFunction_afterBody>(*lexicalGlobalObject, *callFrame, "after");
}

static inline JSC::EncodedJSValue jsDocumentTypePrototypeFunction_replaceWithBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocumentType>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.replaceWith(WTFMove(nodes)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentTypePrototypeFunction_replaceWith, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocumentType>::call<jsDocumentTypePrototypeFunction_replaceWithBody>(*lexicalGlobalObject, *callFrame, "replaceWith");
}

static inline JSC::EncodedJSValue jsDocumentTypePrototypeFunction_removeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocumentType>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.remove(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentTypePrototypeFunction_remove, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocumentType>::call<jsDocumentTypePrototypeFunction_removeBody>(*lexicalGlobalObject, *callFrame, "remove");
}

JSC::GCClient::IsoSubspace* JSDocumentType::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDocumentType, UseCustomHeapCellType::No>(vm, "JSDocumentType"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDocumentType.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDocumentType = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDocumentType.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDocumentType = std::forward<decltype(space)>(space); }
    );
}

void JSDocumentType::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDocumentType*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DocumentType@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12DocumentTypeE[]; }
#endif
template<std::same_as<DocumentType> T>
static inline void verifyVTable(DocumentType* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DocumentType@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12DocumentTypeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DocumentType has subclasses. If DocumentType has subclasses that get passed
        // to toJS() we currently require DocumentType you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DocumentType>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<DocumentType>(impl.ptr());
#endif
    return createWrapper<DocumentType>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DocumentType& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DocumentType* JSDocumentType::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDocumentType*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
