// java wrapper for vtkRenderWindowInteractor object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkRenderWindowInteractor_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkRenderWindowInteractor",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_Initialize_14(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_ReInitialize_15(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReInitialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_UnRegister_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObjectBase * temp0;
  temp0 = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnRegister(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_Start_17(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->Start();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_ProcessEvents_18(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ProcessEvents();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderWindowInteractor_GetDone_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDone();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetDone_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDone(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_Enable_111(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->Enable();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_Disable_112(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->Disable();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetEnabled_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnabled();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_EnableRenderOn_114(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableRenderOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_EnableRenderOff_115(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableRenderOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEnableRender_116(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableRender(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderWindowInteractor_GetEnableRender_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableRender();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetRenderWindow_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderWindow(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_GetRenderWindow_119(JNIEnv* env, jobject obj)
{
  vtkRenderWindow * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderWindow();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetHardwareWindow_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkHardwareWindow * temp0;
  temp0 = static_cast<vtkHardwareWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHardwareWindow(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_GetHardwareWindow_121(JNIEnv* env, jobject obj)
{
  vtkHardwareWindow * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHardwareWindow();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_UpdateSize_122(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateSize(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_CreateTimer_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateTimer(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_DestroyTimer_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DestroyTimer();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_CreateRepeatingTimer_125(JNIEnv* env, jobject obj,jlong id0)
{
   unsigned long   temp0;
  int   temp20;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateRepeatingTimer(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_CreateOneShotTimer_126(JNIEnv* env, jobject obj,jlong id0)
{
   unsigned long   temp0;
  int   temp20;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateOneShotTimer(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_IsOneShotTimer_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsOneShotTimer(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_GetTimerDuration_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
   unsigned long   temp20;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimerDuration(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_ResetTimer_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ResetTimer(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_DestroyTimer_130(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DestroyTimer(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetVTKTimerId_131(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVTKTimerId(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetTimerDuration_132(JNIEnv* env, jobject obj,jlong id0)
{
   unsigned long   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimerDuration(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_GetTimerDurationMinValue_133(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimerDurationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_GetTimerDurationMaxValue_134(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimerDurationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_GetTimerDuration_135(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimerDuration();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetTimerEventId_136(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimerEventId(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetTimerEventId_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimerEventId();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetTimerEventType_138(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimerEventType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetTimerEventType_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimerEventType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetTimerEventDuration_140(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimerEventDuration(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetTimerEventDuration_141(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimerEventDuration();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetTimerEventPlatformId_142(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimerEventPlatformId(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetTimerEventPlatformId_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimerEventPlatformId();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_TerminateApp_144(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->TerminateApp();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetInteractorStyle_145(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInteractorObserver * temp0;
  temp0 = static_cast<vtkInteractorObserver*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractorStyle(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_GetInteractorStyle_146(JNIEnv* env, jobject obj)
{
  vtkInteractorObserver * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractorStyle();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetLightFollowCamera_147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLightFollowCamera(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetLightFollowCamera_148(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLightFollowCamera();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_LightFollowCameraOn_149(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LightFollowCameraOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_LightFollowCameraOff_150(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LightFollowCameraOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetDesiredUpdateRate_151(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDesiredUpdateRate(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindowInteractor_GetDesiredUpdateRateMinValue_152(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDesiredUpdateRateMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindowInteractor_GetDesiredUpdateRateMaxValue_153(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDesiredUpdateRateMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindowInteractor_GetDesiredUpdateRate_154(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDesiredUpdateRate();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetStillUpdateRate_155(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStillUpdateRate(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindowInteractor_GetStillUpdateRateMinValue_156(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStillUpdateRateMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindowInteractor_GetStillUpdateRateMaxValue_157(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStillUpdateRateMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindowInteractor_GetStillUpdateRate_158(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStillUpdateRate();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetInitialized_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInitialized();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetPicker_160(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractPicker * temp0;
  temp0 = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPicker(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_GetPicker_161(JNIEnv* env, jobject obj)
{
  vtkAbstractPicker * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPicker();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_CreateDefaultPicker_162(JNIEnv* env, jobject obj)
{
  vtkAbstractPropPicker * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateDefaultPicker();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetPickingManager_163(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPickingManager * temp0;
  temp0 = static_cast<vtkPickingManager*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPickingManager(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_GetPickingManager_164(JNIEnv* env, jobject obj)
{
  vtkPickingManager * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickingManager();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_ExitCallback_165(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExitCallback();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_UserCallback_166(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->UserCallback();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_StartPickCallback_167(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartPickCallback();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_EndPickCallback_168(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndPickCallback();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_HideCursor_169(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->HideCursor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_ShowCursor_170(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowCursor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_Render_171(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_FlyTo_172(JNIEnv* env, jobject obj,jobject id0,jdouble id1,jdouble id2,jdouble id3)
{
  vtkRenderer * temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->FlyTo(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_FlyToImage_173(JNIEnv* env, jobject obj,jobject id0,jdouble id1,jdouble id2)
{
  vtkRenderer * temp0;
  double   temp1;
  double   temp2;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->FlyToImage(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetNumberOfFlyFrames_174(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfFlyFrames(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetNumberOfFlyFramesMinValue_175(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFlyFramesMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetNumberOfFlyFramesMaxValue_176(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFlyFramesMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetNumberOfFlyFrames_177(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFlyFrames();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetDolly_178(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDolly(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindowInteractor_GetDolly_179(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDolly();
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkRenderWindowInteractor_GetEventPosition_180(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEventPosition();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkRenderWindowInteractor_GetLastEventPosition_181(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastEventPosition();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetLastEventPosition_182(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLastEventPosition(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetLastEventPosition_183(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLastEventPosition(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventPosition_184(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventPosition(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventPosition_185(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventPosition(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventPositionFlipY_186(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventPositionFlipY(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventPositionFlipY_187(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventPositionFlipY(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventPosition_188(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventPosition(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventPosition_189(JNIEnv* env, jobject obj,jintArray id0,jint id1)
{
  int temp0[2];
  int   temp1;
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventPosition(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventPositionFlipY_190(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventPositionFlipY(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventPositionFlipY_191(JNIEnv* env, jobject obj,jintArray id0,jint id1)
{
  int temp0[2];
  int   temp1;
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventPositionFlipY(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetAltKey_192(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAltKey(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetAltKey_193(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAltKey();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetControlKey_194(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetControlKey(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetControlKey_195(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetControlKey();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetShiftKey_196(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShiftKey(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetShiftKey_197(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShiftKey();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetKeyCode_198(JNIEnv* env, jobject obj,jchar id0)
{
  char   temp0;
  temp0 = static_cast<char>(0xff & id0);

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKeyCode(temp0);

}

extern "C" JNIEXPORT jchar  JNICALL Java_vtk_vtkRenderWindowInteractor_GetKeyCode_199(JNIEnv* env, jobject obj)
{
  char   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyCode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetRepeatCount_1100(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRepeatCount(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetRepeatCount_1101(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRepeatCount();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetKeySym_1102(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKeySym(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderWindowInteractor_GetKeySym_1103(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeySym();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetPointerIndex_1104(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointerIndex(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetPointerIndex_1105(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointerIndex();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetRotation_1106(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRotation(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindowInteractor_GetRotation_1107(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRotation();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindowInteractor_GetLastRotation_1108(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastRotation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetScale_1109(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScale(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindowInteractor_GetScale_1110(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScale();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindowInteractor_GetLastScale_1111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetTranslation_1112(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTranslation(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkRenderWindowInteractor_GetTranslation_1113(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTranslation();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkRenderWindowInteractor_GetLastTranslation_1114(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastTranslation();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventInformation_1115(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jchar id4,jint id5, jbyteArray id6, jint len6,jint id7)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  char   temp4;
  int   temp5;
  char * temp6;
  int   temp7;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<char>(0xff & id4);
  temp5 = id5;
  temp6 = vtkJavaUTF8ToChars(env, id6, len6);
  temp7 = id7;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventInformation(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);
  delete[] temp6;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventInformation_1116(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jchar id4,jint id5, jbyteArray id6, jint len6)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  char   temp4;
  int   temp5;
  char * temp6;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<char>(0xff & id4);
  temp5 = id5;
  temp6 = vtkJavaUTF8ToChars(env, id6, len6);

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventInformation(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  delete[] temp6;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventInformationFlipY_1117(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jchar id4,jint id5, jbyteArray id6, jint len6,jint id7)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  char   temp4;
  int   temp5;
  char * temp6;
  int   temp7;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<char>(0xff & id4);
  temp5 = id5;
  temp6 = vtkJavaUTF8ToChars(env, id6, len6);
  temp7 = id7;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventInformationFlipY(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);
  delete[] temp6;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventInformationFlipY_1118(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jchar id4,jint id5, jbyteArray id6, jint len6)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  char   temp4;
  int   temp5;
  char * temp6;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<char>(0xff & id4);
  temp5 = id5;
  temp6 = vtkJavaUTF8ToChars(env, id6, len6);

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventInformationFlipY(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  delete[] temp6;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetKeyEventInformation_1119(JNIEnv* env, jobject obj,jint id0,jint id1,jchar id2,jint id3, jbyteArray id4, jint len4)
{
  int   temp0;
  int   temp1;
  char   temp2;
  int   temp3;
  char * temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<char>(0xff & id2);
  temp3 = id3;
  temp4 = vtkJavaUTF8ToChars(env, id4, len4);

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKeyEventInformation(temp0,temp1,temp2,temp3,temp4);
  delete[] temp4;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetSize_1120(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetSize_1121(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkRenderWindowInteractor_GetSize_1122(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventSize_1123(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetEventSize_1124(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEventSize(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkRenderWindowInteractor_GetEventSize_1125(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEventSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_FindPokedRenderer_1126(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  vtkRenderer * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindPokedRenderer(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindowInteractor_GetObserverMediator_1127(JNIEnv* env, jobject obj)
{
  vtkObserverMediator * temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObserverMediator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetUseTDx_1128(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseTDx(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderWindowInteractor_GetUseTDx_1129(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseTDx();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_MouseMoveEvent_1130(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->MouseMoveEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_RightButtonPressEvent_1131(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RightButtonPressEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_RightButtonReleaseEvent_1132(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RightButtonReleaseEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_LeftButtonPressEvent_1133(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LeftButtonPressEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_LeftButtonReleaseEvent_1134(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LeftButtonReleaseEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_MiddleButtonPressEvent_1135(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->MiddleButtonPressEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_MiddleButtonReleaseEvent_1136(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->MiddleButtonReleaseEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_MouseWheelForwardEvent_1137(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->MouseWheelForwardEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_MouseWheelBackwardEvent_1138(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->MouseWheelBackwardEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_MouseWheelLeftEvent_1139(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->MouseWheelLeftEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_MouseWheelRightEvent_1140(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->MouseWheelRightEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_ExposeEvent_1141(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExposeEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_ConfigureEvent_1142(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ConfigureEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_EnterEvent_1143(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnterEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_LeaveEvent_1144(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LeaveEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_KeyPressEvent_1145(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->KeyPressEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_KeyReleaseEvent_1146(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->KeyReleaseEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_CharEvent_1147(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->CharEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_ExitEvent_1148(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExitEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_FourthButtonPressEvent_1149(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->FourthButtonPressEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_FourthButtonReleaseEvent_1150(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->FourthButtonReleaseEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_FifthButtonPressEvent_1151(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->FifthButtonPressEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_FifthButtonReleaseEvent_1152(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->FifthButtonReleaseEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_StartPinchEvent_1153(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartPinchEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_PinchEvent_1154(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PinchEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_EndPinchEvent_1155(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndPinchEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_StartRotateEvent_1156(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartRotateEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_RotateEvent_1157(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_EndRotateEvent_1158(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndRotateEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_StartPanEvent_1159(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartPanEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_PanEvent_1160(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PanEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_EndPanEvent_1161(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndPanEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_TapEvent_1162(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->TapEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_LongTapEvent_1163(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LongTapEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SwipeEvent_1164(JNIEnv* env, jobject obj)
{

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SwipeEvent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetRecognizeGestures_1165(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRecognizeGestures(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderWindowInteractor_GetRecognizeGestures_1166(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRecognizeGestures();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetPointersDownCount_1167(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointersDownCount();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderWindowInteractor_IsPointerIndexSet_1168(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPointerIndexSet(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_ClearPointerIndex_1169(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearPointerIndex(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindowInteractor_GetCurrentGesture_1170(JNIEnv* env, jobject obj)
{
  vtkCommand::EventIds   temp20;

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentGesture();
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindowInteractor_SetCurrentGesture_1171(JNIEnv* env, jobject obj,jint id0)
{
  vtkCommand::EventIds   temp0;
  temp0 = static_cast<vtkCommand::EventIds>(id0);

  vtkRenderWindowInteractor* op = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCurrentGesture(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkRenderWindowInteractor_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkRenderWindowInteractor::New());
}
