// java wrapper for vtkAbstractPicker object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAbstractPicker.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAbstractPicker_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAbstractPicker",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractPicker_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractPicker_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractPicker_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractPicker_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractPicker_GetRenderer_14(JNIEnv* env, jobject obj)
{
  vtkRenderer * temp20;

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderer();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractPicker_GetSelectionPoint_15(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractPicker_GetPickPosition_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractPicker_Pick_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jobject id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  vtkRenderer * temp3;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id3));

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pick(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractPicker_Pick_18(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[3];
  vtkRenderer * temp1;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pick(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractPicker_Pick3DPoint_19(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[3];
  vtkRenderer * temp1;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pick3DPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractPicker_Pick3DRay_110(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jobject id2)
{
  double temp0[3];
  double temp1[4];
  vtkRenderer * temp2;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);
  temp2 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id2));

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pick3DRay(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractPicker_SetPickFromList_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPickFromList(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractPicker_GetPickFromList_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickFromList();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractPicker_PickFromListOn_113(JNIEnv* env, jobject obj)
{

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->PickFromListOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractPicker_PickFromListOff_114(JNIEnv* env, jobject obj)
{

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->PickFromListOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractPicker_InitializePickList_115(JNIEnv* env, jobject obj)
{

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializePickList();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractPicker_AddPickList_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddPickList(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractPicker_DeletePickList_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeletePickList(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractPicker_GetPickList_118(JNIEnv* env, jobject obj)
{
  vtkPropCollection * temp20;

  vtkAbstractPicker* op = static_cast<vtkAbstractPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickList();
  return reinterpret_cast<jlong>(temp20);
}
