// java wrapper for vtkFastSplatter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkFastSplatter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkFastSplatter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkFastSplatter",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFastSplatter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFastSplatter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFastSplatter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFastSplatter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFastSplatter_SetModelBounds_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFastSplatter_SetModelBounds_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkFastSplatter_GetModelBounds_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModelBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFastSplatter_SetOutputDimensions_17(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFastSplatter_SetOutputDimensions_18(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputDimensions(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkFastSplatter_GetOutputDimensions_19(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputDimensions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFastSplatter_SetLimitMode_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLimitMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFastSplatter_GetLimitMode_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLimitMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFastSplatter_SetLimitModeToNone_112(JNIEnv* env, jobject obj)
{

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLimitModeToNone();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFastSplatter_SetLimitModeToClamp_113(JNIEnv* env, jobject obj)
{

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLimitModeToClamp();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFastSplatter_SetLimitModeToScale_114(JNIEnv* env, jobject obj)
{

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLimitModeToScale();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFastSplatter_SetLimitModeToFreezeScale_115(JNIEnv* env, jobject obj)
{

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLimitModeToFreezeScale();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFastSplatter_SetMinValue_116(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkFastSplatter_GetMinValue_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFastSplatter_SetMaxValue_118(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaxValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkFastSplatter_GetMaxValue_119(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFastSplatter_GetNumberOfPointsSplatted_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsSplatted();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFastSplatter_SetSplatConnection_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkFastSplatter* op = static_cast<vtkFastSplatter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSplatConnection(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkFastSplatter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkFastSplatter::New());
}
