// java wrapper for vtkDataReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkSimpleReader_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataReader",dType)) { return me; }
  if ((res= vtkSimpleReader_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetFileName_15(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetFileName_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetFileVersion_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileVersion();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetFileMajorVersion_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileMajorVersion();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetFileMinorVersion_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileMinorVersion();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_IsFileValid_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsFileValid(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_IsFileStructuredPoints_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsFileStructuredPoints();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_IsFilePolyData_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsFilePolyData();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_IsFileStructuredGrid_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsFileStructuredGrid();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_IsFileUnstructuredGrid_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsFileUnstructuredGrid();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_IsFileRectilinearGrid_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsFileRectilinearGrid();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetInputString_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputString(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetInputString_117(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetInputString_118(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputString(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetInputStringLength_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputStringLength();
  return temp20;

}

extern "C" JNIEXPORT void JNICALL Java_vtk_vtkDataReader_SetBinaryInputString_120(JNIEnv* env, jobject obj, jbyteArray id0, jint id1)
{
  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  char* data = new char[id1];
  env->GetByteArrayRegion(id0, 0, id1, reinterpret_cast<jbyte*>(&data[0]));
  op->SetBinaryInputString(data, id1);
  delete[] data;
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetInputArray_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCharArray * temp0;
  temp0 = static_cast<vtkCharArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputArray(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataReader_GetInputArray_122(JNIEnv* env, jobject obj)
{
  vtkCharArray * temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetHeader_123(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeader();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetReadFromInputString_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadFromInputString(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetReadFromInputString_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadFromInputString();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadFromInputStringOn_126(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadFromInputStringOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadFromInputStringOff_127(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadFromInputStringOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetFileType_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetNumberOfScalarsInFile_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfScalarsInFile();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetNumberOfVectorsInFile_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfVectorsInFile();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetNumberOfTensorsInFile_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTensorsInFile();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetNumberOfNormalsInFile_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNormalsInFile();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetNumberOfTCoordsInFile_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTCoordsInFile();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetNumberOfFieldDataInFile_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFieldDataInFile();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetScalarsNameInFile_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarsNameInFile(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetVectorsNameInFile_136(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVectorsNameInFile(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetTensorsNameInFile_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTensorsNameInFile(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetNormalsNameInFile_138(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalsNameInFile(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetTCoordsNameInFile_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTCoordsNameInFile(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetFieldDataNameInFile_140(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldDataNameInFile(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetScalarsName_141(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetScalarsName_142(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetVectorsName_143(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVectorsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetVectorsName_144(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVectorsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetTensorsName_145(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTensorsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetTensorsName_146(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTensorsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetNormalsName_147(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetNormalsName_148(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetTCoordsName_149(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTCoordsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetTCoordsName_150(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTCoordsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetLookupTableName_151(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLookupTableName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetLookupTableName_152(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLookupTableName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetFieldDataName_153(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldDataName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataReader_GetFieldDataName_154(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldDataName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetReadAllScalars_155(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadAllScalars(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetReadAllScalars_156(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadAllScalars();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllScalarsOn_157(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllScalarsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllScalarsOff_158(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllScalarsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetReadAllVectors_159(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadAllVectors(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetReadAllVectors_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadAllVectors();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllVectorsOn_161(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllVectorsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllVectorsOff_162(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllVectorsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetReadAllNormals_163(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadAllNormals(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetReadAllNormals_164(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadAllNormals();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllNormalsOn_165(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllNormalsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllNormalsOff_166(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllNormalsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetReadAllTensors_167(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadAllTensors(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetReadAllTensors_168(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadAllTensors();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllTensorsOn_169(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllTensorsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllTensorsOff_170(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllTensorsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetReadAllColorScalars_171(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadAllColorScalars(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetReadAllColorScalars_172(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadAllColorScalars();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllColorScalarsOn_173(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllColorScalarsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllColorScalarsOff_174(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllColorScalarsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetReadAllTCoords_175(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadAllTCoords(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetReadAllTCoords_176(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadAllTCoords();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllTCoordsOn_177(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllTCoordsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllTCoordsOff_178(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllTCoordsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_SetReadAllFields_179(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadAllFields(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_GetReadAllFields_180(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadAllFields();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllFieldsOn_181(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllFieldsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_ReadAllFieldsOff_182(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadAllFieldsOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_OpenVTKFile_183(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->OpenVTKFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadHeader_184(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadHeader(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadCellData_185(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkDataSet * temp0;
  long long   temp1;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadCellData(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadPointData_186(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkDataSet * temp0;
  long long   temp1;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadPointData(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadPointCoordinates_187(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkPointSet * temp0;
  long long   temp1;
  int   temp20;
  temp0 = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadPointCoordinates(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadPointCoordinates_188(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkGraph * temp0;
  long long   temp1;
  int   temp20;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadPointCoordinates(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadVertexData_189(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkGraph * temp0;
  long long   temp1;
  int   temp20;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadVertexData(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadEdgeData_190(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkGraph * temp0;
  long long   temp1;
  int   temp20;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadEdgeData(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadRowData_191(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkTable * temp0;
  long long   temp1;
  int   temp20;
  temp0 = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadRowData(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadCoordinates_192(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkRectilinearGrid * temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadCoordinates(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataReader_ReadArray_193(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jlong id1,jlong id2)
{
  char * temp0;
  long long   temp1;
  long long   temp2;
  vtkAbstractArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadArray(temp0,temp1,temp2);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataReader_ReadFieldData_194(JNIEnv* env, jobject obj,jint id0)
{
  vtkDataReader::FieldType   temp0;
  vtkFieldData * temp20;
  temp0 = static_cast<vtkDataReader::FieldType>(id0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadFieldData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_Read_195(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Read(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataReader_CloseVTKFile_196(JNIEnv* env, jobject obj)
{

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CloseVTKFile();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadLine_197(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadLine(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadTimeDependentMetaData_198(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkInformation * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadTimeDependentMetaData(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadMesh_199(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkDataObject * temp4;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id4));

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadMesh(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadPoints_1100(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkDataObject * temp4;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id4));

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadPoints(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadArrays_1101(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkDataObject * temp4;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id4));

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadArrays(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadMeshSimple_1102(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  std::string temp0;
  vtkDataObject * temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadMeshSimple(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadPointsSimple_1103(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  std::string temp0;
  vtkDataObject * temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadPointsSimple(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataReader_ReadArraysSimple_1104(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  std::string temp0;
  vtkDataObject * temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataReader* op = static_cast<vtkDataReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReadArraysSimple(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDataReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDataReader::New());
}
