// java wrapper for vtkVolumeReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVolumeReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVolumeReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVolumeReader",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeReader_SetFilePrefix_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFilePrefix(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkVolumeReader_GetFilePrefix_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFilePrefix();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeReader_SetFilePattern_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFilePattern(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkVolumeReader_GetFilePattern_17(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFilePattern();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeReader_SetImageRange_18(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeReader_SetImageRange_19(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageRange(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkVolumeReader_GetImageRange_110(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageRange();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeReader_SetDataSpacing_111(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeReader_SetDataSpacing_112(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSpacing(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkVolumeReader_GetDataSpacing_113(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeReader_SetDataOrigin_114(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeReader_SetDataOrigin_115(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkVolumeReader_GetDataOrigin_116(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeReader_GetImage_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkImageData * temp20;
  temp0 = id0;

  vtkVolumeReader* op = static_cast<vtkVolumeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImage(temp0);
  return reinterpret_cast<jlong>(temp20);
}
