// java wrapper for vtkHDFWriter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHDFWriter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWriter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHDFWriter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHDFWriter",dType)) { return me; }
  if ((res= vtkWriter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDFWriter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDFWriter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDFWriter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDFWriter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFWriter_SetController_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMultiProcessController * temp0;
  temp0 = static_cast<vtkMultiProcessController*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetController(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDFWriter_GetController_15(JNIEnv* env, jobject obj)
{
  vtkMultiProcessController * temp20;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetController();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFWriter_SetFileName_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkHDFWriter_GetFileName_17(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFWriter_SetOverwrite_18(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOverwrite(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHDFWriter_GetOverwrite_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOverwrite();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFWriter_SetWriteAllTimeSteps_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWriteAllTimeSteps(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHDFWriter_GetWriteAllTimeSteps_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWriteAllTimeSteps();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFWriter_SetChunkSize_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetChunkSize(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDFWriter_GetChunkSize_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChunkSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFWriter_SetCompressionLevel_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCompressionLevel(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDFWriter_GetCompressionLevelMinValue_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCompressionLevelMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDFWriter_GetCompressionLevelMaxValue_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCompressionLevelMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDFWriter_GetCompressionLevel_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCompressionLevel();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFWriter_SetUseExternalComposite_118(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseExternalComposite(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHDFWriter_GetUseExternalComposite_119(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseExternalComposite();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFWriter_SetUseExternalTimeSteps_120(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseExternalTimeSteps(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHDFWriter_GetUseExternalTimeSteps_121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseExternalTimeSteps();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHDFWriter_SetUseExternalPartitions_122(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseExternalPartitions(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHDFWriter_GetUseExternalPartitions_123(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHDFWriter* op = static_cast<vtkHDFWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseExternalPartitions();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkHDFWriter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkHDFWriter::New());
}
