// java wrapper for vtkSTLReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSTLReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractPolyDataReader_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSTLReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSTLReader",dType)) { return me; }
  if ((res= vtkAbstractPolyDataReader_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSTLReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSTLReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSTLReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSTLReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSTLReader_GetMTime_14(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSTLReader_SetMerging_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMerging(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSTLReader_GetMerging_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMerging();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSTLReader_MergingOn_17(JNIEnv* env, jobject obj)
{

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSTLReader_MergingOff_18(JNIEnv* env, jobject obj)
{

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSTLReader_SetScalarTags_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTags(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSTLReader_GetScalarTags_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarTags();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSTLReader_ScalarTagsOn_111(JNIEnv* env, jobject obj)
{

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarTagsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSTLReader_ScalarTagsOff_112(JNIEnv* env, jobject obj)
{

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarTagsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSTLReader_SetLocator_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIncrementalPointLocator * temp0;
  temp0 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLocator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSTLReader_GetLocator_114(JNIEnv* env, jobject obj)
{
  vtkIncrementalPointLocator * temp20;

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLocator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSTLReader_GetHeader_115(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeader();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSTLReader_GetBinaryHeader_116(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkSTLReader* op = static_cast<vtkSTLReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBinaryHeader();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSTLReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSTLReader::New());
}
