// java wrapper for vtkOutlineSource object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOutlineSource.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOutlineSource_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOutlineSource",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOutlineSource_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOutlineSource_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOutlineSource_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOutlineSource_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOutlineSource_SetBoxType_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBoxType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOutlineSource_GetBoxType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoxType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOutlineSource_SetBoxTypeToAxisAligned_16(JNIEnv* env, jobject obj)
{

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBoxTypeToAxisAligned();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOutlineSource_SetBoxTypeToOriented_17(JNIEnv* env, jobject obj)
{

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBoxTypeToOriented();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOutlineSource_SetBounds_18(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOutlineSource_SetBounds_19(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkOutlineSource_GetBounds_110(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkOutlineSource_GetCorners_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCorners();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 24);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOutlineSource_SetGenerateFaces_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateFaces(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOutlineSource_GenerateFacesOn_113(JNIEnv* env, jobject obj)
{

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateFacesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOutlineSource_GenerateFacesOff_114(JNIEnv* env, jobject obj)
{

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateFacesOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOutlineSource_GetGenerateFaces_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateFaces();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOutlineSource_SetOutputPointsPrecision_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputPointsPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOutlineSource_GetOutputPointsPrecision_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOutlineSource* op = static_cast<vtkOutlineSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPointsPrecision();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOutlineSource_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOutlineSource::New());
}
