// java wrapper for vtkArrayCalculator object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkArrayCalculator.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPassInputTypeAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkArrayCalculator_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkArrayCalculator",dType)) { return me; }
  if ((res= vtkPassInputTypeAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayCalculator_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayCalculator_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayCalculator_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayCalculator_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetFunction_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFunction(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayCalculator_GetFunction_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFunction();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_AddScalarArrayName_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddScalarArrayName(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_AddVectorArrayName_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1,jint id2,jint id3)
{
  char * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddVectorArrayName(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_AddScalarVariable_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1,jint id2)
{
  char * temp0;
  char * temp1;
  int   temp2;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddScalarVariable(temp0,temp1,temp2);
  delete[] temp0;
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_AddVectorVariable_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1,jint id2,jint id3,jint id4)
{
  char * temp0;
  char * temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddVectorVariable(temp0,temp1,temp2,temp3,temp4);
  delete[] temp0;
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_AddCoordinateScalarVariable_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddCoordinateScalarVariable(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_AddCoordinateVectorVariable_111(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1,jint id2,jint id3)
{
  char * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddCoordinateVectorVariable(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetResultArrayName_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResultArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayCalculator_GetResultArrayName_113(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResultArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayCalculator_GetResultArrayType_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResultArrayType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetResultArrayType_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResultArrayType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayCalculator_GetCoordinateResults_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoordinateResults();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetCoordinateResults_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateResults(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_CoordinateResultsOn_118(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->CoordinateResultsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_CoordinateResultsOff_119(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->CoordinateResultsOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArrayCalculator_GetResultNormals_120(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResultNormals();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetResultNormals_121(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResultNormals(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_ResultNormalsOn_122(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResultNormalsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_ResultNormalsOff_123(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResultNormalsOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArrayCalculator_GetResultTCoords_124(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResultTCoords();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetResultTCoords_125(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResultTCoords(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_ResultTCoordsOn_126(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResultTCoordsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_ResultTCoordsOff_127(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResultTCoordsOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayCalculator_GetAttributeTypeAsString_128(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeTypeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetAttributeType_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttributeType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayCalculator_GetAttributeType_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetAttributeTypeToDefault_131(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttributeTypeToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetAttributeTypeToPointData_132(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttributeTypeToPointData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetAttributeTypeToCellData_133(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttributeTypeToCellData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetAttributeTypeToEdgeData_134(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttributeTypeToEdgeData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetAttributeTypeToVertexData_135(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttributeTypeToVertexData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetAttributeTypeToRowData_136(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttributeTypeToRowData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_RemoveAllVariables_137(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllVariables();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_RemoveScalarVariables_138(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveScalarVariables();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_RemoveVectorVariables_139(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveVectorVariables();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_RemoveCoordinateScalarVariables_140(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveCoordinateScalarVariables();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_RemoveCoordinateVectorVariables_141(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveCoordinateVectorVariables();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayCalculator_GetScalarArrayName_142(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarArrayName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayCalculator_GetVectorArrayName_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVectorArrayName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayCalculator_GetScalarVariableName_144(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarVariableName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayCalculator_GetVectorVariableName_145(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVectorVariableName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayCalculator_GetSelectedScalarComponent_146(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedScalarComponent(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayCalculator_GetNumberOfScalarArrays_147(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfScalarArrays();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayCalculator_GetNumberOfVectorArrays_148(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfVectorArrays();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetReplaceInvalidValues_149(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReplaceInvalidValues(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayCalculator_GetReplaceInvalidValues_150(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReplaceInvalidValues();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_ReplaceInvalidValuesOn_151(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReplaceInvalidValuesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_ReplaceInvalidValuesOff_152(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReplaceInvalidValuesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetReplacementValue_153(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReplacementValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkArrayCalculator_GetReplacementValue_154(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReplacementValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetIgnoreMissingArrays_155(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIgnoreMissingArrays(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArrayCalculator_GetIgnoreMissingArrays_156(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIgnoreMissingArrays();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_IgnoreMissingArraysOn_157(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->IgnoreMissingArraysOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_IgnoreMissingArraysOff_158(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->IgnoreMissingArraysOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetFunctionParserType_159(JNIEnv* env, jobject obj,jint id0)
{
  vtkArrayCalculator::FunctionParserTypes   temp0;
  temp0 = static_cast<vtkArrayCalculator::FunctionParserTypes>(id0);

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFunctionParserType(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetFunctionParserTypeToFunctionParser_160(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFunctionParserTypeToFunctionParser();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayCalculator_SetFunctionParserTypeToExprTkFunctionParser_161(JNIEnv* env, jobject obj)
{

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFunctionParserTypeToExprTkFunctionParser();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayCalculator_GetFunctionParserType_162(JNIEnv* env, jobject obj)
{
  vtkArrayCalculator::FunctionParserTypes   temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFunctionParserType();
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayCalculator_GetDataSetOutput_163(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkArrayCalculator* op = static_cast<vtkArrayCalculator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSetOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkArrayCalculator_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkArrayCalculator::New());
}
