// java wrapper for vtkSpanSpace object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSpanSpace.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkScalarTree_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSpanSpace_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSpanSpace",dType)) { return me; }
  if ((res= vtkScalarTree_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSpanSpace_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSpanSpace_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSpanSpace_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSpanSpace_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_ShallowCopy_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkScalarTree * temp0;
  temp0 = static_cast<vtkScalarTree*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_SetScalarRange_15(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_SetScalarRange_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkSpanSpace_GetScalarRange_17(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_SetComputeScalarRange_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComputeScalarRange(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSpanSpace_GetComputeScalarRange_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputeScalarRange();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_ComputeScalarRangeOn_110(JNIEnv* env, jobject obj)
{

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeScalarRangeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_ComputeScalarRangeOff_111(JNIEnv* env, jobject obj)
{

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeScalarRangeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_SetResolution_112(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResolution(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSpanSpace_GetResolutionMinValue_113(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResolutionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSpanSpace_GetResolutionMaxValue_114(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResolutionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSpanSpace_GetResolution_115(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResolution();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_SetComputeResolution_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComputeResolution(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSpanSpace_GetComputeResolution_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputeResolution();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_ComputeResolutionOn_118(JNIEnv* env, jobject obj)
{

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeResolutionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_ComputeResolutionOff_119(JNIEnv* env, jobject obj)
{

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeResolutionOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_SetNumberOfCellsPerBucket_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfCellsPerBucket(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSpanSpace_GetNumberOfCellsPerBucketMinValue_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellsPerBucketMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSpanSpace_GetNumberOfCellsPerBucketMaxValue_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellsPerBucketMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSpanSpace_GetNumberOfCellsPerBucket_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellsPerBucket();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_Initialize_124(JNIEnv* env, jobject obj)
{

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_BuildTree_125(JNIEnv* env, jobject obj)
{

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildTree();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_InitTraversal_126(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitTraversal(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSpanSpace_GetNumberOfCellBatches_127(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  long long   temp20;
  temp0 = id0;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellBatches(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSpanSpace_SetBatchSize_128(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBatchSize(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSpanSpace_GetBatchSizeMinValue_129(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBatchSizeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSpanSpace_GetBatchSizeMaxValue_130(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBatchSizeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSpanSpace_GetBatchSize_131(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkSpanSpace* op = static_cast<vtkSpanSpace*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBatchSize();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSpanSpace_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSpanSpace::New());
}
