// java wrapper for vtkStructuredCellArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkStructuredCellArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractCellArray_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkStructuredCellArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkStructuredCellArray",dType)) { return me; }
  if ((res= vtkAbstractCellArray_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredCellArray_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredCellArray_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredCellArray_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredCellArray_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredCellArray_Initialize_14(JNIEnv* env, jobject obj)
{

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredCellArray_GetNumberOfCells_15(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredCellArray_GetNumberOfOffsets_16(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfOffsets();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredCellArray_GetOffset_17(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffset(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredCellArray_GetNumberOfConnectivityIds_18(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfConnectivityIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredCellArray_SetData_19(JNIEnv* env, jobject obj,jintArray id0,jboolean id1)
{
  int temp0[6];
  bool   temp1;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = (id1 != 0) ? true : false;

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetData(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStructuredCellArray_IsStorageShareable_110(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsStorageShareable();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredCellArray_IsHomogeneous_111(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsHomogeneous();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredCellArray_GetCellAtId_112(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellAtId(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredCellArray_GetCellAtId_113(JNIEnv* env, jobject obj,jintArray id0,jobject id1)
{
  int temp0[3];
  vtkIdList * temp1;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellAtId(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredCellArray_GetCellSize_114(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredCellArray_GetMaxCellSize_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxCellSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredCellArray_DeepCopy_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractCellArray * temp0;
  temp0 = static_cast<vtkAbstractCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredCellArray_ShallowCopy_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractCellArray * temp0;
  temp0 = static_cast<vtkAbstractCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStructuredCellArray* op = static_cast<vtkStructuredCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkStructuredCellArray_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkStructuredCellArray::New());
}
