// java wrapper for vtkDataAssemblyUtilities object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataAssemblyUtilities.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataAssemblyUtilities_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataAssemblyUtilities",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssemblyUtilities_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssemblyUtilities* op = static_cast<vtkDataAssemblyUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssemblyUtilities_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssemblyUtilities* op = static_cast<vtkDataAssemblyUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataAssemblyUtilities_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssemblyUtilities* op = static_cast<vtkDataAssemblyUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataAssemblyUtilities_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssemblyUtilities* op = static_cast<vtkDataAssemblyUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataAssemblyUtilities_HierarchyName_14(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDataAssemblyUtilities* op = static_cast<vtkDataAssemblyUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HierarchyName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataAssemblyUtilities_GenerateHierarchy_15(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkCompositeDataSet * temp0;
  vtkDataAssembly * temp1;
  vtkPartitionedDataSetCollection * temp2;
  bool   temp20;
  temp0 = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkPartitionedDataSetCollection*>(vtkJavaGetPointerFromObject(env, id2));

  vtkDataAssemblyUtilities* op = static_cast<vtkDataAssemblyUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GenerateHierarchy(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataAssemblyUtilities_GetSelectorForCompositeId_16(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
   unsigned int   temp0;
  vtkDataAssembly * temp1;
  std::string   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataAssemblyUtilities* op = static_cast<vtkDataAssemblyUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectorForCompositeId(temp0,temp1);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDataAssemblyUtilities_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDataAssemblyUtilities::New());
}
