// java wrapper for vtkInformation object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkInformation.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkInformation_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkInformation",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Modified_14(JNIEnv* env, jobject obj)
{

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Modified();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Modified_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationKey * temp0;
  temp0 = static_cast<vtkInformationKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Modified(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Clear_16(JNIEnv* env, jobject obj)
{

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clear();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_GetNumberOfKeys_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfKeys();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Copy_18(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformation * temp0;
  int   temp1;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Copy(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_19(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformation * temp0;
  int   temp1;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_110(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_111(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationDataObjectKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationDataObjectKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_112(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationDoubleVectorKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationDoubleVectorKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_113(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationVariantKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationVariantKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_114(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationVariantVectorKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationVariantVectorKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_115(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationInformationKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationInformationKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_116(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationInformationVectorKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationInformationVectorKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_117(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationIntegerKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationIntegerKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_118(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationIntegerVectorKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationIntegerVectorKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_119(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationObjectBaseVectorKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationObjectBaseVectorKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_120(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationRequestKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationRequestKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_121(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationStringKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationStringKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_122(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationStringVectorKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationStringVectorKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntry_123(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationUnsignedLongKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationUnsignedLongKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntry(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_CopyEntries_124(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformation * temp0;
  vtkInformationKeyVectorKey * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEntries(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationKey * temp0;
  temp0 = static_cast<vtkInformationKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationRequestKey * temp0;
  temp0 = static_cast<vtkInformationRequestKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationRequestKey * temp0;
  temp0 = static_cast<vtkInformationRequestKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationRequestKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationRequestKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_130(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationIntegerKey * temp0;
  int   temp1;
  temp0 = static_cast<vtkInformationIntegerKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Get_131(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIntegerKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationIntegerKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Get(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIntegerKey * temp0;
  temp0 = static_cast<vtkInformationIntegerKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_133(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIntegerKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationIntegerKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_134(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkInformationIdTypeKey * temp0;
  long long   temp1;
  temp0 = static_cast<vtkInformationIdTypeKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_Get_135(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIdTypeKey * temp0;
  long long   temp20;
  temp0 = static_cast<vtkInformationIdTypeKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Get(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_136(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIdTypeKey * temp0;
  temp0 = static_cast<vtkInformationIdTypeKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_137(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIdTypeKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationIdTypeKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_138(JNIEnv* env, jobject obj,jobject id0,jdouble id1)
{
  vtkInformationDoubleKey * temp0;
  double   temp1;
  temp0 = static_cast<vtkInformationDoubleKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkInformation_Get_139(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationDoubleKey * temp0;
  double   temp20;
  temp0 = static_cast<vtkInformationDoubleKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Get(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_140(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationDoubleKey * temp0;
  temp0 = static_cast<vtkInformationDoubleKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_141(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationDoubleKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationDoubleKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationVariantKey * temp0;
  temp0 = static_cast<vtkInformationVariantKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_143(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationVariantKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationVariantKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_144(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationIntegerVectorKey * temp0;
  int   temp1;
  temp0 = static_cast<vtkInformationIntegerVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_145(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2,jint id3)
{
  vtkInformationIntegerVectorKey * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = static_cast<vtkInformationIntegerVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_146(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2,jint id3,jint id4,jint id5,jint id6)
{
  vtkInformationIntegerVectorKey * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  int   temp6;
  temp0 = static_cast<vtkInformationIntegerVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1,temp2,temp3,temp4,temp5,temp6);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Get_147(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationIntegerVectorKey * temp0;
  int   temp1;
  int   temp20;
  temp0 = static_cast<vtkInformationIntegerVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Get(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Length_148(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIntegerVectorKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationIntegerVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Length(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_149(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIntegerVectorKey * temp0;
  temp0 = static_cast<vtkInformationIntegerVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_150(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIntegerVectorKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationIntegerVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_151(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1)
{
  vtkInformationStringVectorKey * temp0;
  char * temp1;
  temp0 = static_cast<vtkInformationStringVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_152(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1,jint id2)
{
  vtkInformationStringVectorKey * temp0;
  char * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformationStringVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1,temp2);
  delete[] temp1;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkInformation_Get_153(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationStringVectorKey * temp0;
  int   temp1;
  const char * temp20;
  temp0 = static_cast<vtkInformationStringVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Get(temp0,temp1);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Length_154(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationStringVectorKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationStringVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Length(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_155(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationStringVectorKey * temp0;
  temp0 = static_cast<vtkInformationStringVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_156(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationStringVectorKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationStringVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Length_157(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIntegerPointerKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationIntegerPointerKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Length(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_158(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIntegerPointerKey * temp0;
  temp0 = static_cast<vtkInformationIntegerPointerKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_159(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIntegerPointerKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationIntegerPointerKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_160(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkInformationUnsignedLongKey * temp0;
   unsigned long   temp1;
  temp0 = static_cast<vtkInformationUnsignedLongKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_Get_161(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationUnsignedLongKey * temp0;
   unsigned long   temp20;
  temp0 = static_cast<vtkInformationUnsignedLongKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Get(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_162(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationUnsignedLongKey * temp0;
  temp0 = static_cast<vtkInformationUnsignedLongKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_163(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationUnsignedLongKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationUnsignedLongKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_164(JNIEnv* env, jobject obj,jobject id0,jdouble id1)
{
  vtkInformationDoubleVectorKey * temp0;
  double   temp1;
  temp0 = static_cast<vtkInformationDoubleVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_165(JNIEnv* env, jobject obj,jobject id0,jdouble id1,jdouble id2,jdouble id3)
{
  vtkInformationDoubleVectorKey * temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = static_cast<vtkInformationDoubleVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_166(JNIEnv* env, jobject obj,jobject id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6)
{
  vtkInformationDoubleVectorKey * temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  temp0 = static_cast<vtkInformationDoubleVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1,temp2,temp3,temp4,temp5,temp6);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkInformation_Get_167(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationDoubleVectorKey * temp0;
  int   temp1;
  double   temp20;
  temp0 = static_cast<vtkInformationDoubleVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Get(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Length_168(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationDoubleVectorKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationDoubleVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Length(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_169(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationDoubleVectorKey * temp0;
  temp0 = static_cast<vtkInformationDoubleVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_170(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationDoubleVectorKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationDoubleVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Length_171(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationVariantVectorKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationVariantVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Length(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_172(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationVariantVectorKey * temp0;
  temp0 = static_cast<vtkInformationVariantVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_173(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationVariantVectorKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationVariantVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_174(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_AppendUnique_175(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendUnique(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_176(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_Get_177(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationKeyVectorKey * temp0;
  int   temp1;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Get(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Length_178(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationKeyVectorKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Length(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_179(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationKeyVectorKey * temp0;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_180(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationKeyVectorKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_181(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationDataObjectKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationDataObjectKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_182(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationDoubleKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationDoubleKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_183(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationDoubleVectorKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationDoubleVectorKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_184(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationInformationKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationInformationKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_185(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationInformationVectorKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationInformationVectorKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_186(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationIntegerKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationIntegerKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_187(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationIntegerVectorKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationIntegerVectorKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_188(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationStringKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationStringKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_189(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationStringVectorKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationStringVectorKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_190(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationObjectBaseKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationObjectBaseKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_191(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationUnsignedLongKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationUnsignedLongKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_AppendUnique_192(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationDataObjectKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationDataObjectKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendUnique(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_AppendUnique_193(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationDoubleKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationDoubleKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendUnique(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_AppendUnique_194(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationDoubleVectorKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationDoubleVectorKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendUnique(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_AppendUnique_195(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationInformationKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationInformationKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendUnique(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_AppendUnique_196(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationInformationVectorKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationInformationVectorKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendUnique(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_AppendUnique_197(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationIntegerKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationIntegerKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendUnique(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_AppendUnique_198(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationIntegerVectorKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationIntegerVectorKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendUnique(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_AppendUnique_199(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationStringKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationStringKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendUnique(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_AppendUnique_1100(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationStringVectorKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationStringVectorKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendUnique(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_AppendUnique_1101(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationObjectBaseKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationObjectBaseKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendUnique(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_AppendUnique_1102(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationKeyVectorKey * temp0;
  vtkInformationUnsignedLongKey * temp1;
  temp0 = static_cast<vtkInformationKeyVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationUnsignedLongKey*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendUnique(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_1103(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1)
{
  vtkInformationStringKey * temp0;
  char * temp1;
  temp0 = static_cast<vtkInformationStringKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkInformation_Get_1104(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationStringKey * temp0;
  const char * temp20;
  temp0 = static_cast<vtkInformationStringKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Get(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_1105(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationStringKey * temp0;
  temp0 = static_cast<vtkInformationStringKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_1106(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationStringKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationStringKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_1107(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationInformationKey * temp0;
  vtkInformation * temp1;
  temp0 = static_cast<vtkInformationInformationKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_Get_1108(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationInformationKey * temp0;
  vtkInformation * temp20;
  temp0 = static_cast<vtkInformationInformationKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Get(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_1109(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationInformationKey * temp0;
  temp0 = static_cast<vtkInformationInformationKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_1110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationInformationKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationInformationKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_1111(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationInformationVectorKey * temp0;
  vtkInformationVector * temp1;
  temp0 = static_cast<vtkInformationInformationVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_Get_1112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationInformationVectorKey * temp0;
  vtkInformationVector * temp20;
  temp0 = static_cast<vtkInformationInformationVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Get(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_1113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationInformationVectorKey * temp0;
  temp0 = static_cast<vtkInformationInformationVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_1114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationInformationVectorKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationInformationVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_1115(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationObjectBaseKey * temp0;
  vtkObjectBase * temp1;
  temp0 = static_cast<vtkInformationObjectBaseKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_Get_1116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationObjectBaseKey * temp0;
  vtkObjectBase * temp20;
  temp0 = static_cast<vtkInformationObjectBaseKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Get(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_1117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationObjectBaseKey * temp0;
  temp0 = static_cast<vtkInformationObjectBaseKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_1118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationObjectBaseKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationObjectBaseKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Append_1119(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationObjectBaseVectorKey * temp0;
  vtkObjectBase * temp1;
  temp0 = static_cast<vtkInformationObjectBaseVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Set_1120(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2)
{
  vtkInformationObjectBaseVectorKey * temp0;
  vtkObjectBase * temp1;
  int   temp2;
  temp0 = static_cast<vtkInformationObjectBaseVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Set(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_Get_1121(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationObjectBaseVectorKey * temp0;
  int   temp1;
  vtkObjectBase * temp20;
  temp0 = static_cast<vtkInformationObjectBaseVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Get(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Length_1122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationObjectBaseVectorKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationObjectBaseVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Length(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_1123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationObjectBaseVectorKey * temp0;
  temp0 = static_cast<vtkInformationObjectBaseVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_1124(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformationObjectBaseVectorKey * temp0;
  vtkObjectBase * temp1;
  temp0 = static_cast<vtkInformationObjectBaseVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, id1));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_1125(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationObjectBaseVectorKey * temp0;
  int   temp1;
  temp0 = static_cast<vtkInformationObjectBaseVectorKey*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_1126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationObjectBaseVectorKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationObjectBaseVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_Remove_1127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationDataObjectKey * temp0;
  temp0 = static_cast<vtkInformationDataObjectKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->Remove(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInformation_Has_1128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationDataObjectKey * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformationDataObjectKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Has(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationDataObjectKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationDataObjectKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationDoubleKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationDoubleKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1131(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationDoubleVectorKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationDoubleVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationInformationKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationInformationKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1133(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationInformationVectorKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationInformationVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1134(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIntegerKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationIntegerKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1135(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationIntegerVectorKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationIntegerVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1136(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationRequestKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationRequestKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1137(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationStringKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationStringKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1138(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationStringVectorKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationStringVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1139(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1140(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationUnsignedLongKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationUnsignedLongKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1141(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationVariantKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationVariantKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetKey_1142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationVariantVectorKey * temp0;
  vtkInformationKey * temp20;
  temp0 = static_cast<vtkInformationVariantVectorKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKey(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkInformation_UsesGarbageCollector_1143(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UsesGarbageCollector();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInformation_SetRequest_1144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformationRequestKey * temp0;
  temp0 = static_cast<vtkInformationRequestKey*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequest(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInformation_GetRequest_1145(JNIEnv* env, jobject obj)
{
  vtkInformationRequestKey * temp20;

  vtkInformation* op = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequest();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkInformation_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkInformation::New());
}
