// java wrapper for vtkFloatArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkFloatArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataArray_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkFloatArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkFloatArray",dType)) { return me; }
  if ((res= vtkDataArray_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}

// Array conversion routines
extern "C" JNIEXPORT jfloatArray JNICALL Java_vtk_vtkFloatArray_GetJavaArray_10(JNIEnv* env, jobject obj)
{
  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  float* buffer = op->GetPointer(0);
  return vtkJavaMakeJArrayOfFloat(env, reinterpret_cast<jfloat*>(buffer), op->GetSize());
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFloatArray_SetJavaArray_10(JNIEnv* env, jobject obj, jfloatArray id0, jint len0)
{
  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfTuples(len0 / op->GetNumberOfComponents());
  float* buffer = op->GetPointer(0);
  env->GetFloatArrayRegion(id0, 0, len0, reinterpret_cast<jfloat*>(buffer));
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFloatArray_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFloatArray_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFloatArray_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFloatArray_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFloatArray_ExtendedNew_14(JNIEnv* env, jobject obj)
{
  vtkFloatArray * temp20;

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFloatArray_GetDataType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataType();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkFloatArray_GetValue_16(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  float   temp20;
  temp0 = id0;

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkFloatArray_GetValueRange_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  float * temp20;
  temp0 = id0;

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValueRange(temp0);
  return vtkJavaMakeJArrayOfFloat(env, temp20, 2);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkFloatArray_GetValueRange_18(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValueRange();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFloatArray_SetValue_19(JNIEnv* env, jobject obj,jlong id0,jfloat id1)
{
  long long   temp0;
  float   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkFloatArray_SetNumberOfValues_110(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNumberOfValues(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFloatArray_InsertValue_111(JNIEnv* env, jobject obj,jlong id0,jfloat id1)
{
  long long   temp0;
  float   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertValue(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFloatArray_InsertNextValue_112(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  long long   temp20;
  temp0 = id0;

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFloatArray_FastDownCast_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  vtkFloatArray * temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FastDownCast(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkFloatArray_GetDataTypeValueMin_114(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMin();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkFloatArray_GetDataTypeValueMax_115(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkFloatArray* op = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMax();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkFloatArray_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkFloatArray::New());
}
