// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#ifndef vtkRenderingMatplotlibObjectFactory_h
#define vtkRenderingMatplotlibObjectFactory_h

#include "vtkRenderingMatplotlibModule.h" // For export macro
#include "vtkObjectFactory.h"

VTK_ABI_NAMESPACE_BEGIN

class VTKRENDERINGMATPLOTLIB_EXPORT vtkRenderingMatplotlibObjectFactory : public vtkObjectFactory
{
public:
  static vtkRenderingMatplotlibObjectFactory * New();
  vtkTypeMacro(vtkRenderingMatplotlibObjectFactory, vtkObjectFactory);

  const char * GetDescription() VTK_FUTURE_CONST override { return "vtkRenderingMatplotlib factory overrides."; }

  const char * GetVTKSourceVersion() VTK_FUTURE_CONST override;

  void PrintSelf(ostream &os, vtkIndent indent) override;

protected:
  vtkRenderingMatplotlibObjectFactory();

private:
  vtkRenderingMatplotlibObjectFactory(const vtkRenderingMatplotlibObjectFactory&) = delete;
  void operator=(const vtkRenderingMatplotlibObjectFactory&) = delete;
};

VTK_ABI_NAMESPACE_END

#endif // vtkRenderingMatplotlibObjectFactory_h
