// python wrapper for vtkGDALVectorReader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkGDALVectorReader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkGDALVectorReader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGDALVectorReader_ClassNew(); }


static PyObject *
PyvtkGDALVectorReader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGDALVectorReader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGDALVectorReader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGDALVectorReader *tempr = vtkGDALVectorReader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGDALVectorReader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGDALVectorReader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGDALVectorReader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGDALVectorReader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkGDALVectorReader::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkGDALVectorReader::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_GetNumberOfLayers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfLayers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfLayers() :
      op->vtkGDALVectorReader::GetNumberOfLayers());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_GetLayerType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLayerType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  int temp0 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    int tempr = (ap.IsBound() ?
      op->GetLayerType(temp0) :
      op->vtkGDALVectorReader::GetLayerType(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_GetFeatureCount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFeatureCount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  int temp0 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    int tempr = (ap.IsBound() ?
      op->GetFeatureCount(temp0) :
      op->vtkGDALVectorReader::GetFeatureCount(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_GetActiveLayerType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveLayerType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetActiveLayerType() :
      op->vtkGDALVectorReader::GetActiveLayerType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_GetActiveLayerFeatureCount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveLayerFeatureCount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetActiveLayerFeatureCount() :
      op->vtkGDALVectorReader::GetActiveLayerFeatureCount());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_SetActiveLayer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActiveLayer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActiveLayer(temp0);
    }
    else
    {
      op->vtkGDALVectorReader::SetActiveLayer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_GetActiveLayer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveLayer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetActiveLayer() :
      op->vtkGDALVectorReader::GetActiveLayer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_SetAppendFeatures(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAppendFeatures");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAppendFeatures(temp0);
    }
    else
    {
      op->vtkGDALVectorReader::SetAppendFeatures(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_GetAppendFeatures(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAppendFeatures");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAppendFeatures() :
      op->vtkGDALVectorReader::GetAppendFeatures());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_AppendFeaturesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AppendFeaturesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AppendFeaturesOn();
    }
    else
    {
      op->vtkGDALVectorReader::AppendFeaturesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_AppendFeaturesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AppendFeaturesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AppendFeaturesOff();
    }
    else
    {
      op->vtkGDALVectorReader::AppendFeaturesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_GetLayerProjection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLayerProjection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetLayerProjection(temp0) :
      op->vtkGDALVectorReader::GetLayerProjection(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_GetLayerProjectionAsProj4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLayerProjectionAsProj4");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetLayerProjectionAsProj4(temp0) :
      op->vtkGDALVectorReader::GetLayerProjectionAsProj4(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_SetAddFeatureIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAddFeatureIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAddFeatureIds(temp0);
    }
    else
    {
      op->vtkGDALVectorReader::SetAddFeatureIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_GetAddFeatureIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAddFeatureIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAddFeatureIds() :
      op->vtkGDALVectorReader::GetAddFeatureIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_AddFeatureIdsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddFeatureIdsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AddFeatureIdsOn();
    }
    else
    {
      op->vtkGDALVectorReader::AddFeatureIdsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALVectorReader_AddFeatureIdsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddFeatureIdsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALVectorReader *op = static_cast<vtkGDALVectorReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AddFeatureIdsOff();
    }
    else
    {
      op->vtkGDALVectorReader::AddFeatureIdsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGDALVectorReader_Methods[] = {
  {"IsTypeOf", PyvtkGDALVectorReader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGDALVectorReader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGDALVectorReader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkGDALVectorReader\nC++: static vtkGDALVectorReader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGDALVectorReader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkGDALVectorReader\nC++: vtkGDALVectorReader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGDALVectorReader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGDALVectorReader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetFileName", PyvtkGDALVectorReader_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\n"},
  {"GetFileName", PyvtkGDALVectorReader_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"GetNumberOfLayers", PyvtkGDALVectorReader_GetNumberOfLayers, METH_VARARGS,
   "GetNumberOfLayers(self) -> int\nC++: int GetNumberOfLayers()\n\nReturn number of layers.\n"},
  {"GetLayerType", PyvtkGDALVectorReader_GetLayerType, METH_VARARGS,
   "GetLayerType(self, layerIndex:int=0) -> int\nC++: int GetLayerType(int layerIndex=0)\n\nGiven a index return layer type (eg point, line, polygon).\n"},
  {"GetFeatureCount", PyvtkGDALVectorReader_GetFeatureCount, METH_VARARGS,
   "GetFeatureCount(self, layerIndex:int=0) -> int\nC++: int GetFeatureCount(int layerIndex=0)\n\nGiven a layer index return number of features (shapes).\n"},
  {"GetActiveLayerType", PyvtkGDALVectorReader_GetActiveLayerType, METH_VARARGS,
   "GetActiveLayerType(self) -> int\nC++: int GetActiveLayerType()\n\nReturn the active layer type (eg point, line, polygon).\n"},
  {"GetActiveLayerFeatureCount", PyvtkGDALVectorReader_GetActiveLayerFeatureCount, METH_VARARGS,
   "GetActiveLayerFeatureCount(self) -> int\nC++: int GetActiveLayerFeatureCount()\n\nReturn the number of features in the active layer (shapes).\n"},
  {"SetActiveLayer", PyvtkGDALVectorReader_SetActiveLayer, METH_VARARGS,
   "SetActiveLayer(self, _arg:int) -> None\nC++: virtual void SetActiveLayer(int _arg)\n\nSet and Get the active layer. If ActiveLayer is less than 0 (the\ndefault is -1), then all layers are read. Otherwise, only the\nspecified layer is read.\n"},
  {"GetActiveLayer", PyvtkGDALVectorReader_GetActiveLayer, METH_VARARGS,
   "GetActiveLayer(self) -> int\nC++: virtual int GetActiveLayer()\n\n"},
  {"SetAppendFeatures", PyvtkGDALVectorReader_SetAppendFeatures, METH_VARARGS,
   "SetAppendFeatures(self, _arg:int) -> None\nC++: virtual void SetAppendFeatures(int _arg)\n\nSet and Get whether features are appended to a single\nvtkPolyData. Turning the option on is useful when a shapefile has\na number of features which could otherwise lead to a huge\nmultiblock structure.\n"},
  {"GetAppendFeatures", PyvtkGDALVectorReader_GetAppendFeatures, METH_VARARGS,
   "GetAppendFeatures(self) -> int\nC++: virtual int GetAppendFeatures()\n\n"},
  {"AppendFeaturesOn", PyvtkGDALVectorReader_AppendFeaturesOn, METH_VARARGS,
   "AppendFeaturesOn(self) -> None\nC++: virtual void AppendFeaturesOn()\n\n"},
  {"AppendFeaturesOff", PyvtkGDALVectorReader_AppendFeaturesOff, METH_VARARGS,
   "AppendFeaturesOff(self) -> None\nC++: virtual void AppendFeaturesOff()\n\n"},
  {"GetLayerProjection", PyvtkGDALVectorReader_GetLayerProjection, METH_VARARGS,
   "GetLayerProjection(self, layerIndex:int) -> str\nC++: const char *GetLayerProjection(int layerIndex)\n\nReturn projection string belonging to a layer in WKT format.\n"},
  {"GetLayerProjectionAsProj4", PyvtkGDALVectorReader_GetLayerProjectionAsProj4, METH_VARARGS,
   "GetLayerProjectionAsProj4(self, layerIndex:int) -> str\nC++: const char *GetLayerProjectionAsProj4(int layerIndex)\n\nReturn projection string belonging to a layer in PROJ.4 format\n\note The returned string has to be deleted (via delete[]) by the\ncalling program.\n"},
  {"SetAddFeatureIds", PyvtkGDALVectorReader_SetAddFeatureIds, METH_VARARGS,
   "SetAddFeatureIds(self, _arg:int) -> None\nC++: virtual void SetAddFeatureIds(int _arg)\n\nSet/get whether feature IDs should be generated. Some GDAL\nprimitives (e.g., a polygon with a hole in its interior) are\nrepresented by multiple VTK cells. If you wish to identify the\nprimitive responsible for a VTK cell, turn this on. It is off by\ndefault for backwards compatibility. The array of feature IDs\nwill be the active cell-data pedigree IDs.\n"},
  {"GetAddFeatureIds", PyvtkGDALVectorReader_GetAddFeatureIds, METH_VARARGS,
   "GetAddFeatureIds(self) -> int\nC++: virtual int GetAddFeatureIds()\n\n"},
  {"AddFeatureIdsOn", PyvtkGDALVectorReader_AddFeatureIdsOn, METH_VARARGS,
   "AddFeatureIdsOn(self) -> None\nC++: virtual void AddFeatureIdsOn()\n\n"},
  {"AddFeatureIdsOff", PyvtkGDALVectorReader_AddFeatureIdsOff, METH_VARARGS,
   "AddFeatureIdsOff(self) -> None\nC++: virtual void AddFeatureIdsOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGDALVectorReader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALVectorReader_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGDALVectorReader_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGDALVectorReader_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_layer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALVectorReader_GetActiveLayer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGDALVectorReader_SetActiveLayer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGDALVectorReader_SetActiveLayer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetActiveLayer/SetActiveLayer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("append_features"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALVectorReader_GetAppendFeatures(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGDALVectorReader_SetAppendFeatures(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGDALVectorReader_SetAppendFeatures(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAppendFeatures/SetAppendFeatures\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("add_feature_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALVectorReader_GetAddFeatureIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGDALVectorReader_SetAddFeatureIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGDALVectorReader_SetAddFeatureIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAddFeatureIds/SetAddFeatureIds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_layer_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALVectorReader_GetActiveLayerType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveLayerType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_layer_feature_count"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALVectorReader_GetActiveLayerFeatureCount(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveLayerFeatureCount\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_layers"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALVectorReader_GetNumberOfLayers(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfLayers\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGDALVectorReader_Doc =
  "vtkGDALVectorReader - Read vector file formats using GDAL.\n\n"
  "Superclass: vtkMultiBlockDataSetAlgorithm\n\n"
  "vtkGDALVectorReader is a source object that reads vector files and\n"
  "uses GDAL as the underlying library for the task. GDAL is required\n"
  "for this reader. The output of the reader is a vtkMultiBlockDataSet\n\n"
  "This filter uses the ActiveLayer member to only load entries from the\n"
  "specified layer (when ActiveLayer >= 0).\n\n"
  "@sa\n"
  "vtkMultiBlockDataSet\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGDALVectorReader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOGDAL.vtkGDALVectorReader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGDALVectorReader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkGDALVectorReader_StaticNew()
{
  return vtkGDALVectorReader::New();
}

PyObject *PyvtkGDALVectorReader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGDALVectorReader_Type, PyvtkGDALVectorReader_Methods,
    "vtkGDALVectorReader",
 &PyvtkGDALVectorReader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkMultiBlockDataSetAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGDALVectorReader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkGDALVectorReader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkGDALVectorReader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkGDALVectorReader", o) != 0)
  {
    Py_DECREF(o);
  }

}

