// python wrapper for vtkFidesWriter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkFidesWriter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkFidesWriter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkFidesWriter_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkFidesWriter_EngineTypes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOFides.vtkFidesWriter.EngineTypes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkFidesWriter_EngineTypes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkFidesWriter_EngineTypes_Type, static_cast<int>(val));
}


static PyObject *
PyvtkFidesWriter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkFidesWriter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkFidesWriter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkFidesWriter *tempr = vtkFidesWriter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkFidesWriter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkFidesWriter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkFidesWriter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkFidesWriter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkFidesWriter::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkFidesWriter::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_SetChooseFieldsToWrite(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChooseFieldsToWrite");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChooseFieldsToWrite(temp0);
    }
    else
    {
      op->vtkFidesWriter::SetChooseFieldsToWrite(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_GetChooseFieldsToWrite(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetChooseFieldsToWrite");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetChooseFieldsToWrite() :
      op->vtkFidesWriter::GetChooseFieldsToWrite());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_ChooseFieldsToWriteOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ChooseFieldsToWriteOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ChooseFieldsToWriteOn();
    }
    else
    {
      op->vtkFidesWriter::ChooseFieldsToWriteOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_ChooseFieldsToWriteOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ChooseFieldsToWriteOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ChooseFieldsToWriteOff();
    }
    else
    {
      op->vtkFidesWriter::ChooseFieldsToWriteOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_GetArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetArraySelection(temp0) :
      op->vtkFidesWriter::GetArraySelection(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_GetPointDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetPointDataArraySelection() :
      op->vtkFidesWriter::GetPointDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_GetCellDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetCellDataArraySelection() :
      op->vtkFidesWriter::GetCellDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_GetFieldDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetFieldDataArraySelection() :
      op->vtkFidesWriter::GetFieldDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_SetTimeStepRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeStepRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTimeStepRange(temp0, temp1);
    }
    else
    {
      op->vtkFidesWriter::SetTimeStepRange(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkFidesWriter_SetTimeStepRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeStepRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetTimeStepRange(temp0);
    }
    else
    {
      op->vtkFidesWriter::SetTimeStepRange(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkFidesWriter_SetTimeStepRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkFidesWriter_SetTimeStepRange_s1(self, args);
    case 1:
      return PyvtkFidesWriter_SetTimeStepRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTimeStepRange");
  return nullptr;
}


static PyObject *
PyvtkFidesWriter_GetTimeStepRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStepRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetTimeStepRange() :
      op->vtkFidesWriter::GetTimeStepRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_SetTimeStepStride(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeStepStride");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTimeStepStride(temp0);
    }
    else
    {
      op->vtkFidesWriter::SetTimeStepStride(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_GetTimeStepStrideMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStepStrideMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeStepStrideMinValue() :
      op->vtkFidesWriter::GetTimeStepStrideMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_GetTimeStepStrideMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStepStrideMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeStepStrideMaxValue() :
      op->vtkFidesWriter::GetTimeStepStrideMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_GetTimeStepStride(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStepStride");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeStepStride() :
      op->vtkFidesWriter::GetTimeStepStride());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_SetEngine(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEngine");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEngine(temp0);
    }
    else
    {
      op->vtkFidesWriter::SetEngine(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_GetEngine(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEngine");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetEngine() :
      op->vtkFidesWriter::GetEngine());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkFidesWriter::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesWriter_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesWriter *op = static_cast<vtkFidesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkFidesWriter::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkFidesWriter_Methods[] = {
  {"IsTypeOf", PyvtkFidesWriter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkFidesWriter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkFidesWriter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkFidesWriter\nC++: static vtkFidesWriter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkFidesWriter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkFidesWriter\nC++: vtkFidesWriter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkFidesWriter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkFidesWriter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetFileName", PyvtkFidesWriter_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\nSet/Get the filename to be written.\n"},
  {"GetFileName", PyvtkFidesWriter_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"SetChooseFieldsToWrite", PyvtkFidesWriter_SetChooseFieldsToWrite, METH_VARARGS,
   "SetChooseFieldsToWrite(self, _arg:bool) -> None\nC++: virtual void SetChooseFieldsToWrite(bool _arg)\n\nChoose which fields to write. If this is true, then only the\narrays selected will be written. If this is false, then all\narrays will be written.\n\nThe default is false.\n"},
  {"GetChooseFieldsToWrite", PyvtkFidesWriter_GetChooseFieldsToWrite, METH_VARARGS,
   "GetChooseFieldsToWrite(self) -> bool\nC++: virtual bool GetChooseFieldsToWrite()\n\n"},
  {"ChooseFieldsToWriteOn", PyvtkFidesWriter_ChooseFieldsToWriteOn, METH_VARARGS,
   "ChooseFieldsToWriteOn(self) -> None\nC++: virtual void ChooseFieldsToWriteOn()\n\n"},
  {"ChooseFieldsToWriteOff", PyvtkFidesWriter_ChooseFieldsToWriteOff, METH_VARARGS,
   "ChooseFieldsToWriteOff(self) -> None\nC++: virtual void ChooseFieldsToWriteOff()\n\n"},
  {"GetArraySelection", PyvtkFidesWriter_GetArraySelection, METH_VARARGS,
   "GetArraySelection(self, association:int) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetArraySelection(int association)\n\nReturns the array selection object for point, cell, or field\ndata.\n"},
  {"GetPointDataArraySelection", PyvtkFidesWriter_GetPointDataArraySelection, METH_VARARGS,
   "GetPointDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetPointDataArraySelection()\n\n"},
  {"GetCellDataArraySelection", PyvtkFidesWriter_GetCellDataArraySelection, METH_VARARGS,
   "GetCellDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetCellDataArraySelection()\n\n"},
  {"GetFieldDataArraySelection", PyvtkFidesWriter_GetFieldDataArraySelection, METH_VARARGS,
   "GetFieldDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetFieldDataArraySelection()\n\n"},
  {"SetTimeStepRange", PyvtkFidesWriter_SetTimeStepRange, METH_VARARGS,
   "SetTimeStepRange(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetTimeStepRange(int _arg1, int _arg2)\nSetTimeStepRange(self, _arg:(int, int)) -> None\nC++: void SetTimeStepRange(const int _arg[2])\n\n`TimeStepRange` and `TimeStepStride` can be used to limit which\ntimesteps will be written.\n\nIf the range is invalid, i.e. `TimeStepRange[0] >=\nTimeStepRange[1]`, it's assumed that no TimeStepRange overrides\nhave been specified and both TimeStepRange and TimeStepStride\nwill be ignored. When valid, only the chosen subset of files will\nbe processed.\n"},
  {"GetTimeStepRange", PyvtkFidesWriter_GetTimeStepRange, METH_VARARGS,
   "GetTimeStepRange(self) -> (int, int)\nC++: virtual int *GetTimeStepRange()\n\n"},
  {"SetTimeStepStride", PyvtkFidesWriter_SetTimeStepStride, METH_VARARGS,
   "SetTimeStepStride(self, _arg:int) -> None\nC++: virtual void SetTimeStepStride(int _arg)\n\n"},
  {"GetTimeStepStrideMinValue", PyvtkFidesWriter_GetTimeStepStrideMinValue, METH_VARARGS,
   "GetTimeStepStrideMinValue(self) -> int\nC++: virtual int GetTimeStepStrideMinValue()\n\n"},
  {"GetTimeStepStrideMaxValue", PyvtkFidesWriter_GetTimeStepStrideMaxValue, METH_VARARGS,
   "GetTimeStepStrideMaxValue(self) -> int\nC++: virtual int GetTimeStepStrideMaxValue()\n\n"},
  {"GetTimeStepStride", PyvtkFidesWriter_GetTimeStepStride, METH_VARARGS,
   "GetTimeStepStride(self) -> int\nC++: virtual int GetTimeStepStride()\n\n"},
  {"SetEngine", PyvtkFidesWriter_SetEngine, METH_VARARGS,
   "SetEngine(self, _arg:int) -> None\nC++: virtual void SetEngine(int _arg)\n\nSet/Get the ADIOS engine to use (currently BPFile only!)\n"},
  {"GetEngine", PyvtkFidesWriter_GetEngine, METH_VARARGS,
   "GetEngine(self) -> int\nC++: virtual int GetEngine()\n\n"},
  {"SetController", PyvtkFidesWriter_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: void SetController(vtkMultiProcessController *)\n\nGet/Set the controller to use when working in parallel.\nInitialized to `vtkMultiProcessController::GetGlobalController`\nin the constructor.\n"},
  {"GetController", PyvtkFidesWriter_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkFidesWriter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesWriter_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFidesWriter_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFidesWriter_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("choose_fields_to_write"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesWriter_GetChooseFieldsToWrite(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFidesWriter_SetChooseFieldsToWrite(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFidesWriter_SetChooseFieldsToWrite(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetChooseFieldsToWrite/SetChooseFieldsToWrite\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_step_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesWriter_GetTimeStepRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFidesWriter_SetTimeStepRange(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFidesWriter_SetTimeStepRange(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeStepRange/SetTimeStepRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_step_stride"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesWriter_GetTimeStepStride(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFidesWriter_SetTimeStepStride(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFidesWriter_SetTimeStepStride(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeStepStride/SetTimeStepStride\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("engine"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesWriter_GetEngine(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFidesWriter_SetEngine(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFidesWriter_SetEngine(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEngine/SetEngine\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesWriter_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFidesWriter_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFidesWriter_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesWriter_GetPointDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPointDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesWriter_GetCellDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCellDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("field_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesWriter_GetFieldDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFieldDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkFidesWriter_Doc =
  "vtkFidesWriter - Write ADIOS2 streams using Fides data model\n\n"
  "Superclass: vtkWriter\n\n"
  "vtkFidesWriter uses ADIOS2 to write files using the Fides schema.\n"
  "Fides requires data in Viskores format, so this vtkFidesWriter first\n"
  "converts VTK datasets to Viskores datasets. This also writes out a\n"
  "Fides schema so it can be read back in using vtkFidesReader. The\n"
  "schema is written as an attribute in the ADIOS2 file.\n\n"
  "Note: Currently only supports BP file engine.\n\n"
  "Typical usage is as follows:\n\n"
  "{.cpp}\n"
  "vtkNewwriter;\n"
  "writer->SetInputData(...)\n"
  "writer->SetFileName(...);\n"
  "writer->Write();\n\n"
  "@section FidesWriterSelectArraysToWrite Selecting arrays to write\n\n"
  "By default, all arrays are enabled. To write specific arrays, set\n"
  "ChooseFieldsToWrite to true, via\n"
  "`vtkFidesWriter::SetChooseFieldsToWrite(true)`. Then use the\n"
  "`vtkDataArraySelection` instance returned using\n"
  "`vtkFidesWriter::GetArraySelection` (or one of the conviences\n"
  "variants) to enable specific arrays.\n\n"
  "Typical usage is as follows:\n\n"
  "{.cpp}\n"
  "vtkNewwriter;\n"
  "writer->SetInputData(...)\n"
  "writer->SetFileName(...);\n"
  "writer->SetChooseFieldsToWrite(true);\n"
  "writer->GetPointDataArraySelection()->EnableArray(fieldName);\n"
  "writer->Write();\n\n"
  "@section FidesWriterSelectTimeSteps Selecting TimeSteps\n\n"
  "`vtkFidesWriter::SetTimeStepRange(...)` and\n"
  "`vtkFidesWriter::SetTimeStepStride(...)` can be used to write a\n"
  "subset of time steps using a range and a stride.\n\n"
  "@sa vtkFidesReader\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkFidesWriter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOFides.vtkFidesWriter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkFidesWriter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkFidesWriter_StaticNew()
{
  return vtkFidesWriter::New();
}

PyObject *PyvtkFidesWriter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkFidesWriter_Type, PyvtkFidesWriter_Methods,
    "vtkFidesWriter",
 &PyvtkFidesWriter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkWriter");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkFidesWriter_EngineTypes_Type);
  PyVTKEnum_Add(&PyvtkFidesWriter_EngineTypes_Type, "vtkFidesWriter.EngineTypes");

  o = (PyObject *)&PyvtkFidesWriter_EngineTypes_Type;
  if (PyDict_SetItemString(d, "EngineTypes", o) != 0)
  {
    Py_DECREF(o);
  }

  o = PyvtkFidesWriter_EngineTypes_FromEnum(vtkFidesWriter::BPFile);
  if (o)
  {
    PyDict_SetItemString(d, "BPFile", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkFidesWriter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkFidesWriter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkFidesWriter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkFidesWriter", o) != 0)
  {
    Py_DECREF(o);
  }

}

