// python wrapper for vtkGhostCellsGenerator
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkGhostCellsGenerator.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkGhostCellsGenerator(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGhostCellsGenerator_ClassNew(); }


static PyObject *
PyvtkGhostCellsGenerator_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGhostCellsGenerator::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGhostCellsGenerator::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGhostCellsGenerator *tempr = vtkGhostCellsGenerator::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGhostCellsGenerator *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGhostCellsGenerator::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGhostCellsGenerator::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGhostCellsGenerator::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkGhostCellsGenerator::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkGhostCellsGenerator::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkGhostCellsGenerator::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_SetBuildIfRequired(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBuildIfRequired");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBuildIfRequired(temp0);
    }
    else
    {
      op->vtkGhostCellsGenerator::SetBuildIfRequired(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GetBuildIfRequired(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBuildIfRequired");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetBuildIfRequired() :
      op->vtkGhostCellsGenerator::GetBuildIfRequired());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_BuildIfRequiredOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "BuildIfRequiredOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->BuildIfRequiredOn();
    }
    else
    {
      op->vtkGhostCellsGenerator::BuildIfRequiredOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_BuildIfRequiredOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "BuildIfRequiredOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->BuildIfRequiredOff();
    }
    else
    {
      op->vtkGhostCellsGenerator::BuildIfRequiredOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GetNumberOfGhostLayers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGhostLayers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfGhostLayers() :
      op->vtkGhostCellsGenerator::GetNumberOfGhostLayers());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_SetNumberOfGhostLayers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfGhostLayers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfGhostLayers(temp0);
    }
    else
    {
      op->vtkGhostCellsGenerator::SetNumberOfGhostLayers(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GetNumberOfGhostLayersMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGhostLayersMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfGhostLayersMinValue() :
      op->vtkGhostCellsGenerator::GetNumberOfGhostLayersMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GetNumberOfGhostLayersMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGhostLayersMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfGhostLayersMaxValue() :
      op->vtkGhostCellsGenerator::GetNumberOfGhostLayersMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_SetGenerateGlobalIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateGlobalIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateGlobalIds(temp0);
    }
    else
    {
      op->vtkGhostCellsGenerator::SetGenerateGlobalIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GetGenerateGlobalIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateGlobalIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGenerateGlobalIds() :
      op->vtkGhostCellsGenerator::GetGenerateGlobalIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GenerateGlobalIdsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateGlobalIdsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateGlobalIdsOn();
    }
    else
    {
      op->vtkGhostCellsGenerator::GenerateGlobalIdsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GenerateGlobalIdsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateGlobalIdsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateGlobalIdsOff();
    }
    else
    {
      op->vtkGhostCellsGenerator::GenerateGlobalIdsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_SetGenerateProcessIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateProcessIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateProcessIds(temp0);
    }
    else
    {
      op->vtkGhostCellsGenerator::SetGenerateProcessIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GetGenerateProcessIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateProcessIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGenerateProcessIds() :
      op->vtkGhostCellsGenerator::GetGenerateProcessIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GenerateProcessIdsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateProcessIdsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateProcessIdsOn();
    }
    else
    {
      op->vtkGhostCellsGenerator::GenerateProcessIdsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GenerateProcessIdsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateProcessIdsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateProcessIdsOff();
    }
    else
    {
      op->vtkGhostCellsGenerator::GenerateProcessIdsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_SetSynchronizeOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSynchronizeOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSynchronizeOnly(temp0);
    }
    else
    {
      op->vtkGhostCellsGenerator::SetSynchronizeOnly(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GetSynchronizeOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSynchronizeOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSynchronizeOnly() :
      op->vtkGhostCellsGenerator::GetSynchronizeOnly());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_SynchronizeOnlyOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SynchronizeOnlyOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SynchronizeOnlyOn();
    }
    else
    {
      op->vtkGhostCellsGenerator::SynchronizeOnlyOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_SynchronizeOnlyOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SynchronizeOnlyOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SynchronizeOnlyOff();
    }
    else
    {
      op->vtkGhostCellsGenerator::SynchronizeOnlyOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_SetUseStaticMeshCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseStaticMeshCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseStaticMeshCache(temp0);
    }
    else
    {
      op->vtkGhostCellsGenerator::SetUseStaticMeshCache(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_GetUseStaticMeshCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseStaticMeshCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseStaticMeshCache() :
      op->vtkGhostCellsGenerator::GetUseStaticMeshCache());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_UseStaticMeshCacheOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseStaticMeshCacheOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseStaticMeshCacheOn();
    }
    else
    {
      op->vtkGhostCellsGenerator::UseStaticMeshCacheOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGhostCellsGenerator_UseStaticMeshCacheOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseStaticMeshCacheOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGhostCellsGenerator *op = static_cast<vtkGhostCellsGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseStaticMeshCacheOff();
    }
    else
    {
      op->vtkGhostCellsGenerator::UseStaticMeshCacheOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGhostCellsGenerator_Methods[] = {
  {"IsTypeOf", PyvtkGhostCellsGenerator_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGhostCellsGenerator_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGhostCellsGenerator_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkGhostCellsGenerator\nC++: static vtkGhostCellsGenerator *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGhostCellsGenerator_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkGhostCellsGenerator\nC++: vtkGhostCellsGenerator *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGhostCellsGenerator_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGhostCellsGenerator_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetController", PyvtkGhostCellsGenerator_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: virtual void SetController(vtkMultiProcessController *)\n\nGet/Set the controller to use. By default\nvtkMultiProcessController::GlobalController will be used.\n"},
  {"GetController", PyvtkGhostCellsGenerator_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: vtkMultiProcessController *GetController()\n\n"},
  {"Initialize", PyvtkGhostCellsGenerator_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: virtual void Initialize()\n\n"},
  {"SetBuildIfRequired", PyvtkGhostCellsGenerator_SetBuildIfRequired, METH_VARARGS,
   "SetBuildIfRequired(self, _arg:bool) -> None\nC++: virtual void SetBuildIfRequired(bool _arg)\n\nSpecify if the filter must generate the ghost cells only if\nrequired by the pipeline. If false, ghost cells are computed even\nif they are not required. Default is TRUE.\n"},
  {"GetBuildIfRequired", PyvtkGhostCellsGenerator_GetBuildIfRequired, METH_VARARGS,
   "GetBuildIfRequired(self) -> bool\nC++: virtual bool GetBuildIfRequired()\n\n"},
  {"BuildIfRequiredOn", PyvtkGhostCellsGenerator_BuildIfRequiredOn, METH_VARARGS,
   "BuildIfRequiredOn(self) -> None\nC++: virtual void BuildIfRequiredOn()\n\n"},
  {"BuildIfRequiredOff", PyvtkGhostCellsGenerator_BuildIfRequiredOff, METH_VARARGS,
   "BuildIfRequiredOff(self) -> None\nC++: virtual void BuildIfRequiredOff()\n\n"},
  {"GetNumberOfGhostLayers", PyvtkGhostCellsGenerator_GetNumberOfGhostLayers, METH_VARARGS,
   "GetNumberOfGhostLayers(self) -> int\nC++: virtual int GetNumberOfGhostLayers()\n\nWhen BuildIfRequired is `false`, this can be used to set the\nnumber of ghost layers to generate. Note, if the downstream\npipeline requests more ghost levels than the number specified\nhere, then the filter will generate those extra ghost levels as\nneeded. Accepted values are in the interval [1, VTK_INT_MAX].\n"},
  {"SetNumberOfGhostLayers", PyvtkGhostCellsGenerator_SetNumberOfGhostLayers, METH_VARARGS,
   "SetNumberOfGhostLayers(self, _arg:int) -> None\nC++: virtual void SetNumberOfGhostLayers(int _arg)\n\n"},
  {"GetNumberOfGhostLayersMinValue", PyvtkGhostCellsGenerator_GetNumberOfGhostLayersMinValue, METH_VARARGS,
   "GetNumberOfGhostLayersMinValue(self) -> int\nC++: virtual int GetNumberOfGhostLayersMinValue()\n\n"},
  {"GetNumberOfGhostLayersMaxValue", PyvtkGhostCellsGenerator_GetNumberOfGhostLayersMaxValue, METH_VARARGS,
   "GetNumberOfGhostLayersMaxValue(self) -> int\nC++: virtual int GetNumberOfGhostLayersMaxValue()\n\n"},
  {"SetGenerateGlobalIds", PyvtkGhostCellsGenerator_SetGenerateGlobalIds, METH_VARARGS,
   "SetGenerateGlobalIds(self, _arg:bool) -> None\nC++: virtual void SetGenerateGlobalIds(bool _arg)\n\nSpecify if the filter should generate GlobalsIds. Default is\nFALSE.\n"},
  {"GetGenerateGlobalIds", PyvtkGhostCellsGenerator_GetGenerateGlobalIds, METH_VARARGS,
   "GetGenerateGlobalIds(self) -> bool\nC++: virtual bool GetGenerateGlobalIds()\n\n"},
  {"GenerateGlobalIdsOn", PyvtkGhostCellsGenerator_GenerateGlobalIdsOn, METH_VARARGS,
   "GenerateGlobalIdsOn(self) -> None\nC++: virtual void GenerateGlobalIdsOn()\n\n"},
  {"GenerateGlobalIdsOff", PyvtkGhostCellsGenerator_GenerateGlobalIdsOff, METH_VARARGS,
   "GenerateGlobalIdsOff(self) -> None\nC++: virtual void GenerateGlobalIdsOff()\n\n"},
  {"SetGenerateProcessIds", PyvtkGhostCellsGenerator_SetGenerateProcessIds, METH_VARARGS,
   "SetGenerateProcessIds(self, _arg:bool) -> None\nC++: virtual void SetGenerateProcessIds(bool _arg)\n\nSpecify if the filter should generate ProcessIds. Default is\nFALSE.\n"},
  {"GetGenerateProcessIds", PyvtkGhostCellsGenerator_GetGenerateProcessIds, METH_VARARGS,
   "GetGenerateProcessIds(self) -> bool\nC++: virtual bool GetGenerateProcessIds()\n\n"},
  {"GenerateProcessIdsOn", PyvtkGhostCellsGenerator_GenerateProcessIdsOn, METH_VARARGS,
   "GenerateProcessIdsOn(self) -> None\nC++: virtual void GenerateProcessIdsOn()\n\n"},
  {"GenerateProcessIdsOff", PyvtkGhostCellsGenerator_GenerateProcessIdsOff, METH_VARARGS,
   "GenerateProcessIdsOff(self) -> None\nC++: virtual void GenerateProcessIdsOff()\n\n"},
  {"SetSynchronizeOnly", PyvtkGhostCellsGenerator_SetSynchronizeOnly, METH_VARARGS,
   "SetSynchronizeOnly(self, _arg:bool) -> None\nC++: virtual void SetSynchronizeOnly(bool _arg)\n\nSpecify if the filter should try to synchronize ghost instead of\nregenerating ghosts if it can. If it can't, ghost cells and\npoints will be generated instead. This assumes that the ghost\nlayer stays the same. Default is FALSE.\n"},
  {"GetSynchronizeOnly", PyvtkGhostCellsGenerator_GetSynchronizeOnly, METH_VARARGS,
   "GetSynchronizeOnly(self) -> bool\nC++: virtual bool GetSynchronizeOnly()\n\n"},
  {"SynchronizeOnlyOn", PyvtkGhostCellsGenerator_SynchronizeOnlyOn, METH_VARARGS,
   "SynchronizeOnlyOn(self) -> None\nC++: virtual void SynchronizeOnlyOn()\n\n"},
  {"SynchronizeOnlyOff", PyvtkGhostCellsGenerator_SynchronizeOnlyOff, METH_VARARGS,
   "SynchronizeOnlyOff(self) -> None\nC++: virtual void SynchronizeOnlyOff()\n\n"},
  {"SetUseStaticMeshCache", PyvtkGhostCellsGenerator_SetUseStaticMeshCache, METH_VARARGS,
   "SetUseStaticMeshCache(self, _arg:bool) -> None\nC++: virtual void SetUseStaticMeshCache(bool _arg)\n\nSpecify if the filter should keep a cache of the output geometry.\nGhost cells will be generated once on the first update, and\nfollowing updates will only regenerate them if the input mesh has\nchanged. This should allow faster execution in cases where the\nmesh is the same. Default is TRUE.\n"},
  {"GetUseStaticMeshCache", PyvtkGhostCellsGenerator_GetUseStaticMeshCache, METH_VARARGS,
   "GetUseStaticMeshCache(self) -> bool\nC++: virtual bool GetUseStaticMeshCache()\n\n"},
  {"UseStaticMeshCacheOn", PyvtkGhostCellsGenerator_UseStaticMeshCacheOn, METH_VARARGS,
   "UseStaticMeshCacheOn(self) -> None\nC++: virtual void UseStaticMeshCacheOn()\n\n"},
  {"UseStaticMeshCacheOff", PyvtkGhostCellsGenerator_UseStaticMeshCacheOff, METH_VARARGS,
   "UseStaticMeshCacheOff(self) -> None\nC++: virtual void UseStaticMeshCacheOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGhostCellsGenerator_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGhostCellsGenerator_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGhostCellsGenerator_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGhostCellsGenerator_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("build_if_required"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGhostCellsGenerator_GetBuildIfRequired(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGhostCellsGenerator_SetBuildIfRequired(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGhostCellsGenerator_SetBuildIfRequired(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBuildIfRequired/SetBuildIfRequired\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_global_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGhostCellsGenerator_GetGenerateGlobalIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGhostCellsGenerator_SetGenerateGlobalIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGhostCellsGenerator_SetGenerateGlobalIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateGlobalIds/SetGenerateGlobalIds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_process_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGhostCellsGenerator_GetGenerateProcessIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGhostCellsGenerator_SetGenerateProcessIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGhostCellsGenerator_SetGenerateProcessIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateProcessIds/SetGenerateProcessIds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("synchronize_only"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGhostCellsGenerator_GetSynchronizeOnly(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGhostCellsGenerator_SetSynchronizeOnly(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGhostCellsGenerator_SetSynchronizeOnly(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSynchronizeOnly/SetSynchronizeOnly\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_static_mesh_cache"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGhostCellsGenerator_GetUseStaticMeshCache(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGhostCellsGenerator_SetUseStaticMeshCache(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGhostCellsGenerator_SetUseStaticMeshCache(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseStaticMeshCache/SetUseStaticMeshCache\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_ghost_layers_min_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGhostCellsGenerator_GetNumberOfGhostLayersMinValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfGhostLayersMinValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_ghost_layers_max_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGhostCellsGenerator_GetNumberOfGhostLayersMaxValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfGhostLayersMaxValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_ghost_layers"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGhostCellsGenerator_GetNumberOfGhostLayers(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGhostCellsGenerator_SetNumberOfGhostLayers(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGhostCellsGenerator_SetNumberOfGhostLayers(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfGhostLayers/SetNumberOfGhostLayers\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGhostCellsGenerator_Doc =
  "vtkGhostCellsGenerator - Computes ghost cells on vtkCompositeDataSet\ninputs\n\n"
  "Superclass: vtkPassInputTypeAlgorithm\n\n"
  "This filter computes ghost cells between data sets of same types in a\n"
  "`vtkCompositeDataSet`. For example, a `vtkImageData` inside a\n"
  "`vtkCompositeDataSet` will send and receive ghosts only to and from\n"
  "other `vtkImageData`. The backend used to generate the ghosts is\n"
  "`vtkDIYGhostUtilities::GenerateGhosts`.\n\n"
  "If the input is a `vtkPartitionedDataSetCollection`, then ghosts are\n"
  "computed per partitioned data set. In other words, ghost are not\n"
  "computed between 2 `vtkDataSet` belonging to 2 different\n"
  "`vtkPartitionedDataSet`, even if they are adjacent.\n\n"
  "If `BuildIfRequired` is set to true (which is by default), then the\n"
  "filter will compute ghost based on the value being returned by\n"
  "`vtkStreamingDemandDrivenPipeline::UPDATE_NUMBER_OF_GHOST_LEVELS()`\n"
  "in the downstream streaming pipeline. If not (i.e. `BuildIfRequired`\n"
  "is off), then the max between this latter value and\n"
  "`NumberOfGhostLayers` is being used.\n\n"
  "Ghosts points are generated in addition to ghost cells. The same\n"
  "point exists across multiple partitions at the interface between\n"
  "them. One version of those points is not tagged as ghost, while the\n"
  "others are. As a consequence, there are as many non ghost points as\n"
  "there would be points if the input partitions were all merged into\n"
  "one partition.\n\n"
  "If the input is composed of some data sets already owning ghosts,\n"
  "those ghosts are removed from the output and are recomputed. Ghosts\n"
  "in the input are as if they didn't exist. A ghost cell is to be\n"
  "peeled off if it holds the `CELLDUPLICATE` flag in its ghost bit\n"
  "mask. Similarly, each generated ghost cells from this filter is\n"
  "tagged with `CELLDUPLICATE`, in addition of other tags that could be\n"
  "set (`HIDDENCELL` for instance).\n\n"
  "However, if `SynchronizeOnly` is On, ghost data will be synchronized\n"
  "between processes and ghost array won't be recomputed. This parameter\n"
  "assumes that the ghost layer remains unchanged. For this feature to\n"
  "work, the input must already have GlobalIds and ProcessIds arrays.\n"
  "Otherwise, the filter will fallback on its default behavior.\n\n"
  "To ease the subsequent use of the synchronization mechanism, two\n"
  "other options can be enabled to generate GlobalIds and ProcessIds on\n"
  "points/cells, via `GenerateGlobalIds` and `GenerateProcessIds`.\n\n"
  "If the input is a `vtkUnstructuredGrid`, if the input `vtkPointData`\n"
  "has global ids, then the values of those global ids are used instead\n"
  "of point position in 3D to connect 2 partitions. If not, point\n"
  "position of the outer surface are used to connect them. The precision\n"
  "of such connection is done using numeric precision of the input\n"
  "coordinates. Points and cells tagged as hidden ghosts are removed\n"
  "from the output.\n\n"
  "When requesting zero layers of ghost cells, ghost points are still\n"
  "generated. In this instance, the filter will produce a ghost cell\n"
  "array in the output if and only if the input is a structured data set\n"
  "(`vtkImageData`, `vtkRectilinearGrid`, or `vtkStructuredGrid`), and\n"
  "has hidden ghosts within its valid extent (extent when duplicate\n"
  "ghosts are peeled off).\n\n"
  "Points at the interface between 2 partitions are edited depending on\n"
  "the ownership of the point after the ghost points are generated. One\n"
  "can keep track of which process owns a non-ghost copy of the point if\n"
  "an array associating each point with its process id is available in\n"
  "the input.\n\n"
  "@warning If an input already holds ghosts, the input ghost cells\n"
  "    should be tagged as\n"
  "`CELLDUPLICATE` in order for this filter to work properly.\n\n"
  "ote Currently,`vtkImageData`, `vtkRectilinearGrid`,\n"
  "`vtkStructuredGrid`, `vtkUnstructuredGrid` and `vtkPolyData` are\n"
  "implemented.\n\n"
  "@warning This warning only applies for `vtkUnstructuredGrid` and\n"
  "    `vtkPolyData` inputs. If\n"
  "there are duplicate points in the outer shell of an input partition,\n"
  "then this filter cannot decide on how to connect the cells properly\n"
  "when generating ghosts. The same phenomenon occurs when the outer\n"
  "shell of the partition has 2 points with the same global id. In such\n"
  "circumstances, use the `vtkStaticCleanUnstructuredGrid` or\n"
  "`vtkStaticCleanPolyData` filter first in order to have a clean input.\n\n"
  "@sa vtkDIYGhostUtilities\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGhostCellsGenerator_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkFiltersParallelDIY2.vtkGhostCellsGenerator", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGhostCellsGenerator_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkGhostCellsGenerator_StaticNew()
{
  return vtkGhostCellsGenerator::New();
}

PyObject *PyvtkGhostCellsGenerator_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGhostCellsGenerator_Type, PyvtkGhostCellsGenerator_Methods,
    "vtkGhostCellsGenerator",
 &PyvtkGhostCellsGenerator_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPassInputTypeAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGhostCellsGenerator_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkGhostCellsGenerator(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkGhostCellsGenerator_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkGhostCellsGenerator", o) != 0)
  {
    Py_DECREF(o);
  }

}

