// python wrapper for vtkExtractSubsetWithSeed
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkExtractSubsetWithSeed.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkExtractSubsetWithSeed(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkExtractSubsetWithSeed_ClassNew(); }


static PyObject *
PyvtkExtractSubsetWithSeed_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkExtractSubsetWithSeed::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkExtractSubsetWithSeed::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkExtractSubsetWithSeed *tempr = vtkExtractSubsetWithSeed::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkExtractSubsetWithSeed *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkExtractSubsetWithSeed::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkExtractSubsetWithSeed::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkExtractSubsetWithSeed::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_SetSeed_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSeed(temp0, temp1, temp2);
    }
    else
    {
      op->vtkExtractSubsetWithSeed::SetSeed(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExtractSubsetWithSeed_SetSeed_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetSeed(temp0);
    }
    else
    {
      op->vtkExtractSubsetWithSeed::SetSeed(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExtractSubsetWithSeed_SetSeed(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkExtractSubsetWithSeed_SetSeed_s1(self, args);
    case 1:
      return PyvtkExtractSubsetWithSeed_SetSeed_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSeed");
  return nullptr;
}


static PyObject *
PyvtkExtractSubsetWithSeed_GetSeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetSeed() :
      op->vtkExtractSubsetWithSeed::GetSeed());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_SetDirection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDirection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDirection(temp0);
    }
    else
    {
      op->vtkExtractSubsetWithSeed::SetDirection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_GetDirectionMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDirectionMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDirectionMinValue() :
      op->vtkExtractSubsetWithSeed::GetDirectionMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_GetDirectionMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDirectionMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDirectionMaxValue() :
      op->vtkExtractSubsetWithSeed::GetDirectionMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_GetDirection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDirection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDirection() :
      op->vtkExtractSubsetWithSeed::GetDirection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_SetDirectionToLineI(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDirectionToLineI");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetDirectionToLineI();
    }
    else
    {
      op->vtkExtractSubsetWithSeed::SetDirectionToLineI();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_SetDirectionToLineJ(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDirectionToLineJ");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetDirectionToLineJ();
    }
    else
    {
      op->vtkExtractSubsetWithSeed::SetDirectionToLineJ();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_SetDirectionToLineK(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDirectionToLineK");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetDirectionToLineK();
    }
    else
    {
      op->vtkExtractSubsetWithSeed::SetDirectionToLineK();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_SetDirectionToPlaneIJ(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDirectionToPlaneIJ");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetDirectionToPlaneIJ();
    }
    else
    {
      op->vtkExtractSubsetWithSeed::SetDirectionToPlaneIJ();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_SetDirectionToPlaneJK(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDirectionToPlaneJK");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetDirectionToPlaneJK();
    }
    else
    {
      op->vtkExtractSubsetWithSeed::SetDirectionToPlaneJK();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_SetDirectionToPlaneKI(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDirectionToPlaneKI");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetDirectionToPlaneKI();
    }
    else
    {
      op->vtkExtractSubsetWithSeed::SetDirectionToPlaneKI();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkExtractSubsetWithSeed::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractSubsetWithSeed_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractSubsetWithSeed *op = static_cast<vtkExtractSubsetWithSeed *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkExtractSubsetWithSeed::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkExtractSubsetWithSeed_Methods[] = {
  {"IsTypeOf", PyvtkExtractSubsetWithSeed_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkExtractSubsetWithSeed_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkExtractSubsetWithSeed_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkExtractSubsetWithSeed\nC++: static vtkExtractSubsetWithSeed *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkExtractSubsetWithSeed_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkExtractSubsetWithSeed\nC++: vtkExtractSubsetWithSeed *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkExtractSubsetWithSeed_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkExtractSubsetWithSeed_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetSeed", PyvtkExtractSubsetWithSeed_SetSeed, METH_VARARGS,
   "SetSeed(self, _arg1:float, _arg2:float, _arg3:float) -> None\nC++: virtual void SetSeed(double _arg1, double _arg2,\n    double _arg3)\nSetSeed(self, _arg:(float, float, float)) -> None\nC++: virtual void SetSeed(const double _arg[3])\n\nGet/Set the extraction seed point. This is specified in world\ncoordinates i.e. x-y-z space.\n"},
  {"GetSeed", PyvtkExtractSubsetWithSeed_GetSeed, METH_VARARGS,
   "GetSeed(self) -> (float, float, float)\nC++: virtual double *GetSeed()\n\n"},
  {"SetDirection", PyvtkExtractSubsetWithSeed_SetDirection, METH_VARARGS,
   "SetDirection(self, _arg:int) -> None\nC++: virtual void SetDirection(int _arg)\n\nGet/Set the directions in the ijk spaced to extract starting with\nthe seed.\n"},
  {"GetDirectionMinValue", PyvtkExtractSubsetWithSeed_GetDirectionMinValue, METH_VARARGS,
   "GetDirectionMinValue(self) -> int\nC++: virtual int GetDirectionMinValue()\n\n"},
  {"GetDirectionMaxValue", PyvtkExtractSubsetWithSeed_GetDirectionMaxValue, METH_VARARGS,
   "GetDirectionMaxValue(self) -> int\nC++: virtual int GetDirectionMaxValue()\n\n"},
  {"GetDirection", PyvtkExtractSubsetWithSeed_GetDirection, METH_VARARGS,
   "GetDirection(self) -> int\nC++: virtual int GetDirection()\n\n"},
  {"SetDirectionToLineI", PyvtkExtractSubsetWithSeed_SetDirectionToLineI, METH_VARARGS,
   "SetDirectionToLineI(self) -> None\nC++: void SetDirectionToLineI()\n\n"},
  {"SetDirectionToLineJ", PyvtkExtractSubsetWithSeed_SetDirectionToLineJ, METH_VARARGS,
   "SetDirectionToLineJ(self) -> None\nC++: void SetDirectionToLineJ()\n\n"},
  {"SetDirectionToLineK", PyvtkExtractSubsetWithSeed_SetDirectionToLineK, METH_VARARGS,
   "SetDirectionToLineK(self) -> None\nC++: void SetDirectionToLineK()\n\n"},
  {"SetDirectionToPlaneIJ", PyvtkExtractSubsetWithSeed_SetDirectionToPlaneIJ, METH_VARARGS,
   "SetDirectionToPlaneIJ(self) -> None\nC++: void SetDirectionToPlaneIJ()\n\n"},
  {"SetDirectionToPlaneJK", PyvtkExtractSubsetWithSeed_SetDirectionToPlaneJK, METH_VARARGS,
   "SetDirectionToPlaneJK(self) -> None\nC++: void SetDirectionToPlaneJK()\n\n"},
  {"SetDirectionToPlaneKI", PyvtkExtractSubsetWithSeed_SetDirectionToPlaneKI, METH_VARARGS,
   "SetDirectionToPlaneKI(self) -> None\nC++: void SetDirectionToPlaneKI()\n\n"},
  {"SetController", PyvtkExtractSubsetWithSeed_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: void SetController(vtkMultiProcessController *)\n\nGet/Set the controller to use. By default\nvtkMultiProcessController::GlobalController will be used.\n"},
  {"GetController", PyvtkExtractSubsetWithSeed_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkExtractSubsetWithSeed_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("seed"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExtractSubsetWithSeed_GetSeed(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExtractSubsetWithSeed_SetSeed(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExtractSubsetWithSeed_SetSeed(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSeed/SetSeed\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("direction"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExtractSubsetWithSeed_GetDirection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExtractSubsetWithSeed_SetDirection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExtractSubsetWithSeed_SetDirection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDirection/SetDirection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExtractSubsetWithSeed_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExtractSubsetWithSeed_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExtractSubsetWithSeed_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkExtractSubsetWithSeed_Doc =
  "vtkExtractSubsetWithSeed - extract a line or plane in the ijk space\nstarting with a seed\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "vtkExtractSubsetWithSeed is a filter that can extract a line or a\n"
  "plane in the i-j-k space starting with a seed point. The filter\n"
  "supports cases where the structured grid is split up into multiple\n"
  "blocks (across multiple ranks). It also handles cases were the ijk\n"
  "origin for each the blocks is not aligned.\n\n"
  "The implementation starts with the seed point and then extracts a\n"
  "line in the chosen direction. Then, using the face center for the\n"
  "terminal faces as the new seeds it continues seeding and extracting\n"
  "until a seed can no longer extract a new grid. The same principle\n"
  "holds when extracting a plane, except in that case multiple seeds are\n"
  "generated using face centers for each face alone the plane edges.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkExtractSubsetWithSeed_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkFiltersParallelDIY2.vtkExtractSubsetWithSeed", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkExtractSubsetWithSeed_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkExtractSubsetWithSeed_StaticNew()
{
  return vtkExtractSubsetWithSeed::New();
}

PyObject *PyvtkExtractSubsetWithSeed_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkExtractSubsetWithSeed_Type, PyvtkExtractSubsetWithSeed_Methods,
    "vtkExtractSubsetWithSeed",
 &PyvtkExtractSubsetWithSeed_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 6; c++)
  {
    static const struct { const char *name; int value; }
      constants[6] = {
        { "LINE_I", vtkExtractSubsetWithSeed::LINE_I },
        { "LINE_J", vtkExtractSubsetWithSeed::LINE_J },
        { "LINE_K", vtkExtractSubsetWithSeed::LINE_K },
        { "PLANE_IJ", vtkExtractSubsetWithSeed::PLANE_IJ },
        { "PLANE_JK", vtkExtractSubsetWithSeed::PLANE_JK },
        { "PLANE_KI", vtkExtractSubsetWithSeed::PLANE_KI },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkExtractSubsetWithSeed_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkExtractSubsetWithSeed(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkExtractSubsetWithSeed_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkExtractSubsetWithSeed", o) != 0)
  {
    Py_DECREF(o);
  }

}

