/** @file
 * VirtualBox API class wrapper code for IVRDEServerInfo.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_VRDESERVERINFO

#include "VRDEServerInfoWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(VRDEServerInfoWrap)

//
// IVRDEServerInfo properties
//

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(Active)(BOOL *aActive)
{
    LogRelFlow(("{%p} %s: enter aActive=%p\n", this, "VRDEServerInfo::getActive", aActive));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aActive);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_ACTIVE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getActive(aActive);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_ACTIVE_RETURN(this, hrc, 0 /*normal*/,*aActive != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_ACTIVE_RETURN(this, hrc, 1 /*hrc exception*/,*aActive != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_ACTIVE_RETURN(this, hrc, 9 /*unhandled exception*/,*aActive != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aActive=%RTbool hrc=%Rhrc\n", this, "VRDEServerInfo::getActive", *aActive, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(Port)(LONG *aPort)
{
    LogRelFlow(("{%p} %s: enter aPort=%p\n", this, "VRDEServerInfo::getPort", aPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPort);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_PORT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPort(aPort);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_PORT_RETURN(this, hrc, 0 /*normal*/,*aPort);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_PORT_RETURN(this, hrc, 1 /*hrc exception*/,*aPort);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_PORT_RETURN(this, hrc, 9 /*unhandled exception*/,*aPort);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPort=%RI32 hrc=%Rhrc\n", this, "VRDEServerInfo::getPort", *aPort, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(NumberOfClients)(ULONG *aNumberOfClients)
{
    LogRelFlow(("{%p} %s: enter aNumberOfClients=%p\n", this, "VRDEServerInfo::getNumberOfClients", aNumberOfClients));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNumberOfClients);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_NUMBEROFCLIENTS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNumberOfClients(aNumberOfClients);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_NUMBEROFCLIENTS_RETURN(this, hrc, 0 /*normal*/,*aNumberOfClients);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_NUMBEROFCLIENTS_RETURN(this, hrc, 1 /*hrc exception*/,*aNumberOfClients);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_NUMBEROFCLIENTS_RETURN(this, hrc, 9 /*unhandled exception*/,*aNumberOfClients);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNumberOfClients=%RU32 hrc=%Rhrc\n", this, "VRDEServerInfo::getNumberOfClients", *aNumberOfClients, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(BeginTime)(LONG64 *aBeginTime)
{
    LogRelFlow(("{%p} %s: enter aBeginTime=%p\n", this, "VRDEServerInfo::getBeginTime", aBeginTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBeginTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BEGINTIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBeginTime(aBeginTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BEGINTIME_RETURN(this, hrc, 0 /*normal*/,*aBeginTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BEGINTIME_RETURN(this, hrc, 1 /*hrc exception*/,*aBeginTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BEGINTIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aBeginTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBeginTime=%RI64 hrc=%Rhrc\n", this, "VRDEServerInfo::getBeginTime", *aBeginTime, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(EndTime)(LONG64 *aEndTime)
{
    LogRelFlow(("{%p} %s: enter aEndTime=%p\n", this, "VRDEServerInfo::getEndTime", aEndTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEndTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_ENDTIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEndTime(aEndTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_ENDTIME_RETURN(this, hrc, 0 /*normal*/,*aEndTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_ENDTIME_RETURN(this, hrc, 1 /*hrc exception*/,*aEndTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_ENDTIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aEndTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEndTime=%RI64 hrc=%Rhrc\n", this, "VRDEServerInfo::getEndTime", *aEndTime, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(BytesSent)(LONG64 *aBytesSent)
{
    LogRelFlow(("{%p} %s: enter aBytesSent=%p\n", this, "VRDEServerInfo::getBytesSent", aBytesSent));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBytesSent);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESSENT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBytesSent(aBytesSent);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESSENT_RETURN(this, hrc, 0 /*normal*/,*aBytesSent);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESSENT_RETURN(this, hrc, 1 /*hrc exception*/,*aBytesSent);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESSENT_RETURN(this, hrc, 9 /*unhandled exception*/,*aBytesSent);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBytesSent=%RI64 hrc=%Rhrc\n", this, "VRDEServerInfo::getBytesSent", *aBytesSent, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(BytesSentTotal)(LONG64 *aBytesSentTotal)
{
    LogRelFlow(("{%p} %s: enter aBytesSentTotal=%p\n", this, "VRDEServerInfo::getBytesSentTotal", aBytesSentTotal));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBytesSentTotal);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESSENTTOTAL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBytesSentTotal(aBytesSentTotal);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESSENTTOTAL_RETURN(this, hrc, 0 /*normal*/,*aBytesSentTotal);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESSENTTOTAL_RETURN(this, hrc, 1 /*hrc exception*/,*aBytesSentTotal);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESSENTTOTAL_RETURN(this, hrc, 9 /*unhandled exception*/,*aBytesSentTotal);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBytesSentTotal=%RI64 hrc=%Rhrc\n", this, "VRDEServerInfo::getBytesSentTotal", *aBytesSentTotal, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(BytesReceived)(LONG64 *aBytesReceived)
{
    LogRelFlow(("{%p} %s: enter aBytesReceived=%p\n", this, "VRDEServerInfo::getBytesReceived", aBytesReceived));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBytesReceived);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESRECEIVED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBytesReceived(aBytesReceived);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESRECEIVED_RETURN(this, hrc, 0 /*normal*/,*aBytesReceived);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESRECEIVED_RETURN(this, hrc, 1 /*hrc exception*/,*aBytesReceived);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESRECEIVED_RETURN(this, hrc, 9 /*unhandled exception*/,*aBytesReceived);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBytesReceived=%RI64 hrc=%Rhrc\n", this, "VRDEServerInfo::getBytesReceived", *aBytesReceived, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(BytesReceivedTotal)(LONG64 *aBytesReceivedTotal)
{
    LogRelFlow(("{%p} %s: enter aBytesReceivedTotal=%p\n", this, "VRDEServerInfo::getBytesReceivedTotal", aBytesReceivedTotal));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBytesReceivedTotal);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESRECEIVEDTOTAL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBytesReceivedTotal(aBytesReceivedTotal);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESRECEIVEDTOTAL_RETURN(this, hrc, 0 /*normal*/,*aBytesReceivedTotal);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESRECEIVEDTOTAL_RETURN(this, hrc, 1 /*hrc exception*/,*aBytesReceivedTotal);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_BYTESRECEIVEDTOTAL_RETURN(this, hrc, 9 /*unhandled exception*/,*aBytesReceivedTotal);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBytesReceivedTotal=%RI64 hrc=%Rhrc\n", this, "VRDEServerInfo::getBytesReceivedTotal", *aBytesReceivedTotal, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(User)(BSTR *aUser)
{
    LogRelFlow(("{%p} %s: enter aUser=%p\n", this, "VRDEServerInfo::getUser", aUser));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUser);
        BSTROutConverter TmpUser(aUser);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_USER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUser(TmpUser.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_USER_RETURN(this, hrc, 0 /*normal*/,TmpUser.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_USER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_USER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUser=%ls hrc=%Rhrc\n", this, "VRDEServerInfo::getUser", *aUser, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(Domain)(BSTR *aDomain)
{
    LogRelFlow(("{%p} %s: enter aDomain=%p\n", this, "VRDEServerInfo::getDomain", aDomain));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDomain);
        BSTROutConverter TmpDomain(aDomain);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_DOMAIN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDomain(TmpDomain.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_DOMAIN_RETURN(this, hrc, 0 /*normal*/,TmpDomain.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_DOMAIN_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_DOMAIN_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDomain=%ls hrc=%Rhrc\n", this, "VRDEServerInfo::getDomain", *aDomain, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(ClientName)(BSTR *aClientName)
{
    LogRelFlow(("{%p} %s: enter aClientName=%p\n", this, "VRDEServerInfo::getClientName", aClientName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aClientName);
        BSTROutConverter TmpClientName(aClientName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_CLIENTNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getClientName(TmpClientName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_CLIENTNAME_RETURN(this, hrc, 0 /*normal*/,TmpClientName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_CLIENTNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_CLIENTNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aClientName=%ls hrc=%Rhrc\n", this, "VRDEServerInfo::getClientName", *aClientName, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(ClientIP)(BSTR *aClientIP)
{
    LogRelFlow(("{%p} %s: enter aClientIP=%p\n", this, "VRDEServerInfo::getClientIP", aClientIP));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aClientIP);
        BSTROutConverter TmpClientIP(aClientIP);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_CLIENTIP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getClientIP(TmpClientIP.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_CLIENTIP_RETURN(this, hrc, 0 /*normal*/,TmpClientIP.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_CLIENTIP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_CLIENTIP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aClientIP=%ls hrc=%Rhrc\n", this, "VRDEServerInfo::getClientIP", *aClientIP, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(ClientVersion)(ULONG *aClientVersion)
{
    LogRelFlow(("{%p} %s: enter aClientVersion=%p\n", this, "VRDEServerInfo::getClientVersion", aClientVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aClientVersion);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_CLIENTVERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getClientVersion(aClientVersion);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_CLIENTVERSION_RETURN(this, hrc, 0 /*normal*/,*aClientVersion);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_CLIENTVERSION_RETURN(this, hrc, 1 /*hrc exception*/,*aClientVersion);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_CLIENTVERSION_RETURN(this, hrc, 9 /*unhandled exception*/,*aClientVersion);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aClientVersion=%RU32 hrc=%Rhrc\n", this, "VRDEServerInfo::getClientVersion", *aClientVersion, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(EncryptionStyle)(ULONG *aEncryptionStyle)
{
    LogRelFlow(("{%p} %s: enter aEncryptionStyle=%p\n", this, "VRDEServerInfo::getEncryptionStyle", aEncryptionStyle));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEncryptionStyle);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_ENCRYPTIONSTYLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEncryptionStyle(aEncryptionStyle);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_ENCRYPTIONSTYLE_RETURN(this, hrc, 0 /*normal*/,*aEncryptionStyle);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_ENCRYPTIONSTYLE_RETURN(this, hrc, 1 /*hrc exception*/,*aEncryptionStyle);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVERINFO_GET_ENCRYPTIONSTYLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aEncryptionStyle);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEncryptionStyle=%RU32 hrc=%Rhrc\n", this, "VRDEServerInfo::getEncryptionStyle", *aEncryptionStyle, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(InternalAndReservedAttribute1IVRDEServerInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(InternalAndReservedAttribute2IVRDEServerInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(InternalAndReservedAttribute3IVRDEServerInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(InternalAndReservedAttribute4IVRDEServerInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(InternalAndReservedAttribute5IVRDEServerInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(InternalAndReservedAttribute6IVRDEServerInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(InternalAndReservedAttribute7IVRDEServerInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VRDEServerInfoWrap::COMGETTER(InternalAndReservedAttribute8IVRDEServerInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IVRDEServerInfo methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(VRDEServerInfoWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(VRDEServerInfoWrap, IVRDEServerInfo)
#endif // VBOX_WITH_XPCOM
