/** @file
 * VirtualBox API class wrapper code for ITrustedPlatformModule.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_TRUSTEDPLATFORMMODULE

#include "TrustedPlatformModuleWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(TrustedPlatformModuleWrap)

//
// ITrustedPlatformModule properties
//

STDMETHODIMP TrustedPlatformModuleWrap::COMGETTER(Type)(TpmType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "TrustedPlatformModule::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "TrustedPlatformModule::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP TrustedPlatformModuleWrap::COMSETTER(Type)(TpmType_T aType)
{
    LogRelFlow(("{%p} %s: enter aType=%RU32\n", this, "TrustedPlatformModule::setType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_SET_TYPE_ENTER(this, aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_SET_TYPE_RETURN(this, hrc, 0 /*normal*/,aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_SET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_SET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "TrustedPlatformModule::setType", hrc));
    return hrc;
}

STDMETHODIMP TrustedPlatformModuleWrap::COMGETTER(Location)(BSTR *aLocation)
{
    LogRelFlow(("{%p} %s: enter aLocation=%p\n", this, "TrustedPlatformModule::getLocation", aLocation));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLocation);
        BSTROutConverter TmpLocation(aLocation);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_GET_LOCATION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLocation(TmpLocation.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_GET_LOCATION_RETURN(this, hrc, 0 /*normal*/,TmpLocation.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_GET_LOCATION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_GET_LOCATION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLocation=%ls hrc=%Rhrc\n", this, "TrustedPlatformModule::getLocation", *aLocation, hrc));
    return hrc;
}

STDMETHODIMP TrustedPlatformModuleWrap::COMSETTER(Location)(IN_BSTR aLocation)
{
    LogRelFlow(("{%p} %s: enter aLocation=%ls\n", this, "TrustedPlatformModule::setLocation", aLocation));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpLocation(aLocation);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_SET_LOCATION_ENTER(this, TmpLocation.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLocation(TmpLocation.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_SET_LOCATION_RETURN(this, hrc, 0 /*normal*/,TmpLocation.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_SET_LOCATION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_TRUSTEDPLATFORMMODULE_SET_LOCATION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "TrustedPlatformModule::setLocation", hrc));
    return hrc;
}

STDMETHODIMP TrustedPlatformModuleWrap::COMGETTER(InternalAndReservedAttribute1ITrustedPlatformModule)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP TrustedPlatformModuleWrap::COMGETTER(InternalAndReservedAttribute2ITrustedPlatformModule)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP TrustedPlatformModuleWrap::COMGETTER(InternalAndReservedAttribute3ITrustedPlatformModule)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP TrustedPlatformModuleWrap::COMGETTER(InternalAndReservedAttribute4ITrustedPlatformModule)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP TrustedPlatformModuleWrap::COMGETTER(InternalAndReservedAttribute5ITrustedPlatformModule)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP TrustedPlatformModuleWrap::COMGETTER(InternalAndReservedAttribute6ITrustedPlatformModule)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP TrustedPlatformModuleWrap::COMGETTER(InternalAndReservedAttribute7ITrustedPlatformModule)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP TrustedPlatformModuleWrap::COMGETTER(InternalAndReservedAttribute8ITrustedPlatformModule)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ITrustedPlatformModule methods
//

STDMETHODIMP TrustedPlatformModuleWrap::InternalAndReservedMethod1ITrustedPlatformModule()
{
    return E_NOTIMPL;
}

STDMETHODIMP TrustedPlatformModuleWrap::InternalAndReservedMethod2ITrustedPlatformModule()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(TrustedPlatformModuleWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(TrustedPlatformModuleWrap, ITrustedPlatformModule)
#endif // VBOX_WITH_XPCOM
