/** @file
 * VirtualBox API class wrapper code for IMachine.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_MACHINE

#include "MachineWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(MachineWrap)

//
// IMachine properties
//

STDMETHODIMP MachineWrap::COMGETTER(Parent)(IVirtualBox **aParent)
{
    LogRelFlow(("{%p} %s: enter aParent=%p\n", this, "Machine::getParent", aParent));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aParent);
        ComTypeOutConverter<IVirtualBox> TmpParent(aParent);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PARENT_ENTER(this);
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getParent(TmpParent.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PARENT_RETURN(this, hrc, 0 /*normal*/,(void *)TmpParent.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PARENT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PARENT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aParent=%p hrc=%Rhrc\n", this, "Machine::getParent", *aParent, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(Icon)(ComSafeArrayOut(BYTE, aIcon))
{
    LogRelFlow(("{%p} %s: enter aIcon=%p\n", this, "Machine::getIcon", aIcon));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIcon);
        ArrayOutConverter<BYTE> TmpIcon(ComSafeArrayOutArg(aIcon));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ICON_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIcon(TmpIcon.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ICON_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpIcon.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ICON_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ICON_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIcon=%zu hrc=%Rhrc\n", this, "Machine::getIcon", ComSafeArraySize(*aIcon), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(Icon)(ComSafeArrayIn(BYTE, aIcon))
{
    LogRelFlow(("{%p} %s: enter aIcon=%zu\n", this, "Machine::setIcon", ComSafeArraySize(aIcon)));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        ArrayInConverter<BYTE> TmpIcon(ComSafeArrayInArg(aIcon));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_ICON_ENTER(this, (uint32_t)TmpIcon.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIcon(TmpIcon.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_ICON_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpIcon.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_ICON_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_ICON_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setIcon", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(Accessible)(BOOL *aAccessible)
{
    LogRelFlow(("{%p} %s: enter aAccessible=%p\n", this, "Machine::getAccessible", aAccessible));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAccessible);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ACCESSIBLE_ENTER(this);
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAccessible(aAccessible);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ACCESSIBLE_RETURN(this, hrc, 0 /*normal*/,*aAccessible != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ACCESSIBLE_RETURN(this, hrc, 1 /*hrc exception*/,*aAccessible != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ACCESSIBLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAccessible != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAccessible=%RTbool hrc=%Rhrc\n", this, "Machine::getAccessible", *aAccessible, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(AccessError)(IVirtualBoxErrorInfo **aAccessError)
{
    LogRelFlow(("{%p} %s: enter aAccessError=%p\n", this, "Machine::getAccessError", aAccessError));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAccessError);
        ComTypeOutConverter<IVirtualBoxErrorInfo> TmpAccessError(aAccessError);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ACCESSERROR_ENTER(this);
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAccessError(TmpAccessError.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ACCESSERROR_RETURN(this, hrc, 0 /*normal*/,(void *)TmpAccessError.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ACCESSERROR_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ACCESSERROR_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAccessError=%p hrc=%Rhrc\n", this, "Machine::getAccessError", *aAccessError, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "Machine::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "Machine::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(Name)(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "Machine::setName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_NAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setName", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "Machine::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "Machine::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(Description)(IN_BSTR aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%ls\n", this, "Machine::setDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpDescription(aDescription);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_DESCRIPTION_ENTER(this, TmpDescription.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setDescription", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(Id)(BSTR *aId)
{
    LogRelFlow(("{%p} %s: enter aId=%p\n", this, "Machine::getId", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        UuidOutConverter TmpId(aId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ID_ENTER(this);
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getId(TmpId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ID_RETURN(this, hrc, 0 /*normal*/,TmpId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%ls hrc=%Rhrc\n", this, "Machine::getId", *aId, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(Groups)(ComSafeArrayOut(BSTR, aGroups))
{
    LogRelFlow(("{%p} %s: enter aGroups=%p\n", this, "Machine::getGroups", aGroups));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGroups);
        ArrayBSTROutConverter TmpGroups(ComSafeArrayOutArg(aGroups));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_GROUPS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGroups(TmpGroups.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_GROUPS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpGroups.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_GROUPS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_GROUPS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGroups=%zu hrc=%Rhrc\n", this, "Machine::getGroups", ComSafeArraySize(*aGroups), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(Groups)(ComSafeArrayIn(IN_BSTR, aGroups))
{
    LogRelFlow(("{%p} %s: enter aGroups=%zu\n", this, "Machine::setGroups", ComSafeArraySize(aGroups)));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        ArrayBSTRInConverter TmpGroups(ComSafeArrayInArg(aGroups));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_GROUPS_ENTER(this, (uint32_t)TmpGroups.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setGroups(TmpGroups.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_GROUPS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpGroups.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_GROUPS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_GROUPS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setGroups", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(OSTypeId)(BSTR *aOSTypeId)
{
    LogRelFlow(("{%p} %s: enter aOSTypeId=%p\n", this, "Machine::getOSTypeId", aOSTypeId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOSTypeId);
        BSTROutConverter TmpOSTypeId(aOSTypeId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_OSTYPEID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOSTypeId(TmpOSTypeId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_OSTYPEID_RETURN(this, hrc, 0 /*normal*/,TmpOSTypeId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_OSTYPEID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_OSTYPEID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOSTypeId=%ls hrc=%Rhrc\n", this, "Machine::getOSTypeId", *aOSTypeId, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(OSTypeId)(IN_BSTR aOSTypeId)
{
    LogRelFlow(("{%p} %s: enter aOSTypeId=%ls\n", this, "Machine::setOSTypeId", aOSTypeId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpOSTypeId(aOSTypeId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_OSTYPEID_ENTER(this, TmpOSTypeId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setOSTypeId(TmpOSTypeId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_OSTYPEID_RETURN(this, hrc, 0 /*normal*/,TmpOSTypeId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_OSTYPEID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_OSTYPEID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setOSTypeId", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(HardwareVersion)(BSTR *aHardwareVersion)
{
    LogRelFlow(("{%p} %s: enter aHardwareVersion=%p\n", this, "Machine::getHardwareVersion", aHardwareVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHardwareVersion);
        BSTROutConverter TmpHardwareVersion(aHardwareVersion);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_HARDWAREVERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHardwareVersion(TmpHardwareVersion.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_HARDWAREVERSION_RETURN(this, hrc, 0 /*normal*/,TmpHardwareVersion.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_HARDWAREVERSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_HARDWAREVERSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHardwareVersion=%ls hrc=%Rhrc\n", this, "Machine::getHardwareVersion", *aHardwareVersion, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(HardwareVersion)(IN_BSTR aHardwareVersion)
{
    LogRelFlow(("{%p} %s: enter aHardwareVersion=%ls\n", this, "Machine::setHardwareVersion", aHardwareVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpHardwareVersion(aHardwareVersion);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_HARDWAREVERSION_ENTER(this, TmpHardwareVersion.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setHardwareVersion(TmpHardwareVersion.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_HARDWAREVERSION_RETURN(this, hrc, 0 /*normal*/,TmpHardwareVersion.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_HARDWAREVERSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_HARDWAREVERSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setHardwareVersion", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(HardwareUUID)(BSTR *aHardwareUUID)
{
    LogRelFlow(("{%p} %s: enter aHardwareUUID=%p\n", this, "Machine::getHardwareUUID", aHardwareUUID));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHardwareUUID);
        UuidOutConverter TmpHardwareUUID(aHardwareUUID);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_HARDWAREUUID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHardwareUUID(TmpHardwareUUID.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_HARDWAREUUID_RETURN(this, hrc, 0 /*normal*/,TmpHardwareUUID.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_HARDWAREUUID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_HARDWAREUUID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHardwareUUID=%ls hrc=%Rhrc\n", this, "Machine::getHardwareUUID", *aHardwareUUID, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(HardwareUUID)(IN_BSTR aHardwareUUID)
{
    LogRelFlow(("{%p} %s: enter aHardwareUUID=%ls\n", this, "Machine::setHardwareUUID", aHardwareUUID));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        UuidInConverter TmpHardwareUUID(aHardwareUUID);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_HARDWAREUUID_ENTER(this, TmpHardwareUUID.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setHardwareUUID(TmpHardwareUUID.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_HARDWAREUUID_RETURN(this, hrc, 0 /*normal*/,TmpHardwareUUID.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_HARDWAREUUID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_HARDWAREUUID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setHardwareUUID", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(CPUCount)(ULONG *aCPUCount)
{
    LogRelFlow(("{%p} %s: enter aCPUCount=%p\n", this, "Machine::getCPUCount", aCPUCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCPUCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCPUCount(aCPUCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUCOUNT_RETURN(this, hrc, 0 /*normal*/,*aCPUCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aCPUCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aCPUCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCPUCount=%RU32 hrc=%Rhrc\n", this, "Machine::getCPUCount", *aCPUCount, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(CPUCount)(ULONG aCPUCount)
{
    LogRelFlow(("{%p} %s: enter aCPUCount=%RU32\n", this, "Machine::setCPUCount", aCPUCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUCOUNT_ENTER(this, aCPUCount);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCPUCount(aCPUCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUCOUNT_RETURN(this, hrc, 0 /*normal*/,aCPUCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,aCPUCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,aCPUCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setCPUCount", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(CPUHotPlugEnabled)(BOOL *aCPUHotPlugEnabled)
{
    LogRelFlow(("{%p} %s: enter aCPUHotPlugEnabled=%p\n", this, "Machine::getCPUHotPlugEnabled", aCPUHotPlugEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCPUHotPlugEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUHOTPLUGENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCPUHotPlugEnabled(aCPUHotPlugEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUHOTPLUGENABLED_RETURN(this, hrc, 0 /*normal*/,*aCPUHotPlugEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUHOTPLUGENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aCPUHotPlugEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUHOTPLUGENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aCPUHotPlugEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCPUHotPlugEnabled=%RTbool hrc=%Rhrc\n", this, "Machine::getCPUHotPlugEnabled", *aCPUHotPlugEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(CPUHotPlugEnabled)(BOOL aCPUHotPlugEnabled)
{
    LogRelFlow(("{%p} %s: enter aCPUHotPlugEnabled=%RTbool\n", this, "Machine::setCPUHotPlugEnabled", aCPUHotPlugEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUHOTPLUGENABLED_ENTER(this, aCPUHotPlugEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCPUHotPlugEnabled(aCPUHotPlugEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUHOTPLUGENABLED_RETURN(this, hrc, 0 /*normal*/,aCPUHotPlugEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUHOTPLUGENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aCPUHotPlugEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUHOTPLUGENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aCPUHotPlugEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setCPUHotPlugEnabled", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(CPUExecutionCap)(ULONG *aCPUExecutionCap)
{
    LogRelFlow(("{%p} %s: enter aCPUExecutionCap=%p\n", this, "Machine::getCPUExecutionCap", aCPUExecutionCap));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCPUExecutionCap);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUEXECUTIONCAP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCPUExecutionCap(aCPUExecutionCap);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUEXECUTIONCAP_RETURN(this, hrc, 0 /*normal*/,*aCPUExecutionCap);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUEXECUTIONCAP_RETURN(this, hrc, 1 /*hrc exception*/,*aCPUExecutionCap);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUEXECUTIONCAP_RETURN(this, hrc, 9 /*unhandled exception*/,*aCPUExecutionCap);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCPUExecutionCap=%RU32 hrc=%Rhrc\n", this, "Machine::getCPUExecutionCap", *aCPUExecutionCap, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(CPUExecutionCap)(ULONG aCPUExecutionCap)
{
    LogRelFlow(("{%p} %s: enter aCPUExecutionCap=%RU32\n", this, "Machine::setCPUExecutionCap", aCPUExecutionCap));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUEXECUTIONCAP_ENTER(this, aCPUExecutionCap);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCPUExecutionCap(aCPUExecutionCap);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUEXECUTIONCAP_RETURN(this, hrc, 0 /*normal*/,aCPUExecutionCap);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUEXECUTIONCAP_RETURN(this, hrc, 1 /*hrc exception*/,aCPUExecutionCap);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUEXECUTIONCAP_RETURN(this, hrc, 9 /*unhandled exception*/,aCPUExecutionCap);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setCPUExecutionCap", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(CPUIDPortabilityLevel)(ULONG *aCPUIDPortabilityLevel)
{
    LogRelFlow(("{%p} %s: enter aCPUIDPortabilityLevel=%p\n", this, "Machine::getCPUIDPortabilityLevel", aCPUIDPortabilityLevel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCPUIDPortabilityLevel);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUIDPORTABILITYLEVEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCPUIDPortabilityLevel(aCPUIDPortabilityLevel);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUIDPORTABILITYLEVEL_RETURN(this, hrc, 0 /*normal*/,*aCPUIDPortabilityLevel);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUIDPORTABILITYLEVEL_RETURN(this, hrc, 1 /*hrc exception*/,*aCPUIDPortabilityLevel);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUIDPORTABILITYLEVEL_RETURN(this, hrc, 9 /*unhandled exception*/,*aCPUIDPortabilityLevel);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCPUIDPortabilityLevel=%RU32 hrc=%Rhrc\n", this, "Machine::getCPUIDPortabilityLevel", *aCPUIDPortabilityLevel, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(CPUIDPortabilityLevel)(ULONG aCPUIDPortabilityLevel)
{
    LogRelFlow(("{%p} %s: enter aCPUIDPortabilityLevel=%RU32\n", this, "Machine::setCPUIDPortabilityLevel", aCPUIDPortabilityLevel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUIDPORTABILITYLEVEL_ENTER(this, aCPUIDPortabilityLevel);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCPUIDPortabilityLevel(aCPUIDPortabilityLevel);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUIDPORTABILITYLEVEL_RETURN(this, hrc, 0 /*normal*/,aCPUIDPortabilityLevel);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUIDPORTABILITYLEVEL_RETURN(this, hrc, 1 /*hrc exception*/,aCPUIDPortabilityLevel);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUIDPORTABILITYLEVEL_RETURN(this, hrc, 9 /*unhandled exception*/,aCPUIDPortabilityLevel);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setCPUIDPortabilityLevel", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(MemorySize)(ULONG *aMemorySize)
{
    LogRelFlow(("{%p} %s: enter aMemorySize=%p\n", this, "Machine::getMemorySize", aMemorySize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMemorySize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_MEMORYSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMemorySize(aMemorySize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_MEMORYSIZE_RETURN(this, hrc, 0 /*normal*/,*aMemorySize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_MEMORYSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aMemorySize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_MEMORYSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aMemorySize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMemorySize=%RU32 hrc=%Rhrc\n", this, "Machine::getMemorySize", *aMemorySize, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(MemorySize)(ULONG aMemorySize)
{
    LogRelFlow(("{%p} %s: enter aMemorySize=%RU32\n", this, "Machine::setMemorySize", aMemorySize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_MEMORYSIZE_ENTER(this, aMemorySize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMemorySize(aMemorySize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_MEMORYSIZE_RETURN(this, hrc, 0 /*normal*/,aMemorySize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_MEMORYSIZE_RETURN(this, hrc, 1 /*hrc exception*/,aMemorySize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_MEMORYSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,aMemorySize);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setMemorySize", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(MemoryBalloonSize)(ULONG *aMemoryBalloonSize)
{
    LogRelFlow(("{%p} %s: enter aMemoryBalloonSize=%p\n", this, "Machine::getMemoryBalloonSize", aMemoryBalloonSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMemoryBalloonSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_MEMORYBALLOONSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMemoryBalloonSize(aMemoryBalloonSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_MEMORYBALLOONSIZE_RETURN(this, hrc, 0 /*normal*/,*aMemoryBalloonSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_MEMORYBALLOONSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aMemoryBalloonSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_MEMORYBALLOONSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aMemoryBalloonSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMemoryBalloonSize=%RU32 hrc=%Rhrc\n", this, "Machine::getMemoryBalloonSize", *aMemoryBalloonSize, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(MemoryBalloonSize)(ULONG aMemoryBalloonSize)
{
    LogRelFlow(("{%p} %s: enter aMemoryBalloonSize=%RU32\n", this, "Machine::setMemoryBalloonSize", aMemoryBalloonSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_MEMORYBALLOONSIZE_ENTER(this, aMemoryBalloonSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMemoryBalloonSize(aMemoryBalloonSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_MEMORYBALLOONSIZE_RETURN(this, hrc, 0 /*normal*/,aMemoryBalloonSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_MEMORYBALLOONSIZE_RETURN(this, hrc, 1 /*hrc exception*/,aMemoryBalloonSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_MEMORYBALLOONSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,aMemoryBalloonSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setMemoryBalloonSize", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(PageFusionEnabled)(BOOL *aPageFusionEnabled)
{
    LogRelFlow(("{%p} %s: enter aPageFusionEnabled=%p\n", this, "Machine::getPageFusionEnabled", aPageFusionEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPageFusionEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PAGEFUSIONENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPageFusionEnabled(aPageFusionEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PAGEFUSIONENABLED_RETURN(this, hrc, 0 /*normal*/,*aPageFusionEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PAGEFUSIONENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aPageFusionEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PAGEFUSIONENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aPageFusionEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPageFusionEnabled=%RTbool hrc=%Rhrc\n", this, "Machine::getPageFusionEnabled", *aPageFusionEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(PageFusionEnabled)(BOOL aPageFusionEnabled)
{
    LogRelFlow(("{%p} %s: enter aPageFusionEnabled=%RTbool\n", this, "Machine::setPageFusionEnabled", aPageFusionEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_PAGEFUSIONENABLED_ENTER(this, aPageFusionEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPageFusionEnabled(aPageFusionEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_PAGEFUSIONENABLED_RETURN(this, hrc, 0 /*normal*/,aPageFusionEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_PAGEFUSIONENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aPageFusionEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_PAGEFUSIONENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aPageFusionEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setPageFusionEnabled", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(GraphicsAdapter)(IGraphicsAdapter **aGraphicsAdapter)
{
    LogRelFlow(("{%p} %s: enter aGraphicsAdapter=%p\n", this, "Machine::getGraphicsAdapter", aGraphicsAdapter));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGraphicsAdapter);
        ComTypeOutConverter<IGraphicsAdapter> TmpGraphicsAdapter(aGraphicsAdapter);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_GRAPHICSADAPTER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGraphicsAdapter(TmpGraphicsAdapter.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_GRAPHICSADAPTER_RETURN(this, hrc, 0 /*normal*/,(void *)TmpGraphicsAdapter.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_GRAPHICSADAPTER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_GRAPHICSADAPTER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGraphicsAdapter=%p hrc=%Rhrc\n", this, "Machine::getGraphicsAdapter", *aGraphicsAdapter, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(Platform)(IPlatform **aPlatform)
{
    LogRelFlow(("{%p} %s: enter aPlatform=%p\n", this, "Machine::getPlatform", aPlatform));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPlatform);
        ComTypeOutConverter<IPlatform> TmpPlatform(aPlatform);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PLATFORM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPlatform(TmpPlatform.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PLATFORM_RETURN(this, hrc, 0 /*normal*/,(void *)TmpPlatform.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PLATFORM_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PLATFORM_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPlatform=%p hrc=%Rhrc\n", this, "Machine::getPlatform", *aPlatform, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(FirmwareSettings)(IFirmwareSettings **aFirmwareSettings)
{
    LogRelFlow(("{%p} %s: enter aFirmwareSettings=%p\n", this, "Machine::getFirmwareSettings", aFirmwareSettings));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFirmwareSettings);
        ComTypeOutConverter<IFirmwareSettings> TmpFirmwareSettings(aFirmwareSettings);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_FIRMWARESETTINGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFirmwareSettings(TmpFirmwareSettings.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_FIRMWARESETTINGS_RETURN(this, hrc, 0 /*normal*/,(void *)TmpFirmwareSettings.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_FIRMWARESETTINGS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_FIRMWARESETTINGS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFirmwareSettings=%p hrc=%Rhrc\n", this, "Machine::getFirmwareSettings", *aFirmwareSettings, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(TrustedPlatformModule)(ITrustedPlatformModule **aTrustedPlatformModule)
{
    LogRelFlow(("{%p} %s: enter aTrustedPlatformModule=%p\n", this, "Machine::getTrustedPlatformModule", aTrustedPlatformModule));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTrustedPlatformModule);
        ComTypeOutConverter<ITrustedPlatformModule> TmpTrustedPlatformModule(aTrustedPlatformModule);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TRUSTEDPLATFORMMODULE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTrustedPlatformModule(TmpTrustedPlatformModule.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TRUSTEDPLATFORMMODULE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpTrustedPlatformModule.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TRUSTEDPLATFORMMODULE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TRUSTEDPLATFORMMODULE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTrustedPlatformModule=%p hrc=%Rhrc\n", this, "Machine::getTrustedPlatformModule", *aTrustedPlatformModule, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(NonVolatileStore)(INvramStore **aNonVolatileStore)
{
    LogRelFlow(("{%p} %s: enter aNonVolatileStore=%p\n", this, "Machine::getNonVolatileStore", aNonVolatileStore));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNonVolatileStore);
        ComTypeOutConverter<INvramStore> TmpNonVolatileStore(aNonVolatileStore);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_NONVOLATILESTORE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNonVolatileStore(TmpNonVolatileStore.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_NONVOLATILESTORE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpNonVolatileStore.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_NONVOLATILESTORE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_NONVOLATILESTORE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNonVolatileStore=%p hrc=%Rhrc\n", this, "Machine::getNonVolatileStore", *aNonVolatileStore, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(RecordingSettings)(IRecordingSettings **aRecordingSettings)
{
    LogRelFlow(("{%p} %s: enter aRecordingSettings=%p\n", this, "Machine::getRecordingSettings", aRecordingSettings));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecordingSettings);
        ComTypeOutConverter<IRecordingSettings> TmpRecordingSettings(aRecordingSettings);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_RECORDINGSETTINGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecordingSettings(TmpRecordingSettings.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_RECORDINGSETTINGS_RETURN(this, hrc, 0 /*normal*/,(void *)TmpRecordingSettings.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_RECORDINGSETTINGS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_RECORDINGSETTINGS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecordingSettings=%p hrc=%Rhrc\n", this, "Machine::getRecordingSettings", *aRecordingSettings, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(PointingHIDType)(PointingHIDType_T *aPointingHIDType)
{
    LogRelFlow(("{%p} %s: enter aPointingHIDType=%p\n", this, "Machine::getPointingHIDType", aPointingHIDType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPointingHIDType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_POINTINGHIDTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPointingHIDType(aPointingHIDType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_POINTINGHIDTYPE_RETURN(this, hrc, 0 /*normal*/,*aPointingHIDType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_POINTINGHIDTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aPointingHIDType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_POINTINGHIDTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aPointingHIDType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPointingHIDType=%RU32 hrc=%Rhrc\n", this, "Machine::getPointingHIDType", *aPointingHIDType, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(PointingHIDType)(PointingHIDType_T aPointingHIDType)
{
    LogRelFlow(("{%p} %s: enter aPointingHIDType=%RU32\n", this, "Machine::setPointingHIDType", aPointingHIDType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_POINTINGHIDTYPE_ENTER(this, aPointingHIDType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPointingHIDType(aPointingHIDType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_POINTINGHIDTYPE_RETURN(this, hrc, 0 /*normal*/,aPointingHIDType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_POINTINGHIDTYPE_RETURN(this, hrc, 1 /*hrc exception*/,aPointingHIDType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_POINTINGHIDTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aPointingHIDType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setPointingHIDType", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(KeyboardHIDType)(KeyboardHIDType_T *aKeyboardHIDType)
{
    LogRelFlow(("{%p} %s: enter aKeyboardHIDType=%p\n", this, "Machine::getKeyboardHIDType", aKeyboardHIDType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aKeyboardHIDType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_KEYBOARDHIDTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getKeyboardHIDType(aKeyboardHIDType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_KEYBOARDHIDTYPE_RETURN(this, hrc, 0 /*normal*/,*aKeyboardHIDType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_KEYBOARDHIDTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aKeyboardHIDType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_KEYBOARDHIDTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aKeyboardHIDType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aKeyboardHIDType=%RU32 hrc=%Rhrc\n", this, "Machine::getKeyboardHIDType", *aKeyboardHIDType, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(KeyboardHIDType)(KeyboardHIDType_T aKeyboardHIDType)
{
    LogRelFlow(("{%p} %s: enter aKeyboardHIDType=%RU32\n", this, "Machine::setKeyboardHIDType", aKeyboardHIDType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_KEYBOARDHIDTYPE_ENTER(this, aKeyboardHIDType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setKeyboardHIDType(aKeyboardHIDType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_KEYBOARDHIDTYPE_RETURN(this, hrc, 0 /*normal*/,aKeyboardHIDType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_KEYBOARDHIDTYPE_RETURN(this, hrc, 1 /*hrc exception*/,aKeyboardHIDType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_KEYBOARDHIDTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aKeyboardHIDType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setKeyboardHIDType", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(SnapshotFolder)(BSTR *aSnapshotFolder)
{
    LogRelFlow(("{%p} %s: enter aSnapshotFolder=%p\n", this, "Machine::getSnapshotFolder", aSnapshotFolder));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSnapshotFolder);
        BSTROutConverter TmpSnapshotFolder(aSnapshotFolder);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SNAPSHOTFOLDER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSnapshotFolder(TmpSnapshotFolder.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SNAPSHOTFOLDER_RETURN(this, hrc, 0 /*normal*/,TmpSnapshotFolder.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SNAPSHOTFOLDER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SNAPSHOTFOLDER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSnapshotFolder=%ls hrc=%Rhrc\n", this, "Machine::getSnapshotFolder", *aSnapshotFolder, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(SnapshotFolder)(IN_BSTR aSnapshotFolder)
{
    LogRelFlow(("{%p} %s: enter aSnapshotFolder=%ls\n", this, "Machine::setSnapshotFolder", aSnapshotFolder));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpSnapshotFolder(aSnapshotFolder);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_SNAPSHOTFOLDER_ENTER(this, TmpSnapshotFolder.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSnapshotFolder(TmpSnapshotFolder.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_SNAPSHOTFOLDER_RETURN(this, hrc, 0 /*normal*/,TmpSnapshotFolder.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_SNAPSHOTFOLDER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_SNAPSHOTFOLDER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setSnapshotFolder", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(VRDEServer)(IVRDEServer **aVRDEServer)
{
    LogRelFlow(("{%p} %s: enter aVRDEServer=%p\n", this, "Machine::getVRDEServer", aVRDEServer));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVRDEServer);
        ComTypeOutConverter<IVRDEServer> TmpVRDEServer(aVRDEServer);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_VRDESERVER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVRDEServer(TmpVRDEServer.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_VRDESERVER_RETURN(this, hrc, 0 /*normal*/,(void *)TmpVRDEServer.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_VRDESERVER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_VRDESERVER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVRDEServer=%p hrc=%Rhrc\n", this, "Machine::getVRDEServer", *aVRDEServer, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(EmulatedUSBCardReaderEnabled)(BOOL *aEmulatedUSBCardReaderEnabled)
{
    LogRelFlow(("{%p} %s: enter aEmulatedUSBCardReaderEnabled=%p\n", this, "Machine::getEmulatedUSBCardReaderEnabled", aEmulatedUSBCardReaderEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEmulatedUSBCardReaderEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_EMULATEDUSBCARDREADERENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEmulatedUSBCardReaderEnabled(aEmulatedUSBCardReaderEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_EMULATEDUSBCARDREADERENABLED_RETURN(this, hrc, 0 /*normal*/,*aEmulatedUSBCardReaderEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_EMULATEDUSBCARDREADERENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEmulatedUSBCardReaderEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_EMULATEDUSBCARDREADERENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEmulatedUSBCardReaderEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEmulatedUSBCardReaderEnabled=%RTbool hrc=%Rhrc\n", this, "Machine::getEmulatedUSBCardReaderEnabled", *aEmulatedUSBCardReaderEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(EmulatedUSBCardReaderEnabled)(BOOL aEmulatedUSBCardReaderEnabled)
{
    LogRelFlow(("{%p} %s: enter aEmulatedUSBCardReaderEnabled=%RTbool\n", this, "Machine::setEmulatedUSBCardReaderEnabled", aEmulatedUSBCardReaderEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_EMULATEDUSBCARDREADERENABLED_ENTER(this, aEmulatedUSBCardReaderEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEmulatedUSBCardReaderEnabled(aEmulatedUSBCardReaderEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_EMULATEDUSBCARDREADERENABLED_RETURN(this, hrc, 0 /*normal*/,aEmulatedUSBCardReaderEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_EMULATEDUSBCARDREADERENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aEmulatedUSBCardReaderEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_EMULATEDUSBCARDREADERENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aEmulatedUSBCardReaderEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setEmulatedUSBCardReaderEnabled", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(MediumAttachments)(ComSafeArrayOut(IMediumAttachment *, aMediumAttachments))
{
    LogRelFlow(("{%p} %s: enter aMediumAttachments=%p\n", this, "Machine::getMediumAttachments", aMediumAttachments));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMediumAttachments);
        ArrayComTypeOutConverter<IMediumAttachment> TmpMediumAttachments(ComSafeArrayOutArg(aMediumAttachments));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_MEDIUMATTACHMENTS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMediumAttachments(TmpMediumAttachments.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_MEDIUMATTACHMENTS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpMediumAttachments.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_MEDIUMATTACHMENTS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_MEDIUMATTACHMENTS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMediumAttachments=%zu hrc=%Rhrc\n", this, "Machine::getMediumAttachments", ComSafeArraySize(*aMediumAttachments), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(USBControllers)(ComSafeArrayOut(IUSBController *, aUSBControllers))
{
    LogRelFlow(("{%p} %s: enter aUSBControllers=%p\n", this, "Machine::getUSBControllers", aUSBControllers));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUSBControllers);
        ArrayComTypeOutConverter<IUSBController> TmpUSBControllers(ComSafeArrayOutArg(aUSBControllers));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_USBCONTROLLERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUSBControllers(TmpUSBControllers.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_USBCONTROLLERS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpUSBControllers.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_USBCONTROLLERS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_USBCONTROLLERS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUSBControllers=%zu hrc=%Rhrc\n", this, "Machine::getUSBControllers", ComSafeArraySize(*aUSBControllers), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(USBDeviceFilters)(IUSBDeviceFilters **aUSBDeviceFilters)
{
    LogRelFlow(("{%p} %s: enter aUSBDeviceFilters=%p\n", this, "Machine::getUSBDeviceFilters", aUSBDeviceFilters));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUSBDeviceFilters);
        ComTypeOutConverter<IUSBDeviceFilters> TmpUSBDeviceFilters(aUSBDeviceFilters);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_USBDEVICEFILTERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUSBDeviceFilters(TmpUSBDeviceFilters.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_USBDEVICEFILTERS_RETURN(this, hrc, 0 /*normal*/,(void *)TmpUSBDeviceFilters.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_USBDEVICEFILTERS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_USBDEVICEFILTERS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUSBDeviceFilters=%p hrc=%Rhrc\n", this, "Machine::getUSBDeviceFilters", *aUSBDeviceFilters, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(AudioSettings)(IAudioSettings **aAudioSettings)
{
    LogRelFlow(("{%p} %s: enter aAudioSettings=%p\n", this, "Machine::getAudioSettings", aAudioSettings));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAudioSettings);
        ComTypeOutConverter<IAudioSettings> TmpAudioSettings(aAudioSettings);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUDIOSETTINGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAudioSettings(TmpAudioSettings.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUDIOSETTINGS_RETURN(this, hrc, 0 /*normal*/,(void *)TmpAudioSettings.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUDIOSETTINGS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUDIOSETTINGS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAudioSettings=%p hrc=%Rhrc\n", this, "Machine::getAudioSettings", *aAudioSettings, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(StorageControllers)(ComSafeArrayOut(IStorageController *, aStorageControllers))
{
    LogRelFlow(("{%p} %s: enter aStorageControllers=%p\n", this, "Machine::getStorageControllers", aStorageControllers));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStorageControllers);
        ArrayComTypeOutConverter<IStorageController> TmpStorageControllers(ComSafeArrayOutArg(aStorageControllers));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STORAGECONTROLLERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStorageControllers(TmpStorageControllers.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STORAGECONTROLLERS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpStorageControllers.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STORAGECONTROLLERS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STORAGECONTROLLERS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStorageControllers=%zu hrc=%Rhrc\n", this, "Machine::getStorageControllers", ComSafeArraySize(*aStorageControllers), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(SettingsFilePath)(BSTR *aSettingsFilePath)
{
    LogRelFlow(("{%p} %s: enter aSettingsFilePath=%p\n", this, "Machine::getSettingsFilePath", aSettingsFilePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSettingsFilePath);
        BSTROutConverter TmpSettingsFilePath(aSettingsFilePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SETTINGSFILEPATH_ENTER(this);
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSettingsFilePath(TmpSettingsFilePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SETTINGSFILEPATH_RETURN(this, hrc, 0 /*normal*/,TmpSettingsFilePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SETTINGSFILEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SETTINGSFILEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSettingsFilePath=%ls hrc=%Rhrc\n", this, "Machine::getSettingsFilePath", *aSettingsFilePath, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(SettingsAuxFilePath)(BSTR *aSettingsAuxFilePath)
{
    LogRelFlow(("{%p} %s: enter aSettingsAuxFilePath=%p\n", this, "Machine::getSettingsAuxFilePath", aSettingsAuxFilePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSettingsAuxFilePath);
        BSTROutConverter TmpSettingsAuxFilePath(aSettingsAuxFilePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SETTINGSAUXFILEPATH_ENTER(this);
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSettingsAuxFilePath(TmpSettingsAuxFilePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SETTINGSAUXFILEPATH_RETURN(this, hrc, 0 /*normal*/,TmpSettingsAuxFilePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SETTINGSAUXFILEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SETTINGSAUXFILEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSettingsAuxFilePath=%ls hrc=%Rhrc\n", this, "Machine::getSettingsAuxFilePath", *aSettingsAuxFilePath, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(SettingsModified)(BOOL *aSettingsModified)
{
    LogRelFlow(("{%p} %s: enter aSettingsModified=%p\n", this, "Machine::getSettingsModified", aSettingsModified));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSettingsModified);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SETTINGSMODIFIED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSettingsModified(aSettingsModified);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SETTINGSMODIFIED_RETURN(this, hrc, 0 /*normal*/,*aSettingsModified != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SETTINGSMODIFIED_RETURN(this, hrc, 1 /*hrc exception*/,*aSettingsModified != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SETTINGSMODIFIED_RETURN(this, hrc, 9 /*unhandled exception*/,*aSettingsModified != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSettingsModified=%RTbool hrc=%Rhrc\n", this, "Machine::getSettingsModified", *aSettingsModified, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(SessionState)(SessionState_T *aSessionState)
{
    LogRelFlow(("{%p} %s: enter aSessionState=%p\n", this, "Machine::getSessionState", aSessionState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSessionState);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SESSIONSTATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSessionState(aSessionState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SESSIONSTATE_RETURN(this, hrc, 0 /*normal*/,*aSessionState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SESSIONSTATE_RETURN(this, hrc, 1 /*hrc exception*/,*aSessionState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SESSIONSTATE_RETURN(this, hrc, 9 /*unhandled exception*/,*aSessionState);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSessionState=%RU32 hrc=%Rhrc\n", this, "Machine::getSessionState", *aSessionState, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(SessionName)(BSTR *aSessionName)
{
    LogRelFlow(("{%p} %s: enter aSessionName=%p\n", this, "Machine::getSessionName", aSessionName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSessionName);
        BSTROutConverter TmpSessionName(aSessionName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SESSIONNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSessionName(TmpSessionName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SESSIONNAME_RETURN(this, hrc, 0 /*normal*/,TmpSessionName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SESSIONNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SESSIONNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSessionName=%ls hrc=%Rhrc\n", this, "Machine::getSessionName", *aSessionName, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(SessionPID)(ULONG *aSessionPID)
{
    LogRelFlow(("{%p} %s: enter aSessionPID=%p\n", this, "Machine::getSessionPID", aSessionPID));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSessionPID);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SESSIONPID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSessionPID(aSessionPID);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SESSIONPID_RETURN(this, hrc, 0 /*normal*/,*aSessionPID);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SESSIONPID_RETURN(this, hrc, 1 /*hrc exception*/,*aSessionPID);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SESSIONPID_RETURN(this, hrc, 9 /*unhandled exception*/,*aSessionPID);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSessionPID=%RU32 hrc=%Rhrc\n", this, "Machine::getSessionPID", *aSessionPID, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(State)(MachineState_T *aState)
{
    LogRelFlow(("{%p} %s: enter aState=%p\n", this, "Machine::getState", aState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aState);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getState(aState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATE_RETURN(this, hrc, 0 /*normal*/,*aState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATE_RETURN(this, hrc, 1 /*hrc exception*/,*aState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATE_RETURN(this, hrc, 9 /*unhandled exception*/,*aState);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aState=%RU32 hrc=%Rhrc\n", this, "Machine::getState", *aState, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(LastStateChange)(LONG64 *aLastStateChange)
{
    LogRelFlow(("{%p} %s: enter aLastStateChange=%p\n", this, "Machine::getLastStateChange", aLastStateChange));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLastStateChange);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LASTSTATECHANGE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLastStateChange(aLastStateChange);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LASTSTATECHANGE_RETURN(this, hrc, 0 /*normal*/,*aLastStateChange);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LASTSTATECHANGE_RETURN(this, hrc, 1 /*hrc exception*/,*aLastStateChange);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LASTSTATECHANGE_RETURN(this, hrc, 9 /*unhandled exception*/,*aLastStateChange);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLastStateChange=%RI64 hrc=%Rhrc\n", this, "Machine::getLastStateChange", *aLastStateChange, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(StateFilePath)(BSTR *aStateFilePath)
{
    LogRelFlow(("{%p} %s: enter aStateFilePath=%p\n", this, "Machine::getStateFilePath", aStateFilePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStateFilePath);
        BSTROutConverter TmpStateFilePath(aStateFilePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATEFILEPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStateFilePath(TmpStateFilePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATEFILEPATH_RETURN(this, hrc, 0 /*normal*/,TmpStateFilePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATEFILEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATEFILEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStateFilePath=%ls hrc=%Rhrc\n", this, "Machine::getStateFilePath", *aStateFilePath, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(LogFolder)(BSTR *aLogFolder)
{
    LogRelFlow(("{%p} %s: enter aLogFolder=%p\n", this, "Machine::getLogFolder", aLogFolder));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogFolder);
        BSTROutConverter TmpLogFolder(aLogFolder);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LOGFOLDER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogFolder(TmpLogFolder.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LOGFOLDER_RETURN(this, hrc, 0 /*normal*/,TmpLogFolder.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LOGFOLDER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LOGFOLDER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogFolder=%ls hrc=%Rhrc\n", this, "Machine::getLogFolder", *aLogFolder, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(CurrentSnapshot)(ISnapshot **aCurrentSnapshot)
{
    LogRelFlow(("{%p} %s: enter aCurrentSnapshot=%p\n", this, "Machine::getCurrentSnapshot", aCurrentSnapshot));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCurrentSnapshot);
        ComTypeOutConverter<ISnapshot> TmpCurrentSnapshot(aCurrentSnapshot);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CURRENTSNAPSHOT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCurrentSnapshot(TmpCurrentSnapshot.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CURRENTSNAPSHOT_RETURN(this, hrc, 0 /*normal*/,(void *)TmpCurrentSnapshot.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CURRENTSNAPSHOT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CURRENTSNAPSHOT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCurrentSnapshot=%p hrc=%Rhrc\n", this, "Machine::getCurrentSnapshot", *aCurrentSnapshot, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(SnapshotCount)(ULONG *aSnapshotCount)
{
    LogRelFlow(("{%p} %s: enter aSnapshotCount=%p\n", this, "Machine::getSnapshotCount", aSnapshotCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSnapshotCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SNAPSHOTCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSnapshotCount(aSnapshotCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SNAPSHOTCOUNT_RETURN(this, hrc, 0 /*normal*/,*aSnapshotCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SNAPSHOTCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aSnapshotCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SNAPSHOTCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aSnapshotCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSnapshotCount=%RU32 hrc=%Rhrc\n", this, "Machine::getSnapshotCount", *aSnapshotCount, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(CurrentStateModified)(BOOL *aCurrentStateModified)
{
    LogRelFlow(("{%p} %s: enter aCurrentStateModified=%p\n", this, "Machine::getCurrentStateModified", aCurrentStateModified));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCurrentStateModified);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CURRENTSTATEMODIFIED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCurrentStateModified(aCurrentStateModified);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CURRENTSTATEMODIFIED_RETURN(this, hrc, 0 /*normal*/,*aCurrentStateModified != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CURRENTSTATEMODIFIED_RETURN(this, hrc, 1 /*hrc exception*/,*aCurrentStateModified != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CURRENTSTATEMODIFIED_RETURN(this, hrc, 9 /*unhandled exception*/,*aCurrentStateModified != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCurrentStateModified=%RTbool hrc=%Rhrc\n", this, "Machine::getCurrentStateModified", *aCurrentStateModified, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(SharedFolders)(ComSafeArrayOut(ISharedFolder *, aSharedFolders))
{
    LogRelFlow(("{%p} %s: enter aSharedFolders=%p\n", this, "Machine::getSharedFolders", aSharedFolders));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSharedFolders);
        ArrayComTypeOutConverter<ISharedFolder> TmpSharedFolders(ComSafeArrayOutArg(aSharedFolders));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SHAREDFOLDERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSharedFolders(TmpSharedFolders.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SHAREDFOLDERS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSharedFolders.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SHAREDFOLDERS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_SHAREDFOLDERS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSharedFolders=%zu hrc=%Rhrc\n", this, "Machine::getSharedFolders", ComSafeArraySize(*aSharedFolders), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(ClipboardMode)(ClipboardMode_T *aClipboardMode)
{
    LogRelFlow(("{%p} %s: enter aClipboardMode=%p\n", this, "Machine::getClipboardMode", aClipboardMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aClipboardMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CLIPBOARDMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getClipboardMode(aClipboardMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CLIPBOARDMODE_RETURN(this, hrc, 0 /*normal*/,*aClipboardMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CLIPBOARDMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aClipboardMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CLIPBOARDMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aClipboardMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aClipboardMode=%RU32 hrc=%Rhrc\n", this, "Machine::getClipboardMode", *aClipboardMode, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(ClipboardMode)(ClipboardMode_T aClipboardMode)
{
    LogRelFlow(("{%p} %s: enter aClipboardMode=%RU32\n", this, "Machine::setClipboardMode", aClipboardMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CLIPBOARDMODE_ENTER(this, aClipboardMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setClipboardMode(aClipboardMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CLIPBOARDMODE_RETURN(this, hrc, 0 /*normal*/,aClipboardMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CLIPBOARDMODE_RETURN(this, hrc, 1 /*hrc exception*/,aClipboardMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CLIPBOARDMODE_RETURN(this, hrc, 9 /*unhandled exception*/,aClipboardMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setClipboardMode", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(ClipboardFileTransfersEnabled)(BOOL *aClipboardFileTransfersEnabled)
{
    LogRelFlow(("{%p} %s: enter aClipboardFileTransfersEnabled=%p\n", this, "Machine::getClipboardFileTransfersEnabled", aClipboardFileTransfersEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aClipboardFileTransfersEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CLIPBOARDFILETRANSFERSENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getClipboardFileTransfersEnabled(aClipboardFileTransfersEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CLIPBOARDFILETRANSFERSENABLED_RETURN(this, hrc, 0 /*normal*/,*aClipboardFileTransfersEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CLIPBOARDFILETRANSFERSENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aClipboardFileTransfersEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CLIPBOARDFILETRANSFERSENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aClipboardFileTransfersEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aClipboardFileTransfersEnabled=%RTbool hrc=%Rhrc\n", this, "Machine::getClipboardFileTransfersEnabled", *aClipboardFileTransfersEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(ClipboardFileTransfersEnabled)(BOOL aClipboardFileTransfersEnabled)
{
    LogRelFlow(("{%p} %s: enter aClipboardFileTransfersEnabled=%RTbool\n", this, "Machine::setClipboardFileTransfersEnabled", aClipboardFileTransfersEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CLIPBOARDFILETRANSFERSENABLED_ENTER(this, aClipboardFileTransfersEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setClipboardFileTransfersEnabled(aClipboardFileTransfersEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CLIPBOARDFILETRANSFERSENABLED_RETURN(this, hrc, 0 /*normal*/,aClipboardFileTransfersEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CLIPBOARDFILETRANSFERSENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aClipboardFileTransfersEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CLIPBOARDFILETRANSFERSENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aClipboardFileTransfersEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setClipboardFileTransfersEnabled", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(DnDMode)(DnDMode_T *aDnDMode)
{
    LogRelFlow(("{%p} %s: enter aDnDMode=%p\n", this, "Machine::getDnDMode", aDnDMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDnDMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_DNDMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDnDMode(aDnDMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_DNDMODE_RETURN(this, hrc, 0 /*normal*/,*aDnDMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_DNDMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aDnDMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_DNDMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aDnDMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDnDMode=%RU32 hrc=%Rhrc\n", this, "Machine::getDnDMode", *aDnDMode, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(DnDMode)(DnDMode_T aDnDMode)
{
    LogRelFlow(("{%p} %s: enter aDnDMode=%RU32\n", this, "Machine::setDnDMode", aDnDMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_DNDMODE_ENTER(this, aDnDMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDnDMode(aDnDMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_DNDMODE_RETURN(this, hrc, 0 /*normal*/,aDnDMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_DNDMODE_RETURN(this, hrc, 1 /*hrc exception*/,aDnDMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_DNDMODE_RETURN(this, hrc, 9 /*unhandled exception*/,aDnDMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setDnDMode", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(TeleporterEnabled)(BOOL *aTeleporterEnabled)
{
    LogRelFlow(("{%p} %s: enter aTeleporterEnabled=%p\n", this, "Machine::getTeleporterEnabled", aTeleporterEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTeleporterEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTeleporterEnabled(aTeleporterEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERENABLED_RETURN(this, hrc, 0 /*normal*/,*aTeleporterEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aTeleporterEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aTeleporterEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTeleporterEnabled=%RTbool hrc=%Rhrc\n", this, "Machine::getTeleporterEnabled", *aTeleporterEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(TeleporterEnabled)(BOOL aTeleporterEnabled)
{
    LogRelFlow(("{%p} %s: enter aTeleporterEnabled=%RTbool\n", this, "Machine::setTeleporterEnabled", aTeleporterEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERENABLED_ENTER(this, aTeleporterEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTeleporterEnabled(aTeleporterEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERENABLED_RETURN(this, hrc, 0 /*normal*/,aTeleporterEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aTeleporterEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aTeleporterEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setTeleporterEnabled", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(TeleporterPort)(ULONG *aTeleporterPort)
{
    LogRelFlow(("{%p} %s: enter aTeleporterPort=%p\n", this, "Machine::getTeleporterPort", aTeleporterPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTeleporterPort);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERPORT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTeleporterPort(aTeleporterPort);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERPORT_RETURN(this, hrc, 0 /*normal*/,*aTeleporterPort);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERPORT_RETURN(this, hrc, 1 /*hrc exception*/,*aTeleporterPort);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERPORT_RETURN(this, hrc, 9 /*unhandled exception*/,*aTeleporterPort);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTeleporterPort=%RU32 hrc=%Rhrc\n", this, "Machine::getTeleporterPort", *aTeleporterPort, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(TeleporterPort)(ULONG aTeleporterPort)
{
    LogRelFlow(("{%p} %s: enter aTeleporterPort=%RU32\n", this, "Machine::setTeleporterPort", aTeleporterPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERPORT_ENTER(this, aTeleporterPort);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTeleporterPort(aTeleporterPort);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERPORT_RETURN(this, hrc, 0 /*normal*/,aTeleporterPort);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERPORT_RETURN(this, hrc, 1 /*hrc exception*/,aTeleporterPort);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERPORT_RETURN(this, hrc, 9 /*unhandled exception*/,aTeleporterPort);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setTeleporterPort", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(TeleporterAddress)(BSTR *aTeleporterAddress)
{
    LogRelFlow(("{%p} %s: enter aTeleporterAddress=%p\n", this, "Machine::getTeleporterAddress", aTeleporterAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTeleporterAddress);
        BSTROutConverter TmpTeleporterAddress(aTeleporterAddress);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTeleporterAddress(TmpTeleporterAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpTeleporterAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTeleporterAddress=%ls hrc=%Rhrc\n", this, "Machine::getTeleporterAddress", *aTeleporterAddress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(TeleporterAddress)(IN_BSTR aTeleporterAddress)
{
    LogRelFlow(("{%p} %s: enter aTeleporterAddress=%ls\n", this, "Machine::setTeleporterAddress", aTeleporterAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpTeleporterAddress(aTeleporterAddress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERADDRESS_ENTER(this, TmpTeleporterAddress.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTeleporterAddress(TmpTeleporterAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpTeleporterAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setTeleporterAddress", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(TeleporterPassword)(BSTR *aTeleporterPassword)
{
    LogRelFlow(("{%p} %s: enter aTeleporterPassword=%p\n", this, "Machine::getTeleporterPassword", aTeleporterPassword));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTeleporterPassword);
        BSTROutConverter TmpTeleporterPassword(aTeleporterPassword);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERPASSWORD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTeleporterPassword(TmpTeleporterPassword.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERPASSWORD_RETURN(this, hrc, 0 /*normal*/,TmpTeleporterPassword.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERPASSWORD_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TELEPORTERPASSWORD_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTeleporterPassword=%ls hrc=%Rhrc\n", this, "Machine::getTeleporterPassword", *aTeleporterPassword, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(TeleporterPassword)(IN_BSTR aTeleporterPassword)
{
    LogRelFlow(("{%p} %s: enter aTeleporterPassword=%ls\n", this, "Machine::setTeleporterPassword", aTeleporterPassword));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpTeleporterPassword(aTeleporterPassword);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERPASSWORD_ENTER(this, TmpTeleporterPassword.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTeleporterPassword(TmpTeleporterPassword.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERPASSWORD_RETURN(this, hrc, 0 /*normal*/,TmpTeleporterPassword.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERPASSWORD_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TELEPORTERPASSWORD_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setTeleporterPassword", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(ParavirtProvider)(ParavirtProvider_T *aParavirtProvider)
{
    LogRelFlow(("{%p} %s: enter aParavirtProvider=%p\n", this, "Machine::getParavirtProvider", aParavirtProvider));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aParavirtProvider);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PARAVIRTPROVIDER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getParavirtProvider(aParavirtProvider);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PARAVIRTPROVIDER_RETURN(this, hrc, 0 /*normal*/,*aParavirtProvider);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PARAVIRTPROVIDER_RETURN(this, hrc, 1 /*hrc exception*/,*aParavirtProvider);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PARAVIRTPROVIDER_RETURN(this, hrc, 9 /*unhandled exception*/,*aParavirtProvider);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aParavirtProvider=%RU32 hrc=%Rhrc\n", this, "Machine::getParavirtProvider", *aParavirtProvider, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(ParavirtProvider)(ParavirtProvider_T aParavirtProvider)
{
    LogRelFlow(("{%p} %s: enter aParavirtProvider=%RU32\n", this, "Machine::setParavirtProvider", aParavirtProvider));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_PARAVIRTPROVIDER_ENTER(this, aParavirtProvider);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setParavirtProvider(aParavirtProvider);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_PARAVIRTPROVIDER_RETURN(this, hrc, 0 /*normal*/,aParavirtProvider);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_PARAVIRTPROVIDER_RETURN(this, hrc, 1 /*hrc exception*/,aParavirtProvider);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_PARAVIRTPROVIDER_RETURN(this, hrc, 9 /*unhandled exception*/,aParavirtProvider);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setParavirtProvider", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(IOCacheEnabled)(BOOL *aIOCacheEnabled)
{
    LogRelFlow(("{%p} %s: enter aIOCacheEnabled=%p\n", this, "Machine::getIOCacheEnabled", aIOCacheEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIOCacheEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_IOCACHEENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIOCacheEnabled(aIOCacheEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_IOCACHEENABLED_RETURN(this, hrc, 0 /*normal*/,*aIOCacheEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_IOCACHEENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aIOCacheEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_IOCACHEENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aIOCacheEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIOCacheEnabled=%RTbool hrc=%Rhrc\n", this, "Machine::getIOCacheEnabled", *aIOCacheEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(IOCacheEnabled)(BOOL aIOCacheEnabled)
{
    LogRelFlow(("{%p} %s: enter aIOCacheEnabled=%RTbool\n", this, "Machine::setIOCacheEnabled", aIOCacheEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_IOCACHEENABLED_ENTER(this, aIOCacheEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIOCacheEnabled(aIOCacheEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_IOCACHEENABLED_RETURN(this, hrc, 0 /*normal*/,aIOCacheEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_IOCACHEENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aIOCacheEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_IOCACHEENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aIOCacheEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setIOCacheEnabled", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(IOCacheSize)(ULONG *aIOCacheSize)
{
    LogRelFlow(("{%p} %s: enter aIOCacheSize=%p\n", this, "Machine::getIOCacheSize", aIOCacheSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIOCacheSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_IOCACHESIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIOCacheSize(aIOCacheSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_IOCACHESIZE_RETURN(this, hrc, 0 /*normal*/,*aIOCacheSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_IOCACHESIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aIOCacheSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_IOCACHESIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aIOCacheSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIOCacheSize=%RU32 hrc=%Rhrc\n", this, "Machine::getIOCacheSize", *aIOCacheSize, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(IOCacheSize)(ULONG aIOCacheSize)
{
    LogRelFlow(("{%p} %s: enter aIOCacheSize=%RU32\n", this, "Machine::setIOCacheSize", aIOCacheSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_IOCACHESIZE_ENTER(this, aIOCacheSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIOCacheSize(aIOCacheSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_IOCACHESIZE_RETURN(this, hrc, 0 /*normal*/,aIOCacheSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_IOCACHESIZE_RETURN(this, hrc, 1 /*hrc exception*/,aIOCacheSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_IOCACHESIZE_RETURN(this, hrc, 9 /*unhandled exception*/,aIOCacheSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setIOCacheSize", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(PCIDeviceAssignments)(ComSafeArrayOut(IPCIDeviceAttachment *, aPCIDeviceAssignments))
{
    LogRelFlow(("{%p} %s: enter aPCIDeviceAssignments=%p\n", this, "Machine::getPCIDeviceAssignments", aPCIDeviceAssignments));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPCIDeviceAssignments);
        ArrayComTypeOutConverter<IPCIDeviceAttachment> TmpPCIDeviceAssignments(ComSafeArrayOutArg(aPCIDeviceAssignments));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PCIDEVICEASSIGNMENTS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPCIDeviceAssignments(TmpPCIDeviceAssignments.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PCIDEVICEASSIGNMENTS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpPCIDeviceAssignments.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PCIDEVICEASSIGNMENTS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PCIDEVICEASSIGNMENTS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPCIDeviceAssignments=%zu hrc=%Rhrc\n", this, "Machine::getPCIDeviceAssignments", ComSafeArraySize(*aPCIDeviceAssignments), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(BandwidthControl)(IBandwidthControl **aBandwidthControl)
{
    LogRelFlow(("{%p} %s: enter aBandwidthControl=%p\n", this, "Machine::getBandwidthControl", aBandwidthControl));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBandwidthControl);
        ComTypeOutConverter<IBandwidthControl> TmpBandwidthControl(aBandwidthControl);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_BANDWIDTHCONTROL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBandwidthControl(TmpBandwidthControl.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_BANDWIDTHCONTROL_RETURN(this, hrc, 0 /*normal*/,(void *)TmpBandwidthControl.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_BANDWIDTHCONTROL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_BANDWIDTHCONTROL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBandwidthControl=%p hrc=%Rhrc\n", this, "Machine::getBandwidthControl", *aBandwidthControl, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(TracingEnabled)(BOOL *aTracingEnabled)
{
    LogRelFlow(("{%p} %s: enter aTracingEnabled=%p\n", this, "Machine::getTracingEnabled", aTracingEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTracingEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TRACINGENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTracingEnabled(aTracingEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TRACINGENABLED_RETURN(this, hrc, 0 /*normal*/,*aTracingEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TRACINGENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aTracingEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TRACINGENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aTracingEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTracingEnabled=%RTbool hrc=%Rhrc\n", this, "Machine::getTracingEnabled", *aTracingEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(TracingEnabled)(BOOL aTracingEnabled)
{
    LogRelFlow(("{%p} %s: enter aTracingEnabled=%RTbool\n", this, "Machine::setTracingEnabled", aTracingEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TRACINGENABLED_ENTER(this, aTracingEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTracingEnabled(aTracingEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TRACINGENABLED_RETURN(this, hrc, 0 /*normal*/,aTracingEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TRACINGENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aTracingEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TRACINGENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aTracingEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setTracingEnabled", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(TracingConfig)(BSTR *aTracingConfig)
{
    LogRelFlow(("{%p} %s: enter aTracingConfig=%p\n", this, "Machine::getTracingConfig", aTracingConfig));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTracingConfig);
        BSTROutConverter TmpTracingConfig(aTracingConfig);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TRACINGCONFIG_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTracingConfig(TmpTracingConfig.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TRACINGCONFIG_RETURN(this, hrc, 0 /*normal*/,TmpTracingConfig.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TRACINGCONFIG_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_TRACINGCONFIG_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTracingConfig=%ls hrc=%Rhrc\n", this, "Machine::getTracingConfig", *aTracingConfig, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(TracingConfig)(IN_BSTR aTracingConfig)
{
    LogRelFlow(("{%p} %s: enter aTracingConfig=%ls\n", this, "Machine::setTracingConfig", aTracingConfig));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpTracingConfig(aTracingConfig);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TRACINGCONFIG_ENTER(this, TmpTracingConfig.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTracingConfig(TmpTracingConfig.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TRACINGCONFIG_RETURN(this, hrc, 0 /*normal*/,TmpTracingConfig.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TRACINGCONFIG_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_TRACINGCONFIG_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setTracingConfig", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(AllowTracingToAccessVM)(BOOL *aAllowTracingToAccessVM)
{
    LogRelFlow(("{%p} %s: enter aAllowTracingToAccessVM=%p\n", this, "Machine::getAllowTracingToAccessVM", aAllowTracingToAccessVM));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAllowTracingToAccessVM);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ALLOWTRACINGTOACCESSVM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAllowTracingToAccessVM(aAllowTracingToAccessVM);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ALLOWTRACINGTOACCESSVM_RETURN(this, hrc, 0 /*normal*/,*aAllowTracingToAccessVM != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ALLOWTRACINGTOACCESSVM_RETURN(this, hrc, 1 /*hrc exception*/,*aAllowTracingToAccessVM != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_ALLOWTRACINGTOACCESSVM_RETURN(this, hrc, 9 /*unhandled exception*/,*aAllowTracingToAccessVM != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAllowTracingToAccessVM=%RTbool hrc=%Rhrc\n", this, "Machine::getAllowTracingToAccessVM", *aAllowTracingToAccessVM, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(AllowTracingToAccessVM)(BOOL aAllowTracingToAccessVM)
{
    LogRelFlow(("{%p} %s: enter aAllowTracingToAccessVM=%RTbool\n", this, "Machine::setAllowTracingToAccessVM", aAllowTracingToAccessVM));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_ALLOWTRACINGTOACCESSVM_ENTER(this, aAllowTracingToAccessVM != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAllowTracingToAccessVM(aAllowTracingToAccessVM != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_ALLOWTRACINGTOACCESSVM_RETURN(this, hrc, 0 /*normal*/,aAllowTracingToAccessVM != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_ALLOWTRACINGTOACCESSVM_RETURN(this, hrc, 1 /*hrc exception*/,aAllowTracingToAccessVM != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_ALLOWTRACINGTOACCESSVM_RETURN(this, hrc, 9 /*unhandled exception*/,aAllowTracingToAccessVM != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setAllowTracingToAccessVM", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(AutostartEnabled)(BOOL *aAutostartEnabled)
{
    LogRelFlow(("{%p} %s: enter aAutostartEnabled=%p\n", this, "Machine::getAutostartEnabled", aAutostartEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAutostartEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUTOSTARTENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAutostartEnabled(aAutostartEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUTOSTARTENABLED_RETURN(this, hrc, 0 /*normal*/,*aAutostartEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUTOSTARTENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aAutostartEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUTOSTARTENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aAutostartEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAutostartEnabled=%RTbool hrc=%Rhrc\n", this, "Machine::getAutostartEnabled", *aAutostartEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(AutostartEnabled)(BOOL aAutostartEnabled)
{
    LogRelFlow(("{%p} %s: enter aAutostartEnabled=%RTbool\n", this, "Machine::setAutostartEnabled", aAutostartEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_AUTOSTARTENABLED_ENTER(this, aAutostartEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAutostartEnabled(aAutostartEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_AUTOSTARTENABLED_RETURN(this, hrc, 0 /*normal*/,aAutostartEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_AUTOSTARTENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aAutostartEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_AUTOSTARTENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aAutostartEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setAutostartEnabled", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(AutostartDelay)(ULONG *aAutostartDelay)
{
    LogRelFlow(("{%p} %s: enter aAutostartDelay=%p\n", this, "Machine::getAutostartDelay", aAutostartDelay));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAutostartDelay);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUTOSTARTDELAY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAutostartDelay(aAutostartDelay);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUTOSTARTDELAY_RETURN(this, hrc, 0 /*normal*/,*aAutostartDelay);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUTOSTARTDELAY_RETURN(this, hrc, 1 /*hrc exception*/,*aAutostartDelay);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUTOSTARTDELAY_RETURN(this, hrc, 9 /*unhandled exception*/,*aAutostartDelay);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAutostartDelay=%RU32 hrc=%Rhrc\n", this, "Machine::getAutostartDelay", *aAutostartDelay, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(AutostartDelay)(ULONG aAutostartDelay)
{
    LogRelFlow(("{%p} %s: enter aAutostartDelay=%RU32\n", this, "Machine::setAutostartDelay", aAutostartDelay));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_AUTOSTARTDELAY_ENTER(this, aAutostartDelay);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAutostartDelay(aAutostartDelay);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_AUTOSTARTDELAY_RETURN(this, hrc, 0 /*normal*/,aAutostartDelay);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_AUTOSTARTDELAY_RETURN(this, hrc, 1 /*hrc exception*/,aAutostartDelay);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_AUTOSTARTDELAY_RETURN(this, hrc, 9 /*unhandled exception*/,aAutostartDelay);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setAutostartDelay", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(AutostopType)(AutostopType_T *aAutostopType)
{
    LogRelFlow(("{%p} %s: enter aAutostopType=%p\n", this, "Machine::getAutostopType", aAutostopType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAutostopType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUTOSTOPTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAutostopType(aAutostopType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUTOSTOPTYPE_RETURN(this, hrc, 0 /*normal*/,*aAutostopType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUTOSTOPTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aAutostopType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_AUTOSTOPTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAutostopType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAutostopType=%RU32 hrc=%Rhrc\n", this, "Machine::getAutostopType", *aAutostopType, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(AutostopType)(AutostopType_T aAutostopType)
{
    LogRelFlow(("{%p} %s: enter aAutostopType=%RU32\n", this, "Machine::setAutostopType", aAutostopType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_AUTOSTOPTYPE_ENTER(this, aAutostopType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAutostopType(aAutostopType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_AUTOSTOPTYPE_RETURN(this, hrc, 0 /*normal*/,aAutostopType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_AUTOSTOPTYPE_RETURN(this, hrc, 1 /*hrc exception*/,aAutostopType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_AUTOSTOPTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aAutostopType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setAutostopType", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(DefaultFrontend)(BSTR *aDefaultFrontend)
{
    LogRelFlow(("{%p} %s: enter aDefaultFrontend=%p\n", this, "Machine::getDefaultFrontend", aDefaultFrontend));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDefaultFrontend);
        BSTROutConverter TmpDefaultFrontend(aDefaultFrontend);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_DEFAULTFRONTEND_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultFrontend(TmpDefaultFrontend.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_DEFAULTFRONTEND_RETURN(this, hrc, 0 /*normal*/,TmpDefaultFrontend.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_DEFAULTFRONTEND_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_DEFAULTFRONTEND_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDefaultFrontend=%ls hrc=%Rhrc\n", this, "Machine::getDefaultFrontend", *aDefaultFrontend, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(DefaultFrontend)(IN_BSTR aDefaultFrontend)
{
    LogRelFlow(("{%p} %s: enter aDefaultFrontend=%ls\n", this, "Machine::setDefaultFrontend", aDefaultFrontend));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpDefaultFrontend(aDefaultFrontend);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_DEFAULTFRONTEND_ENTER(this, TmpDefaultFrontend.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDefaultFrontend(TmpDefaultFrontend.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_DEFAULTFRONTEND_RETURN(this, hrc, 0 /*normal*/,TmpDefaultFrontend.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_DEFAULTFRONTEND_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_DEFAULTFRONTEND_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setDefaultFrontend", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(USBProxyAvailable)(BOOL *aUSBProxyAvailable)
{
    LogRelFlow(("{%p} %s: enter aUSBProxyAvailable=%p\n", this, "Machine::getUSBProxyAvailable", aUSBProxyAvailable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUSBProxyAvailable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_USBPROXYAVAILABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUSBProxyAvailable(aUSBProxyAvailable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_USBPROXYAVAILABLE_RETURN(this, hrc, 0 /*normal*/,*aUSBProxyAvailable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_USBPROXYAVAILABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aUSBProxyAvailable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_USBPROXYAVAILABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aUSBProxyAvailable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUSBProxyAvailable=%RTbool hrc=%Rhrc\n", this, "Machine::getUSBProxyAvailable", *aUSBProxyAvailable, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(VMProcessPriority)(VMProcPriority_T *aVMProcessPriority)
{
    LogRelFlow(("{%p} %s: enter aVMProcessPriority=%p\n", this, "Machine::getVMProcessPriority", aVMProcessPriority));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVMProcessPriority);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_VMPROCESSPRIORITY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVMProcessPriority(aVMProcessPriority);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_VMPROCESSPRIORITY_RETURN(this, hrc, 0 /*normal*/,*aVMProcessPriority);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_VMPROCESSPRIORITY_RETURN(this, hrc, 1 /*hrc exception*/,*aVMProcessPriority);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_VMPROCESSPRIORITY_RETURN(this, hrc, 9 /*unhandled exception*/,*aVMProcessPriority);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVMProcessPriority=%RU32 hrc=%Rhrc\n", this, "Machine::getVMProcessPriority", *aVMProcessPriority, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(VMProcessPriority)(VMProcPriority_T aVMProcessPriority)
{
    LogRelFlow(("{%p} %s: enter aVMProcessPriority=%RU32\n", this, "Machine::setVMProcessPriority", aVMProcessPriority));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_VMPROCESSPRIORITY_ENTER(this, aVMProcessPriority);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVMProcessPriority(aVMProcessPriority);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_VMPROCESSPRIORITY_RETURN(this, hrc, 0 /*normal*/,aVMProcessPriority);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_VMPROCESSPRIORITY_RETURN(this, hrc, 1 /*hrc exception*/,aVMProcessPriority);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_VMPROCESSPRIORITY_RETURN(this, hrc, 9 /*unhandled exception*/,aVMProcessPriority);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setVMProcessPriority", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(VMExecutionEngine)(VMExecutionEngine_T *aVMExecutionEngine)
{
    LogRelFlow(("{%p} %s: enter aVMExecutionEngine=%p\n", this, "Machine::getVMExecutionEngine", aVMExecutionEngine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVMExecutionEngine);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_VMEXECUTIONENGINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVMExecutionEngine(aVMExecutionEngine);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_VMEXECUTIONENGINE_RETURN(this, hrc, 0 /*normal*/,*aVMExecutionEngine);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_VMEXECUTIONENGINE_RETURN(this, hrc, 1 /*hrc exception*/,*aVMExecutionEngine);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_VMEXECUTIONENGINE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVMExecutionEngine);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVMExecutionEngine=%RU32 hrc=%Rhrc\n", this, "Machine::getVMExecutionEngine", *aVMExecutionEngine, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(VMExecutionEngine)(VMExecutionEngine_T aVMExecutionEngine)
{
    LogRelFlow(("{%p} %s: enter aVMExecutionEngine=%RU32\n", this, "Machine::setVMExecutionEngine", aVMExecutionEngine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_VMEXECUTIONENGINE_ENTER(this, aVMExecutionEngine);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVMExecutionEngine(aVMExecutionEngine);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_VMEXECUTIONENGINE_RETURN(this, hrc, 0 /*normal*/,aVMExecutionEngine);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_VMEXECUTIONENGINE_RETURN(this, hrc, 1 /*hrc exception*/,aVMExecutionEngine);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_VMEXECUTIONENGINE_RETURN(this, hrc, 9 /*unhandled exception*/,aVMExecutionEngine);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setVMExecutionEngine", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(ParavirtDebug)(BSTR *aParavirtDebug)
{
    LogRelFlow(("{%p} %s: enter aParavirtDebug=%p\n", this, "Machine::getParavirtDebug", aParavirtDebug));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aParavirtDebug);
        BSTROutConverter TmpParavirtDebug(aParavirtDebug);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PARAVIRTDEBUG_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getParavirtDebug(TmpParavirtDebug.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PARAVIRTDEBUG_RETURN(this, hrc, 0 /*normal*/,TmpParavirtDebug.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PARAVIRTDEBUG_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_PARAVIRTDEBUG_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aParavirtDebug=%ls hrc=%Rhrc\n", this, "Machine::getParavirtDebug", *aParavirtDebug, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(ParavirtDebug)(IN_BSTR aParavirtDebug)
{
    LogRelFlow(("{%p} %s: enter aParavirtDebug=%ls\n", this, "Machine::setParavirtDebug", aParavirtDebug));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpParavirtDebug(aParavirtDebug);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_PARAVIRTDEBUG_ENTER(this, TmpParavirtDebug.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setParavirtDebug(TmpParavirtDebug.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_PARAVIRTDEBUG_RETURN(this, hrc, 0 /*normal*/,TmpParavirtDebug.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_PARAVIRTDEBUG_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_PARAVIRTDEBUG_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setParavirtDebug", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(CPUProfile)(BSTR *aCPUProfile)
{
    LogRelFlow(("{%p} %s: enter aCPUProfile=%p\n", this, "Machine::getCPUProfile", aCPUProfile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCPUProfile);
        BSTROutConverter TmpCPUProfile(aCPUProfile);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUPROFILE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCPUProfile(TmpCPUProfile.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUPROFILE_RETURN(this, hrc, 0 /*normal*/,TmpCPUProfile.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUPROFILE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_CPUPROFILE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCPUProfile=%ls hrc=%Rhrc\n", this, "Machine::getCPUProfile", *aCPUProfile, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMSETTER(CPUProfile)(IN_BSTR aCPUProfile)
{
    LogRelFlow(("{%p} %s: enter aCPUProfile=%ls\n", this, "Machine::setCPUProfile", aCPUProfile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpCPUProfile(aCPUProfile);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUPROFILE_ENTER(this, TmpCPUProfile.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCPUProfile(TmpCPUProfile.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUPROFILE_RETURN(this, hrc, 0 /*normal*/,TmpCPUProfile.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUPROFILE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SET_CPUPROFILE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setCPUProfile", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(StateKeyId)(BSTR *aStateKeyId)
{
    LogRelFlow(("{%p} %s: enter aStateKeyId=%p\n", this, "Machine::getStateKeyId", aStateKeyId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStateKeyId);
        BSTROutConverter TmpStateKeyId(aStateKeyId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATEKEYID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStateKeyId(TmpStateKeyId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATEKEYID_RETURN(this, hrc, 0 /*normal*/,TmpStateKeyId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATEKEYID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATEKEYID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStateKeyId=%ls hrc=%Rhrc\n", this, "Machine::getStateKeyId", *aStateKeyId, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(StateKeyStore)(BSTR *aStateKeyStore)
{
    LogRelFlow(("{%p} %s: enter aStateKeyStore=%p\n", this, "Machine::getStateKeyStore", aStateKeyStore));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStateKeyStore);
        BSTROutConverter TmpStateKeyStore(aStateKeyStore);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATEKEYSTORE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStateKeyStore(TmpStateKeyStore.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATEKEYSTORE_RETURN(this, hrc, 0 /*normal*/,TmpStateKeyStore.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATEKEYSTORE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_STATEKEYSTORE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStateKeyStore=%ls hrc=%Rhrc\n", this, "Machine::getStateKeyStore", *aStateKeyStore, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(LogKeyId)(BSTR *aLogKeyId)
{
    LogRelFlow(("{%p} %s: enter aLogKeyId=%p\n", this, "Machine::getLogKeyId", aLogKeyId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogKeyId);
        BSTROutConverter TmpLogKeyId(aLogKeyId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LOGKEYID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogKeyId(TmpLogKeyId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LOGKEYID_RETURN(this, hrc, 0 /*normal*/,TmpLogKeyId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LOGKEYID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LOGKEYID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogKeyId=%ls hrc=%Rhrc\n", this, "Machine::getLogKeyId", *aLogKeyId, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(LogKeyStore)(BSTR *aLogKeyStore)
{
    LogRelFlow(("{%p} %s: enter aLogKeyStore=%p\n", this, "Machine::getLogKeyStore", aLogKeyStore));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogKeyStore);
        BSTROutConverter TmpLogKeyStore(aLogKeyStore);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LOGKEYSTORE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogKeyStore(TmpLogKeyStore.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LOGKEYSTORE_RETURN(this, hrc, 0 /*normal*/,TmpLogKeyStore.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LOGKEYSTORE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_LOGKEYSTORE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogKeyStore=%ls hrc=%Rhrc\n", this, "Machine::getLogKeyStore", *aLogKeyStore, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(GuestDebugControl)(IGuestDebugControl **aGuestDebugControl)
{
    LogRelFlow(("{%p} %s: enter aGuestDebugControl=%p\n", this, "Machine::getGuestDebugControl", aGuestDebugControl));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGuestDebugControl);
        ComTypeOutConverter<IGuestDebugControl> TmpGuestDebugControl(aGuestDebugControl);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_GUESTDEBUGCONTROL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuestDebugControl(TmpGuestDebugControl.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_GUESTDEBUGCONTROL_RETURN(this, hrc, 0 /*normal*/,(void *)TmpGuestDebugControl.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_GUESTDEBUGCONTROL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GET_GUESTDEBUGCONTROL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGuestDebugControl=%p hrc=%Rhrc\n", this, "Machine::getGuestDebugControl", *aGuestDebugControl, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute1IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute2IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute3IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute4IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute5IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute6IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute7IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute8IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute9IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute10IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute11IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute12IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute13IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute14IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute15IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::COMGETTER(InternalAndReservedAttribute16IMachine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IInternalMachineControl properties
//


//
// IMachine methods
//

STDMETHODIMP MachineWrap::LockMachine(ISession *aSession,
                                      LockType_T aLockType)
{
    LogRelFlow(("{%p} %s: enter aSession=%p aLockType=%RU32\n", this, "Machine::lockMachine", aSession, aLockType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<ISession> TmpSession(aSession);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_LOCKMACHINE_ENTER(this, (void *)TmpSession.ptr(), aLockType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = lockMachine(TmpSession.ptr(),
                              aLockType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_LOCKMACHINE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpSession.ptr(), aLockType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_LOCKMACHINE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aLockType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_LOCKMACHINE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aLockType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::lockMachine", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::LaunchVMProcess(ISession *aSession,
                                          IN_BSTR aName,
                                          ComSafeArrayIn(IN_BSTR, aEnvironmentChanges),
                                          IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSession=%p aName=%ls aEnvironmentChanges=%zu aProgress=%p\n", this, "Machine::launchVMProcess", aSession, aName, aEnvironmentChanges, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<ISession> TmpSession(aSession);
        BSTRInConverter TmpName(aName);
        ArrayBSTRInConverter TmpEnvironmentChanges(ComSafeArrayInArg(aEnvironmentChanges));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_LAUNCHVMPROCESS_ENTER(this, (void *)TmpSession.ptr(), TmpName.str().c_str(), (uint32_t)TmpEnvironmentChanges.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = launchVMProcess(TmpSession.ptr(),
                                  TmpName.str(),
                                  TmpEnvironmentChanges.array(),
                                  TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_LAUNCHVMPROCESS_RETURN(this, hrc, 0 /*normal*/, (void *)TmpSession.ptr(), TmpName.str().c_str(), (uint32_t)TmpEnvironmentChanges.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_LAUNCHVMPROCESS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_LAUNCHVMPROCESS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Machine::launchVMProcess", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::SetBootOrder(ULONG aPosition,
                                       DeviceType_T aDevice)
{
    LogRelFlow(("{%p} %s: enter aPosition=%RU32 aDevice=%RU32\n", this, "Machine::setBootOrder", aPosition, aDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETBOOTORDER_ENTER(this, aPosition, aDevice);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setBootOrder(aPosition,
                               aDevice);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETBOOTORDER_RETURN(this, hrc, 0 /*normal*/, aPosition, aDevice);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETBOOTORDER_RETURN(this, hrc, 1 /*hrc exception*/, aPosition, aDevice);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETBOOTORDER_RETURN(this, hrc, 9 /*unhandled exception*/, aPosition, aDevice);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setBootOrder", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetBootOrder(ULONG aPosition,
                                       DeviceType_T *aDevice)
{
    LogRelFlow(("{%p} %s: enter aPosition=%RU32 aDevice=%p\n", this, "Machine::getBootOrder", aPosition, aDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDevice);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETBOOTORDER_ENTER(this, aPosition);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBootOrder(aPosition,
                               aDevice);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETBOOTORDER_RETURN(this, hrc, 0 /*normal*/, aPosition, *aDevice);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETBOOTORDER_RETURN(this, hrc, 1 /*hrc exception*/, aPosition, *aDevice);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETBOOTORDER_RETURN(this, hrc, 9 /*unhandled exception*/, aPosition, *aDevice);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDevice=%RU32 hrc=%Rhrc\n", this, "Machine::getBootOrder", *aDevice, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::AttachDevice(IN_BSTR aName,
                                       LONG aControllerPort,
                                       LONG aDevice,
                                       DeviceType_T aType,
                                       IMedium *aMedium)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32 aType=%RU32 aMedium=%p\n", this, "Machine::attachDevice", aName, aControllerPort, aDevice, aType, aMedium));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        
        
        ComTypeInConverter<IMedium> TmpMedium(aMedium);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ATTACHDEVICE_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice, aType, (void *)TmpMedium.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = attachDevice(TmpName.str(),
                               aControllerPort,
                               aDevice,
                               aType,
                               TmpMedium.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ATTACHDEVICE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice, aType, (void *)TmpMedium.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ATTACHDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice, aType, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ATTACHDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice, aType, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::attachDevice", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::AttachDeviceWithoutMedium(IN_BSTR aName,
                                                    LONG aControllerPort,
                                                    LONG aDevice,
                                                    DeviceType_T aType)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32 aType=%RU32\n", this, "Machine::attachDeviceWithoutMedium", aName, aControllerPort, aDevice, aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ATTACHDEVICEWITHOUTMEDIUM_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice, aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = attachDeviceWithoutMedium(TmpName.str(),
                                            aControllerPort,
                                            aDevice,
                                            aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ATTACHDEVICEWITHOUTMEDIUM_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice, aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ATTACHDEVICEWITHOUTMEDIUM_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice, aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ATTACHDEVICEWITHOUTMEDIUM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice, aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::attachDeviceWithoutMedium", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::DetachDevice(IN_BSTR aName,
                                       LONG aControllerPort,
                                       LONG aDevice)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32\n", this, "Machine::detachDevice", aName, aControllerPort, aDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHDEVICE_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = detachDevice(TmpName.str(),
                               aControllerPort,
                               aDevice);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHDEVICE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::detachDevice", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::PassthroughDevice(IN_BSTR aName,
                                            LONG aControllerPort,
                                            LONG aDevice,
                                            BOOL aPassthrough)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32 aPassthrough=%RTbool\n", this, "Machine::passthroughDevice", aName, aControllerPort, aDevice, aPassthrough));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_PASSTHROUGHDEVICE_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice, aPassthrough != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = passthroughDevice(TmpName.str(),
                                    aControllerPort,
                                    aDevice,
                                    aPassthrough != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_PASSTHROUGHDEVICE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice, aPassthrough != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_PASSTHROUGHDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice, aPassthrough != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_PASSTHROUGHDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice, aPassthrough != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::passthroughDevice", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::TemporaryEjectDevice(IN_BSTR aName,
                                               LONG aControllerPort,
                                               LONG aDevice,
                                               BOOL aTemporaryEject)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32 aTemporaryEject=%RTbool\n", this, "Machine::temporaryEjectDevice", aName, aControllerPort, aDevice, aTemporaryEject));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_TEMPORARYEJECTDEVICE_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice, aTemporaryEject != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = temporaryEjectDevice(TmpName.str(),
                                       aControllerPort,
                                       aDevice,
                                       aTemporaryEject != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_TEMPORARYEJECTDEVICE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice, aTemporaryEject != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_TEMPORARYEJECTDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice, aTemporaryEject != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_TEMPORARYEJECTDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice, aTemporaryEject != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::temporaryEjectDevice", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::NonRotationalDevice(IN_BSTR aName,
                                              LONG aControllerPort,
                                              LONG aDevice,
                                              BOOL aNonRotational)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32 aNonRotational=%RTbool\n", this, "Machine::nonRotationalDevice", aName, aControllerPort, aDevice, aNonRotational));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_NONROTATIONALDEVICE_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice, aNonRotational != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = nonRotationalDevice(TmpName.str(),
                                      aControllerPort,
                                      aDevice,
                                      aNonRotational != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_NONROTATIONALDEVICE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice, aNonRotational != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_NONROTATIONALDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice, aNonRotational != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_NONROTATIONALDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice, aNonRotational != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::nonRotationalDevice", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::SetAutoDiscardForDevice(IN_BSTR aName,
                                                  LONG aControllerPort,
                                                  LONG aDevice,
                                                  BOOL aDiscard)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32 aDiscard=%RTbool\n", this, "Machine::setAutoDiscardForDevice", aName, aControllerPort, aDevice, aDiscard));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETAUTODISCARDFORDEVICE_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice, aDiscard != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAutoDiscardForDevice(TmpName.str(),
                                          aControllerPort,
                                          aDevice,
                                          aDiscard != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETAUTODISCARDFORDEVICE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice, aDiscard != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETAUTODISCARDFORDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice, aDiscard != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETAUTODISCARDFORDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice, aDiscard != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setAutoDiscardForDevice", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::SetHotPluggableForDevice(IN_BSTR aName,
                                                   LONG aControllerPort,
                                                   LONG aDevice,
                                                   BOOL aHotPluggable)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32 aHotPluggable=%RTbool\n", this, "Machine::setHotPluggableForDevice", aName, aControllerPort, aDevice, aHotPluggable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETHOTPLUGGABLEFORDEVICE_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice, aHotPluggable != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setHotPluggableForDevice(TmpName.str(),
                                           aControllerPort,
                                           aDevice,
                                           aHotPluggable != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETHOTPLUGGABLEFORDEVICE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice, aHotPluggable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETHOTPLUGGABLEFORDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice, aHotPluggable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETHOTPLUGGABLEFORDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice, aHotPluggable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setHotPluggableForDevice", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::SetBandwidthGroupForDevice(IN_BSTR aName,
                                                     LONG aControllerPort,
                                                     LONG aDevice,
                                                     IBandwidthGroup *aBandwidthGroup)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32 aBandwidthGroup=%p\n", this, "Machine::setBandwidthGroupForDevice", aName, aControllerPort, aDevice, aBandwidthGroup));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        
        ComTypeInConverter<IBandwidthGroup> TmpBandwidthGroup(aBandwidthGroup);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETBANDWIDTHGROUPFORDEVICE_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice, (void *)TmpBandwidthGroup.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setBandwidthGroupForDevice(TmpName.str(),
                                             aControllerPort,
                                             aDevice,
                                             TmpBandwidthGroup.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETBANDWIDTHGROUPFORDEVICE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice, (void *)TmpBandwidthGroup.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETBANDWIDTHGROUPFORDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETBANDWIDTHGROUPFORDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setBandwidthGroupForDevice", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::SetNoBandwidthGroupForDevice(IN_BSTR aName,
                                                       LONG aControllerPort,
                                                       LONG aDevice)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32\n", this, "Machine::setNoBandwidthGroupForDevice", aName, aControllerPort, aDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETNOBANDWIDTHGROUPFORDEVICE_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setNoBandwidthGroupForDevice(TmpName.str(),
                                               aControllerPort,
                                               aDevice);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETNOBANDWIDTHGROUPFORDEVICE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETNOBANDWIDTHGROUPFORDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETNOBANDWIDTHGROUPFORDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setNoBandwidthGroupForDevice", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::UnmountMedium(IN_BSTR aName,
                                        LONG aControllerPort,
                                        LONG aDevice,
                                        BOOL aForce)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32 aForce=%RTbool\n", this, "Machine::unmountMedium", aName, aControllerPort, aDevice, aForce));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UNMOUNTMEDIUM_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice, aForce != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = unmountMedium(TmpName.str(),
                                aControllerPort,
                                aDevice,
                                aForce != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UNMOUNTMEDIUM_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice, aForce != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UNMOUNTMEDIUM_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice, aForce != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UNMOUNTMEDIUM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice, aForce != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::unmountMedium", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::MountMedium(IN_BSTR aName,
                                      LONG aControllerPort,
                                      LONG aDevice,
                                      IMedium *aMedium,
                                      BOOL aForce)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32 aMedium=%p aForce=%RTbool\n", this, "Machine::mountMedium", aName, aControllerPort, aDevice, aMedium, aForce));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        
        ComTypeInConverter<IMedium> TmpMedium(aMedium);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_MOUNTMEDIUM_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice, (void *)TmpMedium.ptr(), aForce != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = mountMedium(TmpName.str(),
                              aControllerPort,
                              aDevice,
                              TmpMedium.ptr(),
                              aForce != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_MOUNTMEDIUM_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice, (void *)TmpMedium.ptr(), aForce != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_MOUNTMEDIUM_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice, 0, aForce != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_MOUNTMEDIUM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice, 0, aForce != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::mountMedium", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetMedium(IN_BSTR aName,
                                    LONG aControllerPort,
                                    LONG aDevice,
                                    IMedium **aMedium)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32 aMedium=%p\n", this, "Machine::getMedium", aName, aControllerPort, aDevice, aMedium));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMedium);


        BSTRInConverter TmpName(aName);
        
        
        ComTypeOutConverter<IMedium> TmpMedium(aMedium);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETMEDIUM_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMedium(TmpName.str(),
                            aControllerPort,
                            aDevice,
                            TmpMedium.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETMEDIUM_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice, (void *)TmpMedium.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETMEDIUM_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETMEDIUM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMedium=%p hrc=%Rhrc\n", this, "Machine::getMedium", *aMedium, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetMediumAttachmentsOfController(IN_BSTR aName,
                                                           ComSafeArrayOut(IMediumAttachment *, aMediumAttachments))
{
    LogRelFlow(("{%p} %s: enter aName=%ls aMediumAttachments=%p\n", this, "Machine::getMediumAttachmentsOfController", aName, aMediumAttachments));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMediumAttachments);


        BSTRInConverter TmpName(aName);
        ArrayComTypeOutConverter<IMediumAttachment> TmpMediumAttachments(ComSafeArrayOutArg(aMediumAttachments));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETMEDIUMATTACHMENTSOFCONTROLLER_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMediumAttachmentsOfController(TmpName.str(),
                                                   TmpMediumAttachments.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETMEDIUMATTACHMENTSOFCONTROLLER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (uint32_t)TmpMediumAttachments.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETMEDIUMATTACHMENTSOFCONTROLLER_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETMEDIUMATTACHMENTSOFCONTROLLER_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMediumAttachments=%zu hrc=%Rhrc\n", this, "Machine::getMediumAttachmentsOfController", ComSafeArraySize(*aMediumAttachments), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetMediumAttachment(IN_BSTR aName,
                                              LONG aControllerPort,
                                              LONG aDevice,
                                              IMediumAttachment **aAttachment)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aControllerPort=%RI32 aDevice=%RI32 aAttachment=%p\n", this, "Machine::getMediumAttachment", aName, aControllerPort, aDevice, aAttachment));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAttachment);


        BSTRInConverter TmpName(aName);
        
        
        ComTypeOutConverter<IMediumAttachment> TmpAttachment(aAttachment);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETMEDIUMATTACHMENT_ENTER(this, TmpName.str().c_str(), aControllerPort, aDevice);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMediumAttachment(TmpName.str(),
                                      aControllerPort,
                                      aDevice,
                                      TmpAttachment.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETMEDIUMATTACHMENT_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aControllerPort, aDevice, (void *)TmpAttachment.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETMEDIUMATTACHMENT_RETURN(this, hrc, 1 /*hrc exception*/, 0, aControllerPort, aDevice, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETMEDIUMATTACHMENT_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aControllerPort, aDevice, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aAttachment=%p hrc=%Rhrc\n", this, "Machine::getMediumAttachment", *aAttachment, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::AttachHostPCIDevice(LONG aHostAddress,
                                              LONG aDesiredGuestAddress,
                                              BOOL aTryToUnbind)
{
    LogRelFlow(("{%p} %s: enter aHostAddress=%RI32 aDesiredGuestAddress=%RI32 aTryToUnbind=%RTbool\n", this, "Machine::attachHostPCIDevice", aHostAddress, aDesiredGuestAddress, aTryToUnbind));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ATTACHHOSTPCIDEVICE_ENTER(this, aHostAddress, aDesiredGuestAddress, aTryToUnbind != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = attachHostPCIDevice(aHostAddress,
                                      aDesiredGuestAddress,
                                      aTryToUnbind != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ATTACHHOSTPCIDEVICE_RETURN(this, hrc, 0 /*normal*/, aHostAddress, aDesiredGuestAddress, aTryToUnbind != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ATTACHHOSTPCIDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, aHostAddress, aDesiredGuestAddress, aTryToUnbind != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ATTACHHOSTPCIDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, aHostAddress, aDesiredGuestAddress, aTryToUnbind != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::attachHostPCIDevice", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::DetachHostPCIDevice(LONG aHostAddress)
{
    LogRelFlow(("{%p} %s: enter aHostAddress=%RI32\n", this, "Machine::detachHostPCIDevice", aHostAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHHOSTPCIDEVICE_ENTER(this, aHostAddress);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = detachHostPCIDevice(aHostAddress);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHHOSTPCIDEVICE_RETURN(this, hrc, 0 /*normal*/, aHostAddress);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHHOSTPCIDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, aHostAddress);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHHOSTPCIDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, aHostAddress);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::detachHostPCIDevice", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetNetworkAdapter(ULONG aSlot,
                                            INetworkAdapter **aAdapter)
{
    LogRelFlow(("{%p} %s: enter aSlot=%RU32 aAdapter=%p\n", this, "Machine::getNetworkAdapter", aSlot, aAdapter));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAdapter);


        
        ComTypeOutConverter<INetworkAdapter> TmpAdapter(aAdapter);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETNETWORKADAPTER_ENTER(this, aSlot);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNetworkAdapter(aSlot,
                                    TmpAdapter.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETNETWORKADAPTER_RETURN(this, hrc, 0 /*normal*/, aSlot, (void *)TmpAdapter.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETNETWORKADAPTER_RETURN(this, hrc, 1 /*hrc exception*/, aSlot, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETNETWORKADAPTER_RETURN(this, hrc, 9 /*unhandled exception*/, aSlot, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aAdapter=%p hrc=%Rhrc\n", this, "Machine::getNetworkAdapter", *aAdapter, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::AddStorageController(IN_BSTR aName,
                                               StorageBus_T aConnectionType,
                                               IStorageController **aController)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aConnectionType=%RU32 aController=%p\n", this, "Machine::addStorageController", aName, aConnectionType, aController));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aController);


        BSTRInConverter TmpName(aName);
        
        ComTypeOutConverter<IStorageController> TmpController(aController);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDSTORAGECONTROLLER_ENTER(this, TmpName.str().c_str(), aConnectionType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addStorageController(TmpName.str(),
                                       aConnectionType,
                                       TmpController.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDSTORAGECONTROLLER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aConnectionType, (void *)TmpController.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDSTORAGECONTROLLER_RETURN(this, hrc, 1 /*hrc exception*/, 0, aConnectionType, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDSTORAGECONTROLLER_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aConnectionType, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aController=%p hrc=%Rhrc\n", this, "Machine::addStorageController", *aController, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetStorageControllerByName(IN_BSTR aName,
                                                     IStorageController **aStorageController)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aStorageController=%p\n", this, "Machine::getStorageControllerByName", aName, aStorageController));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStorageController);


        BSTRInConverter TmpName(aName);
        ComTypeOutConverter<IStorageController> TmpStorageController(aStorageController);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETSTORAGECONTROLLERBYNAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStorageControllerByName(TmpName.str(),
                                             TmpStorageController.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETSTORAGECONTROLLERBYNAME_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (void *)TmpStorageController.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETSTORAGECONTROLLERBYNAME_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETSTORAGECONTROLLERBYNAME_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aStorageController=%p hrc=%Rhrc\n", this, "Machine::getStorageControllerByName", *aStorageController, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetStorageControllerByInstance(StorageBus_T aConnectionType,
                                                         ULONG aInstance,
                                                         IStorageController **aStorageController)
{
    LogRelFlow(("{%p} %s: enter aConnectionType=%RU32 aInstance=%RU32 aStorageController=%p\n", this, "Machine::getStorageControllerByInstance", aConnectionType, aInstance, aStorageController));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStorageController);


        
        
        ComTypeOutConverter<IStorageController> TmpStorageController(aStorageController);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETSTORAGECONTROLLERBYINSTANCE_ENTER(this, aConnectionType, aInstance);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStorageControllerByInstance(aConnectionType,
                                                 aInstance,
                                                 TmpStorageController.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETSTORAGECONTROLLERBYINSTANCE_RETURN(this, hrc, 0 /*normal*/, aConnectionType, aInstance, (void *)TmpStorageController.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETSTORAGECONTROLLERBYINSTANCE_RETURN(this, hrc, 1 /*hrc exception*/, aConnectionType, aInstance, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETSTORAGECONTROLLERBYINSTANCE_RETURN(this, hrc, 9 /*unhandled exception*/, aConnectionType, aInstance, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aStorageController=%p hrc=%Rhrc\n", this, "Machine::getStorageControllerByInstance", *aStorageController, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::RemoveStorageController(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "Machine::removeStorageController", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVESTORAGECONTROLLER_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeStorageController(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVESTORAGECONTROLLER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVESTORAGECONTROLLER_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVESTORAGECONTROLLER_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::removeStorageController", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::SetStorageControllerBootable(IN_BSTR aName,
                                                       BOOL aBootable)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aBootable=%RTbool\n", this, "Machine::setStorageControllerBootable", aName, aBootable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETSTORAGECONTROLLERBOOTABLE_ENTER(this, TmpName.str().c_str(), aBootable != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setStorageControllerBootable(TmpName.str(),
                                               aBootable != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETSTORAGECONTROLLERBOOTABLE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aBootable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETSTORAGECONTROLLERBOOTABLE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aBootable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETSTORAGECONTROLLERBOOTABLE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aBootable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setStorageControllerBootable", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::AddUSBController(IN_BSTR aName,
                                           USBControllerType_T aType,
                                           IUSBController **aController)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aType=%RU32 aController=%p\n", this, "Machine::addUSBController", aName, aType, aController));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aController);


        BSTRInConverter TmpName(aName);
        
        ComTypeOutConverter<IUSBController> TmpController(aController);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDUSBCONTROLLER_ENTER(this, TmpName.str().c_str(), aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addUSBController(TmpName.str(),
                                   aType,
                                   TmpController.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDUSBCONTROLLER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aType, (void *)TmpController.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDUSBCONTROLLER_RETURN(this, hrc, 1 /*hrc exception*/, 0, aType, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDUSBCONTROLLER_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aType, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aController=%p hrc=%Rhrc\n", this, "Machine::addUSBController", *aController, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::RemoveUSBController(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "Machine::removeUSBController", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVEUSBCONTROLLER_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeUSBController(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVEUSBCONTROLLER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVEUSBCONTROLLER_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVEUSBCONTROLLER_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::removeUSBController", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetUSBControllerByName(IN_BSTR aName,
                                                 IUSBController **aController)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aController=%p\n", this, "Machine::getUSBControllerByName", aName, aController));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aController);


        BSTRInConverter TmpName(aName);
        ComTypeOutConverter<IUSBController> TmpController(aController);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETUSBCONTROLLERBYNAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUSBControllerByName(TmpName.str(),
                                         TmpController.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETUSBCONTROLLERBYNAME_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (void *)TmpController.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETUSBCONTROLLERBYNAME_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETUSBCONTROLLERBYNAME_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aController=%p hrc=%Rhrc\n", this, "Machine::getUSBControllerByName", *aController, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetUSBControllerCountByType(USBControllerType_T aType,
                                                      ULONG *aControllers)
{
    LogRelFlow(("{%p} %s: enter aType=%RU32 aControllers=%p\n", this, "Machine::getUSBControllerCountByType", aType, aControllers));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aControllers);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETUSBCONTROLLERCOUNTBYTYPE_ENTER(this, aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUSBControllerCountByType(aType,
                                              aControllers);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETUSBCONTROLLERCOUNTBYTYPE_RETURN(this, hrc, 0 /*normal*/, aType, *aControllers);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETUSBCONTROLLERCOUNTBYTYPE_RETURN(this, hrc, 1 /*hrc exception*/, aType, *aControllers);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETUSBCONTROLLERCOUNTBYTYPE_RETURN(this, hrc, 9 /*unhandled exception*/, aType, *aControllers);
#endif
    }

    LogRelFlow(("{%p} %s: leave aControllers=%RU32 hrc=%Rhrc\n", this, "Machine::getUSBControllerCountByType", *aControllers, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetSerialPort(ULONG aSlot,
                                        ISerialPort **aPort)
{
    LogRelFlow(("{%p} %s: enter aSlot=%RU32 aPort=%p\n", this, "Machine::getSerialPort", aSlot, aPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPort);


        
        ComTypeOutConverter<ISerialPort> TmpPort(aPort);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETSERIALPORT_ENTER(this, aSlot);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSerialPort(aSlot,
                                TmpPort.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETSERIALPORT_RETURN(this, hrc, 0 /*normal*/, aSlot, (void *)TmpPort.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETSERIALPORT_RETURN(this, hrc, 1 /*hrc exception*/, aSlot, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETSERIALPORT_RETURN(this, hrc, 9 /*unhandled exception*/, aSlot, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aPort=%p hrc=%Rhrc\n", this, "Machine::getSerialPort", *aPort, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetParallelPort(ULONG aSlot,
                                          IParallelPort **aPort)
{
    LogRelFlow(("{%p} %s: enter aSlot=%RU32 aPort=%p\n", this, "Machine::getParallelPort", aSlot, aPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPort);


        
        ComTypeOutConverter<IParallelPort> TmpPort(aPort);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETPARALLELPORT_ENTER(this, aSlot);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getParallelPort(aSlot,
                                  TmpPort.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETPARALLELPORT_RETURN(this, hrc, 0 /*normal*/, aSlot, (void *)TmpPort.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETPARALLELPORT_RETURN(this, hrc, 1 /*hrc exception*/, aSlot, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETPARALLELPORT_RETURN(this, hrc, 9 /*unhandled exception*/, aSlot, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aPort=%p hrc=%Rhrc\n", this, "Machine::getParallelPort", *aPort, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetExtraDataKeys(ComSafeArrayOut(BSTR, aKeys))
{
    LogRelFlow(("{%p} %s: enter aKeys=%p\n", this, "Machine::getExtraDataKeys", aKeys));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aKeys);


        ArrayBSTROutConverter TmpKeys(ComSafeArrayOutArg(aKeys));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETEXTRADATAKEYS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExtraDataKeys(TmpKeys.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETEXTRADATAKEYS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpKeys.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETEXTRADATAKEYS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETEXTRADATAKEYS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aKeys=%zu hrc=%Rhrc\n", this, "Machine::getExtraDataKeys", ComSafeArraySize(*aKeys), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetExtraData(IN_BSTR aKey,
                                       BSTR *aValue)
{
    LogRelFlow(("{%p} %s: enter aKey=%ls aValue=%p\n", this, "Machine::getExtraData", aKey, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        BSTRInConverter TmpKey(aKey);
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETEXTRADATA_ENTER(this, TmpKey.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExtraData(TmpKey.str(),
                               TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETEXTRADATA_RETURN(this, hrc, 0 /*normal*/, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETEXTRADATA_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETEXTRADATA_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%ls hrc=%Rhrc\n", this, "Machine::getExtraData", *aValue, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::SetExtraData(IN_BSTR aKey,
                                       IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s: enter aKey=%ls aValue=%ls\n", this, "Machine::setExtraData", aKey, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpKey(aKey);
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETEXTRADATA_ENTER(this, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setExtraData(TmpKey.str(),
                               TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETEXTRADATA_RETURN(this, hrc, 0 /*normal*/, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETEXTRADATA_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETEXTRADATA_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setExtraData", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::SetSettingsFilePath(IN_BSTR aSettingsFilePath,
                                              IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSettingsFilePath=%ls aProgress=%p\n", this, "Machine::setSettingsFilePath", aSettingsFilePath, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpSettingsFilePath(aSettingsFilePath);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETSETTINGSFILEPATH_ENTER(this, TmpSettingsFilePath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSettingsFilePath(TmpSettingsFilePath.str(),
                                      TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETSETTINGSFILEPATH_RETURN(this, hrc, 0 /*normal*/, TmpSettingsFilePath.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETSETTINGSFILEPATH_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETSETTINGSFILEPATH_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Machine::setSettingsFilePath", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::SaveSettings()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Machine::saveSettings"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SAVESETTINGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = saveSettings();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SAVESETTINGS_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SAVESETTINGS_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SAVESETTINGS_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::saveSettings", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::DiscardSettings()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Machine::discardSettings"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DISCARDSETTINGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = discardSettings();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DISCARDSETTINGS_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DISCARDSETTINGS_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DISCARDSETTINGS_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::discardSettings", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::Unregister(CleanupMode_T aCleanupMode,
                                     ComSafeArrayOut(IMedium *, aMedia))
{
    LogRelFlow(("{%p} %s: enter aCleanupMode=%RU32 aMedia=%p\n", this, "Machine::unregister", aCleanupMode, aMedia));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMedia);


        
        ArrayComTypeOutConverter<IMedium> TmpMedia(ComSafeArrayOutArg(aMedia));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UNREGISTER_ENTER(this, aCleanupMode);
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = unregister(autoCaller,
                         aCleanupMode,
                             TmpMedia.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UNREGISTER_RETURN(this, hrc, 0 /*normal*/, aCleanupMode, (uint32_t)TmpMedia.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UNREGISTER_RETURN(this, hrc, 1 /*hrc exception*/, aCleanupMode, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UNREGISTER_RETURN(this, hrc, 9 /*unhandled exception*/, aCleanupMode, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMedia=%zu hrc=%Rhrc\n", this, "Machine::unregister", ComSafeArraySize(*aMedia), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::DeleteConfig(ComSafeArrayIn(IMedium *, aMedia),
                                       IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aMedia=%zu aProgress=%p\n", this, "Machine::deleteConfig", aMedia, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ArrayComTypeInConverter<IMedium> TmpMedia(ComSafeArrayInArg(aMedia));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETECONFIG_ENTER(this, (uint32_t)TmpMedia.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = deleteConfig(TmpMedia.array(),
                               TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETECONFIG_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpMedia.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETECONFIG_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETECONFIG_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Machine::deleteConfig", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::ExportTo(IAppliance *aAppliance,
                                   IN_BSTR aLocation,
                                   IVirtualSystemDescription **aDescription)
{
    LogRelFlow(("{%p} %s: enter aAppliance=%p aLocation=%ls aDescription=%p\n", this, "Machine::exportTo", aAppliance, aLocation, aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);


        ComTypeInConverter<IAppliance> TmpAppliance(aAppliance);
        BSTRInConverter TmpLocation(aLocation);
        ComTypeOutConverter<IVirtualSystemDescription> TmpDescription(aDescription);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_EXPORTTO_ENTER(this, (void *)TmpAppliance.ptr(), TmpLocation.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = exportTo(TmpAppliance.ptr(),
                           TmpLocation.str(),
                           TmpDescription.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_EXPORTTO_RETURN(this, hrc, 0 /*normal*/, (void *)TmpAppliance.ptr(), TmpLocation.str().c_str(), (void *)TmpDescription.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_EXPORTTO_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_EXPORTTO_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDescription=%p hrc=%Rhrc\n", this, "Machine::exportTo", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::FindSnapshot(IN_BSTR aNameOrId,
                                       ISnapshot **aSnapshot)
{
    LogRelFlow(("{%p} %s: enter aNameOrId=%ls aSnapshot=%p\n", this, "Machine::findSnapshot", aNameOrId, aSnapshot));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSnapshot);


        BSTRInConverter TmpNameOrId(aNameOrId);
        ComTypeOutConverter<ISnapshot> TmpSnapshot(aSnapshot);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_FINDSNAPSHOT_ENTER(this, TmpNameOrId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findSnapshot(TmpNameOrId.str(),
                               TmpSnapshot.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_FINDSNAPSHOT_RETURN(this, hrc, 0 /*normal*/, TmpNameOrId.str().c_str(), (void *)TmpSnapshot.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_FINDSNAPSHOT_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_FINDSNAPSHOT_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSnapshot=%p hrc=%Rhrc\n", this, "Machine::findSnapshot", *aSnapshot, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::CreateSharedFolder(IN_BSTR aName,
                                             IN_BSTR aHostPath,
                                             BOOL aWritable,
                                             BOOL aAutomount,
                                             IN_BSTR aAutoMountPoint)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aHostPath=%ls aWritable=%RTbool aAutomount=%RTbool aAutoMountPoint=%ls\n", this, "Machine::createSharedFolder", aName, aHostPath, aWritable, aAutomount, aAutoMountPoint));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        BSTRInConverter TmpHostPath(aHostPath);
        
        
        BSTRInConverter TmpAutoMountPoint(aAutoMountPoint);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CREATESHAREDFOLDER_ENTER(this, TmpName.str().c_str(), TmpHostPath.str().c_str(), aWritable != FALSE, aAutomount != FALSE, TmpAutoMountPoint.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createSharedFolder(TmpName.str(),
                                     TmpHostPath.str(),
                                     aWritable != FALSE,
                                     aAutomount != FALSE,
                                     TmpAutoMountPoint.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CREATESHAREDFOLDER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpHostPath.str().c_str(), aWritable != FALSE, aAutomount != FALSE, TmpAutoMountPoint.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CREATESHAREDFOLDER_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aWritable != FALSE, aAutomount != FALSE, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CREATESHAREDFOLDER_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aWritable != FALSE, aAutomount != FALSE, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::createSharedFolder", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::RemoveSharedFolder(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "Machine::removeSharedFolder", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVESHAREDFOLDER_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeSharedFolder(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVESHAREDFOLDER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVESHAREDFOLDER_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVESHAREDFOLDER_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::removeSharedFolder", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::CanShowConsoleWindow(BOOL *aCanShow)
{
    LogRelFlow(("{%p} %s: enter aCanShow=%p\n", this, "Machine::canShowConsoleWindow", aCanShow));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCanShow);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CANSHOWCONSOLEWINDOW_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = canShowConsoleWindow(aCanShow);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CANSHOWCONSOLEWINDOW_RETURN(this, hrc, 0 /*normal*/, *aCanShow != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CANSHOWCONSOLEWINDOW_RETURN(this, hrc, 1 /*hrc exception*/, *aCanShow != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CANSHOWCONSOLEWINDOW_RETURN(this, hrc, 9 /*unhandled exception*/, *aCanShow != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aCanShow=%RTbool hrc=%Rhrc\n", this, "Machine::canShowConsoleWindow", *aCanShow, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::ShowConsoleWindow(LONG64 *aWinId)
{
    LogRelFlow(("{%p} %s: enter aWinId=%p\n", this, "Machine::showConsoleWindow", aWinId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWinId);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SHOWCONSOLEWINDOW_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = showConsoleWindow(aWinId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SHOWCONSOLEWINDOW_RETURN(this, hrc, 0 /*normal*/, *aWinId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SHOWCONSOLEWINDOW_RETURN(this, hrc, 1 /*hrc exception*/, *aWinId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SHOWCONSOLEWINDOW_RETURN(this, hrc, 9 /*unhandled exception*/, *aWinId);
#endif
    }

    LogRelFlow(("{%p} %s: leave aWinId=%RI64 hrc=%Rhrc\n", this, "Machine::showConsoleWindow", *aWinId, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetGuestProperty(IN_BSTR aName,
                                           BSTR *aValue,
                                           LONG64 *aTimestamp,
                                           BSTR *aFlags)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aValue=%p aTimestamp=%p aFlags=%p\n", this, "Machine::getGuestProperty", aName, aValue, aTimestamp, aFlags));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);
        CheckComArgOutPointerValidThrow(aTimestamp);
        CheckComArgOutPointerValidThrow(aFlags);


        BSTRInConverter TmpName(aName);
        BSTROutConverter TmpValue(aValue);
        
        BSTROutConverter TmpFlags(aFlags);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETGUESTPROPERTY_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuestProperty(TmpName.str(),
                                   TmpValue.str(),
                                   aTimestamp,
                                   TmpFlags.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETGUESTPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpValue.str().c_str(), *aTimestamp, TmpFlags.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETGUESTPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, *aTimestamp, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETGUESTPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, *aTimestamp, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aValue=%ls *aTimestamp=%RI64 *aFlags=%ls hrc=%Rhrc\n", this, "Machine::getGuestProperty", *aValue, *aTimestamp, *aFlags, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetGuestPropertyValue(IN_BSTR aProperty,
                                                BSTR *aValue)
{
    LogRelFlow(("{%p} %s: enter aProperty=%ls aValue=%p\n", this, "Machine::getGuestPropertyValue", aProperty, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        BSTRInConverter TmpProperty(aProperty);
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETGUESTPROPERTYVALUE_ENTER(this, TmpProperty.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuestPropertyValue(TmpProperty.str(),
                                        TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETGUESTPROPERTYVALUE_RETURN(this, hrc, 0 /*normal*/, TmpProperty.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETGUESTPROPERTYVALUE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETGUESTPROPERTYVALUE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%ls hrc=%Rhrc\n", this, "Machine::getGuestPropertyValue", *aValue, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetGuestPropertyTimestamp(IN_BSTR aProperty,
                                                    LONG64 *aValue)
{
    LogRelFlow(("{%p} %s: enter aProperty=%ls aValue=%p\n", this, "Machine::getGuestPropertyTimestamp", aProperty, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        BSTRInConverter TmpProperty(aProperty);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETGUESTPROPERTYTIMESTAMP_ENTER(this, TmpProperty.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuestPropertyTimestamp(TmpProperty.str(),
                                            aValue);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETGUESTPROPERTYTIMESTAMP_RETURN(this, hrc, 0 /*normal*/, TmpProperty.str().c_str(), *aValue);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETGUESTPROPERTYTIMESTAMP_RETURN(this, hrc, 1 /*hrc exception*/, 0, *aValue);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETGUESTPROPERTYTIMESTAMP_RETURN(this, hrc, 9 /*unhandled exception*/, 0, *aValue);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%RI64 hrc=%Rhrc\n", this, "Machine::getGuestPropertyTimestamp", *aValue, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::SetGuestProperty(IN_BSTR aProperty,
                                           IN_BSTR aValue,
                                           IN_BSTR aFlags)
{
    LogRelFlow(("{%p} %s: enter aProperty=%ls aValue=%ls aFlags=%ls\n", this, "Machine::setGuestProperty", aProperty, aValue, aFlags));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpProperty(aProperty);
        BSTRInConverter TmpValue(aValue);
        BSTRInConverter TmpFlags(aFlags);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETGUESTPROPERTY_ENTER(this, TmpProperty.str().c_str(), TmpValue.str().c_str(), TmpFlags.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setGuestProperty(TmpProperty.str(),
                                   TmpValue.str(),
                                   TmpFlags.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETGUESTPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpProperty.str().c_str(), TmpValue.str().c_str(), TmpFlags.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETGUESTPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETGUESTPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setGuestProperty", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::SetGuestPropertyValue(IN_BSTR aProperty,
                                                IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s: enter aProperty=%ls aValue=%ls\n", this, "Machine::setGuestPropertyValue", aProperty, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpProperty(aProperty);
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETGUESTPROPERTYVALUE_ENTER(this, TmpProperty.str().c_str(), TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setGuestPropertyValue(TmpProperty.str(),
                                        TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETGUESTPROPERTYVALUE_RETURN(this, hrc, 0 /*normal*/, TmpProperty.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETGUESTPROPERTYVALUE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SETGUESTPROPERTYVALUE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::setGuestPropertyValue", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::DeleteGuestProperty(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "Machine::deleteGuestProperty", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETEGUESTPROPERTY_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = deleteGuestProperty(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETEGUESTPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETEGUESTPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETEGUESTPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::deleteGuestProperty", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::EnumerateGuestProperties(IN_BSTR aPatterns,
                                                   ComSafeArrayOut(BSTR, aNames),
                                                   ComSafeArrayOut(BSTR, aValues),
                                                   ComSafeArrayOut(LONG64, aTimestamps),
                                                   ComSafeArrayOut(BSTR, aFlags))
{
    LogRelFlow(("{%p} %s: enter aPatterns=%ls aNames=%p aValues=%p aTimestamps=%p aFlags=%p\n", this, "Machine::enumerateGuestProperties", aPatterns, aNames, aValues, aTimestamps, aFlags));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNames);
        CheckComArgOutPointerValidThrow(aValues);
        CheckComArgOutPointerValidThrow(aTimestamps);
        CheckComArgOutPointerValidThrow(aFlags);


        BSTRInConverter TmpPatterns(aPatterns);
        ArrayBSTROutConverter TmpNames(ComSafeArrayOutArg(aNames));
        ArrayBSTROutConverter TmpValues(ComSafeArrayOutArg(aValues));
        ArrayOutConverter<LONG64> TmpTimestamps(ComSafeArrayOutArg(aTimestamps));
        ArrayBSTROutConverter TmpFlags(ComSafeArrayOutArg(aFlags));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ENUMERATEGUESTPROPERTIES_ENTER(this, TmpPatterns.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = enumerateGuestProperties(TmpPatterns.str(),
                                           TmpNames.array(),
                                           TmpValues.array(),
                                           TmpTimestamps.array(),
                                           TmpFlags.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ENUMERATEGUESTPROPERTIES_RETURN(this, hrc, 0 /*normal*/, TmpPatterns.str().c_str(), (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/, (uint32_t)TmpTimestamps.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ENUMERATEGUESTPROPERTIES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ENUMERATEGUESTPROPERTIES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNames=%zu *aValues=%zu *aTimestamps=%zu *aFlags=%zu hrc=%Rhrc\n", this, "Machine::enumerateGuestProperties", ComSafeArraySize(*aNames), ComSafeArraySize(*aValues), ComSafeArraySize(*aTimestamps), ComSafeArraySize(*aFlags), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::QuerySavedGuestScreenInfo(ULONG aScreenId,
                                                    ULONG *aOriginX,
                                                    ULONG *aOriginY,
                                                    ULONG *aWidth,
                                                    ULONG *aHeight,
                                                    BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aScreenId=%RU32 aOriginX=%p aOriginY=%p aWidth=%p aHeight=%p aEnabled=%p\n", this, "Machine::querySavedGuestScreenInfo", aScreenId, aOriginX, aOriginY, aWidth, aHeight, aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOriginX);
        CheckComArgOutPointerValidThrow(aOriginY);
        CheckComArgOutPointerValidThrow(aWidth);
        CheckComArgOutPointerValidThrow(aHeight);
        CheckComArgOutPointerValidThrow(aEnabled);


        
        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_QUERYSAVEDGUESTSCREENINFO_ENTER(this, aScreenId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = querySavedGuestScreenInfo(aScreenId,
                                            aOriginX,
                                            aOriginY,
                                            aWidth,
                                            aHeight,
                                            aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_QUERYSAVEDGUESTSCREENINFO_RETURN(this, hrc, 0 /*normal*/, aScreenId, *aOriginX, *aOriginY, *aWidth, *aHeight, *aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_QUERYSAVEDGUESTSCREENINFO_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, *aOriginX, *aOriginY, *aWidth, *aHeight, *aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_QUERYSAVEDGUESTSCREENINFO_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, *aOriginX, *aOriginY, *aWidth, *aHeight, *aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOriginX=%RU32 *aOriginY=%RU32 *aWidth=%RU32 *aHeight=%RU32 *aEnabled=%RTbool hrc=%Rhrc\n", this, "Machine::querySavedGuestScreenInfo", *aOriginX, *aOriginY, *aWidth, *aHeight, *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::ReadSavedThumbnailToArray(ULONG aScreenId,
                                                    BitmapFormat_T aBitmapFormat,
                                                    ULONG *aWidth,
                                                    ULONG *aHeight,
                                                    ComSafeArrayOut(BYTE, aData))
{
    LogRelFlow(("{%p} %s: enter aScreenId=%RU32 aBitmapFormat=%RU32 aWidth=%p aHeight=%p aData=%p\n", this, "Machine::readSavedThumbnailToArray", aScreenId, aBitmapFormat, aWidth, aHeight, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWidth);
        CheckComArgOutPointerValidThrow(aHeight);
        CheckComArgOutPointerValidThrow(aData);


        
        
        
        
        ArrayOutConverter<BYTE> TmpData(ComSafeArrayOutArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_READSAVEDTHUMBNAILTOARRAY_ENTER(this, aScreenId, aBitmapFormat);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = readSavedThumbnailToArray(aScreenId,
                                            aBitmapFormat,
                                            aWidth,
                                            aHeight,
                                            TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_READSAVEDTHUMBNAILTOARRAY_RETURN(this, hrc, 0 /*normal*/, aScreenId, aBitmapFormat, *aWidth, *aHeight, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_READSAVEDTHUMBNAILTOARRAY_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aBitmapFormat, *aWidth, *aHeight, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_READSAVEDTHUMBNAILTOARRAY_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aBitmapFormat, *aWidth, *aHeight, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWidth=%RU32 *aHeight=%RU32 aData=%zu hrc=%Rhrc\n", this, "Machine::readSavedThumbnailToArray", *aWidth, *aHeight, ComSafeArraySize(*aData), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::QuerySavedScreenshotInfo(ULONG aScreenId,
                                                   ULONG *aWidth,
                                                   ULONG *aHeight,
                                                   ComSafeArrayOut(BitmapFormat_T, aBitmapFormats))
{
    LogRelFlow(("{%p} %s: enter aScreenId=%RU32 aWidth=%p aHeight=%p aBitmapFormats=%p\n", this, "Machine::querySavedScreenshotInfo", aScreenId, aWidth, aHeight, aBitmapFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWidth);
        CheckComArgOutPointerValidThrow(aHeight);
        CheckComArgOutPointerValidThrow(aBitmapFormats);


        
        
        
        ArrayOutConverter<BitmapFormat_T> TmpBitmapFormats(ComSafeArrayOutArg(aBitmapFormats));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_QUERYSAVEDSCREENSHOTINFO_ENTER(this, aScreenId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = querySavedScreenshotInfo(aScreenId,
                                           aWidth,
                                           aHeight,
                                           TmpBitmapFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_QUERYSAVEDSCREENSHOTINFO_RETURN(this, hrc, 0 /*normal*/, aScreenId, *aWidth, *aHeight, (uint32_t)TmpBitmapFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_QUERYSAVEDSCREENSHOTINFO_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, *aWidth, *aHeight, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_QUERYSAVEDSCREENSHOTINFO_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, *aWidth, *aHeight, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWidth=%RU32 *aHeight=%RU32 aBitmapFormats=%zu hrc=%Rhrc\n", this, "Machine::querySavedScreenshotInfo", *aWidth, *aHeight, ComSafeArraySize(*aBitmapFormats), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::ReadSavedScreenshotToArray(ULONG aScreenId,
                                                     BitmapFormat_T aBitmapFormat,
                                                     ULONG *aWidth,
                                                     ULONG *aHeight,
                                                     ComSafeArrayOut(BYTE, aData))
{
    LogRelFlow(("{%p} %s: enter aScreenId=%RU32 aBitmapFormat=%RU32 aWidth=%p aHeight=%p aData=%p\n", this, "Machine::readSavedScreenshotToArray", aScreenId, aBitmapFormat, aWidth, aHeight, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWidth);
        CheckComArgOutPointerValidThrow(aHeight);
        CheckComArgOutPointerValidThrow(aData);


        
        
        
        
        ArrayOutConverter<BYTE> TmpData(ComSafeArrayOutArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_READSAVEDSCREENSHOTTOARRAY_ENTER(this, aScreenId, aBitmapFormat);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = readSavedScreenshotToArray(aScreenId,
                                             aBitmapFormat,
                                             aWidth,
                                             aHeight,
                                             TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_READSAVEDSCREENSHOTTOARRAY_RETURN(this, hrc, 0 /*normal*/, aScreenId, aBitmapFormat, *aWidth, *aHeight, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_READSAVEDSCREENSHOTTOARRAY_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aBitmapFormat, *aWidth, *aHeight, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_READSAVEDSCREENSHOTTOARRAY_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aBitmapFormat, *aWidth, *aHeight, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWidth=%RU32 *aHeight=%RU32 aData=%zu hrc=%Rhrc\n", this, "Machine::readSavedScreenshotToArray", *aWidth, *aHeight, ComSafeArraySize(*aData), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::HotPlugCPU(ULONG aCpu)
{
    LogRelFlow(("{%p} %s: enter aCpu=%RU32\n", this, "Machine::hotPlugCPU", aCpu));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_HOTPLUGCPU_ENTER(this, aCpu);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = hotPlugCPU(aCpu);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_HOTPLUGCPU_RETURN(this, hrc, 0 /*normal*/, aCpu);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_HOTPLUGCPU_RETURN(this, hrc, 1 /*hrc exception*/, aCpu);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_HOTPLUGCPU_RETURN(this, hrc, 9 /*unhandled exception*/, aCpu);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::hotPlugCPU", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::HotUnplugCPU(ULONG aCpu)
{
    LogRelFlow(("{%p} %s: enter aCpu=%RU32\n", this, "Machine::hotUnplugCPU", aCpu));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_HOTUNPLUGCPU_ENTER(this, aCpu);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = hotUnplugCPU(aCpu);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_HOTUNPLUGCPU_RETURN(this, hrc, 0 /*normal*/, aCpu);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_HOTUNPLUGCPU_RETURN(this, hrc, 1 /*hrc exception*/, aCpu);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_HOTUNPLUGCPU_RETURN(this, hrc, 9 /*unhandled exception*/, aCpu);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::hotUnplugCPU", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetCPUStatus(ULONG aCpu,
                                       BOOL *aAttached)
{
    LogRelFlow(("{%p} %s: enter aCpu=%RU32 aAttached=%p\n", this, "Machine::getCPUStatus", aCpu, aAttached));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAttached);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETCPUSTATUS_ENTER(this, aCpu);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCPUStatus(aCpu,
                               aAttached);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETCPUSTATUS_RETURN(this, hrc, 0 /*normal*/, aCpu, *aAttached != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETCPUSTATUS_RETURN(this, hrc, 1 /*hrc exception*/, aCpu, *aAttached != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETCPUSTATUS_RETURN(this, hrc, 9 /*unhandled exception*/, aCpu, *aAttached != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aAttached=%RTbool hrc=%Rhrc\n", this, "Machine::getCPUStatus", *aAttached, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetEffectiveParavirtProvider(ParavirtProvider_T *aParavirtProvider)
{
    LogRelFlow(("{%p} %s: enter aParavirtProvider=%p\n", this, "Machine::getEffectiveParavirtProvider", aParavirtProvider));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aParavirtProvider);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETEFFECTIVEPARAVIRTPROVIDER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEffectiveParavirtProvider(aParavirtProvider);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETEFFECTIVEPARAVIRTPROVIDER_RETURN(this, hrc, 0 /*normal*/, *aParavirtProvider);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETEFFECTIVEPARAVIRTPROVIDER_RETURN(this, hrc, 1 /*hrc exception*/, *aParavirtProvider);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETEFFECTIVEPARAVIRTPROVIDER_RETURN(this, hrc, 9 /*unhandled exception*/, *aParavirtProvider);
#endif
    }

    LogRelFlow(("{%p} %s: leave aParavirtProvider=%RU32 hrc=%Rhrc\n", this, "Machine::getEffectiveParavirtProvider", *aParavirtProvider, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::QueryLogFilename(ULONG aIdx,
                                           BSTR *aFilename)
{
    LogRelFlow(("{%p} %s: enter aIdx=%RU32 aFilename=%p\n", this, "Machine::queryLogFilename", aIdx, aFilename));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFilename);


        
        BSTROutConverter TmpFilename(aFilename);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_QUERYLOGFILENAME_ENTER(this, aIdx);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryLogFilename(aIdx,
                                   TmpFilename.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_QUERYLOGFILENAME_RETURN(this, hrc, 0 /*normal*/, aIdx, TmpFilename.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_QUERYLOGFILENAME_RETURN(this, hrc, 1 /*hrc exception*/, aIdx, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_QUERYLOGFILENAME_RETURN(this, hrc, 9 /*unhandled exception*/, aIdx, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aFilename=%ls hrc=%Rhrc\n", this, "Machine::queryLogFilename", *aFilename, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::ReadLog(ULONG aIdx,
                                  LONG64 aOffset,
                                  LONG64 aSize,
                                  ComSafeArrayOut(BYTE, aData))
{
    LogRelFlow(("{%p} %s: enter aIdx=%RU32 aOffset=%RI64 aSize=%RI64 aData=%p\n", this, "Machine::readLog", aIdx, aOffset, aSize, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aData);


        
        
        
        ArrayOutConverter<BYTE> TmpData(ComSafeArrayOutArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_READLOG_ENTER(this, aIdx, aOffset, aSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = readLog(aIdx,
                          aOffset,
                          aSize,
                          TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_READLOG_RETURN(this, hrc, 0 /*normal*/, aIdx, aOffset, aSize, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_READLOG_RETURN(this, hrc, 1 /*hrc exception*/, aIdx, aOffset, aSize, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_READLOG_RETURN(this, hrc, 9 /*unhandled exception*/, aIdx, aOffset, aSize, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aData=%zu hrc=%Rhrc\n", this, "Machine::readLog", ComSafeArraySize(*aData), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::CloneTo(IMachine *aTarget,
                                  CloneMode_T aMode,
                                  ComSafeArrayIn(CloneOptions_T, aOptions),
                                  IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aTarget=%p aMode=%RU32 aOptions=%zu aProgress=%p\n", this, "Machine::cloneTo", aTarget, aMode, aOptions, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<IMachine> TmpTarget(aTarget);
        
        ArrayInConverter<CloneOptions_T> TmpOptions(ComSafeArrayInArg(aOptions));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CLONETO_ENTER(this, (void *)TmpTarget.ptr(), aMode, (uint32_t)TmpOptions.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = cloneTo(TmpTarget.ptr(),
                          aMode,
                          TmpOptions.array(),
                          TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CLONETO_RETURN(this, hrc, 0 /*normal*/, (void *)TmpTarget.ptr(), aMode, (uint32_t)TmpOptions.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CLONETO_RETURN(this, hrc, 1 /*hrc exception*/, 0, aMode, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CLONETO_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aMode, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Machine::cloneTo", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::MoveTo(IN_BSTR aFolder,
                                 IN_BSTR aType,
                                 IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aFolder=%ls aType=%ls aProgress=%p\n", this, "Machine::moveTo", aFolder, aType, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpFolder(aFolder);
        BSTRInConverter TmpType(aType);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_MOVETO_ENTER(this, TmpFolder.str().c_str(), TmpType.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = moveTo(TmpFolder.str(),
                         TmpType.str(),
                         TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_MOVETO_RETURN(this, hrc, 0 /*normal*/, TmpFolder.str().c_str(), TmpType.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_MOVETO_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_MOVETO_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Machine::moveTo", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::SaveState(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aProgress=%p\n", this, "Machine::saveState", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SAVESTATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = saveState(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SAVESTATE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SAVESTATE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_SAVESTATE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Machine::saveState", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::AdoptSavedState(IN_BSTR aSavedStateFile)
{
    LogRelFlow(("{%p} %s: enter aSavedStateFile=%ls\n", this, "Machine::adoptSavedState", aSavedStateFile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpSavedStateFile(aSavedStateFile);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADOPTSAVEDSTATE_ENTER(this, TmpSavedStateFile.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = adoptSavedState(TmpSavedStateFile.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADOPTSAVEDSTATE_RETURN(this, hrc, 0 /*normal*/, TmpSavedStateFile.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADOPTSAVEDSTATE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADOPTSAVEDSTATE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::adoptSavedState", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::DiscardSavedState(BOOL aFRemoveFile)
{
    LogRelFlow(("{%p} %s: enter aFRemoveFile=%RTbool\n", this, "Machine::discardSavedState", aFRemoveFile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DISCARDSAVEDSTATE_ENTER(this, aFRemoveFile != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = discardSavedState(aFRemoveFile != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DISCARDSAVEDSTATE_RETURN(this, hrc, 0 /*normal*/, aFRemoveFile != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DISCARDSAVEDSTATE_RETURN(this, hrc, 1 /*hrc exception*/, aFRemoveFile != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DISCARDSAVEDSTATE_RETURN(this, hrc, 9 /*unhandled exception*/, aFRemoveFile != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::discardSavedState", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::TakeSnapshot(IN_BSTR aName,
                                       IN_BSTR aDescription,
                                       BOOL aPause,
                                       BSTR *aId,
                                       IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aDescription=%ls aPause=%RTbool aId=%p aProgress=%p\n", this, "Machine::takeSnapshot", aName, aDescription, aPause, aId, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpName(aName);
        BSTRInConverter TmpDescription(aDescription);
        
        UuidOutConverter TmpId(aId);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_TAKESNAPSHOT_ENTER(this, TmpName.str().c_str(), TmpDescription.str().c_str(), aPause != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = takeSnapshot(TmpName.str(),
                               TmpDescription.str(),
                               aPause != FALSE,
                               TmpId.uuid(),
                               TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_TAKESNAPSHOT_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpDescription.str().c_str(), aPause != FALSE, TmpId.uuid().toStringCurly().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_TAKESNAPSHOT_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aPause != FALSE, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_TAKESNAPSHOT_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aPause != FALSE, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%ls aProgress=%p hrc=%Rhrc\n", this, "Machine::takeSnapshot", *aId, *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::DeleteSnapshot(IN_BSTR aId,
                                         IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aProgress=%p\n", this, "Machine::deleteSnapshot", aId, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        UuidInConverter TmpId(aId);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETESNAPSHOT_ENTER(this, TmpId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = deleteSnapshot(TmpId.uuid(),
                                 TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETESNAPSHOT_RETURN(this, hrc, 0 /*normal*/, TmpId.uuid().toStringCurly().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETESNAPSHOT_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETESNAPSHOT_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Machine::deleteSnapshot", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::DeleteSnapshotAndAllChildren(IN_BSTR aId,
                                                       IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aProgress=%p\n", this, "Machine::deleteSnapshotAndAllChildren", aId, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        UuidInConverter TmpId(aId);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETESNAPSHOTANDALLCHILDREN_ENTER(this, TmpId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = deleteSnapshotAndAllChildren(TmpId.uuid(),
                                               TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETESNAPSHOTANDALLCHILDREN_RETURN(this, hrc, 0 /*normal*/, TmpId.uuid().toStringCurly().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETESNAPSHOTANDALLCHILDREN_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETESNAPSHOTANDALLCHILDREN_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Machine::deleteSnapshotAndAllChildren", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::DeleteSnapshotRange(IN_BSTR aStartId,
                                              IN_BSTR aEndId,
                                              IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aStartId=%ls aEndId=%ls aProgress=%p\n", this, "Machine::deleteSnapshotRange", aStartId, aEndId, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        UuidInConverter TmpStartId(aStartId);
        UuidInConverter TmpEndId(aEndId);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETESNAPSHOTRANGE_ENTER(this, TmpStartId.uuid().toStringCurly().c_str(), TmpEndId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = deleteSnapshotRange(TmpStartId.uuid(),
                                      TmpEndId.uuid(),
                                      TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETESNAPSHOTRANGE_RETURN(this, hrc, 0 /*normal*/, TmpStartId.uuid().toStringCurly().c_str(), TmpEndId.uuid().toStringCurly().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETESNAPSHOTRANGE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DELETESNAPSHOTRANGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Machine::deleteSnapshotRange", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::RestoreSnapshot(ISnapshot *aSnapshot,
                                          IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSnapshot=%p aProgress=%p\n", this, "Machine::restoreSnapshot", aSnapshot, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<ISnapshot> TmpSnapshot(aSnapshot);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_RESTORESNAPSHOT_ENTER(this, (void *)TmpSnapshot.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = restoreSnapshot(TmpSnapshot.ptr(),
                                  TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_RESTORESNAPSHOT_RETURN(this, hrc, 0 /*normal*/, (void *)TmpSnapshot.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_RESTORESNAPSHOT_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_RESTORESNAPSHOT_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Machine::restoreSnapshot", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::ApplyDefaults(IN_BSTR aFlags)
{
    LogRelFlow(("{%p} %s: enter aFlags=%ls\n", this, "Machine::applyDefaults", aFlags));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpFlags(aFlags);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_APPLYDEFAULTS_ENTER(this, TmpFlags.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = applyDefaults(TmpFlags.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_APPLYDEFAULTS_RETURN(this, hrc, 0 /*normal*/, TmpFlags.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_APPLYDEFAULTS_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_APPLYDEFAULTS_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::applyDefaults", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::ChangeEncryption(IN_BSTR aCurrentPassword,
                                           IN_BSTR aCipher,
                                           IN_BSTR aNewPassword,
                                           IN_BSTR aNewPasswordId,
                                           BOOL aForce,
                                           IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aCurrentPassword=%ls aCipher=%ls aNewPassword=%ls aNewPasswordId=%ls aForce=%RTbool aProgress=%p\n", this, "Machine::changeEncryption", aCurrentPassword, aCipher, aNewPassword, aNewPasswordId, aForce, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpCurrentPassword(aCurrentPassword);
        BSTRInConverter TmpCipher(aCipher);
        BSTRInConverter TmpNewPassword(aNewPassword);
        BSTRInConverter TmpNewPasswordId(aNewPasswordId);
        
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CHANGEENCRYPTION_ENTER(this, TmpCurrentPassword.str().c_str(), TmpCipher.str().c_str(), TmpNewPassword.str().c_str(), TmpNewPasswordId.str().c_str(), aForce != FALSE);
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = changeEncryption(TmpCurrentPassword.str(),
                                   TmpCipher.str(),
                                   TmpNewPassword.str(),
                                   TmpNewPasswordId.str(),
                                   aForce != FALSE,
                                   TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CHANGEENCRYPTION_RETURN(this, hrc, 0 /*normal*/, TmpCurrentPassword.str().c_str(), TmpCipher.str().c_str(), TmpNewPassword.str().c_str(), TmpNewPasswordId.str().c_str(), aForce != FALSE, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CHANGEENCRYPTION_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, aForce != FALSE, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CHANGEENCRYPTION_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, aForce != FALSE, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Machine::changeEncryption", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::GetEncryptionSettings(BSTR *aCipher,
                                                BSTR *aPasswordId)
{
    LogRelFlow(("{%p} %s: enter aCipher=%p aPasswordId=%p\n", this, "Machine::getEncryptionSettings", aCipher, aPasswordId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCipher);
        CheckComArgOutPointerValidThrow(aPasswordId);


        BSTROutConverter TmpCipher(aCipher);
        BSTROutConverter TmpPasswordId(aPasswordId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETENCRYPTIONSETTINGS_ENTER(this);
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEncryptionSettings(TmpCipher.str(),
                                        TmpPasswordId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETENCRYPTIONSETTINGS_RETURN(this, hrc, 0 /*normal*/, TmpCipher.str().c_str(), TmpPasswordId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETENCRYPTIONSETTINGS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_GETENCRYPTIONSETTINGS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCipher=%ls *aPasswordId=%ls hrc=%Rhrc\n", this, "Machine::getEncryptionSettings", *aCipher, *aPasswordId, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::CheckEncryptionPassword(IN_BSTR aPassword)
{
    LogRelFlow(("{%p} %s: enter aPassword=%ls\n", this, "Machine::checkEncryptionPassword", aPassword));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpPassword(aPassword);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CHECKENCRYPTIONPASSWORD_ENTER(this, TmpPassword.str().c_str());
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = checkEncryptionPassword(TmpPassword.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CHECKENCRYPTIONPASSWORD_RETURN(this, hrc, 0 /*normal*/, TmpPassword.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CHECKENCRYPTIONPASSWORD_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CHECKENCRYPTIONPASSWORD_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::checkEncryptionPassword", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::AddEncryptionPassword(IN_BSTR aId,
                                                IN_BSTR aPassword)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aPassword=%ls\n", this, "Machine::addEncryptionPassword", aId, aPassword));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpId(aId);
        BSTRInConverter TmpPassword(aPassword);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDENCRYPTIONPASSWORD_ENTER(this, TmpId.str().c_str(), TmpPassword.str().c_str());
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addEncryptionPassword(TmpId.str(),
                                        TmpPassword.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDENCRYPTIONPASSWORD_RETURN(this, hrc, 0 /*normal*/, TmpId.str().c_str(), TmpPassword.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDENCRYPTIONPASSWORD_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDENCRYPTIONPASSWORD_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::addEncryptionPassword", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::AddEncryptionPasswords(ComSafeArrayIn(IN_BSTR, aIds),
                                                 ComSafeArrayIn(IN_BSTR, aPasswords))
{
    LogRelFlow(("{%p} %s: enter aIds=%zu aPasswords=%zu\n", this, "Machine::addEncryptionPasswords", aIds, aPasswords));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayBSTRInConverter TmpIds(ComSafeArrayInArg(aIds));
        ArrayBSTRInConverter TmpPasswords(ComSafeArrayInArg(aPasswords));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDENCRYPTIONPASSWORDS_ENTER(this, (uint32_t)TmpIds.array().size(), NULL /*for now*/, (uint32_t)TmpPasswords.array().size(), NULL /*for now*/);
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addEncryptionPasswords(TmpIds.array(),
                                         TmpPasswords.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDENCRYPTIONPASSWORDS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpIds.array().size(), NULL /*for now*/, (uint32_t)TmpPasswords.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDENCRYPTIONPASSWORDS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ADDENCRYPTIONPASSWORDS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::addEncryptionPasswords", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::RemoveEncryptionPassword(IN_BSTR aId)
{
    LogRelFlow(("{%p} %s: enter aId=%ls\n", this, "Machine::removeEncryptionPassword", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpId(aId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVEENCRYPTIONPASSWORD_ENTER(this, TmpId.str().c_str());
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeEncryptionPassword(autoCaller,
                                       TmpId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVEENCRYPTIONPASSWORD_RETURN(this, hrc, 0 /*normal*/, TmpId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVEENCRYPTIONPASSWORD_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REMOVEENCRYPTIONPASSWORD_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::removeEncryptionPassword", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::ClearAllEncryptionPasswords()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Machine::clearAllEncryptionPasswords"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CLEARALLENCRYPTIONPASSWORDS_ENTER(this);
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = clearAllEncryptionPasswords(autoCaller);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CLEARALLENCRYPTIONPASSWORDS_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CLEARALLENCRYPTIONPASSWORDS_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CLEARALLENCRYPTIONPASSWORDS_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::clearAllEncryptionPasswords", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::InternalAndReservedMethod1IMachine()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::InternalAndReservedMethod2IMachine()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::InternalAndReservedMethod3IMachine()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::InternalAndReservedMethod4IMachine()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::InternalAndReservedMethod5IMachine()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::InternalAndReservedMethod6IMachine()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::InternalAndReservedMethod7IMachine()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineWrap::InternalAndReservedMethod8IMachine()
{
    return E_NOTIMPL;
}

//
// IInternalMachineControl methods
//

STDMETHODIMP MachineWrap::UpdateState(MachineState_T aState)
{
    LogRelFlow(("{%p} %s: enter aState=%RU32\n", this, "Machine::updateState", aState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UPDATESTATE_ENTER(this, aState);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = updateState(aState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UPDATESTATE_RETURN(this, hrc, 0 /*normal*/, aState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UPDATESTATE_RETURN(this, hrc, 1 /*hrc exception*/, aState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UPDATESTATE_RETURN(this, hrc, 9 /*unhandled exception*/, aState);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::updateState", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::BeginPowerUp(IProgress *aProgress)
{
    LogRelFlow(("{%p} %s: enter aProgress=%p\n", this, "Machine::beginPowerUp", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_BEGINPOWERUP_ENTER(this, (void *)TmpProgress.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = beginPowerUp(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_BEGINPOWERUP_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_BEGINPOWERUP_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_BEGINPOWERUP_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::beginPowerUp", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::EndPowerUp(LONG aResult)
{
    LogRelFlow(("{%p} %s: enter aResult=%RI32\n", this, "Machine::endPowerUp", aResult));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ENDPOWERUP_ENTER(this, aResult);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = endPowerUp(aResult);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ENDPOWERUP_RETURN(this, hrc, 0 /*normal*/, aResult);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ENDPOWERUP_RETURN(this, hrc, 1 /*hrc exception*/, aResult);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ENDPOWERUP_RETURN(this, hrc, 9 /*unhandled exception*/, aResult);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::endPowerUp", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::BeginPoweringDown(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aProgress=%p\n", this, "Machine::beginPoweringDown", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_BEGINPOWERINGDOWN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = beginPoweringDown(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_BEGINPOWERINGDOWN_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_BEGINPOWERINGDOWN_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_BEGINPOWERINGDOWN_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProgress=%p hrc=%Rhrc\n", this, "Machine::beginPoweringDown", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::EndPoweringDown(LONG aResult,
                                          IN_BSTR aErrMsg)
{
    LogRelFlow(("{%p} %s: enter aResult=%RI32 aErrMsg=%ls\n", this, "Machine::endPoweringDown", aResult, aErrMsg));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        BSTRInConverter TmpErrMsg(aErrMsg);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ENDPOWERINGDOWN_ENTER(this, aResult, TmpErrMsg.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = endPoweringDown(aResult,
                                  TmpErrMsg.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ENDPOWERINGDOWN_RETURN(this, hrc, 0 /*normal*/, aResult, TmpErrMsg.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ENDPOWERINGDOWN_RETURN(this, hrc, 1 /*hrc exception*/, aResult, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ENDPOWERINGDOWN_RETURN(this, hrc, 9 /*unhandled exception*/, aResult, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::endPoweringDown", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::RunUSBDeviceFilters(IUSBDevice *aDevice,
                                              BOOL *aMatched,
                                              ULONG *aMaskedInterfaces)
{
    LogRelFlow(("{%p} %s: enter aDevice=%p aMatched=%p aMaskedInterfaces=%p\n", this, "Machine::runUSBDeviceFilters", aDevice, aMatched, aMaskedInterfaces));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMatched);
        CheckComArgOutPointerValidThrow(aMaskedInterfaces);


        ComTypeInConverter<IUSBDevice> TmpDevice(aDevice);
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_RUNUSBDEVICEFILTERS_ENTER(this, (void *)TmpDevice.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = runUSBDeviceFilters(TmpDevice.ptr(),
                                      aMatched,
                                      aMaskedInterfaces);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_RUNUSBDEVICEFILTERS_RETURN(this, hrc, 0 /*normal*/, (void *)TmpDevice.ptr(), *aMatched != FALSE, *aMaskedInterfaces);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_RUNUSBDEVICEFILTERS_RETURN(this, hrc, 1 /*hrc exception*/, 0, *aMatched != FALSE, *aMaskedInterfaces);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_RUNUSBDEVICEFILTERS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, *aMatched != FALSE, *aMaskedInterfaces);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMatched=%RTbool *aMaskedInterfaces=%RU32 hrc=%Rhrc\n", this, "Machine::runUSBDeviceFilters", *aMatched, *aMaskedInterfaces, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::CaptureUSBDevice(IN_BSTR aId,
                                           IN_BSTR aCaptureFilename)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aCaptureFilename=%ls\n", this, "Machine::captureUSBDevice", aId, aCaptureFilename));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        UuidInConverter TmpId(aId);
        BSTRInConverter TmpCaptureFilename(aCaptureFilename);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CAPTUREUSBDEVICE_ENTER(this, TmpId.uuid().toStringCurly().c_str(), TmpCaptureFilename.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = captureUSBDevice(TmpId.uuid(),
                                   TmpCaptureFilename.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CAPTUREUSBDEVICE_RETURN(this, hrc, 0 /*normal*/, TmpId.uuid().toStringCurly().c_str(), TmpCaptureFilename.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CAPTUREUSBDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_CAPTUREUSBDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::captureUSBDevice", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::DetachUSBDevice(IN_BSTR aId,
                                          BOOL aDone)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aDone=%RTbool\n", this, "Machine::detachUSBDevice", aId, aDone));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        UuidInConverter TmpId(aId);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHUSBDEVICE_ENTER(this, TmpId.uuid().toStringCurly().c_str(), aDone != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = detachUSBDevice(TmpId.uuid(),
                                  aDone != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHUSBDEVICE_RETURN(this, hrc, 0 /*normal*/, TmpId.uuid().toStringCurly().c_str(), aDone != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHUSBDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aDone != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHUSBDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aDone != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::detachUSBDevice", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::AutoCaptureUSBDevices()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Machine::autoCaptureUSBDevices"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_AUTOCAPTUREUSBDEVICES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = autoCaptureUSBDevices();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_AUTOCAPTUREUSBDEVICES_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_AUTOCAPTUREUSBDEVICES_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_AUTOCAPTUREUSBDEVICES_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::autoCaptureUSBDevices", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::DetachAllUSBDevices(BOOL aDone)
{
    LogRelFlow(("{%p} %s: enter aDone=%RTbool\n", this, "Machine::detachAllUSBDevices", aDone));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHALLUSBDEVICES_ENTER(this, aDone != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = detachAllUSBDevices(aDone != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHALLUSBDEVICES_RETURN(this, hrc, 0 /*normal*/, aDone != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHALLUSBDEVICES_RETURN(this, hrc, 1 /*hrc exception*/, aDone != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_DETACHALLUSBDEVICES_RETURN(this, hrc, 9 /*unhandled exception*/, aDone != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::detachAllUSBDevices", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::OnSessionEnd(ISession *aSession,
                                       IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSession=%p aProgress=%p\n", this, "Machine::onSessionEnd", aSession, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<ISession> TmpSession(aSession);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ONSESSIONEND_ENTER(this, (void *)TmpSession.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onSessionEnd(TmpSession.ptr(),
                               TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ONSESSIONEND_RETURN(this, hrc, 0 /*normal*/, (void *)TmpSession.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ONSESSIONEND_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_ONSESSIONEND_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Machine::onSessionEnd", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::FinishOnlineMergeMedium()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Machine::finishOnlineMergeMedium"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_FINISHONLINEMERGEMEDIUM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = finishOnlineMergeMedium();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_FINISHONLINEMERGEMEDIUM_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_FINISHONLINEMERGEMEDIUM_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_FINISHONLINEMERGEMEDIUM_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::finishOnlineMergeMedium", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::PullGuestProperties(ComSafeArrayOut(BSTR, aNames),
                                              ComSafeArrayOut(BSTR, aValues),
                                              ComSafeArrayOut(LONG64, aTimestamps),
                                              ComSafeArrayOut(BSTR, aFlags))
{
    LogRelFlow(("{%p} %s: enter aNames=%p aValues=%p aTimestamps=%p aFlags=%p\n", this, "Machine::pullGuestProperties", aNames, aValues, aTimestamps, aFlags));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNames);
        CheckComArgOutPointerValidThrow(aValues);
        CheckComArgOutPointerValidThrow(aTimestamps);
        CheckComArgOutPointerValidThrow(aFlags);


        ArrayBSTROutConverter TmpNames(ComSafeArrayOutArg(aNames));
        ArrayBSTROutConverter TmpValues(ComSafeArrayOutArg(aValues));
        ArrayOutConverter<LONG64> TmpTimestamps(ComSafeArrayOutArg(aTimestamps));
        ArrayBSTROutConverter TmpFlags(ComSafeArrayOutArg(aFlags));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_PULLGUESTPROPERTIES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = pullGuestProperties(TmpNames.array(),
                                      TmpValues.array(),
                                      TmpTimestamps.array(),
                                      TmpFlags.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_PULLGUESTPROPERTIES_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/, (uint32_t)TmpTimestamps.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_PULLGUESTPROPERTIES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_PULLGUESTPROPERTIES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNames=%zu *aValues=%zu *aTimestamps=%zu *aFlags=%zu hrc=%Rhrc\n", this, "Machine::pullGuestProperties", ComSafeArraySize(*aNames), ComSafeArraySize(*aValues), ComSafeArraySize(*aTimestamps), ComSafeArraySize(*aFlags), hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::PushGuestProperty(IN_BSTR aName,
                                            IN_BSTR aValue,
                                            LONG64 aTimestamp,
                                            IN_BSTR aFlags,
                                            BOOL aFWasDeleted)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aValue=%ls aTimestamp=%RI64 aFlags=%ls aFWasDeleted=%RTbool\n", this, "Machine::pushGuestProperty", aName, aValue, aTimestamp, aFlags, aFWasDeleted));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        BSTRInConverter TmpValue(aValue);
        
        BSTRInConverter TmpFlags(aFlags);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_PUSHGUESTPROPERTY_ENTER(this, TmpName.str().c_str(), TmpValue.str().c_str(), aTimestamp, TmpFlags.str().c_str(), aFWasDeleted != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = pushGuestProperty(TmpName.str(),
                                    TmpValue.str(),
                                    aTimestamp,
                                    TmpFlags.str(),
                                    aFWasDeleted != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_PUSHGUESTPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpValue.str().c_str(), aTimestamp, TmpFlags.str().c_str(), aFWasDeleted != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_PUSHGUESTPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aTimestamp, 0, aFWasDeleted != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_PUSHGUESTPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aTimestamp, 0, aFWasDeleted != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::pushGuestProperty", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::LockMedia()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Machine::lockMedia"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_LOCKMEDIA_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = lockMedia();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_LOCKMEDIA_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_LOCKMEDIA_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_LOCKMEDIA_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::lockMedia", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::UnlockMedia()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Machine::unlockMedia"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UNLOCKMEDIA_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = unlockMedia();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UNLOCKMEDIA_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UNLOCKMEDIA_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_UNLOCKMEDIA_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::unlockMedia", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::EjectMedium(IMediumAttachment *aAttachment,
                                      IMediumAttachment **aNewAttachment)
{
    LogRelFlow(("{%p} %s: enter aAttachment=%p aNewAttachment=%p\n", this, "Machine::ejectMedium", aAttachment, aNewAttachment));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNewAttachment);


        ComTypeInConverter<IMediumAttachment> TmpAttachment(aAttachment);
        ComTypeOutConverter<IMediumAttachment> TmpNewAttachment(aNewAttachment);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_EJECTMEDIUM_ENTER(this, (void *)TmpAttachment.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = ejectMedium(TmpAttachment.ptr(),
                              TmpNewAttachment.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_EJECTMEDIUM_RETURN(this, hrc, 0 /*normal*/, (void *)TmpAttachment.ptr(), (void *)TmpNewAttachment.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_EJECTMEDIUM_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_EJECTMEDIUM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aNewAttachment=%p hrc=%Rhrc\n", this, "Machine::ejectMedium", *aNewAttachment, hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::ReportVmStatistics(ULONG aValidStats,
                                             ULONG aCpuUser,
                                             ULONG aCpuKernel,
                                             ULONG aCpuIdle,
                                             ULONG aMemTotal,
                                             ULONG aMemFree,
                                             ULONG aMemBalloon,
                                             ULONG aMemShared,
                                             ULONG aMemCache,
                                             ULONG aPagedTotal,
                                             ULONG aMemAllocTotal,
                                             ULONG aMemFreeTotal,
                                             ULONG aMemBalloonTotal,
                                             ULONG aMemSharedTotal,
                                             ULONG aVmNetRx,
                                             ULONG aVmNetTx)
{
    LogRelFlow(("{%p} %s: enter aValidStats=%RU32 aCpuUser=%RU32 aCpuKernel=%RU32 aCpuIdle=%RU32 aMemTotal=%RU32 aMemFree=%RU32 aMemBalloon=%RU32 aMemShared=%RU32 aMemCache=%RU32 aPagedTotal=%RU32 aMemAllocTotal=%RU32 aMemFreeTotal=%RU32 aMemBalloonTotal=%RU32 aMemSharedTotal=%RU32 aVmNetRx=%RU32 aVmNetTx=%RU32\n", this, "Machine::reportVmStatistics", aValidStats, aCpuUser, aCpuKernel, aCpuIdle, aMemTotal, aMemFree, aMemBalloon, aMemShared, aMemCache, aPagedTotal, aMemAllocTotal, aMemFreeTotal, aMemBalloonTotal, aMemSharedTotal, aVmNetRx, aVmNetTx));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REPORTVMSTATISTICS_ENTER(this, aValidStats, aCpuUser, aCpuKernel, aCpuIdle, aMemTotal, aMemFree, aMemBalloon, aMemShared, aMemCache, aPagedTotal, aMemAllocTotal, aMemFreeTotal, aMemBalloonTotal, aMemSharedTotal, aVmNetRx, aVmNetTx);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = reportVmStatistics(aValidStats,
                                     aCpuUser,
                                     aCpuKernel,
                                     aCpuIdle,
                                     aMemTotal,
                                     aMemFree,
                                     aMemBalloon,
                                     aMemShared,
                                     aMemCache,
                                     aPagedTotal,
                                     aMemAllocTotal,
                                     aMemFreeTotal,
                                     aMemBalloonTotal,
                                     aMemSharedTotal,
                                     aVmNetRx,
                                     aVmNetTx);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REPORTVMSTATISTICS_RETURN(this, hrc, 0 /*normal*/, aValidStats, aCpuUser, aCpuKernel, aCpuIdle, aMemTotal, aMemFree, aMemBalloon, aMemShared, aMemCache, aPagedTotal, aMemAllocTotal, aMemFreeTotal, aMemBalloonTotal, aMemSharedTotal, aVmNetRx, aVmNetTx);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REPORTVMSTATISTICS_RETURN(this, hrc, 1 /*hrc exception*/, aValidStats, aCpuUser, aCpuKernel, aCpuIdle, aMemTotal, aMemFree, aMemBalloon, aMemShared, aMemCache, aPagedTotal, aMemAllocTotal, aMemFreeTotal, aMemBalloonTotal, aMemSharedTotal, aVmNetRx, aVmNetTx);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_REPORTVMSTATISTICS_RETURN(this, hrc, 9 /*unhandled exception*/, aValidStats, aCpuUser, aCpuKernel, aCpuIdle, aMemTotal, aMemFree, aMemBalloon, aMemShared, aMemCache, aPagedTotal, aMemAllocTotal, aMemFreeTotal, aMemBalloonTotal, aMemSharedTotal, aVmNetRx, aVmNetTx);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Machine::reportVmStatistics", hrc));
    return hrc;
}

STDMETHODIMP MachineWrap::AuthenticateExternal(ComSafeArrayIn(IN_BSTR, aAuthParams),
                                               BSTR *aResult)
{
    LogRelFlow(("{%p} %s: enter aAuthParams=%zu aResult=%p\n", this, "Machine::authenticateExternal", aAuthParams, aResult));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResult);


        ArrayBSTRInConverter TmpAuthParams(ComSafeArrayInArg(aAuthParams));
        BSTROutConverter TmpResult(aResult);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_AUTHENTICATEEXTERNAL_ENTER(this, (uint32_t)TmpAuthParams.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = authenticateExternal(TmpAuthParams.array(),
                                       TmpResult.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_AUTHENTICATEEXTERNAL_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpAuthParams.array().size(), NULL /*for now*/, TmpResult.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_AUTHENTICATEEXTERNAL_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINE_AUTHENTICATEEXTERNAL_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aResult=%ls hrc=%Rhrc\n", this, "Machine::authenticateExternal", *aResult, hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MachineWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(MachineWrap, IMachine)
#endif // VBOX_WITH_XPCOM
