/** @file
 * VirtualBox API class wrapper code for IAudioSettings.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_AUDIOSETTINGS

#include "AudioSettingsWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(AudioSettingsWrap)

//
// IAudioSettings properties
//

STDMETHODIMP AudioSettingsWrap::COMGETTER(Adapter)(IAudioAdapter **aAdapter)
{
    LogRelFlow(("{%p} %s: enter aAdapter=%p\n", this, "AudioSettings::getAdapter", aAdapter));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAdapter);
        ComTypeOutConverter<IAudioAdapter> TmpAdapter(aAdapter);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOSETTINGS_GET_ADAPTER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAdapter(TmpAdapter.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOSETTINGS_GET_ADAPTER_RETURN(this, hrc, 0 /*normal*/,(void *)TmpAdapter.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOSETTINGS_GET_ADAPTER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOSETTINGS_GET_ADAPTER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAdapter=%p hrc=%Rhrc\n", this, "AudioSettings::getAdapter", *aAdapter, hrc));
    return hrc;
}

STDMETHODIMP AudioSettingsWrap::COMGETTER(InternalAndReservedAttribute1IAudioSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioSettingsWrap::COMGETTER(InternalAndReservedAttribute2IAudioSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioSettingsWrap::COMGETTER(InternalAndReservedAttribute3IAudioSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioSettingsWrap::COMGETTER(InternalAndReservedAttribute4IAudioSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioSettingsWrap::COMGETTER(InternalAndReservedAttribute5IAudioSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioSettingsWrap::COMGETTER(InternalAndReservedAttribute6IAudioSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioSettingsWrap::COMGETTER(InternalAndReservedAttribute7IAudioSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioSettingsWrap::COMGETTER(InternalAndReservedAttribute8IAudioSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IAudioSettings methods
//

STDMETHODIMP AudioSettingsWrap::GetHostAudioDevice(AudioDirection_T aUsage,
                                                   IHostAudioDevice **aDevice)
{
    LogRelFlow(("{%p} %s: enter aUsage=%RU32 aDevice=%p\n", this, "AudioSettings::getHostAudioDevice", aUsage, aDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDevice);


        
        ComTypeOutConverter<IHostAudioDevice> TmpDevice(aDevice);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOSETTINGS_GETHOSTAUDIODEVICE_ENTER(this, aUsage);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHostAudioDevice(aUsage,
                                     TmpDevice.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOSETTINGS_GETHOSTAUDIODEVICE_RETURN(this, hrc, 0 /*normal*/, aUsage, (void *)TmpDevice.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOSETTINGS_GETHOSTAUDIODEVICE_RETURN(this, hrc, 1 /*hrc exception*/, aUsage, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOSETTINGS_GETHOSTAUDIODEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, aUsage, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDevice=%p hrc=%Rhrc\n", this, "AudioSettings::getHostAudioDevice", *aDevice, hrc));
    return hrc;
}

STDMETHODIMP AudioSettingsWrap::SetHostAudioDevice(IHostAudioDevice *aDevice,
                                                   AudioDirection_T aUsage)
{
    LogRelFlow(("{%p} %s: enter aDevice=%p aUsage=%RU32\n", this, "AudioSettings::setHostAudioDevice", aDevice, aUsage));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IHostAudioDevice> TmpDevice(aDevice);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOSETTINGS_SETHOSTAUDIODEVICE_ENTER(this, (void *)TmpDevice.ptr(), aUsage);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setHostAudioDevice(TmpDevice.ptr(),
                                     aUsage);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOSETTINGS_SETHOSTAUDIODEVICE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpDevice.ptr(), aUsage);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOSETTINGS_SETHOSTAUDIODEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aUsage);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOSETTINGS_SETHOSTAUDIODEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aUsage);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "AudioSettings::setHostAudioDevice", hrc));
    return hrc;
}

STDMETHODIMP AudioSettingsWrap::InternalAndReservedMethod1IAudioSettings()
{
    return E_NOTIMPL;
}

STDMETHODIMP AudioSettingsWrap::InternalAndReservedMethod2IAudioSettings()
{
    return E_NOTIMPL;
}

STDMETHODIMP AudioSettingsWrap::InternalAndReservedMethod3IAudioSettings()
{
    return E_NOTIMPL;
}

STDMETHODIMP AudioSettingsWrap::InternalAndReservedMethod4IAudioSettings()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(AudioSettingsWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(AudioSettingsWrap, IAudioSettings)
#endif // VBOX_WITH_XPCOM
