// python wrapper for ttkCinemaDarkroomSSDoF
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkCinemaDarkroomSSDoF.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkCinemaDarkroomSSDoF(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkCinemaDarkroomSSDoF_ClassNew(); }

#ifndef DECLARED_PyttkCinemaDarkroomShader_ClassNew
extern "C" { PyObject *PyttkCinemaDarkroomShader_ClassNew(); }
#define DECLARED_PyttkCinemaDarkroomShader_ClassNew
#endif

static PyObject *
PyttkCinemaDarkroomSSDoF_SetRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomSSDoF *op = static_cast<ttkCinemaDarkroomSSDoF *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRadius(temp0);
    }
    else
    {
      op->ttkCinemaDarkroomSSDoF::SetRadius(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomSSDoF_GetRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomSSDoF *op = static_cast<ttkCinemaDarkroomSSDoF *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetRadius() :
      op->ttkCinemaDarkroomSSDoF::GetRadius());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomSSDoF_SetMaxBlur(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxBlur");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomSSDoF *op = static_cast<ttkCinemaDarkroomSSDoF *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaxBlur(temp0);
    }
    else
    {
      op->ttkCinemaDarkroomSSDoF::SetMaxBlur(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomSSDoF_GetMaxBlur(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxBlur");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomSSDoF *op = static_cast<ttkCinemaDarkroomSSDoF *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaxBlur() :
      op->ttkCinemaDarkroomSSDoF::GetMaxBlur());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomSSDoF_SetAperture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAperture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomSSDoF *op = static_cast<ttkCinemaDarkroomSSDoF *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAperture(temp0);
    }
    else
    {
      op->ttkCinemaDarkroomSSDoF::SetAperture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomSSDoF_GetAperture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAperture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomSSDoF *op = static_cast<ttkCinemaDarkroomSSDoF *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetAperture() :
      op->ttkCinemaDarkroomSSDoF::GetAperture());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomSSDoF_SetFocalDepth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFocalDepth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomSSDoF *op = static_cast<ttkCinemaDarkroomSSDoF *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFocalDepth(temp0);
    }
    else
    {
      op->ttkCinemaDarkroomSSDoF::SetFocalDepth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomSSDoF_GetFocalDepth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFocalDepth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomSSDoF *op = static_cast<ttkCinemaDarkroomSSDoF *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetFocalDepth() :
      op->ttkCinemaDarkroomSSDoF::GetFocalDepth());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomSSDoF_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkCinemaDarkroomSSDoF::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomSSDoF_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomSSDoF *op = static_cast<ttkCinemaDarkroomSSDoF *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkCinemaDarkroomSSDoF::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomSSDoF_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkCinemaDarkroomSSDoF *tempr = ttkCinemaDarkroomSSDoF::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomSSDoF_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomSSDoF *op = static_cast<ttkCinemaDarkroomSSDoF *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkCinemaDarkroomSSDoF *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkCinemaDarkroomSSDoF::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomSSDoF_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkCinemaDarkroomSSDoF::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomSSDoF_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomSSDoF *op = static_cast<ttkCinemaDarkroomSSDoF *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkCinemaDarkroomSSDoF::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkCinemaDarkroomSSDoF_Methods[] = {
  {"SetRadius", PyttkCinemaDarkroomSSDoF_SetRadius, METH_VARARGS,
   "SetRadius(self, _arg:float) -> None\nC++: virtual void SetRadius(double _arg)\n\n"},
  {"GetRadius", PyttkCinemaDarkroomSSDoF_GetRadius, METH_VARARGS,
   "GetRadius(self) -> float\nC++: virtual double GetRadius()\n\n"},
  {"SetMaxBlur", PyttkCinemaDarkroomSSDoF_SetMaxBlur, METH_VARARGS,
   "SetMaxBlur(self, _arg:float) -> None\nC++: virtual void SetMaxBlur(double _arg)\n\n"},
  {"GetMaxBlur", PyttkCinemaDarkroomSSDoF_GetMaxBlur, METH_VARARGS,
   "GetMaxBlur(self) -> float\nC++: virtual double GetMaxBlur()\n\n"},
  {"SetAperture", PyttkCinemaDarkroomSSDoF_SetAperture, METH_VARARGS,
   "SetAperture(self, _arg:float) -> None\nC++: virtual void SetAperture(double _arg)\n\n"},
  {"GetAperture", PyttkCinemaDarkroomSSDoF_GetAperture, METH_VARARGS,
   "GetAperture(self) -> float\nC++: virtual double GetAperture()\n\n"},
  {"SetFocalDepth", PyttkCinemaDarkroomSSDoF_SetFocalDepth, METH_VARARGS,
   "SetFocalDepth(self, _arg:float) -> None\nC++: virtual void SetFocalDepth(double _arg)\n\n"},
  {"GetFocalDepth", PyttkCinemaDarkroomSSDoF_GetFocalDepth, METH_VARARGS,
   "GetFocalDepth(self) -> float\nC++: virtual double GetFocalDepth()\n\n"},
  {"IsTypeOf", PyttkCinemaDarkroomSSDoF_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkCinemaDarkroomSSDoF_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkCinemaDarkroomSSDoF_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkCinemaDarkroomSSDoF\nC++: static ttkCinemaDarkroomSSDoF *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkCinemaDarkroomSSDoF_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkCinemaDarkroomSSDoF\nC++: ttkCinemaDarkroomSSDoF *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkCinemaDarkroomSSDoF_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkCinemaDarkroomSSDoF_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkCinemaDarkroomSSDoF_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("radius"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaDarkroomSSDoF_GetRadius(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaDarkroomSSDoF_SetRadius(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaDarkroomSSDoF_SetRadius(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRadius/SetRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("max_blur"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaDarkroomSSDoF_GetMaxBlur(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaDarkroomSSDoF_SetMaxBlur(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaDarkroomSSDoF_SetMaxBlur(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaxBlur/SetMaxBlur\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("aperture"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaDarkroomSSDoF_GetAperture(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaDarkroomSSDoF_SetAperture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaDarkroomSSDoF_SetAperture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAperture/SetAperture\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("focal_depth"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaDarkroomSSDoF_GetFocalDepth(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaDarkroomSSDoF_SetFocalDepth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaDarkroomSSDoF_SetFocalDepth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFocalDepth/SetFocalDepth\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkCinemaDarkroomSSDoF_Doc =
  "ttkCinemaDarkroomSSDoF - \\ingroup vtk\n\n"
  "Superclass: ttkCinemaDarkroomShader\n\n"
  "\\author Jonas Lukasczyk <jl@jluk.de>\\date 01.11.2020\n\n"
  "Screen Space Depth of Field\n\n"
  "\\param Input vtkImageData.\n"
  "\\param Output vtkImageData.\n\n"
  "Related Publication: \"Efficiently Simulating the Bokeh of Polygonal\n"
  "Apertures in a Post-Process Depth of Field Shader\". L. McIntosh, B.\n"
  "E. Riecke and S. DiPaola. Computer Graphics Forum. 2012.\n\n"
  "\\sa ttkCinemaDarkroomShader\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkCinemaDarkroomSSDoF_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkCinemaDarkroom.ttkCinemaDarkroomSSDoF", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkCinemaDarkroomSSDoF_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkCinemaDarkroomSSDoF_StaticNew()
{
  return ttkCinemaDarkroomSSDoF::New();
}

PyObject *PyttkCinemaDarkroomSSDoF_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkCinemaDarkroomSSDoF_Type, PyttkCinemaDarkroomSSDoF_Methods,
    "ttkCinemaDarkroomSSDoF",
 &PyttkCinemaDarkroomSSDoF_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyttkCinemaDarkroomShader_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkCinemaDarkroomSSDoF_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkCinemaDarkroomSSDoF(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkCinemaDarkroomSSDoF_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkCinemaDarkroomSSDoF", o) != 0)
  {
    Py_DECREF(o);
  }

}

