const char metrics_tarantool_fibers_lua[] =
"local fiber = require('fiber')\n"
"local utils = require('metrics.utils')\n"
"\n"
"local collectors_list = {}\n"
"\n"
"local function update_fibers_metrics()\n"
"    local fibers_info = fiber.info({backtrace = false})\n"
"    local fibers = 0\n"
"    local csws = 0\n"
"    local falloc = 0\n"
"    local fused = 0\n"
"\n"
"    for _, f in pairs(fibers_info) do\n"
"        fibers = fibers + 1\n"
"        csws = csws + f.csw\n"
"        falloc = falloc + f.memory.total\n"
"        fused = fused + f.memory.used\n"
"    end\n"
"\n"
"    collectors_list.fiber_amount = utils.set_gauge('fiber_amount', 'Amount of fibers',\n"
"        fibers, nil, nil, {default = true})\n"
"    collectors_list.fiber_csw = utils.set_gauge('fiber_csw', 'Fibers csw',\n"
"        csws, nil, nil, {default = true})\n"
"    collectors_list.fiber_memalloc = utils.set_gauge('fiber_memalloc', 'Fibers memalloc',\n"
"        falloc, nil, nil, {default = true})\n"
"    collectors_list.fiber_memused = utils.set_gauge('fiber_memused', 'Fibers memused',\n"
"        fused, nil, nil, {default = true})\n"
"end\n"
"\n"
"return {\n"
"    update = update_fibers_metrics,\n"
"    list = collectors_list,\n"
"}\n"
""
;
