/* Display.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Display.vala, do not modify */

/*
* Copyright 2017-2020 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* widget to display/add/remove/move keyboard layouts*/

#include "keyboard.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define KEYBOARD_TYPE_SOURCE_SETTINGS (keyboard_source_settings_get_type ())
#define KEYBOARD_SOURCE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettings))
#define KEYBOARD_SOURCE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettingsClass))
#define KEYBOARD_IS_SOURCE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_TYPE_SOURCE_SETTINGS))
#define KEYBOARD_IS_SOURCE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_TYPE_SOURCE_SETTINGS))
#define KEYBOARD_SOURCE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettingsClass))

typedef struct _KeyboardSourceSettings KeyboardSourceSettings;
typedef struct _KeyboardSourceSettingsClass KeyboardSourceSettingsClass;
enum  {
	KEYBOARD_LAYOUT_PAGE_DISPLAY_0_PROPERTY,
	KEYBOARD_LAYOUT_PAGE_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* keyboard_layout_page_display_properties[KEYBOARD_LAYOUT_PAGE_DISPLAY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW (keyboard_layout_page_display_display_row_get_type ())
#define KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, KeyboardLayoutPageDisplayDisplayRow))
#define KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, KeyboardLayoutPageDisplayDisplayRowClass))
#define KEYBOARD_LAYOUT_PAGE_DISPLAY_IS_DISPLAY_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW))
#define KEYBOARD_LAYOUT_PAGE_DISPLAY_IS_DISPLAY_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW))
#define KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, KeyboardLayoutPageDisplayDisplayRowClass))

typedef struct _KeyboardLayoutPageDisplayDisplayRow KeyboardLayoutPageDisplayDisplayRow;
typedef struct _KeyboardLayoutPageDisplayDisplayRowClass KeyboardLayoutPageDisplayDisplayRowClass;
typedef struct _Block15Data Block15Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _KeyboardLayoutPageDisplayDisplayRowPrivate KeyboardLayoutPageDisplayDisplayRowPrivate;
enum  {
	KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_0_PROPERTY,
	KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_LAYOUT_NAME_PROPERTY,
	KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_INDEX_PROPERTY,
	KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_NUM_PROPERTIES
};
static GParamSpec* keyboard_layout_page_display_display_row_properties[KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_NUM_PROPERTIES];
enum  {
	KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_REMOVE_LAYOUT_SIGNAL,
	KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_MOVE_UP_SIGNAL,
	KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_MOVE_DOWN_SIGNAL,
	KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_NUM_SIGNALS
};
static guint keyboard_layout_page_display_display_row_signals[KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_NUM_SIGNALS] = {0};

struct _KeyboardLayoutPageDisplayPrivate {
	KeyboardSourceSettings* settings;
	GtkListBox* list;
};

struct _Block15Data {
	int _ref_count_;
	KeyboardLayoutPageDisplay* self;
	guint i;
};

struct _KeyboardLayoutPageDisplayDisplayRow {
	GtkListBoxRow parent_instance;
	KeyboardLayoutPageDisplayDisplayRowPrivate * priv;
	GtkButton* up_button;
	GtkButton* down_button;
};

struct _KeyboardLayoutPageDisplayDisplayRowClass {
	GtkListBoxRowClass parent_class;
};

struct _KeyboardLayoutPageDisplayDisplayRowPrivate {
	gchar* _layout_name;
	guint _index;
};

static gint KeyboardLayoutPageDisplay_private_offset;
static gpointer keyboard_layout_page_display_parent_class = NULL;
static gint KeyboardLayoutPageDisplayDisplayRow_private_offset;
static gpointer keyboard_layout_page_display_display_row_parent_class = NULL;

VALA_EXTERN GType keyboard_source_settings_get_type (void) G_GNUC_CONST ;
static gint keyboard_layout_page_display_get_cursor_index (KeyboardLayoutPageDisplay* self);
static GType keyboard_layout_page_display_display_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static guint keyboard_layout_page_display_display_row_get_index (KeyboardLayoutPageDisplayDisplayRow* self);
static void keyboard_layout_page_display_update_cursor (KeyboardLayoutPageDisplay* self);
VALA_EXTERN KeyboardInputSource* keyboard_source_settings_get_active_input_source (KeyboardSourceSettings* self);
VALA_EXTERN guint keyboard_source_settings_get_active_index (KeyboardSourceSettings* self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
VALA_EXTERN void keyboard_source_settings_foreach_layout (KeyboardSourceSettings* self,
                                              GFunc func,
                                              gpointer func_target);
static void __lambda33_ (Block15Data* _data15_,
                  KeyboardInputSource* input_source);
static KeyboardLayoutPageDisplayDisplayRow* keyboard_layout_page_display_display_row_new (const gchar* layout_name,
                                                                                   guint index);
static KeyboardLayoutPageDisplayDisplayRow* keyboard_layout_page_display_display_row_construct (GType object_type,
                                                                                         const gchar* layout_name,
                                                                                         guint index);
static void ___lambda34_ (KeyboardLayoutPageDisplay* self,
                   KeyboardLayoutPageDisplayDisplayRow* row);
VALA_EXTERN void keyboard_source_settings_remove_layout (KeyboardSourceSettings* self,
                                             guint index);
static void ____lambda34__keyboard_layout_page_display_display_row_remove_layout (KeyboardLayoutPageDisplayDisplayRow* _sender,
                                                                           gpointer self);
static void ___lambda35_ (KeyboardLayoutPageDisplay* self,
                   KeyboardLayoutPageDisplayDisplayRow* row);
VALA_EXTERN void keyboard_source_settings_switch_items (KeyboardSourceSettings* self,
                                            guint pos1,
                                            gboolean move_up);
static void ____lambda35__keyboard_layout_page_display_display_row_move_up (KeyboardLayoutPageDisplayDisplayRow* _sender,
                                                                     gpointer self);
static void ___lambda36_ (KeyboardLayoutPageDisplay* self,
                   KeyboardLayoutPageDisplayDisplayRow* row);
static void ____lambda36__keyboard_layout_page_display_display_row_move_down (KeyboardLayoutPageDisplayDisplayRow* _sender,
                                                                       gpointer self);
static void ___lambda33__gfunc (gconstpointer data,
                         gpointer self);
static const gchar* keyboard_layout_page_display_display_row_get_layout_name (KeyboardLayoutPageDisplayDisplayRow* self);
static void keyboard_layout_page_display_display_row_set_layout_name (KeyboardLayoutPageDisplayDisplayRow* self,
                                                               const gchar* value);
static void keyboard_layout_page_display_display_row_set_index (KeyboardLayoutPageDisplayDisplayRow* self,
                                                         guint value);
static GObject * keyboard_layout_page_display_display_row_constructor (GType type,
                                                                guint n_construct_properties,
                                                                GObjectConstructParam * construct_properties);
static void _keyboard_layout_page_display_display_row___lambda30_ (KeyboardLayoutPageDisplayDisplayRow* self);
static void __keyboard_layout_page_display_display_row___lambda30__gtk_button_clicked (GtkButton* _sender,
                                                                                gpointer self);
static void _keyboard_layout_page_display_display_row___lambda31_ (KeyboardLayoutPageDisplayDisplayRow* self);
static void __keyboard_layout_page_display_display_row___lambda31__gtk_button_clicked (GtkButton* _sender,
                                                                                gpointer self);
static void _keyboard_layout_page_display_display_row___lambda32_ (KeyboardLayoutPageDisplayDisplayRow* self);
static void __keyboard_layout_page_display_display_row___lambda32__gtk_button_clicked (GtkButton* _sender,
                                                                                gpointer self);
static void keyboard_layout_page_display_display_row_finalize (GObject * obj);
static GType keyboard_layout_page_display_display_row_get_type_once (void);
static void _vala_keyboard_layout_page_display_display_row_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_keyboard_layout_page_display_display_row_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec);
static GObject * keyboard_layout_page_display_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
VALA_EXTERN KeyboardSourceSettings* keyboard_source_settings_get_instance (void);
static void _keyboard_layout_page_display___lambda37_ (KeyboardLayoutPageDisplay* self);
static void __lambda49_ (KeyboardLayoutPageDisplay* self,
                  const gchar* layout,
                  const gchar* variant);
VALA_EXTERN gboolean keyboard_source_settings_add_layout (KeyboardSourceSettings* self,
                                              KeyboardInputSource* new_layout);
static void ___lambda49__keyboard_layout_page_add_layout_dialog_layout_added (KeyboardLayoutPageAddLayoutDialog* _sender,
                                                                       const gchar* language,
                                                                       const gchar* layout,
                                                                       gpointer self);
static void __keyboard_layout_page_display___lambda37__gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
static void _keyboard_layout_page_display___lambda50_ (KeyboardLayoutPageDisplay* self);
VALA_EXTERN void keyboard_source_settings_set_active_index (KeyboardSourceSettings* self,
                                                guint value);
static void __keyboard_layout_page_display___lambda50__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                            GtkListBoxRow* row,
                                                                            gpointer self);
static void _keyboard_layout_page_display_update_cursor_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
static void _keyboard_layout_page_display_rebuild_list_keyboard_source_settings_external_layout_change (KeyboardSourceSettings* _sender,
                                                                                                 gpointer self);
static void keyboard_layout_page_display_finalize (GObject * obj);
static GType keyboard_layout_page_display_get_type_once (void);

static inline gpointer
keyboard_layout_page_display_get_instance_private (KeyboardLayoutPageDisplay* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardLayoutPageDisplay_private_offset);
}

/**
     * Returns the index of the selected (xkb) layout in the list of (all) input sources.
     * In case the list contains no layouts, it returns 0.
     */
static gint
keyboard_layout_page_display_get_cursor_index (KeyboardLayoutPageDisplay* self)
{
	KeyboardLayoutPageDisplayDisplayRow* selected_row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	KeyboardLayoutPageDisplayDisplayRow* _tmp2_;
	KeyboardLayoutPageDisplayDisplayRow* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->list;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	selected_row = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, KeyboardLayoutPageDisplayDisplayRow);
	_tmp2_ = selected_row;
	if (_tmp2_ == NULL) {
		result = 0;
		return result;
	}
	_tmp3_ = selected_row;
	_tmp4_ = keyboard_layout_page_display_display_row_get_index (_tmp3_);
	_tmp5_ = _tmp4_;
	result = (gint) _tmp5_;
	return result;
}

static void
keyboard_layout_page_display_update_cursor (KeyboardLayoutPageDisplay* self)
{
	KeyboardSourceSettings* _tmp0_;
	KeyboardInputSource* _tmp1_;
	KeyboardInputSource* _tmp2_;
	GtkWidget* child = NULL;
	GtkListBox* _tmp3_;
	GtkWidget* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = keyboard_source_settings_get_active_input_source (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = self->priv->list;
	_tmp4_ = gtk_widget_get_first_child ((GtkWidget*) _tmp3_);
	child = _tmp4_;
	while (TRUE) {
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp16_;
		GtkWidget* _tmp17_;
		_tmp5_ = child;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = child;
		if (KEYBOARD_LAYOUT_PAGE_DISPLAY_IS_DISPLAY_ROW (_tmp6_)) {
			KeyboardLayoutPageDisplayDisplayRow* row = NULL;
			GtkWidget* _tmp7_;
			KeyboardSourceSettings* _tmp8_;
			guint _tmp9_;
			guint _tmp10_;
			KeyboardLayoutPageDisplayDisplayRow* _tmp11_;
			guint _tmp12_;
			guint _tmp13_;
			_tmp7_ = child;
			row = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, KeyboardLayoutPageDisplayDisplayRow);
			_tmp8_ = self->priv->settings;
			_tmp9_ = keyboard_source_settings_get_active_index (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = row;
			_tmp12_ = keyboard_layout_page_display_display_row_get_index (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp10_ == _tmp13_) {
				GtkListBox* _tmp14_;
				KeyboardLayoutPageDisplayDisplayRow* _tmp15_;
				_tmp14_ = self->priv->list;
				_tmp15_ = row;
				gtk_list_box_select_row (_tmp14_, (GtkListBoxRow*) _tmp15_);
				break;
			}
		}
		_tmp16_ = child;
		_tmp17_ = gtk_widget_get_next_sibling (_tmp16_);
		child = _tmp17_;
	}
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		KeyboardLayoutPageDisplay* self;
		self = _data15_->self;
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
___lambda34_ (KeyboardLayoutPageDisplay* self,
              KeyboardLayoutPageDisplayDisplayRow* row)
{
	KeyboardSourceSettings* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = keyboard_layout_page_display_display_row_get_index (row);
	_tmp2_ = _tmp1_;
	keyboard_source_settings_remove_layout (_tmp0_, _tmp2_);
	keyboard_layout_page_display_rebuild_list (self);
}

static void
____lambda34__keyboard_layout_page_display_display_row_remove_layout (KeyboardLayoutPageDisplayDisplayRow* _sender,
                                                                      gpointer self)
{
	___lambda34_ ((KeyboardLayoutPageDisplay*) self, _sender);
}

static void
___lambda35_ (KeyboardLayoutPageDisplay* self,
              KeyboardLayoutPageDisplayDisplayRow* row)
{
	KeyboardSourceSettings* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = keyboard_layout_page_display_display_row_get_index (row);
	_tmp2_ = _tmp1_;
	keyboard_source_settings_switch_items (_tmp0_, _tmp2_, TRUE);
	keyboard_layout_page_display_rebuild_list (self);
}

static void
____lambda35__keyboard_layout_page_display_display_row_move_up (KeyboardLayoutPageDisplayDisplayRow* _sender,
                                                                gpointer self)
{
	___lambda35_ ((KeyboardLayoutPageDisplay*) self, _sender);
}

static void
___lambda36_ (KeyboardLayoutPageDisplay* self,
              KeyboardLayoutPageDisplayDisplayRow* row)
{
	KeyboardSourceSettings* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = keyboard_layout_page_display_display_row_get_index (row);
	_tmp2_ = _tmp1_;
	keyboard_source_settings_switch_items (_tmp0_, _tmp2_, FALSE);
	keyboard_layout_page_display_rebuild_list (self);
}

static void
____lambda36__keyboard_layout_page_display_display_row_move_down (KeyboardLayoutPageDisplayDisplayRow* _sender,
                                                                  gpointer self)
{
	___lambda36_ ((KeyboardLayoutPageDisplay*) self, _sender);
}

static void
__lambda33_ (Block15Data* _data15_,
             KeyboardInputSource* input_source)
{
	KeyboardLayoutPageDisplay* self;
	KeyboardLayoutType _tmp0_;
	KeyboardLayoutType _tmp1_;
	guint _tmp15_;
	self = _data15_->self;
	g_return_if_fail (input_source != NULL);
	_tmp0_ = keyboard_input_source_get_layout_type (input_source);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == KEYBOARD_LAYOUT_TYPE_XKB) {
		KeyboardLayoutPageDisplayDisplayRow* row = NULL;
		KeyboardXkbLayoutHandler* _tmp2_;
		KeyboardXkbLayoutHandler* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		KeyboardLayoutPageDisplayDisplayRow* _tmp8_;
		KeyboardLayoutPageDisplayDisplayRow* _tmp9_;
		GtkListBox* _tmp10_;
		KeyboardLayoutPageDisplayDisplayRow* _tmp11_;
		KeyboardLayoutPageDisplayDisplayRow* _tmp12_;
		KeyboardLayoutPageDisplayDisplayRow* _tmp13_;
		KeyboardLayoutPageDisplayDisplayRow* _tmp14_;
		_tmp2_ = keyboard_xkb_layout_handler_get_instance ();
		_tmp3_ = _tmp2_;
		_tmp4_ = keyboard_input_source_get_name (input_source);
		_tmp5_ = _tmp4_;
		_tmp6_ = keyboard_xkb_layout_handler_get_display_name (_tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = keyboard_layout_page_display_display_row_new (_tmp7_, _data15_->i);
		g_object_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_object_unref0 (_tmp3_);
		row = _tmp9_;
		_tmp10_ = self->priv->list;
		_tmp11_ = row;
		gtk_list_box_append (_tmp10_, (GtkWidget*) _tmp11_);
		_tmp12_ = row;
		g_signal_connect_object (_tmp12_, "remove-layout", (GCallback) ____lambda34__keyboard_layout_page_display_display_row_remove_layout, self, 0);
		_tmp13_ = row;
		g_signal_connect_object (_tmp13_, "move-up", (GCallback) ____lambda35__keyboard_layout_page_display_display_row_move_up, self, 0);
		_tmp14_ = row;
		g_signal_connect_object (_tmp14_, "move-down", (GCallback) ____lambda36__keyboard_layout_page_display_display_row_move_down, self, 0);
		_g_object_unref0 (row);
	}
	_tmp15_ = _data15_->i;
	_data15_->i = _tmp15_ + 1;
}

static void
___lambda33__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda33_ (self, (KeyboardInputSource*) data);
}

void
keyboard_layout_page_display_rebuild_list (KeyboardLayoutPageDisplay* self)
{
	Block15Data* _data15_;
	KeyboardSourceSettings* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBoxRow* _tmp7_;
	g_return_if_fail (self != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	while (TRUE) {
		GtkListBox* _tmp0_;
		GtkListBoxRow* _tmp1_;
		GtkListBox* _tmp2_;
		GtkListBox* _tmp3_;
		GtkListBoxRow* _tmp4_;
		_tmp0_ = self->priv->list;
		_tmp1_ = gtk_list_box_get_row_at_index (_tmp0_, 0);
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = self->priv->list;
		_tmp3_ = self->priv->list;
		_tmp4_ = gtk_list_box_get_row_at_index (_tmp3_, 0);
		gtk_list_box_remove (_tmp2_, (GtkWidget*) _tmp4_);
	}
	_data15_->i = (guint) 0;
	_tmp5_ = self->priv->settings;
	keyboard_source_settings_foreach_layout (_tmp5_, ___lambda33__gfunc, _data15_);
	_tmp6_ = self->priv->list;
	_tmp7_ = gtk_list_box_get_row_at_index (_tmp6_, 0);
	if (_tmp7_ != NULL) {
		KeyboardLayoutPageDisplayDisplayRow* first_child = NULL;
		GtkListBox* _tmp8_;
		GtkListBoxRow* _tmp9_;
		KeyboardLayoutPageDisplayDisplayRow* _tmp10_;
		GtkButton* _tmp11_;
		gint index = 0;
		KeyboardLayoutPageDisplayDisplayRow* last_child = NULL;
		GtkListBox* _tmp15_;
		GtkListBoxRow* _tmp16_;
		KeyboardLayoutPageDisplayDisplayRow* _tmp17_;
		GtkButton* _tmp18_;
		_tmp8_ = self->priv->list;
		_tmp9_ = gtk_list_box_get_row_at_index (_tmp8_, 0);
		first_child = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, KeyboardLayoutPageDisplayDisplayRow);
		_tmp10_ = first_child;
		_tmp11_ = _tmp10_->up_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
		index = 0;
		while (TRUE) {
			GtkListBox* _tmp12_;
			GtkListBoxRow* _tmp13_;
			gint _tmp14_;
			_tmp12_ = self->priv->list;
			_tmp13_ = gtk_list_box_get_row_at_index (_tmp12_, index);
			if (!(_tmp13_ != NULL)) {
				break;
			}
			_tmp14_ = index;
			index = _tmp14_ + 1;
		}
		_tmp15_ = self->priv->list;
		_tmp16_ = gtk_list_box_get_row_at_index (_tmp15_, index - 1);
		last_child = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, KeyboardLayoutPageDisplayDisplayRow);
		_tmp17_ = last_child;
		_tmp18_ = _tmp17_->down_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp18_, FALSE);
	}
	keyboard_layout_page_display_update_cursor (self);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

KeyboardLayoutPageDisplay*
keyboard_layout_page_display_construct (GType object_type)
{
	KeyboardLayoutPageDisplay * self = NULL;
	self = (KeyboardLayoutPageDisplay*) g_object_new (object_type, NULL);
	return self;
}

KeyboardLayoutPageDisplay*
keyboard_layout_page_display_new (void)
{
	return keyboard_layout_page_display_construct (KEYBOARD_LAYOUT_PAGE_TYPE_DISPLAY);
}

static inline gpointer
keyboard_layout_page_display_display_row_get_instance_private (KeyboardLayoutPageDisplayDisplayRow* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardLayoutPageDisplayDisplayRow_private_offset);
}

static KeyboardLayoutPageDisplayDisplayRow*
keyboard_layout_page_display_display_row_construct (GType object_type,
                                                    const gchar* layout_name,
                                                    guint index)
{
	KeyboardLayoutPageDisplayDisplayRow * self = NULL;
	g_return_val_if_fail (layout_name != NULL, NULL);
	self = (KeyboardLayoutPageDisplayDisplayRow*) g_object_new (object_type, "layout-name", layout_name, "index", index, NULL);
	return self;
}

static KeyboardLayoutPageDisplayDisplayRow*
keyboard_layout_page_display_display_row_new (const gchar* layout_name,
                                              guint index)
{
	return keyboard_layout_page_display_display_row_construct (KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, layout_name, index);
}

static const gchar*
keyboard_layout_page_display_display_row_get_layout_name (KeyboardLayoutPageDisplayDisplayRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_layout_name;
	result = _tmp0_;
	return result;
}

static void
keyboard_layout_page_display_display_row_set_layout_name (KeyboardLayoutPageDisplayDisplayRow* self,
                                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_layout_page_display_display_row_get_layout_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_layout_name);
		self->priv->_layout_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, keyboard_layout_page_display_display_row_properties[KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_LAYOUT_NAME_PROPERTY]);
	}
}

static guint
keyboard_layout_page_display_display_row_get_index (KeyboardLayoutPageDisplayDisplayRow* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_index;
	return result;
}

static void
keyboard_layout_page_display_display_row_set_index (KeyboardLayoutPageDisplayDisplayRow* self,
                                                    guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_layout_page_display_display_row_get_index (self);
	if (old_value != value) {
		self->priv->_index = value;
		g_object_notify_by_pspec ((GObject *) self, keyboard_layout_page_display_display_row_properties[KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_INDEX_PROPERTY]);
	}
}

static void
_keyboard_layout_page_display_display_row___lambda30_ (KeyboardLayoutPageDisplayDisplayRow* self)
{
	g_signal_emit (self, keyboard_layout_page_display_display_row_signals[KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_REMOVE_LAYOUT_SIGNAL], 0);
}

static void
__keyboard_layout_page_display_display_row___lambda30__gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self)
{
	_keyboard_layout_page_display_display_row___lambda30_ ((KeyboardLayoutPageDisplayDisplayRow*) self);
}

static void
_keyboard_layout_page_display_display_row___lambda31_ (KeyboardLayoutPageDisplayDisplayRow* self)
{
	g_signal_emit (self, keyboard_layout_page_display_display_row_signals[KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_MOVE_UP_SIGNAL], 0);
}

static void
__keyboard_layout_page_display_display_row___lambda31__gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self)
{
	_keyboard_layout_page_display_display_row___lambda31_ ((KeyboardLayoutPageDisplayDisplayRow*) self);
}

static void
_keyboard_layout_page_display_display_row___lambda32_ (KeyboardLayoutPageDisplayDisplayRow* self)
{
	g_signal_emit (self, keyboard_layout_page_display_display_row_signals[KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_MOVE_DOWN_SIGNAL], 0);
}

static void
__keyboard_layout_page_display_display_row___lambda32__gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self)
{
	_keyboard_layout_page_display_display_row___lambda32_ ((KeyboardLayoutPageDisplayDisplayRow*) self);
}

static GObject *
keyboard_layout_page_display_display_row_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	KeyboardLayoutPageDisplayDisplayRow * self;
	GtkLabel* label = NULL;
	const gchar* _tmp0_;
	GtkLabel* _tmp1_ = NULL;
	GtkButton* remove_button = NULL;
	gchar* _tmp2_;
	GtkButton* _tmp3_ = NULL;
	gchar* _tmp4_;
	GtkButton* _tmp5_ = NULL;
	gchar* _tmp6_;
	GtkButton* _tmp7_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkBox* _tmp11_;
	GtkButton* _tmp12_;
	GtkBox* _tmp13_;
	GtkButton* _tmp14_;
	GtkBox* _tmp15_;
	GtkButton* _tmp16_;
	GtkBox* _tmp17_;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	parent_class = G_OBJECT_CLASS (keyboard_layout_page_display_display_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, KeyboardLayoutPageDisplayDisplayRow);
	_tmp0_ = self->priv->_layout_name;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_START);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp1_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp1_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp1_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp1_, 6);
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	_tmp2_ = g_strdup (_ ("Remove"));
	_tmp3_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-symbolic");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	remove_button = _tmp3_;
	_tmp4_ = g_strdup (_ ("Move up"));
	_tmp5_ = (GtkButton*) gtk_button_new_from_icon_name ("go-up-symbolic");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _tmp4_);
	_g_free0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->up_button);
	self->up_button = _tmp5_;
	_tmp6_ = g_strdup (_ ("Move down"));
	_tmp7_ = (GtkButton*) gtk_button_new_from_icon_name ("go-down-symbolic");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp7_, _tmp6_);
	_g_free0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->down_button);
	self->down_button = _tmp7_;
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp8_);
	box = _tmp8_;
	_tmp9_ = box;
	_tmp10_ = label;
	gtk_box_append (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = box;
	_tmp12_ = remove_button;
	gtk_box_append (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = box;
	_tmp14_ = self->up_button;
	gtk_box_append (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = box;
	_tmp16_ = self->down_button;
	gtk_box_append (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = box;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp17_);
	_tmp18_ = remove_button;
	g_signal_connect_object (_tmp18_, "clicked", (GCallback) __keyboard_layout_page_display_display_row___lambda30__gtk_button_clicked, self, 0);
	_tmp19_ = self->up_button;
	g_signal_connect_object (_tmp19_, "clicked", (GCallback) __keyboard_layout_page_display_display_row___lambda31__gtk_button_clicked, self, 0);
	_tmp20_ = self->down_button;
	g_signal_connect_object (_tmp20_, "clicked", (GCallback) __keyboard_layout_page_display_display_row___lambda32__gtk_button_clicked, self, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (remove_button);
	_g_object_unref0 (label);
	return obj;
}

static void
keyboard_layout_page_display_display_row_class_init (KeyboardLayoutPageDisplayDisplayRowClass * klass,
                                                     gpointer klass_data)
{
	keyboard_layout_page_display_display_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardLayoutPageDisplayDisplayRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_keyboard_layout_page_display_display_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_keyboard_layout_page_display_display_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = keyboard_layout_page_display_display_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = keyboard_layout_page_display_display_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_LAYOUT_NAME_PROPERTY, keyboard_layout_page_display_display_row_properties[KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_LAYOUT_NAME_PROPERTY] = g_param_spec_string ("layout-name", "layout-name", "layout-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_INDEX_PROPERTY, keyboard_layout_page_display_display_row_properties[KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_INDEX_PROPERTY] = g_param_spec_uint ("index", "index", "index", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	keyboard_layout_page_display_display_row_signals[KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_REMOVE_LAYOUT_SIGNAL] = g_signal_new ("remove-layout", KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	keyboard_layout_page_display_display_row_signals[KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_MOVE_UP_SIGNAL] = g_signal_new ("move-up", KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	keyboard_layout_page_display_display_row_signals[KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_MOVE_DOWN_SIGNAL] = g_signal_new ("move-down", KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
keyboard_layout_page_display_display_row_instance_init (KeyboardLayoutPageDisplayDisplayRow * self,
                                                        gpointer klass)
{
	self->priv = keyboard_layout_page_display_display_row_get_instance_private (self);
}

static void
keyboard_layout_page_display_display_row_finalize (GObject * obj)
{
	KeyboardLayoutPageDisplayDisplayRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, KeyboardLayoutPageDisplayDisplayRow);
	_g_free0 (self->priv->_layout_name);
	_g_object_unref0 (self->up_button);
	_g_object_unref0 (self->down_button);
	G_OBJECT_CLASS (keyboard_layout_page_display_display_row_parent_class)->finalize (obj);
}

static GType
keyboard_layout_page_display_display_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardLayoutPageDisplayDisplayRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_layout_page_display_display_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardLayoutPageDisplayDisplayRow), 0, (GInstanceInitFunc) keyboard_layout_page_display_display_row_instance_init, NULL };
	GType keyboard_layout_page_display_display_row_type_id;
	keyboard_layout_page_display_display_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "KeyboardLayoutPageDisplayDisplayRow", &g_define_type_info, 0);
	KeyboardLayoutPageDisplayDisplayRow_private_offset = g_type_add_instance_private (keyboard_layout_page_display_display_row_type_id, sizeof (KeyboardLayoutPageDisplayDisplayRowPrivate));
	return keyboard_layout_page_display_display_row_type_id;
}

static GType
keyboard_layout_page_display_display_row_get_type (void)
{
	static volatile gsize keyboard_layout_page_display_display_row_type_id__once = 0;
	if (g_once_init_enter (&keyboard_layout_page_display_display_row_type_id__once)) {
		GType keyboard_layout_page_display_display_row_type_id;
		keyboard_layout_page_display_display_row_type_id = keyboard_layout_page_display_display_row_get_type_once ();
		g_once_init_leave (&keyboard_layout_page_display_display_row_type_id__once, keyboard_layout_page_display_display_row_type_id);
	}
	return keyboard_layout_page_display_display_row_type_id__once;
}

static void
_vala_keyboard_layout_page_display_display_row_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec)
{
	KeyboardLayoutPageDisplayDisplayRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, KeyboardLayoutPageDisplayDisplayRow);
	switch (property_id) {
		case KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_LAYOUT_NAME_PROPERTY:
		g_value_set_string (value, keyboard_layout_page_display_display_row_get_layout_name (self));
		break;
		case KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_INDEX_PROPERTY:
		g_value_set_uint (value, keyboard_layout_page_display_display_row_get_index (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_keyboard_layout_page_display_display_row_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec)
{
	KeyboardLayoutPageDisplayDisplayRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_LAYOUT_PAGE_DISPLAY_TYPE_DISPLAY_ROW, KeyboardLayoutPageDisplayDisplayRow);
	switch (property_id) {
		case KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_LAYOUT_NAME_PROPERTY:
		keyboard_layout_page_display_display_row_set_layout_name (self, g_value_get_string (value));
		break;
		case KEYBOARD_LAYOUT_PAGE_DISPLAY_DISPLAY_ROW_INDEX_PROPERTY:
		keyboard_layout_page_display_display_row_set_index (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda49_ (KeyboardLayoutPageDisplay* self,
             const gchar* layout,
             const gchar* variant)
{
	KeyboardSourceSettings* _tmp0_;
	KeyboardInputSource* _tmp1_;
	KeyboardInputSource* _tmp2_;
	g_return_if_fail (layout != NULL);
	g_return_if_fail (variant != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = keyboard_input_source_new_xkb (layout, variant);
	_tmp2_ = _tmp1_;
	keyboard_source_settings_add_layout (_tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	keyboard_layout_page_display_rebuild_list (self);
}

static void
___lambda49__keyboard_layout_page_add_layout_dialog_layout_added (KeyboardLayoutPageAddLayoutDialog* _sender,
                                                                  const gchar* language,
                                                                  const gchar* layout,
                                                                  gpointer self)
{
	__lambda49_ ((KeyboardLayoutPageDisplay*) self, language, layout);
}

static void
_keyboard_layout_page_display___lambda37_ (KeyboardLayoutPageDisplay* self)
{
	KeyboardLayoutPageAddLayoutDialog* dialog = NULL;
	KeyboardLayoutPageAddLayoutDialog* _tmp0_;
	KeyboardLayoutPageAddLayoutDialog* _tmp1_;
	GtkRoot* _tmp2_;
	KeyboardLayoutPageAddLayoutDialog* _tmp3_;
	KeyboardLayoutPageAddLayoutDialog* _tmp4_;
	_tmp0_ = keyboard_layout_page_add_layout_dialog_new ();
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	_tmp1_ = dialog;
	_tmp2_ = gtk_widget_get_root ((GtkWidget*) self);
	gtk_window_set_transient_for ((GtkWindow*) _tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow));
	_tmp3_ = dialog;
	gtk_window_present ((GtkWindow*) _tmp3_);
	_tmp4_ = dialog;
	g_signal_connect_object (_tmp4_, "layout-added", (GCallback) ___lambda49__keyboard_layout_page_add_layout_dialog_layout_added, self, 0);
	_g_object_unref0 (dialog);
}

static void
__keyboard_layout_page_display___lambda37__gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	_keyboard_layout_page_display___lambda37_ ((KeyboardLayoutPageDisplay*) self);
}

static void
_keyboard_layout_page_display___lambda50_ (KeyboardLayoutPageDisplay* self)
{
	KeyboardSourceSettings* _tmp0_;
	_tmp0_ = self->priv->settings;
	keyboard_source_settings_set_active_index (_tmp0_, (guint) keyboard_layout_page_display_get_cursor_index (self));
}

static void
__keyboard_layout_page_display___lambda50__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                       GtkListBoxRow* row,
                                                                       gpointer self)
{
	_keyboard_layout_page_display___lambda50_ ((KeyboardLayoutPageDisplay*) self);
}

static void
_keyboard_layout_page_display_update_cursor_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
	keyboard_layout_page_display_update_cursor ((KeyboardLayoutPageDisplay*) self);
}

static void
_keyboard_layout_page_display_rebuild_list_keyboard_source_settings_external_layout_change (KeyboardSourceSettings* _sender,
                                                                                            gpointer self)
{
	keyboard_layout_page_display_rebuild_list ((KeyboardLayoutPageDisplay*) self);
}

static GObject *
keyboard_layout_page_display_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	KeyboardLayoutPageDisplay * self;
	KeyboardSourceSettings* _tmp0_;
	GtkListBox* _tmp1_ = NULL;
	GtkScrolledWindow* scroll = NULL;
	GtkListBox* _tmp2_;
	GtkWidget* _tmp3_;
	GtkScrolledWindow* _tmp4_ = NULL;
	GtkLabel* add_button_label = NULL;
	GtkLabel* _tmp5_;
	GtkBox* add_button_box = NULL;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* _tmp9_;
	GtkBox* _tmp10_;
	GtkLabel* _tmp11_;
	GtkButton* add_button = NULL;
	GtkBox* _tmp12_;
	GtkWidget* _tmp13_;
	GtkButton* _tmp14_ = NULL;
	GtkButton* _tmp15_;
	GtkLabel* _tmp16_;
	GtkButton* _tmp17_;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp18_;
	GtkActionBar* _tmp19_;
	GtkButton* _tmp20_;
	GtkActionBar* _tmp21_;
	GtkBox* box = NULL;
	GtkBox* _tmp22_;
	GtkBox* _tmp23_;
	GtkScrolledWindow* _tmp24_;
	GtkBox* _tmp25_;
	GtkActionBar* _tmp26_;
	GtkBox* _tmp27_;
	GtkButton* _tmp28_;
	GtkListBox* _tmp29_;
	KeyboardSourceSettings* _tmp30_;
	KeyboardSourceSettings* _tmp31_;
	parent_class = G_OBJECT_CLASS (keyboard_layout_page_display_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_LAYOUT_PAGE_TYPE_DISPLAY, KeyboardLayoutPageDisplay);
	_tmp0_ = keyboard_source_settings_get_instance ();
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp1_, GTK_SELECTION_BROWSE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->list);
	self->priv->list = _tmp1_;
	_tmp2_ = self->priv->list;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	_tmp4_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_set (_tmp4_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
	gtk_scrolled_window_set_child (_tmp4_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	scroll = _tmp4_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_ ("Add Keyboard Layout…"));
	g_object_ref_sink (_tmp5_);
	add_button_label = _tmp5_;
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp6_);
	add_button_box = _tmp6_;
	_tmp7_ = add_button_box;
	_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic");
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	gtk_box_append (_tmp7_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = add_button_box;
	_tmp11_ = add_button_label;
	gtk_box_append (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = add_button_box;
	_tmp13_ = _g_object_ref0 ((GtkWidget*) _tmp12_);
	_tmp14_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp14_, _tmp13_);
	_g_object_unref0 (_tmp13_);
	g_object_ref_sink (_tmp14_);
	add_button = _tmp14_;
	_tmp15_ = add_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp15_, GRANITE_STYLE_CLASS_FLAT);
	_tmp16_ = add_button_label;
	_tmp17_ = add_button;
	gtk_label_set_mnemonic_widget (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp18_);
	actionbar = _tmp18_;
	_tmp19_ = actionbar;
	_tmp20_ = add_button;
	gtk_action_bar_pack_start (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = actionbar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp21_, GRANITE_STYLE_CLASS_FLAT);
	_tmp22_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp22_);
	box = _tmp22_;
	_tmp23_ = box;
	_tmp24_ = scroll;
	gtk_box_append (_tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = box;
	_tmp26_ = actionbar;
	gtk_box_append (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = box;
	gtk_frame_set_child ((GtkFrame*) self, (GtkWidget*) _tmp27_);
	_tmp28_ = add_button;
	g_signal_connect_object (_tmp28_, "clicked", (GCallback) __keyboard_layout_page_display___lambda37__gtk_button_clicked, self, 0);
	_tmp29_ = self->priv->list;
	g_signal_connect_object (_tmp29_, "row-activated", (GCallback) __keyboard_layout_page_display___lambda50__gtk_list_box_row_activated, self, 0);
	_tmp30_ = self->priv->settings;
	g_signal_connect_object ((GObject*) _tmp30_, "notify::active-index", (GCallback) _keyboard_layout_page_display_update_cursor_g_object_notify, self, 0);
	_tmp31_ = self->priv->settings;
	g_signal_connect_object (_tmp31_, "external-layout-change", (GCallback) _keyboard_layout_page_display_rebuild_list_keyboard_source_settings_external_layout_change, self, 0);
	keyboard_layout_page_display_rebuild_list (self);
	_g_object_unref0 (box);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (add_button);
	_g_object_unref0 (add_button_box);
	_g_object_unref0 (add_button_label);
	_g_object_unref0 (scroll);
	return obj;
}

static void
keyboard_layout_page_display_class_init (KeyboardLayoutPageDisplayClass * klass,
                                         gpointer klass_data)
{
	keyboard_layout_page_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardLayoutPageDisplay_private_offset);
	G_OBJECT_CLASS (klass)->constructor = keyboard_layout_page_display_constructor;
	G_OBJECT_CLASS (klass)->finalize = keyboard_layout_page_display_finalize;
}

static void
keyboard_layout_page_display_instance_init (KeyboardLayoutPageDisplay * self,
                                            gpointer klass)
{
	self->priv = keyboard_layout_page_display_get_instance_private (self);
}

static void
keyboard_layout_page_display_finalize (GObject * obj)
{
	KeyboardLayoutPageDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_LAYOUT_PAGE_TYPE_DISPLAY, KeyboardLayoutPageDisplay);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->list);
	G_OBJECT_CLASS (keyboard_layout_page_display_parent_class)->finalize (obj);
}

static GType
keyboard_layout_page_display_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardLayoutPageDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_layout_page_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardLayoutPageDisplay), 0, (GInstanceInitFunc) keyboard_layout_page_display_instance_init, NULL };
	GType keyboard_layout_page_display_type_id;
	keyboard_layout_page_display_type_id = g_type_register_static (gtk_frame_get_type (), "KeyboardLayoutPageDisplay", &g_define_type_info, 0);
	KeyboardLayoutPageDisplay_private_offset = g_type_add_instance_private (keyboard_layout_page_display_type_id, sizeof (KeyboardLayoutPageDisplayPrivate));
	return keyboard_layout_page_display_type_id;
}

GType
keyboard_layout_page_display_get_type (void)
{
	static volatile gsize keyboard_layout_page_display_type_id__once = 0;
	if (g_once_init_enter (&keyboard_layout_page_display_type_id__once)) {
		GType keyboard_layout_page_display_type_id;
		keyboard_layout_page_display_type_id = keyboard_layout_page_display_get_type_once ();
		g_once_init_leave (&keyboard_layout_page_display_type_id__once, keyboard_layout_page_display_type_id);
	}
	return keyboard_layout_page_display_type_id__once;
}

