/* rygel-media-item.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-media-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define RYGEL_TYPE_MEDIA_ITEM_ERROR (rygel_media_item_error_get_type ())
enum  {
	RYGEL_MEDIA_ITEM_0_PROPERTY,
	RYGEL_MEDIA_ITEM_DESCRIPTION_PROPERTY,
	RYGEL_MEDIA_ITEM_NUM_PROPERTIES
};
static GParamSpec* rygel_media_item_properties[RYGEL_MEDIA_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()

struct _RygelMediaItemPrivate {
	gchar* _description;
};

static gint RygelMediaItem_private_offset;
static gpointer rygel_media_item_parent_class = NULL;

VALA_EXTERN GQuark rygel_media_item_error_quark (void);
VALA_EXTERN GType rygel_media_item_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void rygel_media_object_apply_didl_lite (RygelMediaObject* self,
                                         GUPnPDIDLLiteObject* didl_object);
static void rygel_media_item_real_apply_didl_lite (RygelMediaObject* base,
                                            GUPnPDIDLLiteObject* didl_object);
static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base,
                                                      RygelSerializer* serializer,
                                                      RygelHTTPServer* http_server,
                                                      GError** error);
VALA_EXTERN gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_media_item_finalize (GObject * obj);
static GType rygel_media_item_get_type_once (void);
static void _vala_rygel_media_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_rygel_media_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
rygel_media_item_error_quark (void)
{
	return g_quark_from_static_string ("rygel-media-item-error-quark");
}

 G_GNUC_NO_INLINE static GType
rygel_media_item_error_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_MEDIA_ITEM_ERROR_BAD_URI, "RYGEL_MEDIA_ITEM_ERROR_BAD_URI", "bad-uri"}, {0, NULL, NULL}};
	GType rygel_media_item_error_type_id;
	rygel_media_item_error_type_id = g_enum_register_static ("RygelMediaItemError", values);
	return rygel_media_item_error_type_id;
}

GType
rygel_media_item_error_get_type (void)
{
	static volatile gsize rygel_media_item_error_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_item_error_type_id__once)) {
		GType rygel_media_item_error_type_id;
		rygel_media_item_error_type_id = rygel_media_item_error_get_type_once ();
		g_once_init_leave (&rygel_media_item_error_type_id__once, rygel_media_item_error_type_id);
	}
	return rygel_media_item_error_type_id__once;
}

static inline gpointer
rygel_media_item_get_instance_private (RygelMediaItem* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaItem_private_offset);
}

static void
rygel_media_item_real_apply_didl_lite (RygelMediaObject* base,
                                       GUPnPDIDLLiteObject* didl_object)
{
	RygelMediaItem * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (RygelMediaItem*) base;
	g_return_if_fail (didl_object != NULL);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->apply_didl_lite (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject), didl_object);
	_tmp0_ = gupnp_didl_lite_object_get_creator (didl_object);
	rygel_media_object_set_creator ((RygelMediaObject*) self, _tmp0_);
	_tmp1_ = gupnp_didl_lite_object_get_date (didl_object);
	_tmp2_ = _tmp1_;
	rygel_media_object_set_date ((RygelMediaObject*) self, _tmp2_);
	_tmp3_ = gupnp_didl_lite_object_get_description (didl_object);
	_tmp4_ = _tmp3_;
	rygel_media_item_set_description (self, _tmp4_);
}

static GUPnPDIDLLiteObject*
rygel_media_item_real_serialize (RygelMediaObject* base,
                                 RygelSerializer* serializer,
                                 RygelHTTPServer* http_server,
                                 GError** error)
{
	RygelMediaItem * self;
	GUPnPDIDLLiteItem* didl_item = NULL;
	GUPnPDIDLLiteItem* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	RygelMediaContainer* _tmp9_;
	RygelMediaContainer* _tmp10_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GUPnPDIDLLiteItem* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GUPnPDIDLLiteItem* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gboolean _tmp35_ = FALSE;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp45_;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	gboolean _tmp61_ = FALSE;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	GUPnPDIDLLiteObject* result;
	self = (RygelMediaItem*) base;
	g_return_val_if_fail (serializer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = rygel_serializer_add_item (serializer);
	didl_item = _tmp0_;
	_tmp1_ = didl_item;
	_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp3_ = _tmp2_;
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) _tmp1_, _tmp3_);
	_tmp4_ = rygel_media_object_get_ref_id ((RygelMediaObject*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		GUPnPDIDLLiteItem* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = didl_item;
		_tmp7_ = rygel_media_object_get_ref_id ((RygelMediaObject*) self);
		_tmp8_ = _tmp7_;
		gupnp_didl_lite_item_set_ref_id (_tmp6_, _tmp8_);
	}
	_tmp9_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		GUPnPDIDLLiteItem* _tmp11_;
		RygelMediaContainer* _tmp12_;
		RygelMediaContainer* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp11_ = didl_item;
		_tmp12_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp13_);
		_tmp15_ = _tmp14_;
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp11_, _tmp15_);
	} else {
		GUPnPDIDLLiteItem* _tmp16_;
		_tmp16_ = didl_item;
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp16_, "0");
	}
	_tmp17_ = rygel_media_object_get_restricted ((RygelMediaObject*) self);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		GUPnPDIDLLiteItem* _tmp19_;
		_tmp19_ = didl_item;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp19_, TRUE);
	} else {
		GUPnPDIDLLiteItem* _tmp20_;
		GUPnPDIDLLiteItem* _tmp21_;
		GUPnPOCMFlags _tmp22_;
		GUPnPOCMFlags _tmp23_;
		_tmp20_ = didl_item;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp20_, FALSE);
		_tmp21_ = didl_item;
		_tmp22_ = rygel_media_object_get_ocm_flags ((RygelMediaObject*) self);
		_tmp23_ = _tmp22_;
		gupnp_didl_lite_object_set_dlna_managed ((GUPnPDIDLLiteObject*) _tmp21_, _tmp23_);
	}
	_tmp24_ = didl_item;
	_tmp25_ = rygel_media_object_get_title ((RygelMediaObject*) self);
	_tmp26_ = _tmp25_;
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) _tmp24_, _tmp26_);
	_tmp27_ = didl_item;
	_tmp28_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) self);
	_tmp29_ = _tmp28_;
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _tmp27_, _tmp29_);
	_tmp30_ = rygel_media_object_get_date ((RygelMediaObject*) self);
	_tmp31_ = _tmp30_;
	if (_tmp31_ != NULL) {
		GUPnPDIDLLiteItem* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		_tmp32_ = didl_item;
		_tmp33_ = rygel_media_object_get_date ((RygelMediaObject*) self);
		_tmp34_ = _tmp33_;
		gupnp_didl_lite_object_set_date ((GUPnPDIDLLiteObject*) _tmp32_, _tmp34_);
	}
	_tmp36_ = rygel_media_object_get_creator ((RygelMediaObject*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		_tmp38_ = rygel_media_object_get_creator ((RygelMediaObject*) self);
		_tmp39_ = _tmp38_;
		_tmp35_ = g_strcmp0 (_tmp39_, "") != 0;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		GUPnPDIDLLiteContributor* creator = NULL;
		GUPnPDIDLLiteItem* _tmp40_;
		GUPnPDIDLLiteContributor* _tmp41_;
		GUPnPDIDLLiteContributor* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		_tmp40_ = didl_item;
		_tmp41_ = gupnp_didl_lite_object_add_creator ((GUPnPDIDLLiteObject*) _tmp40_);
		creator = _tmp41_;
		_tmp42_ = creator;
		_tmp43_ = rygel_media_object_get_creator ((RygelMediaObject*) self);
		_tmp44_ = _tmp43_;
		gupnp_didl_lite_contributor_set_name (_tmp42_, _tmp44_);
		_g_object_unref0 (creator);
	}
	_tmp45_ = self->priv->_description;
	if (_tmp45_ != NULL) {
		GUPnPDIDLLiteItem* _tmp46_;
		const gchar* _tmp47_;
		_tmp46_ = didl_item;
		_tmp47_ = self->priv->_description;
		gupnp_didl_lite_object_set_description ((GUPnPDIDLLiteObject*) _tmp46_, _tmp47_);
	}
	if (RYGEL_IS_TRACKABLE_ITEM (self)) {
		GUPnPDIDLLiteItem* _tmp48_;
		guint _tmp49_;
		guint _tmp50_;
		_tmp48_ = didl_item;
		_tmp49_ = rygel_media_object_get_object_update_id ((RygelMediaObject*) self);
		_tmp50_ = _tmp49_;
		gupnp_didl_lite_object_set_update_id ((GUPnPDIDLLiteObject*) _tmp48_, _tmp50_);
	}
	_tmp52_ = rygel_media_object_get_artist ((RygelMediaObject*) self);
	_tmp53_ = _tmp52_;
	if (_tmp53_ != NULL) {
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		_tmp54_ = rygel_media_object_get_artist ((RygelMediaObject*) self);
		_tmp55_ = _tmp54_;
		_tmp51_ = g_strcmp0 (_tmp55_, "") != 0;
	} else {
		_tmp51_ = FALSE;
	}
	if (_tmp51_) {
		GUPnPDIDLLiteContributor* contributor = NULL;
		GUPnPDIDLLiteItem* _tmp56_;
		GUPnPDIDLLiteContributor* _tmp57_;
		GUPnPDIDLLiteContributor* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		_tmp56_ = didl_item;
		_tmp57_ = gupnp_didl_lite_object_add_artist ((GUPnPDIDLLiteObject*) _tmp56_);
		contributor = _tmp57_;
		_tmp58_ = contributor;
		_tmp59_ = rygel_media_object_get_artist ((RygelMediaObject*) self);
		_tmp60_ = _tmp59_;
		gupnp_didl_lite_contributor_set_name (_tmp58_, _tmp60_);
		_g_object_unref0 (contributor);
	}
	_tmp62_ = rygel_media_object_get_genre ((RygelMediaObject*) self);
	_tmp63_ = _tmp62_;
	if (_tmp63_ != NULL) {
		const gchar* _tmp64_;
		const gchar* _tmp65_;
		_tmp64_ = rygel_media_object_get_genre ((RygelMediaObject*) self);
		_tmp65_ = _tmp64_;
		_tmp61_ = g_strcmp0 (_tmp65_, "") != 0;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		GUPnPDIDLLiteItem* _tmp66_;
		const gchar* _tmp67_;
		const gchar* _tmp68_;
		_tmp66_ = didl_item;
		_tmp67_ = rygel_media_object_get_genre ((RygelMediaObject*) self);
		_tmp68_ = _tmp67_;
		gupnp_didl_lite_object_set_genre ((GUPnPDIDLLiteObject*) _tmp66_, _tmp68_);
	}
	result = (GUPnPDIDLLiteObject*) didl_item;
	return result;
}

RygelMediaItem*
rygel_media_item_construct (GType object_type)
{
	RygelMediaItem * self = NULL;
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
	return self;
}

const gchar*
rygel_media_item_get_description (RygelMediaItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

void
rygel_media_item_set_description (RygelMediaItem* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_item_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_item_properties[RYGEL_MEDIA_ITEM_DESCRIPTION_PROPERTY]);
	}
}

static void
rygel_media_item_class_init (RygelMediaItemClass * klass,
                             gpointer klass_data)
{
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaItem_private_offset);
	((RygelMediaObjectClass *) klass)->apply_didl_lite = (void (*) (RygelMediaObject*, GUPnPDIDLLiteObject*)) rygel_media_item_real_apply_didl_lite;
	((RygelMediaObjectClass *) klass)->serialize = (GUPnPDIDLLiteObject* (*) (RygelMediaObject*, RygelSerializer*, RygelHTTPServer*, GError**)) rygel_media_item_real_serialize;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_DESCRIPTION_PROPERTY, rygel_media_item_properties[RYGEL_MEDIA_ITEM_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_media_item_instance_init (RygelMediaItem * self,
                                gpointer klass)
{
	self->priv = rygel_media_item_get_instance_private (self);
	self->priv->_description = NULL;
}

static void
rygel_media_item_finalize (GObject * obj)
{
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
	_g_free0 (self->priv->_description);
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}

/**
 * Abstract class representing a MediaItem
 *
 * MediaItems must live in a container and may not contain other MediaItems
 */
 G_GNUC_NO_INLINE static GType
rygel_media_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
	GType rygel_media_item_type_id;
	rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	RygelMediaItem_private_offset = g_type_add_instance_private (rygel_media_item_type_id, sizeof (RygelMediaItemPrivate));
	return rygel_media_item_type_id;
}

GType
rygel_media_item_get_type (void)
{
	static volatile gsize rygel_media_item_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__once)) {
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = rygel_media_item_get_type_once ();
		g_once_init_leave (&rygel_media_item_type_id__once, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__once;
}

static void
_vala_rygel_media_item_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
	switch (property_id) {
		case RYGEL_MEDIA_ITEM_DESCRIPTION_PROPERTY:
		g_value_set_string (value, rygel_media_item_get_description (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_item_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
	switch (property_id) {
		case RYGEL_MEDIA_ITEM_DESCRIPTION_PROPERTY:
		rygel_media_item_set_description (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

