/* rygel-logical-expression.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-logical-expression.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer rygel_logical_expression_parent_class = NULL;

static gboolean rygel_logical_expression_real_satisfied_by (RygelSearchExpression* base,
                                                     RygelMediaObject* media_object);
static gchar* rygel_logical_expression_real_to_string (RygelSearchExpression* base);
static GType rygel_logical_expression_get_type_once (void);

 G_GNUC_NO_INLINE static GType
rygel_logical_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_LOGICAL_OPERATOR_AND, "RYGEL_LOGICAL_OPERATOR_AND", "and"}, {RYGEL_LOGICAL_OPERATOR_OR, "RYGEL_LOGICAL_OPERATOR_OR", "or"}, {0, NULL, NULL}};
	GType rygel_logical_operator_type_id;
	rygel_logical_operator_type_id = g_enum_register_static ("RygelLogicalOperator", values);
	return rygel_logical_operator_type_id;
}

GType
rygel_logical_operator_get_type (void)
{
	static volatile gsize rygel_logical_operator_type_id__once = 0;
	if (g_once_init_enter (&rygel_logical_operator_type_id__once)) {
		GType rygel_logical_operator_type_id;
		rygel_logical_operator_type_id = rygel_logical_operator_get_type_once ();
		g_once_init_leave (&rygel_logical_operator_type_id__once, rygel_logical_operator_type_id);
	}
	return rygel_logical_operator_type_id__once;
}

static gboolean
rygel_logical_expression_real_satisfied_by (RygelSearchExpression* base,
                                            RygelMediaObject* media_object)
{
	RygelLogicalExpression * self;
	gconstpointer _tmp0_;
	gboolean result;
	self = (RygelLogicalExpression*) base;
	g_return_val_if_fail (media_object != NULL, FALSE);
	_tmp0_ = ((RygelSearchExpression*) self)->op;
	switch ((RygelLogicalOperator) ((gintptr) _tmp0_)) {
		case RYGEL_LOGICAL_OPERATOR_AND:
		{
			gboolean _tmp1_ = FALSE;
			gconstpointer _tmp2_;
			_tmp2_ = ((RygelSearchExpression*) self)->operand1;
			if (rygel_search_expression_satisfied_by ((RygelSearchExpression*) _tmp2_, media_object)) {
				gconstpointer _tmp3_;
				_tmp3_ = ((RygelSearchExpression*) self)->operand2;
				_tmp1_ = rygel_search_expression_satisfied_by ((RygelSearchExpression*) _tmp3_, media_object);
			} else {
				_tmp1_ = FALSE;
			}
			result = _tmp1_;
			return result;
		}
		case RYGEL_LOGICAL_OPERATOR_OR:
		{
			gboolean _tmp4_ = FALSE;
			gconstpointer _tmp5_;
			_tmp5_ = ((RygelSearchExpression*) self)->operand1;
			if (rygel_search_expression_satisfied_by ((RygelSearchExpression*) _tmp5_, media_object)) {
				_tmp4_ = TRUE;
			} else {
				gconstpointer _tmp6_;
				_tmp6_ = ((RygelSearchExpression*) self)->operand2;
				_tmp4_ = rygel_search_expression_satisfied_by ((RygelSearchExpression*) _tmp6_, media_object);
			}
			result = _tmp4_;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gchar*
rygel_logical_expression_real_to_string (RygelSearchExpression* base)
{
	RygelLogicalExpression * self;
	gchar* _tmp0_ = NULL;
	gconstpointer _tmp1_;
	gchar* operand1 = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gconstpointer _tmp7_;
	gchar* operand2 = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gconstpointer _tmp13_;
	gchar* _tmp14_;
	gchar* result;
	self = (RygelLogicalExpression*) base;
	_tmp1_ = ((RygelSearchExpression*) self)->operand1;
	if (((RygelSearchExpression*) _tmp1_) != NULL) {
		gconstpointer _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = ((RygelSearchExpression*) self)->operand1;
		_tmp3_ = rygel_search_expression_to_string ((RygelSearchExpression*) _tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("none");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = g_strdup (_tmp0_);
	operand1 = _tmp5_;
	_tmp7_ = ((RygelSearchExpression*) self)->operand2;
	if (((RygelSearchExpression*) _tmp7_) != NULL) {
		gconstpointer _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = ((RygelSearchExpression*) self)->operand2;
		_tmp9_ = rygel_search_expression_to_string ((RygelSearchExpression*) _tmp8_);
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("none");
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp10_;
	}
	_tmp11_ = g_strdup (_tmp6_);
	operand2 = _tmp11_;
	_tmp12_ = operand1;
	_tmp13_ = ((RygelSearchExpression*) self)->op;
	_tmp14_ = g_strdup_printf ("(%s %d %s)", _tmp12_, (gint) ((RygelLogicalOperator) ((gintptr) _tmp13_)), operand2);
	result = _tmp14_;
	_g_free0 (operand2);
	_g_free0 (_tmp6_);
	_g_free0 (operand1);
	_g_free0 (_tmp0_);
	return result;
}

RygelLogicalExpression*
rygel_logical_expression_construct (GType object_type)
{
	RygelLogicalExpression* self = NULL;
	self = (RygelLogicalExpression*) rygel_search_expression_construct (object_type, RYGEL_TYPE_LOGICAL_OPERATOR, NULL, NULL, RYGEL_TYPE_SEARCH_EXPRESSION, (GBoxedCopyFunc) rygel_search_expression_ref, (GDestroyNotify) rygel_search_expression_unref, RYGEL_TYPE_SEARCH_EXPRESSION, (GBoxedCopyFunc) rygel_search_expression_ref, (GDestroyNotify) rygel_search_expression_unref);
	return self;
}

RygelLogicalExpression*
rygel_logical_expression_new (void)
{
	return rygel_logical_expression_construct (RYGEL_TYPE_LOGICAL_EXPRESSION);
}

static void
rygel_logical_expression_class_init (RygelLogicalExpressionClass * klass,
                                     gpointer klass_data)
{
	rygel_logical_expression_parent_class = g_type_class_peek_parent (klass);
	((RygelSearchExpressionClass *) klass)->satisfied_by = (gboolean (*) (RygelSearchExpression*, RygelMediaObject*)) rygel_logical_expression_real_satisfied_by;
	((RygelSearchExpressionClass *) klass)->to_string = (gchar* (*) (RygelSearchExpression*)) rygel_logical_expression_real_to_string;
}

static void
rygel_logical_expression_instance_init (RygelLogicalExpression * self,
                                        gpointer klass)
{
}

/**
 * This is a parsed UPnP search expression consisting of two other search expressions
 * joined by a boolean operator such as AND or OR.
 */
 G_GNUC_NO_INLINE static GType
rygel_logical_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLogicalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_logical_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLogicalExpression), 0, (GInstanceInitFunc) rygel_logical_expression_instance_init, NULL };
	GType rygel_logical_expression_type_id;
	rygel_logical_expression_type_id = g_type_register_static (RYGEL_TYPE_SEARCH_EXPRESSION, "RygelLogicalExpression", &g_define_type_info, 0);
	return rygel_logical_expression_type_id;
}

GType
rygel_logical_expression_get_type (void)
{
	static volatile gsize rygel_logical_expression_type_id__once = 0;
	if (g_once_init_enter (&rygel_logical_expression_type_id__once)) {
		GType rygel_logical_expression_type_id;
		rygel_logical_expression_type_id = rygel_logical_expression_get_type_once ();
		g_once_init_leave (&rygel_logical_expression_type_id__once, rygel_logical_expression_type_id);
	}
	return rygel_logical_expression_type_id__once;
}

