/* rygel-image-item.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-image-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_IMAGE_ITEM_0_PROPERTY,
	RYGEL_IMAGE_ITEM_WIDTH_PROPERTY,
	RYGEL_IMAGE_ITEM_HEIGHT_PROPERTY,
	RYGEL_IMAGE_ITEM_COLOR_DEPTH_PROPERTY,
	RYGEL_IMAGE_ITEM_THUMBNAILS_PROPERTY,
	RYGEL_IMAGE_ITEM_NUM_PROPERTIES
};
static GParamSpec* rygel_image_item_properties[RYGEL_IMAGE_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelImageItemPrivate {
	gint _width;
	gint _height;
	gint _color_depth;
	GeeArrayList* _thumbnails;
};

static gint RygelImageItem_private_offset;
static gpointer rygel_image_item_parent_class = NULL;
static RygelVisualItemIface * rygel_image_item_rygel_visual_item_parent_iface = NULL;

VALA_EXTERN void rygel_media_file_item_add_additional_resources (RygelMediaFileItem* self,
                                                     RygelHTTPServer* server);
static void rygel_image_item_real_constructed (GObject* base);
static void rygel_image_item_real_add_uri (RygelMediaObject* base,
                                    const gchar* uri);
VALA_EXTERN void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self,
                                              const gchar* uri);
static RygelMediaResource* rygel_image_item_real_get_primary_resource (RygelMediaFileItem* base);
VALA_EXTERN void rygel_visual_item_set_visual_resource_properties (RygelVisualItem* self,
                                                       RygelMediaResource* res);
static void rygel_image_item_real_add_additional_resources (RygelMediaFileItem* base,
                                                     RygelHTTPServer* server);
VALA_EXTERN void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self,
                                                RygelHTTPServer* http_server);
static void rygel_image_item_finalize (GObject * obj);
static GType rygel_image_item_get_type_once (void);
static void _vala_rygel_image_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_rygel_image_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
rygel_image_item_get_instance_private (RygelImageItem* self)
{
	return G_STRUCT_MEMBER_P (self, RygelImageItem_private_offset);
}

RygelImageItem*
rygel_image_item_construct (GType object_type,
                            const gchar* id,
                            RygelMediaContainer* parent,
                            const gchar* title,
                            const gchar* upnp_class)
{
	RygelImageItem * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelImageItem*) g_object_new (object_type, "id", id, "parent", parent, "title", title, "upnp-class", upnp_class, NULL);
	return self;
}

RygelImageItem*
rygel_image_item_new (const gchar* id,
                      RygelMediaContainer* parent,
                      const gchar* title,
                      const gchar* upnp_class)
{
	return rygel_image_item_construct (RYGEL_TYPE_IMAGE_ITEM, id, parent, title, upnp_class);
}

static void
rygel_image_item_real_constructed (GObject* base)
{
	RygelImageItem * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self = (RygelImageItem*) base;
	G_OBJECT_CLASS (rygel_image_item_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem));
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_icon_info_ref, (GDestroyNotify) rygel_icon_info_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
rygel_image_item_real_add_uri (RygelMediaObject* base,
                               const gchar* uri)
{
	RygelImageItem * self;
	self = (RygelImageItem*) base;
	g_return_if_fail (uri != NULL);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_image_item_parent_class)->add_uri ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem), uri);
	rygel_visual_item_add_thumbnail_for_uri ((RygelVisualItem*) self, uri);
}

static RygelMediaResource*
rygel_image_item_real_get_primary_resource (RygelMediaFileItem* base)
{
	RygelImageItem * self;
	RygelMediaResource* res = NULL;
	RygelMediaResource* _tmp0_;
	GUPnPDLNAFlags _tmp1_;
	GUPnPDLNAFlags _tmp2_;
	RygelMediaResource* result;
	self = (RygelImageItem*) base;
	_tmp0_ = RYGEL_MEDIA_FILE_ITEM_CLASS (rygel_image_item_parent_class)->get_primary_resource (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem));
	res = _tmp0_;
	rygel_visual_item_set_visual_resource_properties ((RygelVisualItem*) self, res);
	_tmp1_ = rygel_media_resource_get_dlna_flags (res);
	_tmp2_ = _tmp1_;
	rygel_media_resource_set_dlna_flags (res, _tmp2_ | GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
	result = res;
	return result;
}

static void
rygel_image_item_real_add_additional_resources (RygelMediaFileItem* base,
                                                RygelHTTPServer* server)
{
	RygelImageItem * self;
	self = (RygelImageItem*) base;
	g_return_if_fail (server != NULL);
	RYGEL_MEDIA_FILE_ITEM_CLASS (rygel_image_item_parent_class)->add_additional_resources (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem), server);
	rygel_visual_item_add_thumbnail_resources ((RygelVisualItem*) self, server);
}

static gint
rygel_image_item_real_get_width (RygelVisualItem* base)
{
	gint result;
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	result = self->priv->_width;
	return result;
}

static void
rygel_image_item_real_set_width (RygelVisualItem* base,
                                 gint value)
{
	RygelImageItem* self;
	gint old_value;
	self = (RygelImageItem*) base;
	old_value = rygel_image_item_real_get_width (base);
	if (old_value != value) {
		self->priv->_width = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_image_item_properties[RYGEL_IMAGE_ITEM_WIDTH_PROPERTY]);
	}
}

static gint
rygel_image_item_real_get_height (RygelVisualItem* base)
{
	gint result;
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	result = self->priv->_height;
	return result;
}

static void
rygel_image_item_real_set_height (RygelVisualItem* base,
                                  gint value)
{
	RygelImageItem* self;
	gint old_value;
	self = (RygelImageItem*) base;
	old_value = rygel_image_item_real_get_height (base);
	if (old_value != value) {
		self->priv->_height = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_image_item_properties[RYGEL_IMAGE_ITEM_HEIGHT_PROPERTY]);
	}
}

static gint
rygel_image_item_real_get_color_depth (RygelVisualItem* base)
{
	gint result;
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	result = self->priv->_color_depth;
	return result;
}

static void
rygel_image_item_real_set_color_depth (RygelVisualItem* base,
                                       gint value)
{
	RygelImageItem* self;
	gint old_value;
	self = (RygelImageItem*) base;
	old_value = rygel_image_item_real_get_color_depth (base);
	if (old_value != value) {
		self->priv->_color_depth = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_image_item_properties[RYGEL_IMAGE_ITEM_COLOR_DEPTH_PROPERTY]);
	}
}

static GeeArrayList*
rygel_image_item_real_get_thumbnails (RygelVisualItem* base)
{
	GeeArrayList* result;
	RygelImageItem* self;
	GeeArrayList* _tmp0_;
	self = (RygelImageItem*) base;
	_tmp0_ = self->priv->_thumbnails;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_image_item_real_set_thumbnails (RygelVisualItem* base,
                                      GeeArrayList* value)
{
	RygelImageItem* self;
	GeeArrayList* old_value;
	self = (RygelImageItem*) base;
	old_value = rygel_image_item_real_get_thumbnails (base);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_thumbnails);
		self->priv->_thumbnails = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_image_item_properties[RYGEL_IMAGE_ITEM_THUMBNAILS_PROPERTY]);
	}
}

static void
rygel_image_item_class_init (RygelImageItemClass * klass,
                             gpointer klass_data)
{
	rygel_image_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelImageItem_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_image_item_real_constructed;
	((RygelMediaObjectClass *) klass)->add_uri = (void (*) (RygelMediaObject*, const gchar*)) rygel_image_item_real_add_uri;
	((RygelMediaFileItemClass *) klass)->get_primary_resource = (RygelMediaResource* (*) (RygelMediaFileItem*)) rygel_image_item_real_get_primary_resource;
	((RygelMediaFileItemClass *) klass)->add_additional_resources = (void (*) (RygelMediaFileItem*, RygelHTTPServer*)) rygel_image_item_real_add_additional_resources;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_image_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_image_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_image_item_finalize;
	/**
	     * The width of the image in pixels.
	     * A value of -1 means that the width is unknown and will not, or did not,
	     * appear in DIDL-Lite XML.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_WIDTH_PROPERTY, rygel_image_item_properties[RYGEL_IMAGE_ITEM_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The height of the image in pixels.
	     * A value of -1 means that the height is unknown and will not, or did not,
	     * appear in DIDL-Lite XML.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_HEIGHT_PROPERTY, rygel_image_item_properties[RYGEL_IMAGE_ITEM_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     *The number of bits per pixel used to represent the image resource.
	     * A value of -1 means that the color depth is unknown and will not, or did
	     * not, appear in DIDL-Lite XML.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_COLOR_DEPTH_PROPERTY, rygel_image_item_properties[RYGEL_IMAGE_ITEM_COLOR_DEPTH_PROPERTY] = g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Thumbnail pictures to represent the image.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_THUMBNAILS_PROPERTY, rygel_image_item_properties[RYGEL_IMAGE_ITEM_THUMBNAILS_PROPERTY] = g_param_spec_object ("thumbnails", "thumbnails", "thumbnails", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_image_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface,
                                                   gpointer iface_data)
{
	rygel_image_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_width = rygel_image_item_real_get_width;
	iface->set_width = rygel_image_item_real_set_width;
	iface->get_height = rygel_image_item_real_get_height;
	iface->set_height = rygel_image_item_real_set_height;
	iface->get_color_depth = rygel_image_item_real_get_color_depth;
	iface->set_color_depth = rygel_image_item_real_set_color_depth;
	iface->get_thumbnails = rygel_image_item_real_get_thumbnails;
	iface->set_thumbnails = rygel_image_item_real_set_thumbnails;
}

static void
rygel_image_item_instance_init (RygelImageItem * self,
                                gpointer klass)
{
	self->priv = rygel_image_item_get_instance_private (self);
	self->priv->_width = -1;
	self->priv->_height = -1;
	self->priv->_color_depth = -1;
}

static void
rygel_image_item_finalize (GObject * obj)
{
	RygelImageItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_IMAGE_ITEM, RygelImageItem);
	_g_object_unref0 (self->priv->_thumbnails);
	G_OBJECT_CLASS (rygel_image_item_parent_class)->finalize (obj);
}

/**
 * Represents an image item.
 */
 G_GNUC_NO_INLINE static GType
rygel_image_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelImageItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_image_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelImageItem), 0, (GInstanceInitFunc) rygel_image_item_instance_init, NULL };
	static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_image_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_image_item_type_id;
	rygel_image_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_FILE_ITEM, "RygelImageItem", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_image_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
	RygelImageItem_private_offset = g_type_add_instance_private (rygel_image_item_type_id, sizeof (RygelImageItemPrivate));
	return rygel_image_item_type_id;
}

GType
rygel_image_item_get_type (void)
{
	static volatile gsize rygel_image_item_type_id__once = 0;
	if (g_once_init_enter (&rygel_image_item_type_id__once)) {
		GType rygel_image_item_type_id;
		rygel_image_item_type_id = rygel_image_item_get_type_once ();
		g_once_init_leave (&rygel_image_item_type_id__once, rygel_image_item_type_id);
	}
	return rygel_image_item_type_id__once;
}

static void
_vala_rygel_image_item_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	RygelImageItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_IMAGE_ITEM, RygelImageItem);
	switch (property_id) {
		case RYGEL_IMAGE_ITEM_WIDTH_PROPERTY:
		g_value_set_int (value, rygel_visual_item_get_width ((RygelVisualItem*) self));
		break;
		case RYGEL_IMAGE_ITEM_HEIGHT_PROPERTY:
		g_value_set_int (value, rygel_visual_item_get_height ((RygelVisualItem*) self));
		break;
		case RYGEL_IMAGE_ITEM_COLOR_DEPTH_PROPERTY:
		g_value_set_int (value, rygel_visual_item_get_color_depth ((RygelVisualItem*) self));
		break;
		case RYGEL_IMAGE_ITEM_THUMBNAILS_PROPERTY:
		g_value_set_object (value, rygel_visual_item_get_thumbnails ((RygelVisualItem*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_image_item_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	RygelImageItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_IMAGE_ITEM, RygelImageItem);
	switch (property_id) {
		case RYGEL_IMAGE_ITEM_WIDTH_PROPERTY:
		rygel_visual_item_set_width ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_IMAGE_ITEM_HEIGHT_PROPERTY:
		rygel_visual_item_set_height ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_IMAGE_ITEM_COLOR_DEPTH_PROPERTY:
		rygel_visual_item_set_color_depth ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_IMAGE_ITEM_THUMBNAILS_PROPERTY:
		rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

