/* rygel-log-handler.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-log-handler.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-core.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

#define RYGEL_LOG_HANDLER_DEFAULT_LEVELS "*:4"
#define RYGEL_LOG_HANDLER_DEFAULT_FLAGS ((((G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR) | G_LOG_LEVEL_MESSAGE) | G_LOG_LEVEL_INFO)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_LOG_HANDLER_0_PROPERTY,
	RYGEL_LOG_HANDLER_NUM_PROPERTIES
};
static GParamSpec* rygel_log_handler_properties[RYGEL_LOG_HANDLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelLogHandlerPrivate {
	GeeHashMap* log_level_hash;
};

static gint RygelLogHandler_private_offset;
static gpointer rygel_log_handler_parent_class = NULL;
static RygelLogHandler* rygel_log_handler_log_handler;
static RygelLogHandler* rygel_log_handler_log_handler = NULL;

static RygelLogHandler* rygel_log_handler_new (void);
static RygelLogHandler* rygel_log_handler_construct (GType object_type);
static GLogLevelFlags rygel_log_handler_log_level_to_flags (RygelLogHandler* self,
                                                     RygelLogLevel level);
static void rygel_log_handler_log_func (RygelLogHandler* self,
                                 const gchar* log_domain,
                                 GLogLevelFlags log_levels,
                                 const gchar* message);
static void _rygel_log_handler_log_func_glog_func (const gchar* log_domain,
                                            GLogLevelFlags log_levels,
                                            const gchar* message,
                                            gpointer self);
static void rygel_log_handler_finalize (GObject * obj);
static GType rygel_log_handler_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

 G_GNUC_NO_INLINE static GType
rygel_log_level_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_LOG_LEVEL_INVALID, "RYGEL_LOG_LEVEL_INVALID", "invalid"}, {RYGEL_LOG_LEVEL_ERROR, "RYGEL_LOG_LEVEL_ERROR", "error"}, {RYGEL_LOG_LEVEL_CRITICAL, "RYGEL_LOG_LEVEL_CRITICAL", "critical"}, {RYGEL_LOG_LEVEL_WARNING, "RYGEL_LOG_LEVEL_WARNING", "warning"}, {RYGEL_LOG_LEVEL_INFO, "RYGEL_LOG_LEVEL_INFO", "info"}, {RYGEL_LOG_LEVEL_DEFAULT, "RYGEL_LOG_LEVEL_DEFAULT", "default"}, {RYGEL_LOG_LEVEL_DEBUG, "RYGEL_LOG_LEVEL_DEBUG", "debug"}, {0, NULL, NULL}};
	GType rygel_log_level_type_id;
	rygel_log_level_type_id = g_enum_register_static ("RygelLogLevel", values);
	return rygel_log_level_type_id;
}

GType
rygel_log_level_get_type (void)
{
	static volatile gsize rygel_log_level_type_id__once = 0;
	if (g_once_init_enter (&rygel_log_level_type_id__once)) {
		GType rygel_log_level_type_id;
		rygel_log_level_type_id = rygel_log_level_get_type_once ();
		g_once_init_leave (&rygel_log_level_type_id__once, rygel_log_level_type_id);
	}
	return rygel_log_level_type_id__once;
}

static inline gpointer
rygel_log_handler_get_instance_private (RygelLogHandler* self)
{
	return G_STRUCT_MEMBER_P (self, RygelLogHandler_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelLogHandler*
rygel_log_handler_get_default (void)
{
	RygelLogHandler* _tmp0_;
	RygelLogHandler* _tmp2_;
	RygelLogHandler* _tmp3_;
	RygelLogHandler* result;
	_tmp0_ = rygel_log_handler_log_handler;
	if (_tmp0_ == NULL) {
		RygelLogHandler* _tmp1_;
		_tmp1_ = rygel_log_handler_new ();
		_g_object_unref0 (rygel_log_handler_log_handler);
		rygel_log_handler_log_handler = _tmp1_;
	}
	_tmp2_ = rygel_log_handler_log_handler;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
_rygel_log_handler_log_func_glog_func (const gchar* log_domain,
                                       GLogLevelFlags log_levels,
                                       const gchar* message,
                                       gpointer self)
{
	rygel_log_handler_log_func ((RygelLogHandler*) self, log_domain, log_levels, message);
}

static RygelLogHandler*
rygel_log_handler_construct (GType object_type)
{
	RygelLogHandler * self = NULL;
	GeeHashMap* _tmp0_;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp1_;
	gchar* log_levels = NULL;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	GError* _inner_error0_ = NULL;
	self = (RygelLogHandler*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->log_level_hash);
	self->priv->log_level_hash = _tmp0_;
	_tmp1_ = rygel_meta_config_get_default ();
	config = _tmp1_;
	{
		gchar* _tmp2_ = NULL;
		RygelMetaConfig* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = config;
		_tmp4_ = rygel_configuration_get_log_levels ((RygelConfiguration*) _tmp3_, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_free0 (log_levels);
		log_levels = _tmp5_;
		_g_free0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = g_strdup (RYGEL_LOG_HANDLER_DEFAULT_LEVELS);
		_g_free0 (log_levels);
		log_levels = _tmp6_;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		g_warning (_ ("Failed to get log level from configuration: %s"), _tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (log_levels);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp9_ = log_levels;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, ",", 0);
	{
		gchar** pair_collection = NULL;
		gint pair_collection_length1 = 0;
		gint _pair_collection_size_ = 0;
		gint pair_it = 0;
		pair_collection = _tmp11_;
		pair_collection_length1 = _vala_array_length (_tmp10_);
		for (pair_it = 0; pair_it < pair_collection_length1; pair_it = pair_it + 1) {
			gchar* _tmp12_;
			gchar* pair = NULL;
			_tmp12_ = g_strdup (pair_collection[pair_it]);
			pair = _tmp12_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp13_;
				gchar** _tmp14_;
				gchar** _tmp15_;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				gchar* domain = NULL;
				RygelLogLevel level = 0;
				gchar** _tmp17_;
				gint _tmp17__length1;
				GLogLevelFlags flags = 0U;
				GeeHashMap* _tmp26_;
				const gchar* _tmp27_;
				_tmp13_ = pair;
				_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, ":", 0);
				tokens = _tmp15_;
				tokens_length1 = _vala_array_length (_tmp14_);
				_tokens_size_ = tokens_length1;
				_tmp16_ = tokens;
				_tmp16__length1 = tokens_length1;
				if (_tmp16__length1 < 1) {
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (pair);
					break;
				}
				_tmp17_ = tokens;
				_tmp17__length1 = tokens_length1;
				if (_tmp17__length1 == 1) {
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp18_ = tokens;
					_tmp18__length1 = tokens_length1;
					_tmp19_ = _tmp18_[0];
					level = (RygelLogLevel) atoi (_tmp19_);
					_tmp20_ = g_strdup ("*");
					_g_free0 (domain);
					domain = _tmp20_;
				} else {
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar** _tmp24_;
					gint _tmp24__length1;
					const gchar* _tmp25_;
					_tmp21_ = tokens;
					_tmp21__length1 = tokens_length1;
					_tmp22_ = _tmp21_[0];
					_tmp23_ = g_strdup (_tmp22_);
					_g_free0 (domain);
					domain = _tmp23_;
					_tmp24_ = tokens;
					_tmp24__length1 = tokens_length1;
					_tmp25_ = _tmp24_[1];
					level = (RygelLogLevel) atoi (_tmp25_);
				}
				flags = rygel_log_handler_log_level_to_flags (self, level);
				_tmp26_ = self->priv->log_level_hash;
				_tmp27_ = domain;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, _tmp27_, (gpointer) ((gintptr) flags));
				_g_free0 (domain);
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (pair);
			}
		}
		pair_collection = (_vala_array_free (pair_collection, pair_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	g_log_set_default_handler (_rygel_log_handler_log_func_glog_func, self);
	_g_free0 (log_levels);
	_g_object_unref0 (config);
	return self;
}

static RygelLogHandler*
rygel_log_handler_new (void)
{
	return rygel_log_handler_construct (RYGEL_TYPE_LOG_HANDLER);
}

static void
rygel_log_handler_log_func (RygelLogHandler* self,
                            const gchar* log_domain,
                            GLogLevelFlags log_levels,
                            const gchar* message)
{
	GLogLevelFlags flags = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	flags = 0;
	if (log_domain != NULL) {
		GeeHashMap* _tmp0_;
		gpointer _tmp1_;
		_tmp0_ = self->priv->log_level_hash;
		_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, log_domain);
		flags = (GLogLevelFlags) ((gintptr) _tmp1_);
	}
	if (flags == 0) {
		GeeHashMap* _tmp2_;
		gpointer _tmp3_;
		_tmp2_ = self->priv->log_level_hash;
		_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, "*");
		flags = (GLogLevelFlags) ((gintptr) _tmp3_);
	}
	if ((flags & log_levels) == log_levels) {
		GLogFunc _tmp4_;
		gpointer _tmp4__target;
		_tmp4_ = g_log_default_handler;
		_tmp4__target = NULL;
		_tmp4_ (log_domain, log_levels, message, _tmp4__target);
	}
}

static GLogLevelFlags
rygel_log_handler_log_level_to_flags (RygelLogHandler* self,
                                      RygelLogLevel level)
{
	GLogLevelFlags flags = 0U;
	GLogLevelFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	flags = RYGEL_LOG_HANDLER_DEFAULT_FLAGS;
	switch (level) {
		case RYGEL_LOG_LEVEL_ERROR:
		{
			flags = G_LOG_LEVEL_ERROR;
			break;
		}
		case RYGEL_LOG_LEVEL_CRITICAL:
		{
			flags = G_LOG_LEVEL_CRITICAL | G_LOG_LEVEL_ERROR;
			break;
		}
		case RYGEL_LOG_LEVEL_WARNING:
		{
			flags = (G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR;
			break;
		}
		case RYGEL_LOG_LEVEL_INFO:
		{
			flags = (((G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR) | G_LOG_LEVEL_MESSAGE) | G_LOG_LEVEL_INFO;
			break;
		}
		case RYGEL_LOG_LEVEL_DEBUG:
		{
			flags = ((((G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR) | G_LOG_LEVEL_MESSAGE) | G_LOG_LEVEL_INFO) | G_LOG_LEVEL_DEBUG;
			break;
		}
		default:
		{
			flags = RYGEL_LOG_HANDLER_DEFAULT_FLAGS;
			break;
		}
	}
	result = flags;
	return result;
}

static void
rygel_log_handler_class_init (RygelLogHandlerClass * klass,
                              gpointer klass_data)
{
	rygel_log_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelLogHandler_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rygel_log_handler_finalize;
}

static void
rygel_log_handler_instance_init (RygelLogHandler * self,
                                 gpointer klass)
{
	self->priv = rygel_log_handler_get_instance_private (self);
}

static void
rygel_log_handler_finalize (GObject * obj)
{
	RygelLogHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_LOG_HANDLER, RygelLogHandler);
	_g_object_unref0 (self->priv->log_level_hash);
	G_OBJECT_CLASS (rygel_log_handler_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_log_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLogHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_log_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLogHandler), 0, (GInstanceInitFunc) rygel_log_handler_instance_init, NULL };
	GType rygel_log_handler_type_id;
	rygel_log_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelLogHandler", &g_define_type_info, 0);
	RygelLogHandler_private_offset = g_type_add_instance_private (rygel_log_handler_type_id, sizeof (RygelLogHandlerPrivate));
	return rygel_log_handler_type_id;
}

GType
rygel_log_handler_get_type (void)
{
	static volatile gsize rygel_log_handler_type_id__once = 0;
	if (g_once_init_enter (&rygel_log_handler_type_id__once)) {
		GType rygel_log_handler_type_id;
		rygel_log_handler_type_id = rygel_log_handler_get_type_once ();
		g_once_init_leave (&rygel_log_handler_type_id__once, rygel_log_handler_type_id);
	}
	return rygel_log_handler_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

