// third_party/blink/public/mojom/widget/device_emulation_params.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* EmulatedScreenTypeToStringHelper(EmulatedScreenType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EmulatedScreenType::kDesktop:
      return "kDesktop";
    case EmulatedScreenType::kMobile:
      return "kMobile";
    default:
      return nullptr;
  }
}

std::string EmulatedScreenTypeToString(EmulatedScreenType value) {
  const char *str = EmulatedScreenTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EmulatedScreenType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EmulatedScreenType value) {
  return os << EmulatedScreenTypeToString(value);
}

namespace internal {


// static
bool DeviceEmulationParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceEmulationParams_Data* object =
      static_cast<const DeviceEmulationParams_Data*>(data);


  if (!::blink::mojom::internal::EmulatedScreenType_Data
        ::Validate(object->screen_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->screen_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->screen_size, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->view_position, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->view_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->view_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->viewport_offset, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->viewport_offset, validation_context))
    return false;


  if (!::display::mojom::internal::ScreenOrientation_Data
        ::Validate(object->screen_orientation_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->viewport_segments, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& viewport_segments_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->viewport_segments, validation_context,
                                         &viewport_segments_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::DevicePostureType_Data
        ::Validate(object->device_posture, validation_context))
    return false;

  return true;
}

DeviceEmulationParams_Data::DeviceEmulationParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::EmulatedScreenType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::EmulatedScreenType value) {
  return std::move(context).WriteString(::blink::mojom::EmulatedScreenTypeToString(value));
}

} // namespace perfetto