// third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* ScrollAlignment_BehaviorToStringHelper(ScrollAlignment_Behavior value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ScrollAlignment_Behavior::kNoScroll:
      return "kNoScroll";
    case ScrollAlignment_Behavior::kCenter:
      return "kCenter";
    case ScrollAlignment_Behavior::kTop:
      return "kTop";
    case ScrollAlignment_Behavior::kBottom:
      return "kBottom";
    case ScrollAlignment_Behavior::kLeft:
      return "kLeft";
    case ScrollAlignment_Behavior::kRight:
      return "kRight";
    case ScrollAlignment_Behavior::kClosestEdge:
      return "kClosestEdge";
    default:
      return nullptr;
  }
}

std::string ScrollAlignment_BehaviorToString(ScrollAlignment_Behavior value) {
  const char *str = ScrollAlignment_BehaviorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ScrollAlignment_Behavior value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ScrollAlignment_Behavior value) {
  return os << ScrollAlignment_BehaviorToString(value);
}

namespace internal {


// static
bool ScrollAlignment_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollAlignment_Data* object =
      static_cast<const ScrollAlignment_Data*>(data);


  if (!::blink::mojom::internal::ScrollAlignment_Behavior_Data
        ::Validate(object->rect_visible, validation_context))
    return false;


  if (!::blink::mojom::internal::ScrollAlignment_Behavior_Data
        ::Validate(object->rect_hidden, validation_context))
    return false;


  if (!::blink::mojom::internal::ScrollAlignment_Behavior_Data
        ::Validate(object->rect_partial, validation_context))
    return false;

  return true;
}

ScrollAlignment_Data::ScrollAlignment_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FocusedEditableParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FocusedEditableParams_Data* object =
      static_cast<const FocusedEditableParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relative_location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  return true;
}

FocusedEditableParams_Data::FocusedEditableParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollIntoViewParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollIntoViewParams_Data* object =
      static_cast<const ScrollIntoViewParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->align_x, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->align_x, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->align_y, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->align_y, validation_context))
    return false;


  if (!::blink::mojom::internal::ScrollType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::blink::mojom::internal::ScrollBehavior_Data
        ::Validate(object->behavior, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->for_focused_editable, validation_context))
    return false;

  return true;
}

ScrollIntoViewParams_Data::ScrollIntoViewParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ScrollAlignment_Behavior>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ScrollAlignment_Behavior value) {
  return std::move(context).WriteString(::blink::mojom::ScrollAlignment_BehaviorToString(value));
}

} // namespace perfetto