// third_party/blink/public/mojom/link_to_text/link_to_text.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* LinkGenerationReadyStatusToStringHelper(LinkGenerationReadyStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LinkGenerationReadyStatus::kRequestedBeforeReady:
      return "kRequestedBeforeReady";
    case LinkGenerationReadyStatus::kRequestedAfterReady:
      return "kRequestedAfterReady";
    default:
      return nullptr;
  }
}

std::string LinkGenerationReadyStatusToString(LinkGenerationReadyStatus value) {
  const char *str = LinkGenerationReadyStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LinkGenerationReadyStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LinkGenerationReadyStatus value) {
  return os << LinkGenerationReadyStatusToString(value);
}

NOINLINE static const char* LinkGenerationErrorToStringHelper(LinkGenerationError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LinkGenerationError::kNone:
      return "kNone";
    case LinkGenerationError::kIncorrectSelector:
      return "kIncorrectSelector";
    case LinkGenerationError::kNoRange:
      return "kNoRange";
    case LinkGenerationError::kNoContext:
      return "kNoContext";
    case LinkGenerationError::kContextExhausted:
      return "kContextExhausted";
    case LinkGenerationError::kContextLimitReached:
      return "kContextLimitReached";
    case LinkGenerationError::kEmptySelection:
      return "kEmptySelection";
    case LinkGenerationError::kTabHidden:
      return "kTabHidden";
    case LinkGenerationError::kOmniboxNavigation:
      return "kOmniboxNavigation";
    case LinkGenerationError::kTabCrash:
      return "kTabCrash";
    case LinkGenerationError::kUnknown:
      return "kUnknown";
    case LinkGenerationError::kIFrame:
      return "kIFrame";
    case LinkGenerationError::kTimeout:
      return "kTimeout";
    case LinkGenerationError::kBlockList:
      return "kBlockList";
    case LinkGenerationError::kNoRemoteConnection:
      return "kNoRemoteConnection";
    case LinkGenerationError::kNotGenerated:
      return "kNotGenerated";
    default:
      return nullptr;
  }
}

std::string LinkGenerationErrorToString(LinkGenerationError value) {
  const char *str = LinkGenerationErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LinkGenerationError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LinkGenerationError value) {
  return os << LinkGenerationErrorToString(value);
}

namespace internal {


// static
bool TextFragmentReceiver_Cancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextFragmentReceiver_Cancel_Params_Data* object =
      static_cast<const TextFragmentReceiver_Cancel_Params_Data*>(data);

  return true;
}

TextFragmentReceiver_Cancel_Params_Data::TextFragmentReceiver_Cancel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextFragmentReceiver_RequestSelector_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextFragmentReceiver_RequestSelector_Params_Data* object =
      static_cast<const TextFragmentReceiver_RequestSelector_Params_Data*>(data);

  return true;
}

TextFragmentReceiver_RequestSelector_Params_Data::TextFragmentReceiver_RequestSelector_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextFragmentReceiver_RequestSelector_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextFragmentReceiver_RequestSelector_ResponseParams_Data* object =
      static_cast<const TextFragmentReceiver_RequestSelector_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selector, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& selector_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->selector, validation_context,
                                         &selector_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::LinkGenerationError_Data
        ::Validate(object->error, validation_context))
    return false;


  if (!::blink::mojom::internal::LinkGenerationReadyStatus_Data
        ::Validate(object->ready_status, validation_context))
    return false;

  return true;
}

TextFragmentReceiver_RequestSelector_ResponseParams_Data::TextFragmentReceiver_RequestSelector_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextFragmentReceiver_RemoveFragments_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextFragmentReceiver_RemoveFragments_Params_Data* object =
      static_cast<const TextFragmentReceiver_RemoveFragments_Params_Data*>(data);

  return true;
}

TextFragmentReceiver_RemoveFragments_Params_Data::TextFragmentReceiver_RemoveFragments_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextFragmentReceiver_ExtractTextFragmentsMatches_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextFragmentReceiver_ExtractTextFragmentsMatches_Params_Data* object =
      static_cast<const TextFragmentReceiver_ExtractTextFragmentsMatches_Params_Data*>(data);

  return true;
}

TextFragmentReceiver_ExtractTextFragmentsMatches_Params_Data::TextFragmentReceiver_ExtractTextFragmentsMatches_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams_Data* object =
      static_cast<const TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams_Data::TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextFragmentReceiver_GetExistingSelectors_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextFragmentReceiver_GetExistingSelectors_Params_Data* object =
      static_cast<const TextFragmentReceiver_GetExistingSelectors_Params_Data*>(data);

  return true;
}

TextFragmentReceiver_GetExistingSelectors_Params_Data::TextFragmentReceiver_GetExistingSelectors_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextFragmentReceiver_GetExistingSelectors_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextFragmentReceiver_GetExistingSelectors_ResponseParams_Data* object =
      static_cast<const TextFragmentReceiver_GetExistingSelectors_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selectors, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& selectors_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->selectors, validation_context,
                                         &selectors_validate_params)) {
    return false;
  }

  return true;
}

TextFragmentReceiver_GetExistingSelectors_ResponseParams_Data::TextFragmentReceiver_GetExistingSelectors_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextFragmentReceiver_ExtractFirstFragmentRect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextFragmentReceiver_ExtractFirstFragmentRect_Params_Data* object =
      static_cast<const TextFragmentReceiver_ExtractFirstFragmentRect_Params_Data*>(data);

  return true;
}

TextFragmentReceiver_ExtractFirstFragmentRect_Params_Data::TextFragmentReceiver_ExtractFirstFragmentRect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams_Data* object =
      static_cast<const TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams_Data::TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::LinkGenerationReadyStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::LinkGenerationReadyStatus value) {
  return std::move(context).WriteString(::blink::mojom::LinkGenerationReadyStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::LinkGenerationError>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::LinkGenerationError value) {
  return std::move(context).WriteString(::blink::mojom::LinkGenerationErrorToString(value));
}

} // namespace perfetto