// storage/browser/quota/quota_manager_observer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef STORAGE_BROWSER_QUOTA_QUOTA_MANAGER_OBSERVER_MOJOM_H_
#define STORAGE_BROWSER_QUOTA_QUOTA_MANAGER_OBSERVER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "storage/browser/quota/quota_manager_observer.mojom-features.h"  // IWYU pragma: export
#include "storage/browser/quota/quota_manager_observer.mojom-shared.h"  // IWYU pragma: export
#include "storage/browser/quota/quota_manager_observer.mojom-forward.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/buckets/bucket_info.mojom.h"
#include "components/services/storage/public/mojom/buckets/bucket_locator.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"




namespace storage::mojom {

class QuotaManagerObserverProxy;

template <typename ImplRefTraits>
class QuotaManagerObserverStub;

class QuotaManagerObserverRequestValidator;


class COMPONENT_EXPORT(STORAGE_BROWSER_INTERFACES) QuotaManagerObserver
    : public QuotaManagerObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = QuotaManagerObserverInterfaceBase;
  using Proxy_ = QuotaManagerObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = QuotaManagerObserverStub<ImplRefTraits>;

  using RequestValidator_ = QuotaManagerObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCreateOrUpdateBucketMinVersion = 0,
    kOnDeleteBucketMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnCreateOrUpdateBucket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDeleteBucket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~QuotaManagerObserver() = default;

  
  virtual void OnCreateOrUpdateBucket(const ::storage::BucketInfo& bucket_info) = 0;

  
  virtual void OnDeleteBucket(const ::storage::BucketLocator& bucket_locator) = 0;
};



class COMPONENT_EXPORT(STORAGE_BROWSER_INTERFACES) QuotaManagerObserverProxy
    : public QuotaManagerObserver {
 public:
  using InterfaceType = QuotaManagerObserver;

  explicit QuotaManagerObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnCreateOrUpdateBucket(const ::storage::BucketInfo& bucket_info) final;
  
  void OnDeleteBucket(const ::storage::BucketLocator& bucket_locator) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(STORAGE_BROWSER_INTERFACES) QuotaManagerObserverStubDispatch {
 public:
  static bool Accept(QuotaManagerObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      QuotaManagerObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<QuotaManagerObserver>>
class QuotaManagerObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  QuotaManagerObserverStub() = default;
  ~QuotaManagerObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuotaManagerObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuotaManagerObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(STORAGE_BROWSER_INTERFACES) QuotaManagerObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // storage::mojom

namespace mojo {

}  // namespace mojo

#endif  // STORAGE_BROWSER_QUOTA_QUOTA_MANAGER_OBSERVER_MOJOM_H_