// services/viz/public/mojom/compositing/returned_resource.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_RETURNED_RESOURCE_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_RETURNED_RESOURCE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/returned_resource.mojom-shared-internal.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-shared.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace viz::mojom {
class ReturnedResourceDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::ReturnedResourceDataView> {
  using Data = ::viz::mojom::internal::ReturnedResource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class ReturnedResourceDataView {
 public:
  ReturnedResourceDataView() = default;

  ReturnedResourceDataView(
      internal::ReturnedResource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::viz::mojom::ResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::viz::mojom::ResourceIdDataView>(
        pointer, output, message_);
  }
  inline void GetSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncToken(UserType* output) {
    
    auto* pointer = data_->sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  inline void GetReleaseFenceDataView(
      ::gfx::mojom::GpuFenceHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReleaseFence(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::GpuFenceHandleDataView, UserType>(),
    "Attempting to read the optional `release_fence` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReleaseFence` instead "
    "of `ReadReleaseFence if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->release_fence.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuFenceHandleDataView>(
        pointer, output, message_);
  }
  int32_t count() const {
    return data_->count;
  }
  bool lost() const {
    return data_->lost;
  }
 private:
  internal::ReturnedResource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::ReturnedResourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::ReturnedResourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::ReturnedResource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::ResourceIdDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in ReturnedResource struct");
    decltype(Traits::sync_token(input)) in_sync_token = Traits::sync_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sync_token)::BaseType> sync_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
        in_sync_token, sync_token_fragment);
    fragment->sync_token.Set(
        sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sync_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sync_token in ReturnedResource struct");
    decltype(Traits::release_fence(input)) in_release_fence = Traits::release_fence(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->release_fence)::BaseType> release_fence_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::GpuFenceHandleDataView>(
        in_release_fence, release_fence_fragment);
    fragment->release_fence.Set(
        release_fence_fragment.is_null() ? nullptr : release_fence_fragment.data());
    fragment->count = Traits::count(input);
    fragment->lost = Traits::lost(input);
  }

  static bool Deserialize(::viz::mojom::internal::ReturnedResource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::ReturnedResourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void ReturnedResourceDataView::GetIdDataView(
    ::viz::mojom::ResourceIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::viz::mojom::ResourceIdDataView(pointer, message_);
}
inline void ReturnedResourceDataView::GetSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}
inline void ReturnedResourceDataView::GetReleaseFenceDataView(
    ::gfx::mojom::GpuFenceHandleDataView* output) {
  auto pointer = data_->release_fence.Get();
  *output = ::gfx::mojom::GpuFenceHandleDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_RETURNED_RESOURCE_MOJOM_SHARED_H_