// services/network/public/mojom/proxy_config.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/proxy_config.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_string.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class ProxyBypassRulesDataView;

class ProxyListDataView;

class ProxyRulesDataView;

class ProxyConfigDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ProxyBypassRulesDataView> {
  using Data = ::network::mojom::internal::ProxyBypassRules_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ProxyListDataView> {
  using Data = ::network::mojom::internal::ProxyList_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ProxyRulesDataView> {
  using Data = ::network::mojom::internal::ProxyRules_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ProxyConfigDataView> {
  using Data = ::network::mojom::internal::ProxyConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class ProxyRulesType : int32_t {
  
  EMPTY = 0,
  
  PROXY_LIST = 1,
  
  PROXY_LIST_PER_SCHEME = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ProxyRulesType value);
inline bool IsKnownEnumValue(ProxyRulesType value) {
  return internal::ProxyRulesType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IpProtectionProxyBypassPolicy : int32_t {
  
  kNone = 0,
  
  kFirstPartyToTopLevelFrame = 1,
  
  kExclusionList = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, IpProtectionProxyBypassPolicy value);
inline bool IsKnownEnumValue(IpProtectionProxyBypassPolicy value) {
  return internal::IpProtectionProxyBypassPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ProxyBypassRulesDataView {
 public:
  ProxyBypassRulesDataView() = default;

  ProxyBypassRulesDataView(
      internal::ProxyBypassRules_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRulesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRules(UserType* output) {
    
    auto* pointer = data_->rules.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ProxyBypassRules_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProxyListDataView {
 public:
  ProxyListDataView() = default;

  ProxyListDataView(
      internal::ProxyList_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProxiesDataView(
      mojo::ArrayDataView<::network::mojom::ProxyChainDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxies(UserType* output) {
    
    auto* pointer = data_->proxies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ProxyChainDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ProxyList_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProxyRulesDataView {
 public:
  ProxyRulesDataView() = default;

  ProxyRulesDataView(
      internal::ProxyRules_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBypassRulesDataView(
      ProxyBypassRulesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBypassRules(UserType* output) {
    
    auto* pointer = data_->bypass_rules.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyBypassRulesDataView>(
        pointer, output, message_);
  }
  bool reverse_bypass() const {
    return data_->reverse_bypass;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::ProxyRulesType>(
        data_value, output);
  }
  ProxyRulesType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ProxyRulesType>(data_->type));
  }
  inline void GetSingleProxiesDataView(
      ProxyListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSingleProxies(UserType* output) {
    
    auto* pointer = data_->single_proxies.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyListDataView>(
        pointer, output, message_);
  }
  inline void GetProxiesForHttpDataView(
      ProxyListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxiesForHttp(UserType* output) {
    
    auto* pointer = data_->proxies_for_http.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyListDataView>(
        pointer, output, message_);
  }
  inline void GetProxiesForHttpsDataView(
      ProxyListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxiesForHttps(UserType* output) {
    
    auto* pointer = data_->proxies_for_https.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyListDataView>(
        pointer, output, message_);
  }
  inline void GetProxiesForFtpDataView(
      ProxyListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxiesForFtp(UserType* output) {
    
    auto* pointer = data_->proxies_for_ftp.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyListDataView>(
        pointer, output, message_);
  }
  inline void GetFallbackProxiesDataView(
      ProxyListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFallbackProxies(UserType* output) {
    
    auto* pointer = data_->fallback_proxies.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyListDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProxyRules_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProxyConfigDataView {
 public:
  ProxyConfigDataView() = default;

  ProxyConfigDataView(
      internal::ProxyConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool auto_detect() const {
    return data_->auto_detect;
  }
  bool from_system() const {
    return data_->from_system;
  }
  inline void GetPacUrlDataView(
      ::mojo_base::mojom::BigStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPacUrl(UserType* output) {
    
    auto* pointer = data_->pac_url.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::BigStringDataView>(
        pointer, output, message_);
  }
  bool pac_mandatory() const {
    return data_->pac_mandatory;
  }
  inline void GetProxyRulesDataView(
      ProxyRulesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxyRules(UserType* output) {
    
    auto* pointer = data_->proxy_rules.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyRulesDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProxyConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

template <>
struct hash<::network::mojom::ProxyRulesType>
    : public mojo::internal::EnumHashImpl<::network::mojom::ProxyRulesType> {};

template <>
struct hash<::network::mojom::IpProtectionProxyBypassPolicy>
    : public mojo::internal::EnumHashImpl<::network::mojom::IpProtectionProxyBypassPolicy> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyRulesType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ProxyRulesType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ProxyRulesType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::IpProtectionProxyBypassPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::IpProtectionProxyBypassPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::IpProtectionProxyBypassPolicy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyBypassRulesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyBypassRulesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyBypassRules_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::rules(input)) in_rules = Traits::rules(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rules)::BaseType>
        rules_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& rules_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_rules, rules_fragment, &rules_validate_params);
    fragment->rules.Set(
        rules_fragment.is_null() ? nullptr : rules_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->rules.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rules in ProxyBypassRules struct");
  }

  static bool Deserialize(::network::mojom::internal::ProxyBypassRules_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ProxyBypassRulesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyListDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyListDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyList_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::proxies(input)) in_proxies = Traits::proxies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxies)::BaseType>
        proxies_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& proxies_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ProxyChainDataView>>(
        in_proxies, proxies_fragment, &proxies_validate_params);
    fragment->proxies.Set(
        proxies_fragment.is_null() ? nullptr : proxies_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->proxies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxies in ProxyList struct");
  }

  static bool Deserialize(::network::mojom::internal::ProxyList_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ProxyListDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyRulesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyRulesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyRules_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::bypass_rules(input)) in_bypass_rules = Traits::bypass_rules(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bypass_rules)::BaseType> bypass_rules_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ProxyBypassRulesDataView>(
        in_bypass_rules, bypass_rules_fragment);
    fragment->bypass_rules.Set(
        bypass_rules_fragment.is_null() ? nullptr : bypass_rules_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bypass_rules.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bypass_rules in ProxyRules struct");
    fragment->reverse_bypass = Traits::reverse_bypass(input);
    mojo::internal::Serialize<::network::mojom::ProxyRulesType>(
        Traits::type(input), &fragment->type);
    decltype(Traits::single_proxies(input)) in_single_proxies = Traits::single_proxies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->single_proxies)::BaseType> single_proxies_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ProxyListDataView>(
        in_single_proxies, single_proxies_fragment);
    fragment->single_proxies.Set(
        single_proxies_fragment.is_null() ? nullptr : single_proxies_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->single_proxies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null single_proxies in ProxyRules struct");
    decltype(Traits::proxies_for_http(input)) in_proxies_for_http = Traits::proxies_for_http(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxies_for_http)::BaseType> proxies_for_http_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ProxyListDataView>(
        in_proxies_for_http, proxies_for_http_fragment);
    fragment->proxies_for_http.Set(
        proxies_for_http_fragment.is_null() ? nullptr : proxies_for_http_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->proxies_for_http.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxies_for_http in ProxyRules struct");
    decltype(Traits::proxies_for_https(input)) in_proxies_for_https = Traits::proxies_for_https(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxies_for_https)::BaseType> proxies_for_https_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ProxyListDataView>(
        in_proxies_for_https, proxies_for_https_fragment);
    fragment->proxies_for_https.Set(
        proxies_for_https_fragment.is_null() ? nullptr : proxies_for_https_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->proxies_for_https.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxies_for_https in ProxyRules struct");
    decltype(Traits::proxies_for_ftp(input)) in_proxies_for_ftp = Traits::proxies_for_ftp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxies_for_ftp)::BaseType> proxies_for_ftp_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ProxyListDataView>(
        in_proxies_for_ftp, proxies_for_ftp_fragment);
    fragment->proxies_for_ftp.Set(
        proxies_for_ftp_fragment.is_null() ? nullptr : proxies_for_ftp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->proxies_for_ftp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxies_for_ftp in ProxyRules struct");
    decltype(Traits::fallback_proxies(input)) in_fallback_proxies = Traits::fallback_proxies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fallback_proxies)::BaseType> fallback_proxies_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ProxyListDataView>(
        in_fallback_proxies, fallback_proxies_fragment);
    fragment->fallback_proxies.Set(
        fallback_proxies_fragment.is_null() ? nullptr : fallback_proxies_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->fallback_proxies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fallback_proxies in ProxyRules struct");
  }

  static bool Deserialize(::network::mojom::internal::ProxyRules_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ProxyRulesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->auto_detect = Traits::auto_detect(input);
    fragment->from_system = Traits::from_system(input);
    decltype(Traits::pac_url(input)) in_pac_url = Traits::pac_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pac_url)::BaseType> pac_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::BigStringDataView>(
        in_pac_url, pac_url_fragment);
    fragment->pac_url.Set(
        pac_url_fragment.is_null() ? nullptr : pac_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pac_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pac_url in ProxyConfig struct");
    fragment->pac_mandatory = Traits::pac_mandatory(input);
    decltype(Traits::proxy_rules(input)) in_proxy_rules = Traits::proxy_rules(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxy_rules)::BaseType> proxy_rules_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ProxyRulesDataView>(
        in_proxy_rules, proxy_rules_fragment);
    fragment->proxy_rules.Set(
        proxy_rules_fragment.is_null() ? nullptr : proxy_rules_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->proxy_rules.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxy_rules in ProxyConfig struct");
  }

  static bool Deserialize(::network::mojom::internal::ProxyConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ProxyConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void ProxyBypassRulesDataView::GetRulesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->rules.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void ProxyListDataView::GetProxiesDataView(
    mojo::ArrayDataView<::network::mojom::ProxyChainDataView>* output) {
  auto pointer = data_->proxies.Get();
  *output = mojo::ArrayDataView<::network::mojom::ProxyChainDataView>(pointer, message_);
}


inline void ProxyRulesDataView::GetBypassRulesDataView(
    ProxyBypassRulesDataView* output) {
  auto pointer = data_->bypass_rules.Get();
  *output = ProxyBypassRulesDataView(pointer, message_);
}
inline void ProxyRulesDataView::GetSingleProxiesDataView(
    ProxyListDataView* output) {
  auto pointer = data_->single_proxies.Get();
  *output = ProxyListDataView(pointer, message_);
}
inline void ProxyRulesDataView::GetProxiesForHttpDataView(
    ProxyListDataView* output) {
  auto pointer = data_->proxies_for_http.Get();
  *output = ProxyListDataView(pointer, message_);
}
inline void ProxyRulesDataView::GetProxiesForHttpsDataView(
    ProxyListDataView* output) {
  auto pointer = data_->proxies_for_https.Get();
  *output = ProxyListDataView(pointer, message_);
}
inline void ProxyRulesDataView::GetProxiesForFtpDataView(
    ProxyListDataView* output) {
  auto pointer = data_->proxies_for_ftp.Get();
  *output = ProxyListDataView(pointer, message_);
}
inline void ProxyRulesDataView::GetFallbackProxiesDataView(
    ProxyListDataView* output) {
  auto pointer = data_->fallback_proxies.Get();
  *output = ProxyListDataView(pointer, message_);
}


inline void ProxyConfigDataView::GetPacUrlDataView(
    ::mojo_base::mojom::BigStringDataView* output) {
  auto pointer = data_->pac_url.Get();
  *output = ::mojo_base::mojom::BigStringDataView(pointer, message_);
}
inline void ProxyConfigDataView::GetProxyRulesDataView(
    ProxyRulesDataView* output) {
  auto pointer = data_->proxy_rules.Get();
  *output = ProxyRulesDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ProxyRulesType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ProxyRulesType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::IpProtectionProxyBypassPolicy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::IpProtectionProxyBypassPolicy value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_SHARED_H_