// media/mojo/mojom/stable/stable_video_decoder_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_STABLE_STABLE_VIDEO_DECODER_TYPES_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_STABLE_STABLE_VIDEO_DECODER_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/stable/stable_video_decoder_types.mojom-shared-internal.h"
#include "media/mojo/mojom/encryption_pattern.mojom-shared.h"
#include "media/mojo/mojom/stable/native_pixmap_handle.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace media::stable::mojom {
class SubsampleEntryDataView;

class DecryptConfigDataView;

class ColorVolumeMetadataDataView;

class HDRMetadataDataView;

class VideoDecoderConfigDataView;

class SupportedVideoDecoderConfigDataView;

class StatusDataDataView;

class StatusDataView;

class DecoderBufferSideDataDataView;

class DecoderBufferDataView;

class ColorSpaceDataView;

class NativeGpuMemoryBufferHandleDataView;

class VideoFrameMetadataDataView;

class VideoFrameDataView;

class MediaLogRecordDataView;



}  // media::stable::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::stable::mojom::SubsampleEntryDataView> {
  using Data = ::media::stable::mojom::internal::SubsampleEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::DecryptConfigDataView> {
  using Data = ::media::stable::mojom::internal::DecryptConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::ColorVolumeMetadataDataView> {
  using Data = ::media::stable::mojom::internal::ColorVolumeMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::HDRMetadataDataView> {
  using Data = ::media::stable::mojom::internal::HDRMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::VideoDecoderConfigDataView> {
  using Data = ::media::stable::mojom::internal::VideoDecoderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::SupportedVideoDecoderConfigDataView> {
  using Data = ::media::stable::mojom::internal::SupportedVideoDecoderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::StatusDataDataView> {
  using Data = ::media::stable::mojom::internal::StatusData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::StatusDataView> {
  using Data = ::media::stable::mojom::internal::Status_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::DecoderBufferSideDataDataView> {
  using Data = ::media::stable::mojom::internal::DecoderBufferSideData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::DecoderBufferDataView> {
  using Data = ::media::stable::mojom::internal::DecoderBuffer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::ColorSpaceDataView> {
  using Data = ::media::stable::mojom::internal::ColorSpace_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::NativeGpuMemoryBufferHandleDataView> {
  using Data = ::media::stable::mojom::internal::NativeGpuMemoryBufferHandle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::VideoFrameMetadataDataView> {
  using Data = ::media::stable::mojom::internal::VideoFrameMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::VideoFrameDataView> {
  using Data = ::media::stable::mojom::internal::VideoFrame_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::MediaLogRecordDataView> {
  using Data = ::media::stable::mojom::internal::MediaLogRecord_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::stable::mojom {


enum class VideoCodec : int32_t {
  
  kUnknown = 0,
  
  kH264 = 1,
  
  kVC1 = 2,
  
  kMPEG2 = 3,
  
  kMPEG4 = 4,
  
  kTheora = 5,
  
  kVP8 = 6,
  
  kVP9 = 7,
  
  kHEVC = 8,
  
  kDolbyVision = 9,
  
  kAV1 = 10,
  kMinValue = 0,
  kMaxValue = 10,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, VideoCodec value);
inline bool IsKnownEnumValue(VideoCodec value) {
  return internal::VideoCodec_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline VideoCodec ToKnownEnumValue(VideoCodec value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return VideoCodec::kDefaultValue;
}


enum class VideoCodecProfile : int32_t {
  
  kVideoCodecProfileUnknown = -1,
  
  kH264ProfileMin = 0,
  
  kH264ProfileBaseline = 0,
  
  kH264ProfileMain = 1,
  
  kH264ProfileExtended = 2,
  
  kH264ProfileHigh = 3,
  
  kH264ProfileHigh10 = 4,
  
  kH264ProfileHigh422 = 5,
  
  kH264ProfileHigh444Predictive = 6,
  
  kH264ProfileScalableBaseline = 7,
  
  kH264ProfileScalableHigh = 8,
  
  kH264ProfileStereoHigh = 9,
  
  kH264ProfileMultiviewHigh = 10,
  
  kH264ProfileMax = 10,
  
  kVP8ProfileMin = 11,
  
  kVP8ProfileAny = 11,
  
  kVP8ProfileMax = 11,
  
  kVP9ProfileMin = 12,
  
  kVP9Profile0 = 12,
  
  kVP9Profile1 = 13,
  
  kVP9Profile2 = 14,
  
  kVP9Profile3 = 15,
  
  kVP9ProfileMax = 15,
  
  kHEVCProfileMin = 16,
  
  kHEVCProfileMain = 16,
  
  kHEVCProfileMain10 = 17,
  
  kHEVCProfileMainStillPicture = 18,
  
  kHEVCProfileMax = 18,
  
  kDolbyVisionProfile0 = 19,
  
  kDeprecatedDolbyVisionProfile4 = 20,
  
  kDolbyVisionProfile5 = 21,
  
  kDolbyVisionProfile7 = 22,
  
  kTheoraProfileMin = 23,
  
  kTheoraProfileAny = 23,
  
  kTheoraProfileMax = 23,
  
  kAV1ProfileMin = 24,
  
  kAV1ProfileMain = 24,
  
  kAV1ProfileHigh = 25,
  
  kAV1ProfilePro = 26,
  
  kAV1ProfileMax = 26,
  
  kDolbyVisionProfile8 = 27,
  
  kDolbyVisionProfile9 = 28,
  
  kHEVCProfileExtMin = 29,
  
  kHEVCProfileRext = 29,
  
  kHEVCProfileHighThroughput = 30,
  
  kHEVCProfileMultiviewMain = 31,
  
  kHEVCProfileScalableMain = 32,
  
  kHEVCProfile3dMain = 33,
  
  kHEVCProfileScreenExtended = 34,
  
  kHEVCProfileScalableRext = 35,
  
  kHEVCProfileHighThroughputScreenExtended = 36,
  
  kHEVCProfileExtMax = 36,
  
  kVVCProfileMin = 37,
  
  kVVCProfileMain10 = 37,
  
  kVVCProfileMain12 = 38,
  
  kVVCProfileMain12Intra = 39,
  
  kVVCProfileMultilayerMain10 = 40,
  
  kVVCProfileMain10444 = 41,
  
  kVVCProfileMain12444 = 42,
  
  kVVCProfileMain16444 = 43,
  
  kVVCProfileMain12444Intra = 44,
  
  kVVCProfileMain16444Intra = 45,
  
  kVVCProfileMultilayerMain10444 = 46,
  
  kVVCProfileMain10Still = 47,
  
  kVVCProfileMain12Still = 48,
  
  kVVCProfileMain10444Still = 49,
  
  kVVCProfileMain12444Still = 50,
  
  kVVCProfileMain16444Still = 51,
  
  kVVCProileMax = 51,
  kMinValue = -1,
  kMaxValue = 51,
  kDefaultValue = -1
};

 std::ostream& operator<<(std::ostream& os, VideoCodecProfile value);
inline bool IsKnownEnumValue(VideoCodecProfile value) {
  return internal::VideoCodecProfile_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline VideoCodecProfile ToKnownEnumValue(VideoCodecProfile value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return VideoCodecProfile::kDefaultValue;
}


enum class EncryptionScheme : int32_t {
  
  kUnencrypted = 0,
  
  kCenc = 1,
  
  kCbcs = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, EncryptionScheme value);
inline bool IsKnownEnumValue(EncryptionScheme value) {
  return internal::EncryptionScheme_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline EncryptionScheme ToKnownEnumValue(EncryptionScheme value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return EncryptionScheme::kDefaultValue;
}


enum class StatusCode : int32_t {
  
  kOk_DEPRECATED = 0,
  
  kAborted = 1,
  
  kError = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 2
};

 std::ostream& operator<<(std::ostream& os, StatusCode value);
inline bool IsKnownEnumValue(StatusCode value) {
  return internal::StatusCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline StatusCode ToKnownEnumValue(StatusCode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return StatusCode::kDefaultValue;
}


enum class VideoDecoderType : int32_t {
  
  kUnknown = 0,
  
  kVaapi = 1,
  
  kVda = 2,
  
  kV4L2 = 3,
  
  kTesting = 4,
  kMinValue = 0,
  kMaxValue = 4,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, VideoDecoderType value);
inline bool IsKnownEnumValue(VideoDecoderType value) {
  return internal::VideoDecoderType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline VideoDecoderType ToKnownEnumValue(VideoDecoderType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return VideoDecoderType::kDefaultValue;
}


enum class ColorSpacePrimaryID : int32_t {
  
  kInvalid = 0,
  
  kBT709 = 1,
  
  kBT470M = 2,
  
  kBT470BG = 3,
  
  kSMPTE170M = 4,
  
  kSMPTE240M = 5,
  
  kFilm = 6,
  
  kBT2020 = 7,
  
  kSMPTEST428_1 = 8,
  
  kSMPTEST431_2 = 9,
  
  kSMPTEST432_1 = 10,
  
  kXYZ_D50 = 11,
  
  kAdobeRGB = 12,
  
  kAppleGenericRGB = 13,
  
  kWideGamutColorSpin = 14,
  
  kCustom = 15,
  
  kEBU_3213_E = 16,
  kMinValue = 0,
  kMaxValue = 16,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ColorSpacePrimaryID value);
inline bool IsKnownEnumValue(ColorSpacePrimaryID value) {
  return internal::ColorSpacePrimaryID_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ColorSpacePrimaryID ToKnownEnumValue(ColorSpacePrimaryID value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ColorSpacePrimaryID::kDefaultValue;
}


enum class ColorSpaceTransferID : int32_t {
  
  kInvalid = 0,
  
  kBT709 = 1,
  
  kBT709Apple = 2,
  
  kGamma18 = 3,
  
  kGamma22 = 4,
  
  kGamma24 = 5,
  
  kGamma28 = 6,
  
  kSMPTE170M = 7,
  
  kSMPTE240M = 8,
  
  kLinear = 9,
  
  kLog = 10,
  
  kLogSqrt = 11,
  
  kIEC61966_2_4 = 12,
  
  kBT1361_ECG = 13,
  
  kIEC61966_2_1 = 14,
  
  kBT2020_10 = 15,
  
  kBT2020_12 = 16,
  
  kSMPTEST2084 = 17,
  
  kSMPTEST428_1 = 18,
  
  kARIB_STD_B67 = 19,
  
  kIEC61966_2_1_HDR = 20,
  
  kLinearHDR = 21,
  
  kCustom = 22,
  
  kCustomHDR = 23,
  
  kPiecewiseHDR = 24,
  
  kScrgbLinear80Nits = 25,
  kMinValue = 0,
  kMaxValue = 25,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ColorSpaceTransferID value);
inline bool IsKnownEnumValue(ColorSpaceTransferID value) {
  return internal::ColorSpaceTransferID_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ColorSpaceTransferID ToKnownEnumValue(ColorSpaceTransferID value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ColorSpaceTransferID::kDefaultValue;
}


enum class ColorSpaceMatrixID : int32_t {
  
  kInvalid = 0,
  
  kRGB = 1,
  
  kBT709 = 2,
  
  kFCC = 3,
  
  kBT470BG = 4,
  
  kSMPTE170M = 5,
  
  kSMPTE240M = 6,
  
  kYCOCG = 7,
  
  kBT2020_NCL = 8,
  
  kBT2020_CL = 9,
  
  kYDZDX = 10,
  
  kGBR = 11,
  kMinValue = 0,
  kMaxValue = 11,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ColorSpaceMatrixID value);
inline bool IsKnownEnumValue(ColorSpaceMatrixID value) {
  return internal::ColorSpaceMatrixID_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ColorSpaceMatrixID ToKnownEnumValue(ColorSpaceMatrixID value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ColorSpaceMatrixID::kDefaultValue;
}


enum class ColorSpaceRangeID : int32_t {
  
  kInvalid = 0,
  
  kLimited = 1,
  
  kFull = 2,
  
  kDerived = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ColorSpaceRangeID value);
inline bool IsKnownEnumValue(ColorSpaceRangeID value) {
  return internal::ColorSpaceRangeID_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ColorSpaceRangeID ToKnownEnumValue(ColorSpaceRangeID value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ColorSpaceRangeID::kDefaultValue;
}


enum class VideoPixelFormat : int32_t {
  
  kPixelFormatUnknown = 0,
  
  kPixelFormatI420 = 1,
  
  kPixelFormatYV12 = 2,
  
  kPixelFormatI422 = 3,
  
  kPixelFormatI420A = 4,
  
  kPixelFormatI444 = 5,
  
  kPixelFormatNV12 = 6,
  
  kPixelFormatNV21 = 7,
  
  kPixelFormatUYVY = 8,
  
  kPixelFormatYUY2 = 9,
  
  kPixelFormatARGB = 10,
  
  kPixelFormatXRGB = 11,
  
  kPixelFormatRGB24 = 12,
  
  kPixelFormatMJPEG = 14,
  
  kPixelFormatYUV420P9 = 16,
  
  kPixelFormatYUV420P10 = 17,
  
  kPixelFormatYUV422P9 = 18,
  
  kPixelFormatYUV422P10 = 19,
  
  kPixelFormatYUV444P9 = 20,
  
  kPixelFormatYUV444P10 = 21,
  
  kPixelFormatYUV420P12 = 22,
  
  kPixelFormatYUV422P12 = 23,
  
  kPixelFormatYUV444P12 = 24,
  
  kPixelFormatY16 = 26,
  
  kPixelFormatABGR = 27,
  
  kPixelFormatXBGR = 28,
  
  kPixelFormatP010LE = 29,
  
  kPixelFormatXR30 = 30,
  
  kPixelFormatXB30 = 31,
  
  kPixelFormatBGRA = 32,
  
  kPixelFormatRGBAF16 = 33,
  
  kPixelFormatI422A = 34,
  
  kPixelFormatI444A = 35,
  
  kPixelFormatYUV420AP10 = 36,
  
  kPixelFormatYUV422AP10 = 37,
  
  kPixelFormatYUV444AP10 = 38,
  
  kPixelFormatNV12A = 39,
  
  kPixelFormatNV16 = 40,
  
  kPixelFormatNV24 = 41,
  
  kPixelFormatP210LE = 42,
  
  kPixelFormatP410LE = 43,
  kMinValue = 0,
  kMaxValue = 43,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, VideoPixelFormat value);
inline bool IsKnownEnumValue(VideoPixelFormat value) {
  return internal::VideoPixelFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline VideoPixelFormat ToKnownEnumValue(VideoPixelFormat value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return VideoPixelFormat::kDefaultValue;
}


enum class WaitingReason : int32_t {
  
  kNoCdm = 0,
  
  kNoDecryptionKey = 1,
  
  kDecoderStateLost = 2,
  
  kSecureSurfaceLost = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, WaitingReason value);
inline bool IsKnownEnumValue(WaitingReason value) {
  return internal::WaitingReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline WaitingReason ToKnownEnumValue(WaitingReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return WaitingReason::kDefaultValue;
}


enum class DecryptStatus : int32_t {
  
  kSuccess = 0,
  
  kNoKey = 1,
  
  kFailure = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 2
};

 std::ostream& operator<<(std::ostream& os, DecryptStatus value);
inline bool IsKnownEnumValue(DecryptStatus value) {
  return internal::DecryptStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline DecryptStatus ToKnownEnumValue(DecryptStatus value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return DecryptStatus::kDefaultValue;
}


enum class CdmContextEvent : int32_t {
  
  kHasAdditionalUsableKey = 0,
  
  kHardwareContextReset = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, CdmContextEvent value);
inline bool IsKnownEnumValue(CdmContextEvent value) {
  return internal::CdmContextEvent_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline CdmContextEvent ToKnownEnumValue(CdmContextEvent value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return CdmContextEvent::kDefaultValue;
}


enum class MediaLogRecord_Type : int32_t {
  
  kMessage = 0,
  
  kMediaPropertyChange = 1,
  
  kMediaEventTriggered = 2,
  
  kMediaStatus = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, MediaLogRecord_Type value);
inline bool IsKnownEnumValue(MediaLogRecord_Type value) {
  return internal::MediaLogRecord_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline MediaLogRecord_Type ToKnownEnumValue(MediaLogRecord_Type value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return MediaLogRecord_Type::kDefaultValue;
}


class SubsampleEntryDataView {
 public:
  SubsampleEntryDataView() = default;

  SubsampleEntryDataView(
      internal::SubsampleEntry_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t clear_bytes() const {
    return data_->clear_bytes;
  }
  uint32_t cypher_bytes() const {
    return data_->cypher_bytes;
  }
 private:
  internal::SubsampleEntry_Data* data_ = nullptr;
};


class DecryptConfigDataView {
 public:
  DecryptConfigDataView() = default;

  DecryptConfigDataView(
      internal::DecryptConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadEncryptionScheme(UserType* output) const {
    auto data_value = data_->encryption_scheme;
    return mojo::internal::Deserialize<::media::stable::mojom::EncryptionScheme>(
        data_value, output);
  }
  EncryptionScheme encryption_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::EncryptionScheme>(data_->encryption_scheme));
  }
  inline void GetKeyIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyId(UserType* output) {
    
    auto* pointer = data_->key_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIvDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIv(UserType* output) {
    
    auto* pointer = data_->iv.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSubsamplesDataView(
      mojo::ArrayDataView<SubsampleEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubsamples(UserType* output) {
    
    auto* pointer = data_->subsamples.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::stable::mojom::SubsampleEntryDataView>>(
        pointer, output, message_);
  }
  inline void GetEncryptionPatternDataView(
      ::media::mojom::EncryptionPatternDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncryptionPattern(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::EncryptionPatternDataView, UserType>(),
    "Attempting to read the optional `encryption_pattern` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEncryptionPattern` instead "
    "of `ReadEncryptionPattern if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->encryption_pattern.Get();
    return mojo::internal::Deserialize<::media::mojom::EncryptionPatternDataView>(
        pointer, output, message_);
  }
 private:
  internal::DecryptConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ColorVolumeMetadataDataView {
 public:
  ColorVolumeMetadataDataView() = default;

  ColorVolumeMetadataDataView(
      internal::ColorVolumeMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrimaryRDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryR(UserType* output) {
    
    auto* pointer = data_->primary_r.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetPrimaryGDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryG(UserType* output) {
    
    auto* pointer = data_->primary_g.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetPrimaryBDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryB(UserType* output) {
    
    auto* pointer = data_->primary_b.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetWhitePointDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWhitePoint(UserType* output) {
    
    auto* pointer = data_->white_point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  float luminance_max() const {
    return data_->luminance_max;
  }
  float luminance_min() const {
    return data_->luminance_min;
  }
 private:
  internal::ColorVolumeMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HDRMetadataDataView {
 public:
  HDRMetadataDataView() = default;

  HDRMetadataDataView(
      internal::HDRMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetColorVolumeMetadataDataView(
      ColorVolumeMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorVolumeMetadata(UserType* output) {
    
    auto* pointer = data_->color_volume_metadata.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::ColorVolumeMetadataDataView>(
        pointer, output, message_);
  }
  uint32_t max_content_light_level() const {
    return data_->max_content_light_level;
  }
  uint32_t max_frame_average_light_level() const {
    return data_->max_frame_average_light_level;
  }
 private:
  internal::HDRMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecoderConfigDataView {
 public:
  VideoDecoderConfigDataView() = default;

  VideoDecoderConfigDataView(
      internal::VideoDecoderConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCodec(UserType* output) const {
    auto data_value = data_->codec;
    return mojo::internal::Deserialize<::media::stable::mojom::VideoCodec>(
        data_value, output);
  }
  VideoCodec codec() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::VideoCodec>(data_->codec));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) const {
    auto data_value = data_->profile;
    return mojo::internal::Deserialize<::media::stable::mojom::VideoCodecProfile>(
        data_value, output);
  }
  VideoCodecProfile profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::VideoCodecProfile>(data_->profile));
  }
  uint32_t level() const {
    return data_->level;
  }
  bool has_alpha() const {
    return data_->has_alpha;
  }
  inline void GetCodedSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodedSize(UserType* output) {
    
    auto* pointer = data_->coded_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleRect(UserType* output) {
    
    auto* pointer = data_->visible_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetNaturalSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNaturalSize(UserType* output) {
    
    auto* pointer = data_->natural_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetExtraDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtraData(UserType* output) {
    
    auto* pointer = data_->extra_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEncryptionScheme(UserType* output) const {
    auto data_value = data_->encryption_scheme;
    return mojo::internal::Deserialize<::media::stable::mojom::EncryptionScheme>(
        data_value, output);
  }
  EncryptionScheme encryption_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::EncryptionScheme>(data_->encryption_scheme));
  }
  inline void GetColorSpaceInfoDataView(
      ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpaceInfo(UserType* output) {
    
    auto* pointer = data_->color_space_info.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
  inline void GetHdrMetadataDataView(
      HDRMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHdrMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::stable::mojom::HDRMetadataDataView, UserType>(),
    "Attempting to read the optional `hdr_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHdrMetadata` instead "
    "of `ReadHdrMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hdr_metadata.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::HDRMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoDecoderConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SupportedVideoDecoderConfigDataView {
 public:
  SupportedVideoDecoderConfigDataView() = default;

  SupportedVideoDecoderConfigDataView(
      internal::SupportedVideoDecoderConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProfileMin(UserType* output) const {
    auto data_value = data_->profile_min;
    return mojo::internal::Deserialize<::media::stable::mojom::VideoCodecProfile>(
        data_value, output);
  }
  VideoCodecProfile profile_min() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::VideoCodecProfile>(data_->profile_min));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProfileMax(UserType* output) const {
    auto data_value = data_->profile_max;
    return mojo::internal::Deserialize<::media::stable::mojom::VideoCodecProfile>(
        data_value, output);
  }
  VideoCodecProfile profile_max() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::VideoCodecProfile>(data_->profile_max));
  }
  inline void GetCodedSizeMinDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodedSizeMin(UserType* output) {
    
    auto* pointer = data_->coded_size_min.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetCodedSizeMaxDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodedSizeMax(UserType* output) {
    
    auto* pointer = data_->coded_size_max.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  bool allow_encrypted() const {
    return data_->allow_encrypted;
  }
  bool require_encrypted() const {
    return data_->require_encrypted;
  }
 private:
  internal::SupportedVideoDecoderConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StatusDataDataView {
 public:
  StatusDataDataView() = default;

  StatusDataDataView(
      internal::StatusData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGroupDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroup(UserType* output) {
    
    auto* pointer = data_->group.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) const {
    auto data_value = data_->code;
    return mojo::internal::Deserialize<::media::stable::mojom::StatusCode>(
        data_value, output);
  }
  StatusCode code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::StatusCode>(data_->code));
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFramesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::ValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrames(UserType* output) {
    
    auto* pointer = data_->frames.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::ValueDataView>>(
        pointer, output, message_);
  }
  inline void GetCauseDataView(
      StatusDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCause(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::stable::mojom::StatusDataDataView, UserType>(),
    "Attempting to read the optional `cause` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCause` instead "
    "of `ReadCause if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cause.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::StatusDataDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::ValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::ValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::StatusData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StatusDataView {
 public:
  StatusDataView() = default;

  StatusDataView(
      internal::Status_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInternalDataView(
      StatusDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInternal(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::stable::mojom::StatusDataDataView, UserType>(),
    "Attempting to read the optional `internal` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInternal` instead "
    "of `ReadInternal if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->internal.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::StatusDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::Status_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DecoderBufferSideDataDataView {
 public:
  DecoderBufferSideDataDataView() = default;

  DecoderBufferSideDataDataView(
      internal::DecoderBufferSideData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSpatialLayersDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSpatialLayers(UserType* output) {
    
    auto* pointer = data_->spatial_layers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetAlphaDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlphaData(UserType* output) {
    
    auto* pointer = data_->alpha_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  uint64_t secure_handle() const {
    return data_->secure_handle;
  }
 private:
  internal::DecoderBufferSideData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DecoderBufferDataView {
 public:
  DecoderBufferDataView() = default;

  DecoderBufferDataView(
      internal::DecoderBuffer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool is_end_of_stream() const {
    return data_->is_end_of_stream;
  }
  uint32_t data_size() const {
    return data_->data_size;
  }
  bool is_key_frame() const {
    return data_->is_key_frame;
  }
  inline void GetRawSideDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawSideData(UserType* output) {
    
    auto* pointer = data_->raw_side_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetDecryptConfigDataView(
      DecryptConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecryptConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::stable::mojom::DecryptConfigDataView, UserType>(),
    "Attempting to read the optional `decrypt_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDecryptConfig` instead "
    "of `ReadDecryptConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->decrypt_config.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::DecryptConfigDataView>(
        pointer, output, message_);
  }
  inline void GetFrontDiscardDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrontDiscard(UserType* output) {
    
    auto* pointer = data_->front_discard.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetBackDiscardDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackDiscard(UserType* output) {
    
    auto* pointer = data_->back_discard.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetSideDataDataView(
      DecoderBufferSideDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSideData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::stable::mojom::DecoderBufferSideDataDataView, UserType>(),
    "Attempting to read the optional `side_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSideData` instead "
    "of `ReadSideData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->side_data.Get() : nullptr;
    return mojo::internal::Deserialize<::media::stable::mojom::DecoderBufferSideDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::DecoderBuffer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ColorSpaceDataView {
 public:
  ColorSpaceDataView() = default;

  ColorSpaceDataView(
      internal::ColorSpace_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadPrimaries(UserType* output) const {
    auto data_value = data_->primaries;
    return mojo::internal::Deserialize<::media::stable::mojom::ColorSpacePrimaryID>(
        data_value, output);
  }
  ColorSpacePrimaryID primaries() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::ColorSpacePrimaryID>(data_->primaries));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTransfer(UserType* output) const {
    auto data_value = data_->transfer;
    return mojo::internal::Deserialize<::media::stable::mojom::ColorSpaceTransferID>(
        data_value, output);
  }
  ColorSpaceTransferID transfer() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::ColorSpaceTransferID>(data_->transfer));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMatrix(UserType* output) const {
    auto data_value = data_->matrix;
    return mojo::internal::Deserialize<::media::stable::mojom::ColorSpaceMatrixID>(
        data_value, output);
  }
  ColorSpaceMatrixID matrix() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::ColorSpaceMatrixID>(data_->matrix));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRange(UserType* output) const {
    auto data_value = data_->range;
    return mojo::internal::Deserialize<::media::stable::mojom::ColorSpaceRangeID>(
        data_value, output);
  }
  ColorSpaceRangeID range() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::ColorSpaceRangeID>(data_->range));
  }
  inline void GetCustomPrimaryMatrixDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCustomPrimaryMatrix(UserType* output) {
    
    auto* pointer = data_->custom_primary_matrix.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  inline void GetTransferParamsDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransferParams(UserType* output) {
    
    auto* pointer = data_->transfer_params.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
 private:
  internal::ColorSpace_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NativeGpuMemoryBufferHandleDataView {
 public:
  NativeGpuMemoryBufferHandleDataView() = default;

  NativeGpuMemoryBufferHandleDataView(
      internal::NativeGpuMemoryBufferHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::gfx::mojom::GpuMemoryBufferIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
        pointer, output, message_);
  }
  inline void GetPlatformHandleDataView(
      ::media::stable::mojom::NativePixmapHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlatformHandle(UserType* output) {
    
    auto* pointer = data_->platform_handle.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::NativePixmapHandleDataView>(
        pointer, output, message_);
  }
 private:
  internal::NativeGpuMemoryBufferHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoFrameMetadataDataView {
 public:
  VideoFrameMetadataDataView() = default;

  VideoFrameMetadataDataView(
      internal::VideoFrameMetadata_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool protected_video() const {
    return data_->protected_video;
  }
  bool hw_protected() const {
    return data_->hw_protected;
  }
  bool needs_detiling() const {
    if (data_->header_.version < 1)
      return bool{};
    return data_->needs_detiling;
  }
 private:
  internal::VideoFrameMetadata_Data* data_ = nullptr;
};


class VideoFrameDataView {
 public:
  VideoFrameDataView() = default;

  VideoFrameDataView(
      internal::VideoFrame_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) const {
    auto data_value = data_->format;
    return mojo::internal::Deserialize<::media::stable::mojom::VideoPixelFormat>(
        data_value, output);
  }
  VideoPixelFormat format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::VideoPixelFormat>(data_->format));
  }
  inline void GetCodedSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodedSize(UserType* output) {
    
    auto* pointer = data_->coded_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleRect(UserType* output) {
    
    auto* pointer = data_->visible_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetNaturalSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNaturalSize(UserType* output) {
    
    auto* pointer = data_->natural_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetGpuMemoryBufferHandleDataView(
      NativeGpuMemoryBufferHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGpuMemoryBufferHandle(UserType* output) {
    
    auto* pointer = data_->gpu_memory_buffer_handle.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::NativeGpuMemoryBufferHandleDataView>(
        pointer, output, message_);
  }
  inline void GetMetadataDataView(
      VideoFrameMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::VideoFrameMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetColorSpaceDataView(
      ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpace(UserType* output) {
    
    auto* pointer = data_->color_space.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
  inline void GetHdrMetadataDataView(
      HDRMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHdrMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::stable::mojom::HDRMetadataDataView, UserType>(),
    "Attempting to read the optional `hdr_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHdrMetadata` instead "
    "of `ReadHdrMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hdr_metadata.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::HDRMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoFrame_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaLogRecordDataView {
 public:
  MediaLogRecordDataView() = default;

  MediaLogRecordDataView(
      internal::MediaLogRecord_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::media::stable::mojom::MediaLogRecord_Type>(
        data_value, output);
  }
  MediaLogRecord_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::MediaLogRecord_Type>(data_->type));
  }
  inline void GetParamsDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
  inline void GetTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTime(UserType* output) {
    
    auto* pointer = data_->time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaLogRecord_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::stable::mojom

namespace std {

template <>
struct hash<::media::stable::mojom::VideoCodec>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::VideoCodec> {};

template <>
struct hash<::media::stable::mojom::VideoCodecProfile>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::VideoCodecProfile> {};

template <>
struct hash<::media::stable::mojom::EncryptionScheme>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::EncryptionScheme> {};

template <>
struct hash<::media::stable::mojom::StatusCode>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::StatusCode> {};

template <>
struct hash<::media::stable::mojom::VideoDecoderType>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::VideoDecoderType> {};

template <>
struct hash<::media::stable::mojom::ColorSpacePrimaryID>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::ColorSpacePrimaryID> {};

template <>
struct hash<::media::stable::mojom::ColorSpaceTransferID>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::ColorSpaceTransferID> {};

template <>
struct hash<::media::stable::mojom::ColorSpaceMatrixID>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::ColorSpaceMatrixID> {};

template <>
struct hash<::media::stable::mojom::ColorSpaceRangeID>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::ColorSpaceRangeID> {};

template <>
struct hash<::media::stable::mojom::VideoPixelFormat>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::VideoPixelFormat> {};

template <>
struct hash<::media::stable::mojom::WaitingReason>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::WaitingReason> {};

template <>
struct hash<::media::stable::mojom::DecryptStatus>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::DecryptStatus> {};

template <>
struct hash<::media::stable::mojom::CdmContextEvent>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::CdmContextEvent> {};

template <>
struct hash<::media::stable::mojom::MediaLogRecord_Type>
    : public mojo::internal::EnumHashImpl<::media::stable::mojom::MediaLogRecord_Type> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::VideoCodec, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::VideoCodec, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::VideoCodec>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::VideoCodecProfile, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::VideoCodecProfile, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::VideoCodecProfile>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::EncryptionScheme, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::EncryptionScheme, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::EncryptionScheme>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::StatusCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::StatusCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::StatusCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::VideoDecoderType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::VideoDecoderType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::VideoDecoderType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::ColorSpacePrimaryID, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::ColorSpacePrimaryID, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::ColorSpacePrimaryID>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::ColorSpaceTransferID, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::ColorSpaceTransferID, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::ColorSpaceTransferID>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::ColorSpaceMatrixID, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::ColorSpaceMatrixID, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::ColorSpaceMatrixID>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::ColorSpaceRangeID, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::ColorSpaceRangeID, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::ColorSpaceRangeID>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::VideoPixelFormat, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::VideoPixelFormat, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::VideoPixelFormat>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::WaitingReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::WaitingReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::WaitingReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::DecryptStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::DecryptStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::DecryptStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::CdmContextEvent, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::CdmContextEvent, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::CdmContextEvent>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::MediaLogRecord_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::stable::mojom::MediaLogRecord_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::stable::mojom::MediaLogRecord_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::SubsampleEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::SubsampleEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::SubsampleEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->clear_bytes = Traits::clear_bytes(input);
    fragment->cypher_bytes = Traits::cypher_bytes(input);
  }

  static bool Deserialize(::media::stable::mojom::internal::SubsampleEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::SubsampleEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::DecryptConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::DecryptConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::DecryptConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::media::stable::mojom::EncryptionScheme>(
        Traits::encryption_scheme(input), &fragment->encryption_scheme);
    decltype(Traits::key_id(input)) in_key_id = Traits::key_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_id)::BaseType> key_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_key_id, key_id_fragment);
    fragment->key_id.Set(
        key_id_fragment.is_null() ? nullptr : key_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->key_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_id in DecryptConfig struct");
    decltype(Traits::iv(input)) in_iv = Traits::iv(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->iv)::BaseType> iv_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_iv, iv_fragment);
    fragment->iv.Set(
        iv_fragment.is_null() ? nullptr : iv_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->iv.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null iv in DecryptConfig struct");
    decltype(Traits::subsamples(input)) in_subsamples = Traits::subsamples(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subsamples)::BaseType>
        subsamples_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& subsamples_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::stable::mojom::SubsampleEntryDataView>>(
        in_subsamples, subsamples_fragment, &subsamples_validate_params);
    fragment->subsamples.Set(
        subsamples_fragment.is_null() ? nullptr : subsamples_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->subsamples.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subsamples in DecryptConfig struct");
    decltype(Traits::encryption_pattern(input)) in_encryption_pattern = Traits::encryption_pattern(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->encryption_pattern)::BaseType> encryption_pattern_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::EncryptionPatternDataView>(
        in_encryption_pattern, encryption_pattern_fragment);
    fragment->encryption_pattern.Set(
        encryption_pattern_fragment.is_null() ? nullptr : encryption_pattern_fragment.data());
  }

  static bool Deserialize(::media::stable::mojom::internal::DecryptConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::DecryptConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::ColorVolumeMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::ColorVolumeMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::ColorVolumeMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::primary_r(input)) in_primary_r = Traits::primary_r(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->primary_r)::BaseType> primary_r_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_primary_r, primary_r_fragment);
    fragment->primary_r.Set(
        primary_r_fragment.is_null() ? nullptr : primary_r_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->primary_r.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary_r in ColorVolumeMetadata struct");
    decltype(Traits::primary_g(input)) in_primary_g = Traits::primary_g(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->primary_g)::BaseType> primary_g_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_primary_g, primary_g_fragment);
    fragment->primary_g.Set(
        primary_g_fragment.is_null() ? nullptr : primary_g_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->primary_g.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary_g in ColorVolumeMetadata struct");
    decltype(Traits::primary_b(input)) in_primary_b = Traits::primary_b(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->primary_b)::BaseType> primary_b_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_primary_b, primary_b_fragment);
    fragment->primary_b.Set(
        primary_b_fragment.is_null() ? nullptr : primary_b_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->primary_b.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary_b in ColorVolumeMetadata struct");
    decltype(Traits::white_point(input)) in_white_point = Traits::white_point(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->white_point)::BaseType> white_point_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_white_point, white_point_fragment);
    fragment->white_point.Set(
        white_point_fragment.is_null() ? nullptr : white_point_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->white_point.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null white_point in ColorVolumeMetadata struct");
    fragment->luminance_max = Traits::luminance_max(input);
    fragment->luminance_min = Traits::luminance_min(input);
  }

  static bool Deserialize(::media::stable::mojom::internal::ColorVolumeMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::ColorVolumeMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::HDRMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::HDRMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::HDRMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::color_volume_metadata(input)) in_color_volume_metadata = Traits::color_volume_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_volume_metadata)::BaseType> color_volume_metadata_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::stable::mojom::ColorVolumeMetadataDataView>(
        in_color_volume_metadata, color_volume_metadata_fragment);
    fragment->color_volume_metadata.Set(
        color_volume_metadata_fragment.is_null() ? nullptr : color_volume_metadata_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->color_volume_metadata.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_volume_metadata in HDRMetadata struct");
    fragment->max_content_light_level = Traits::max_content_light_level(input);
    fragment->max_frame_average_light_level = Traits::max_frame_average_light_level(input);
  }

  static bool Deserialize(::media::stable::mojom::internal::HDRMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::HDRMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::VideoDecoderConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::VideoDecoderConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::VideoDecoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::media::stable::mojom::VideoCodec>(
        Traits::codec(input), &fragment->codec);
    mojo::internal::Serialize<::media::stable::mojom::VideoCodecProfile>(
        Traits::profile(input), &fragment->profile);
    fragment->level = Traits::level(input);
    fragment->has_alpha = Traits::has_alpha(input);
    decltype(Traits::coded_size(input)) in_coded_size = Traits::coded_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coded_size)::BaseType> coded_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_coded_size, coded_size_fragment);
    fragment->coded_size.Set(
        coded_size_fragment.is_null() ? nullptr : coded_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->coded_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coded_size in VideoDecoderConfig struct");
    decltype(Traits::visible_rect(input)) in_visible_rect = Traits::visible_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_rect)::BaseType> visible_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_visible_rect, visible_rect_fragment);
    fragment->visible_rect.Set(
        visible_rect_fragment.is_null() ? nullptr : visible_rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->visible_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_rect in VideoDecoderConfig struct");
    decltype(Traits::natural_size(input)) in_natural_size = Traits::natural_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->natural_size)::BaseType> natural_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_natural_size, natural_size_fragment);
    fragment->natural_size.Set(
        natural_size_fragment.is_null() ? nullptr : natural_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->natural_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null natural_size in VideoDecoderConfig struct");
    decltype(Traits::extra_data(input)) in_extra_data = Traits::extra_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extra_data)::BaseType>
        extra_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_extra_data, extra_data_fragment, &extra_data_validate_params);
    fragment->extra_data.Set(
        extra_data_fragment.is_null() ? nullptr : extra_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->extra_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extra_data in VideoDecoderConfig struct");
    mojo::internal::Serialize<::media::stable::mojom::EncryptionScheme>(
        Traits::encryption_scheme(input), &fragment->encryption_scheme);
    decltype(Traits::color_space_info(input)) in_color_space_info = Traits::color_space_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_space_info)::BaseType> color_space_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::stable::mojom::ColorSpaceDataView>(
        in_color_space_info, color_space_info_fragment);
    fragment->color_space_info.Set(
        color_space_info_fragment.is_null() ? nullptr : color_space_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->color_space_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_space_info in VideoDecoderConfig struct");
    decltype(Traits::hdr_metadata(input)) in_hdr_metadata = Traits::hdr_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hdr_metadata)::BaseType> hdr_metadata_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::stable::mojom::HDRMetadataDataView>(
        in_hdr_metadata, hdr_metadata_fragment);
    fragment->hdr_metadata.Set(
        hdr_metadata_fragment.is_null() ? nullptr : hdr_metadata_fragment.data());
  }

  static bool Deserialize(::media::stable::mojom::internal::VideoDecoderConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::VideoDecoderConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::SupportedVideoDecoderConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::SupportedVideoDecoderConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::SupportedVideoDecoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::media::stable::mojom::VideoCodecProfile>(
        Traits::profile_min(input), &fragment->profile_min);
    mojo::internal::Serialize<::media::stable::mojom::VideoCodecProfile>(
        Traits::profile_max(input), &fragment->profile_max);
    decltype(Traits::coded_size_min(input)) in_coded_size_min = Traits::coded_size_min(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coded_size_min)::BaseType> coded_size_min_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_coded_size_min, coded_size_min_fragment);
    fragment->coded_size_min.Set(
        coded_size_min_fragment.is_null() ? nullptr : coded_size_min_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->coded_size_min.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coded_size_min in SupportedVideoDecoderConfig struct");
    decltype(Traits::coded_size_max(input)) in_coded_size_max = Traits::coded_size_max(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coded_size_max)::BaseType> coded_size_max_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_coded_size_max, coded_size_max_fragment);
    fragment->coded_size_max.Set(
        coded_size_max_fragment.is_null() ? nullptr : coded_size_max_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->coded_size_max.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coded_size_max in SupportedVideoDecoderConfig struct");
    fragment->allow_encrypted = Traits::allow_encrypted(input);
    fragment->require_encrypted = Traits::require_encrypted(input);
  }

  static bool Deserialize(::media::stable::mojom::internal::SupportedVideoDecoderConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::SupportedVideoDecoderConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::StatusDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::StatusDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::StatusData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::group(input)) in_group = Traits::group(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group)::BaseType> group_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_group, group_fragment);
    fragment->group.Set(
        group_fragment.is_null() ? nullptr : group_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->group.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null group in StatusData struct");
    mojo::internal::Serialize<::media::stable::mojom::StatusCode>(
        Traits::code(input), &fragment->code);
    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_message, message_fragment);
    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->message.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in StatusData struct");
    decltype(Traits::frames(input)) in_frames = Traits::frames(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frames)::BaseType>
        frames_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& frames_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ValueDataView>>(
        in_frames, frames_fragment, &frames_validate_params);
    fragment->frames.Set(
        frames_fragment.is_null() ? nullptr : frames_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frames.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frames in StatusData struct");
    decltype(Traits::cause(input)) in_cause = Traits::cause(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cause)::BaseType> cause_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::stable::mojom::StatusDataDataView>(
        in_cause, cause_fragment);
    fragment->cause.Set(
        cause_fragment.is_null() ? nullptr : cause_fragment.data());
    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
        in_data, data_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in StatusData struct");
  }

  static bool Deserialize(::media::stable::mojom::internal::StatusData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::StatusDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::StatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::StatusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::Status_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::internal(input)) in_internal = Traits::internal(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->internal)::BaseType> internal_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::stable::mojom::StatusDataDataView>(
        in_internal, internal_fragment);
    fragment->internal.Set(
        internal_fragment.is_null() ? nullptr : internal_fragment.data());
  }

  static bool Deserialize(::media::stable::mojom::internal::Status_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::StatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::DecoderBufferSideDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::DecoderBufferSideDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::DecoderBufferSideData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::spatial_layers(input)) in_spatial_layers = Traits::spatial_layers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->spatial_layers)::BaseType>
        spatial_layers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& spatial_layers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
        in_spatial_layers, spatial_layers_fragment, &spatial_layers_validate_params);
    fragment->spatial_layers.Set(
        spatial_layers_fragment.is_null() ? nullptr : spatial_layers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->spatial_layers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null spatial_layers in DecoderBufferSideData struct");
    decltype(Traits::alpha_data(input)) in_alpha_data = Traits::alpha_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alpha_data)::BaseType>
        alpha_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& alpha_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_alpha_data, alpha_data_fragment, &alpha_data_validate_params);
    fragment->alpha_data.Set(
        alpha_data_fragment.is_null() ? nullptr : alpha_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->alpha_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alpha_data in DecoderBufferSideData struct");
    fragment->secure_handle = Traits::secure_handle(input);
  }

  static bool Deserialize(::media::stable::mojom::internal::DecoderBufferSideData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::DecoderBufferSideDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::DecoderBufferDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::DecoderBufferDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::DecoderBuffer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_timestamp, timestamp_fragment);
    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in DecoderBuffer struct");
    decltype(Traits::duration(input)) in_duration = Traits::duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->duration)::BaseType> duration_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_duration, duration_fragment);
    fragment->duration.Set(
        duration_fragment.is_null() ? nullptr : duration_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->duration.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null duration in DecoderBuffer struct");
    fragment->is_end_of_stream = Traits::is_end_of_stream(input);
    fragment->data_size = Traits::data_size(input);
    fragment->is_key_frame = Traits::is_key_frame(input);
    decltype(Traits::raw_side_data(input)) in_raw_side_data = Traits::raw_side_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raw_side_data)::BaseType>
        raw_side_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& raw_side_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_raw_side_data, raw_side_data_fragment, &raw_side_data_validate_params);
    fragment->raw_side_data.Set(
        raw_side_data_fragment.is_null() ? nullptr : raw_side_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->raw_side_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null raw_side_data in DecoderBuffer struct");
    decltype(Traits::decrypt_config(input)) in_decrypt_config = Traits::decrypt_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->decrypt_config)::BaseType> decrypt_config_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::stable::mojom::DecryptConfigDataView>(
        in_decrypt_config, decrypt_config_fragment);
    fragment->decrypt_config.Set(
        decrypt_config_fragment.is_null() ? nullptr : decrypt_config_fragment.data());
    decltype(Traits::front_discard(input)) in_front_discard = Traits::front_discard(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->front_discard)::BaseType> front_discard_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_front_discard, front_discard_fragment);
    fragment->front_discard.Set(
        front_discard_fragment.is_null() ? nullptr : front_discard_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->front_discard.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null front_discard in DecoderBuffer struct");
    decltype(Traits::back_discard(input)) in_back_discard = Traits::back_discard(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->back_discard)::BaseType> back_discard_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_back_discard, back_discard_fragment);
    fragment->back_discard.Set(
        back_discard_fragment.is_null() ? nullptr : back_discard_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->back_discard.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null back_discard in DecoderBuffer struct");
    decltype(Traits::side_data(input)) in_side_data = Traits::side_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->side_data)::BaseType> side_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::stable::mojom::DecoderBufferSideDataDataView>(
        in_side_data, side_data_fragment);
    fragment->side_data.Set(
        side_data_fragment.is_null() ? nullptr : side_data_fragment.data());
  }

  static bool Deserialize(::media::stable::mojom::internal::DecoderBuffer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::DecoderBufferDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::ColorSpaceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::ColorSpaceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::ColorSpace_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::media::stable::mojom::ColorSpacePrimaryID>(
        Traits::primaries(input), &fragment->primaries);
    mojo::internal::Serialize<::media::stable::mojom::ColorSpaceTransferID>(
        Traits::transfer(input), &fragment->transfer);
    mojo::internal::Serialize<::media::stable::mojom::ColorSpaceMatrixID>(
        Traits::matrix(input), &fragment->matrix);
    mojo::internal::Serialize<::media::stable::mojom::ColorSpaceRangeID>(
        Traits::range(input), &fragment->range);
    decltype(Traits::custom_primary_matrix(input)) in_custom_primary_matrix = Traits::custom_primary_matrix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->custom_primary_matrix)::BaseType>
        custom_primary_matrix_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& custom_primary_matrix_validate_params =
        mojo::internal::GetArrayValidator<9, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_custom_primary_matrix, custom_primary_matrix_fragment, &custom_primary_matrix_validate_params);
    fragment->custom_primary_matrix.Set(
        custom_primary_matrix_fragment.is_null() ? nullptr : custom_primary_matrix_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->custom_primary_matrix.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null custom_primary_matrix in ColorSpace struct");
    decltype(Traits::transfer_params(input)) in_transfer_params = Traits::transfer_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transfer_params)::BaseType>
        transfer_params_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& transfer_params_validate_params =
        mojo::internal::GetArrayValidator<7, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_transfer_params, transfer_params_fragment, &transfer_params_validate_params);
    fragment->transfer_params.Set(
        transfer_params_fragment.is_null() ? nullptr : transfer_params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->transfer_params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transfer_params in ColorSpace struct");
  }

  static bool Deserialize(::media::stable::mojom::internal::ColorSpace_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::ColorSpaceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::NativeGpuMemoryBufferHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::NativeGpuMemoryBufferHandleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::NativeGpuMemoryBufferHandle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in NativeGpuMemoryBufferHandle struct");
    decltype(Traits::platform_handle(input)) in_platform_handle = Traits::platform_handle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->platform_handle)::BaseType> platform_handle_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::stable::mojom::NativePixmapHandleDataView>(
        in_platform_handle, platform_handle_fragment);
    fragment->platform_handle.Set(
        platform_handle_fragment.is_null() ? nullptr : platform_handle_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->platform_handle.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null platform_handle in NativeGpuMemoryBufferHandle struct");
  }

  static bool Deserialize(::media::stable::mojom::internal::NativeGpuMemoryBufferHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::NativeGpuMemoryBufferHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::VideoFrameMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::VideoFrameMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::VideoFrameMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->protected_video = Traits::protected_video(input);
    fragment->hw_protected = Traits::hw_protected(input);
    fragment->needs_detiling = Traits::needs_detiling(input);
  }

  static bool Deserialize(::media::stable::mojom::internal::VideoFrameMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::VideoFrameMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::VideoFrameDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::VideoFrameDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::VideoFrame_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::media::stable::mojom::VideoPixelFormat>(
        Traits::format(input), &fragment->format);
    decltype(Traits::coded_size(input)) in_coded_size = Traits::coded_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coded_size)::BaseType> coded_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_coded_size, coded_size_fragment);
    fragment->coded_size.Set(
        coded_size_fragment.is_null() ? nullptr : coded_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->coded_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coded_size in VideoFrame struct");
    decltype(Traits::visible_rect(input)) in_visible_rect = Traits::visible_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_rect)::BaseType> visible_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_visible_rect, visible_rect_fragment);
    fragment->visible_rect.Set(
        visible_rect_fragment.is_null() ? nullptr : visible_rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->visible_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_rect in VideoFrame struct");
    decltype(Traits::natural_size(input)) in_natural_size = Traits::natural_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->natural_size)::BaseType> natural_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_natural_size, natural_size_fragment);
    fragment->natural_size.Set(
        natural_size_fragment.is_null() ? nullptr : natural_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->natural_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null natural_size in VideoFrame struct");
    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_timestamp, timestamp_fragment);
    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in VideoFrame struct");
    decltype(Traits::gpu_memory_buffer_handle(input)) in_gpu_memory_buffer_handle = Traits::gpu_memory_buffer_handle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gpu_memory_buffer_handle)::BaseType> gpu_memory_buffer_handle_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::stable::mojom::NativeGpuMemoryBufferHandleDataView>(
        in_gpu_memory_buffer_handle, gpu_memory_buffer_handle_fragment);
    fragment->gpu_memory_buffer_handle.Set(
        gpu_memory_buffer_handle_fragment.is_null() ? nullptr : gpu_memory_buffer_handle_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->gpu_memory_buffer_handle.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gpu_memory_buffer_handle in VideoFrame struct");
    decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metadata)::BaseType> metadata_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::stable::mojom::VideoFrameMetadataDataView>(
        in_metadata, metadata_fragment);
    fragment->metadata.Set(
        metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->metadata.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metadata in VideoFrame struct");
    decltype(Traits::color_space(input)) in_color_space = Traits::color_space(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_space)::BaseType> color_space_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::stable::mojom::ColorSpaceDataView>(
        in_color_space, color_space_fragment);
    fragment->color_space.Set(
        color_space_fragment.is_null() ? nullptr : color_space_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->color_space.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_space in VideoFrame struct");
    decltype(Traits::hdr_metadata(input)) in_hdr_metadata = Traits::hdr_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hdr_metadata)::BaseType> hdr_metadata_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::stable::mojom::HDRMetadataDataView>(
        in_hdr_metadata, hdr_metadata_fragment);
    fragment->hdr_metadata.Set(
        hdr_metadata_fragment.is_null() ? nullptr : hdr_metadata_fragment.data());
  }

  static bool Deserialize(::media::stable::mojom::internal::VideoFrame_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::VideoFrameDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::MediaLogRecordDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::MediaLogRecordDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::MediaLogRecord_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    mojo::internal::Serialize<::media::stable::mojom::MediaLogRecord_Type>(
        Traits::type(input), &fragment->type);
    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->params)::BaseType> params_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
        in_params, params_fragment);
    fragment->params.Set(
        params_fragment.is_null() ? nullptr : params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in MediaLogRecord struct");
    decltype(Traits::time(input)) in_time = Traits::time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->time)::BaseType> time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_time, time_fragment);
    fragment->time.Set(
        time_fragment.is_null() ? nullptr : time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time in MediaLogRecord struct");
  }

  static bool Deserialize(::media::stable::mojom::internal::MediaLogRecord_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::MediaLogRecordDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::stable::mojom {



inline void DecryptConfigDataView::GetKeyIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DecryptConfigDataView::GetIvDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->iv.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DecryptConfigDataView::GetSubsamplesDataView(
    mojo::ArrayDataView<SubsampleEntryDataView>* output) {
  auto pointer = data_->subsamples.Get();
  *output = mojo::ArrayDataView<SubsampleEntryDataView>(pointer, message_);
}
inline void DecryptConfigDataView::GetEncryptionPatternDataView(
    ::media::mojom::EncryptionPatternDataView* output) {
  auto pointer = data_->encryption_pattern.Get();
  *output = ::media::mojom::EncryptionPatternDataView(pointer, message_);
}


inline void ColorVolumeMetadataDataView::GetPrimaryRDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->primary_r.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void ColorVolumeMetadataDataView::GetPrimaryGDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->primary_g.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void ColorVolumeMetadataDataView::GetPrimaryBDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->primary_b.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void ColorVolumeMetadataDataView::GetWhitePointDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->white_point.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}


inline void HDRMetadataDataView::GetColorVolumeMetadataDataView(
    ColorVolumeMetadataDataView* output) {
  auto pointer = data_->color_volume_metadata.Get();
  *output = ColorVolumeMetadataDataView(pointer, message_);
}


inline void VideoDecoderConfigDataView::GetCodedSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->coded_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VideoDecoderConfigDataView::GetVisibleRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->visible_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void VideoDecoderConfigDataView::GetNaturalSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->natural_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VideoDecoderConfigDataView::GetExtraDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->extra_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void VideoDecoderConfigDataView::GetColorSpaceInfoDataView(
    ColorSpaceDataView* output) {
  auto pointer = data_->color_space_info.Get();
  *output = ColorSpaceDataView(pointer, message_);
}
inline void VideoDecoderConfigDataView::GetHdrMetadataDataView(
    HDRMetadataDataView* output) {
  auto pointer = data_->hdr_metadata.Get();
  *output = HDRMetadataDataView(pointer, message_);
}


inline void SupportedVideoDecoderConfigDataView::GetCodedSizeMinDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->coded_size_min.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void SupportedVideoDecoderConfigDataView::GetCodedSizeMaxDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->coded_size_max.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void StatusDataDataView::GetGroupDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void StatusDataDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void StatusDataDataView::GetFramesDataView(
    mojo::ArrayDataView<::mojo_base::mojom::ValueDataView>* output) {
  auto pointer = data_->frames.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::ValueDataView>(pointer, message_);
}
inline void StatusDataDataView::GetCauseDataView(
    StatusDataDataView* output) {
  auto pointer = data_->cause.Get();
  *output = StatusDataDataView(pointer, message_);
}
inline void StatusDataDataView::GetDataDataView(
    ::mojo_base::mojom::ValueDataView* output) {
  auto pointer = &data_->data;
  *output = ::mojo_base::mojom::ValueDataView(pointer, message_);
}


inline void StatusDataView::GetInternalDataView(
    StatusDataDataView* output) {
  auto pointer = data_->internal.Get();
  *output = StatusDataDataView(pointer, message_);
}


inline void DecoderBufferSideDataDataView::GetSpatialLayersDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->spatial_layers.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void DecoderBufferSideDataDataView::GetAlphaDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->alpha_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void DecoderBufferDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void DecoderBufferDataView::GetDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void DecoderBufferDataView::GetRawSideDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->raw_side_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void DecoderBufferDataView::GetDecryptConfigDataView(
    DecryptConfigDataView* output) {
  auto pointer = data_->decrypt_config.Get();
  *output = DecryptConfigDataView(pointer, message_);
}
inline void DecoderBufferDataView::GetFrontDiscardDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->front_discard.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void DecoderBufferDataView::GetBackDiscardDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->back_discard.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void DecoderBufferDataView::GetSideDataDataView(
    DecoderBufferSideDataDataView* output) {
  auto pointer = data_->header_.version >= 1
                 ? data_->side_data.Get() : nullptr;
  *output = DecoderBufferSideDataDataView(pointer, message_);
}


inline void ColorSpaceDataView::GetCustomPrimaryMatrixDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->custom_primary_matrix.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void ColorSpaceDataView::GetTransferParamsDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->transfer_params.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}


inline void NativeGpuMemoryBufferHandleDataView::GetIdDataView(
    ::gfx::mojom::GpuMemoryBufferIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::gfx::mojom::GpuMemoryBufferIdDataView(pointer, message_);
}
inline void NativeGpuMemoryBufferHandleDataView::GetPlatformHandleDataView(
    ::media::stable::mojom::NativePixmapHandleDataView* output) {
  auto pointer = data_->platform_handle.Get();
  *output = ::media::stable::mojom::NativePixmapHandleDataView(pointer, message_);
}




inline void VideoFrameDataView::GetCodedSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->coded_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VideoFrameDataView::GetVisibleRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->visible_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void VideoFrameDataView::GetNaturalSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->natural_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VideoFrameDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void VideoFrameDataView::GetGpuMemoryBufferHandleDataView(
    NativeGpuMemoryBufferHandleDataView* output) {
  auto pointer = data_->gpu_memory_buffer_handle.Get();
  *output = NativeGpuMemoryBufferHandleDataView(pointer, message_);
}
inline void VideoFrameDataView::GetMetadataDataView(
    VideoFrameMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = VideoFrameMetadataDataView(pointer, message_);
}
inline void VideoFrameDataView::GetColorSpaceDataView(
    ColorSpaceDataView* output) {
  auto pointer = data_->color_space.Get();
  *output = ColorSpaceDataView(pointer, message_);
}
inline void VideoFrameDataView::GetHdrMetadataDataView(
    HDRMetadataDataView* output) {
  auto pointer = data_->hdr_metadata.Get();
  *output = HDRMetadataDataView(pointer, message_);
}


inline void MediaLogRecordDataView::GetParamsDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, message_);
}
inline void MediaLogRecordDataView::GetTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}



}  // media::stable::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::VideoCodec> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::VideoCodec value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::VideoCodecProfile> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::VideoCodecProfile value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::EncryptionScheme> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::EncryptionScheme value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::StatusCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::StatusCode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::VideoDecoderType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::VideoDecoderType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::ColorSpacePrimaryID> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::ColorSpacePrimaryID value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::ColorSpaceTransferID> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::ColorSpaceTransferID value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::ColorSpaceMatrixID> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::ColorSpaceMatrixID value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::ColorSpaceRangeID> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::ColorSpaceRangeID value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::VideoPixelFormat> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::VideoPixelFormat value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::WaitingReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::WaitingReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::DecryptStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::DecryptStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::CdmContextEvent> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::CdmContextEvent value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::stable::mojom::MediaLogRecord_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::stable::mojom::MediaLogRecord_Type value);
};

} // namespace perfetto

#endif  // MEDIA_MOJO_MOJOM_STABLE_STABLE_VIDEO_DECODER_TYPES_MOJOM_SHARED_H_